#include "Inventory.h"
#ifdef ME_SINGLE

static bool isfinished;

void MTT::precheckOutbound()
{
	int numr = outab.cont.GetCount();
	PromptOK(Format("There are %d rows to precheck", numr));
	prog.Info(statbar);
	prog.Text("Prechecking File:");
	prog.Set(0,numr);

	Thread wrk;
	// "isfinished" flag will let us proceed.
	// From the Upp/Core/Threads, IsOpen() doc:
	// "Note that the thread can be already finished and not running anymore (calling to Wait in
	// that case returns immediately)."
	// However, if we call Wait for an unfinished worker ("Join"), it will block.
	// And we don't want that.
	// Note that this will work only if we'll have a single worker thread.
	
	isfinished = false;	
	wrk.Run([&] {
		for (int i = outab.cont.GetCount() - 1, p = 0;  i >= 0; i--, p++)
		{
			PostCallback([&] {prog.Set(p, numr);}); // the hell??

			LOG(Format("Count: %d, i %d", outab.cont.GetCount(), i));	
			// fetch data from grid
			String typ  = outab.cont(i,0);
			String date = outab.cont(i,1);
			String ordr = outab.cont(i,2);
			String item = outab.cont(i,3);
			double qtty = double(outab.cont(i,4));
			
			int splitpos = item.Find(":");
			if(splitpos > 0 && splitpos < 10)
				item = item.Mid(++splitpos);
		
			Vector<String> mdy = Split(3,date,"/");
			int64 otis = GetUTCSeconds(Time(StrInt(mdy[2]), StrInt(mdy[0]), StrInt(mdy[1])));
			
			if (ToUpper(TrimBoth(item)).StartsWith("SHIPPING"))
			{
				//PostCallback([=] { outab.cont.Remove(i); });
				continue;
			}
			// Sleep to reflect the increased time it takes to do that with a remote MySQL instead
			// of the local sqlite db
			Sleep(50);
			//
			SQL * Select(SqlAll()).From(OUTB).Where(ORDERID == ordr && ITEM == item && DATUM == otis && TYP == typ);
			if(SQL.Fetch())
			{
				if(SQL[QTY] == qtty)
				{
					PostCallback([=] {outab.cont.Remove(i);});
				}
				else
				{
				//	Possible change of quantity
					if(PromptYesNo(Format("Already processed %d of %s, new quantity %d & Do you want to update the Quantity?", SQL[QTY], SQL[ITEM], qtty)))
					{
						int pid = SQL[ID];
						int cqty = SQL[QTY];
						int stockid = SQL[STOCKID];
						int diff = cqty - qtty;
						Sleep(50);
						SQL * SqlUpdate(OUTB)(QTY, qtty).Where(ID == pid);
						
						PromptOK(Format("Stock ( %d ) and outbound ( %d ) table updated!", diff, qtty));
						PostCallback([=] {outab.cont.Remove(i);});
					}
					else
					{
						PromptOK("entry removed");
						PostCallback([=] {outab.cont.Remove(i);});
					}
				}
			}

		}
		isfinished = true;
		PostCallback([&]{ statbar = Null; });
	
	});
	// This is not the proper way to handle a thread.
	// Threads should be asynchronous.
	// Below loop makes it quasi-synchronous.
	// Yet it is ok but only if you are using a single worker thread.
	while(wrk.IsOpen() && !isfinished)
		ProcessEvents();
}

void MTT::processOutbound()
{
	outab.processdb.Disable();
	
	if(~outab.precheck) 
		precheckOutbound();
	
	
	int numr = outab.cont.GetCount();
	PromptOK(Format("There are %d rows to process", numr));
	prog.Info(statbar);
	prog.Text("Processing File:");
	prog.Set(0,numr);
	

	Thread().Run([&] {
	//	for (int i = 0,p=0; i < ; i++,p++)
		for (int i = outab.cont.GetCount() - 1, p = 0;  i >= 0; i--, p++)
		{
			PostCallback([&] {prog.Set(p, outab.cont.GetCount()); }); 
			
			outab.cont.GetRow(i).Bg(Yellow());
			// fetch data from grid
			String typ  = outab.cont(i,0);
			String date = outab.cont(i,1);
			String ordr = outab.cont(i,2);
			String item = outab.cont(i,3);
			double qtty = double(outab.cont(i,4));
			
			int splitpos = item.Find(":");
			if(splitpos > 0 && splitpos < 10)
				item = item.Mid(++splitpos);
		
			Vector<String> mdy = Split(3,date,"/");
			int64 otis = GetUTCSeconds(Time(StrInt(mdy[2]), StrInt(mdy[0]), StrInt(mdy[1])));
					
			splitpos = item.Find("(");
			if(splitpos > 0)
			{
				String sku = TrimBoth(item.Left(splitpos));
				String desc = TrimBoth(item.Mid(splitpos));
			
				desc.TrimStart("(");
				desc.TrimEnd(")");
				
				if(Random()%200 < 100)
				{
					Sleep(50);
					SQL * Insert(OUTB)
						(ORDERID, ordr)
						(STOCKID, 1)
						(SKU, sku)
						(ITEM, item)
						(QTY, qtty)
						(DATUM, otis)
						(TYP, typ);
					
					if(SQL.WasError())
					{
						LOG(Format("############  ERROR\n %s\n for query:\n %s\n\n",SQL.GetLastError(),SQL.GetErrorStatement()));
						SQL.ClearError();
						PostCallback([=] {outab.cont.GetRow(i).Bg(LtRed());});
						continue;
					}
					PostCallback([=] {outab.cont.GetRow(i).Bg(LtGreen());});
				}
				else
				{
					PostCallback([=] {outab.cont.GetRow(i).Bg(LtRed());});
				}
			}
			else
			{
				PostCallback([=] {outab.cont.GetRow(i).Bg(LtRed());});
			}
		}
		PostCallback([=] { statbar = Null; });
	});
	
}
#endif