#include "treetest.h"

class ItemDisplay: public Display {
public:
	int DoPaint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const;
	
	virtual Size GetStdSize(const Value& q) const {
		NilDraw w;
		return Size(DoPaint(w, Rect(0, 0, INT_MAX, INT_MAX), q, Null, Null, 0), StdFont().GetCy());
	}
	
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const {
		DoPaint(w, r, q, ink, paper, style);
	}
};

int ItemDisplay::DoPaint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
{
	Font f = StdFont();
	String s = ValueTo<String>(q);
	w.DrawRect(r, paper);
	w.DrawText(r.left, r.top, s , f, ink);
	
	return GetTextSize(s, f).cx;
}

treetest::treetest()
{
	CtrlLayout(*this, "Window title");
	
	tree.SetRoot(Image(), "test");
	//tree.SetDisplay(Single<ItemDisplay>());
	tree.Add(0, Image(), "aaaaaaaaaaaaaaaa");
	tree.Open(0);
}

GUI_APP_MAIN
{
	treetest().Run();
}
