#include "CtrlLib/CtrlLib.h"

#define LAYOUTFILE <GuiMT/Divisors.lay>
#include <CtrlCore/lay.h>

struct Divisors : public WithDivisorsLayout<TopWindow> {
public:
	typedef Divisors CLASSNAME;
	
	volatile Atomic terminated;
	volatile Atomic threads;

	Divisors();
	~Divisors();

	void TestNumber();
	void ShowResult(int line, String result);
};


struct DivisorsInfo {
	int       line;
	uint64    number;
	Divisors *gui;
	
	bool operator==(const DivisorsInfo&) const { return false; } // To satisfy Callback operator==
};

void WorkerThread(DivisorsInfo f)
{
	String r;
	int divisors = 0;
	uint64 max = (uint64)sqrt((double)f.number) + 1;
	for(uint64 i = 1; i < max; i++) {
		if(AtomicRead(f.gui->terminated))
			break;
		if(f.number % i == 0) {
			r << ' ' << i;
			PostCallback(callback2(f.gui, &Divisors::ShowResult, f.line, "working..." + r));
			divisors++;
		}
	}
	r << ' ' << f.number;
	LOG("Leaving the loop " << divisors);
	PostCallback(callback2(f.gui, &Divisors::ShowResult, f.line, AsString(divisors + 1) + ": " + r));
	AtomicDec(f.gui->threads);
}

void Divisors::TestNumber()
{
	if(IsNull(editor))
		return;
	DivisorsInfo f;
	f.number = stou64((String)~editor);
	f.line = table.GetCount();
	table.Add(AsString(f.number), "working...");
	f.gui = this;
	AtomicInc(threads);
	Thread().Run(callback1(WorkerThread, f));
}

void Divisors::ShowResult(int line, String result)
{
	table.Set(line, 1, result);
}

Divisors::Divisors()
{
	CtrlLayout(*this, "Window title");
	Sizeable().Zoomable();
	push <<= THISBACK(TestNumber);
	editor.SetFilter(CharFilterDigit);
	table.AddColumn("Number");
	table.AddColumn("Divisors");
	table.ColumnWidths("135 527");
	table.NoCursor();
	AtomicWrite(terminated, 0);
	AtomicWrite(threads, 0);
}

Divisors::~Divisors()
{
	AtomicWrite(terminated, 1);
	while(AtomicRead(threads))
		Sleep(10);
}

GUI_APP_MAIN
{
	Divisors().Run();
}
