#include <Core/Core.h>

using namespace Upp;

String t[1100000];
String chnames[1100000];
int uc[1100000];
int lc[1100000];
int tc[1100000];

String abbr[] = { "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Mc", "Me", "Nd", "Nl", "No",
					"Pc", "Pd", "Ps", "Pe", "Pi", "Pf", "Po", "Sm", "Sc", "Sk", "So",
					"Zs", "Zl", "Zp", "Cc", "Cf", "Cs", "Co", "Cn" };

int Conv(const String& s) {
	for (int i = 0; i < __countof(abbr); i++)
		if (abbr[i] == s)
			return i;
}

#undef PLANES

const int BS = 8;
const int PLANES = 3;

word db1[256 * 256];
qword db2[256 * 256];

dword _ToUpper(dword c) {
	dword plane = c >> 16;
	if (plane < PLANES) {
		dword group = c / BS;
		dword offs = c % BS;
		word gdata = db1[group];
		if (gdata & 0x8000) {
			gdata &= 0x7FFF;
			return db2[gdata * BS + offs] & 0x3FFFF;
		}
		else
			return c;
	}
}

dword _ToLower(dword c) {
	dword plane = c >> 16;
	if (plane < PLANES) {
		dword group = c / BS;
		dword offs = c % BS;
		word gdata = db1[group];
		if (gdata & 0x8000) {
			gdata &= 0x7FFF;
			return (db2[gdata * BS + offs] >> 18) & 0x3FFFF;
		}
		else
			return c;
	}
}

dword _ToTitle(dword c) {
	dword plane = c >> 16;
	if (plane < PLANES) {
		dword group = c / BS;
		dword offs = c % BS;
		word gdata = db1[group];
		if (gdata & 0x8000) {
			gdata &= 0x7FFF;
			return (db2[gdata * BS + offs] >> 36) & 0x3FFFF;
		}
		else
			return c;
	}
}

CONSOLE_APP_MAIN {
	String path = GetDataFile("UnicodeData.txt");
	FileIn f(path);
	int lastCp = 0;
	for (int i = 0; i < 1100000; i++)
		t[i] = "Cn";
	String all;
	int max = -1;
	String umin;
	VectorMap<String, int> descs;
	while (!f.IsEof()) {
		String s = f.GetLine();
		Vector<String> v = Split(s, ";", false);
		if (v.GetCount() != 15)
			continue;

		Vector<String> v2 = Split(v[1], " ", false);
		for (int kk = 0; kk < v2.GetCount(); kk++) {
			//if (v2[kk].GetCount() > 1)
				int ii = descs.Find(v2[kk]);
				if (ii == -1)
					descs.Add(v2[kk], 1);
				else {
					int a = descs[ii];
					descs[ii] = a + 1;
				}
				//descs[ii]++;
		}
			//else
			//	descs.FindAdd(v2[kk]);
		int cp = ScanInt(v[0], nullptr, 16);
		chnames[cp] = v[1];
		t[cp] = v[2];
		if (cp == 0x4DB5 || cp == 0x9FD5 || cp == 0xD7A3 || cp == 0xDB7F || cp == 0xDBFF || cp == 0xDFFF || cp == 0xF8FF) {
			LOG(cp);
			for (int i = lastCp; i < cp - 1; i++)
				t[i] = v[2];
		}
		lastCp = cp;
		if (v[12].GetCount()) {
			int p = ScanInt(v[12], nullptr, 16);
			uc[cp] = p;
		}
		if (v[13].GetCount()) {
			int p = ScanInt(v[13], nullptr, 16);
			lc[cp] = p;
		}
		if (v[14].GetCount()) {
			int p = ScanInt(v[14], nullptr, 16);
			tc[cp] = p;
		}
	}

	for (int i = 0; i < 256 * 256 * PLANES; i++) {
		if (uc[i] == 0)
			uc[i] = i;
		if (lc[i] == 0)
			lc[i] = i;
		if (tc[i] == 0)
			tc[i] = i;
		umin << FormatIntHex(i, 6) << ";" << FormatIntHex(uc[i], 6)
			<< ";" << FormatIntHex(lc[i], 6)
			<< ";" << FormatIntHex(tc[i], 6)
			<< ";" << chnames[i] << "\n";
	}
	SaveFile(GetDataFile("UnicodeCaseData.txt"), umin);

	String t1 = "{\n";
	String t2 = "{ ";
	int count = 0, count2 = 0, count3 = 0, count4 = 0;
	int countcase = 0;
	for (int i = 0; i < 256 * 256 * PLANES; i += BS) {
		String a = t[i];
		bool same = a != "Lu" && a != "Ll" && a != "Lt" && (i == uc[i]) && (i == lc[i])&& (i == tc[i]);
		for (int j = i + 1; j < i + BS; j++) {
			if (t[j] != a || t[j] == "Lu" || t[j] == "Ll" || t[j] == "Lt" || j != uc[j] || j != lc[j] || j != tc[j]) {
				same = false;
				break;
			}
		}
		if (same)
			count++;
		if (same) {
			//LOG("0x" + FormatIntHex(i, 6) + " " + a);
			int c = Conv(a);
			if (count4 % 16 == 0)
				t2 << "\n\t\t";
			t2 << "0x" << FormatIntHex(c, 4);
			t2 << ", ";
			db1[i / BS] = c;
			count4++;
		}
		else {
			if (count4 % 16 == 0)
				t2 << "\n\t\t";
			int c = (count3++ | 0x8000);
			t2 << "0x" << FormatIntHex(c, 4);
			t2 << ", ";
			db1[i / BS] = c;

			String s = "0x" + FormatIntHex(i, 6) + " ";
			t1 << "\t\t";
			//t2 << "\t\t\t";
			for (int j = i; j < i + BS; j++) {
				s << t[j] << " ";

				qword cu = (qword)uc[j];
				qword cl = ((qword)lc[j] << 18);
				qword ct = ((qword)tc[j] << (18 + 18));
				qword cc = (qword)Conv(t[j]);
				cc = cc << (64 - 8);
				qword ccc = cu | cl | ct | cc;

				t1 << "0x";
				String zz = Format64Hex(ccc);
				while (zz.GetCount() < 16)
					zz = "0" + zz;
				t1 << zz;
				t1 << "ul";
				t1 << ", ";
				db2[count2++] = ccc;
			}
			t1 << "\n";

			count4++;
			//LOG(s);
		}
	}
	t1 << "\t};";
	t2 << "\n\t};";

	t2 << "\n\n" << t1 << "\n}";
	LOG(IntStr(count) + " " + IntStr(256 * 256 * PLANES / BS));
	LOG(count2);
	LOG(max);
	LOG(countcase);

	DUMP((256 * 256 * PLANES / BS) * 2 + count2 * 8);
	DUMP(descs.GetCount());
	int uq = 0;
	for (int i = 0; i < descs.GetCount(); i++) {
		if (descs[i] > 128) {
			uq++;
			LOG(descs.GetKey(i));
		}
	}
	DUMP(uq);

	max = _ToUpper('A');
	SaveFile(GetDataFile("UnicodeData.out"), t2);

	umin = "";
	for (int i = 0; i < 256 * 256 * PLANES; i++) {
		umin << FormatIntHex(i, 6) << ";" << FormatIntHex(_ToUpper(i), 6)
			<< ";" << FormatIntHex(_ToLower(i), 6)
			<< ";" << FormatIntHex(_ToTitle(i), 6)
			<< ";" << chnames[i] << "\n";
	}
	SaveFile(GetDataFile("UnicodeCaseData2.txt"), umin);
}
