#include "Address.h"

Address::Address() {
    CtrlLayout(*this, "Addresses");     // Non-modal so cannot use Cancel etc...
    Sizeable().Zoomable();

    addressList.AddColumn("Name");
    addressList.AddColumn("Surname");
    addressList.AddColumn("Address");
    addressList.AddColumn("Email");

    for (int j = 0; j < 25; j++) {
        Vector<Value> q;

        for (int i = j; i < j + 4; i++) {
            q.Add(i);
        }

        addressList.Add(q);
    }

    cancel <<= THISBACK(Cancel);        // Non-modal so call the Cancel function declared in the header

    addressList.WhenLeftDouble = THISBACK(ShowInfo);
}

void Address::ShowInfo() {
    PromptOK(String().Cat() << "First Column: " << addressList.Get(0) << ", Second Column: " << addressList.Get(1));
}
