#include "Hello.h"

Hello::Hello() {
    Title("Hello World");
    Sizeable().Zoomable();
    Maximize();
    CenterScreen();
    Icon(HelloImg::appicon());
    AddFrame(menu);
    AddFrame(status);
    menu.Set(THISBACK(MainMenu));
    menu.WhenHelp = status;
    status = "Welcome to the Application";
}

void Hello::About() {
    status = "About the application";
    PromptOK("{{1@5 [@9= This is the]::@2 [A5@0 Ultimate`+`+ Hello world sample}}");
    status = "Ready";
}

void Hello::AddressList() {    
    Addr.IsOpen() ? Addr.Close() : Addr.Open(this); // Non-modal so close using if / else statement
}

void Hello::FileMenu(Bar& bar) {
    bar.Add("&Adress List", THISBACK(AddressList)).Help("Display all addresses");
    bar.Add("About..", THISBACK(About)).Help("About the application");
    bar.Separator();
    bar.Add("E&xit", [=] { Exit(); }).Help("Exit the application");
}

void Hello::MainMenu(Bar& bar) {
    menu.Add("&File", THISBACK(FileMenu));
}

GUI_APP_MAIN {
    SetLanguage(LNG_ENGLISH);
    Hello().Run();
}
