#include <CtrlLib/CtrlLib.h>

#define LAYOUTFILE <BigArray/BigArray.lay>
#include <CtrlCore/lay.h>


class NumberToText : public Convert
{
public:
   Value  Format(const Value& q) const;
   String convert(int number) const;
};

Value NumberToText::Format(const Value &q) const
{
  int number = q;
  if(number == 0)
    return String("zero");
  else
    return convert(number);
}

String NumberToText::convert(int number) const
{
  static const char * const digits[10] =
  { "", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine" };

  static const char * const teens[10] =
  { "ten", "eleven", "twelve", "thirteen", "fourteen",
    "fifteen", "sixteen", "seventeen", "eighteen", "nineteen" };

  static const char * const tenMul[10] =
  { "", "ten", "twenty", "thirty", "fourty", "fifty", "sixty", "seventy", "eighty", "ninety" };

  if(number < 10)
    return digits[number];
  else if(number < 20)
    return teens[ number-10 ];
  else if(number < 100)
    return tenMul[ number/10 ] + String(" ") + convert( number%10 );
  else if(number < 1000)
    return digits[ number/100 ] + String(" hundred ") + convert( number%100 );
  else if(number < 1000000)
    return convert(number/1000) + String(" thousand, ") + convert( number%1000 );
  else
    return "";
}


class BigArray : public WithBigArrayLayout<TopWindow> {
public:
  typedef BigArray CLASSNAME;
  NumberToText numberToText;
  BigArray()
  {
      CtrlLayout(*this, "Window title");
      array.AddRowNumColumn("number");
      array.AddRowNumColumn("text");
      array.HeaderTab(0).SetRatio(20);
      array.HeaderTab(1).SetRatio(80);
      array.ColumnAt(1).SetConvert(numberToText);
      array.SetVirtualCount(900000);
      Zoomable().Sizeable();
  }
};


GUI_APP_MAIN
{
  BigArray().Run();
}

