#include <Core/Core.h>
#include <Work/Work.h>

using namespace Upp;

String GetDivisors()
{
	String s;
	int number = (int) 10000;
	Vector<int> divisors;
	for(auto i = 1, j = 0; i < number + 1; i++) {
		auto d = number % i;
		if(d == 0){
			divisors.Add(i);
			j++;
		}
		if(i == number)
			s = Format("Worker Id: %d, Number: %d, Divisors (count: %d): %s",
						CoWork::GetWorkerIndex(),
						number,
						j,
						divisors.ToString());
	}
	return pick(s);
}

//#define OUTPUT
CONSOLE_APP_MAIN
{
	const int N = 10000;
	Work work;
	Array<WorkResult<String>> workresults;
	
	CoWork cowork;
	Vector<String> results;

#ifdef _DEBUG
	DLOG("Debug Mode");
#else
	RLOG("Release Mode");
#endif
	RDUMP(N);
	RDUMP(CPU_Cores());
	{
#ifdef OUPTUT
		RTIMING("Job -- With output");
#else
		RTIMING("Job -- Without output");
#endif
		for(int i = 0; i < N; i++) {
			workresults.Add() = work.Do([=]{ return  GetDivisors(); });
		}
		work.Finish();
#ifdef OUTPUT
		for(auto& r : workresults)
			Cout() << r.Get() << '\n';
#endif
	}
	{
#ifdef OUPTUT
		RTIMING("CoWork -- With output");
#else
		RTIMING("CoWork -- Without output");
#endif
		for(int i = 0; i < N; i++)
			cowork & [=, &results] { String h = GetDivisors(); CoWork::FinLock(); results.At(i) = h; };
		cowork.Finish();
#ifdef OUTPUT
		for(auto& r : results)
			Cout() << r << '\n';
#endif
	}

//	Error handling, picking/moving.
	auto r1 = work.Do([=] { throw Work::Error("Worker failed."); });
	work.Finish();
	auto r2 = pick(r1); // r1 is picked.
	if(r2.IsError()) {
		Cout() << r2.GetErrorDesc() << '\n';
	}
}
