#ifndef _OrbitFractalv2_OrbitFractalv2_h
#define _OrbitFractalv2_OrbitFractalv2_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <OrbitFractalv2/OrbitFractalv2.lay>
#include <CtrlCore/lay.h>

class OrbitFractalv2 : public WithOrbitFractalv2Layout<TopWindow> {
    Image image;										//Painting target
    ImageDraw iw;										//Painting tool
    Rect rr;                                            //Render rectangle;
    Color penColor;
	Point p;											//Origin coordinate
	int ticks;											//counts Callback calls									
    int counter;                                        //used by render
    int rndrange;                                       //Range of random numbers
    double a, b, c, x, y, xx, yy;                       //Numbers for Martin Attractor

public:
    typedef OrbitFractalv2 CLASSNAME;
    OrbitFractalv2();

    void Paint(Draw& w);
    void BtnNew();
    void BtnStart();
    void BtnStop();
    void BtnClose();
    void Initnumbers();
    double sign (double x);                             //x<0=-1 x>0=1
    void Render();										//The core algorithm
};

#endif
