#include "OrbitFractalv2.h"

OrbitFractalv2::OrbitFractalv2():
    iw(840,940) 											//Todo: sizeable win and ImageDraw size
{
    CtrlLayout(*this, "Martin Attractor");
    btnNew      << [=]  { BtnNew(); };
    btnStart    << [=]  { BtnStart(); };
    btnStop     << [=]  { BtnStop(); };
    btnClose    << [=]  { BtnClose(); };
    btnStop.Enable(false);
    rr=frameRight.GetRect();
    Initnumbers();
}

void OrbitFractalv2::Paint(Draw& w)
{
    rr=frameRight.GetRect();
    w.DrawRect(rr, Black());
    w.DrawImage(rr.left, rr.top, image);
}

void OrbitFractalv2::BtnNew()
{
    btnStop.Enable(true);
    btnStart.Enable(false);
    btnNew.Enable(false);
    Initnumbers();
    iw.DrawRect(0, 0, rr.Width(), rr.Height(), Black());	//Clear the fractal
    image = iw;												//Update Image
    SetTimeCallback(-40, THISBACK(Render), 1);				//Todo:Measuring execution time of Render
}

void OrbitFractalv2::BtnStart()
{
    btnStart.Enable(false);
    btnStop.Enable(true);
    btnNew.Enable(false);
    SetTimeCallback(-40, THISBACK(Render), 1);
}

void OrbitFractalv2::BtnStop()
{
    btnStart.SetLabel(t_("Continue"));
    btnStart.Enable(true);
    btnStop.Enable(false);
    btnNew.Enable(true);
    KillTimeCallback(1);
}

void OrbitFractalv2::BtnClose()
{
    Close();
}

void OrbitFractalv2::Initnumbers()
{
    penColor = Color(Random(255), Random(255), Random(255));
    p=Point(rr.Width() / 2, rr.Height() / 2);				//Origin is middle of Image		
	ticks=0;
    counter=1000;
    rndrange =40;
    a=Randomf()*rndrange;
    b=Randomf()*rndrange;
    c=Randomf()*rndrange;
    x=0, y=0, xx=0, yy=0;
}

double OrbitFractalv2::sign(double x)
{
    if (std::signbit(x))          x = -1.0;
    if ((std::signbit(x))==false) x = 1.0;
    return x;
}

void OrbitFractalv2::Render()
{
/*
Algorithm found here:
http://www.fraktalwelt.de/myhome/simpiter2.htm
Thanks to Ulrich Schwebinghaus
*/
    ticks++;
    if (ticks==3){
        ticks=0;
    	penColor = Color(Random(255), Random(255), Random(255));
    }
    for(int i = 0; i < counter; i++){
        xx = y - (sign(x)) * sqrt(abs(b * x - c));
        yy = a - x;
        x  = xx*2; y  = yy*2;
        x  = xx;   y  = yy;
        iw.DrawEllipse(int(x)+p.x, int(y)+p.y, 1, 1, penColor, Null, penColor);
    }
    image = iw;
    Refresh();
}

GUI_APP_MAIN
{
    OrbitFractalv2().Run();
}