#include "TreeTest.h"



TreeTest::TreeTest()
{
	CtrlLayout(*this, "TreeTest");
	Sizeable();
	
	selected.Columns(1);
	multi.Set(0);
	tree.WhenCursor = THISBACK(OnCursor);	
	tree.WhenSel    = THISBACK(OnSelection);
	multi		  <<= THISBACK(OnMulti);
	int p1 = tree.Add(0, Image(), -1, "Parent 1", true);
	int p2 = tree.Add(0, Image(), -2, "Parent 2", true);
/*	
	TreeCtrl::Node node = tree.GetNode(p2);
	node.CanSelect(false);
	tree.SetNode(p2, node);	
*/	
	String text = "Selectable Node ";
	for (int i = 1; i < 10; i++) {
		int n = tree.Add(p1, Image(), i, text + AsString(i), false);		
	}	
	text = "Non-Selectable Node ";
	for (int i = 10; i < 20; i++) {
		int n = tree.Add(p2, Image(), i, text + AsString(i), false);
		TreeCtrl::Node node = tree.GetNode(n);
		node.CanSelect(false);
		tree.SetNode(n, node);
	}	
	cursor <<= "None";
}

void TreeTest::OnCursor()
{
	int c = tree.GetCursor();
	if (c >= 0)
		cursor <<= tree.GetValue(c);
	else
		cursor <<= "None";
}

void TreeTest::OnSelection()
{
	BeepInformation();
	selected.Clear();
	Vector<int> sel = tree.GetSel();
	for (int i = 0; i < sel.GetCount(); i++)
		selected.Add(tree.GetValue(sel[i]));
}

GUI_APP_MAIN
{
	TreeTest().Run();
}

