#include <Core/Core.h>
#include <plugin/bz2/bz2.h>

using namespace Upp;

CONSOLE_APP_MAIN
{
	enum { BUF_SIZE = 65536 };
	const Vector<String>& cmdline = CommandLine();
	if (cmdline.GetCount() < 2)
		return;
	FileIn in(cmdline[0]);
	FileOut out(cmdline[1]);
#if 0
	bz2::DecompressStream bz2(in);
	char buff[BUF_SIZE];
	while (!bz2.IsEof()) {
		const int n = bz2.Get(buff, BUF_SIZE);
		out.Put(buff, n);
	}
#endif
#if 1
	// Read only a first stream.
	bz2::DecompressStream bz2(in, false);
	char buff[BUF_SIZE];
	while (!bz2.IsEof()) {
		const int n = bz2.Get(buff, BUF_SIZE);
		out.Put(buff, n);
	}
#endif
#if 0
	bz2::CompressStream bz2(out);
	char buff[BUF_SIZE];
	while (!in.IsEof()) {
		const int n = in.Get(buff, BUF_SIZE);
		bz2.Put(buff, n);
	}
#endif
#if 1
	BZ2Decompress(out, in);
#endif
#if 0
	BZ2Compress(out, in);
#endif
}
