#include "ServeurUDP.h"

#pragma comment(lib, "ws2_32.lib")

ServeurUDP::ServeurUDP() {}

ServeurUDP::~ServeurUDP() {}

int ServeurUDP::Demarrage()
{
	struct sockaddr_in si_me, si_other;
    #ifdef _WIN32
    
	SOCKET s;
	int slen , recv_len;
	WSADATA wsa;
	slen = sizeof(si_other) ;
	//Initialise winsock
	printf("\nInitialising Winsock...");
	if (WSAStartup(MAKEWORD(2,2),&wsa) != 0)
	{
		printf( "Impoossible d'initialiser Winsock" );
		return(0);
	}
	printf("Initialised.\n");
	
    #else
    
    int s, i, slen = sizeof(si_other) , recv_len;
    
    #endif
    char buf[BUFLEN];
	
	//Create a socket
	if ((s=socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) == INVALID_SOCKET )
	{
		printf( "Je peux pas creer la socket" );
		return(0);
	}
	printf("Socket created.\n");
	
	#ifndef _WIN32
    memset((char *) &si_me, 0, sizeof(si_me));
    #endif
     
    si_me.sin_family = AF_INET;
    si_me.sin_port = htons(PORT);
    #ifdef _WIN32
    si_me.sin_addr.s_addr = INADDR_ANY;
    #else
    si_me.sin_addr.s_addr = htonl(INADDR_ANY);
	#endif

    //bind socket to port sous linux
    if( bind(s ,(struct sockaddr*)&si_me, sizeof(si_me) ) == SOCKET_ERROR)
    {
        printf( "Je peux pas binder la socket" );
		return(0);
    }
	puts("Bind done");
	
	//keep listening for data
	while(1)
	{
		printf("Waiting for data...");
		fflush(stdout);
		
		//clear the buffer by filling null, it might have previously received data
		memset(buf,'\0', BUFLEN);
		
		//try to receive some data, this is a blocking call
		if ((recv_len = recvfrom(s, buf, BUFLEN, 0, (struct sockaddr *) &si_other, &slen)) == SOCKET_ERROR)
		{
			printf("Probleme reception");
		}
		
		//print details of the client/peer and the data received
		printf("Received packet from %s:%d\n", inet_ntoa(si_other.sin_addr), ntohs(si_other.sin_port));
		printf("Data: %s\n" , buf);

		//now reply the client with the same data
		if (sendto(s, buf, recv_len, 0, (struct sockaddr*) &si_other, slen) == SOCKET_ERROR)
		{
			printf("sendto() failed with error code : %d" , WSAGetLastError());
			exit(EXIT_FAILURE);
		}
	}
	#ifdef _WIN32
    closesocket(s);
	WSACleanup();
    #else
    close(s);
	#endif
}