/// @file xed-encoder-1.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-encoder.h"
#include "xed-encode-private.h"
#include "xed-enc-operand-lu.h"
#include "xed-operand-accessors.h"
xed_uint32_t xed_encode_nonterminal_UISA_ENC_INDEX_ZMM_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t rexx ;xed_int8_t sibindex ;xed_int8_t vexdest4;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(242)=0 INDEX=XED_REG_ZMM0  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0,0},
/*h(243)=1 INDEX=XED_REG_ZMM1  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1,0},
/*h(244)=2 INDEX=XED_REG_ZMM2  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2,0},
/*h(245)=3 INDEX=XED_REG_ZMM3  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3,0},
/*h(246)=4 INDEX=XED_REG_ZMM4  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4,0},
/*h(247)=5 INDEX=XED_REG_ZMM5  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5,0},
/*h(248)=6 INDEX=XED_REG_ZMM6  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6,0},
/*h(249)=7 INDEX=XED_REG_ZMM7  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7,0},
/*h(250)=8 INDEX=XED_REG_ZMM8  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0,0},
/*h(251)=9 INDEX=XED_REG_ZMM9  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1,0},
/*h(252)=10 INDEX=XED_REG_ZMM10  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2,0},
/*h(253)=11 INDEX=XED_REG_ZMM11  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3,0},
/*h(254)=12 INDEX=XED_REG_ZMM12  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4,0},
/*h(255)=13 INDEX=XED_REG_ZMM13  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5,0},
/*h(256)=14 INDEX=XED_REG_ZMM14  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6,0},
/*h(257)=15 INDEX=XED_REG_ZMM15  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7,0},
/*h(258)=16 INDEX=XED_REG_ZMM16  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0,1},
/*h(259)=17 INDEX=XED_REG_ZMM17  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1,1},
/*h(260)=18 INDEX=XED_REG_ZMM18  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2,1},
/*h(261)=19 INDEX=XED_REG_ZMM19  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3,1},
/*h(262)=20 INDEX=XED_REG_ZMM20  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4,1},
/*h(263)=21 INDEX=XED_REG_ZMM21  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5,1},
/*h(264)=22 INDEX=XED_REG_ZMM22  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6,1},
/*h(265)=23 INDEX=XED_REG_ZMM23  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7,1},
/*h(266)=24 INDEX=XED_REG_ZMM24  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0,1},
/*h(267)=25 INDEX=XED_REG_ZMM25  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1,1},
/*h(268)=26 INDEX=XED_REG_ZMM26  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2,1},
/*h(269)=27 INDEX=XED_REG_ZMM27  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3,1},
/*h(270)=28 INDEX=XED_REG_ZMM28  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4,1},
/*h(271)=29 INDEX=XED_REG_ZMM29  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5,1},
/*h(272)=30 INDEX=XED_REG_ZMM30  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6,1},
/*h(273)=31 INDEX=XED_REG_ZMM31  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_INDEX(xes);
hidx = key - 242;
if(hidx <= 31) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    xed3_operand_set_vexdest4(xes,lu_table[hidx].vexdest4);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_FIXUP_SMODE_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error ;xed_int8_t smode;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(2)=0 MODE=2 SMODE=0  ->	FB SMODE=2 value=0x2*/ {2, -1,2},
/*h(6)=1 MODE=2 SMODE=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {6, XED_ERROR_GENERAL_ERROR,-1}
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_SMODE(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-1));
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    if(lu_table[hidx].smode >= 0) xed3_operand_set_smode(xes,lu_table[hidx].smode);
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_FORCE64_BIND(xed_encoder_request_t* xes)
{
xed3_operand_set_df64(xes,1);
xed3_operand_set_eosz(xes,3);
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GSCAT_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t seg_ovd;} lu_entry_t;
static const lu_entry_t lu_table[14] = {
/*h(0)=0 DEFAULT_SEG=0 SEG0=@  ->	FB SEG_OVD=0 value=0x0*/ {0, 0},
/*h(601)=1 DEFAULT_SEG=1 SEG0=XED_REG_SS  ->	FB SEG_OVD=0 value=0x0*/ {601, 0},
/*h(604)=2 DEFAULT_SEG=0 SEG0=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4*/ {604, 4},
/*h(593)=3 DEFAULT_SEG=1 SEG0=XED_REG_DS  ->	FB SEG_OVD=2 value=0x2*/ {593, 2},
/*h(596)=4 DEFAULT_SEG=0 SEG0=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3*/ {596, 3},
/*h(1)=5 DEFAULT_SEG=1 SEG0=@  ->	FB SEG_OVD=0 value=0x0*/ {1, 0},
/*h(588)=6 DEFAULT_SEG=0 SEG0=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1*/ {588, 1},
/*h(605)=7 DEFAULT_SEG=1 SEG0=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4*/ {605, 4},
/*h(608)=8 DEFAULT_SEG=0 SEG0=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5*/ {608, 5},
/*h(597)=9 DEFAULT_SEG=1 SEG0=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3*/ {597, 3},
/*h(600)=10 DEFAULT_SEG=0 SEG0=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6*/ {600, 6},
/*h(589)=11 DEFAULT_SEG=1 SEG0=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1*/ {589, 1},
/*h(592)=12 DEFAULT_SEG=0 SEG0=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0*/ {592, 0},
/*h(609)=13 DEFAULT_SEG=1 SEG0=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5*/ {609, 5}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DEFAULT_SEG_SEG0(xes);
hidx = ((5*key % 163) % 14);
if(lu_table[hidx].key == key) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    return 1;
}
else{
    xed3_operand_set_seg_ovd(xes,0);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_RM_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*empty slot1 */ {0,0},
/*h(2)=1 EASZ=2 SIB=0  ->	nt NT[MODRM_RM_ENCODE_EA32_SIB0]*/ {2, xed_encode_nonterminal_MODRM_RM_ENCODE_EA32_SIB0_BIND},
/*h(7)=2 EASZ!=1 SIB=1  ->	nt NT[MODRM_RM_ENCODE_EANOT16_SIB1]*/ {7, xed_encode_nonterminal_MODRM_RM_ENCODE_EANOT16_SIB1_BIND},
/*h(4)=3 EASZ!=1 SIB=1  ->	nt NT[MODRM_RM_ENCODE_EANOT16_SIB1]*/ {4, xed_encode_nonterminal_MODRM_RM_ENCODE_EANOT16_SIB1_BIND},
/*h(1)=4 EASZ=1 SIB=0  ->	nt NT[MODRM_RM_ENCODE_EA16_SIB0]*/ {1, xed_encode_nonterminal_MODRM_RM_ENCODE_EA16_SIB0_BIND},
/*h(6)=5 EASZ!=1 SIB=1  ->	nt NT[MODRM_RM_ENCODE_EANOT16_SIB1]*/ {6, xed_encode_nonterminal_MODRM_RM_ENCODE_EANOT16_SIB1_BIND},
/*h(3)=6 EASZ=3 SIB=0  ->	nt NT[MODRM_RM_ENCODE_EA64_SIB0]*/ {3, xed_encode_nonterminal_MODRM_RM_ENCODE_EA64_SIB0_BIND},
/*empty slot1 */ {0,0}
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_EASZ_SIB(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-3));
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_READER_SUBDWORD_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_ERROR_BIND(xed_encoder_request_t* xes)
{
xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_32_BIND(xed_encoder_request_t* xes)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 32;
if(hidx == 0) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_UPP_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 VEX_PREFIX=0  ->	emit 0b100 emit_type=numeric value=0x4 nbits=3*/ {1},
/*h(1)=1 VEX_PREFIX=1  ->	emit 0b101 emit_type=numeric value=0x5 nbits=3*/ {2},
/*h(2)=2 VEX_PREFIX=2  ->	emit 0b111 emit_type=numeric value=0x7 nbits=3*/ {3},
/*h(3)=3 VEX_PREFIX=3  ->	emit 0b110 emit_type=numeric value=0x6 nbits=3*/ {4}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_VEX_PREFIX(xes);
hidx = key - 0;
if(hidx <= 3) {
    xed_encoder_request_iforms(xes)->x_EVEX_UPP_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_MAP_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 MAP=0  ->	emit 0b0000 emit_type=numeric value=0x0 nbits=4*/ {1},
/*h(1)=1 MAP=1  ->	emit 0b0001 emit_type=numeric value=0x1 nbits=4*/ {2},
/*h(2)=2 MAP=2  ->	emit 0b0010 emit_type=numeric value=0x2 nbits=4*/ {3},
/*h(3)=3 MAP=3  ->	emit 0b0011 emit_type=numeric value=0x3 nbits=4*/ {4}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MAP(xes);
hidx = key - 0;
if(hidx <= 3) {
    xed_encoder_request_iforms(xes)->x_EVEX_MAP_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_FULLMEM_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_ESIZE_1_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_SUBDWORD_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_SE_IMM8_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(0)=0 DUMMY=0 ESRC[ssss]=* UIMM0[dddd]=*  ->	emit ssss_dddd emit_type=letters nbits=8*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DUMMY(xes);
hidx = key - 0;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_SE_IMM8=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA16_DISP8_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(37)=0 BASE0=XED_REG_BX INDEX=@  ->	FB MOD=1 value=0x1*/ {37, 1},
/*h(21029)=1 BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB MOD=1 value=0x1*/ {21029, 1},
/*h(20517)=2 BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB MOD=1 value=0x1*/ {20517, 1},
/*h(39)=3 BASE0=XED_REG_BP INDEX=@  ->	FB MOD=1 value=0x1*/ {39, 1},
/*h(21031)=4 BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB MOD=1 value=0x1*/ {21031, 1},
/*h(20519)=5 BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB MOD=1 value=0x1*/ {20519, 1},
/*h(41)=6 BASE0=XED_REG_DI INDEX=@  ->	FB MOD=1 value=0x1*/ {41, 1},
/*h(40)=7 BASE0=XED_REG_SI INDEX=@  ->	FB MOD=1 value=0x1*/ {40, 1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0_INDEX(xes);
hidx = ((20*key % 37) % 8);
if(lu_table[hidx].key == key) {
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_BND_B_CHECK_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t error;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(0)=0 REXB=0 RM=0x0  ->	nothing*/ {-1},
/*h(1)=1 REXB=1 RM=0x0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(2)=2 REXB=0 RM=0x1  ->	nothing*/ {-1},
/*h(3)=3 REXB=1 RM=0x1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(4)=4 REXB=0 RM=0x2  ->	nothing*/ {-1},
/*h(5)=5 REXB=1 RM=0x2  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(6)=6 REXB=0 RM=0x3  ->	nothing*/ {-1},
/*h(7)=7 REXB=1 RM=0x3  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(8)=8 REXB=0 RM=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(9)=9 REXB=1 RM=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(10)=10 REXB=0 RM=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(11)=11 REXB=1 RM=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(12)=12 REXB=0 RM=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(13)=13 REXB=1 RM=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(14)=14 REXB=0 RM=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(15)=15 REXB=1 RM=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_REXB_RM(xes);
hidx = key - 0;
if(hidx <= 15) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_XOP_MAP_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(8)=0 MAP=8 REXW[w]=*  ->	emit 0b0_1000 emit_type=numeric value=0x8 nbits=5 	emit w emit_type=letters nbits=1*/ {1},
/*h(9)=1 MAP=9 REXW[w]=*  ->	emit 0b0_1001 emit_type=numeric value=0x9 nbits=5 	emit w emit_type=letters nbits=1*/ {2},
/*h(10)=2 MAP=10 REXW[w]=*  ->	emit 0b0_1010 emit_type=numeric value=0xa nbits=5 	emit w emit_type=letters nbits=1*/ {3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MAP(xes);
hidx = key - 8;
if(hidx <= 2) {
    xed_encoder_request_iforms(xes)->x_XOP_MAP_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE1_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[15] = {
/*h(264)=0 EASZ=2 DISP_WIDTH=8  ->	nt NT[MODRM_MOD_EA32_DISP8]*/ {264, xed_encode_nonterminal_MODRM_MOD_EA32_DISP8_BIND},
/*h(416)=1 EASZ=3 DISP_WIDTH=32  ->	nt NT[MODRM_MOD_EA64_DISP32]*/ {416, xed_encode_nonterminal_MODRM_MOD_EA64_DISP32_BIND},
/*h(144)=2 EASZ=1 DISP_WIDTH=16  ->	nt NT[MODRM_MOD_EA16_DISP16]*/ {144, xed_encode_nonterminal_MODRM_MOD_EA16_DISP16_BIND},
/*h(256)=3 EASZ=2 DISP_WIDTH=0  ->	nt NT[MODRM_MOD_EA32_DISP0]*/ {256, xed_encode_nonterminal_MODRM_MOD_EA32_DISP0_BIND},
/*h(448)=4 EASZ=3 DISP_WIDTH=64  ->	nt NT[ERROR]*/ {448, xed_encode_nonterminal_ERROR_BIND},
/*h(136)=5 EASZ=1 DISP_WIDTH=8  ->	nt NT[MODRM_MOD_EA16_DISP8]*/ {136, xed_encode_nonterminal_MODRM_MOD_EA16_DISP8_BIND},
/*h(288)=6 EASZ=2 DISP_WIDTH=32  ->	nt NT[MODRM_MOD_EA32_DISP32]*/ {288, xed_encode_nonterminal_MODRM_MOD_EA32_DISP32_BIND},
/*h(400)=7 EASZ=3 DISP_WIDTH=16  ->	nt NT[ERROR]*/ {400, xed_encode_nonterminal_ERROR_BIND},
/*h(128)=8 EASZ=1 DISP_WIDTH=0  ->	nt NT[MODRM_MOD_EA16_DISP0]*/ {128, xed_encode_nonterminal_MODRM_MOD_EA16_DISP0_BIND},
/*h(320)=9 EASZ=2 DISP_WIDTH=64  ->	nt NT[ERROR]*/ {320, xed_encode_nonterminal_ERROR_BIND},
/*h(392)=10 EASZ=3 DISP_WIDTH=8  ->	nt NT[MODRM_MOD_EA64_DISP8]*/ {392, xed_encode_nonterminal_MODRM_MOD_EA64_DISP8_BIND},
/*h(160)=11 EASZ=1 DISP_WIDTH=32  ->	nt NT[ERROR]*/ {160, xed_encode_nonterminal_ERROR_BIND},
/*h(272)=12 EASZ=2 DISP_WIDTH=16  ->	nt NT[ERROR]*/ {272, xed_encode_nonterminal_ERROR_BIND},
/*h(384)=13 EASZ=3 DISP_WIDTH=0  ->	nt NT[MODRM_MOD_EA64_DISP0]*/ {384, xed_encode_nonterminal_MODRM_MOD_EA64_DISP0_BIND},
/*h(192)=14 EASZ=1 DISP_WIDTH=64  ->	nt NT[ERROR]*/ {192, xed_encode_nonterminal_ERROR_BIND}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_DISP_WIDTH_EASZ(xes);
hidx = ((5*key % 43) % 15);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_MODRM_MOD_ENCODE=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_MEM128_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t error;} lu_entry_t;
static const lu_entry_t lu_table[31] = {
/*h(1)=0 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(2)=1 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(3)=2 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(4)=3 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(5)=4 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(6)=5 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(7)=6 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(8)=7 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(9)=8 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(10)=9 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(11)=10 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(12)=11 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(13)=12 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(14)=13 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(15)=14 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(16)=15 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(17)=16 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(18)=17 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(19)=18 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(20)=19 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(21)=20 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(22)=21 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(23)=22 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(24)=23 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(25)=24 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(26)=25 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(27)=26 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(28)=27 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(29)=28 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(30)=29 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(31)=30 BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BCAST(xes);
hidx = key - 1;
if(hidx <= 30) {
    xed3_operand_set_error(xes,lu_table[hidx].error);
    return 1;
}
else{
    xed3_operand_set_bcrc(xes,0);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_D_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_VSIB_ENC_BASE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t sibbase ;xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[104] = {
/*h(0)=0 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {0, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(548)=3 BASE0=XED_REG_DX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=2 value=0x2*/ {548, 0,2,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(549)=7 BASE0=XED_REG_BX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=3 value=0x3*/ {549, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(550)=11 BASE0=XED_REG_SP EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=4 value=0x4*/ {550, 0,4,0},
/*h(1024)=12 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {1024, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(1074)=13 BASE0=XED_REG_EAX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=0 value=0x0*/ {1074, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(551)=15 BASE0=XED_REG_BP EASZ=1  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {551, 0,5,xed_encode_nonterminal_DISP_WIDTH_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1075)=17 BASE0=XED_REG_ECX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=1 value=0x1*/ {1075, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(552)=19 BASE0=XED_REG_SI EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=6 value=0x6*/ {552, 0,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(1076)=21 BASE0=XED_REG_EDX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=2 value=0x2*/ {1076, 0,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(553)=23 BASE0=XED_REG_DI EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=7 value=0x7*/ {553, 0,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(1077)=25 BASE0=XED_REG_EBX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=3 value=0x3*/ {1077, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(554)=27 BASE0=XED_REG_R8W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=0 value=0x0*/ {554, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1078)=29 BASE0=XED_REG_ESP EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=4 value=0x4*/ {1078, 0,4,0},
/*empty slot1 */ {0,0,0,0},
/*h(555)=31 BASE0=XED_REG_R9W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=1 value=0x1*/ {555, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(1079)=33 BASE0=XED_REG_EBP EASZ=2  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {1079, 0,5,xed_encode_nonterminal_DISP_WIDTH_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(556)=35 BASE0=XED_REG_R10W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=2 value=0x2*/ {556, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(1080)=37 BASE0=XED_REG_ESI EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=6 value=0x6*/ {1080, 0,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(557)=39 BASE0=XED_REG_R11W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=3 value=0x3*/ {557, 1,3,0},
/*h(1602)=40 BASE0=XED_REG_RAX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=0 value=0x0*/ {1602, 0,0,0},
/*h(1081)=41 BASE0=XED_REG_EDI EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=7 value=0x7*/ {1081, 0,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(558)=43 BASE0=XED_REG_R12W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=4 value=0x4*/ {558, 1,4,0},
/*h(1603)=44 BASE0=XED_REG_RCX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=1 value=0x1*/ {1603, 0,1,0},
/*h(1082)=45 BASE0=XED_REG_R8D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=0 value=0x0*/ {1082, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(559)=47 BASE0=XED_REG_R13W EASZ=1  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=1 value=0x1 	FB SIBBASE=5 value=0x5*/ {559, 1,5,xed_encode_nonterminal_DISP_WIDTH_8_32_BIND},
/*h(1604)=48 BASE0=XED_REG_RDX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=2 value=0x2*/ {1604, 0,2,0},
/*h(1083)=49 BASE0=XED_REG_R9D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=1 value=0x1*/ {1083, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(560)=51 BASE0=XED_REG_R14W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=6 value=0x6*/ {560, 1,6,0},
/*h(1605)=52 BASE0=XED_REG_RBX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=3 value=0x3*/ {1605, 0,3,0},
/*h(1084)=53 BASE0=XED_REG_R10D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=2 value=0x2*/ {1084, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(561)=55 BASE0=XED_REG_R15W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=7 value=0x7*/ {561, 1,7,0},
/*h(1606)=56 BASE0=XED_REG_RSP EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=4 value=0x4*/ {1606, 0,4,0},
/*h(1085)=57 BASE0=XED_REG_R11D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=3 value=0x3*/ {1085, 1,3,0},
/*h(512)=58 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {512, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1607)=60 BASE0=XED_REG_RBP EASZ=3  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {1607, 0,5,xed_encode_nonterminal_DISP_WIDTH_8_32_BIND},
/*h(1086)=61 BASE0=XED_REG_R12D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=4 value=0x4*/ {1086, 1,4,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1608)=64 BASE0=XED_REG_RSI EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=6 value=0x6*/ {1608, 0,6,0},
/*h(1087)=65 BASE0=XED_REG_R13D EASZ=2  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=1 value=0x1 	FB SIBBASE=5 value=0x5*/ {1087, 1,5,xed_encode_nonterminal_DISP_WIDTH_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1609)=68 BASE0=XED_REG_RDI EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=7 value=0x7*/ {1609, 0,7,0},
/*h(1088)=69 BASE0=XED_REG_R14D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=6 value=0x6*/ {1088, 1,6,0},
/*h(1536)=70 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5*/ {1536, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1610)=72 BASE0=XED_REG_R8 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=0 value=0x0*/ {1610, 1,0,0},
/*h(1089)=73 BASE0=XED_REG_R15D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=7 value=0x7*/ {1089, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1611)=76 BASE0=XED_REG_R9 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=1 value=0x1*/ {1611, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1612)=80 BASE0=XED_REG_R10 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=2 value=0x2*/ {1612, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1613)=84 BASE0=XED_REG_R11 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=3 value=0x3*/ {1613, 1,3,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1614)=88 BASE0=XED_REG_R12 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=4 value=0x4*/ {1614, 1,4,0},
/*empty slot1 */ {0,0,0,0},
/*h(546)=90 BASE0=XED_REG_AX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=0 value=0x0*/ {546, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1615)=92 BASE0=XED_REG_R13 EASZ=3  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=1 value=0x1 	FB SIBBASE=5 value=0x5*/ {1615, 1,5,xed_encode_nonterminal_DISP_WIDTH_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(547)=94 BASE0=XED_REG_CX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=1 value=0x1*/ {547, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(1616)=96 BASE0=XED_REG_R14 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=6 value=0x6*/ {1616, 1,6,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1617)=100 BASE0=XED_REG_R15 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=7 value=0x7*/ {1617, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_BASE0_EASZ(xes);
hidx = ((4*key % 199) % 104);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_sibbase(xes,lu_table[hidx].sibbase);
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_VSIB_ENC_BASE=hidx+1;
    return res;
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_WORD_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_ESIZE_16_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_SIMM8_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t imm0signed ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(8)=0 IMM_WIDTH=8 UIMM0[iiiiiiii]=*  ->	emit uimm0=iiiiiiii emit_type=letters nbits=8 	FB IMM0SIGNED=1 value=0x1*/ {1,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_IMM_WIDTH(xes);
hidx = key - 8;
if(hidx == 0) {
    xed3_operand_set_imm0signed(xes,lu_table[hidx].imm0signed);
    xed_encoder_request_iforms(xes)->x_SIMM8=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MEMDISPv_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(448)=0 DISP_WIDTH=64 EASZ=3 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=64*/ {448, 1},
/*h(288)=1 DISP_WIDTH=32 EASZ=2 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=32*/ {288, 2},
/*h(144)=2 DISP_WIDTH=16 EASZ=1 DISP[aaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaa emit_type=letters nbits=16*/ {144, 3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH_EASZ(xes);
hidx = ((4*key % 7) % 3);
if(lu_table[hidx].key == key) {
    xed_encoder_request_iforms(xes)->x_MEMDISPv=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MEMDISP8_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(8)=0 DISP_WIDTH=8 DISP[aaaaaaaa]=*  ->	emit disp=aaaaaaaa emit_type=letters nbits=8*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 8;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_MEMDISP8=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_UIMM8_1_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(0)=0 DUMMY=0 UIMM1[iiiiiiii]=*  ->	emit uimm1=iiiiiiii emit_type=letters nbits=8*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DUMMY(xes);
hidx = key - 0;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_UIMM8_1=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MEMDISP_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t need_memdisp ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 DISP_WIDTH=0  ->	FB NEED_MEMDISP=0 value=0x0*/ {0, 0,0},
/*h(16)=1 DISP_WIDTH=16 DISP[aaaaaaaaaaaaaaaa]=*  ->	FB NEED_MEMDISP=16 value=0x10 	emit disp=aaaaaaaaaaaaaaaa emit_type=letters nbits=16*/ {16, 16,2},
/*h(32)=2 DISP_WIDTH=32 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	FB NEED_MEMDISP=32 value=0x20 	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=32*/ {32, 32,3},
/*h(8)=3 DISP_WIDTH=8 DISP[aaaaaaaa]=*  ->	FB NEED_MEMDISP=8 value=0x8 	emit disp=aaaaaaaa emit_type=letters nbits=8*/ {8, 8,4}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = ((6*key % 5) % 4);
if(lu_table[hidx].key == key) {
    xed3_operand_set_need_memdisp(xes,lu_table[hidx].need_memdisp);
    xed_encoder_request_iforms(xes)->x_MEMDISP=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_BRDISP32_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(32)=0 BRDISP_WIDTH=32 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit disp=dddddddddddddddddddddddddddddddd emit_type=letters nbits=32*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BRDISP_WIDTH(xes);
hidx = key - 32;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_BRDISP32=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MEMDISP32_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(32)=0 DISP_WIDTH=32 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=32*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 32;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_MEMDISP32=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MEMDISP16_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(16)=0 DISP_WIDTH=16 DISP[aaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaa emit_type=letters nbits=16*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 16;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_MEMDISP16=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_UIMM32_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(32)=0 IMM_WIDTH=32 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_IMM_WIDTH(xes);
hidx = key - 32;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_UIMM32=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ONE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(648)=0 IMM_WIDTH=8 UIMM0=1 MODE=1  ->	nothing*/ {648, },
/*h(520)=1 IMM_WIDTH=8 UIMM0=1 MODE=0  ->	nothing*/ {520, },
/*h(776)=2 IMM_WIDTH=8 UIMM0=1 MODE=2  ->	nothing*/ {776, }
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_IMM_WIDTH_MODE_UIMM0_1(xes);
hidx = (4*key % 3);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_SIMMz_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t imm0signed ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(65)=0 IMM_WIDTH=16 EOSZ=1 UIMM0[iiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiii emit_type=letters nbits=16 	FB IMM0SIGNED=1 value=0x1*/ {65, 1,1},
/*h(130)=1 IMM_WIDTH=32 EOSZ=2 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32 	FB IMM0SIGNED=1 value=0x1*/ {130, 1,2},
/*h(131)=2 IMM_WIDTH=32 EOSZ=3 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32 	FB IMM0SIGNED=1 value=0x1*/ {131, 1,3}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_EOSZ_IMM_WIDTH(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_imm0signed(xes,lu_table[hidx].imm0signed);
    xed_encoder_request_iforms(xes)->x_SIMMz=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ASZ_NONTERM_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t asz;} lu_entry_t;
static const lu_entry_t lu_table[9] = {
/*h(5)=0 EASZ=1 MODE=1  ->	FB ASZ=1 value=0x1*/ {5, 1},
/*h(10)=1 EASZ=2 MODE=2  ->	FB ASZ=1 value=0x1*/ {10, 1},
/*h(2)=2 EASZ=2 MODE=0  ->	FB ASZ=1 value=0x1*/ {2, 1},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1)=5 EASZ=1 MODE=0  ->	FB ASZ=0 value=0x0*/ {1, 0},
/*h(6)=6 EASZ=2 MODE=1  ->	FB ASZ=0 value=0x0*/ {6, 0},
/*h(11)=7 EASZ=3 MODE=2  ->	FB ASZ=0 value=0x0*/ {11, 0},
/*empty slot1 */ {0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_EASZ_MODE(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 9ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_asz(xes,lu_table[hidx].asz);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_UIMMv_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(259)=0 IMM_WIDTH=64 EOSZ=3 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=64*/ {259, 1},
/*h(65)=1 IMM_WIDTH=16 EOSZ=1 UIMM0[iiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiii emit_type=letters nbits=16*/ {65, 2},
/*h(130)=2 IMM_WIDTH=32 EOSZ=2 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32*/ {130, 3},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_EOSZ_IMM_WIDTH(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed_encoder_request_iforms(xes)->x_UIMMv=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_UIMM16_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(16)=0 IMM_WIDTH=16 UIMM0[iiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiii emit_type=letters nbits=16*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_IMM_WIDTH(xes);
hidx = key - 16;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_UIMM16=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_BRDISPz_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(224)=0 BRDISP_WIDTH=32 EOSZ=3 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit disp=dddddddddddddddddddddddddddddddd emit_type=letters nbits=32*/ {224, 1},
/*h(160)=1 BRDISP_WIDTH=32 EOSZ=2 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit disp=dddddddddddddddddddddddddddddddd emit_type=letters nbits=32*/ {160, 2},
/*h(80)=2 BRDISP_WIDTH=16 EOSZ=1 DISP[dddddddddddddddd]=*  ->	emit disp=dddddddddddddddd emit_type=letters nbits=16*/ {80, 3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BRDISP_WIDTH_EOSZ(xes);
hidx = ((3*key % 7) % 3);
if(lu_table[hidx].key == key) {
    xed_encoder_request_iforms(xes)->x_BRDISPz=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_UIMM8_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(8)=0 IMM_WIDTH=8 UIMM0[iiiiiiii]=*  ->	emit uimm0=iiiiiiii emit_type=letters nbits=8*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_IMM_WIDTH(xes);
hidx = key - 8;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_UIMM8=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_BRDISP8_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(8)=0 BRDISP_WIDTH=8 DISP[dddddddd]=*  ->	emit disp=dddddddd emit_type=letters nbits=8*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BRDISP_WIDTH(xes);
hidx = key - 8;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_BRDISP8=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASKNOT0(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t mask;} lu_entry_t;
static const lu_entry_t lu_table[10] = {
/*h(102)=0 OUTREG=XED_REG_ERROR  ->	FB MASK=0 value=0x0*/ {102, 0},
/*h(107)=1 OUTREG=XED_REG_K1  ->	FB MASK=1 value=0x1*/ {107, 1},
/*h(112)=2 OUTREG=XED_REG_K6  ->	FB MASK=6 value=0x6*/ {112, 6},
/*h(109)=3 OUTREG=XED_REG_K3  ->	FB MASK=3 value=0x3*/ {109, 3},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(111)=6 OUTREG=XED_REG_K5  ->	FB MASK=5 value=0x5*/ {111, 5},
/*h(108)=7 OUTREG=XED_REG_K2  ->	FB MASK=2 value=0x2*/ {108, 2},
/*h(113)=8 OUTREG=XED_REG_K7  ->	FB MASK=7 value=0x7*/ {113, 7},
/*h(110)=9 OUTREG=XED_REG_K4  ->	FB MASK=4 value=0x4*/ {110, 4}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 10ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_mask(xes,lu_table[hidx].mask);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_R3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr ;xed_int8_t rexrr;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,0},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,0},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,0},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,0},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,0},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,0},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,0},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1,0},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1,0},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1,0},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1,0},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1,0},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1,0},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1,0},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1,0},
/*h(194)=16 OUTREG=XED_REG_XMM16  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,1},
/*h(195)=17 OUTREG=XED_REG_XMM17  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,1},
/*h(196)=18 OUTREG=XED_REG_XMM18  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,1},
/*h(197)=19 OUTREG=XED_REG_XMM19  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,1},
/*h(198)=20 OUTREG=XED_REG_XMM20  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,1},
/*h(199)=21 OUTREG=XED_REG_XMM21  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,1},
/*h(200)=22 OUTREG=XED_REG_XMM22  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,1},
/*h(201)=23 OUTREG=XED_REG_XMM23  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,1},
/*h(202)=24 OUTREG=XED_REG_XMM24  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1,1},
/*h(203)=25 OUTREG=XED_REG_XMM25  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1,1},
/*h(204)=26 OUTREG=XED_REG_XMM26  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1,1},
/*h(205)=27 OUTREG=XED_REG_XMM27  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1,1},
/*h(206)=28 OUTREG=XED_REG_XMM28  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1,1},
/*h(207)=29 OUTREG=XED_REG_XMM29  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1,1},
/*h(208)=30 OUTREG=XED_REG_XMM30  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1,1},
/*h(209)=31 OUTREG=XED_REG_XMM31  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 31) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    xed3_operand_set_rexrr(xes,lu_table[hidx].rexrr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_B_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB RM=0 value=0x0*/ {0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB RM=1 value=0x1*/ {1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB RM=2 value=0x2*/ {2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB RM=3 value=0x3*/ {3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB RM=4 value=0x4*/ {4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB RM=5 value=0x5*/ {5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB RM=6 value=0x6*/ {6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_DSEG_MODE64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t seg_ovd ;xed_int8_t using_default_segment0;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 OUTREG=XED_REG_INVALID  ->	FB SEG_OVD=0 value=0x0 	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {0, 0,1},
/*h(151)=1 OUTREG=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {151, 4,0},
/*empty slot1 */ {0,0,0},
/*h(152)=3 OUTREG=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {152, 5,0}
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    xed3_operand_set_using_default_segment0(xes,lu_table[hidx].using_default_segment0);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_OeAX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*empty slot1 */ {0},
/*h(203)=1 OUTREG=XED_REG_EAX EOSZ=3  ->	nothing*/ {203, },
/*h(137)=2 OUTREG=XED_REG_AX EOSZ=1  ->	nothing*/ {137, },
/*h(202)=3 OUTREG=XED_REG_EAX EOSZ=2  ->	nothing*/ {202, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_B3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rexx ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0,0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,0,1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,0,2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,0,3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,0,4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,0,5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,0,6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,0,7},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0,0},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,0,1},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,0,2},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,0,3},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,0,4},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,0,5},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,0,6},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,0,7},
/*h(226)=16 OUTREG=XED_REG_YMM16  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,1,0},
/*h(227)=17 OUTREG=XED_REG_YMM17  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1,1},
/*h(228)=18 OUTREG=XED_REG_YMM18  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,1,2},
/*h(229)=19 OUTREG=XED_REG_YMM19  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,1,3},
/*h(230)=20 OUTREG=XED_REG_YMM20  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,1,4},
/*h(231)=21 OUTREG=XED_REG_YMM21  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,1,5},
/*h(232)=22 OUTREG=XED_REG_YMM22  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,1,6},
/*h(233)=23 OUTREG=XED_REG_YMM23  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,1,7},
/*h(234)=24 OUTREG=XED_REG_YMM24  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,1,0},
/*h(235)=25 OUTREG=XED_REG_YMM25  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1,1},
/*h(236)=26 OUTREG=XED_REG_YMM26  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,1,2},
/*h(237)=27 OUTREG=XED_REG_YMM27  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,1,3},
/*h(238)=28 OUTREG=XED_REG_YMM28  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,1,4},
/*h(239)=29 OUTREG=XED_REG_YMM29  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,1,5},
/*h(240)=30 OUTREG=XED_REG_YMM30  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,1,6},
/*h(241)=31 OUTREG=XED_REG_YMM31  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 31) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_N_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_B3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(242)=0 OUTREG=XED_REG_ZMM0  ->	FB RM=0 value=0x0*/ {0},
/*h(243)=1 OUTREG=XED_REG_ZMM1  ->	FB RM=1 value=0x1*/ {1},
/*h(244)=2 OUTREG=XED_REG_ZMM2  ->	FB RM=2 value=0x2*/ {2},
/*h(245)=3 OUTREG=XED_REG_ZMM3  ->	FB RM=3 value=0x3*/ {3},
/*h(246)=4 OUTREG=XED_REG_ZMM4  ->	FB RM=4 value=0x4*/ {4},
/*h(247)=5 OUTREG=XED_REG_ZMM5  ->	FB RM=5 value=0x5*/ {5},
/*h(248)=6 OUTREG=XED_REG_ZMM6  ->	FB RM=6 value=0x6*/ {6},
/*h(249)=7 OUTREG=XED_REG_ZMM7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 242;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_SSEG0(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t using_default_segment0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(2)=0 OUTREG=XED_REG_INVALID MODE=2  ->	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {2, 1},
/*h(601)=1 OUTREG=XED_REG_SS MODE=1  ->	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {601, 1},
/*h(600)=2 OUTREG=XED_REG_SS MODE=0  ->	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {600, 1}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_using_default_segment0(xes,lu_table[hidx].using_default_segment0);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_SSEG1(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t using_default_segment1;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(2)=0 OUTREG=XED_REG_INVALID MODE=2  ->	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {2, 1},
/*h(601)=1 OUTREG=XED_REG_SS MODE=1  ->	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {601, 1},
/*h(600)=2 OUTREG=XED_REG_SS MODE=0  ->	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {600, 1}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_using_default_segment1(xes,lu_table[hidx].using_default_segment1);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPRy_N(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_VGPR32_N},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_VGPR32_N},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_VGPR64_N}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR8_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t needrex ;xed_int8_t norex ;xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[20] = {
/*h(82)=0 OUTREG=XED_REG_AL  ->	FB REG=0 value=0x0*/ {-1,-1,0,-1},
/*h(83)=1 OUTREG=XED_REG_CL  ->	FB REG=1 value=0x1*/ {-1,-1,1,-1},
/*h(84)=2 OUTREG=XED_REG_DL  ->	FB REG=2 value=0x2*/ {-1,-1,2,-1},
/*h(85)=3 OUTREG=XED_REG_BL  ->	FB REG=3 value=0x3*/ {-1,-1,3,-1},
/*h(86)=4 OUTREG=XED_REG_SPL  ->	FB REG=4 value=0x4 	FB NEEDREX=1 value=0x1*/ {1,-1,4,-1},
/*h(87)=5 OUTREG=XED_REG_BPL  ->	FB REG=5 value=0x5 	FB NEEDREX=1 value=0x1*/ {1,-1,5,-1},
/*h(88)=6 OUTREG=XED_REG_SIL  ->	FB REG=6 value=0x6 	FB NEEDREX=1 value=0x1*/ {1,-1,6,-1},
/*h(89)=7 OUTREG=XED_REG_DIL  ->	FB REG=7 value=0x7 	FB NEEDREX=1 value=0x1*/ {1,-1,7,-1},
/*h(90)=8 OUTREG=XED_REG_R8B  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {-1,-1,0,1},
/*h(91)=9 OUTREG=XED_REG_R9B  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {-1,-1,1,1},
/*h(92)=10 OUTREG=XED_REG_R10B  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {-1,-1,2,1},
/*h(93)=11 OUTREG=XED_REG_R11B  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {-1,-1,3,1},
/*h(94)=12 OUTREG=XED_REG_R12B  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {-1,-1,4,1},
/*h(95)=13 OUTREG=XED_REG_R13B  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {-1,-1,5,1},
/*h(96)=14 OUTREG=XED_REG_R14B  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {-1,-1,6,1},
/*h(97)=15 OUTREG=XED_REG_R15B  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {-1,-1,7,1},
/*h(98)=16 OUTREG=XED_REG_AH  ->	FB REG=4 value=0x4 	FB NOREX=1 value=0x1*/ {-1,1,4,-1},
/*h(99)=17 OUTREG=XED_REG_CH  ->	FB REG=5 value=0x5 	FB NOREX=1 value=0x1*/ {-1,1,5,-1},
/*h(100)=18 OUTREG=XED_REG_DH  ->	FB REG=6 value=0x6 	FB NOREX=1 value=0x1*/ {-1,1,6,-1},
/*h(101)=19 OUTREG=XED_REG_BH  ->	FB REG=7 value=0x7 	FB NOREX=1 value=0x1*/ {-1,1,7,-1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 82;
if(hidx <= 19) {
    if(lu_table[hidx].needrex >= 0) xed3_operand_set_needrex(xes,lu_table[hidx].needrex);
    if(lu_table[hidx].norex >= 0) xed3_operand_set_norex(xes,lu_table[hidx].norex);
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    if(lu_table[hidx].rexr >= 0) xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar8(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*empty slot1 */ {0},
/*h(169)=1 OUTREG=XED_REG_R8W EASZ=1  ->	nothing*/ {169, },
/*h(234)=2 OUTREG=XED_REG_R8D EASZ=2  ->	nothing*/ {234, },
/*h(299)=3 OUTREG=XED_REG_R8 EASZ=3  ->	nothing*/ {299, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar9(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(238)=0 OUTREG=XED_REG_R9D EASZ=2  ->	nothing*/ {238, },
/*h(303)=1 OUTREG=XED_REG_R9 EASZ=3  ->	nothing*/ {303, },
/*empty slot1 */ {0},
/*h(173)=3 OUTREG=XED_REG_R9W EASZ=1  ->	nothing*/ {173, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR8_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t needrex ;xed_int8_t norex ;xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[20] = {
/*h(82)=0 OUTREG=XED_REG_AL  ->	FB RM=0 value=0x0*/ {-1,-1,-1,0},
/*h(83)=1 OUTREG=XED_REG_CL  ->	FB RM=1 value=0x1*/ {-1,-1,-1,1},
/*h(84)=2 OUTREG=XED_REG_DL  ->	FB RM=2 value=0x2*/ {-1,-1,-1,2},
/*h(85)=3 OUTREG=XED_REG_BL  ->	FB RM=3 value=0x3*/ {-1,-1,-1,3},
/*h(86)=4 OUTREG=XED_REG_SPL  ->	FB RM=4 value=0x4 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,4},
/*h(87)=5 OUTREG=XED_REG_BPL  ->	FB RM=5 value=0x5 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,5},
/*h(88)=6 OUTREG=XED_REG_SIL  ->	FB RM=6 value=0x6 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,6},
/*h(89)=7 OUTREG=XED_REG_DIL  ->	FB RM=7 value=0x7 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,7},
/*h(90)=8 OUTREG=XED_REG_R8B  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {-1,-1,1,0},
/*h(91)=9 OUTREG=XED_REG_R9B  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {-1,-1,1,1},
/*h(92)=10 OUTREG=XED_REG_R10B  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {-1,-1,1,2},
/*h(93)=11 OUTREG=XED_REG_R11B  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {-1,-1,1,3},
/*h(94)=12 OUTREG=XED_REG_R12B  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {-1,-1,1,4},
/*h(95)=13 OUTREG=XED_REG_R13B  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {-1,-1,1,5},
/*h(96)=14 OUTREG=XED_REG_R14B  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {-1,-1,1,6},
/*h(97)=15 OUTREG=XED_REG_R15B  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {-1,-1,1,7},
/*h(98)=16 OUTREG=XED_REG_AH  ->	FB RM=4 value=0x4 	FB NOREX=1 value=0x1*/ {-1,1,-1,4},
/*h(99)=17 OUTREG=XED_REG_CH  ->	FB RM=5 value=0x5 	FB NOREX=1 value=0x1*/ {-1,1,-1,5},
/*h(100)=18 OUTREG=XED_REG_DH  ->	FB RM=6 value=0x6 	FB NOREX=1 value=0x1*/ {-1,1,-1,6},
/*h(101)=19 OUTREG=XED_REG_BH  ->	FB RM=7 value=0x7 	FB NOREX=1 value=0x1*/ {-1,1,-1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 82;
if(hidx <= 19) {
    if(lu_table[hidx].needrex >= 0) xed3_operand_set_needrex(xes,lu_table[hidx].needrex);
    if(lu_table[hidx].norex >= 0) xed3_operand_set_norex(xes,lu_table[hidx].norex);
    if(lu_table[hidx].rexb >= 0) xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_SEGe(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 147;
if(hidx <= 5) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_B_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_B_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_B_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_N(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_N_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_N_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_N_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_N3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_ZMM_N3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_ZMM_N3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_ZMM_N3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_R_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_R_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_R_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_OrDX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(145)=3 OUTREG=XED_REG_DX EOSZ=1  ->	nothing*/ {145, },
/*h(210)=4 OUTREG=XED_REG_EDX EOSZ=2  ->	nothing*/ {210, },
/*h(275)=5 OUTREG=XED_REG_RDX EOSZ=3  ->	nothing*/ {275, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_N3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3 ;xed_int8_t vexdest4;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1,0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1,0},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1,0},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1,0},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1,0},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1,0},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1,0},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1,0},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0,0},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0,0},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0,0},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0,0},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0,0},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0,0},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0,0},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0,0},
/*h(194)=16 OUTREG=XED_REG_XMM16  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1,1},
/*h(195)=17 OUTREG=XED_REG_XMM17  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1,1},
/*h(196)=18 OUTREG=XED_REG_XMM18  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1,1},
/*h(197)=19 OUTREG=XED_REG_XMM19  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1,1},
/*h(198)=20 OUTREG=XED_REG_XMM20  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1,1},
/*h(199)=21 OUTREG=XED_REG_XMM21  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1,1},
/*h(200)=22 OUTREG=XED_REG_XMM22  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1,1},
/*h(201)=23 OUTREG=XED_REG_XMM23  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1,1},
/*h(202)=24 OUTREG=XED_REG_XMM24  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0,1},
/*h(203)=25 OUTREG=XED_REG_XMM25  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0,1},
/*h(204)=26 OUTREG=XED_REG_XMM26  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0,1},
/*h(205)=27 OUTREG=XED_REG_XMM27  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0,1},
/*h(206)=28 OUTREG=XED_REG_XMM28  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0,1},
/*h(207)=29 OUTREG=XED_REG_XMM29  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0,1},
/*h(208)=30 OUTREG=XED_REG_XMM30  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0,1},
/*h(209)=31 OUTREG=XED_REG_XMM31  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 31) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    xed3_operand_set_vexdest4(xes,lu_table[hidx].vexdest4);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_B_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB RM=0 value=0x0*/ {0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB RM=1 value=0x1*/ {1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB RM=2 value=0x2*/ {2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB RM=3 value=0x3*/ {3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB RM=4 value=0x4*/ {4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB RM=5 value=0x5*/ {5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB RM=6 value=0x6*/ {6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRy_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR32_R},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_R},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR64_R}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_B3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rexx ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0,0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,0,1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,0,2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,0,3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,0,4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,0,5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,0,6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,0,7},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0,0},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,0,1},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,0,2},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,0,3},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,0,4},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,0,5},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,0,6},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,0,7},
/*h(194)=16 OUTREG=XED_REG_XMM16  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,1,0},
/*h(195)=17 OUTREG=XED_REG_XMM17  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1,1},
/*h(196)=18 OUTREG=XED_REG_XMM18  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,1,2},
/*h(197)=19 OUTREG=XED_REG_XMM19  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,1,3},
/*h(198)=20 OUTREG=XED_REG_XMM20  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,1,4},
/*h(199)=21 OUTREG=XED_REG_XMM21  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,1,5},
/*h(200)=22 OUTREG=XED_REG_XMM22  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,1,6},
/*h(201)=23 OUTREG=XED_REG_XMM23  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,1,7},
/*h(202)=24 OUTREG=XED_REG_XMM24  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,1,0},
/*h(203)=25 OUTREG=XED_REG_XMM25  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1,1},
/*h(204)=26 OUTREG=XED_REG_XMM26  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,1,2},
/*h(205)=27 OUTREG=XED_REG_XMM27  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,1,3},
/*h(206)=28 OUTREG=XED_REG_XMM28  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,1,4},
/*h(207)=29 OUTREG=XED_REG_XMM29  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,1,5},
/*h(208)=30 OUTREG=XED_REG_XMM30  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,1,6},
/*h(209)=31 OUTREG=XED_REG_XMM31  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 31) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32e_m64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_SE(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_SE32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_SE32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_SE64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_SSEG_NOT64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t seg_ovd ;xed_int8_t using_default_segment0;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(147)=0 OUTREG=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {1,0},
/*h(148)=1 OUTREG=XED_REG_DS  ->	FB SEG_OVD=2 value=0x2 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {2,0},
/*h(149)=2 OUTREG=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {3,0},
/*h(150)=3 OUTREG=XED_REG_SS  ->	FB SEG_OVD=0 value=0x0 	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {0,1},
/*h(151)=4 OUTREG=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {4,0},
/*h(152)=5 OUTREG=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {5,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 147;
if(hidx <= 5) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    xed3_operand_set_using_default_segment0(xes,lu_table[hidx].using_default_segment0);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_OrAX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(267)=0 OUTREG=XED_REG_RAX EOSZ=3  ->	nothing*/ {267, },
/*empty slot1 */ {0},
/*h(137)=2 OUTREG=XED_REG_AX EOSZ=1  ->	nothing*/ {137, },
/*h(202)=3 OUTREG=XED_REG_EAX EOSZ=2  ->	nothing*/ {202, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR16_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(34)=0 OUTREG=XED_REG_AX  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(35)=1 OUTREG=XED_REG_CX  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(36)=2 OUTREG=XED_REG_DX  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(37)=3 OUTREG=XED_REG_BX  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(38)=4 OUTREG=XED_REG_SP  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(39)=5 OUTREG=XED_REG_BP  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(40)=6 OUTREG=XED_REG_SI  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(41)=7 OUTREG=XED_REG_DI  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(42)=8 OUTREG=XED_REG_R8W  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(43)=9 OUTREG=XED_REG_R9W  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(44)=10 OUTREG=XED_REG_R10W  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(45)=11 OUTREG=XED_REG_R11W  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(46)=12 OUTREG=XED_REG_R12W  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(47)=13 OUTREG=XED_REG_R13W  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(48)=14 OUTREG=XED_REG_R14W  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(49)=15 OUTREG=XED_REG_R15W  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 34;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRz_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR16_B},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_B},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR32_B}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArSI(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(161)=2 OUTREG=XED_REG_SI EASZ=1  ->	nothing*/ {161, },
/*h(226)=3 OUTREG=XED_REG_ESI EASZ=2  ->	nothing*/ {226, },
/*h(291)=4 OUTREG=XED_REG_RSI EASZ=3  ->	nothing*/ {291, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArSP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(153)=2 OUTREG=XED_REG_SP EASZ=1  ->	nothing*/ {153, },
/*h(218)=3 OUTREG=XED_REG_ESP EASZ=2  ->	nothing*/ {218, },
/*h(283)=4 OUTREG=XED_REG_RSP EASZ=3  ->	nothing*/ {283, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_N3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(242)=0 OUTREG=XED_REG_ZMM0  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(243)=1 OUTREG=XED_REG_ZMM1  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(244)=2 OUTREG=XED_REG_ZMM2  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(245)=3 OUTREG=XED_REG_ZMM3  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(246)=4 OUTREG=XED_REG_ZMM4  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(247)=5 OUTREG=XED_REG_ZMM5  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(248)=6 OUTREG=XED_REG_ZMM6  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(249)=7 OUTREG=XED_REG_ZMM7  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 242;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArDX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(145)=3 OUTREG=XED_REG_DX EASZ=1  ->	nothing*/ {145, },
/*h(210)=4 OUTREG=XED_REG_EDX EASZ=2  ->	nothing*/ {210, },
/*h(275)=5 OUTREG=XED_REG_RDX EASZ=3  ->	nothing*/ {275, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_VGPR32_R_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_VGPR32_R_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_VGPR32_R_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRz_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR16_R},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_R},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR32_R}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_R3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr ;xed_int8_t rexrr;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,0},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,0},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,0},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,0},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,0},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,0},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,0},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1,0},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1,0},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1,0},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1,0},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1,0},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1,0},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1,0},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1,0},
/*h(226)=16 OUTREG=XED_REG_YMM16  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,1},
/*h(227)=17 OUTREG=XED_REG_YMM17  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,1},
/*h(228)=18 OUTREG=XED_REG_YMM18  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,1},
/*h(229)=19 OUTREG=XED_REG_YMM19  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,1},
/*h(230)=20 OUTREG=XED_REG_YMM20  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,1},
/*h(231)=21 OUTREG=XED_REG_YMM21  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,1},
/*h(232)=22 OUTREG=XED_REG_YMM22  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,1},
/*h(233)=23 OUTREG=XED_REG_YMM23  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,1},
/*h(234)=24 OUTREG=XED_REG_YMM24  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1,1},
/*h(235)=25 OUTREG=XED_REG_YMM25  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1,1},
/*h(236)=26 OUTREG=XED_REG_YMM26  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1,1},
/*h(237)=27 OUTREG=XED_REG_YMM27  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1,1},
/*h(238)=28 OUTREG=XED_REG_YMM28  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1,1},
/*h(239)=29 OUTREG=XED_REG_YMM29  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1,1},
/*h(240)=30 OUTREG=XED_REG_YMM30  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1,1},
/*h(241)=31 OUTREG=XED_REG_YMM31  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 31) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    xed3_operand_set_rexrr(xes,lu_table[hidx].rexrr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_R_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArCX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(141)=0 OUTREG=XED_REG_CX EASZ=1  ->	nothing*/ {141, },
/*h(206)=1 OUTREG=XED_REG_ECX EASZ=2  ->	nothing*/ {206, },
/*h(271)=2 OUTREG=XED_REG_RCX EASZ=3  ->	nothing*/ {271, },
/*empty slot1 */ {0},
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_B3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_B3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_B3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_B3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_N_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_R3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_R3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_R3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_R3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_N3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3 ;xed_int8_t vexdest4;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1,0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1,0},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1,0},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1,0},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1,0},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1,0},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1,0},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1,0},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0,0},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0,0},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0,0},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0,0},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0,0},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0,0},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0,0},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0,0},
/*h(226)=16 OUTREG=XED_REG_YMM16  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1,1},
/*h(227)=17 OUTREG=XED_REG_YMM17  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1,1},
/*h(228)=18 OUTREG=XED_REG_YMM18  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1,1},
/*h(229)=19 OUTREG=XED_REG_YMM19  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1,1},
/*h(230)=20 OUTREG=XED_REG_YMM20  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1,1},
/*h(231)=21 OUTREG=XED_REG_YMM21  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1,1},
/*h(232)=22 OUTREG=XED_REG_YMM22  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1,1},
/*h(233)=23 OUTREG=XED_REG_YMM23  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1,1},
/*h(234)=24 OUTREG=XED_REG_YMM24  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0,1},
/*h(235)=25 OUTREG=XED_REG_YMM25  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0,1},
/*h(236)=26 OUTREG=XED_REG_YMM26  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0,1},
/*h(237)=27 OUTREG=XED_REG_YMM27  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0,1},
/*h(238)=28 OUTREG=XED_REG_YMM28  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0,1},
/*h(239)=29 OUTREG=XED_REG_YMM29  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0,1},
/*h(240)=30 OUTREG=XED_REG_YMM30  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0,1},
/*h(241)=31 OUTREG=XED_REG_YMM31  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 31) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    xed3_operand_set_vexdest4(xes,lu_table[hidx].vexdest4);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_DSEG1_MODE64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t seg_ovd ;xed_int8_t using_default_segment1;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 OUTREG=XED_REG_INVALID  ->	FB SEG_OVD=0 value=0x0 	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {0, 0,1},
/*h(151)=1 OUTREG=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {151, 4,0},
/*empty slot1 */ {0,0,0},
/*h(152)=3 OUTREG=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {152, 5,0}
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    xed3_operand_set_using_default_segment1(xes,lu_table[hidx].using_default_segment1);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_N(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_N_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_N_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_N_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_rIPa(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(418)=0 OUTREG=XED_REG_EIP EASZ=2  ->	nothing*/ {418, },
/*h(415)=1 OUTREG=XED_REG_RIP EASZ=3  ->	nothing*/ {415, }
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (3*key % 2);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_N_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1},
/*h(58)=8 OUTREG=XED_REG_R8D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0},
/*h(60)=10 OUTREG=XED_REG_R10D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0},
/*h(61)=11 OUTREG=XED_REG_R11D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0},
/*h(62)=12 OUTREG=XED_REG_R12D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0},
/*h(63)=13 OUTREG=XED_REG_R13D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0},
/*h(64)=14 OUTREG=XED_REG_R14D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0},
/*h(65)=15 OUTREG=XED_REG_R15D  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRm_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_GPR32_R},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_GPR32_R},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_GPR64_R}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR64_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 OUTREG=XED_REG_RAX  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(67)=1 OUTREG=XED_REG_RCX  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(68)=2 OUTREG=XED_REG_RDX  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(69)=3 OUTREG=XED_REG_RBX  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(70)=4 OUTREG=XED_REG_RSP  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(71)=5 OUTREG=XED_REG_RBP  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(73)=7 OUTREG=XED_REG_RDI  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(74)=8 OUTREG=XED_REG_R8  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(75)=9 OUTREG=XED_REG_R9  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(76)=10 OUTREG=XED_REG_R10  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(77)=11 OUTREG=XED_REG_R11  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(78)=12 OUTREG=XED_REG_R12  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(79)=13 OUTREG=XED_REG_R13  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(81)=15 OUTREG=XED_REG_R15  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_SE(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_SE32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_SE32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_SE64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_B_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_B_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_B_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_R_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32e_m32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 7) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_SE64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t esrc;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB ESRC=0 value=0x0*/ {0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB ESRC=1 value=0x1*/ {1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB ESRC=2 value=0x2*/ {2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB ESRC=3 value=0x3*/ {3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB ESRC=4 value=0x4*/ {4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB ESRC=5 value=0x5*/ {5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB ESRC=6 value=0x6*/ {6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB ESRC=7 value=0x7*/ {7},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB ESRC=8 value=0x8*/ {8},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB ESRC=9 value=0x9*/ {9},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB ESRC=10 value=0xa*/ {10},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB ESRC=11 value=0xb*/ {11},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB ESRC=12 value=0xc*/ {12},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB ESRC=13 value=0xd*/ {13},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB ESRC=14 value=0xe*/ {14},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB ESRC=15 value=0xf*/ {15}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 15) {
    xed3_operand_set_esrc(xes,lu_table[hidx].esrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar12(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*empty slot1 */ {0},
/*h(185)=1 OUTREG=XED_REG_R12W EASZ=1  ->	nothing*/ {185, },
/*h(250)=2 OUTREG=XED_REG_R12D EASZ=2  ->	nothing*/ {250, },
/*h(315)=3 OUTREG=XED_REG_R12 EASZ=3  ->	nothing*/ {315, },
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar13(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(319)=0 OUTREG=XED_REG_R13 EASZ=3  ->	nothing*/ {319, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(189)=4 OUTREG=XED_REG_R13W EASZ=1  ->	nothing*/ {189, },
/*h(254)=5 OUTREG=XED_REG_R13D EASZ=2  ->	nothing*/ {254, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_B_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar11(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(246)=0 OUTREG=XED_REG_R11D EASZ=2  ->	nothing*/ {246, },
/*h(311)=1 OUTREG=XED_REG_R11 EASZ=3  ->	nothing*/ {311, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(181)=4 OUTREG=XED_REG_R11W EASZ=1  ->	nothing*/ {181, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_N_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 15) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar14(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*empty slot1 */ {0},
/*h(193)=1 OUTREG=XED_REG_R14W EASZ=1  ->	nothing*/ {193, },
/*h(258)=2 OUTREG=XED_REG_R14D EASZ=2  ->	nothing*/ {258, },
/*h(323)=3 OUTREG=XED_REG_R14 EASZ=3  ->	nothing*/ {323, },
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar15(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(327)=0 OUTREG=XED_REG_R15 EASZ=3  ->	nothing*/ {327, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(197)=3 OUTREG=XED_REG_R15W EASZ=1  ->	nothing*/ {197, },
/*h(262)=4 OUTREG=XED_REG_R15D EASZ=2  ->	nothing*/ {262, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR64_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 OUTREG=XED_REG_RAX  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(67)=1 OUTREG=XED_REG_RCX  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(68)=2 OUTREG=XED_REG_RDX  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(69)=3 OUTREG=XED_REG_RBX  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(70)=4 OUTREG=XED_REG_RSP  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(71)=5 OUTREG=XED_REG_RBP  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(73)=7 OUTREG=XED_REG_RDI  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(74)=8 OUTREG=XED_REG_R8  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(75)=9 OUTREG=XED_REG_R9  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(76)=10 OUTREG=XED_REG_R10  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(77)=11 OUTREG=XED_REG_R11  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(78)=12 OUTREG=XED_REG_R12  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(79)=13 OUTREG=XED_REG_R13  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(81)=15 OUTREG=XED_REG_R15  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_R_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_R_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_R_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR64_SB(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t srm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 OUTREG=XED_REG_RAX  ->	FB REXB=0 value=0x0 	FB SRM=0 value=0x0*/ {0,0},
/*h(67)=1 OUTREG=XED_REG_RCX  ->	FB REXB=0 value=0x0 	FB SRM=1 value=0x1*/ {0,1},
/*h(68)=2 OUTREG=XED_REG_RDX  ->	FB REXB=0 value=0x0 	FB SRM=2 value=0x2*/ {0,2},
/*h(69)=3 OUTREG=XED_REG_RBX  ->	FB REXB=0 value=0x0 	FB SRM=3 value=0x3*/ {0,3},
/*h(70)=4 OUTREG=XED_REG_RSP  ->	FB REXB=0 value=0x0 	FB SRM=4 value=0x4*/ {0,4},
/*h(71)=5 OUTREG=XED_REG_RBP  ->	FB REXB=0 value=0x0 	FB SRM=5 value=0x5*/ {0,5},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB REXB=0 value=0x0 	FB SRM=6 value=0x6*/ {0,6},
/*h(73)=7 OUTREG=XED_REG_RDI  ->	FB REXB=0 value=0x0 	FB SRM=7 value=0x7*/ {0,7},
/*h(74)=8 OUTREG=XED_REG_R8  ->	FB REXB=1 value=0x1 	FB SRM=0 value=0x0*/ {1,0},
/*h(75)=9 OUTREG=XED_REG_R9  ->	FB REXB=1 value=0x1 	FB SRM=1 value=0x1*/ {1,1},
/*h(76)=10 OUTREG=XED_REG_R10  ->	FB REXB=1 value=0x1 	FB SRM=2 value=0x2*/ {1,2},
/*h(77)=11 OUTREG=XED_REG_R11  ->	FB REXB=1 value=0x1 	FB SRM=3 value=0x3*/ {1,3},
/*h(78)=12 OUTREG=XED_REG_R12  ->	FB REXB=1 value=0x1 	FB SRM=4 value=0x4*/ {1,4},
/*h(79)=13 OUTREG=XED_REG_R13  ->	FB REXB=1 value=0x1 	FB SRM=5 value=0x5*/ {1,5},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB REXB=1 value=0x1 	FB SRM=6 value=0x6*/ {1,6},
/*h(81)=15 OUTREG=XED_REG_R15  ->	FB REXB=1 value=0x1 	FB SRM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_srm(xes,lu_table[hidx].srm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRy_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR32_B},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_B},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR64_B}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASK_N64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(106)=0 OUTREG=XED_REG_K0  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1},
/*h(107)=1 OUTREG=XED_REG_K1  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1},
/*h(108)=2 OUTREG=XED_REG_K2  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1},
/*h(109)=3 OUTREG=XED_REG_K3  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1},
/*h(110)=4 OUTREG=XED_REG_K4  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1},
/*h(111)=5 OUTREG=XED_REG_K5  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1},
/*h(112)=6 OUTREG=XED_REG_K6  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1},
/*h(113)=7 OUTREG=XED_REG_K7  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 106;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_Ar10(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*empty slot1 */ {0},
/*h(177)=1 OUTREG=XED_REG_R10W EASZ=1  ->	nothing*/ {177, },
/*h(242)=2 OUTREG=XED_REG_R10D EASZ=2  ->	nothing*/ {242, },
/*h(307)=3 OUTREG=XED_REG_R10 EASZ=3  ->	nothing*/ {307, },
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_B_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB RM=0 value=0x0*/ {0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB RM=1 value=0x1*/ {1},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB RM=2 value=0x2*/ {2},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB RM=3 value=0x3*/ {3},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB RM=4 value=0x4*/ {4},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB RM=5 value=0x5*/ {5},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB RM=6 value=0x6*/ {6},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR16e(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 34;
if(hidx <= 7) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRv_SB(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR16_SB},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_SB},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR64_SB}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_DSEG1(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_FINAL_DSEG1_NOT64},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_FINAL_DSEG1_NOT64},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_FINAL_DSEG1_MODE64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR16_SB(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t srm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(34)=0 OUTREG=XED_REG_AX  ->	FB REXB=0 value=0x0 	FB SRM=0 value=0x0*/ {0,0},
/*h(35)=1 OUTREG=XED_REG_CX  ->	FB REXB=0 value=0x0 	FB SRM=1 value=0x1*/ {0,1},
/*h(36)=2 OUTREG=XED_REG_DX  ->	FB REXB=0 value=0x0 	FB SRM=2 value=0x2*/ {0,2},
/*h(37)=3 OUTREG=XED_REG_BX  ->	FB REXB=0 value=0x0 	FB SRM=3 value=0x3*/ {0,3},
/*h(38)=4 OUTREG=XED_REG_SP  ->	FB REXB=0 value=0x0 	FB SRM=4 value=0x4*/ {0,4},
/*h(39)=5 OUTREG=XED_REG_BP  ->	FB REXB=0 value=0x0 	FB SRM=5 value=0x5*/ {0,5},
/*h(40)=6 OUTREG=XED_REG_SI  ->	FB REXB=0 value=0x0 	FB SRM=6 value=0x6*/ {0,6},
/*h(41)=7 OUTREG=XED_REG_DI  ->	FB REXB=0 value=0x0 	FB SRM=7 value=0x7*/ {0,7},
/*h(42)=8 OUTREG=XED_REG_R8W  ->	FB REXB=1 value=0x1 	FB SRM=0 value=0x0*/ {1,0},
/*h(43)=9 OUTREG=XED_REG_R9W  ->	FB REXB=1 value=0x1 	FB SRM=1 value=0x1*/ {1,1},
/*h(44)=10 OUTREG=XED_REG_R10W  ->	FB REXB=1 value=0x1 	FB SRM=2 value=0x2*/ {1,2},
/*h(45)=11 OUTREG=XED_REG_R11W  ->	FB REXB=1 value=0x1 	FB SRM=3 value=0x3*/ {1,3},
/*h(46)=12 OUTREG=XED_REG_R12W  ->	FB REXB=1 value=0x1 	FB SRM=4 value=0x4*/ {1,4},
/*h(47)=13 OUTREG=XED_REG_R13W  ->	FB REXB=1 value=0x1 	FB SRM=5 value=0x5*/ {1,5},
/*h(48)=14 OUTREG=XED_REG_R14W  ->	FB REXB=1 value=0x1 	FB SRM=6 value=0x6*/ {1,6},
/*h(49)=15 OUTREG=XED_REG_R15W  ->	FB REXB=1 value=0x1 	FB SRM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 34;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_srm(xes,lu_table[hidx].srm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_R3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_R3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_R3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_R3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
