/// @file xed-encoder-2.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-encoder.h"
#include "xed-encode-private.h"
#include "xed-enc-operand-lu.h"
#include "xed-operand-accessors.h"
xed_uint32_t xed_encode_ntluf_SrSP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1094)=0 OUTREG=XED_REG_RSP SMODE=2  ->	nothing*/ {1094, },
/*h(38)=1 OUTREG=XED_REG_SP SMODE=0  ->	nothing*/ {38, },
/*h(566)=2 OUTREG=XED_REG_ESP SMODE=1  ->	nothing*/ {566, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG_SMODE(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR64_N(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 OUTREG=XED_REG_RAX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1},
/*h(67)=1 OUTREG=XED_REG_RCX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1},
/*h(68)=2 OUTREG=XED_REG_RDX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1},
/*h(69)=3 OUTREG=XED_REG_RBX  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1},
/*h(70)=4 OUTREG=XED_REG_RSP  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1},
/*h(71)=5 OUTREG=XED_REG_RBP  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1},
/*h(73)=7 OUTREG=XED_REG_RDI  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1},
/*h(74)=8 OUTREG=XED_REG_R8  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0},
/*h(75)=9 OUTREG=XED_REG_R9  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0},
/*h(76)=10 OUTREG=XED_REG_R10  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0},
/*h(77)=11 OUTREG=XED_REG_R11  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0},
/*h(78)=12 OUTREG=XED_REG_R12  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0},
/*h(79)=13 OUTREG=XED_REG_R13  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0},
/*h(81)=15 OUTREG=XED_REG_R15  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR64_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 OUTREG=XED_REG_RAX  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(67)=1 OUTREG=XED_REG_RCX  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(68)=2 OUTREG=XED_REG_RDX  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(69)=3 OUTREG=XED_REG_RBX  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(70)=4 OUTREG=XED_REG_RSP  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(71)=5 OUTREG=XED_REG_RBP  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(73)=7 OUTREG=XED_REG_RDI  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(74)=8 OUTREG=XED_REG_R8  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(75)=9 OUTREG=XED_REG_R9  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(76)=10 OUTREG=XED_REG_R10  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(77)=11 OUTREG=XED_REG_R11  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(78)=12 OUTREG=XED_REG_R12  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(79)=13 OUTREG=XED_REG_R13  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(81)=15 OUTREG=XED_REG_R15  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR64_X(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t rexx ;xed_int8_t sibindex;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(0)=0 OUTREG=XED_REG_INVALID  ->	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0, 0,4},
/*h(81)=1 OUTREG=XED_REG_R15  ->	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {81, 1,7},
/*h(76)=2 OUTREG=XED_REG_R10  ->	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {76, 1,2},
/*h(71)=3 OUTREG=XED_REG_RBP  ->	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {71, 0,5},
/*h(66)=4 OUTREG=XED_REG_RAX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {66, 0,0},
/*h(77)=5 OUTREG=XED_REG_R11  ->	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {77, 1,3},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {72, 0,6},
/*h(67)=7 OUTREG=XED_REG_RCX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {67, 0,1},
/*h(78)=8 OUTREG=XED_REG_R12  ->	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {78, 1,4},
/*h(73)=9 OUTREG=XED_REG_RDI  ->	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {73, 0,7},
/*h(68)=10 OUTREG=XED_REG_RDX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {68, 0,2},
/*h(79)=11 OUTREG=XED_REG_R13  ->	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {79, 1,5},
/*h(74)=12 OUTREG=XED_REG_R8  ->	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {74, 1,0},
/*h(69)=13 OUTREG=XED_REG_RBX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {69, 0,3},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {80, 1,6},
/*h(75)=15 OUTREG=XED_REG_R9  ->	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {75, 1,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = ((3*key % 89) % 16);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_DR_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[15] = {
/*h(102)=0 OUTREG=XED_REG_ERROR  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {102, 0,1},
/*h(26)=1 OUTREG=XED_REG_DR3  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {26, 3,0},
/*empty slot1 */ {0,0,0},
/*h(23)=3 OUTREG=XED_REG_DR0  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {23, 0,0},
/*h(28)=4 OUTREG=XED_REG_DR5  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {28, 5,0},
/*empty slot1 */ {0,0,0},
/*h(25)=6 OUTREG=XED_REG_DR2  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {25, 2,0},
/*empty slot1 */ {0,0,0},
/*h(30)=8 OUTREG=XED_REG_DR7  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {30, 7,0},
/*empty slot1 */ {0,0,0},
/*h(27)=10 OUTREG=XED_REG_DR4  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {27, 4,0},
/*empty slot1 */ {0,0,0},
/*h(24)=12 OUTREG=XED_REG_DR1  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {24, 1,0},
/*h(29)=13 OUTREG=XED_REG_DR6  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {29, 6,0},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 15ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR64_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 OUTREG=XED_REG_RAX  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(67)=1 OUTREG=XED_REG_RCX  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(68)=2 OUTREG=XED_REG_RDX  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(69)=3 OUTREG=XED_REG_RBX  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(70)=4 OUTREG=XED_REG_RSP  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(71)=5 OUTREG=XED_REG_RBP  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(72)=6 OUTREG=XED_REG_RSI  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(73)=7 OUTREG=XED_REG_RDI  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(74)=8 OUTREG=XED_REG_R8  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(75)=9 OUTREG=XED_REG_R9  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(76)=10 OUTREG=XED_REG_R10  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(77)=11 OUTREG=XED_REG_R11  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(78)=12 OUTREG=XED_REG_R12  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(79)=13 OUTREG=XED_REG_R13  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(80)=14 OUTREG=XED_REG_R14  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(81)=15 OUTREG=XED_REG_R15  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_rFLAGS(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(129)=0 OUTREG=XED_REG_EFLAGS MODE=1  ->	nothing*/ {129, },
/*h(124)=1 OUTREG=XED_REG_FLAGS MODE=0  ->	nothing*/ {124, },
/*h(134)=2 OUTREG=XED_REG_RFLAGS MODE=2  ->	nothing*/ {134, }
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (4*key % 3);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_R_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB REG=0 value=0x0*/ {0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB REG=1 value=0x1*/ {1},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REG=2 value=0x2*/ {2},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB REG=3 value=0x3*/ {3},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB REG=4 value=0x4*/ {4},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB REG=5 value=0x5*/ {5},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB REG=6 value=0x6*/ {6},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_ESEG1(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t using_default_segment1;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(2)=0 OUTREG=XED_REG_INVALID MODE=2  ->	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {2, 1},
/*h(596)=1 OUTREG=XED_REG_ES MODE=0  ->	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {596, 1},
/*h(597)=2 OUTREG=XED_REG_ES MODE=1  ->	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {597, 1}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_using_default_segment1(xes,lu_table[hidx].using_default_segment1);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_B3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB RM=0 value=0x0*/ {0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB RM=1 value=0x1*/ {1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB RM=2 value=0x2*/ {2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB RM=3 value=0x3*/ {3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB RM=4 value=0x4*/ {4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB RM=5 value=0x5*/ {5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB RM=6 value=0x6*/ {6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArAX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(267)=0 OUTREG=XED_REG_RAX EASZ=3  ->	nothing*/ {267, },
/*empty slot1 */ {0},
/*h(137)=2 OUTREG=XED_REG_AX EASZ=1  ->	nothing*/ {137, },
/*h(202)=3 OUTREG=XED_REG_EAX EASZ=2  ->	nothing*/ {202, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_N3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRm_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_GPR32_B},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_GPR32_B},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_GPR64_B}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_SEG(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[12] = {
/*h(102)=0 OUTREG=XED_REG_ERROR  ->	FB REG=6 value=0x6*/ {102, 6},
/*h(149)=1 OUTREG=XED_REG_ES  ->	FB REG=0 value=0x0*/ {149, 0},
/*empty slot1 */ {0,0},
/*h(151)=3 OUTREG=XED_REG_FS  ->	FB REG=4 value=0x4*/ {151, 4},
/*empty slot1 */ {0,0},
/*h(148)=5 OUTREG=XED_REG_DS  ->	FB REG=3 value=0x3*/ {148, 3},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(150)=8 OUTREG=XED_REG_SS  ->	FB REG=2 value=0x2*/ {150, 2},
/*empty slot1 */ {0,0},
/*h(147)=10 OUTREG=XED_REG_CS  ->	FB REG=1 value=0x1*/ {147, 1},
/*h(152)=11 OUTREG=XED_REG_GS  ->	FB REG=5 value=0x5*/ {152, 5}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 12ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArDI(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(230)=0 OUTREG=XED_REG_EDI EASZ=2  ->	nothing*/ {230, },
/*h(295)=1 OUTREG=XED_REG_RDI EASZ=3  ->	nothing*/ {295, },
/*empty slot1 */ {0},
/*h(165)=3 OUTREG=XED_REG_DI EASZ=1  ->	nothing*/ {165, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_R3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB REG=0 value=0x0*/ {0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB REG=1 value=0x1*/ {1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB REG=2 value=0x2*/ {2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB REG=3 value=0x3*/ {3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB REG=4 value=0x4*/ {4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB REG=5 value=0x5*/ {5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB REG=6 value=0x6*/ {6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_R3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr ;xed_int8_t rexrr;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(242)=0 OUTREG=XED_REG_ZMM0  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,0},
/*h(243)=1 OUTREG=XED_REG_ZMM1  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,0},
/*h(244)=2 OUTREG=XED_REG_ZMM2  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,0},
/*h(245)=3 OUTREG=XED_REG_ZMM3  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,0},
/*h(246)=4 OUTREG=XED_REG_ZMM4  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,0},
/*h(247)=5 OUTREG=XED_REG_ZMM5  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,0},
/*h(248)=6 OUTREG=XED_REG_ZMM6  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,0},
/*h(249)=7 OUTREG=XED_REG_ZMM7  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,0},
/*h(250)=8 OUTREG=XED_REG_ZMM8  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1,0},
/*h(251)=9 OUTREG=XED_REG_ZMM9  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1,0},
/*h(252)=10 OUTREG=XED_REG_ZMM10  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1,0},
/*h(253)=11 OUTREG=XED_REG_ZMM11  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1,0},
/*h(254)=12 OUTREG=XED_REG_ZMM12  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1,0},
/*h(255)=13 OUTREG=XED_REG_ZMM13  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1,0},
/*h(256)=14 OUTREG=XED_REG_ZMM14  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1,0},
/*h(257)=15 OUTREG=XED_REG_ZMM15  ->	FB REXRR=0 value=0x0 	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1,0},
/*h(258)=16 OUTREG=XED_REG_ZMM16  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,1},
/*h(259)=17 OUTREG=XED_REG_ZMM17  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,1},
/*h(260)=18 OUTREG=XED_REG_ZMM18  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,1},
/*h(261)=19 OUTREG=XED_REG_ZMM19  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,1},
/*h(262)=20 OUTREG=XED_REG_ZMM20  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,1},
/*h(263)=21 OUTREG=XED_REG_ZMM21  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,1},
/*h(264)=22 OUTREG=XED_REG_ZMM22  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,1},
/*h(265)=23 OUTREG=XED_REG_ZMM23  ->	FB REXRR=1 value=0x1 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,1},
/*h(266)=24 OUTREG=XED_REG_ZMM24  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1,1},
/*h(267)=25 OUTREG=XED_REG_ZMM25  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1,1},
/*h(268)=26 OUTREG=XED_REG_ZMM26  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1,1},
/*h(269)=27 OUTREG=XED_REG_ZMM27  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1,1},
/*h(270)=28 OUTREG=XED_REG_ZMM28  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1,1},
/*h(271)=29 OUTREG=XED_REG_ZMM29  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1,1},
/*h(272)=30 OUTREG=XED_REG_ZMM30  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1,1},
/*h(273)=31 OUTREG=XED_REG_ZMM31  ->	FB REXRR=1 value=0x1 	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 242;
if(hidx <= 31) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    xed3_operand_set_rexrr(xes,lu_table[hidx].rexrr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_SrBP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(39)=0 OUTREG=XED_REG_BP SMODE=0  ->	nothing*/ {39, },
/*h(567)=1 OUTREG=XED_REG_EBP SMODE=1  ->	nothing*/ {567, },
/*h(1095)=2 OUTREG=XED_REG_RBP SMODE=2  ->	nothing*/ {1095, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG_SMODE(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MMX_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(114)=0 OUTREG=XED_REG_MMX0  ->	FB RM=0 value=0x0*/ {0},
/*h(115)=1 OUTREG=XED_REG_MMX1  ->	FB RM=1 value=0x1*/ {1},
/*h(116)=2 OUTREG=XED_REG_MMX2  ->	FB RM=2 value=0x2*/ {2},
/*h(117)=3 OUTREG=XED_REG_MMX3  ->	FB RM=3 value=0x3*/ {3},
/*h(118)=4 OUTREG=XED_REG_MMX4  ->	FB RM=4 value=0x4*/ {4},
/*h(119)=5 OUTREG=XED_REG_MMX5  ->	FB RM=5 value=0x5*/ {5},
/*h(120)=6 OUTREG=XED_REG_MMX6  ->	FB RM=6 value=0x6*/ {6},
/*h(121)=7 OUTREG=XED_REG_MMX7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 114;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_B3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB RM=0 value=0x0*/ {0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB RM=1 value=0x1*/ {1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB RM=2 value=0x2*/ {2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB RM=3 value=0x3*/ {3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB RM=4 value=0x4*/ {4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB RM=5 value=0x5*/ {5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB RM=6 value=0x6*/ {6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_B3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rexx ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(242)=0 OUTREG=XED_REG_ZMM0  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0,0},
/*h(243)=1 OUTREG=XED_REG_ZMM1  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,0,1},
/*h(244)=2 OUTREG=XED_REG_ZMM2  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,0,2},
/*h(245)=3 OUTREG=XED_REG_ZMM3  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,0,3},
/*h(246)=4 OUTREG=XED_REG_ZMM4  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,0,4},
/*h(247)=5 OUTREG=XED_REG_ZMM5  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,0,5},
/*h(248)=6 OUTREG=XED_REG_ZMM6  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,0,6},
/*h(249)=7 OUTREG=XED_REG_ZMM7  ->	FB REXX=0 value=0x0 	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,0,7},
/*h(250)=8 OUTREG=XED_REG_ZMM8  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0,0},
/*h(251)=9 OUTREG=XED_REG_ZMM9  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,0,1},
/*h(252)=10 OUTREG=XED_REG_ZMM10  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,0,2},
/*h(253)=11 OUTREG=XED_REG_ZMM11  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,0,3},
/*h(254)=12 OUTREG=XED_REG_ZMM12  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,0,4},
/*h(255)=13 OUTREG=XED_REG_ZMM13  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,0,5},
/*h(256)=14 OUTREG=XED_REG_ZMM14  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,0,6},
/*h(257)=15 OUTREG=XED_REG_ZMM15  ->	FB REXX=0 value=0x0 	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,0,7},
/*h(258)=16 OUTREG=XED_REG_ZMM16  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,1,0},
/*h(259)=17 OUTREG=XED_REG_ZMM17  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1,1},
/*h(260)=18 OUTREG=XED_REG_ZMM18  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,1,2},
/*h(261)=19 OUTREG=XED_REG_ZMM19  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,1,3},
/*h(262)=20 OUTREG=XED_REG_ZMM20  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,1,4},
/*h(263)=21 OUTREG=XED_REG_ZMM21  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,1,5},
/*h(264)=22 OUTREG=XED_REG_ZMM22  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,1,6},
/*h(265)=23 OUTREG=XED_REG_ZMM23  ->	FB REXX=1 value=0x1 	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,1,7},
/*h(266)=24 OUTREG=XED_REG_ZMM24  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,1,0},
/*h(267)=25 OUTREG=XED_REG_ZMM25  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1,1},
/*h(268)=26 OUTREG=XED_REG_ZMM26  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,1,2},
/*h(269)=27 OUTREG=XED_REG_ZMM27  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,1,3},
/*h(270)=28 OUTREG=XED_REG_ZMM28  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,1,4},
/*h(271)=29 OUTREG=XED_REG_ZMM29  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,1,5},
/*h(272)=30 OUTREG=XED_REG_ZMM30  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,1,6},
/*h(273)=31 OUTREG=XED_REG_ZMM31  ->	FB REXX=1 value=0x1 	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 242;
if(hidx <= 31) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASK1(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t mask;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(106)=0 OUTREG=XED_REG_K0  ->	FB MASK=0 value=0x0*/ {0},
/*h(107)=1 OUTREG=XED_REG_K1  ->	FB MASK=1 value=0x1*/ {1},
/*h(108)=2 OUTREG=XED_REG_K2  ->	FB MASK=2 value=0x2*/ {2},
/*h(109)=3 OUTREG=XED_REG_K3  ->	FB MASK=3 value=0x3*/ {3},
/*h(110)=4 OUTREG=XED_REG_K4  ->	FB MASK=4 value=0x4*/ {4},
/*h(111)=5 OUTREG=XED_REG_K5  ->	FB MASK=5 value=0x5*/ {5},
/*h(112)=6 OUTREG=XED_REG_K6  ->	FB MASK=6 value=0x6*/ {6},
/*h(113)=7 OUTREG=XED_REG_K7  ->	FB MASK=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 106;
if(hidx <= 7) {
    xed3_operand_set_mask(xes,lu_table[hidx].mask);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MMX_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(114)=0 OUTREG=XED_REG_MMX0  ->	FB REG=0 value=0x0*/ {0},
/*h(115)=1 OUTREG=XED_REG_MMX1  ->	FB REG=1 value=0x1*/ {1},
/*h(116)=2 OUTREG=XED_REG_MMX2  ->	FB REG=2 value=0x2*/ {2},
/*h(117)=3 OUTREG=XED_REG_MMX3  ->	FB REG=3 value=0x3*/ {3},
/*h(118)=4 OUTREG=XED_REG_MMX4  ->	FB REG=4 value=0x4*/ {4},
/*h(119)=5 OUTREG=XED_REG_MMX5  ->	FB REG=5 value=0x5*/ {5},
/*h(120)=6 OUTREG=XED_REG_MMX6  ->	FB REG=6 value=0x6*/ {6},
/*h(121)=7 OUTREG=XED_REG_MMX7  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 114;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_R_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB REG=0 value=0x0*/ {0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB REG=1 value=0x1*/ {1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB REG=2 value=0x2*/ {2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB REG=3 value=0x3*/ {3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB REG=4 value=0x4*/ {4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB REG=5 value=0x5*/ {5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB REG=6 value=0x6*/ {6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_DSEG_NOT64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t seg_ovd ;xed_int8_t using_default_segment0;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(147)=0 OUTREG=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {1,0},
/*h(148)=1 OUTREG=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0 	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {0,1},
/*h(149)=2 OUTREG=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {3,0},
/*h(150)=3 OUTREG=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {6,0},
/*h(151)=4 OUTREG=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {4,0},
/*h(152)=5 OUTREG=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {5,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 147;
if(hidx <= 5) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    xed3_operand_set_using_default_segment0(xes,lu_table[hidx].using_default_segment0);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASK_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr ;xed_int8_t rexrr;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(106)=0 OUTREG=XED_REG_K0  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0,0},
/*h(107)=1 OUTREG=XED_REG_K1  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0,0},
/*h(108)=2 OUTREG=XED_REG_K2  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0,0},
/*h(109)=3 OUTREG=XED_REG_K3  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0,0},
/*h(110)=4 OUTREG=XED_REG_K4  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0,0},
/*h(111)=5 OUTREG=XED_REG_K5  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0,0},
/*h(112)=6 OUTREG=XED_REG_K6  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0,0},
/*h(113)=7 OUTREG=XED_REG_K7  ->	FB REXRR=0 value=0x0 	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 106;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    xed3_operand_set_rexrr(xes,lu_table[hidx].rexrr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArBP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(157)=0 OUTREG=XED_REG_BP EASZ=1  ->	nothing*/ {157, },
/*h(222)=1 OUTREG=XED_REG_EBP EASZ=2  ->	nothing*/ {222, },
/*h(287)=2 OUTREG=XED_REG_RBP EASZ=3  ->	nothing*/ {287, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_R_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(58)=8 OUTREG=XED_REG_R8D  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(60)=10 OUTREG=XED_REG_R10D  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(61)=11 OUTREG=XED_REG_R11D  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(62)=12 OUTREG=XED_REG_R12D  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(63)=13 OUTREG=XED_REG_R13D  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(64)=14 OUTREG=XED_REG_R14D  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(65)=15 OUTREG=XED_REG_R15D  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_CR_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[10] = {
/*h(102)=0 OUTREG=XED_REG_ERROR  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {102, 0,1},
/*h(10)=1 OUTREG=XED_REG_CR3  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {10, 0,3},
/*h(15)=2 OUTREG=XED_REG_CR8  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {15, 1,0},
/*h(7)=3 OUTREG=XED_REG_CR0  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {7, 0,0},
/*empty slot1 */ {0,0,0},
/*h(9)=5 OUTREG=XED_REG_CR2  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {9, 0,2},
/*empty slot1 */ {0,0,0},
/*h(11)=7 OUTREG=XED_REG_CR4  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {11, 0,4},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 10ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_N_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1},
/*h(186)=8 OUTREG=XED_REG_XMM8  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0},
/*h(187)=9 OUTREG=XED_REG_XMM9  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0},
/*h(188)=10 OUTREG=XED_REG_XMM10  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0},
/*h(189)=11 OUTREG=XED_REG_XMM11  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0},
/*h(190)=12 OUTREG=XED_REG_XMM12  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0},
/*h(191)=13 OUTREG=XED_REG_XMM13  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0},
/*h(192)=14 OUTREG=XED_REG_XMM14  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0},
/*h(193)=15 OUTREG=XED_REG_XMM15  ->	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 15) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ArBX(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(149)=0 OUTREG=XED_REG_BX EASZ=1  ->	nothing*/ {149, },
/*h(214)=1 OUTREG=XED_REG_EBX EASZ=2  ->	nothing*/ {214, },
/*h(279)=2 OUTREG=XED_REG_RBX EASZ=3  ->	nothing*/ {279, },
/*empty slot1 */ {0},
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASK_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(106)=0 OUTREG=XED_REG_K0  ->	FB RM=0 value=0x0*/ {0},
/*h(107)=1 OUTREG=XED_REG_K1  ->	FB RM=1 value=0x1*/ {1},
/*h(108)=2 OUTREG=XED_REG_K2  ->	FB RM=2 value=0x2*/ {2},
/*h(109)=3 OUTREG=XED_REG_K3  ->	FB RM=3 value=0x3*/ {3},
/*h(110)=4 OUTREG=XED_REG_K4  ->	FB RM=4 value=0x4*/ {4},
/*h(111)=5 OUTREG=XED_REG_K5  ->	FB RM=5 value=0x5*/ {5},
/*h(112)=6 OUTREG=XED_REG_K6  ->	FB RM=6 value=0x6*/ {6},
/*h(113)=7 OUTREG=XED_REG_K7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 106;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_N(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_VGPR32_N_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_VGPR32_N_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_VGPR32_N_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_R_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB REG=0 value=0x0*/ {0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB REG=1 value=0x1*/ {1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB REG=2 value=0x2*/ {2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB REG=3 value=0x3*/ {3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB REG=4 value=0x4*/ {4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB REG=5 value=0x5*/ {5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB REG=6 value=0x6*/ {6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_A_GPR_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[96] = {
/*h(206)=0 OUTREG=XED_REG_ECX EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {206, 0,1},
/*empty slot1 */ {0,0,0},
/*h(149)=2 OUTREG=XED_REG_BX EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {149, 0,3},
/*h(275)=3 OUTREG=XED_REG_RDX EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {275, 0,2},
/*h(137)=4 OUTREG=XED_REG_AX EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {137, 0,0},
/*h(218)=5 OUTREG=XED_REG_ESP EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {218, 0,4},
/*empty slot1 */ {0,0,0},
/*h(161)=7 OUTREG=XED_REG_SI EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {161, 0,6},
/*h(287)=8 OUTREG=XED_REG_RBP EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {287, 0,5},
/*empty slot1 */ {0,0,0},
/*h(230)=10 OUTREG=XED_REG_EDI EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {230, 0,7},
/*empty slot1 */ {0,0,0},
/*h(173)=12 OUTREG=XED_REG_R9W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {173, 1,1},
/*h(299)=13 OUTREG=XED_REG_R8 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {299, 1,0},
/*empty slot1 */ {0,0,0},
/*h(242)=15 OUTREG=XED_REG_R10D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {242, 1,2},
/*empty slot1 */ {0,0,0},
/*h(185)=17 OUTREG=XED_REG_R12W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {185, 1,4},
/*h(311)=18 OUTREG=XED_REG_R11 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {311, 1,3},
/*empty slot1 */ {0,0,0},
/*h(254)=20 OUTREG=XED_REG_R13D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {254, 1,5},
/*empty slot1 */ {0,0,0},
/*h(197)=22 OUTREG=XED_REG_R15W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {197, 1,7},
/*h(323)=23 OUTREG=XED_REG_R14 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {323, 1,6},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(141)=33 OUTREG=XED_REG_CX EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {141, 0,1},
/*h(267)=34 OUTREG=XED_REG_RAX EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {267, 0,0},
/*empty slot1 */ {0,0,0},
/*h(210)=36 OUTREG=XED_REG_EDX EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {210, 0,2},
/*empty slot1 */ {0,0,0},
/*h(153)=38 OUTREG=XED_REG_SP EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {153, 0,4},
/*h(279)=39 OUTREG=XED_REG_RBX EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {279, 0,3},
/*empty slot1 */ {0,0,0},
/*h(222)=41 OUTREG=XED_REG_EBP EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {222, 0,5},
/*empty slot1 */ {0,0,0},
/*h(165)=43 OUTREG=XED_REG_DI EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {165, 0,7},
/*h(291)=44 OUTREG=XED_REG_RSI EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {291, 0,6},
/*empty slot1 */ {0,0,0},
/*h(234)=46 OUTREG=XED_REG_R8D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {234, 1,0},
/*empty slot1 */ {0,0,0},
/*h(177)=48 OUTREG=XED_REG_R10W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {177, 1,2},
/*h(303)=49 OUTREG=XED_REG_R9 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {303, 1,1},
/*empty slot1 */ {0,0,0},
/*h(246)=51 OUTREG=XED_REG_R11D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {246, 1,3},
/*empty slot1 */ {0,0,0},
/*h(189)=53 OUTREG=XED_REG_R13W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {189, 1,5},
/*h(315)=54 OUTREG=XED_REG_R12 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {315, 1,4},
/*empty slot1 */ {0,0,0},
/*h(258)=56 OUTREG=XED_REG_R14D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {258, 1,6},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(327)=59 OUTREG=XED_REG_R15 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {327, 1,7},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(202)=67 OUTREG=XED_REG_EAX EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {202, 0,0},
/*empty slot1 */ {0,0,0},
/*h(145)=69 OUTREG=XED_REG_DX EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {145, 0,2},
/*h(271)=70 OUTREG=XED_REG_RCX EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {271, 0,1},
/*empty slot1 */ {0,0,0},
/*h(214)=72 OUTREG=XED_REG_EBX EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {214, 0,3},
/*empty slot1 */ {0,0,0},
/*h(157)=74 OUTREG=XED_REG_BP EASZ=1  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {157, 0,5},
/*h(283)=75 OUTREG=XED_REG_RSP EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {283, 0,4},
/*empty slot1 */ {0,0,0},
/*h(226)=77 OUTREG=XED_REG_ESI EASZ=2  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {226, 0,6},
/*empty slot1 */ {0,0,0},
/*h(169)=79 OUTREG=XED_REG_R8W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {169, 1,0},
/*h(295)=80 OUTREG=XED_REG_RDI EASZ=3  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {295, 0,7},
/*empty slot1 */ {0,0,0},
/*h(238)=82 OUTREG=XED_REG_R9D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {238, 1,1},
/*empty slot1 */ {0,0,0},
/*h(181)=84 OUTREG=XED_REG_R11W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {181, 1,3},
/*h(307)=85 OUTREG=XED_REG_R10 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {307, 1,2},
/*empty slot1 */ {0,0,0},
/*h(250)=87 OUTREG=XED_REG_R12D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {250, 1,4},
/*empty slot1 */ {0,0,0},
/*h(193)=89 OUTREG=XED_REG_R14W EASZ=1  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {193, 1,6},
/*h(319)=90 OUTREG=XED_REG_R13 EASZ=3  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {319, 1,5},
/*empty slot1 */ {0,0,0},
/*h(262)=92 OUTREG=XED_REG_R15D EASZ=2  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {262, 1,7},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = ((9*key % 103) % 96);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_ESEG(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t using_default_segment0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(2)=0 OUTREG=XED_REG_INVALID MODE=2  ->	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {2, 1},
/*h(596)=1 OUTREG=XED_REG_ES MODE=0  ->	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {596, 1},
/*h(597)=2 OUTREG=XED_REG_ES MODE=1  ->	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {597, 1}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_using_default_segment0(xes,lu_table[hidx].using_default_segment0);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR16_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(34)=0 OUTREG=XED_REG_AX  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(35)=1 OUTREG=XED_REG_CX  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(36)=2 OUTREG=XED_REG_DX  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(37)=3 OUTREG=XED_REG_BX  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(38)=4 OUTREG=XED_REG_SP  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(39)=5 OUTREG=XED_REG_BP  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(40)=6 OUTREG=XED_REG_SI  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(41)=7 OUTREG=XED_REG_DI  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(42)=8 OUTREG=XED_REG_R8W  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(43)=9 OUTREG=XED_REG_R9W  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(44)=10 OUTREG=XED_REG_R10W  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(45)=11 OUTREG=XED_REG_R11W  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(46)=12 OUTREG=XED_REG_R12W  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(47)=13 OUTREG=XED_REG_R13W  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(48)=14 OUTREG=XED_REG_R14W  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(49)=15 OUTREG=XED_REG_R15W  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 34;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASK_N(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_MASK_N32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_MASK_N32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_MASK_N64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_OrSP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(153)=2 OUTREG=XED_REG_SP EOSZ=1  ->	nothing*/ {153, },
/*h(218)=3 OUTREG=XED_REG_ESP EOSZ=2  ->	nothing*/ {218, },
/*h(283)=4 OUTREG=XED_REG_RSP EOSZ=3  ->	nothing*/ {283, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_VGPR32_B_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_VGPR32_B_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_VGPR32_B_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_N3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_R3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(242)=0 OUTREG=XED_REG_ZMM0  ->	FB REG=0 value=0x0*/ {0},
/*h(243)=1 OUTREG=XED_REG_ZMM1  ->	FB REG=1 value=0x1*/ {1},
/*h(244)=2 OUTREG=XED_REG_ZMM2  ->	FB REG=2 value=0x2*/ {2},
/*h(245)=3 OUTREG=XED_REG_ZMM3  ->	FB REG=3 value=0x3*/ {3},
/*h(246)=4 OUTREG=XED_REG_ZMM4  ->	FB REG=4 value=0x4*/ {4},
/*h(247)=5 OUTREG=XED_REG_ZMM5  ->	FB REG=5 value=0x5*/ {5},
/*h(248)=6 OUTREG=XED_REG_ZMM6  ->	FB REG=6 value=0x6*/ {6},
/*h(249)=7 OUTREG=XED_REG_ZMM7  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 242;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_SE32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t esrc;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(178)=0 OUTREG=XED_REG_XMM0  ->	FB ESRC=0 value=0x0*/ {0},
/*h(179)=1 OUTREG=XED_REG_XMM1  ->	FB ESRC=1 value=0x1*/ {1},
/*h(180)=2 OUTREG=XED_REG_XMM2  ->	FB ESRC=2 value=0x2*/ {2},
/*h(181)=3 OUTREG=XED_REG_XMM3  ->	FB ESRC=3 value=0x3*/ {3},
/*h(182)=4 OUTREG=XED_REG_XMM4  ->	FB ESRC=4 value=0x4*/ {4},
/*h(183)=5 OUTREG=XED_REG_XMM5  ->	FB ESRC=5 value=0x5*/ {5},
/*h(184)=6 OUTREG=XED_REG_XMM6  ->	FB ESRC=6 value=0x6*/ {6},
/*h(185)=7 OUTREG=XED_REG_XMM7  ->	FB ESRC=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 178;
if(hidx <= 7) {
    xed3_operand_set_esrc(xes,lu_table[hidx].esrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_N_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(58)=8 OUTREG=XED_REG_R8D  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(60)=10 OUTREG=XED_REG_R10D  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(61)=11 OUTREG=XED_REG_R11D  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(62)=12 OUTREG=XED_REG_R12D  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(63)=13 OUTREG=XED_REG_R13D  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(64)=14 OUTREG=XED_REG_R14D  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(65)=15 OUTREG=XED_REG_R15D  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_SE32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t esrc;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB ESRC=0 value=0x0*/ {0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB ESRC=1 value=0x1*/ {1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB ESRC=2 value=0x2*/ {2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB ESRC=3 value=0x3*/ {3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB ESRC=4 value=0x4*/ {4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB ESRC=5 value=0x5*/ {5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB ESRC=6 value=0x6*/ {6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB ESRC=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_esrc(xes,lu_table[hidx].esrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32_X(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t rexx ;xed_int8_t sibindex;} lu_entry_t;
static const lu_entry_t lu_table[21] = {
/*h(0)=0 OUTREG=XED_REG_INVALID  ->	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0, 0,4},
/*h(60)=1 OUTREG=XED_REG_R10D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {60, 1,2},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {52, 0,2},
/*h(65)=3 OUTREG=XED_REG_R15D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {65, 1,7},
/*h(57)=4 OUTREG=XED_REG_EDI  ->	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {57, 0,7},
/*empty slot1 */ {0,0,0},
/*h(62)=6 OUTREG=XED_REG_R12D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {62, 1,4},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {59, 1,1},
/*h(51)=10 OUTREG=XED_REG_ECX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {51, 0,1},
/*h(64)=11 OUTREG=XED_REG_R14D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {64, 1,6},
/*h(56)=12 OUTREG=XED_REG_ESI  ->	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {56, 0,6},
/*empty slot1 */ {0,0,0},
/*h(61)=14 OUTREG=XED_REG_R11D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {61, 1,3},
/*h(53)=15 OUTREG=XED_REG_EBX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {53, 0,3},
/*empty slot1 */ {0,0,0},
/*h(58)=17 OUTREG=XED_REG_R8D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {58, 1,0},
/*h(50)=18 OUTREG=XED_REG_EAX  ->	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {50, 0,0},
/*h(63)=19 OUTREG=XED_REG_R13D  ->	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {63, 1,5},
/*h(55)=20 OUTREG=XED_REG_EBP  ->	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {55, 0,5}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 21ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_B_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_DSEG(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_FINAL_DSEG_NOT64},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_FINAL_DSEG_NOT64},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_FINAL_DSEG_MODE64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_N3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_N3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_N3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_N3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_B3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_ZMM_B3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_ZMM_B3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_ZMM_B3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {0,0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {1,0},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {2,0},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {3,0},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {4,0},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {5,0},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {6,0},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {7,0},
/*h(58)=8 OUTREG=XED_REG_R8D  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {0,1},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {1,1},
/*h(60)=10 OUTREG=XED_REG_R10D  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {2,1},
/*h(61)=11 OUTREG=XED_REG_R11D  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {3,1},
/*h(62)=12 OUTREG=XED_REG_R12D  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {4,1},
/*h(63)=13 OUTREG=XED_REG_R13D  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {5,1},
/*h(64)=14 OUTREG=XED_REG_R14D  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {6,1},
/*h(65)=15 OUTREG=XED_REG_R15D  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32_SB(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t srm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB REXB=0 value=0x0 	FB SRM=0 value=0x0*/ {0,0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB REXB=0 value=0x0 	FB SRM=1 value=0x1*/ {0,1},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REXB=0 value=0x0 	FB SRM=2 value=0x2*/ {0,2},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB REXB=0 value=0x0 	FB SRM=3 value=0x3*/ {0,3},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB REXB=0 value=0x0 	FB SRM=4 value=0x4*/ {0,4},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB REXB=0 value=0x0 	FB SRM=5 value=0x5*/ {0,5},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB REXB=0 value=0x0 	FB SRM=6 value=0x6*/ {0,6},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB REXB=0 value=0x0 	FB SRM=7 value=0x7*/ {0,7},
/*h(58)=8 OUTREG=XED_REG_R8D  ->	FB REXB=1 value=0x1 	FB SRM=0 value=0x0*/ {1,0},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB REXB=1 value=0x1 	FB SRM=1 value=0x1*/ {1,1},
/*h(60)=10 OUTREG=XED_REG_R10D  ->	FB REXB=1 value=0x1 	FB SRM=2 value=0x2*/ {1,2},
/*h(61)=11 OUTREG=XED_REG_R11D  ->	FB REXB=1 value=0x1 	FB SRM=3 value=0x3*/ {1,3},
/*h(62)=12 OUTREG=XED_REG_R12D  ->	FB REXB=1 value=0x1 	FB SRM=4 value=0x4*/ {1,4},
/*h(63)=13 OUTREG=XED_REG_R13D  ->	FB REXB=1 value=0x1 	FB SRM=5 value=0x5*/ {1,5},
/*h(64)=14 OUTREG=XED_REG_R14D  ->	FB REXB=1 value=0x1 	FB SRM=6 value=0x6*/ {1,6},
/*h(65)=15 OUTREG=XED_REG_R15D  ->	FB REXB=1 value=0x1 	FB SRM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_srm(xes,lu_table[hidx].srm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRv_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR16_R},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_R},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR64_R}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_X87(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(169)=0 OUTREG=XED_REG_ST0  ->	FB RM=0 value=0x0*/ {0},
/*h(170)=1 OUTREG=XED_REG_ST1  ->	FB RM=1 value=0x1*/ {1},
/*h(171)=2 OUTREG=XED_REG_ST2  ->	FB RM=2 value=0x2*/ {2},
/*h(172)=3 OUTREG=XED_REG_ST3  ->	FB RM=3 value=0x3*/ {3},
/*h(173)=4 OUTREG=XED_REG_ST4  ->	FB RM=4 value=0x4*/ {4},
/*h(174)=5 OUTREG=XED_REG_ST5  ->	FB RM=5 value=0x5*/ {5},
/*h(175)=6 OUTREG=XED_REG_ST6  ->	FB RM=6 value=0x6*/ {6},
/*h(176)=7 OUTREG=XED_REG_ST7  ->	FB RM=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 169;
if(hidx <= 7) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR64e(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 66;
if(hidx <= 15) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_SSEG(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_FINAL_SSEG_NOT64},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_FINAL_SSEG_NOT64},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_FINAL_SSEG_MODE64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPRv_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(1)=0 EOSZ=1  ->	ntluf*/ {xed_encode_ntluf_GPR16_B},
/*h(2)=1 EOSZ=2  ->	ntluf*/ {xed_encode_ntluf_GPR32_B},
/*h(3)=2 EOSZ=3  ->	ntluf*/ {xed_encode_ntluf_GPR64_B}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ(xes);
hidx = key - 1;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_SE64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t esrc;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB ESRC=0 value=0x0*/ {0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB ESRC=1 value=0x1*/ {1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB ESRC=2 value=0x2*/ {2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB ESRC=3 value=0x3*/ {3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB ESRC=4 value=0x4*/ {4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB ESRC=5 value=0x5*/ {5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB ESRC=6 value=0x6*/ {6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB ESRC=7 value=0x7*/ {7},
/*h(218)=8 OUTREG=XED_REG_YMM8  ->	FB ESRC=8 value=0x8*/ {8},
/*h(219)=9 OUTREG=XED_REG_YMM9  ->	FB ESRC=9 value=0x9*/ {9},
/*h(220)=10 OUTREG=XED_REG_YMM10  ->	FB ESRC=10 value=0xa*/ {10},
/*h(221)=11 OUTREG=XED_REG_YMM11  ->	FB ESRC=11 value=0xb*/ {11},
/*h(222)=12 OUTREG=XED_REG_YMM12  ->	FB ESRC=12 value=0xc*/ {12},
/*h(223)=13 OUTREG=XED_REG_YMM13  ->	FB ESRC=13 value=0xd*/ {13},
/*h(224)=14 OUTREG=XED_REG_YMM14  ->	FB ESRC=14 value=0xe*/ {14},
/*h(225)=15 OUTREG=XED_REG_YMM15  ->	FB ESRC=15 value=0xf*/ {15}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 15) {
    xed3_operand_set_esrc(xes,lu_table[hidx].esrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_VGPR32_B_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(50)=0 OUTREG=XED_REG_EAX  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {0,0},
/*h(51)=1 OUTREG=XED_REG_ECX  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {0,1},
/*h(52)=2 OUTREG=XED_REG_EDX  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {0,2},
/*h(53)=3 OUTREG=XED_REG_EBX  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {0,3},
/*h(54)=4 OUTREG=XED_REG_ESP  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {0,4},
/*h(55)=5 OUTREG=XED_REG_EBP  ->	FB REXB=0 value=0x0 	FB RM=5 value=0x5*/ {0,5},
/*h(56)=6 OUTREG=XED_REG_ESI  ->	FB REXB=0 value=0x0 	FB RM=6 value=0x6*/ {0,6},
/*h(57)=7 OUTREG=XED_REG_EDI  ->	FB REXB=0 value=0x0 	FB RM=7 value=0x7*/ {0,7},
/*h(58)=8 OUTREG=XED_REG_R8D  ->	FB REXB=1 value=0x1 	FB RM=0 value=0x0*/ {1,0},
/*h(59)=9 OUTREG=XED_REG_R9D  ->	FB REXB=1 value=0x1 	FB RM=1 value=0x1*/ {1,1},
/*h(60)=10 OUTREG=XED_REG_R10D  ->	FB REXB=1 value=0x1 	FB RM=2 value=0x2*/ {1,2},
/*h(61)=11 OUTREG=XED_REG_R11D  ->	FB REXB=1 value=0x1 	FB RM=3 value=0x3*/ {1,3},
/*h(62)=12 OUTREG=XED_REG_R12D  ->	FB REXB=1 value=0x1 	FB RM=4 value=0x4*/ {1,4},
/*h(63)=13 OUTREG=XED_REG_R13D  ->	FB REXB=1 value=0x1 	FB RM=5 value=0x5*/ {1,5},
/*h(64)=14 OUTREG=XED_REG_R14D  ->	FB REXB=1 value=0x1 	FB RM=6 value=0x6*/ {1,6},
/*h(65)=15 OUTREG=XED_REG_R15D  ->	FB REXB=1 value=0x1 	FB RM=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 50;
if(hidx <= 15) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR32e(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[36] = {
/*empty slot1 */ {0},
/*h(246)=1 MODE=2 OUTREG=XED_REG_R11D  ->	nothing*/ {246, },
/*h(225)=2 MODE=1 OUTREG=XED_REG_ESI  ->	nothing*/ {225, },
/*h(238)=3 MODE=2 OUTREG=XED_REG_R9D  ->	nothing*/ {238, },
/*h(217)=4 MODE=1 OUTREG=XED_REG_ESP  ->	nothing*/ {217, },
/*h(230)=5 MODE=2 OUTREG=XED_REG_EDI  ->	nothing*/ {230, },
/*h(209)=6 MODE=1 OUTREG=XED_REG_EDX  ->	nothing*/ {209, },
/*h(222)=7 MODE=2 OUTREG=XED_REG_EBP  ->	nothing*/ {222, },
/*h(201)=8 MODE=1 OUTREG=XED_REG_EAX  ->	nothing*/ {201, },
/*h(214)=9 MODE=2 OUTREG=XED_REG_EBX  ->	nothing*/ {214, },
/*empty slot1 */ {0},
/*h(206)=11 MODE=2 OUTREG=XED_REG_ECX  ->	nothing*/ {206, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(258)=16 MODE=2 OUTREG=XED_REG_R14D  ->	nothing*/ {258, },
/*empty slot1 */ {0},
/*h(250)=18 MODE=2 OUTREG=XED_REG_R12D  ->	nothing*/ {250, },
/*h(229)=19 MODE=1 OUTREG=XED_REG_EDI  ->	nothing*/ {229, },
/*h(242)=20 MODE=2 OUTREG=XED_REG_R10D  ->	nothing*/ {242, },
/*h(221)=21 MODE=1 OUTREG=XED_REG_EBP  ->	nothing*/ {221, },
/*h(234)=22 MODE=2 OUTREG=XED_REG_R8D  ->	nothing*/ {234, },
/*h(213)=23 MODE=1 OUTREG=XED_REG_EBX  ->	nothing*/ {213, },
/*h(226)=24 MODE=2 OUTREG=XED_REG_ESI  ->	nothing*/ {226, },
/*h(205)=25 MODE=1 OUTREG=XED_REG_ECX  ->	nothing*/ {205, },
/*h(218)=26 MODE=2 OUTREG=XED_REG_ESP  ->	nothing*/ {218, },
/*empty slot1 */ {0},
/*h(210)=28 MODE=2 OUTREG=XED_REG_EDX  ->	nothing*/ {210, },
/*empty slot1 */ {0},
/*h(202)=30 MODE=2 OUTREG=XED_REG_EAX  ->	nothing*/ {202, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(262)=33 MODE=2 OUTREG=XED_REG_R15D  ->	nothing*/ {262, },
/*empty slot1 */ {0},
/*h(254)=35 MODE=2 OUTREG=XED_REG_R13D  ->	nothing*/ {254, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 36ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_XMM_N3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_XMM_N3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_XMM_N3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_XMM_N3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_MASK_N32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(106)=0 OUTREG=XED_REG_K0  ->	FB VEXDEST210=7 value=0x7*/ {7},
/*h(107)=1 OUTREG=XED_REG_K1  ->	FB VEXDEST210=6 value=0x6*/ {6},
/*h(108)=2 OUTREG=XED_REG_K2  ->	FB VEXDEST210=5 value=0x5*/ {5},
/*h(109)=3 OUTREG=XED_REG_K3  ->	FB VEXDEST210=4 value=0x4*/ {4},
/*h(110)=4 OUTREG=XED_REG_K4  ->	FB VEXDEST210=3 value=0x3*/ {3},
/*h(111)=5 OUTREG=XED_REG_K5  ->	FB VEXDEST210=2 value=0x2*/ {2},
/*h(112)=6 OUTREG=XED_REG_K6  ->	FB VEXDEST210=1 value=0x1*/ {1},
/*h(113)=7 OUTREG=XED_REG_K7  ->	FB VEXDEST210=0 value=0x0*/ {0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 106;
if(hidx <= 7) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_DSEG1_NOT64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t seg_ovd ;xed_int8_t using_default_segment1;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(147)=0 OUTREG=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {1,0},
/*h(148)=1 OUTREG=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0 	FB USING_DEFAULT_SEGMENT1=1 value=0x1*/ {0,1},
/*h(149)=2 OUTREG=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {3,0},
/*h(150)=3 OUTREG=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {6,0},
/*h(151)=4 OUTREG=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {4,0},
/*h(152)=5 OUTREG=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5 	FB USING_DEFAULT_SEGMENT1=0 value=0x0*/ {5,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 147;
if(hidx <= 5) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    xed3_operand_set_using_default_segment1(xes,lu_table[hidx].using_default_segment1);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_OrBP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(157)=0 OUTREG=XED_REG_BP EOSZ=1  ->	nothing*/ {157, },
/*h(222)=1 OUTREG=XED_REG_EBP EOSZ=2  ->	nothing*/ {222, },
/*h(287)=2 OUTREG=XED_REG_RBP EOSZ=3  ->	nothing*/ {287, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*empty slot1 */ {0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EOSZ_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_rIP(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(416)=0 OUTREG=XED_REG_EIP MODE=0  ->	nothing*/ {416, },
/*empty slot1 */ {0},
/*h(417)=2 OUTREG=XED_REG_EIP MODE=1  ->	nothing*/ {417, },
/*h(414)=3 OUTREG=XED_REG_RIP MODE=2  ->	nothing*/ {414, }
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_R3_32(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(210)=0 OUTREG=XED_REG_YMM0  ->	FB REG=0 value=0x0*/ {0},
/*h(211)=1 OUTREG=XED_REG_YMM1  ->	FB REG=1 value=0x1*/ {1},
/*h(212)=2 OUTREG=XED_REG_YMM2  ->	FB REG=2 value=0x2*/ {2},
/*h(213)=3 OUTREG=XED_REG_YMM3  ->	FB REG=3 value=0x3*/ {3},
/*h(214)=4 OUTREG=XED_REG_YMM4  ->	FB REG=4 value=0x4*/ {4},
/*h(215)=5 OUTREG=XED_REG_YMM5  ->	FB REG=5 value=0x5*/ {5},
/*h(216)=6 OUTREG=XED_REG_YMM6  ->	FB REG=6 value=0x6*/ {6},
/*h(217)=7 OUTREG=XED_REG_YMM7  ->	FB REG=7 value=0x7*/ {7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 210;
if(hidx <= 7) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_YMM_B3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_YMM_B3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_YMM_B3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_YMM_B3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_FINAL_SSEG_MODE64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t seg_ovd ;xed_int8_t using_default_segment0;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 OUTREG=XED_REG_INVALID  ->	FB SEG_OVD=0 value=0x0 	FB USING_DEFAULT_SEGMENT0=1 value=0x1*/ {0, 0,1},
/*h(151)=1 OUTREG=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {151, 4,0},
/*empty slot1 */ {0,0,0},
/*h(152)=3 OUTREG=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5 	FB USING_DEFAULT_SEGMENT0=0 value=0x0*/ {152, 5,0}
};
xed_union64_t t;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key,  t.s.lo32 >> (32-2));
if(lu_table[hidx].key == key) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    xed3_operand_set_using_default_segment0(xes,lu_table[hidx].using_default_segment0);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_N3_64(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t vexdest210 ;xed_int8_t vexdest3 ;xed_int8_t vexdest4;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(242)=0 OUTREG=XED_REG_ZMM0  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1,0},
/*h(243)=1 OUTREG=XED_REG_ZMM1  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1,0},
/*h(244)=2 OUTREG=XED_REG_ZMM2  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1,0},
/*h(245)=3 OUTREG=XED_REG_ZMM3  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1,0},
/*h(246)=4 OUTREG=XED_REG_ZMM4  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1,0},
/*h(247)=5 OUTREG=XED_REG_ZMM5  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1,0},
/*h(248)=6 OUTREG=XED_REG_ZMM6  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1,0},
/*h(249)=7 OUTREG=XED_REG_ZMM7  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1,0},
/*h(250)=8 OUTREG=XED_REG_ZMM8  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0,0},
/*h(251)=9 OUTREG=XED_REG_ZMM9  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0,0},
/*h(252)=10 OUTREG=XED_REG_ZMM10  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0,0},
/*h(253)=11 OUTREG=XED_REG_ZMM11  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0,0},
/*h(254)=12 OUTREG=XED_REG_ZMM12  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0,0},
/*h(255)=13 OUTREG=XED_REG_ZMM13  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0,0},
/*h(256)=14 OUTREG=XED_REG_ZMM14  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0,0},
/*h(257)=15 OUTREG=XED_REG_ZMM15  ->	FB VEXDEST4=0 value=0x0 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0,0},
/*h(258)=16 OUTREG=XED_REG_ZMM16  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=7 value=0x7*/ {7,1,1},
/*h(259)=17 OUTREG=XED_REG_ZMM17  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=6 value=0x6*/ {6,1,1},
/*h(260)=18 OUTREG=XED_REG_ZMM18  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=5 value=0x5*/ {5,1,1},
/*h(261)=19 OUTREG=XED_REG_ZMM19  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=4 value=0x4*/ {4,1,1},
/*h(262)=20 OUTREG=XED_REG_ZMM20  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=3 value=0x3*/ {3,1,1},
/*h(263)=21 OUTREG=XED_REG_ZMM21  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=2 value=0x2*/ {2,1,1},
/*h(264)=22 OUTREG=XED_REG_ZMM22  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=1 value=0x1*/ {1,1,1},
/*h(265)=23 OUTREG=XED_REG_ZMM23  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=1 value=0x1 	FB VEXDEST210=0 value=0x0*/ {0,1,1},
/*h(266)=24 OUTREG=XED_REG_ZMM24  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=7 value=0x7*/ {7,0,1},
/*h(267)=25 OUTREG=XED_REG_ZMM25  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=6 value=0x6*/ {6,0,1},
/*h(268)=26 OUTREG=XED_REG_ZMM26  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=5 value=0x5*/ {5,0,1},
/*h(269)=27 OUTREG=XED_REG_ZMM27  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=4 value=0x4*/ {4,0,1},
/*h(270)=28 OUTREG=XED_REG_ZMM28  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=3 value=0x3*/ {3,0,1},
/*h(271)=29 OUTREG=XED_REG_ZMM29  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=2 value=0x2*/ {2,0,1},
/*h(272)=30 OUTREG=XED_REG_ZMM30  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=1 value=0x1*/ {1,0,1},
/*h(273)=31 OUTREG=XED_REG_ZMM31  ->	FB VEXDEST4=1 value=0x1 	FB VEXDEST3=0 value=0x0 	FB VEXDEST210=0 value=0x0*/ {0,0,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 242;
if(hidx <= 31) {
    xed3_operand_set_vexdest210(xes,lu_table[hidx].vexdest210);
    xed3_operand_set_vexdest3(xes,lu_table[hidx].vexdest3);
    xed3_operand_set_vexdest4(xes,lu_table[hidx].vexdest4);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_CR_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[10] = {
/*h(102)=0 OUTREG=XED_REG_ERROR  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {102, 1,0},
/*h(10)=1 OUTREG=XED_REG_CR3  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {10, 3,0},
/*h(15)=2 OUTREG=XED_REG_CR8  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {15, 0,1},
/*h(7)=3 OUTREG=XED_REG_CR0  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {7, 0,0},
/*empty slot1 */ {0,0,0},
/*h(9)=5 OUTREG=XED_REG_CR2  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {9, 2,0},
/*empty slot1 */ {0,0,0},
/*h(11)=7 OUTREG=XED_REG_CR4  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {11, 4,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 10ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_BND_B(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t rm;} lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(5)=0 OUTREG=XED_REG_BND2  ->	FB REXB=0 value=0x0 	FB RM=2 value=0x2*/ {5, 0,2},
/*h(102)=1 OUTREG=XED_REG_ERROR  ->	FB REXB=0 value=0x0 	FB RM=4 value=0x4*/ {102, 0,4},
/*h(4)=2 OUTREG=XED_REG_BND1  ->	FB REXB=0 value=0x0 	FB RM=1 value=0x1*/ {4, 0,1},
/*h(6)=3 OUTREG=XED_REG_BND3  ->	FB REXB=0 value=0x0 	FB RM=3 value=0x3*/ {6, 0,3},
/*h(3)=4 OUTREG=XED_REG_BND0  ->	FB REXB=0 value=0x0 	FB RM=0 value=0x0*/ {3, 0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (3*key % 5);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_SEG_MOV(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t reg;} lu_entry_t;
static const lu_entry_t lu_table[12] = {
/*h(102)=0 OUTREG=XED_REG_ERROR  ->	FB REG=6 value=0x6*/ {102, 6},
/*h(149)=1 OUTREG=XED_REG_ES  ->	FB REG=0 value=0x0*/ {149, 0},
/*empty slot1 */ {0,0},
/*h(151)=3 OUTREG=XED_REG_FS  ->	FB REG=4 value=0x4*/ {151, 4},
/*empty slot1 */ {0,0},
/*h(148)=5 OUTREG=XED_REG_DS  ->	FB REG=3 value=0x3*/ {148, 3},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(150)=8 OUTREG=XED_REG_SS  ->	FB REG=2 value=0x2*/ {150, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(152)=11 OUTREG=XED_REG_GS  ->	FB REG=5 value=0x5*/ {152, 5}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 12ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_ZMM_R3(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_ntluf_func_ptr_t ntlufptr0;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	ntluf*/ {xed_encode_ntluf_ZMM_R3_32},
/*h(1)=1 MODE=1  ->	ntluf*/ {xed_encode_ntluf_ZMM_R3_32},
/*h(2)=2 MODE=2  ->	ntluf*/ {xed_encode_ntluf_ZMM_R3_64}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].ntlufptr0 != 0) res=(*lu_table[hidx].ntlufptr0)(xes,arg_reg);
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_GPR8_SB(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct { xed_int8_t needrex ;xed_int8_t norex ;xed_int8_t rexb ;xed_int8_t srm;} lu_entry_t;
static const lu_entry_t lu_table[20] = {
/*h(82)=0 OUTREG=XED_REG_AL  ->	FB SRM=0 value=0x0*/ {-1,-1,-1,0},
/*h(83)=1 OUTREG=XED_REG_CL  ->	FB SRM=1 value=0x1*/ {-1,-1,-1,1},
/*h(84)=2 OUTREG=XED_REG_DL  ->	FB SRM=2 value=0x2*/ {-1,-1,-1,2},
/*h(85)=3 OUTREG=XED_REG_BL  ->	FB SRM=3 value=0x3*/ {-1,-1,-1,3},
/*h(86)=4 OUTREG=XED_REG_SPL  ->	FB SRM=4 value=0x4 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,4},
/*h(87)=5 OUTREG=XED_REG_BPL  ->	FB SRM=5 value=0x5 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,5},
/*h(88)=6 OUTREG=XED_REG_SIL  ->	FB SRM=6 value=0x6 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,6},
/*h(89)=7 OUTREG=XED_REG_DIL  ->	FB SRM=7 value=0x7 	FB NEEDREX=1 value=0x1*/ {1,-1,-1,7},
/*h(90)=8 OUTREG=XED_REG_R8B  ->	FB REXB=1 value=0x1 	FB SRM=0 value=0x0*/ {-1,-1,1,0},
/*h(91)=9 OUTREG=XED_REG_R9B  ->	FB REXB=1 value=0x1 	FB SRM=1 value=0x1*/ {-1,-1,1,1},
/*h(92)=10 OUTREG=XED_REG_R10B  ->	FB REXB=1 value=0x1 	FB SRM=2 value=0x2*/ {-1,-1,1,2},
/*h(93)=11 OUTREG=XED_REG_R11B  ->	FB REXB=1 value=0x1 	FB SRM=3 value=0x3*/ {-1,-1,1,3},
/*h(94)=12 OUTREG=XED_REG_R12B  ->	FB REXB=1 value=0x1 	FB SRM=4 value=0x4*/ {-1,-1,1,4},
/*h(95)=13 OUTREG=XED_REG_R13B  ->	FB REXB=1 value=0x1 	FB SRM=5 value=0x5*/ {-1,-1,1,5},
/*h(96)=14 OUTREG=XED_REG_R14B  ->	FB REXB=1 value=0x1 	FB SRM=6 value=0x6*/ {-1,-1,1,6},
/*h(97)=15 OUTREG=XED_REG_R15B  ->	FB REXB=1 value=0x1 	FB SRM=7 value=0x7*/ {-1,-1,1,7},
/*h(98)=16 OUTREG=XED_REG_AH  ->	FB SRM=4 value=0x4 	FB NOREX=1 value=0x1*/ {-1,1,-1,4},
/*h(99)=17 OUTREG=XED_REG_CH  ->	FB SRM=5 value=0x5 	FB NOREX=1 value=0x1*/ {-1,1,-1,5},
/*h(100)=18 OUTREG=XED_REG_DH  ->	FB SRM=6 value=0x6 	FB NOREX=1 value=0x1*/ {-1,1,-1,6},
/*h(101)=19 OUTREG=XED_REG_BH  ->	FB SRM=7 value=0x7 	FB NOREX=1 value=0x1*/ {-1,1,-1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = key - 82;
if(hidx <= 19) {
    if(lu_table[hidx].needrex >= 0) xed3_operand_set_needrex(xes,lu_table[hidx].needrex);
    if(lu_table[hidx].norex >= 0) xed3_operand_set_norex(xes,lu_table[hidx].norex);
    if(lu_table[hidx].rexb >= 0) xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_srm(xes,lu_table[hidx].srm);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_BND_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(5)=0 OUTREG=XED_REG_BND2  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {5, 2,0},
/*h(102)=1 OUTREG=XED_REG_ERROR  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {102, 4,0},
/*h(4)=2 OUTREG=XED_REG_BND1  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {4, 1,0},
/*h(6)=3 OUTREG=XED_REG_BND3  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {6, 3,0},
/*h(3)=4 OUTREG=XED_REG_BND0  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {3, 0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_OUTREG(xes);
hidx = (3*key % 5);
if(lu_table[hidx].key == key) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_ntluf_A_GPR_R(xed_encoder_request_t* xes, xed_reg_enum_t arg_reg)
{
typedef struct {xed_uint32_t key; xed_int8_t reg ;xed_int8_t rexr;} lu_entry_t;
static const lu_entry_t lu_table[96] = {
/*h(206)=0 OUTREG=XED_REG_ECX EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {206, 1,0},
/*empty slot1 */ {0,0,0},
/*h(149)=2 OUTREG=XED_REG_BX EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {149, 3,0},
/*h(275)=3 OUTREG=XED_REG_RDX EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {275, 2,0},
/*h(137)=4 OUTREG=XED_REG_AX EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {137, 0,0},
/*h(218)=5 OUTREG=XED_REG_ESP EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {218, 4,0},
/*empty slot1 */ {0,0,0},
/*h(161)=7 OUTREG=XED_REG_SI EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {161, 6,0},
/*h(287)=8 OUTREG=XED_REG_RBP EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {287, 5,0},
/*empty slot1 */ {0,0,0},
/*h(230)=10 OUTREG=XED_REG_EDI EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {230, 7,0},
/*empty slot1 */ {0,0,0},
/*h(173)=12 OUTREG=XED_REG_R9W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {173, 1,1},
/*h(299)=13 OUTREG=XED_REG_R8 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {299, 0,1},
/*empty slot1 */ {0,0,0},
/*h(242)=15 OUTREG=XED_REG_R10D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {242, 2,1},
/*empty slot1 */ {0,0,0},
/*h(185)=17 OUTREG=XED_REG_R12W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {185, 4,1},
/*h(311)=18 OUTREG=XED_REG_R11 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {311, 3,1},
/*empty slot1 */ {0,0,0},
/*h(254)=20 OUTREG=XED_REG_R13D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {254, 5,1},
/*empty slot1 */ {0,0,0},
/*h(197)=22 OUTREG=XED_REG_R15W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {197, 7,1},
/*h(323)=23 OUTREG=XED_REG_R14 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {323, 6,1},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(141)=33 OUTREG=XED_REG_CX EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {141, 1,0},
/*h(267)=34 OUTREG=XED_REG_RAX EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {267, 0,0},
/*empty slot1 */ {0,0,0},
/*h(210)=36 OUTREG=XED_REG_EDX EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {210, 2,0},
/*empty slot1 */ {0,0,0},
/*h(153)=38 OUTREG=XED_REG_SP EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {153, 4,0},
/*h(279)=39 OUTREG=XED_REG_RBX EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {279, 3,0},
/*empty slot1 */ {0,0,0},
/*h(222)=41 OUTREG=XED_REG_EBP EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {222, 5,0},
/*empty slot1 */ {0,0,0},
/*h(165)=43 OUTREG=XED_REG_DI EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {165, 7,0},
/*h(291)=44 OUTREG=XED_REG_RSI EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {291, 6,0},
/*empty slot1 */ {0,0,0},
/*h(234)=46 OUTREG=XED_REG_R8D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {234, 0,1},
/*empty slot1 */ {0,0,0},
/*h(177)=48 OUTREG=XED_REG_R10W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {177, 2,1},
/*h(303)=49 OUTREG=XED_REG_R9 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {303, 1,1},
/*empty slot1 */ {0,0,0},
/*h(246)=51 OUTREG=XED_REG_R11D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {246, 3,1},
/*empty slot1 */ {0,0,0},
/*h(189)=53 OUTREG=XED_REG_R13W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {189, 5,1},
/*h(315)=54 OUTREG=XED_REG_R12 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {315, 4,1},
/*empty slot1 */ {0,0,0},
/*h(258)=56 OUTREG=XED_REG_R14D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {258, 6,1},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(327)=59 OUTREG=XED_REG_R15 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {327, 7,1},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(202)=67 OUTREG=XED_REG_EAX EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=0 value=0x0*/ {202, 0,0},
/*empty slot1 */ {0,0,0},
/*h(145)=69 OUTREG=XED_REG_DX EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=2 value=0x2*/ {145, 2,0},
/*h(271)=70 OUTREG=XED_REG_RCX EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=1 value=0x1*/ {271, 1,0},
/*empty slot1 */ {0,0,0},
/*h(214)=72 OUTREG=XED_REG_EBX EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=3 value=0x3*/ {214, 3,0},
/*empty slot1 */ {0,0,0},
/*h(157)=74 OUTREG=XED_REG_BP EASZ=1  ->	FB REXR=0 value=0x0 	FB REG=5 value=0x5*/ {157, 5,0},
/*h(283)=75 OUTREG=XED_REG_RSP EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=4 value=0x4*/ {283, 4,0},
/*empty slot1 */ {0,0,0},
/*h(226)=77 OUTREG=XED_REG_ESI EASZ=2  ->	FB REXR=0 value=0x0 	FB REG=6 value=0x6*/ {226, 6,0},
/*empty slot1 */ {0,0,0},
/*h(169)=79 OUTREG=XED_REG_R8W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=0 value=0x0*/ {169, 0,1},
/*h(295)=80 OUTREG=XED_REG_RDI EASZ=3  ->	FB REXR=0 value=0x0 	FB REG=7 value=0x7*/ {295, 7,0},
/*empty slot1 */ {0,0,0},
/*h(238)=82 OUTREG=XED_REG_R9D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=1 value=0x1*/ {238, 1,1},
/*empty slot1 */ {0,0,0},
/*h(181)=84 OUTREG=XED_REG_R11W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=3 value=0x3*/ {181, 3,1},
/*h(307)=85 OUTREG=XED_REG_R10 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=2 value=0x2*/ {307, 2,1},
/*empty slot1 */ {0,0,0},
/*h(250)=87 OUTREG=XED_REG_R12D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=4 value=0x4*/ {250, 4,1},
/*empty slot1 */ {0,0,0},
/*h(193)=89 OUTREG=XED_REG_R14W EASZ=1  ->	FB REXR=1 value=0x1 	FB REG=6 value=0x6*/ {193, 6,1},
/*h(319)=90 OUTREG=XED_REG_R13 EASZ=3  ->	FB REXR=1 value=0x1 	FB REG=5 value=0x5*/ {319, 5,1},
/*empty slot1 */ {0,0,0},
/*h(262)=92 OUTREG=XED_REG_R15D EASZ=2  ->	FB REXR=1 value=0x1 	FB REG=7 value=0x7*/ {262, 7,1},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed3_operand_set_outreg(xes,arg_reg);
key = xed_enc_lu_EASZ_OUTREG(xes);
hidx = ((9*key % 103) % 96);
if(lu_table[hidx].key == key) {
    xed3_operand_set_reg(xes,lu_table[hidx].reg);
    xed3_operand_set_rexr(xes,lu_table[hidx].rexr);
    return 1;
}
else{
    return 0;
}
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE1_SUBDWORD_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE1_SUBDWORD()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_UISA_ENC_INDEX_XMM_EMIT(xed_encoder_request_t* xes)
{
/* UISA_ENC_INDEX_XMM()::
	INDEX=XED_REG_XMM0  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_XMM1  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_XMM2  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_XMM3  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_XMM4  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_XMM5  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_XMM6  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_XMM7  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_XMM8  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_XMM9  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_XMM10  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_XMM11  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_XMM12  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_XMM13  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_XMM14  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_XMM15  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_XMM16  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_XMM17  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_XMM18  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_XMM19  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_XMM20  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_XMM21  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_XMM22  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_XMM23  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_XMM24  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_XMM25  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_XMM26  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_XMM27  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_XMM28  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_XMM29  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_XMM30  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_XMM31  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIB_NT_EMIT(xed_encoder_request_t* xes)
{
/* SIB_NT()::
	SIB=1 SIBBASE[bbb]=* SIBSCALE[ss]=* SIBINDEX[iii]=*  ->	emit ss_iii_bbb emit_type=letters nbits=8
	SIB=0  ->	nothing
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SIB_NT;
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_sibscale(xes)<< 6)|(xed3_operand_get_sibindex(xes)<< 3)|(xed3_operand_get_sibbase(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (1) { /* nothing */
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_EIGHTHMEM_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_EIGHTHMEM()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA32_DISP0_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA32_DISP0()::
	BASE0=XED_REG_EAX MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EBX MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_ECX MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EDX MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_ESI MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EDI MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_ESP MODE=1  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EAX MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EBX MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_ECX MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EDX MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_ESI MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EDI MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_ESP MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R8D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R9D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R10D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R11D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R12D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R14D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R15D MODE=2  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EBP MODE=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	BASE0=XED_REG_EBP MODE=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	BASE0=XED_REG_R13D MODE=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_OVERRIDE_SEG1_EMIT(xed_encoder_request_t* xes)
{
/* OVERRIDE_SEG1()::
	SEG1=@  ->	FB SEG_OVD=0 value=0x0
	SEG1=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0
	SEG1=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1
	SEG1=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3
	SEG1=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4
	SEG1=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5
	SEG1=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_OVERRIDE_SEG0_EMIT(xed_encoder_request_t* xes)
{
/* OVERRIDE_SEG0()::
	SEG0=@  ->	FB SEG_OVD=0 value=0x0
	SEG0=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0
	SEG0=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1
	SEG0=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3
	SEG0=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4
	SEG0=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5
	SEG0=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIBBASE_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* SIBBASE_ENCODE()::
	SIB=1  ->	nt NT[SIBBASE_ENCODE_SIB1]
	SIB=0  ->	nothing
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SIBBASE_ENCODE;
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_SIBBASE_ENCODE_SIB1_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (1) { /* nothing */
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_VEX_ESCVL_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VEX_ESCVL_ENC()::
	VL=0 VEX_PREFIX=0  ->	emit 0b000 emit_type=numeric value=0x0 nbits=3
	VL=0 VEX_PREFIX=1  ->	emit 0b001 emit_type=numeric value=0x1 nbits=3
	VL=0 VEX_PREFIX=3  ->	emit 0b010 emit_type=numeric value=0x2 nbits=3
	VL=0 VEX_PREFIX=2  ->	emit 0b011 emit_type=numeric value=0x3 nbits=3
	VL=1 VEX_PREFIX=0  ->	emit 0b100 emit_type=numeric value=0x4 nbits=3
	VL=1 VEX_PREFIX=1  ->	emit 0b101 emit_type=numeric value=0x5 nbits=3
	VL=1 VEX_PREFIX=3  ->	emit 0b110 emit_type=numeric value=0x6 nbits=3
	VL=1 VEX_PREFIX=2  ->	emit 0b111 emit_type=numeric value=0x7 nbits=3
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEX_ESCVL_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,3,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,3,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,3,0x2);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,3,0x3);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,3,0x4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 6 */ if (iform==6) {
    xed_encoder_request_encode_emit(xes,3,0x5);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 8 */ if (iform==8) {
    xed_encoder_request_encode_emit(xes,3,0x6);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    xed_encoder_request_encode_emit(xes,3,0x7);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_SIBSCALE_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* SIBSCALE_ENCODE()::
	SIB=1 SCALE=0  ->	FB SIBSCALE=0 value=0x0
	SIB=1 SCALE=1  ->	FB SIBSCALE=0 value=0x0
	SIB=1 SCALE=2  ->	FB SIBSCALE=1 value=0x1
	SIB=1 SCALE=4  ->	FB SIBSCALE=2 value=0x2
	SIB=1 SCALE=8  ->	FB SIBSCALE=3 value=0x3
	SIB=0  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE1_4X_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE1_4X()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_OSZ_NONTERM_ENC_EMIT(xed_encoder_request_t* xes)
{
/* OSZ_NONTERM_ENC()::
	MODE=0 EOSZ=2 DF32=0 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1
	MODE=1 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1
	MODE=2 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1
	MODE=2 EOSZ=3 DF64=0 SKIP_OSZ=0  ->	FB REXW=1 value=0x1
	MODE=0 EOSZ=1  ->	nothing
	MODE=0 EOSZ=2 DF32=1  ->	nothing
	MODE=0 EOSZ=2 DF32=0 SKIP_OSZ=1  ->	nothing
	MODE=1 EOSZ=1 SKIP_OSZ=1  ->	nothing
	MODE=1 EOSZ=2  ->	nothing
	MODE=2 EOSZ=1 SKIP_OSZ=1  ->	nothing
	MODE=2 EOSZ=2 DF64=0  ->	nothing
	MODE=2 EOSZ=3 DF64=1  ->	nothing
	MODE=2 EOSZ=3 DF64=0 SKIP_OSZ=1  ->	nothing
	MODE=2 EOSZ=2 DF64=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA32_DISP8_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA32_DISP8()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_REMOVE_SEGMENT_EMIT(xed_encoder_request_t* xes)
{
/* REMOVE_SEGMENT()::
	AGEN=1  ->	nt NT[REMOVE_SEGMENT_AGEN1]
	AGEN=0  ->	nothing
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_REMOVE_SEGMENT;
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_REMOVE_SEGMENT_AGEN1_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (1) { /* nothing */
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_BRANCH_HINT_EMIT(xed_encoder_request_t* xes)
{
/* BRANCH_HINT()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_FULL_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_FULL()::
	BCAST!=0  ->	FB BCRC=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VEX_REG_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VEX_REG_ENC()::
	MODE=2 VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit u_ddd emit_type=letters nbits=4
	MODE!=2 VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit 1_ddd emit_type=letters nbits=4
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEX_REG_ENC;
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_vexdest3(xes)<< 3)|(xed3_operand_get_vexdest210(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,4,  (1 << 3)|  (((xed3_operand_get_vexdest210(xes) >> 2) & 1) << 2)|  (((xed3_operand_get_vexdest210(xes) >> 1) & 1) << 1)| (xed3_operand_get_vexdest210(xes) & 1) );
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE8_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE8()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_0_8_32()::
	DISP_WIDTH=0  ->	nothing
	DISP_WIDTH=8  ->	nothing
	DISP_WIDTH=32  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE4_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE4()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_8_32()::
	DISP_WIDTH=8  ->	nothing
	DISP_WIDTH=32  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_HALFMEM_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_HALFMEM()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SAE_EMIT(xed_encoder_request_t* xes)
{
/* SAE()::
	SAE=1  ->	FB BCRC=1 value=0x1
	SAE=0  ->	FB BCRC=0 value=0x0
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA16_DISP0_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA16_DISP0()::
	BASE0=XED_REG_BX INDEX=@  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_SI INDEX=@  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_DI INDEX=@  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_BP INDEX=@  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_AVX512_ROUND_EMIT(xed_encoder_request_t* xes)
{
/* AVX512_ROUND()::
	ROUNDC=1  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1
	ROUNDC=2  ->	FB LLRC=1 value=0x1 	FB BCRC=1 value=0x1
	ROUNDC=3  ->	FB LLRC=2 value=0x2 	FB BCRC=1 value=0x1
	ROUNDC=4  ->	FB LLRC=3 value=0x3 	FB BCRC=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_ESIZE_128_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_128_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VSIB_ENC_INDEX_XMM_EMIT(xed_encoder_request_t* xes)
{
/* VSIB_ENC_INDEX_XMM()::
	INDEX=XED_REG_XMM0  ->	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_XMM1  ->	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_XMM2  ->	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_XMM3  ->	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_XMM4  ->	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_XMM5  ->	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_XMM6  ->	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_XMM7  ->	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_XMM8  ->	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_XMM9  ->	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_XMM10  ->	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_XMM11  ->	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_XMM12  ->	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_XMM13  ->	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_XMM14  ->	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_XMM15  ->	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_EVEX_LL_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_LL_ENC()::
	ROUNDC=0 SAE=0 VL=0  ->	FB LLRC=0 value=0x0
	ROUNDC=0 SAE=0 VL=1  ->	FB LLRC=1 value=0x1
	ROUNDC=0 SAE=0 VL=2  ->	FB LLRC=2 value=0x2
	ROUNDC=0 SAE=1 VL=0  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1
	ROUNDC=1 SAE=1 VL=0  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1
	ROUNDC=2 SAE=1 VL=0  ->	FB LLRC=1 value=0x1 	FB BCRC=1 value=0x1
	ROUNDC=3 SAE=1 VL=0  ->	FB LLRC=2 value=0x2 	FB BCRC=1 value=0x1
	ROUNDC=4 SAE=1 VL=0  ->	FB LLRC=3 value=0x3 	FB BCRC=1 value=0x1
	ROUNDC=0 SAE=1 VL=2  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1
	ROUNDC=1 SAE=1 VL=2  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1
	ROUNDC=2 SAE=1 VL=2  ->	FB LLRC=1 value=0x1 	FB BCRC=1 value=0x1
	ROUNDC=3 SAE=1 VL=2  ->	FB LLRC=2 value=0x2 	FB BCRC=1 value=0x1
	ROUNDC=4 SAE=1 VL=2  ->	FB LLRC=3 value=0x3 	FB BCRC=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_ESIZE_2_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_2_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_READER_BYTE_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_READER_BYTE()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_RM_ENCODE_EA32_SIB0_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_RM_ENCODE_EA32_SIB0()::
	BASE0=XED_REG_RIP MODE=2  ->	FB RM=5 value=0x5
	BASE0=XED_REG_EIP MODE=2  ->	FB RM=5 value=0x5
	BASE0=XED_REG_EAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0
	BASE0=XED_REG_R8D  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1
	BASE0=XED_REG_ECX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0
	BASE0=XED_REG_R9D  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1
	BASE0=XED_REG_EDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0
	BASE0=XED_REG_R10D  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1
	BASE0=XED_REG_EBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0
	BASE0=XED_REG_R11D  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1
	BASE0=XED_REG_ESI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0
	BASE0=XED_REG_R14D  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1
	BASE0=XED_REG_EDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0
	BASE0=XED_REG_R15D  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1
	BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5
	BASE0=XED_REG_EBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0
	BASE0=XED_REG_R13D  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE_EA32_SIB0;
/* 66 */ if (iform==66) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 73 */ if (iform==73) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 21 */ if (iform==21) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 81 */ if (iform==81) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 28 */ if (iform==28) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 86 */ if (iform==86) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 37 */ if (iform==37) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 89 */ if (iform==89) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 46 */ if (iform==46) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 98 */ if (iform==98) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 63 */ if (iform==63) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 117 */ if (iform==117) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 68 */ if (iform==68) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 36 */ if (iform==36) {
    xed_encode_nonterminal_DISP_WIDTH_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 58 */ if (iform==58) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 110 */ if (iform==110) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_IMMUNE_REXW_EMIT(xed_encoder_request_t* xes)
{
/* IMMUNE_REXW()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA16_DISP16_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA16_DISP16()::
	BASE0=@ INDEX=@  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_BX INDEX=@  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_SI INDEX=@  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_DI INDEX=@  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_BP INDEX=@  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB MOD=2 value=0x2
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_IGNORE66_EMIT(xed_encoder_request_t* xes)
{
/* IGNORE66()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_IMMUNE66_LOOP64_EMIT(xed_encoder_request_t* xes)
{
/* IMMUNE66_LOOP64()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_READER_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_READER()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_DF64_EMIT(xed_encoder_request_t* xes)
{
/* DF64()::
	MODE=2  ->	FB DF64=1 value=0x1
	MODE=0  ->	nothing
	MODE=1  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA64_DISP32_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA64_DISP32()::
	BASE0=@  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EIP  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RIP  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RAX  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RBX  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RCX  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RDX  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RSI  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RDI  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RSP  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_RBP  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R8  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R9  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R10  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R11  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R12  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R13  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R14  ->	FB MOD=2 value=0x2
	BASE0=XED_REG_R15  ->	FB MOD=2 value=0x2
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_ESIZE_4_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_4_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_REX_PREFIX_ENC_BIND(xed_encoder_request_t* xes)
{
/* REX_PREFIX_ENC()::
	MODE=2 NOREX=0 NEEDREX=1 REXW[w]=* REXB[b]=* REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REX=1 REXW[w]=* REXB[b]=* REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=1 REXB[b]=* REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=* REXB[b]=1 REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=* REXB[b]=* REXX[x]=1 REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=* REXB[b]=* REXX[x]=* REXR[r]=1  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NEEDREX=0 REX=0 REXW=0 REXB=0 REXX=0 REXR=0  ->	nothing
	MODE=1 REX=0 REXW=0 REXB=0 REXX=0 REXR=0  ->	nothing
	MODE=0 REX=0 REXW=0 REXB=0 REXX=0 REXR=0  ->	nothing
	MODE=2 NOREX=1 NEEDREX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXW=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
xed_uint_t conditions_satisfied=0;
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 0) &&
		 (xed3_operand_get_needrex(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC=1;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 0) &&
		 (xed3_operand_get_rex(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC=2;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 0) &&
		 (xed3_operand_get_rexw(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC=3;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 0) &&
		 (xed3_operand_get_rexb(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC=4;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 0) &&
		 (xed3_operand_get_rexx(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC=5;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 0) &&
		 (xed3_operand_get_rexr(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC=6;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_needrex(xes) == 0) &&
		 (xed3_operand_get_rex(xes) == 0) &&
		 (xed3_operand_get_rexw(xes) == 0) &&
		 (xed3_operand_get_rexb(xes) == 0) &&
		 (xed3_operand_get_rexx(xes) == 0) &&
		 (xed3_operand_get_rexr(xes) == 0);
if (conditions_satisfied) {
    okay=1;
    return 1; /* nothing */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_rex(xes) == 0) &&
		 (xed3_operand_get_rexw(xes) == 0) &&
		 (xed3_operand_get_rexb(xes) == 0) &&
		 (xed3_operand_get_rexx(xes) == 0) &&
		 (xed3_operand_get_rexr(xes) == 0);
if (conditions_satisfied) {
    okay=1;
    return 1; /* nothing */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 0) &&
		 (xed3_operand_get_rex(xes) == 0) &&
		 (xed3_operand_get_rexw(xes) == 0) &&
		 (xed3_operand_get_rexb(xes) == 0) &&
		 (xed3_operand_get_rexx(xes) == 0) &&
		 (xed3_operand_get_rexr(xes) == 0);
if (conditions_satisfied) {
    okay=1;
    return 1; /* nothing */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 1) &&
		 (xed3_operand_get_needrex(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 1) &&
		 (xed3_operand_get_rex(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 1) &&
		 (xed3_operand_get_rexw(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 1) &&
		 (xed3_operand_get_rexb(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 1) &&
		 (xed3_operand_get_rexx(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_norex(xes) == 1) &&
		 (xed3_operand_get_rexr(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
    if (okay) return 1;
}
conditions_satisfied = 1;
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
/* FIXME action code not done yet for return 1*/
    if (okay) return 1;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) conditions_satisfied;
}
