/// @file xed-exception-enum.c

// This file was automatically generated.
// Do not edit this file.

#include <string.h>
#include <assert.h>
#include "xed-exception-enum.h"

typedef struct {
    const char* name;
    xed_exception_enum_t value;
} name_table_xed_exception_enum_t;
static const name_table_xed_exception_enum_t name_array_xed_exception_enum_t[] = {
{"INVALID", XED_EXCEPTION_INVALID},
{"AVX512_E1", XED_EXCEPTION_AVX512_E1},
{"AVX512_E10", XED_EXCEPTION_AVX512_E10},
{"AVX512_E10NF", XED_EXCEPTION_AVX512_E10NF},
{"AVX512_E11", XED_EXCEPTION_AVX512_E11},
{"AVX512_E11NF", XED_EXCEPTION_AVX512_E11NF},
{"AVX512_E12", XED_EXCEPTION_AVX512_E12},
{"AVX512_E12NP", XED_EXCEPTION_AVX512_E12NP},
{"AVX512_E1NF", XED_EXCEPTION_AVX512_E1NF},
{"AVX512_E2", XED_EXCEPTION_AVX512_E2},
{"AVX512_E3", XED_EXCEPTION_AVX512_E3},
{"AVX512_E3NF", XED_EXCEPTION_AVX512_E3NF},
{"AVX512_E4", XED_EXCEPTION_AVX512_E4},
{"AVX512_E4NF", XED_EXCEPTION_AVX512_E4NF},
{"AVX512_E5", XED_EXCEPTION_AVX512_E5},
{"AVX512_E5NF", XED_EXCEPTION_AVX512_E5NF},
{"AVX512_E6", XED_EXCEPTION_AVX512_E6},
{"AVX512_E6NF", XED_EXCEPTION_AVX512_E6NF},
{"AVX512_E7NM", XED_EXCEPTION_AVX512_E7NM},
{"AVX512_E7NM128", XED_EXCEPTION_AVX512_E7NM128},
{"AVX512_E9NF", XED_EXCEPTION_AVX512_E9NF},
{"AVX512_K20", XED_EXCEPTION_AVX512_K20},
{"AVX512_K21", XED_EXCEPTION_AVX512_K21},
{"AVX_TYPE_1", XED_EXCEPTION_AVX_TYPE_1},
{"AVX_TYPE_11", XED_EXCEPTION_AVX_TYPE_11},
{"AVX_TYPE_12", XED_EXCEPTION_AVX_TYPE_12},
{"AVX_TYPE_2", XED_EXCEPTION_AVX_TYPE_2},
{"AVX_TYPE_2D", XED_EXCEPTION_AVX_TYPE_2D},
{"AVX_TYPE_3", XED_EXCEPTION_AVX_TYPE_3},
{"AVX_TYPE_4", XED_EXCEPTION_AVX_TYPE_4},
{"AVX_TYPE_4M", XED_EXCEPTION_AVX_TYPE_4M},
{"AVX_TYPE_5", XED_EXCEPTION_AVX_TYPE_5},
{"AVX_TYPE_5L", XED_EXCEPTION_AVX_TYPE_5L},
{"AVX_TYPE_6", XED_EXCEPTION_AVX_TYPE_6},
{"AVX_TYPE_7", XED_EXCEPTION_AVX_TYPE_7},
{"AVX_TYPE_8", XED_EXCEPTION_AVX_TYPE_8},
{"MMX_FP", XED_EXCEPTION_MMX_FP},
{"MMX_FP_16ALIGN", XED_EXCEPTION_MMX_FP_16ALIGN},
{"MMX_MEM", XED_EXCEPTION_MMX_MEM},
{"MMX_NOFP", XED_EXCEPTION_MMX_NOFP},
{"MMX_NOFP2", XED_EXCEPTION_MMX_NOFP2},
{"MMX_NOMEM", XED_EXCEPTION_MMX_NOMEM},
{"SSE_TYPE_1", XED_EXCEPTION_SSE_TYPE_1},
{"SSE_TYPE_2", XED_EXCEPTION_SSE_TYPE_2},
{"SSE_TYPE_2D", XED_EXCEPTION_SSE_TYPE_2D},
{"SSE_TYPE_3", XED_EXCEPTION_SSE_TYPE_3},
{"SSE_TYPE_4", XED_EXCEPTION_SSE_TYPE_4},
{"SSE_TYPE_4M", XED_EXCEPTION_SSE_TYPE_4M},
{"SSE_TYPE_5", XED_EXCEPTION_SSE_TYPE_5},
{"SSE_TYPE_7", XED_EXCEPTION_SSE_TYPE_7},
{"LAST", XED_EXCEPTION_LAST},
{0, XED_EXCEPTION_LAST},
};

        
xed_exception_enum_t str2xed_exception_enum_t(const char* s)
{
   const name_table_xed_exception_enum_t* p = name_array_xed_exception_enum_t;
   while( p->name ) {
     if (strcmp(p->name,s) == 0) {
      return p->value;
     }
     p++;
   }
        

   return XED_EXCEPTION_INVALID;
}


const char* xed_exception_enum_t2str(const xed_exception_enum_t p)
{
   xed_exception_enum_t type_idx = p;
   if ( p > XED_EXCEPTION_LAST) type_idx = XED_EXCEPTION_LAST;
   return name_array_xed_exception_enum_t[type_idx].name;
}

xed_exception_enum_t xed_exception_enum_t_last(void) {
    return XED_EXCEPTION_LAST;
}
       
/*

Here is a skeleton switch statement embedded in a comment


  switch(p) {
  case XED_EXCEPTION_INVALID:
  case XED_EXCEPTION_AVX512_E1:
  case XED_EXCEPTION_AVX512_E10:
  case XED_EXCEPTION_AVX512_E10NF:
  case XED_EXCEPTION_AVX512_E11:
  case XED_EXCEPTION_AVX512_E11NF:
  case XED_EXCEPTION_AVX512_E12:
  case XED_EXCEPTION_AVX512_E12NP:
  case XED_EXCEPTION_AVX512_E1NF:
  case XED_EXCEPTION_AVX512_E2:
  case XED_EXCEPTION_AVX512_E3:
  case XED_EXCEPTION_AVX512_E3NF:
  case XED_EXCEPTION_AVX512_E4:
  case XED_EXCEPTION_AVX512_E4NF:
  case XED_EXCEPTION_AVX512_E5:
  case XED_EXCEPTION_AVX512_E5NF:
  case XED_EXCEPTION_AVX512_E6:
  case XED_EXCEPTION_AVX512_E6NF:
  case XED_EXCEPTION_AVX512_E7NM:
  case XED_EXCEPTION_AVX512_E7NM128:
  case XED_EXCEPTION_AVX512_E9NF:
  case XED_EXCEPTION_AVX512_K20:
  case XED_EXCEPTION_AVX512_K21:
  case XED_EXCEPTION_AVX_TYPE_1:
  case XED_EXCEPTION_AVX_TYPE_11:
  case XED_EXCEPTION_AVX_TYPE_12:
  case XED_EXCEPTION_AVX_TYPE_2:
  case XED_EXCEPTION_AVX_TYPE_2D:
  case XED_EXCEPTION_AVX_TYPE_3:
  case XED_EXCEPTION_AVX_TYPE_4:
  case XED_EXCEPTION_AVX_TYPE_4M:
  case XED_EXCEPTION_AVX_TYPE_5:
  case XED_EXCEPTION_AVX_TYPE_5L:
  case XED_EXCEPTION_AVX_TYPE_6:
  case XED_EXCEPTION_AVX_TYPE_7:
  case XED_EXCEPTION_AVX_TYPE_8:
  case XED_EXCEPTION_MMX_FP:
  case XED_EXCEPTION_MMX_FP_16ALIGN:
  case XED_EXCEPTION_MMX_MEM:
  case XED_EXCEPTION_MMX_NOFP:
  case XED_EXCEPTION_MMX_NOFP2:
  case XED_EXCEPTION_MMX_NOMEM:
  case XED_EXCEPTION_SSE_TYPE_1:
  case XED_EXCEPTION_SSE_TYPE_2:
  case XED_EXCEPTION_SSE_TYPE_2D:
  case XED_EXCEPTION_SSE_TYPE_3:
  case XED_EXCEPTION_SSE_TYPE_4:
  case XED_EXCEPTION_SSE_TYPE_4M:
  case XED_EXCEPTION_SSE_TYPE_5:
  case XED_EXCEPTION_SSE_TYPE_7:
  case XED_EXCEPTION_LAST:
  default:
     xed_assert(0);
  }
*/
