/// @file xed-init-inst-table-data.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-inst-defs.h"
const xed_inst_t xed_inst_table[XED_MAX_INST_TABLE_NODES] = {
/*   0*/ XED_DEF_INST(XED_ICLASS_INVALID,XED_CATEGORY_INVALID,XED_EXTENSION_INVALID,3,XED_IFORM_INVALID,0,0,0,0,0,XED_EXCEPTION_INVALID),
/*   1*/ XED_DEF_INST(XED_ICLASS_SLDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SLDT_MEMw,58,2,0,0,1,XED_EXCEPTION_INVALID),
/*   2*/ XED_DEF_INST(XED_ICLASS_SLDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SLDT_GPRv,60,2,0,0,2,XED_EXCEPTION_INVALID),
/*   3*/ XED_DEF_INST(XED_ICLASS_POPA,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POPA,62,10,0,0,3,XED_EXCEPTION_INVALID),
/*   4*/ XED_DEF_INST(XED_ICLASS_UNPCKHPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_UNPCKHPS_XMMps_MEMdq,72,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*   5*/ XED_DEF_INST(XED_ICLASS_UNPCKHPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_UNPCKHPS_XMMps_XMMdq,74,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*   6*/ XED_DEF_INST(XED_ICLASS_POPF,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POPF,76,4,1,0,5,XED_EXCEPTION_INVALID),
/*   7*/ XED_DEF_INST(XED_ICLASS_LGDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_LGDT_MEMs64,80,2,0,0,6,XED_EXCEPTION_INVALID),
/*   8*/ XED_DEF_INST(XED_ICLASS_LGDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_LGDT_MEMs,82,2,0,0,7,XED_EXCEPTION_INVALID),
/*   9*/ XED_DEF_INST(XED_ICLASS_PFPNACC,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFPNACC_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*  10*/ XED_DEF_INST(XED_ICLASS_PFPNACC,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFPNACC_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*  11*/ XED_DEF_INST(XED_ICLASS_INVLPGA,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,0,XED_IFORM_INVLPGA_OrAX_ECX,88,2,0,0,9,XED_EXCEPTION_INVALID),
/*  12*/ XED_DEF_INST(XED_ICLASS_XRSTORS64,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVES,0,XED_IFORM_XRSTORS64_MEMmxsave,90,4,0,0,10,XED_EXCEPTION_INVALID),
/*  13*/ XED_DEF_INST(XED_ICLASS_UNPCKHPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_UNPCKHPD_XMMpd_MEMdq,94,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*  14*/ XED_DEF_INST(XED_ICLASS_UNPCKHPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_UNPCKHPD_XMMpd_XMMq,96,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*  15*/ XED_DEF_INST(XED_ICLASS_CALL_NEAR,XED_CATEGORY_CALL,XED_EXTENSION_BASE,3,XED_IFORM_CALL_NEAR_MEMv,98,5,0,0,11,XED_EXCEPTION_INVALID),
/*  16*/ XED_DEF_INST(XED_ICLASS_CALL_NEAR,XED_CATEGORY_CALL,XED_EXTENSION_BASE,3,XED_IFORM_CALL_NEAR_GPRv,103,5,0,0,12,XED_EXCEPTION_INVALID),
/*  17*/ XED_DEF_INST(XED_ICLASS_CALL_NEAR,XED_CATEGORY_CALL,XED_EXTENSION_BASE,3,XED_IFORM_CALL_NEAR_RELBRz,108,5,0,0,13,XED_EXCEPTION_INVALID),
/*  18*/ XED_DEF_INST(XED_ICLASS_CALL_NEAR,XED_CATEGORY_CALL,XED_EXTENSION_BASE,3,XED_IFORM_CALL_NEAR_RELBRd,113,5,0,0,13,XED_EXCEPTION_INVALID),
/*  19*/ XED_DEF_INST(XED_ICLASS_PFSUB,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFSUB_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*  20*/ XED_DEF_INST(XED_ICLASS_PFSUB,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFSUB_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*  21*/ XED_DEF_INST(XED_ICLASS_ARPL,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_ARPL_MEMw_GPR16,118,3,2,0,14,XED_EXCEPTION_INVALID),
/*  22*/ XED_DEF_INST(XED_ICLASS_ARPL,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_ARPL_GPR16_GPR16,121,3,2,0,14,XED_EXCEPTION_INVALID),
/*  23*/ XED_DEF_INST(XED_ICLASS_FICOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FICOMP_ST0_MEMmem32int,124,4,3,0,6,XED_EXCEPTION_INVALID),
/*  24*/ XED_DEF_INST(XED_ICLASS_FICOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FICOMP_ST0_MEMmem16int,128,4,3,0,6,XED_EXCEPTION_INVALID),
/*  25*/ XED_DEF_INST(XED_ICLASS_MOV_DR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_DR_DR_GPR32,132,2,0,0,15,XED_EXCEPTION_INVALID),
/*  26*/ XED_DEF_INST(XED_ICLASS_MOV_DR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_DR_DR_GPR64,134,2,0,0,15,XED_EXCEPTION_INVALID),
/*  27*/ XED_DEF_INST(XED_ICLASS_MOV_DR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_DR_GPR32_DR,136,2,0,0,16,XED_EXCEPTION_INVALID),
/*  28*/ XED_DEF_INST(XED_ICLASS_MOV_DR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_DR_GPR64_DR,138,2,0,0,16,XED_EXCEPTION_INVALID),
/*  29*/ XED_DEF_INST(XED_ICLASS_FCHS,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCHS,140,2,4,0,6,XED_EXCEPTION_INVALID),
/*  30*/ XED_DEF_INST(XED_ICLASS_OUTSW,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_OUTSW,142,4,5,0,17,XED_EXCEPTION_INVALID),
/*  31*/ XED_DEF_INST(XED_ICLASS_PUNPCKHDQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKHDQ_MMXq_MEMq,84,2,0,0,18,XED_EXCEPTION_MMX_MEM),
/*  32*/ XED_DEF_INST(XED_ICLASS_PUNPCKHDQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKHDQ_MMXq_MMXd,146,2,0,0,18,XED_EXCEPTION_MMX_MEM),
/*  33*/ XED_DEF_INST(XED_ICLASS_PUNPCKHDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHDQ_XMMdq_MEMdq,148,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*  34*/ XED_DEF_INST(XED_ICLASS_PUNPCKHDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHDQ_XMMdq_XMMq,150,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*  35*/ XED_DEF_INST(XED_ICLASS_FUCOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FUCOM_ST0_X87,152,3,3,0,6,XED_EXCEPTION_INVALID),
/*  36*/ XED_DEF_INST(XED_ICLASS_OUTSB,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_OUTSB,155,4,5,0,19,XED_EXCEPTION_INVALID),
/*  37*/ XED_DEF_INST(XED_ICLASS_OUTSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_OUTSD,159,4,5,0,17,XED_EXCEPTION_INVALID),
/*  38*/ XED_DEF_INST(XED_ICLASS_OUTSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_OUTSD,159,4,5,0,17,XED_EXCEPTION_INVALID),
/*  39*/ XED_DEF_INST(XED_ICLASS_JNLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNLE_RELBRb,163,3,6,0,20,XED_EXCEPTION_INVALID),
/*  40*/ XED_DEF_INST(XED_ICLASS_JNLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNLE_RELBRb,166,3,6,0,20,XED_EXCEPTION_INVALID),
/*  41*/ XED_DEF_INST(XED_ICLASS_JNLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNLE_RELBRz,169,3,6,0,21,XED_EXCEPTION_INVALID),
/*  42*/ XED_DEF_INST(XED_ICLASS_JNLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNLE_RELBRd,172,3,6,0,20,XED_EXCEPTION_INVALID),
/*  43*/ XED_DEF_INST(XED_ICLASS_WRMSR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_WRMSR,175,4,0,0,15,XED_EXCEPTION_INVALID),
/*  44*/ XED_DEF_INST(XED_ICLASS_PFMAX,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFMAX_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*  45*/ XED_DEF_INST(XED_ICLASS_PFMAX,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFMAX_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*  46*/ XED_DEF_INST(XED_ICLASS_REPE_SCASW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPE_SCASW,179,5,7,0,22,XED_EXCEPTION_INVALID),
/*  47*/ XED_DEF_INST(XED_ICLASS_REPE_SCASQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REPE_SCASQ,184,5,7,0,22,XED_EXCEPTION_INVALID),
/*  48*/ XED_DEF_INST(XED_ICLASS_MOVNTI,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVNTI_MEMd_GPR32,189,2,0,0,23,XED_EXCEPTION_INVALID),
/*  49*/ XED_DEF_INST(XED_ICLASS_MOVNTI,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVNTI_MEMq_GPR64,191,2,0,0,23,XED_EXCEPTION_INVALID),
/*  50*/ XED_DEF_INST(XED_ICLASS_PFCMPGT,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCMPGT_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*  51*/ XED_DEF_INST(XED_ICLASS_PFCMPGT,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCMPGT_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*  52*/ XED_DEF_INST(XED_ICLASS_CLWB,XED_CATEGORY_CLWB,XED_EXTENSION_CLWB,3,XED_IFORM_CLWB_MEMmprefetch,193,1,0,0,24,XED_EXCEPTION_INVALID),
/*  53*/ XED_DEF_INST(XED_ICLASS_REPE_SCASD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPE_SCASD,194,5,7,0,22,XED_EXCEPTION_INVALID),
/*  54*/ XED_DEF_INST(XED_ICLASS_REPE_SCASB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPE_SCASB,199,5,7,0,25,XED_EXCEPTION_INVALID),
/*  55*/ XED_DEF_INST(XED_ICLASS_PFCMPGE,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCMPGE_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*  56*/ XED_DEF_INST(XED_ICLASS_PFCMPGE,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCMPGE_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*  57*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_BND_BND,204,2,0,0,0,XED_EXCEPTION_INVALID),
/*  58*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_BND_MEMq,206,2,0,0,0,XED_EXCEPTION_INVALID),
/*  59*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_BND_MEMq,206,2,0,0,0,XED_EXCEPTION_INVALID),
/*  60*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_BND_MEMdq,208,2,0,0,0,XED_EXCEPTION_INVALID),
/*  61*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_BND_BND,210,2,0,0,0,XED_EXCEPTION_INVALID),
/*  62*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_MEMq_BND,212,2,0,0,0,XED_EXCEPTION_INVALID),
/*  63*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_MEMq_BND,212,2,0,0,0,XED_EXCEPTION_INVALID),
/*  64*/ XED_DEF_INST(XED_ICLASS_BNDMOV,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMOV_MEMdq_BND,214,2,0,0,0,XED_EXCEPTION_INVALID),
/*  65*/ XED_DEF_INST(XED_ICLASS_CVTDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTDQ2PD_XMMpd_MEMq,216,2,0,0,26,XED_EXCEPTION_SSE_TYPE_5),
/*  66*/ XED_DEF_INST(XED_ICLASS_CVTDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTDQ2PD_XMMpd_XMMq,218,2,0,0,26,XED_EXCEPTION_SSE_TYPE_5),
/*  67*/ XED_DEF_INST(XED_ICLASS_POPCNT,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_POPCNT_GPRv_MEMv,220,3,8,0,27,XED_EXCEPTION_INVALID),
/*  68*/ XED_DEF_INST(XED_ICLASS_POPCNT,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_POPCNT_GPRv_GPRv,223,3,8,0,27,XED_EXCEPTION_INVALID),
/*  69*/ XED_DEF_INST(XED_ICLASS_MOVNTQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVNTQ_MEMq_MMXq,226,2,0,0,28,XED_EXCEPTION_MMX_NOFP2),
/*  70*/ XED_DEF_INST(XED_ICLASS_JNS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNS_RELBRb,163,3,9,0,20,XED_EXCEPTION_INVALID),
/*  71*/ XED_DEF_INST(XED_ICLASS_JNS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNS_RELBRb,166,3,9,0,20,XED_EXCEPTION_INVALID),
/*  72*/ XED_DEF_INST(XED_ICLASS_JNS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNS_RELBRz,169,3,9,0,21,XED_EXCEPTION_INVALID),
/*  73*/ XED_DEF_INST(XED_ICLASS_JNS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNS_RELBRd,172,3,9,0,20,XED_EXCEPTION_INVALID),
/*  74*/ XED_DEF_INST(XED_ICLASS_JL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JL_RELBRb,163,3,10,0,20,XED_EXCEPTION_INVALID),
/*  75*/ XED_DEF_INST(XED_ICLASS_JL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JL_RELBRb,166,3,10,0,20,XED_EXCEPTION_INVALID),
/*  76*/ XED_DEF_INST(XED_ICLASS_JL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JL_RELBRz,169,3,10,0,21,XED_EXCEPTION_INVALID),
/*  77*/ XED_DEF_INST(XED_ICLASS_JL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JL_RELBRd,172,3,10,0,20,XED_EXCEPTION_INVALID),
/*  78*/ XED_DEF_INST(XED_ICLASS_JNP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNP_RELBRb,163,3,11,0,20,XED_EXCEPTION_INVALID),
/*  79*/ XED_DEF_INST(XED_ICLASS_JNP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNP_RELBRb,166,3,11,0,20,XED_EXCEPTION_INVALID),
/*  80*/ XED_DEF_INST(XED_ICLASS_JNP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNP_RELBRz,169,3,11,0,21,XED_EXCEPTION_INVALID),
/*  81*/ XED_DEF_INST(XED_ICLASS_JNP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNP_RELBRd,172,3,11,0,20,XED_EXCEPTION_INVALID),
/*  82*/ XED_DEF_INST(XED_ICLASS_PMOVZXBQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXBQ_XMMdq_MEMw,228,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*  83*/ XED_DEF_INST(XED_ICLASS_PMOVZXBQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXBQ_XMMdq_XMMw,230,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*  84*/ XED_DEF_INST(XED_ICLASS_JNZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNZ_RELBRb,163,3,12,0,20,XED_EXCEPTION_INVALID),
/*  85*/ XED_DEF_INST(XED_ICLASS_JNZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNZ_RELBRb,166,3,12,0,20,XED_EXCEPTION_INVALID),
/*  86*/ XED_DEF_INST(XED_ICLASS_JNZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNZ_RELBRz,169,3,12,0,21,XED_EXCEPTION_INVALID),
/*  87*/ XED_DEF_INST(XED_ICLASS_JNZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNZ_RELBRd,172,3,12,0,20,XED_EXCEPTION_INVALID),
/*  88*/ XED_DEF_INST(XED_ICLASS_FCOMI,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMI_ST0_X87,232,4,13,0,6,XED_EXCEPTION_INVALID),
/*  89*/ XED_DEF_INST(XED_ICLASS_JNB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNB_RELBRb,163,3,14,0,20,XED_EXCEPTION_INVALID),
/*  90*/ XED_DEF_INST(XED_ICLASS_JNB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNB_RELBRb,166,3,14,0,20,XED_EXCEPTION_INVALID),
/*  91*/ XED_DEF_INST(XED_ICLASS_JNB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNB_RELBRz,169,3,14,0,21,XED_EXCEPTION_INVALID),
/*  92*/ XED_DEF_INST(XED_ICLASS_JNB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNB_RELBRd,172,3,14,0,20,XED_EXCEPTION_INVALID),
/*  93*/ XED_DEF_INST(XED_ICLASS_PMOVZXBD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXBD_XMMdq_MEMd,236,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*  94*/ XED_DEF_INST(XED_ICLASS_PMOVZXBD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXBD_XMMdq_XMMd,238,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*  95*/ XED_DEF_INST(XED_ICLASS_PMOVSXWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXWD_XMMdq_MEMq,240,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*  96*/ XED_DEF_INST(XED_ICLASS_PMOVSXWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXWD_XMMdq_XMMq,242,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*  97*/ XED_DEF_INST(XED_ICLASS_SYSEXIT,XED_CATEGORY_SYSRET,XED_EXTENSION_BASE,0,XED_IFORM_SYSEXIT,244,4,0,0,29,XED_EXCEPTION_INVALID),
/*  98*/ XED_DEF_INST(XED_ICLASS_SYSEXIT,XED_CATEGORY_SYSRET,XED_EXTENSION_BASE,0,XED_IFORM_SYSEXIT,248,4,0,0,29,XED_EXCEPTION_INVALID),
/*  99*/ XED_DEF_INST(XED_ICLASS_JNO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNO_RELBRb,163,3,15,0,20,XED_EXCEPTION_INVALID),
/* 100*/ XED_DEF_INST(XED_ICLASS_JNO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNO_RELBRb,166,3,15,0,20,XED_EXCEPTION_INVALID),
/* 101*/ XED_DEF_INST(XED_ICLASS_JNO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNO_RELBRz,169,3,15,0,21,XED_EXCEPTION_INVALID),
/* 102*/ XED_DEF_INST(XED_ICLASS_JNO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNO_RELBRd,172,3,15,0,20,XED_EXCEPTION_INVALID),
/* 103*/ XED_DEF_INST(XED_ICLASS_FNSAVE,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSAVE_MEMmem94,252,4,3,0,30,XED_EXCEPTION_INVALID),
/* 104*/ XED_DEF_INST(XED_ICLASS_FNSAVE,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSAVE_MEMmem108,256,4,3,0,30,XED_EXCEPTION_INVALID),
/* 105*/ XED_DEF_INST(XED_ICLASS_LAR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_LAR_GPRv_MEMw,260,3,16,0,31,XED_EXCEPTION_INVALID),
/* 106*/ XED_DEF_INST(XED_ICLASS_LAR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_LAR_GPRv_GPRv,263,3,16,0,31,XED_EXCEPTION_INVALID),
/* 107*/ XED_DEF_INST(XED_ICLASS_JNL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNL_RELBRb,163,3,10,0,20,XED_EXCEPTION_INVALID),
/* 108*/ XED_DEF_INST(XED_ICLASS_JNL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNL_RELBRb,166,3,10,0,20,XED_EXCEPTION_INVALID),
/* 109*/ XED_DEF_INST(XED_ICLASS_JNL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNL_RELBRz,169,3,10,0,21,XED_EXCEPTION_INVALID),
/* 110*/ XED_DEF_INST(XED_ICLASS_JNL,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNL_RELBRd,172,3,10,0,20,XED_EXCEPTION_INVALID),
/* 111*/ XED_DEF_INST(XED_ICLASS_FLDL2T,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDL2T,266,3,4,0,6,XED_EXCEPTION_INVALID),
/* 112*/ XED_DEF_INST(XED_ICLASS_FSUB,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUB_ST0_MEMmem32real,269,3,4,0,6,XED_EXCEPTION_INVALID),
/* 113*/ XED_DEF_INST(XED_ICLASS_FSUB,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUB_ST0_X87,272,3,4,0,6,XED_EXCEPTION_INVALID),
/* 114*/ XED_DEF_INST(XED_ICLASS_FSUB,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUB_ST0_MEMm64real,275,3,4,0,6,XED_EXCEPTION_INVALID),
/* 115*/ XED_DEF_INST(XED_ICLASS_FSUB,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUB_X87_ST0,278,3,4,0,6,XED_EXCEPTION_INVALID),
/* 116*/ XED_DEF_INST(XED_ICLASS_DIVPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_DIVPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 117*/ XED_DEF_INST(XED_ICLASS_DIVPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_DIVPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 118*/ XED_DEF_INST(XED_ICLASS_PHSUBD,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBD_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 119*/ XED_DEF_INST(XED_ICLASS_PHSUBD,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBD_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 120*/ XED_DEF_INST(XED_ICLASS_PHSUBD,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 121*/ XED_DEF_INST(XED_ICLASS_PHSUBD,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 122*/ XED_DEF_INST(XED_ICLASS_ROUNDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDPD_XMMpd_MEMpd_IMMb,287,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 123*/ XED_DEF_INST(XED_ICLASS_ROUNDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDPD_XMMpd_XMMpd_IMMb,290,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 124*/ XED_DEF_INST(XED_ICLASS_CMC,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_CMC,293,1,17,0,0,XED_EXCEPTION_INVALID),
/* 125*/ XED_DEF_INST(XED_ICLASS_CVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTPS2DQ_XMMdq_MEMps,294,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 126*/ XED_DEF_INST(XED_ICLASS_CVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTPS2DQ_XMMdq_XMMps,296,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 127*/ XED_DEF_INST(XED_ICLASS_BNDCN,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCN_BND_AGEN,298,2,0,0,34,XED_EXCEPTION_INVALID),
/* 128*/ XED_DEF_INST(XED_ICLASS_BNDCN,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCN_BND_GPR64,300,2,0,0,34,XED_EXCEPTION_INVALID),
/* 129*/ XED_DEF_INST(XED_ICLASS_BNDCN,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCN_BND_GPR32,302,2,0,0,34,XED_EXCEPTION_INVALID),
/* 130*/ XED_DEF_INST(XED_ICLASS_DIVPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_DIVPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 131*/ XED_DEF_INST(XED_ICLASS_DIVPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_DIVPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 132*/ XED_DEF_INST(XED_ICLASS_FLDL2E,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDL2E,266,3,4,0,6,XED_EXCEPTION_INVALID),
/* 133*/ XED_DEF_INST(XED_ICLASS_BNDCU,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCU_BND_AGEN,298,2,0,0,34,XED_EXCEPTION_INVALID),
/* 134*/ XED_DEF_INST(XED_ICLASS_BNDCU,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCU_BND_GPR64,300,2,0,0,34,XED_EXCEPTION_INVALID),
/* 135*/ XED_DEF_INST(XED_ICLASS_BNDCU,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCU_BND_GPR32,302,2,0,0,34,XED_EXCEPTION_INVALID),
/* 136*/ XED_DEF_INST(XED_ICLASS_PMULHRSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PMULHRSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 137*/ XED_DEF_INST(XED_ICLASS_PMULHRSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PMULHRSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 138*/ XED_DEF_INST(XED_ICLASS_PMULHRSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PMULHRSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 139*/ XED_DEF_INST(XED_ICLASS_PMULHRSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PMULHRSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 140*/ XED_DEF_INST(XED_ICLASS_MOVSD_XMM,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVSD_XMM_XMMdq_MEMsd,308,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 141*/ XED_DEF_INST(XED_ICLASS_MOVSD_XMM,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVSD_XMM_XMMsd_XMMsd_0F10,310,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 142*/ XED_DEF_INST(XED_ICLASS_MOVSD_XMM,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVSD_XMM_MEMsd_XMMsd,312,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 143*/ XED_DEF_INST(XED_ICLASS_MOVSD_XMM,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVSD_XMM_XMMsd_XMMsd_0F11,314,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 144*/ XED_DEF_INST(XED_ICLASS_PHSUBW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 145*/ XED_DEF_INST(XED_ICLASS_PHSUBW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 146*/ XED_DEF_INST(XED_ICLASS_PHSUBW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 147*/ XED_DEF_INST(XED_ICLASS_PHSUBW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 148*/ XED_DEF_INST(XED_ICLASS_ROUNDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDPS_XMMps_MEMps_IMMb,316,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 149*/ XED_DEF_INST(XED_ICLASS_ROUNDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDPS_XMMps_XMMps_IMMb,319,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 150*/ XED_DEF_INST(XED_ICLASS_XADD,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_XADD_MEMb_GPR8,322,3,18,0,36,XED_EXCEPTION_INVALID),
/* 151*/ XED_DEF_INST(XED_ICLASS_XADD,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_XADD_GPR8_GPR8,325,3,18,0,37,XED_EXCEPTION_INVALID),
/* 152*/ XED_DEF_INST(XED_ICLASS_XADD,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_XADD_MEMv_GPRv,328,3,18,0,38,XED_EXCEPTION_INVALID),
/* 153*/ XED_DEF_INST(XED_ICLASS_XADD,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_XADD_GPRv_GPRv,331,3,18,0,39,XED_EXCEPTION_INVALID),
/* 154*/ XED_DEF_INST(XED_ICLASS_CMOVBE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVBE_GPRv_MEMv,334,3,19,0,39,XED_EXCEPTION_INVALID),
/* 155*/ XED_DEF_INST(XED_ICLASS_CMOVBE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVBE_GPRv_GPRv,337,3,19,0,39,XED_EXCEPTION_INVALID),
/* 156*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_MEMb_IMMb_80r7,340,3,18,0,37,XED_EXCEPTION_INVALID),
/* 157*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPR8_IMMb_80r7,343,3,18,0,37,XED_EXCEPTION_INVALID),
/* 158*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_MEMv_IMMz,346,3,18,0,39,XED_EXCEPTION_INVALID),
/* 159*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPRv_IMMz,349,3,18,0,39,XED_EXCEPTION_INVALID),
/* 160*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_MEMb_IMMb_82r7,340,3,18,0,37,XED_EXCEPTION_INVALID),
/* 161*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPR8_IMMb_82r7,343,3,18,0,37,XED_EXCEPTION_INVALID),
/* 162*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_MEMv_IMMb,352,3,18,0,39,XED_EXCEPTION_INVALID),
/* 163*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPRv_IMMb,355,3,18,0,39,XED_EXCEPTION_INVALID),
/* 164*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_MEMb_GPR8,358,3,18,0,37,XED_EXCEPTION_INVALID),
/* 165*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPR8_GPR8_38,361,3,18,0,37,XED_EXCEPTION_INVALID),
/* 166*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_MEMv_GPRv,364,3,18,0,39,XED_EXCEPTION_INVALID),
/* 167*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPRv_GPRv_39,367,3,18,0,39,XED_EXCEPTION_INVALID),
/* 168*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPR8_MEMb,370,3,18,0,37,XED_EXCEPTION_INVALID),
/* 169*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPR8_GPR8_3A,373,3,18,0,37,XED_EXCEPTION_INVALID),
/* 170*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPRv_MEMv,376,3,18,0,39,XED_EXCEPTION_INVALID),
/* 171*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_GPRv_GPRv_3B,379,3,18,0,39,XED_EXCEPTION_INVALID),
/* 172*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_AL_IMMb,382,3,18,0,37,XED_EXCEPTION_INVALID),
/* 173*/ XED_DEF_INST(XED_ICLASS_CMP,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_CMP_OrAX_IMMz,385,3,18,0,39,XED_EXCEPTION_INVALID),
/* 174*/ XED_DEF_INST(XED_ICLASS_CMOVLE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVLE_GPRv_MEMv,334,3,6,0,39,XED_EXCEPTION_INVALID),
/* 175*/ XED_DEF_INST(XED_ICLASS_CMOVLE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVLE_GPRv_GPRv,337,3,6,0,39,XED_EXCEPTION_INVALID),
/* 176*/ XED_DEF_INST(XED_ICLASS_PREFETCH_RESERVED,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCH_RESERVED_0F0Dr4,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 177*/ XED_DEF_INST(XED_ICLASS_PREFETCH_RESERVED,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCH_RESERVED_0F0Dr5,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 178*/ XED_DEF_INST(XED_ICLASS_PREFETCH_RESERVED,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCH_RESERVED_0F0Dr6,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 179*/ XED_DEF_INST(XED_ICLASS_PREFETCH_RESERVED,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCH_RESERVED_0F0Dr7,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 180*/ XED_DEF_INST(XED_ICLASS_SHA1NEXTE,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1NEXTE_XMMi32_XMMi32_SHA,285,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 181*/ XED_DEF_INST(XED_ICLASS_SHA1NEXTE,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1NEXTE_XMMi32_MEMi32_SHA,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 182*/ XED_DEF_INST(XED_ICLASS_INVVPID,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_INVVPID_GPR64_MEMdq,388,3,20,0,15,XED_EXCEPTION_INVALID),
/* 183*/ XED_DEF_INST(XED_ICLASS_INVVPID,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_INVVPID_GPR32_MEMdq,391,3,20,0,15,XED_EXCEPTION_INVALID),
/* 184*/ XED_DEF_INST(XED_ICLASS_LSL,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_LSL_GPRv_MEMw,394,3,16,0,31,XED_EXCEPTION_INVALID),
/* 185*/ XED_DEF_INST(XED_ICLASS_LSL,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_LSL_GPRv_GPRz,397,3,16,0,31,XED_EXCEPTION_INVALID),
/* 186*/ XED_DEF_INST(XED_ICLASS_XSAVEC64,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVEC,3,XED_IFORM_XSAVEC64_MEMmxsave,400,4,0,0,40,XED_EXCEPTION_INVALID),
/* 187*/ XED_DEF_INST(XED_ICLASS_LSS,XED_CATEGORY_SEGOP,XED_EXTENSION_BASE,3,XED_IFORM_LSS_GPRv_MEMp2,404,3,0,0,7,XED_EXCEPTION_INVALID),
/* 188*/ XED_DEF_INST(XED_ICLASS_LAHF,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_LAHF,407,2,21,0,0,XED_EXCEPTION_INVALID),
/* 189*/ XED_DEF_INST(XED_ICLASS_PFACC,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFACC_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 190*/ XED_DEF_INST(XED_ICLASS_PFACC,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFACC_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 191*/ XED_DEF_INST(XED_ICLASS_PFRCPIT2,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFRCPIT2_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 192*/ XED_DEF_INST(XED_ICLASS_PFRCPIT2,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFRCPIT2_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 193*/ XED_DEF_INST(XED_ICLASS_PCMPGTQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPGTQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 194*/ XED_DEF_INST(XED_ICLASS_PCMPGTQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPGTQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 195*/ XED_DEF_INST(XED_ICLASS_FYL2X,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FYL2X,409,4,4,0,6,XED_EXCEPTION_INVALID),
/* 196*/ XED_DEF_INST(XED_ICLASS_ADDSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_ADDSS_XMMss_MEMss,413,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 197*/ XED_DEF_INST(XED_ICLASS_ADDSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_ADDSS_XMMss_XMMss,415,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 198*/ XED_DEF_INST(XED_ICLASS_PCMPGTW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPGTW_MMXq_MEMq,417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 199*/ XED_DEF_INST(XED_ICLASS_PCMPGTW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPGTW_MMXq_MMXq,419,2,0,0,6,XED_EXCEPTION_INVALID),
/* 200*/ XED_DEF_INST(XED_ICLASS_PCMPGTW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPGTW_XMMdq_MEMdq,421,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 201*/ XED_DEF_INST(XED_ICLASS_PCMPGTW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPGTW_XMMdq_XMMdq,423,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 202*/ XED_DEF_INST(XED_ICLASS_PBLENDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PBLENDW_XMMdq_MEMdq_IMMb,425,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 203*/ XED_DEF_INST(XED_ICLASS_PBLENDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PBLENDW_XMMdq_XMMdq_IMMb,428,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 204*/ XED_DEF_INST(XED_ICLASS_VMLOAD,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_VMLOAD_OrAX,431,1,0,0,9,XED_EXCEPTION_INVALID),
/* 205*/ XED_DEF_INST(XED_ICLASS_RDPKRU,XED_CATEGORY_PKU,XED_EXTENSION_PKU,3,XED_IFORM_RDPKRU,432,3,0,0,0,XED_EXCEPTION_INVALID),
/* 206*/ XED_DEF_INST(XED_ICLASS_PCMPGTB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPGTB_MMXq_MEMq,435,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 207*/ XED_DEF_INST(XED_ICLASS_PCMPGTB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPGTB_MMXq_MMXq,437,2,0,0,6,XED_EXCEPTION_INVALID),
/* 208*/ XED_DEF_INST(XED_ICLASS_PCMPGTB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPGTB_XMMdq_MEMdq,439,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 209*/ XED_DEF_INST(XED_ICLASS_PCMPGTB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPGTB_XMMdq_XMMdq,441,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 210*/ XED_DEF_INST(XED_ICLASS_PCMPGTD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPGTD_MMXq_MEMq,443,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 211*/ XED_DEF_INST(XED_ICLASS_PCMPGTD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPGTD_MMXq_MMXq,445,2,0,0,6,XED_EXCEPTION_INVALID),
/* 212*/ XED_DEF_INST(XED_ICLASS_PCMPGTD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPGTD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 213*/ XED_DEF_INST(XED_ICLASS_PCMPGTD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPGTD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 214*/ XED_DEF_INST(XED_ICLASS_VMCLEAR,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMCLEAR_MEMq,447,2,20,0,6,XED_EXCEPTION_INVALID),
/* 215*/ XED_DEF_INST(XED_ICLASS_BNDSTX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDSTX_MEMbnd32_BND,449,2,0,0,42,XED_EXCEPTION_INVALID),
/* 216*/ XED_DEF_INST(XED_ICLASS_BNDSTX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDSTX_MEMbnd64_BND,451,2,0,0,42,XED_EXCEPTION_INVALID),
/* 217*/ XED_DEF_INST(XED_ICLASS_BNDSTX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDSTX_MEMbnd64_BND,451,2,0,0,42,XED_EXCEPTION_INVALID),
/* 218*/ XED_DEF_INST(XED_ICLASS_BNDSTX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDSTX_MEMbnd64_BND,451,2,0,0,42,XED_EXCEPTION_INVALID),
/* 219*/ XED_DEF_INST(XED_ICLASS_MPSADBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_MPSADBW_XMMdq_MEMdq_IMMb,453,3,0,0,43,XED_EXCEPTION_SSE_TYPE_4),
/* 220*/ XED_DEF_INST(XED_ICLASS_MPSADBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_MPSADBW_XMMdq_XMMdq_IMMb,456,3,0,0,43,XED_EXCEPTION_SSE_TYPE_4),
/* 221*/ XED_DEF_INST(XED_ICLASS_VMMCALL,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_VMMCALL,0,0,0,0,8,XED_EXCEPTION_INVALID),
/* 222*/ XED_DEF_INST(XED_ICLASS_INSERTQ,XED_CATEGORY_BITBYTE,XED_EXTENSION_SSE4A,3,XED_IFORM_INSERTQ_XMMq_XMMq_IMMb_IMMb,459,4,0,0,44,XED_EXCEPTION_INVALID),
/* 223*/ XED_DEF_INST(XED_ICLASS_INSERTQ,XED_CATEGORY_BITBYTE,XED_EXTENSION_SSE4A,3,XED_IFORM_INSERTQ_XMMq_XMMdq,463,2,0,0,44,XED_EXCEPTION_INVALID),
/* 224*/ XED_DEF_INST(XED_ICLASS_CVTPI2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPI2PD_XMMpd_MEMq,216,2,0,0,45,XED_EXCEPTION_MMX_NOFP),
/* 225*/ XED_DEF_INST(XED_ICLASS_CVTPI2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPI2PD_XMMpd_MMXq,465,2,0,0,45,XED_EXCEPTION_MMX_NOFP),
/* 226*/ XED_DEF_INST(XED_ICLASS_INT,XED_CATEGORY_INTERRUPT,XED_EXTENSION_BASE,3,XED_IFORM_INT_IMMb,467,3,22,0,6,XED_EXCEPTION_INVALID),
/* 227*/ XED_DEF_INST(XED_ICLASS_HLT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_HLT,0,0,0,0,15,XED_EXCEPTION_INVALID),
/* 228*/ XED_DEF_INST(XED_ICLASS_PHMINPOSUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PHMINPOSUW_XMMdq_MEMdq,470,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 229*/ XED_DEF_INST(XED_ICLASS_PHMINPOSUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PHMINPOSUW_XMMdq_XMMdq,472,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 230*/ XED_DEF_INST(XED_ICLASS_FCMOVNU,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVNU_ST0_X87,474,4,23,0,6,XED_EXCEPTION_INVALID),
/* 231*/ XED_DEF_INST(XED_ICLASS_INVPCID,XED_CATEGORY_MISC,XED_EXTENSION_INVPCID,0,XED_IFORM_INVPCID_GPR64_MEMdq,478,2,0,0,15,XED_EXCEPTION_INVALID),
/* 232*/ XED_DEF_INST(XED_ICLASS_INVPCID,XED_CATEGORY_MISC,XED_EXTENSION_INVPCID,0,XED_IFORM_INVPCID_GPR32_MEMdq,480,2,0,0,15,XED_EXCEPTION_INVALID),
/* 233*/ XED_DEF_INST(XED_ICLASS_FCOMIP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMIP_ST0_X87,482,5,13,0,6,XED_EXCEPTION_INVALID),
/* 234*/ XED_DEF_INST(XED_ICLASS_CVTPI2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTPI2PS_XMMq_MEMq,487,2,0,0,45,XED_EXCEPTION_MMX_FP),
/* 235*/ XED_DEF_INST(XED_ICLASS_CVTPI2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTPI2PS_XMMq_MMXq,489,2,0,0,45,XED_EXCEPTION_MMX_FP),
/* 236*/ XED_DEF_INST(XED_ICLASS_PACKUSWB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PACKUSWB_MMXq_MEMq,417,2,0,0,46,XED_EXCEPTION_MMX_MEM),
/* 237*/ XED_DEF_INST(XED_ICLASS_PACKUSWB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PACKUSWB_MMXq_MMXq,419,2,0,0,46,XED_EXCEPTION_INVALID),
/* 238*/ XED_DEF_INST(XED_ICLASS_PACKUSWB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PACKUSWB_XMMdq_MEMdq,421,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/* 239*/ XED_DEF_INST(XED_ICLASS_PACKUSWB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PACKUSWB_XMMdq_XMMdq,423,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/* 240*/ XED_DEF_INST(XED_ICLASS_CBW,XED_CATEGORY_CONVERT,XED_EXTENSION_BASE,3,XED_IFORM_CBW,491,2,0,0,0,XED_EXCEPTION_INVALID),
/* 241*/ XED_DEF_INST(XED_ICLASS_VMSAVE,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_VMSAVE,0,0,0,0,48,XED_EXCEPTION_INVALID),
/* 242*/ XED_DEF_INST(XED_ICLASS_PUSHF,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSHF,493,4,24,0,49,XED_EXCEPTION_INVALID),
/* 243*/ XED_DEF_INST(XED_ICLASS_NOT,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_NOT_MEMb,497,1,0,0,36,XED_EXCEPTION_INVALID),
/* 244*/ XED_DEF_INST(XED_ICLASS_NOT,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_NOT_GPR8,498,1,0,0,37,XED_EXCEPTION_INVALID),
/* 245*/ XED_DEF_INST(XED_ICLASS_NOT,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_NOT_MEMv,499,1,0,0,38,XED_EXCEPTION_INVALID),
/* 246*/ XED_DEF_INST(XED_ICLASS_NOT,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_NOT_GPRv,500,1,0,0,39,XED_EXCEPTION_INVALID),
/* 247*/ XED_DEF_INST(XED_ICLASS_FCMOVNB,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVNB_ST0_X87,474,4,25,0,6,XED_EXCEPTION_INVALID),
/* 248*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r0,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 249*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r1,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 250*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r2,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 251*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r3,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 252*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_0F18r4,502,1,0,0,50,XED_EXCEPTION_INVALID),
/* 253*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r4,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 254*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_0F18r5,502,1,0,0,50,XED_EXCEPTION_INVALID),
/* 255*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r5,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 256*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_0F18r6,502,1,0,0,50,XED_EXCEPTION_INVALID),
/* 257*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r6,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 258*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_0F18r7,502,1,0,0,50,XED_EXCEPTION_INVALID),
/* 259*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_0F18r7,501,1,0,0,50,XED_EXCEPTION_INVALID),
/* 260*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F19,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 261*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F19,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 262*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1D,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 263*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1D,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 264*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1F,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 265*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1F,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 266*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_NOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_90,0,0,0,0,51,XED_EXCEPTION_INVALID),
/* 267*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_NOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_90,0,0,0,0,51,XED_EXCEPTION_INVALID),
/* 268*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F0D,505,2,0,0,39,XED_EXCEPTION_INVALID),
/* 269*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1A,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 270*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1B,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 271*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1B,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 272*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1A,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 273*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1B,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 274*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_MEMv_0F1A,507,2,0,0,50,XED_EXCEPTION_INVALID),
/* 275*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_MEM_0F1B,507,2,0,0,50,XED_EXCEPTION_INVALID),
/* 276*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1E,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 277*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 278*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 279*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 280*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 281*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 282*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 283*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 284*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 285*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 286*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 287*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 288*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 289*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 290*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 291*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 292*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 293*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 294*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 295*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1E,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 296*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 297*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 298*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 299*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 300*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 301*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 302*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 303*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 304*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 305*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 306*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_GPRv_GPRv_0F1C,505,2,0,0,50,XED_EXCEPTION_INVALID),
/* 307*/ XED_DEF_INST(XED_ICLASS_NOP,XED_CATEGORY_WIDENOP,XED_EXTENSION_BASE,3,XED_IFORM_NOP_MEMv_GPRv_0F1C,503,2,0,0,50,XED_EXCEPTION_INVALID),
/* 308*/ XED_DEF_INST(XED_ICLASS_FCMOVNE,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVNE_ST0_X87,474,4,26,0,6,XED_EXCEPTION_INVALID),
/* 309*/ XED_DEF_INST(XED_ICLASS_INC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_MEMb,509,2,27,0,36,XED_EXCEPTION_INVALID),
/* 310*/ XED_DEF_INST(XED_ICLASS_INC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_GPR8,511,2,27,0,37,XED_EXCEPTION_INVALID),
/* 311*/ XED_DEF_INST(XED_ICLASS_INC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_MEMv,513,2,27,0,38,XED_EXCEPTION_INVALID),
/* 312*/ XED_DEF_INST(XED_ICLASS_INC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_GPRv_FFr0,515,2,27,0,39,XED_EXCEPTION_INVALID),
/* 313*/ XED_DEF_INST(XED_ICLASS_INC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_GPRv_40,517,2,27,0,39,XED_EXCEPTION_INVALID),
/* 314*/ XED_DEF_INST(XED_ICLASS_CMPSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_CMPSQ,519,5,28,0,52,XED_EXCEPTION_INVALID),
/* 315*/ XED_DEF_INST(XED_ICLASS_CMPSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_CMPSS_XMMss_MEMss_IMMb,524,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 316*/ XED_DEF_INST(XED_ICLASS_CMPSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_CMPSS_XMMss_XMMss_IMMb,527,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 317*/ XED_DEF_INST(XED_ICLASS_PCMPISTRM,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPISTRM_XMMdq_MEMdq_IMMb,530,5,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 318*/ XED_DEF_INST(XED_ICLASS_PCMPISTRM,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPISTRM_XMMdq_XMMdq_IMMb,535,5,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 319*/ XED_DEF_INST(XED_ICLASS_GF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_GF2P8AFFINEQB_XMMu8_XMMu64_IMM8,540,3,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 320*/ XED_DEF_INST(XED_ICLASS_GF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_GF2P8AFFINEQB_XMMu8_MEMu64_IMM8,543,3,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 321*/ XED_DEF_INST(XED_ICLASS_CMPSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_CMPSW,546,5,28,0,52,XED_EXCEPTION_INVALID),
/* 322*/ XED_DEF_INST(XED_ICLASS_ADC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_LOCK_MEMb_IMMb_80r2,551,3,30,0,53,XED_EXCEPTION_INVALID),
/* 323*/ XED_DEF_INST(XED_ICLASS_ADC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_LOCK_MEMv_IMMz,554,3,30,0,54,XED_EXCEPTION_INVALID),
/* 324*/ XED_DEF_INST(XED_ICLASS_ADC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_LOCK_MEMb_IMMb_82r2,551,3,30,0,53,XED_EXCEPTION_INVALID),
/* 325*/ XED_DEF_INST(XED_ICLASS_ADC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_LOCK_MEMv_IMMb,557,3,30,0,54,XED_EXCEPTION_INVALID),
/* 326*/ XED_DEF_INST(XED_ICLASS_ADC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_LOCK_MEMb_GPR8,560,3,30,0,53,XED_EXCEPTION_INVALID),
/* 327*/ XED_DEF_INST(XED_ICLASS_ADC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_LOCK_MEMv_GPRv,563,3,30,0,54,XED_EXCEPTION_INVALID),
/* 328*/ XED_DEF_INST(XED_ICLASS_INSERTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_INSERTPS_XMMps_MEMd_IMMb,566,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 329*/ XED_DEF_INST(XED_ICLASS_INSERTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_INSERTPS_XMMps_XMMps_IMMb,569,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 330*/ XED_DEF_INST(XED_ICLASS_FADDP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FADDP_X87_ST0,572,4,4,0,6,XED_EXCEPTION_INVALID),
/* 331*/ XED_DEF_INST(XED_ICLASS_ADDSUBPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_ADDSUBPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 332*/ XED_DEF_INST(XED_ICLASS_ADDSUBPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_ADDSUBPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 333*/ XED_DEF_INST(XED_ICLASS_CMPSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_CMPSB,576,5,28,0,55,XED_EXCEPTION_INVALID),
/* 334*/ XED_DEF_INST(XED_ICLASS_XSETBV,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVE,0,XED_IFORM_XSETBV,581,4,0,0,15,XED_EXCEPTION_INVALID),
/* 335*/ XED_DEF_INST(XED_ICLASS_CMPSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_CMPSD,585,5,28,0,52,XED_EXCEPTION_INVALID),
/* 336*/ XED_DEF_INST(XED_ICLASS_ADDSUBPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_ADDSUBPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 337*/ XED_DEF_INST(XED_ICLASS_ADDSUBPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_ADDSUBPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 338*/ XED_DEF_INST(XED_ICLASS_FXSAVE64,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_FXSAVE64_MEMmfpxenv,590,2,0,0,56,XED_EXCEPTION_INVALID),
/* 339*/ XED_DEF_INST(XED_ICLASS_PSIGNW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 340*/ XED_DEF_INST(XED_ICLASS_PSIGNW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 341*/ XED_DEF_INST(XED_ICLASS_PSIGNW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 342*/ XED_DEF_INST(XED_ICLASS_PSIGNW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 343*/ XED_DEF_INST(XED_ICLASS_MASKMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MASKMOVDQU_XMMdq_XMMdq,592,4,0,0,57,XED_EXCEPTION_SSE_TYPE_4),
/* 344*/ XED_DEF_INST(XED_ICLASS_SETB,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETB_MEMb,596,2,31,0,37,XED_EXCEPTION_INVALID),
/* 345*/ XED_DEF_INST(XED_ICLASS_SETB,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETB_GPR8,598,2,31,0,37,XED_EXCEPTION_INVALID),
/* 346*/ XED_DEF_INST(XED_ICLASS_SETL,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETL_MEMb,596,2,10,0,37,XED_EXCEPTION_INVALID),
/* 347*/ XED_DEF_INST(XED_ICLASS_SETL,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETL_GPR8,598,2,10,0,37,XED_EXCEPTION_INVALID),
/* 348*/ XED_DEF_INST(XED_ICLASS_SETO,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETO_MEMb,596,2,15,0,37,XED_EXCEPTION_INVALID),
/* 349*/ XED_DEF_INST(XED_ICLASS_SETO,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETO_GPR8,598,2,15,0,37,XED_EXCEPTION_INVALID),
/* 350*/ XED_DEF_INST(XED_ICLASS_WRUSSD,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_WRUSSD_MEMu32_GPR32u32,600,2,0,0,0,XED_EXCEPTION_INVALID),
/* 351*/ XED_DEF_INST(XED_ICLASS_ANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_ANDNPD_XMMxuq_MEMxuq,602,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 352*/ XED_DEF_INST(XED_ICLASS_ANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_ANDNPD_XMMxuq_XMMxuq,604,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 353*/ XED_DEF_INST(XED_ICLASS_BSR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSR_GPRv_MEMv,606,3,32,0,39,XED_EXCEPTION_INVALID),
/* 354*/ XED_DEF_INST(XED_ICLASS_BSR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSR_GPRv_GPRv,263,3,32,0,39,XED_EXCEPTION_INVALID),
/* 355*/ XED_DEF_INST(XED_ICLASS_BSR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSR_GPRv_MEMv,606,3,32,0,39,XED_EXCEPTION_INVALID),
/* 356*/ XED_DEF_INST(XED_ICLASS_BSR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSR_GPRv_GPRv,263,3,32,0,39,XED_EXCEPTION_INVALID),
/* 357*/ XED_DEF_INST(XED_ICLASS_PSIGND,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGND_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 358*/ XED_DEF_INST(XED_ICLASS_PSIGND,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGND_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 359*/ XED_DEF_INST(XED_ICLASS_PSIGND,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGND_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 360*/ XED_DEF_INST(XED_ICLASS_PSIGND,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGND_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 361*/ XED_DEF_INST(XED_ICLASS_SETP,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETP_MEMb,596,2,33,0,37,XED_EXCEPTION_INVALID),
/* 362*/ XED_DEF_INST(XED_ICLASS_SETP,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETP_GPR8,598,2,33,0,37,XED_EXCEPTION_INVALID),
/* 363*/ XED_DEF_INST(XED_ICLASS_PSIGNB,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 364*/ XED_DEF_INST(XED_ICLASS_PSIGNB,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 365*/ XED_DEF_INST(XED_ICLASS_PSIGNB,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 366*/ XED_DEF_INST(XED_ICLASS_PSIGNB,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSIGNB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 367*/ XED_DEF_INST(XED_ICLASS_LFS,XED_CATEGORY_SEGOP,XED_EXTENSION_BASE,3,XED_IFORM_LFS_GPRv_MEMp2,609,3,0,0,7,XED_EXCEPTION_INVALID),
/* 368*/ XED_DEF_INST(XED_ICLASS_FCMOVBE,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVBE_ST0_X87,474,4,34,0,6,XED_EXCEPTION_INVALID),
/* 369*/ XED_DEF_INST(XED_ICLASS_WRUSSQ,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_WRUSSQ_MEMu64_GPR64u64,612,2,0,0,0,XED_EXCEPTION_INVALID),
/* 370*/ XED_DEF_INST(XED_ICLASS_ANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_ANDNPS_XMMxud_MEMxud,614,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 371*/ XED_DEF_INST(XED_ICLASS_ANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_ANDNPS_XMMxud_XMMxud,616,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 372*/ XED_DEF_INST(XED_ICLASS_VMXON,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMXON_MEMq,447,2,20,0,1,XED_EXCEPTION_INVALID),
/* 373*/ XED_DEF_INST(XED_ICLASS_DEC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_LOCK_MEMb,509,2,35,0,53,XED_EXCEPTION_INVALID),
/* 374*/ XED_DEF_INST(XED_ICLASS_DEC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_LOCK_MEMv,513,2,35,0,54,XED_EXCEPTION_INVALID),
/* 375*/ XED_DEF_INST(XED_ICLASS_OUT,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_OUT_IMMb_AL,618,3,36,0,58,XED_EXCEPTION_INVALID),
/* 376*/ XED_DEF_INST(XED_ICLASS_OUT,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_OUT_IMMb_OeAX,621,3,36,0,7,XED_EXCEPTION_INVALID),
/* 377*/ XED_DEF_INST(XED_ICLASS_OUT,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_OUT_DX_AL,624,3,36,0,37,XED_EXCEPTION_INVALID),
/* 378*/ XED_DEF_INST(XED_ICLASS_OUT,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_OUT_DX_OeAX,627,3,36,0,39,XED_EXCEPTION_INVALID),
/* 379*/ XED_DEF_INST(XED_ICLASS_XSAVES64,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVES,0,XED_IFORM_XSAVES64_MEMmxsave,400,4,0,0,40,XED_EXCEPTION_INVALID),
/* 380*/ XED_DEF_INST(XED_ICLASS_LTR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LTR_MEMw,630,2,0,0,29,XED_EXCEPTION_INVALID),
/* 381*/ XED_DEF_INST(XED_ICLASS_LTR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LTR_GPR16,632,2,0,0,29,XED_EXCEPTION_INVALID),
/* 382*/ XED_DEF_INST(XED_ICLASS_TZCNT,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_TZCNT_GPRv_MEMv,634,3,37,0,39,XED_EXCEPTION_INVALID),
/* 383*/ XED_DEF_INST(XED_ICLASS_TZCNT,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_TZCNT_GPRv_GPRv,637,3,37,0,39,XED_EXCEPTION_INVALID),
/* 384*/ XED_DEF_INST(XED_ICLASS_RDTSCP,XED_CATEGORY_SYSTEM,XED_EXTENSION_RDTSCP,3,XED_IFORM_RDTSCP,640,5,0,0,0,XED_EXCEPTION_INVALID),
/* 385*/ XED_DEF_INST(XED_ICLASS_PSLLDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLDQ_XMMdq_IMMb,645,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/* 386*/ XED_DEF_INST(XED_ICLASS_PSUBD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBD_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 387*/ XED_DEF_INST(XED_ICLASS_PSUBD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBD_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 388*/ XED_DEF_INST(XED_ICLASS_PSUBD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 389*/ XED_DEF_INST(XED_ICLASS_PSUBD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 390*/ XED_DEF_INST(XED_ICLASS_FXTRACT,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FXTRACT,647,3,4,0,6,XED_EXCEPTION_INVALID),
/* 391*/ XED_DEF_INST(XED_ICLASS_CALL_FAR,XED_CATEGORY_CALL,XED_EXTENSION_BASE,3,XED_IFORM_CALL_FAR_MEMp2,650,5,0,0,59,XED_EXCEPTION_INVALID),
/* 392*/ XED_DEF_INST(XED_ICLASS_CALL_FAR,XED_CATEGORY_CALL,XED_EXTENSION_BASE,3,XED_IFORM_CALL_FAR_PTRp_IMMw,655,6,0,0,60,XED_EXCEPTION_INVALID),
/* 393*/ XED_DEF_INST(XED_ICLASS_CMOVNLE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNLE_GPRv_MEMv,334,3,6,0,39,XED_EXCEPTION_INVALID),
/* 394*/ XED_DEF_INST(XED_ICLASS_CMOVNLE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNLE_GPRv_GPRv,337,3,6,0,39,XED_EXCEPTION_INVALID),
/* 395*/ XED_DEF_INST(XED_ICLASS_FMUL,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FMUL_ST0_MEMmem32real,269,3,4,0,6,XED_EXCEPTION_INVALID),
/* 396*/ XED_DEF_INST(XED_ICLASS_FMUL,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FMUL_ST0_X87,272,3,4,0,6,XED_EXCEPTION_INVALID),
/* 397*/ XED_DEF_INST(XED_ICLASS_FMUL,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FMUL_ST0_MEMm64real,275,3,4,0,6,XED_EXCEPTION_INVALID),
/* 398*/ XED_DEF_INST(XED_ICLASS_FMUL,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FMUL_X87_ST0,278,3,4,0,6,XED_EXCEPTION_INVALID),
/* 399*/ XED_DEF_INST(XED_ICLASS_FCOMPP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMPP,661,4,3,0,6,XED_EXCEPTION_INVALID),
/* 400*/ XED_DEF_INST(XED_ICLASS_PF2ID,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PF2ID_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 401*/ XED_DEF_INST(XED_ICLASS_PF2ID,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PF2ID_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 402*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_MEMb_IMMb_80r3,551,3,38,0,36,XED_EXCEPTION_INVALID),
/* 403*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPR8_IMMb_80r3,665,3,38,0,37,XED_EXCEPTION_INVALID),
/* 404*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_MEMv_IMMz,554,3,38,0,38,XED_EXCEPTION_INVALID),
/* 405*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPRv_IMMz,668,3,38,0,39,XED_EXCEPTION_INVALID),
/* 406*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_MEMb_IMMb_82r3,551,3,38,0,36,XED_EXCEPTION_INVALID),
/* 407*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPR8_IMMb_82r3,665,3,38,0,37,XED_EXCEPTION_INVALID),
/* 408*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_MEMv_IMMb,557,3,38,0,38,XED_EXCEPTION_INVALID),
/* 409*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPRv_IMMb,671,3,38,0,39,XED_EXCEPTION_INVALID),
/* 410*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_MEMb_GPR8,560,3,38,0,36,XED_EXCEPTION_INVALID),
/* 411*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPR8_GPR8_18,674,3,38,0,37,XED_EXCEPTION_INVALID),
/* 412*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_MEMv_GPRv,563,3,38,0,38,XED_EXCEPTION_INVALID),
/* 413*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPRv_GPRv_19,677,3,38,0,39,XED_EXCEPTION_INVALID),
/* 414*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPR8_GPR8_1A,680,3,38,0,37,XED_EXCEPTION_INVALID),
/* 415*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPR8_MEMb,683,3,38,0,37,XED_EXCEPTION_INVALID),
/* 416*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPRv_GPRv_1B,686,3,38,0,39,XED_EXCEPTION_INVALID),
/* 417*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_GPRv_MEMv,689,3,38,0,39,XED_EXCEPTION_INVALID),
/* 418*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_AL_IMMb,692,3,38,0,37,XED_EXCEPTION_INVALID),
/* 419*/ XED_DEF_INST(XED_ICLASS_SBB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_OrAX_IMMz,695,3,38,0,39,XED_EXCEPTION_INVALID),
/* 420*/ XED_DEF_INST(XED_ICLASS_LODSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_LODSB,698,4,39,0,61,XED_EXCEPTION_INVALID),
/* 421*/ XED_DEF_INST(XED_ICLASS_PHADDSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 422*/ XED_DEF_INST(XED_ICLASS_PHADDSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 423*/ XED_DEF_INST(XED_ICLASS_PHADDSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 424*/ XED_DEF_INST(XED_ICLASS_PHADDSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 425*/ XED_DEF_INST(XED_ICLASS_PF2IW,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PF2IW_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 426*/ XED_DEF_INST(XED_ICLASS_PF2IW,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PF2IW_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 427*/ XED_DEF_INST(XED_ICLASS_SAVEPREVSSP,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_SAVEPREVSSP,702,1,0,0,0,XED_EXCEPTION_INVALID),
/* 428*/ XED_DEF_INST(XED_ICLASS_FCOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMP_ST0_MEMmem32real,703,4,3,0,6,XED_EXCEPTION_INVALID),
/* 429*/ XED_DEF_INST(XED_ICLASS_FCOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMP_ST0_X87,707,4,3,0,6,XED_EXCEPTION_INVALID),
/* 430*/ XED_DEF_INST(XED_ICLASS_FCOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMP_ST0_X87_DCD1,707,4,3,0,6,XED_EXCEPTION_INVALID),
/* 431*/ XED_DEF_INST(XED_ICLASS_FCOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMP_ST0_X87_DED0,707,4,3,0,6,XED_EXCEPTION_INVALID),
/* 432*/ XED_DEF_INST(XED_ICLASS_FCOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOMP_ST0_MEMm64real,711,4,3,0,6,XED_EXCEPTION_INVALID),
/* 433*/ XED_DEF_INST(XED_ICLASS_UMWAIT,XED_CATEGORY_WAITPKG,XED_EXTENSION_WAITPKG,3,XED_IFORM_UMWAIT_GPR32,715,4,40,0,0,XED_EXCEPTION_INVALID),
/* 434*/ XED_DEF_INST(XED_ICLASS_UMWAIT,XED_CATEGORY_WAITPKG,XED_EXTENSION_WAITPKG,3,XED_IFORM_UMWAIT_GPR64,719,4,40,0,0,XED_EXCEPTION_INVALID),
/* 435*/ XED_DEF_INST(XED_ICLASS_LODSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_LODSQ,723,4,39,0,62,XED_EXCEPTION_INVALID),
/* 436*/ XED_DEF_INST(XED_ICLASS_UD0,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_UD0_GPR32_MEMd,727,2,0,0,6,XED_EXCEPTION_INVALID),
/* 437*/ XED_DEF_INST(XED_ICLASS_UD0,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_UD0_GPR32_GPR32,729,2,0,0,6,XED_EXCEPTION_INVALID),
/* 438*/ XED_DEF_INST(XED_ICLASS_UD1,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_UD1_GPR32_MEMd,727,2,0,0,6,XED_EXCEPTION_INVALID),
/* 439*/ XED_DEF_INST(XED_ICLASS_UD1,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_UD1_GPR32_GPR32,729,2,0,0,6,XED_EXCEPTION_INVALID),
/* 440*/ XED_DEF_INST(XED_ICLASS_LODSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_LODSW,731,4,39,0,62,XED_EXCEPTION_INVALID),
/* 441*/ XED_DEF_INST(XED_ICLASS_FENI8087_NOP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FENI8087_NOP,0,0,0,0,63,XED_EXCEPTION_INVALID),
/* 442*/ XED_DEF_INST(XED_ICLASS_UNPCKLPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_UNPCKLPD_XMMpd_MEMdq,94,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 443*/ XED_DEF_INST(XED_ICLASS_UNPCKLPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_UNPCKLPD_XMMpd_XMMq,96,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 444*/ XED_DEF_INST(XED_ICLASS_PREFETCHT2,XED_CATEGORY_PREFETCH,XED_EXTENSION_SSE,3,XED_IFORM_PREFETCHT2_MEMmprefetch,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 445*/ XED_DEF_INST(XED_ICLASS_PREFETCHT1,XED_CATEGORY_PREFETCH,XED_EXTENSION_SSE,3,XED_IFORM_PREFETCHT1_MEMmprefetch,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 446*/ XED_DEF_INST(XED_ICLASS_PREFETCHT0,XED_CATEGORY_PREFETCH,XED_EXTENSION_SSE,3,XED_IFORM_PREFETCHT0_MEMmprefetch,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 447*/ XED_DEF_INST(XED_ICLASS_LODSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_LODSD,735,4,39,0,62,XED_EXCEPTION_INVALID),
/* 448*/ XED_DEF_INST(XED_ICLASS_JNBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNBE_RELBRb,163,3,41,0,20,XED_EXCEPTION_INVALID),
/* 449*/ XED_DEF_INST(XED_ICLASS_JNBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNBE_RELBRb,166,3,41,0,20,XED_EXCEPTION_INVALID),
/* 450*/ XED_DEF_INST(XED_ICLASS_JNBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNBE_RELBRz,169,3,41,0,21,XED_EXCEPTION_INVALID),
/* 451*/ XED_DEF_INST(XED_ICLASS_JNBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JNBE_RELBRd,172,3,41,0,20,XED_EXCEPTION_INVALID),
/* 452*/ XED_DEF_INST(XED_ICLASS_CVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTTSS2SI_GPR32d_MEMss,739,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 453*/ XED_DEF_INST(XED_ICLASS_CVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTTSS2SI_GPR32d_XMMss,741,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 454*/ XED_DEF_INST(XED_ICLASS_CVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTTSS2SI_GPR64q_MEMss,743,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 455*/ XED_DEF_INST(XED_ICLASS_CVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTTSS2SI_GPR64q_XMMss,745,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 456*/ XED_DEF_INST(XED_ICLASS_PFCPIT1,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCPIT1_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 457*/ XED_DEF_INST(XED_ICLASS_PFCPIT1,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCPIT1_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 458*/ XED_DEF_INST(XED_ICLASS_PMOVSXDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXDQ_XMMdq_MEMq,747,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 459*/ XED_DEF_INST(XED_ICLASS_PMOVSXDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXDQ_XMMdq_XMMq,749,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 460*/ XED_DEF_INST(XED_ICLASS_CDQE,XED_CATEGORY_CONVERT,XED_EXTENSION_LONGMODE,3,XED_IFORM_CDQE,751,2,0,0,0,XED_EXCEPTION_INVALID),
/* 461*/ XED_DEF_INST(XED_ICLASS_FISUBR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISUBR_ST0_MEMmem32int,753,3,4,0,6,XED_EXCEPTION_INVALID),
/* 462*/ XED_DEF_INST(XED_ICLASS_FISUBR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISUBR_ST0_MEMmem16int,756,3,4,0,6,XED_EXCEPTION_INVALID),
/* 463*/ XED_DEF_INST(XED_ICLASS_AESDEC,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESDEC_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 464*/ XED_DEF_INST(XED_ICLASS_AESDEC,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESDEC_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 465*/ XED_DEF_INST(XED_ICLASS_PSADBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSADBW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 466*/ XED_DEF_INST(XED_ICLASS_PSADBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSADBW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 467*/ XED_DEF_INST(XED_ICLASS_PSADBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSADBW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 468*/ XED_DEF_INST(XED_ICLASS_PSADBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSADBW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 469*/ XED_DEF_INST(XED_ICLASS_SHA1RNDS4,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1RNDS4_XMMi32_XMMi32_IMM8_SHA,428,3,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 470*/ XED_DEF_INST(XED_ICLASS_SHA1RNDS4,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1RNDS4_XMMi32_MEMi32_IMM8_SHA,425,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 471*/ XED_DEF_INST(XED_ICLASS_FISUB,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISUB_ST0_MEMmem32int,753,3,4,0,6,XED_EXCEPTION_INVALID),
/* 472*/ XED_DEF_INST(XED_ICLASS_FISUB,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISUB_ST0_MEMmem16int,756,3,4,0,6,XED_EXCEPTION_INVALID),
/* 473*/ XED_DEF_INST(XED_ICLASS_STD,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_STD,759,1,42,0,64,XED_EXCEPTION_INVALID),
/* 474*/ XED_DEF_INST(XED_ICLASS_STOSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_STOSD,760,4,39,0,62,XED_EXCEPTION_INVALID),
/* 475*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_MEMb_IMMb_80r6,764,3,43,0,36,XED_EXCEPTION_INVALID),
/* 476*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPR8_IMMb_80r6,767,3,43,0,37,XED_EXCEPTION_INVALID),
/* 477*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_MEMv_IMMz,770,3,43,0,38,XED_EXCEPTION_INVALID),
/* 478*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPRv_IMMz,773,3,43,0,39,XED_EXCEPTION_INVALID),
/* 479*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_MEMb_IMMb_82r6,764,3,43,0,36,XED_EXCEPTION_INVALID),
/* 480*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPR8_IMMb_82r6,767,3,43,0,37,XED_EXCEPTION_INVALID),
/* 481*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_MEMv_IMMb,776,3,43,0,38,XED_EXCEPTION_INVALID),
/* 482*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPRv_IMMb,779,3,43,0,39,XED_EXCEPTION_INVALID),
/* 483*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_MEMb_GPR8,782,3,43,0,36,XED_EXCEPTION_INVALID),
/* 484*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPR8_GPR8_30,785,3,43,0,37,XED_EXCEPTION_INVALID),
/* 485*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_MEMv_GPRv,788,3,43,0,38,XED_EXCEPTION_INVALID),
/* 486*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPRv_GPRv_31,791,3,43,0,39,XED_EXCEPTION_INVALID),
/* 487*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPR8_GPR8_32,794,3,43,0,37,XED_EXCEPTION_INVALID),
/* 488*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPR8_MEMb,797,3,43,0,37,XED_EXCEPTION_INVALID),
/* 489*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPRv_GPRv_33,800,3,43,0,39,XED_EXCEPTION_INVALID),
/* 490*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_GPRv_MEMv,803,3,43,0,39,XED_EXCEPTION_INVALID),
/* 491*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_AL_IMMb,806,3,43,0,37,XED_EXCEPTION_INVALID),
/* 492*/ XED_DEF_INST(XED_ICLASS_XOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_OrAX_IMMz,809,3,43,0,39,XED_EXCEPTION_INVALID),
/* 493*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_MEMb_IMMb,764,3,1,1,37,XED_EXCEPTION_INVALID),
/* 494*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_GPR8_IMMb,767,3,2,1,37,XED_EXCEPTION_INVALID),
/* 495*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_MEMv_IMMb,812,3,3,1,39,XED_EXCEPTION_INVALID),
/* 496*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_GPRv_IMMb,815,3,4,1,39,XED_EXCEPTION_INVALID),
/* 497*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_MEMb_ONE,818,3,44,0,65,XED_EXCEPTION_INVALID),
/* 498*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_GPR8_ONE,821,3,44,0,65,XED_EXCEPTION_INVALID),
/* 499*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_MEMv_ONE,824,3,44,0,66,XED_EXCEPTION_INVALID),
/* 500*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_GPRv_ONE,827,3,44,0,66,XED_EXCEPTION_INVALID),
/* 501*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_MEMb_CL,830,3,46,0,37,XED_EXCEPTION_INVALID),
/* 502*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_GPR8_CL,833,3,46,0,37,XED_EXCEPTION_INVALID),
/* 503*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_MEMv_CL,836,3,46,0,39,XED_EXCEPTION_INVALID),
/* 504*/ XED_DEF_INST(XED_ICLASS_SAR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SAR_GPRv_CL,839,3,46,0,39,XED_EXCEPTION_INVALID),
/* 505*/ XED_DEF_INST(XED_ICLASS_STC,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_STC,759,1,47,0,0,XED_EXCEPTION_INVALID),
/* 506*/ XED_DEF_INST(XED_ICLASS_STI,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_STI,293,1,48,0,6,XED_EXCEPTION_INVALID),
/* 507*/ XED_DEF_INST(XED_ICLASS_LDMXCSR,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_LDMXCSR_MEMd,842,2,0,0,26,XED_EXCEPTION_SSE_TYPE_5),
/* 508*/ XED_DEF_INST(XED_ICLASS_SYSENTER,XED_CATEGORY_SYSCALL,XED_EXTENSION_BASE,3,XED_IFORM_SYSENTER,844,3,49,0,1,XED_EXCEPTION_INVALID),
/* 509*/ XED_DEF_INST(XED_ICLASS_SYSENTER,XED_CATEGORY_SYSCALL,XED_EXTENSION_BASE,3,XED_IFORM_SYSENTER,847,3,49,0,1,XED_EXCEPTION_INVALID),
/* 510*/ XED_DEF_INST(XED_ICLASS_ORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_ORPS_XMMxud_MEMxud,614,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 511*/ XED_DEF_INST(XED_ICLASS_ORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_ORPS_XMMxud_XMMxud,616,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 512*/ XED_DEF_INST(XED_ICLASS_FSUBP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUBP_X87_ST0,572,4,4,0,6,XED_EXCEPTION_INVALID),
/* 513*/ XED_DEF_INST(XED_ICLASS_STR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_STR_MEMw,850,2,0,0,1,XED_EXCEPTION_INVALID),
/* 514*/ XED_DEF_INST(XED_ICLASS_STR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_STR_GPRv,852,2,0,0,2,XED_EXCEPTION_INVALID),
/* 515*/ XED_DEF_INST(XED_ICLASS_FSUBR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUBR_ST0_MEMmem32real,269,3,4,0,6,XED_EXCEPTION_INVALID),
/* 516*/ XED_DEF_INST(XED_ICLASS_FSUBR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUBR_ST0_X87,272,3,4,0,6,XED_EXCEPTION_INVALID),
/* 517*/ XED_DEF_INST(XED_ICLASS_FSUBR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUBR_ST0_MEMm64real,275,3,4,0,6,XED_EXCEPTION_INVALID),
/* 518*/ XED_DEF_INST(XED_ICLASS_FSUBR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUBR_X87_ST0,278,3,4,0,6,XED_EXCEPTION_INVALID),
/* 519*/ XED_DEF_INST(XED_ICLASS_REP_LODSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REP_LODSQ,854,5,39,0,22,XED_EXCEPTION_INVALID),
/* 520*/ XED_DEF_INST(XED_ICLASS_REP_LODSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REP_LODSQ,854,5,39,0,22,XED_EXCEPTION_INVALID),
/* 521*/ XED_DEF_INST(XED_ICLASS_RSM,XED_CATEGORY_SYSRET,XED_EXTENSION_BASE,3,XED_IFORM_RSM,859,2,50,0,6,XED_EXCEPTION_INVALID),
/* 522*/ XED_DEF_INST(XED_ICLASS_CLFLUSHOPT,XED_CATEGORY_CLFLUSHOPT,XED_EXTENSION_CLFLUSHOPT,3,XED_IFORM_CLFLUSHOPT_MEMmprefetch,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 523*/ XED_DEF_INST(XED_ICLASS_PADDUSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDUSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 524*/ XED_DEF_INST(XED_ICLASS_PADDUSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDUSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/* 525*/ XED_DEF_INST(XED_ICLASS_PADDUSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDUSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 526*/ XED_DEF_INST(XED_ICLASS_PADDUSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDUSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 527*/ XED_DEF_INST(XED_ICLASS_STOSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_STOSB,861,4,39,0,61,XED_EXCEPTION_INVALID),
/* 528*/ XED_DEF_INST(XED_ICLASS_REP_LODSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_LODSW,865,5,39,0,22,XED_EXCEPTION_INVALID),
/* 529*/ XED_DEF_INST(XED_ICLASS_REP_LODSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_LODSW,865,5,39,0,22,XED_EXCEPTION_INVALID),
/* 530*/ XED_DEF_INST(XED_ICLASS_RDMSR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_RDMSR,870,4,0,0,15,XED_EXCEPTION_INVALID),
/* 531*/ XED_DEF_INST(XED_ICLASS_PMADDUBSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PMADDUBSW_MMXq_MEMq,435,2,0,0,67,XED_EXCEPTION_MMX_MEM),
/* 532*/ XED_DEF_INST(XED_ICLASS_PMADDUBSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PMADDUBSW_MMXq_MMXq,437,2,0,0,67,XED_EXCEPTION_MMX_MEM),
/* 533*/ XED_DEF_INST(XED_ICLASS_PMADDUBSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PMADDUBSW_XMMdq_MEMdq,439,2,0,0,43,XED_EXCEPTION_SSE_TYPE_4),
/* 534*/ XED_DEF_INST(XED_ICLASS_PMADDUBSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PMADDUBSW_XMMdq_XMMdq,441,2,0,0,43,XED_EXCEPTION_SSE_TYPE_4),
/* 535*/ XED_DEF_INST(XED_ICLASS_RSTORSSP,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_RSTORSSP_MEMu64,874,2,0,0,0,XED_EXCEPTION_INVALID),
/* 536*/ XED_DEF_INST(XED_ICLASS_INCSSPQ,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_INCSSPQ_GPR64u8,876,2,0,0,0,XED_EXCEPTION_INVALID),
/* 537*/ XED_DEF_INST(XED_ICLASS_REP_LODSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_LODSB,878,5,39,0,25,XED_EXCEPTION_INVALID),
/* 538*/ XED_DEF_INST(XED_ICLASS_REP_LODSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_LODSB,878,5,39,0,25,XED_EXCEPTION_INVALID),
/* 539*/ XED_DEF_INST(XED_ICLASS_REP_LODSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_LODSD,883,5,39,0,22,XED_EXCEPTION_INVALID),
/* 540*/ XED_DEF_INST(XED_ICLASS_REP_LODSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_LODSD,883,5,39,0,22,XED_EXCEPTION_INVALID),
/* 541*/ XED_DEF_INST(XED_ICLASS_PADDUSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDUSB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 542*/ XED_DEF_INST(XED_ICLASS_PADDUSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDUSB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/* 543*/ XED_DEF_INST(XED_ICLASS_PADDUSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDUSB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 544*/ XED_DEF_INST(XED_ICLASS_PADDUSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDUSB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 545*/ XED_DEF_INST(XED_ICLASS_VMREAD,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMREAD_MEMq_GPR64,888,3,20,0,0,XED_EXCEPTION_INVALID),
/* 546*/ XED_DEF_INST(XED_ICLASS_VMREAD,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMREAD_GPR64_GPR64,891,3,20,0,0,XED_EXCEPTION_INVALID),
/* 547*/ XED_DEF_INST(XED_ICLASS_VMREAD,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMREAD_MEMd_GPR32,894,3,20,0,0,XED_EXCEPTION_INVALID),
/* 548*/ XED_DEF_INST(XED_ICLASS_VMREAD,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMREAD_GPR32_GPR32,897,3,20,0,0,XED_EXCEPTION_INVALID),
/* 549*/ XED_DEF_INST(XED_ICLASS_XSAVEOPT64,XED_CATEGORY_XSAVEOPT,XED_EXTENSION_XSAVEOPT,3,XED_IFORM_XSAVEOPT64_MEMmxsave,900,4,0,0,68,XED_EXCEPTION_INVALID),
/* 550*/ XED_DEF_INST(XED_ICLASS_PAVGUSB,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PAVGUSB_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 551*/ XED_DEF_INST(XED_ICLASS_PAVGUSB,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PAVGUSB_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 552*/ XED_DEF_INST(XED_ICLASS_NOT_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_NOT_LOCK_MEMb,497,1,0,0,53,XED_EXCEPTION_INVALID),
/* 553*/ XED_DEF_INST(XED_ICLASS_NOT_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_NOT_LOCK_MEMv,499,1,0,0,54,XED_EXCEPTION_INVALID),
/* 554*/ XED_DEF_INST(XED_ICLASS_POPFD,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POPFD,904,4,1,0,5,XED_EXCEPTION_INVALID),
/* 555*/ XED_DEF_INST(XED_ICLASS_HSUBPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HSUBPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 556*/ XED_DEF_INST(XED_ICLASS_HSUBPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HSUBPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 557*/ XED_DEF_INST(XED_ICLASS_MOVNTDQA,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_MOVNTDQA_XMMdq_MEMdq,470,2,0,0,69,XED_EXCEPTION_SSE_TYPE_1),
/* 558*/ XED_DEF_INST(XED_ICLASS_FILD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FILD_ST0_MEMmem32int,908,4,4,0,6,XED_EXCEPTION_INVALID),
/* 559*/ XED_DEF_INST(XED_ICLASS_FILD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FILD_ST0_MEMmem16int,912,4,4,0,6,XED_EXCEPTION_INVALID),
/* 560*/ XED_DEF_INST(XED_ICLASS_FILD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FILD_ST0_MEMm64int,916,4,4,0,6,XED_EXCEPTION_INVALID),
/* 561*/ XED_DEF_INST(XED_ICLASS_HSUBPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HSUBPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 562*/ XED_DEF_INST(XED_ICLASS_HSUBPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HSUBPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 563*/ XED_DEF_INST(XED_ICLASS_CVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPS2DQ_XMMdq_MEMps,294,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 564*/ XED_DEF_INST(XED_ICLASS_CVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPS2DQ_XMMdq_XMMps,296,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 565*/ XED_DEF_INST(XED_ICLASS_SYSCALL,XED_CATEGORY_SYSCALL,XED_EXTENSION_LONGMODE,3,XED_IFORM_SYSCALL,920,4,51,0,6,XED_EXCEPTION_INVALID),
/* 566*/ XED_DEF_INST(XED_ICLASS_MWAITX,XED_CATEGORY_MISC,XED_EXTENSION_MONITORX,3,XED_IFORM_MWAITX,924,2,0,0,8,XED_EXCEPTION_INVALID),
/* 567*/ XED_DEF_INST(XED_ICLASS_PMOVSXBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXBW_XMMdq_MEMq,926,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 568*/ XED_DEF_INST(XED_ICLASS_PMOVSXBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXBW_XMMdq_XMMq,928,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 569*/ XED_DEF_INST(XED_ICLASS_FADD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FADD_ST0_MEMmem32real,269,3,4,0,6,XED_EXCEPTION_INVALID),
/* 570*/ XED_DEF_INST(XED_ICLASS_FADD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FADD_ST0_X87,272,3,4,0,6,XED_EXCEPTION_INVALID),
/* 571*/ XED_DEF_INST(XED_ICLASS_FADD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FADD_ST0_MEMm64real,275,3,4,0,6,XED_EXCEPTION_INVALID),
/* 572*/ XED_DEF_INST(XED_ICLASS_FADD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FADD_X87_ST0,278,3,4,0,6,XED_EXCEPTION_INVALID),
/* 573*/ XED_DEF_INST(XED_ICLASS_FYL2XP1,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FYL2XP1,409,4,4,0,6,XED_EXCEPTION_INVALID),
/* 574*/ XED_DEF_INST(XED_ICLASS_XEND,XED_CATEGORY_COND_BR,XED_EXTENSION_RTM,3,XED_IFORM_XEND,0,0,0,0,0,XED_EXCEPTION_INVALID),
/* 575*/ XED_DEF_INST(XED_ICLASS_AESKEYGENASSIST,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESKEYGENASSIST_XMMdq_XMMdq_IMMb,930,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 576*/ XED_DEF_INST(XED_ICLASS_AESKEYGENASSIST,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESKEYGENASSIST_XMMdq_MEMdq_IMMb,933,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 577*/ XED_DEF_INST(XED_ICLASS_PACKSSDW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PACKSSDW_MMXq_MEMq,443,2,0,0,46,XED_EXCEPTION_MMX_MEM),
/* 578*/ XED_DEF_INST(XED_ICLASS_PACKSSDW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PACKSSDW_MMXq_MMXq,445,2,0,0,46,XED_EXCEPTION_INVALID),
/* 579*/ XED_DEF_INST(XED_ICLASS_PACKSSDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PACKSSDW_XMMdq_MEMdq,148,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/* 580*/ XED_DEF_INST(XED_ICLASS_PACKSSDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PACKSSDW_XMMdq_XMMdq,285,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/* 581*/ XED_DEF_INST(XED_ICLASS_VMPTRST,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMPTRST_MEMq,936,2,20,0,6,XED_EXCEPTION_INVALID),
/* 582*/ XED_DEF_INST(XED_ICLASS_FRNDINT,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FRNDINT,140,2,4,0,6,XED_EXCEPTION_INVALID),
/* 583*/ XED_DEF_INST(XED_ICLASS_PMULLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMULLW_MMXq_MEMq,417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 584*/ XED_DEF_INST(XED_ICLASS_PMULLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMULLW_MMXq_MMXq,419,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 585*/ XED_DEF_INST(XED_ICLASS_PMULLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULLW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 586*/ XED_DEF_INST(XED_ICLASS_PMULLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULLW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 587*/ XED_DEF_INST(XED_ICLASS_DIVSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_DIVSD_XMMsd_MEMsd,938,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 588*/ XED_DEF_INST(XED_ICLASS_DIVSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_DIVSD_XMMsd_XMMsd,940,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 589*/ XED_DEF_INST(XED_ICLASS_MOVMSKPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVMSKPS_GPR32_XMMps,942,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/* 590*/ XED_DEF_INST(XED_ICLASS_FSETPM287_NOP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSETPM287_NOP,0,0,0,0,63,XED_EXCEPTION_INVALID),
/* 591*/ XED_DEF_INST(XED_ICLASS_PMULLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMULLD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 592*/ XED_DEF_INST(XED_ICLASS_PMULLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMULLD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 593*/ XED_DEF_INST(XED_ICLASS_PHSUBSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 594*/ XED_DEF_INST(XED_ICLASS_PHSUBSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 595*/ XED_DEF_INST(XED_ICLASS_PHSUBSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 596*/ XED_DEF_INST(XED_ICLASS_PHSUBSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHSUBSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 597*/ XED_DEF_INST(XED_ICLASS_PUSHAD,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSHAD,944,11,0,0,70,XED_EXCEPTION_INVALID),
/* 598*/ XED_DEF_INST(XED_ICLASS_DIVSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_DIVSS_XMMss_MEMss,413,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 599*/ XED_DEF_INST(XED_ICLASS_DIVSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_DIVSS_XMMss_XMMss,415,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 600*/ XED_DEF_INST(XED_ICLASS_PCMPEQQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPEQQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 601*/ XED_DEF_INST(XED_ICLASS_PCMPEQQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPEQQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 602*/ XED_DEF_INST(XED_ICLASS_PREFETCH_EXCLUSIVE,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCH_EXCLUSIVE_MEMmprefetch,193,1,0,0,24,XED_EXCEPTION_INVALID),
/* 603*/ XED_DEF_INST(XED_ICLASS_PCMPEQW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPEQW_MMXq_MEMq,417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 604*/ XED_DEF_INST(XED_ICLASS_PCMPEQW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPEQW_MMXq_MMXq,419,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 605*/ XED_DEF_INST(XED_ICLASS_PCMPEQW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPEQW_XMMdq_MEMdq,421,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 606*/ XED_DEF_INST(XED_ICLASS_PCMPEQW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPEQW_XMMdq_XMMdq,423,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 607*/ XED_DEF_INST(XED_ICLASS_REPNE_CMPSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REPNE_CMPSQ,955,6,7,0,71,XED_EXCEPTION_INVALID),
/* 608*/ XED_DEF_INST(XED_ICLASS_RCPSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RCPSS_XMMss_MEMss,961,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 609*/ XED_DEF_INST(XED_ICLASS_RCPSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RCPSS_XMMss_XMMss,963,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 610*/ XED_DEF_INST(XED_ICLASS_IDIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IDIV_MEMb,965,3,52,0,37,XED_EXCEPTION_INVALID),
/* 611*/ XED_DEF_INST(XED_ICLASS_IDIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IDIV_GPR8,968,3,52,0,37,XED_EXCEPTION_INVALID),
/* 612*/ XED_DEF_INST(XED_ICLASS_IDIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IDIV_MEMv,971,4,52,0,39,XED_EXCEPTION_INVALID),
/* 613*/ XED_DEF_INST(XED_ICLASS_IDIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IDIV_GPRv,975,4,52,0,39,XED_EXCEPTION_INVALID),
/* 614*/ XED_DEF_INST(XED_ICLASS_PCMPEQB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPEQB_MMXq_MEMq,435,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 615*/ XED_DEF_INST(XED_ICLASS_PCMPEQB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPEQB_MMXq_MMXq,437,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 616*/ XED_DEF_INST(XED_ICLASS_PCMPEQB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPEQB_XMMdq_MEMdq,439,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 617*/ XED_DEF_INST(XED_ICLASS_PCMPEQB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPEQB_XMMdq_XMMdq,441,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 618*/ XED_DEF_INST(XED_ICLASS_PCMPEQD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPEQD_MMXq_MEMq,443,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 619*/ XED_DEF_INST(XED_ICLASS_PCMPEQD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PCMPEQD_MMXq_MMXq,445,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 620*/ XED_DEF_INST(XED_ICLASS_PCMPEQD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPEQD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 621*/ XED_DEF_INST(XED_ICLASS_PCMPEQD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PCMPEQD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 622*/ XED_DEF_INST(XED_ICLASS_PUSHFD,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSHFD,979,4,24,0,49,XED_EXCEPTION_INVALID),
/* 623*/ XED_DEF_INST(XED_ICLASS_REPNE_CMPSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPNE_CMPSB,983,6,7,0,72,XED_EXCEPTION_INVALID),
/* 624*/ XED_DEF_INST(XED_ICLASS_REPNE_CMPSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPNE_CMPSD,989,6,7,0,71,XED_EXCEPTION_INVALID),
/* 625*/ XED_DEF_INST(XED_ICLASS_PUNPCKLQDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLQDQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 626*/ XED_DEF_INST(XED_ICLASS_PUNPCKLQDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLQDQ_XMMdq_XMMq,150,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 627*/ XED_DEF_INST(XED_ICLASS_HADDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HADDPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 628*/ XED_DEF_INST(XED_ICLASS_HADDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HADDPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 629*/ XED_DEF_INST(XED_ICLASS_MOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE3,3,XED_IFORM_MOVSHDUP_XMMps_MEMps,995,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 630*/ XED_DEF_INST(XED_ICLASS_MOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE3,3,XED_IFORM_MOVSHDUP_XMMps_XMMps,997,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 631*/ XED_DEF_INST(XED_ICLASS_VMLAUNCH,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMLAUNCH,999,1,53,0,6,XED_EXCEPTION_INVALID),
/* 632*/ XED_DEF_INST(XED_ICLASS_HADDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HADDPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 633*/ XED_DEF_INST(XED_ICLASS_HADDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_HADDPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 634*/ XED_DEF_INST(XED_ICLASS_STAC,XED_CATEGORY_SMAP,XED_EXTENSION_SMAP,0,XED_IFORM_STAC,759,1,54,0,0,XED_EXCEPTION_INVALID),
/* 635*/ XED_DEF_INST(XED_ICLASS_PUNPCKLWD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKLWD_MMXq_MEMd,1000,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 636*/ XED_DEF_INST(XED_ICLASS_PUNPCKLWD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKLWD_MMXq_MMXd,1002,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 637*/ XED_DEF_INST(XED_ICLASS_PUNPCKLWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLWD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 638*/ XED_DEF_INST(XED_ICLASS_PUNPCKLWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLWD_XMMdq_XMMq,150,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 639*/ XED_DEF_INST(XED_ICLASS_FNCLEX,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNCLEX,1004,1,55,0,73,XED_EXCEPTION_INVALID),
/* 640*/ XED_DEF_INST(XED_ICLASS_RDSSPQ,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_RDSSPQ_GPR64u64,1005,2,0,0,0,XED_EXCEPTION_INVALID),
/* 641*/ XED_DEF_INST(XED_ICLASS_XSAVES,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVES,0,XED_IFORM_XSAVES_MEMmxsave,400,4,0,0,40,XED_EXCEPTION_INVALID),
/* 642*/ XED_DEF_INST(XED_ICLASS_LOOPNE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPNE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 643*/ XED_DEF_INST(XED_ICLASS_LOOPNE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPNE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 644*/ XED_DEF_INST(XED_ICLASS_LOOPNE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPNE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 645*/ XED_DEF_INST(XED_ICLASS_LOOPNE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPNE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 646*/ XED_DEF_INST(XED_ICLASS_ADOX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADOX_GPR32d_GPR32d,1011,3,57,0,0,XED_EXCEPTION_INVALID),
/* 647*/ XED_DEF_INST(XED_ICLASS_ADOX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADOX_GPR32d_MEMd,1014,3,57,0,0,XED_EXCEPTION_INVALID),
/* 648*/ XED_DEF_INST(XED_ICLASS_ADOX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADOX_GPR64q_GPR64q,1017,3,57,0,0,XED_EXCEPTION_INVALID),
/* 649*/ XED_DEF_INST(XED_ICLASS_ADOX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADOX_GPR64q_MEMq,1020,3,57,0,0,XED_EXCEPTION_INVALID),
/* 650*/ XED_DEF_INST(XED_ICLASS_PADDSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 651*/ XED_DEF_INST(XED_ICLASS_PADDSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 652*/ XED_DEF_INST(XED_ICLASS_PADDSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 653*/ XED_DEF_INST(XED_ICLASS_PADDSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 654*/ XED_DEF_INST(XED_ICLASS_ORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_ORPD_XMMxuq_MEMxuq,602,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 655*/ XED_DEF_INST(XED_ICLASS_ORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_ORPD_XMMxuq_XMMxuq,604,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 656*/ XED_DEF_INST(XED_ICLASS_PMINSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINSD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 657*/ XED_DEF_INST(XED_ICLASS_PMINSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINSD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 658*/ XED_DEF_INST(XED_ICLASS_FPTAN,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FPTAN,647,3,58,0,6,XED_EXCEPTION_INVALID),
/* 659*/ XED_DEF_INST(XED_ICLASS_FIDIV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIDIV_ST0_MEMmem32int,753,3,4,0,6,XED_EXCEPTION_INVALID),
/* 660*/ XED_DEF_INST(XED_ICLASS_FIDIV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIDIV_ST0_MEMmem16int,756,3,4,0,6,XED_EXCEPTION_INVALID),
/* 661*/ XED_DEF_INST(XED_ICLASS_PXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_PXOR_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 662*/ XED_DEF_INST(XED_ICLASS_PXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_PXOR_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 663*/ XED_DEF_INST(XED_ICLASS_PXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_PXOR_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 664*/ XED_DEF_INST(XED_ICLASS_PXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_PXOR_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 665*/ XED_DEF_INST(XED_ICLASS_VMPTRLD,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMPTRLD_MEMq,447,2,20,0,6,XED_EXCEPTION_INVALID),
/* 666*/ XED_DEF_INST(XED_ICLASS_CLRSSBSY,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_CLRSSBSY_MEMu64,1023,1,0,0,0,XED_EXCEPTION_INVALID),
/* 667*/ XED_DEF_INST(XED_ICLASS_CLDEMOTE,XED_CATEGORY_CLDEMOTE,XED_EXTENSION_CLDEMOTE,3,XED_IFORM_CLDEMOTE_MEMu8,1024,1,0,0,0,XED_EXCEPTION_INVALID),
/* 668*/ XED_DEF_INST(XED_ICLASS_SETS,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETS_MEMb,596,2,59,0,37,XED_EXCEPTION_INVALID),
/* 669*/ XED_DEF_INST(XED_ICLASS_SETS,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETS_GPR8,598,2,59,0,37,XED_EXCEPTION_INVALID),
/* 670*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_MEMb_IMMb,764,3,5,1,37,XED_EXCEPTION_INVALID),
/* 671*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_GPR8_IMMb,767,3,6,1,37,XED_EXCEPTION_INVALID),
/* 672*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_MEMv_IMMb,812,3,7,1,39,XED_EXCEPTION_INVALID),
/* 673*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_GPRv_IMMb,815,3,8,1,39,XED_EXCEPTION_INVALID),
/* 674*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_MEMb_ONE,818,3,44,0,65,XED_EXCEPTION_INVALID),
/* 675*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_GPR8_ONE,821,3,44,0,65,XED_EXCEPTION_INVALID),
/* 676*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_MEMv_ONE,824,3,44,0,66,XED_EXCEPTION_INVALID),
/* 677*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_GPRv_ONE,827,3,44,0,66,XED_EXCEPTION_INVALID),
/* 678*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_MEMb_CL,830,3,46,0,37,XED_EXCEPTION_INVALID),
/* 679*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_GPR8_CL,833,3,46,0,37,XED_EXCEPTION_INVALID),
/* 680*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_MEMv_CL,836,3,46,0,39,XED_EXCEPTION_INVALID),
/* 681*/ XED_DEF_INST(XED_ICLASS_SHR,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHR_GPRv_CL,839,3,46,0,39,XED_EXCEPTION_INVALID),
/* 682*/ XED_DEF_INST(XED_ICLASS_SHRD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHRD_MEMv_GPRv_IMMb,1025,4,9,1,39,XED_EXCEPTION_INVALID),
/* 683*/ XED_DEF_INST(XED_ICLASS_SHRD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHRD_GPRv_GPRv_IMMb,1029,4,10,1,39,XED_EXCEPTION_INVALID),
/* 684*/ XED_DEF_INST(XED_ICLASS_SHRD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHRD_MEMv_GPRv_CL,1033,4,46,0,39,XED_EXCEPTION_INVALID),
/* 685*/ XED_DEF_INST(XED_ICLASS_SHRD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHRD_GPRv_GPRv_CL,1037,4,46,0,39,XED_EXCEPTION_INVALID),
/* 686*/ XED_DEF_INST(XED_ICLASS_MONITOR,XED_CATEGORY_MISC,XED_EXTENSION_MONITOR,0,XED_IFORM_MONITOR,1041,3,0,0,15,XED_EXCEPTION_INVALID),
/* 687*/ XED_DEF_INST(XED_ICLASS_MONITOR,XED_CATEGORY_MISC,XED_EXTENSION_MONITOR,0,XED_IFORM_MONITOR,1044,3,0,0,15,XED_EXCEPTION_INVALID),
/* 688*/ XED_DEF_INST(XED_ICLASS_MONITOR,XED_CATEGORY_MISC,XED_EXTENSION_MONITOR,0,XED_IFORM_MONITOR,1047,3,0,0,15,XED_EXCEPTION_INVALID),
/* 689*/ XED_DEF_INST(XED_ICLASS_MONITOR,XED_CATEGORY_MISC,XED_EXTENSION_MONITOR,0,XED_IFORM_MONITOR,1047,3,0,0,15,XED_EXCEPTION_INVALID),
/* 690*/ XED_DEF_INST(XED_ICLASS_XABORT,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_RTM,3,XED_IFORM_XABORT_IMMb,1050,2,0,0,0,XED_EXCEPTION_INVALID),
/* 691*/ XED_DEF_INST(XED_ICLASS_AESENCLAST,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESENCLAST_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 692*/ XED_DEF_INST(XED_ICLASS_AESENCLAST,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESENCLAST_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 693*/ XED_DEF_INST(XED_ICLASS_MOVSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_MOVSD,1052,5,39,0,52,XED_EXCEPTION_INVALID),
/* 694*/ XED_DEF_INST(XED_ICLASS_MOVSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_MOVSB,1057,5,39,0,55,XED_EXCEPTION_INVALID),
/* 695*/ XED_DEF_INST(XED_ICLASS_CMPPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_CMPPD_XMMpd_MEMpd_IMMb,1062,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 696*/ XED_DEF_INST(XED_ICLASS_CMPPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_CMPPD_XMMpd_XMMpd_IMMb,1065,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 697*/ XED_DEF_INST(XED_ICLASS_MOVLHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVLHPS_XMMq_XMMq,1068,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/* 698*/ XED_DEF_INST(XED_ICLASS_MOVQ2DQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ2DQ_XMMdq_MMXq,1070,2,0,0,74,XED_EXCEPTION_INVALID),
/* 699*/ XED_DEF_INST(XED_ICLASS_SQRTSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SQRTSS_XMMss_MEMss,961,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 700*/ XED_DEF_INST(XED_ICLASS_SQRTSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SQRTSS_XMMss_XMMss,963,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 701*/ XED_DEF_INST(XED_ICLASS_SUBSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SUBSS_XMMss_MEMss,413,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 702*/ XED_DEF_INST(XED_ICLASS_SUBSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SUBSS_XMMss_XMMss,415,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 703*/ XED_DEF_INST(XED_ICLASS_MOVSX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVSX_GPRv_MEMb,1072,2,0,0,39,XED_EXCEPTION_INVALID),
/* 704*/ XED_DEF_INST(XED_ICLASS_MOVSX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVSX_GPRv_GPR8,1074,2,0,0,39,XED_EXCEPTION_INVALID),
/* 705*/ XED_DEF_INST(XED_ICLASS_MOVSX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVSX_GPRv_MEMw,1076,2,0,0,39,XED_EXCEPTION_INVALID),
/* 706*/ XED_DEF_INST(XED_ICLASS_MOVSX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVSX_GPRv_GPR16,1078,2,0,0,39,XED_EXCEPTION_INVALID),
/* 707*/ XED_DEF_INST(XED_ICLASS_MOVSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_MOVSW,1080,5,39,0,52,XED_EXCEPTION_INVALID),
/* 708*/ XED_DEF_INST(XED_ICLASS_CMPPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_CMPPS_XMMps_MEMps_IMMb,1085,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 709*/ XED_DEF_INST(XED_ICLASS_CMPPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_CMPPS_XMMps_XMMps_IMMb,569,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 710*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMb_IMMb_C0r4,764,3,11,1,37,XED_EXCEPTION_INVALID),
/* 711*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPR8_IMMb_C0r4,767,3,12,1,37,XED_EXCEPTION_INVALID),
/* 712*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMb_IMMb_C0r6,764,3,13,1,37,XED_EXCEPTION_INVALID),
/* 713*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPR8_IMMb_C0r6,767,3,14,1,37,XED_EXCEPTION_INVALID),
/* 714*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMv_IMMb_C1r4,812,3,15,1,39,XED_EXCEPTION_INVALID),
/* 715*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPRv_IMMb_C1r4,815,3,16,1,39,XED_EXCEPTION_INVALID),
/* 716*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMv_IMMb_C1r6,812,3,17,1,39,XED_EXCEPTION_INVALID),
/* 717*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPRv_IMMb_C1r6,815,3,18,1,39,XED_EXCEPTION_INVALID),
/* 718*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMb_ONE_D0r4,818,3,44,0,65,XED_EXCEPTION_INVALID),
/* 719*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPR8_ONE_D0r4,821,3,44,0,65,XED_EXCEPTION_INVALID),
/* 720*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMb_ONE_D0r6,818,3,44,0,65,XED_EXCEPTION_INVALID),
/* 721*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPR8_ONE_D0r6,821,3,44,0,65,XED_EXCEPTION_INVALID),
/* 722*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMv_ONE_D1r6,824,3,44,0,66,XED_EXCEPTION_INVALID),
/* 723*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPRv_ONE_D1r6,827,3,44,0,66,XED_EXCEPTION_INVALID),
/* 724*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMv_ONE_D1r4,824,3,44,0,66,XED_EXCEPTION_INVALID),
/* 725*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPRv_ONE_D1r4,827,3,44,0,66,XED_EXCEPTION_INVALID),
/* 726*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMb_CL_D2r4,830,3,46,0,37,XED_EXCEPTION_INVALID),
/* 727*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPR8_CL_D2r4,833,3,46,0,37,XED_EXCEPTION_INVALID),
/* 728*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMb_CL_D2r6,830,3,46,0,37,XED_EXCEPTION_INVALID),
/* 729*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPR8_CL_D2r6,833,3,46,0,37,XED_EXCEPTION_INVALID),
/* 730*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMv_CL_D3r4,836,3,46,0,39,XED_EXCEPTION_INVALID),
/* 731*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPRv_CL_D3r4,839,3,46,0,39,XED_EXCEPTION_INVALID),
/* 732*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_MEMv_CL_D3r6,836,3,46,0,39,XED_EXCEPTION_INVALID),
/* 733*/ XED_DEF_INST(XED_ICLASS_SHL,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHL_GPRv_CL_D3r6,839,3,46,0,39,XED_EXCEPTION_INVALID),
/* 734*/ XED_DEF_INST(XED_ICLASS_MOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVSS_XMMdq_MEMss,1088,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 735*/ XED_DEF_INST(XED_ICLASS_MOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVSS_XMMss_XMMss_0F10,963,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 736*/ XED_DEF_INST(XED_ICLASS_MOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVSS_MEMss_XMMss,1090,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 737*/ XED_DEF_INST(XED_ICLASS_MOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVSS_XMMss_XMMss_0F11,1092,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/* 738*/ XED_DEF_INST(XED_ICLASS_MOVSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_MOVSQ,1094,5,39,0,52,XED_EXCEPTION_INVALID),
/* 739*/ XED_DEF_INST(XED_ICLASS_MOV_CR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_CR_CR_GPR32,1099,2,0,0,15,XED_EXCEPTION_INVALID),
/* 740*/ XED_DEF_INST(XED_ICLASS_MOV_CR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_CR_CR_GPR64,1101,2,0,0,15,XED_EXCEPTION_INVALID),
/* 741*/ XED_DEF_INST(XED_ICLASS_MOV_CR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_CR_GPR32_CR,1103,2,0,0,16,XED_EXCEPTION_INVALID),
/* 742*/ XED_DEF_INST(XED_ICLASS_MOV_CR,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,0,XED_IFORM_MOV_CR_GPR64_CR,1105,2,0,0,16,XED_EXCEPTION_INVALID),
/* 743*/ XED_DEF_INST(XED_ICLASS_PFNACC,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFNACC_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 744*/ XED_DEF_INST(XED_ICLASS_PFNACC,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFNACC_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 745*/ XED_DEF_INST(XED_ICLASS_MOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQU_XMMdq_MEMdq,470,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/* 746*/ XED_DEF_INST(XED_ICLASS_MOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQU_XMMdq_XMMdq_0F6F,472,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/* 747*/ XED_DEF_INST(XED_ICLASS_MOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQU_MEMdq_XMMdq,1107,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/* 748*/ XED_DEF_INST(XED_ICLASS_MOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQU_XMMdq_XMMdq_0F7F,1109,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/* 749*/ XED_DEF_INST(XED_ICLASS_FCOS,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOS,140,2,58,0,6,XED_EXCEPTION_INVALID),
/* 750*/ XED_DEF_INST(XED_ICLASS_PSUBB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 751*/ XED_DEF_INST(XED_ICLASS_PSUBB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 752*/ XED_DEF_INST(XED_ICLASS_PSUBB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 753*/ XED_DEF_INST(XED_ICLASS_PSUBB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 754*/ XED_DEF_INST(XED_ICLASS_BTS,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTS_MEMv_IMMb,812,3,60,0,38,XED_EXCEPTION_INVALID),
/* 755*/ XED_DEF_INST(XED_ICLASS_BTS,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTS_GPRv_IMMb,815,3,60,0,39,XED_EXCEPTION_INVALID),
/* 756*/ XED_DEF_INST(XED_ICLASS_BTS,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTS_MEMv_GPRv,788,3,60,0,38,XED_EXCEPTION_INVALID),
/* 757*/ XED_DEF_INST(XED_ICLASS_BTS,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTS_GPRv_GPRv,791,3,60,0,39,XED_EXCEPTION_INVALID),
/* 758*/ XED_DEF_INST(XED_ICLASS_BTR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTR_MEMv_IMMb,812,3,60,0,38,XED_EXCEPTION_INVALID),
/* 759*/ XED_DEF_INST(XED_ICLASS_BTR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTR_GPRv_IMMb,815,3,60,0,39,XED_EXCEPTION_INVALID),
/* 760*/ XED_DEF_INST(XED_ICLASS_BTR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTR_MEMv_GPRv,788,3,60,0,38,XED_EXCEPTION_INVALID),
/* 761*/ XED_DEF_INST(XED_ICLASS_BTR,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTR_GPRv_GPRv,791,3,60,0,39,XED_EXCEPTION_INVALID),
/* 762*/ XED_DEF_INST(XED_ICLASS_SGDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SGDT_MEMs64,1111,2,0,0,6,XED_EXCEPTION_INVALID),
/* 763*/ XED_DEF_INST(XED_ICLASS_SGDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SGDT_MEMs,1113,2,0,0,7,XED_EXCEPTION_INVALID),
/* 764*/ XED_DEF_INST(XED_ICLASS_PSUBUSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBUSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 765*/ XED_DEF_INST(XED_ICLASS_PSUBUSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBUSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 766*/ XED_DEF_INST(XED_ICLASS_PSUBUSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBUSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 767*/ XED_DEF_INST(XED_ICLASS_PSUBUSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBUSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 768*/ XED_DEF_INST(XED_ICLASS_FSCALE,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSCALE,1115,3,4,0,6,XED_EXCEPTION_INVALID),
/* 769*/ XED_DEF_INST(XED_ICLASS_PSUBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 770*/ XED_DEF_INST(XED_ICLASS_PSUBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 771*/ XED_DEF_INST(XED_ICLASS_PSUBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 772*/ XED_DEF_INST(XED_ICLASS_PSUBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 773*/ XED_DEF_INST(XED_ICLASS_PACKUSDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PACKUSDW_XMMdq_MEMdq,148,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/* 774*/ XED_DEF_INST(XED_ICLASS_PACKUSDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PACKUSDW_XMMdq_XMMdq,285,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/* 775*/ XED_DEF_INST(XED_ICLASS_LOOP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOP_RELBRb,1118,3,0,0,0,XED_EXCEPTION_INVALID),
/* 776*/ XED_DEF_INST(XED_ICLASS_BTC,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTC_MEMv_IMMb,812,3,60,0,38,XED_EXCEPTION_INVALID),
/* 777*/ XED_DEF_INST(XED_ICLASS_BTC,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTC_GPRv_IMMb,815,3,60,0,39,XED_EXCEPTION_INVALID),
/* 778*/ XED_DEF_INST(XED_ICLASS_BTC,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTC_MEMv_GPRv,788,3,60,0,38,XED_EXCEPTION_INVALID),
/* 779*/ XED_DEF_INST(XED_ICLASS_BTC,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTC_GPRv_GPRv,791,3,60,0,39,XED_EXCEPTION_INVALID),
/* 780*/ XED_DEF_INST(XED_ICLASS_EXTRACTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_EXTRACTPS_MEMd_XMMps_IMMb,1121,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 781*/ XED_DEF_INST(XED_ICLASS_EXTRACTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_EXTRACTPS_GPR32d_XMMdq_IMMb,1124,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 782*/ XED_DEF_INST(XED_ICLASS_AESIMC,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESIMC_XMMdq_XMMdq,472,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 783*/ XED_DEF_INST(XED_ICLASS_AESIMC,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESIMC_XMMdq_MEMdq,470,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 784*/ XED_DEF_INST(XED_ICLASS_FCOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOM_ST0_MEMmem32real,1127,3,3,0,6,XED_EXCEPTION_INVALID),
/* 785*/ XED_DEF_INST(XED_ICLASS_FCOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOM_ST0_MEMm64real,1130,3,3,0,6,XED_EXCEPTION_INVALID),
/* 786*/ XED_DEF_INST(XED_ICLASS_FCOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOM_ST0_X87,152,3,3,0,6,XED_EXCEPTION_INVALID),
/* 787*/ XED_DEF_INST(XED_ICLASS_FCOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FCOM_ST0_X87_DCD0,152,3,3,0,6,XED_EXCEPTION_INVALID),
/* 788*/ XED_DEF_INST(XED_ICLASS_PUSHFQ,XED_CATEGORY_PUSH,XED_EXTENSION_LONGMODE,3,XED_IFORM_PUSHFQ,1133,4,24,0,49,XED_EXCEPTION_INVALID),
/* 789*/ XED_DEF_INST(XED_ICLASS_IRETD,XED_CATEGORY_RET,XED_EXTENSION_BASE,3,XED_IFORM_IRETD,1137,5,61,0,75,XED_EXCEPTION_INVALID),
/* 790*/ XED_DEF_INST(XED_ICLASS_WBINVD,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_WBINVD,0,0,0,0,15,XED_EXCEPTION_INVALID),
/* 791*/ XED_DEF_INST(XED_ICLASS_WBINVD,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_WBINVD,0,0,0,0,15,XED_EXCEPTION_INVALID),
/* 792*/ XED_DEF_INST(XED_ICLASS_REP_MOVSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REP_MOVSQ,1142,6,39,0,71,XED_EXCEPTION_INVALID),
/* 793*/ XED_DEF_INST(XED_ICLASS_REP_MOVSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REP_MOVSQ,1142,6,39,0,71,XED_EXCEPTION_INVALID),
/* 794*/ XED_DEF_INST(XED_ICLASS_JBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JBE_RELBRb,163,3,41,0,20,XED_EXCEPTION_INVALID),
/* 795*/ XED_DEF_INST(XED_ICLASS_JBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JBE_RELBRb,166,3,41,0,20,XED_EXCEPTION_INVALID),
/* 796*/ XED_DEF_INST(XED_ICLASS_JBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JBE_RELBRz,169,3,41,0,21,XED_EXCEPTION_INVALID),
/* 797*/ XED_DEF_INST(XED_ICLASS_JBE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JBE_RELBRd,172,3,41,0,20,XED_EXCEPTION_INVALID),
/* 798*/ XED_DEF_INST(XED_ICLASS_FXAM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FXAM,140,2,3,0,6,XED_EXCEPTION_INVALID),
/* 799*/ XED_DEF_INST(XED_ICLASS_XSAVEOPT,XED_CATEGORY_XSAVEOPT,XED_EXTENSION_XSAVEOPT,3,XED_IFORM_XSAVEOPT_MEMmxsave,900,4,0,0,68,XED_EXCEPTION_INVALID),
/* 800*/ XED_DEF_INST(XED_ICLASS_MUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_MUL_MEMb,1148,4,62,0,37,XED_EXCEPTION_INVALID),
/* 801*/ XED_DEF_INST(XED_ICLASS_MUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_MUL_GPR8,1152,4,62,0,37,XED_EXCEPTION_INVALID),
/* 802*/ XED_DEF_INST(XED_ICLASS_MUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_MUL_MEMv,1156,4,62,0,39,XED_EXCEPTION_INVALID),
/* 803*/ XED_DEF_INST(XED_ICLASS_MUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_MUL_GPRv,1160,4,62,0,39,XED_EXCEPTION_INVALID),
/* 804*/ XED_DEF_INST(XED_ICLASS_PADDW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 805*/ XED_DEF_INST(XED_ICLASS_PADDW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 806*/ XED_DEF_INST(XED_ICLASS_PADDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDW_XMMdq_MEMdq,421,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 807*/ XED_DEF_INST(XED_ICLASS_PADDW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDW_XMMdq_XMMdq,423,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 808*/ XED_DEF_INST(XED_ICLASS_PMAXSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMAXSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 809*/ XED_DEF_INST(XED_ICLASS_PMAXSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMAXSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 810*/ XED_DEF_INST(XED_ICLASS_PMAXSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMAXSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 811*/ XED_DEF_INST(XED_ICLASS_PMAXSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMAXSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 812*/ XED_DEF_INST(XED_ICLASS_FFREE,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FFREE_X87,1164,2,55,0,76,XED_EXCEPTION_INVALID),
/* 813*/ XED_DEF_INST(XED_ICLASS_FFREEP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FFREEP_X87,1166,3,55,0,76,XED_EXCEPTION_INVALID),
/* 814*/ XED_DEF_INST(XED_ICLASS_SHA256MSG2,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA256MSG2_XMMi32_XMMi32_SHA,285,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/* 815*/ XED_DEF_INST(XED_ICLASS_SHA256MSG2,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA256MSG2_XMMi32_MEMi32_SHA,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 816*/ XED_DEF_INST(XED_ICLASS_PMAXSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXSB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 817*/ XED_DEF_INST(XED_ICLASS_PMAXSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXSB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 818*/ XED_DEF_INST(XED_ICLASS_PMAXSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXSD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 819*/ XED_DEF_INST(XED_ICLASS_PMAXSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXSD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 820*/ XED_DEF_INST(XED_ICLASS_FPREM1,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FPREM1,1115,3,3,0,6,XED_EXCEPTION_INVALID),
/* 821*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_MEMv,1169,4,0,0,77,XED_EXCEPTION_INVALID),
/* 822*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_GPRv_FFr6,1173,4,0,0,70,XED_EXCEPTION_INVALID),
/* 823*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_ES,1177,4,0,0,70,XED_EXCEPTION_INVALID),
/* 824*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_CS,1181,4,0,0,70,XED_EXCEPTION_INVALID),
/* 825*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_SS,1185,4,0,0,70,XED_EXCEPTION_INVALID),
/* 826*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_DS,1189,4,0,0,70,XED_EXCEPTION_INVALID),
/* 827*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_GPRv_50,1193,4,0,0,70,XED_EXCEPTION_INVALID),
/* 828*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_IMMz,1197,4,0,0,70,XED_EXCEPTION_INVALID),
/* 829*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_IMMb,1201,4,0,0,70,XED_EXCEPTION_INVALID),
/* 830*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_FS,1205,4,0,0,70,XED_EXCEPTION_INVALID),
/* 831*/ XED_DEF_INST(XED_ICLASS_PUSH,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSH_GS,1209,4,0,0,70,XED_EXCEPTION_INVALID),
/* 832*/ XED_DEF_INST(XED_ICLASS_PFRSQIT1,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFRSQIT1_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 833*/ XED_DEF_INST(XED_ICLASS_PFRSQIT1,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFRSQIT1_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 834*/ XED_DEF_INST(XED_ICLASS_SETNO,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNO_MEMb,596,2,63,0,37,XED_EXCEPTION_INVALID),
/* 835*/ XED_DEF_INST(XED_ICLASS_SETNO,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNO_GPR8,598,2,63,0,37,XED_EXCEPTION_INVALID),
/* 836*/ XED_DEF_INST(XED_ICLASS_CVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPD2DQ_XMMdq_MEMpd,1213,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 837*/ XED_DEF_INST(XED_ICLASS_CVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPD2DQ_XMMdq_XMMpd,1215,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 838*/ XED_DEF_INST(XED_ICLASS_PADDD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDD_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 839*/ XED_DEF_INST(XED_ICLASS_PADDD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDD_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 840*/ XED_DEF_INST(XED_ICLASS_PADDD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 841*/ XED_DEF_INST(XED_ICLASS_PADDD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 842*/ XED_DEF_INST(XED_ICLASS_SETNL,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNL_MEMb,596,2,10,0,37,XED_EXCEPTION_INVALID),
/* 843*/ XED_DEF_INST(XED_ICLASS_SETNL,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNL_GPR8,598,2,10,0,37,XED_EXCEPTION_INVALID),
/* 844*/ XED_DEF_INST(XED_ICLASS_PADDB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 845*/ XED_DEF_INST(XED_ICLASS_PADDB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 846*/ XED_DEF_INST(XED_ICLASS_PADDB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 847*/ XED_DEF_INST(XED_ICLASS_PADDB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 848*/ XED_DEF_INST(XED_ICLASS_CLI,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_CLI,293,1,48,0,6,XED_EXCEPTION_INVALID),
/* 849*/ XED_DEF_INST(XED_ICLASS_CLD,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_CLD,759,1,64,0,64,XED_EXCEPTION_INVALID),
/* 850*/ XED_DEF_INST(XED_ICLASS_BNDCL,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCL_BND_AGEN,298,2,0,0,34,XED_EXCEPTION_INVALID),
/* 851*/ XED_DEF_INST(XED_ICLASS_BNDCL,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCL_BND_GPR64,300,2,0,0,34,XED_EXCEPTION_INVALID),
/* 852*/ XED_DEF_INST(XED_ICLASS_BNDCL,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDCL_BND_GPR32,302,2,0,0,34,XED_EXCEPTION_INVALID),
/* 853*/ XED_DEF_INST(XED_ICLASS_FIMUL,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIMUL_ST0_MEMmem32int,753,3,4,0,6,XED_EXCEPTION_INVALID),
/* 854*/ XED_DEF_INST(XED_ICLASS_FIMUL,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIMUL_ST0_MEMmem16int,756,3,4,0,6,XED_EXCEPTION_INVALID),
/* 855*/ XED_DEF_INST(XED_ICLASS_SETNB,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNB_MEMb,596,2,65,0,37,XED_EXCEPTION_INVALID),
/* 856*/ XED_DEF_INST(XED_ICLASS_SETNB,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNB_GPR8,598,2,65,0,37,XED_EXCEPTION_INVALID),
/* 857*/ XED_DEF_INST(XED_ICLASS_PSRLDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLDQ_XMMdq_IMMb,645,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/* 858*/ XED_DEF_INST(XED_ICLASS_CLC,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_CLC,759,1,66,0,0,XED_EXCEPTION_INVALID),
/* 859*/ XED_DEF_INST(XED_ICLASS_FSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTP_MEMmem32real_ST0,1217,4,4,0,6,XED_EXCEPTION_INVALID),
/* 860*/ XED_DEF_INST(XED_ICLASS_FSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTP_MEMmem80real_ST0,1221,4,4,0,6,XED_EXCEPTION_INVALID),
/* 861*/ XED_DEF_INST(XED_ICLASS_FSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTP_MEMm64real_ST0,1225,4,4,0,6,XED_EXCEPTION_INVALID),
/* 862*/ XED_DEF_INST(XED_ICLASS_FSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTP_X87_ST0,1229,4,4,0,6,XED_EXCEPTION_INVALID),
/* 863*/ XED_DEF_INST(XED_ICLASS_FSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTP_X87_ST0_DFD0,1229,4,4,0,6,XED_EXCEPTION_INVALID),
/* 864*/ XED_DEF_INST(XED_ICLASS_FSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTP_X87_ST0_DFD1,1229,4,4,0,6,XED_EXCEPTION_INVALID),
/* 865*/ XED_DEF_INST(XED_ICLASS_BLENDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDPD_XMMdq_MEMdq_IMMb,1233,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 866*/ XED_DEF_INST(XED_ICLASS_BLENDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDPD_XMMdq_XMMdq_IMMb,1236,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 867*/ XED_DEF_INST(XED_ICLASS_RDSEED,XED_CATEGORY_RDSEED,XED_EXTENSION_RDSEED,3,XED_IFORM_RDSEED_GPRv,1239,2,67,0,39,XED_EXCEPTION_INVALID),
/* 868*/ XED_DEF_INST(XED_ICLASS_FNINIT,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNINIT,1241,3,3,0,78,XED_EXCEPTION_INVALID),
/* 869*/ XED_DEF_INST(XED_ICLASS_SETNZ,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNZ_MEMb,596,2,56,0,37,XED_EXCEPTION_INVALID),
/* 870*/ XED_DEF_INST(XED_ICLASS_SETNZ,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNZ_GPR8,598,2,56,0,37,XED_EXCEPTION_INVALID),
/* 871*/ XED_DEF_INST(XED_ICLASS_PADDQ,XED_CATEGORY_MMX,XED_EXTENSION_SSE2,3,XED_IFORM_PADDQ_MMXq_MEMq,1244,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 872*/ XED_DEF_INST(XED_ICLASS_PADDQ,XED_CATEGORY_MMX,XED_EXTENSION_SSE2,3,XED_IFORM_PADDQ_MMXq_MMXq,1246,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 873*/ XED_DEF_INST(XED_ICLASS_PADDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 874*/ XED_DEF_INST(XED_ICLASS_PADDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 875*/ XED_DEF_INST(XED_ICLASS_XORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_XORPS_XMMxud_MEMxud,614,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 876*/ XED_DEF_INST(XED_ICLASS_XORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_XORPS_XMMxud_XMMxud,616,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 877*/ XED_DEF_INST(XED_ICLASS_SETNS,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNS_MEMb,596,2,59,0,37,XED_EXCEPTION_INVALID),
/* 878*/ XED_DEF_INST(XED_ICLASS_SETNS,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNS_GPR8,598,2,59,0,37,XED_EXCEPTION_INVALID),
/* 879*/ XED_DEF_INST(XED_ICLASS_FIADD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIADD_ST0_MEMmem32int,753,3,4,0,6,XED_EXCEPTION_INVALID),
/* 880*/ XED_DEF_INST(XED_ICLASS_FIADD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIADD_ST0_MEMmem16int,756,3,4,0,6,XED_EXCEPTION_INVALID),
/* 881*/ XED_DEF_INST(XED_ICLASS_SETNP,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNP_MEMb,596,2,33,0,37,XED_EXCEPTION_INVALID),
/* 882*/ XED_DEF_INST(XED_ICLASS_SETNP,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNP_GPR8,598,2,33,0,37,XED_EXCEPTION_INVALID),
/* 883*/ XED_DEF_INST(XED_ICLASS_SUBPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SUBPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 884*/ XED_DEF_INST(XED_ICLASS_SUBPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SUBPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 885*/ XED_DEF_INST(XED_ICLASS_LLDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LLDT_MEMw,1248,2,0,0,29,XED_EXCEPTION_INVALID),
/* 886*/ XED_DEF_INST(XED_ICLASS_LLDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LLDT_GPR16,1250,2,0,0,29,XED_EXCEPTION_INVALID),
/* 887*/ XED_DEF_INST(XED_ICLASS_SHUFPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SHUFPS_XMMps_MEMps_IMMb,1085,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 888*/ XED_DEF_INST(XED_ICLASS_SHUFPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SHUFPS_XMMps_XMMps_IMMb,569,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 889*/ XED_DEF_INST(XED_ICLASS_PTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE4,3,XED_IFORM_PTEST_XMMdq_MEMdq,1252,3,68,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 890*/ XED_DEF_INST(XED_ICLASS_PTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE4,3,XED_IFORM_PTEST_XMMdq_XMMdq,1255,3,68,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 891*/ XED_DEF_INST(XED_ICLASS_GETSEC,XED_CATEGORY_SYSTEM,XED_EXTENSION_SMX,3,XED_IFORM_GETSEC,1258,2,0,0,1,XED_EXCEPTION_INVALID),
/* 892*/ XED_DEF_INST(XED_ICLASS_PABSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSW_MMXq_MEMq,1260,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 893*/ XED_DEF_INST(XED_ICLASS_PABSW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSW_MMXq_MMXq,1262,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 894*/ XED_DEF_INST(XED_ICLASS_PABSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSW_XMMdq_MEMdq,470,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 895*/ XED_DEF_INST(XED_ICLASS_PABSW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSW_XMMdq_XMMdq,472,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 896*/ XED_DEF_INST(XED_ICLASS_ENCLS,XED_CATEGORY_SGX,XED_EXTENSION_SGX,0,XED_IFORM_ENCLS,1264,4,0,0,0,XED_EXCEPTION_INVALID),
/* 897*/ XED_DEF_INST(XED_ICLASS_JCXZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JCXZ_RELBRb,1268,3,0,0,0,XED_EXCEPTION_INVALID),
/* 898*/ XED_DEF_INST(XED_ICLASS_ENCLU,XED_CATEGORY_SGX,XED_EXTENSION_SGX,3,XED_IFORM_ENCLU,1264,4,0,0,0,XED_EXCEPTION_INVALID),
/* 899*/ XED_DEF_INST(XED_ICLASS_RET_NEAR,XED_CATEGORY_RET,XED_EXTENSION_BASE,3,XED_IFORM_RET_NEAR_IMMw,1271,5,0,0,79,XED_EXCEPTION_INVALID),
/* 900*/ XED_DEF_INST(XED_ICLASS_RET_NEAR,XED_CATEGORY_RET,XED_EXTENSION_BASE,3,XED_IFORM_RET_NEAR,1276,4,0,0,79,XED_EXCEPTION_INVALID),
/* 901*/ XED_DEF_INST(XED_ICLASS_ENCLV,XED_CATEGORY_SGX,XED_EXTENSION_SGX_ENCLV,3,XED_IFORM_ENCLV,1280,4,0,0,0,XED_EXCEPTION_INVALID),
/* 902*/ XED_DEF_INST(XED_ICLASS_SUB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_LOCK_MEMb_IMMb_80r5,1284,3,18,0,53,XED_EXCEPTION_INVALID),
/* 903*/ XED_DEF_INST(XED_ICLASS_SUB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_LOCK_MEMv_IMMz,770,3,18,0,54,XED_EXCEPTION_INVALID),
/* 904*/ XED_DEF_INST(XED_ICLASS_SUB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_LOCK_MEMb_IMMb_82r5,1284,3,18,0,53,XED_EXCEPTION_INVALID),
/* 905*/ XED_DEF_INST(XED_ICLASS_SUB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_LOCK_MEMv_IMMb,776,3,18,0,54,XED_EXCEPTION_INVALID),
/* 906*/ XED_DEF_INST(XED_ICLASS_SUB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_LOCK_MEMb_GPR8,782,3,18,0,53,XED_EXCEPTION_INVALID),
/* 907*/ XED_DEF_INST(XED_ICLASS_SUB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_LOCK_MEMv_GPRv,788,3,18,0,54,XED_EXCEPTION_INVALID),
/* 908*/ XED_DEF_INST(XED_ICLASS_MOVSXD,XED_CATEGORY_DATAXFER,XED_EXTENSION_LONGMODE,3,XED_IFORM_MOVSXD_GPRv_MEMd,1287,2,0,0,39,XED_EXCEPTION_INVALID),
/* 909*/ XED_DEF_INST(XED_ICLASS_MOVSXD,XED_CATEGORY_DATAXFER,XED_EXTENSION_LONGMODE,3,XED_IFORM_MOVSXD_GPRv_GPR32,1289,2,0,0,39,XED_EXCEPTION_INVALID),
/* 910*/ XED_DEF_INST(XED_ICLASS_CLZERO,XED_CATEGORY_CLZERO,XED_EXTENSION_CLZERO,3,XED_IFORM_CLZERO_OrAX,431,1,0,0,80,XED_EXCEPTION_INVALID),
/* 911*/ XED_DEF_INST(XED_ICLASS_AAD,XED_CATEGORY_DECIMAL,XED_EXTENSION_BASE,3,XED_IFORM_AAD_IMMb,1291,4,69,0,0,XED_EXCEPTION_INVALID),
/* 912*/ XED_DEF_INST(XED_ICLASS_PUNPCKHQDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHQDQ_XMMdq_MEMdq,148,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/* 913*/ XED_DEF_INST(XED_ICLASS_PUNPCKHQDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHQDQ_XMMdq_XMMq,150,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/* 914*/ XED_DEF_INST(XED_ICLASS_AAA,XED_CATEGORY_DECIMAL,XED_EXTENSION_BASE,3,XED_IFORM_AAA,1295,3,70,0,0,XED_EXCEPTION_INVALID),
/* 915*/ XED_DEF_INST(XED_ICLASS_BTC_LOCK,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTC_LOCK_MEMv_IMMb,812,3,60,0,54,XED_EXCEPTION_INVALID),
/* 916*/ XED_DEF_INST(XED_ICLASS_BTC_LOCK,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTC_LOCK_MEMv_GPRv,788,3,60,0,54,XED_EXCEPTION_INVALID),
/* 917*/ XED_DEF_INST(XED_ICLASS_AAM,XED_CATEGORY_DECIMAL,XED_EXTENSION_BASE,3,XED_IFORM_AAM_IMMb,1298,4,69,0,0,XED_EXCEPTION_INVALID),
/* 918*/ XED_DEF_INST(XED_ICLASS_MINSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MINSS_XMMss_MEMss,413,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 919*/ XED_DEF_INST(XED_ICLASS_MINSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MINSS_XMMss_XMMss,415,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 920*/ XED_DEF_INST(XED_ICLASS_XGETBV,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVE,3,XED_IFORM_XGETBV,1302,4,0,0,0,XED_EXCEPTION_INVALID),
/* 921*/ XED_DEF_INST(XED_ICLASS_CMPSD_XMM,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_CMPSD_XMM_XMMsd_MEMsd_IMMb,1306,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 922*/ XED_DEF_INST(XED_ICLASS_CMPSD_XMM,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_CMPSD_XMM_XMMsd_XMMsd_IMMb,1309,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 923*/ XED_DEF_INST(XED_ICLASS_MOVLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVLPS_XMMq_MEMq,1312,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 924*/ XED_DEF_INST(XED_ICLASS_MOVLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVLPS_MEMq_XMMps,1314,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 925*/ XED_DEF_INST(XED_ICLASS_CLGI,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_CLGI,0,0,0,0,48,XED_EXCEPTION_INVALID),
/* 926*/ XED_DEF_INST(XED_ICLASS_AAS,XED_CATEGORY_DECIMAL,XED_EXTENSION_BASE,3,XED_IFORM_AAS,1295,3,70,0,0,XED_EXCEPTION_INVALID),
/* 927*/ XED_DEF_INST(XED_ICLASS_PMULHUW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMULHUW_MMXq_MEMq,1316,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 928*/ XED_DEF_INST(XED_ICLASS_PMULHUW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMULHUW_MMXq_MMXq,1318,2,0,0,6,XED_EXCEPTION_INVALID),
/* 929*/ XED_DEF_INST(XED_ICLASS_PMULHUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULHUW_XMMdq_MEMdq,1320,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 930*/ XED_DEF_INST(XED_ICLASS_PMULHUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULHUW_XMMdq_XMMdq,1322,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 931*/ XED_DEF_INST(XED_ICLASS_SETNBE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNBE_MEMb,596,2,41,0,37,XED_EXCEPTION_INVALID),
/* 932*/ XED_DEF_INST(XED_ICLASS_SETNBE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNBE_GPR8,598,2,41,0,37,XED_EXCEPTION_INVALID),
/* 933*/ XED_DEF_INST(XED_ICLASS_MINSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MINSD_XMMsd_MEMsd,938,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 934*/ XED_DEF_INST(XED_ICLASS_MINSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MINSD_XMMsd_XMMsd,940,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 935*/ XED_DEF_INST(XED_ICLASS_FNOP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNOP,0,0,0,0,81,XED_EXCEPTION_INVALID),
/* 936*/ XED_DEF_INST(XED_ICLASS_CVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTSD2SI_GPR32d_MEMsd,1324,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 937*/ XED_DEF_INST(XED_ICLASS_CVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTSD2SI_GPR32d_XMMsd,1326,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 938*/ XED_DEF_INST(XED_ICLASS_CVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTSD2SI_GPR64q_MEMsd,1328,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 939*/ XED_DEF_INST(XED_ICLASS_CVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTSD2SI_GPR64q_XMMsd,1330,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 940*/ XED_DEF_INST(XED_ICLASS_FICOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FICOM_ST0_MEMmem32int,1332,3,3,0,6,XED_EXCEPTION_INVALID),
/* 941*/ XED_DEF_INST(XED_ICLASS_FICOM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FICOM_ST0_MEMmem16int,1335,3,3,0,6,XED_EXCEPTION_INVALID),
/* 942*/ XED_DEF_INST(XED_ICLASS_PMOVZXBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXBW_XMMdq_MEMq,1338,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 943*/ XED_DEF_INST(XED_ICLASS_PMOVZXBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXBW_XMMdq_XMMq,1340,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/* 944*/ XED_DEF_INST(XED_ICLASS_ADDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_ADDPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 945*/ XED_DEF_INST(XED_ICLASS_ADDPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_ADDPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 946*/ XED_DEF_INST(XED_ICLASS_PHADDD,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDD_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 947*/ XED_DEF_INST(XED_ICLASS_PHADDD,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDD_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/* 948*/ XED_DEF_INST(XED_ICLASS_PHADDD,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 949*/ XED_DEF_INST(XED_ICLASS_PHADDD,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 950*/ XED_DEF_INST(XED_ICLASS_POR,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_POR_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_INVALID),
/* 951*/ XED_DEF_INST(XED_ICLASS_POR,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_POR_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/* 952*/ XED_DEF_INST(XED_ICLASS_POR,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_POR_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 953*/ XED_DEF_INST(XED_ICLASS_POR,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_POR_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/* 954*/ XED_DEF_INST(XED_ICLASS_LOOPE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 955*/ XED_DEF_INST(XED_ICLASS_LOOPE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 956*/ XED_DEF_INST(XED_ICLASS_LOOPE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 957*/ XED_DEF_INST(XED_ICLASS_LOOPE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_LOOPE_RELBRb,1007,4,56,0,0,XED_EXCEPTION_INVALID),
/* 958*/ XED_DEF_INST(XED_ICLASS_REP_INSW,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSW,1342,5,5,0,82,XED_EXCEPTION_INVALID),
/* 959*/ XED_DEF_INST(XED_ICLASS_REP_INSW,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSW,1342,5,5,0,82,XED_EXCEPTION_INVALID),
/* 960*/ XED_DEF_INST(XED_ICLASS_MOVNTDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVNTDQ_MEMdq_XMMdq,1107,2,0,0,69,XED_EXCEPTION_SSE_TYPE_1),
/* 961*/ XED_DEF_INST(XED_ICLASS_INT1,XED_CATEGORY_INTERRUPT,XED_EXTENSION_BASE,3,XED_IFORM_INT1,1347,1,0,0,0,XED_EXCEPTION_INVALID),
/* 962*/ XED_DEF_INST(XED_ICLASS_INT3,XED_CATEGORY_INTERRUPT,XED_EXTENSION_BASE,3,XED_IFORM_INT3,1348,2,22,0,6,XED_EXCEPTION_INVALID),
/* 963*/ XED_DEF_INST(XED_ICLASS_CMPXCHG,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG_MEMb_GPR8,1350,4,18,0,36,XED_EXCEPTION_INVALID),
/* 964*/ XED_DEF_INST(XED_ICLASS_CMPXCHG,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG_GPR8_GPR8,1354,4,18,0,37,XED_EXCEPTION_INVALID),
/* 965*/ XED_DEF_INST(XED_ICLASS_CMPXCHG,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG_MEMv_GPRv,1358,4,18,0,38,XED_EXCEPTION_INVALID),
/* 966*/ XED_DEF_INST(XED_ICLASS_CMPXCHG,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG_GPRv_GPRv,1362,4,18,0,39,XED_EXCEPTION_INVALID),
/* 967*/ XED_DEF_INST(XED_ICLASS_REP_INSB,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSB,1366,5,5,0,83,XED_EXCEPTION_INVALID),
/* 968*/ XED_DEF_INST(XED_ICLASS_REP_INSB,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSB,1366,5,5,0,83,XED_EXCEPTION_INVALID),
/* 969*/ XED_DEF_INST(XED_ICLASS_REP_INSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSD,1371,5,5,0,82,XED_EXCEPTION_INVALID),
/* 970*/ XED_DEF_INST(XED_ICLASS_REP_INSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSD,1371,5,5,0,82,XED_EXCEPTION_INVALID),
/* 971*/ XED_DEF_INST(XED_ICLASS_REP_INSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSD,1371,5,5,0,82,XED_EXCEPTION_INVALID),
/* 972*/ XED_DEF_INST(XED_ICLASS_REP_INSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_INSD,1371,5,5,0,82,XED_EXCEPTION_INVALID),
/* 973*/ XED_DEF_INST(XED_ICLASS_ADDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_ADDPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 974*/ XED_DEF_INST(XED_ICLASS_ADDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_ADDPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/* 975*/ XED_DEF_INST(XED_ICLASS_REP_STOSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_STOSD,1376,5,39,0,22,XED_EXCEPTION_INVALID),
/* 976*/ XED_DEF_INST(XED_ICLASS_REP_STOSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_STOSD,1376,5,39,0,22,XED_EXCEPTION_INVALID),
/* 977*/ XED_DEF_INST(XED_ICLASS_PFMUL,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFMUL_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/* 978*/ XED_DEF_INST(XED_ICLASS_PFMUL,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFMUL_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/* 979*/ XED_DEF_INST(XED_ICLASS_RDSSPD,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_RDSSPD_GPR32u32,1381,2,0,0,0,XED_EXCEPTION_INVALID),
/* 980*/ XED_DEF_INST(XED_ICLASS_VERR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_VERR_MEMw,1383,2,16,0,14,XED_EXCEPTION_INVALID),
/* 981*/ XED_DEF_INST(XED_ICLASS_VERR,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_VERR_GPR16,1385,2,16,0,14,XED_EXCEPTION_INVALID),
/* 982*/ XED_DEF_INST(XED_ICLASS_REP_STOSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_STOSB,1387,5,39,0,25,XED_EXCEPTION_INVALID),
/* 983*/ XED_DEF_INST(XED_ICLASS_REP_STOSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_STOSB,1387,5,39,0,25,XED_EXCEPTION_INVALID),
/* 984*/ XED_DEF_INST(XED_ICLASS_INTO,XED_CATEGORY_INTERRUPT,XED_EXTENSION_BASE,3,XED_IFORM_INTO,1392,2,71,0,6,XED_EXCEPTION_INVALID),
/* 985*/ XED_DEF_INST(XED_ICLASS_CVTSD2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSD2SS_XMMss_MEMsd,1394,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 986*/ XED_DEF_INST(XED_ICLASS_CVTSD2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSD2SS_XMMss_XMMsd,1396,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/* 987*/ XED_DEF_INST(XED_ICLASS_FLDPI,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDPI,266,3,4,0,6,XED_EXCEPTION_INVALID),
/* 988*/ XED_DEF_INST(XED_ICLASS_REP_STOSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_STOSW,1398,5,39,0,22,XED_EXCEPTION_INVALID),
/* 989*/ XED_DEF_INST(XED_ICLASS_REP_STOSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_STOSW,1398,5,39,0,22,XED_EXCEPTION_INVALID),
/* 990*/ XED_DEF_INST(XED_ICLASS_REP_STOSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REP_STOSQ,1403,5,39,0,22,XED_EXCEPTION_INVALID),
/* 991*/ XED_DEF_INST(XED_ICLASS_REP_STOSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REP_STOSQ,1403,5,39,0,22,XED_EXCEPTION_INVALID),
/* 992*/ XED_DEF_INST(XED_ICLASS_WRPKRU,XED_CATEGORY_PKU,XED_EXTENSION_PKU,3,XED_IFORM_WRPKRU,1408,3,0,0,0,XED_EXCEPTION_INVALID),
/* 993*/ XED_DEF_INST(XED_ICLASS_CWD,XED_CATEGORY_CONVERT,XED_EXTENSION_BASE,3,XED_IFORM_CWD,1411,2,0,0,0,XED_EXCEPTION_INVALID),
/* 994*/ XED_DEF_INST(XED_ICLASS_FNSTSW,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSTSW_MEMmem16,1413,2,55,0,73,XED_EXCEPTION_INVALID),
/* 995*/ XED_DEF_INST(XED_ICLASS_FNSTSW,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSTSW_AX,1415,2,55,0,73,XED_EXCEPTION_INVALID),
/* 996*/ XED_DEF_INST(XED_ICLASS_AND_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_LOCK_MEMb_IMMb_80r4,764,3,43,0,53,XED_EXCEPTION_INVALID),
/* 997*/ XED_DEF_INST(XED_ICLASS_AND_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_LOCK_MEMv_IMMz,770,3,43,0,54,XED_EXCEPTION_INVALID),
/* 998*/ XED_DEF_INST(XED_ICLASS_AND_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_LOCK_MEMb_IMMb_82r4,764,3,43,0,53,XED_EXCEPTION_INVALID),
/* 999*/ XED_DEF_INST(XED_ICLASS_AND_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_LOCK_MEMv_IMMb,776,3,43,0,54,XED_EXCEPTION_INVALID),
/*1000*/ XED_DEF_INST(XED_ICLASS_AND_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_LOCK_MEMb_GPR8,782,3,43,0,53,XED_EXCEPTION_INVALID),
/*1001*/ XED_DEF_INST(XED_ICLASS_AND_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_LOCK_MEMv_GPRv,788,3,43,0,54,XED_EXCEPTION_INVALID),
/*1002*/ XED_DEF_INST(XED_ICLASS_PSLLD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLD_MMXq_IMMb,1417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1003*/ XED_DEF_INST(XED_ICLASS_PSLLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLD_XMMdq_IMMb,1419,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1004*/ XED_DEF_INST(XED_ICLASS_PSLLD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLD_MMXq_MEMq,1421,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1005*/ XED_DEF_INST(XED_ICLASS_PSLLD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLD_MMXq_MMXq,1423,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1006*/ XED_DEF_INST(XED_ICLASS_PSLLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1007*/ XED_DEF_INST(XED_ICLASS_PSLLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1008*/ XED_DEF_INST(XED_ICLASS_SWAPGS,XED_CATEGORY_SYSTEM,XED_EXTENSION_LONGMODE,0,XED_IFORM_SWAPGS,0,0,0,0,15,XED_EXCEPTION_INVALID),
/*1009*/ XED_DEF_INST(XED_ICLASS_MOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE3,3,XED_IFORM_MOVSLDUP_XMMps_MEMps,995,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1010*/ XED_DEF_INST(XED_ICLASS_MOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE3,3,XED_IFORM_MOVSLDUP_XMMps_XMMps,997,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1011*/ XED_DEF_INST(XED_ICLASS_CVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSI2SS_XMMss_MEMd,1425,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1012*/ XED_DEF_INST(XED_ICLASS_CVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSI2SS_XMMss_GPR32d,1427,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1013*/ XED_DEF_INST(XED_ICLASS_CVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSI2SS_XMMss_MEMq,1429,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1014*/ XED_DEF_INST(XED_ICLASS_CVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSI2SS_XMMss_GPR64q,1431,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1015*/ XED_DEF_INST(XED_ICLASS_SQRTSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SQRTSD_XMMsd_MEMsd,1433,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1016*/ XED_DEF_INST(XED_ICLASS_SQRTSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SQRTSD_XMMsd_XMMsd,310,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1017*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_MEMb_IMMb_F6r0,340,3,43,0,37,XED_EXCEPTION_INVALID),
/*1018*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_MEMb_IMMb_F6r1,340,3,43,0,37,XED_EXCEPTION_INVALID),
/*1019*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_GPR8_IMMb_F6r0,343,3,43,0,37,XED_EXCEPTION_INVALID),
/*1020*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_GPR8_IMMb_F6r1,343,3,43,0,37,XED_EXCEPTION_INVALID),
/*1021*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_MEMv_IMMz_F7r0,346,3,43,0,39,XED_EXCEPTION_INVALID),
/*1022*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_MEMv_IMMz_F7r1,346,3,43,0,39,XED_EXCEPTION_INVALID),
/*1023*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_GPRv_IMMz_F7r0,349,3,43,0,39,XED_EXCEPTION_INVALID),
/*1024*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_GPRv_IMMz_F7r1,349,3,43,0,39,XED_EXCEPTION_INVALID),
/*1025*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_MEMb_GPR8,358,3,43,0,37,XED_EXCEPTION_INVALID),
/*1026*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_GPR8_GPR8,361,3,43,0,37,XED_EXCEPTION_INVALID),
/*1027*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_MEMv_GPRv,364,3,43,0,39,XED_EXCEPTION_INVALID),
/*1028*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_GPRv_GPRv,367,3,43,0,39,XED_EXCEPTION_INVALID),
/*1029*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_AL_IMMb,382,3,43,0,37,XED_EXCEPTION_INVALID),
/*1030*/ XED_DEF_INST(XED_ICLASS_TEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_TEST_OrAX_IMMz,385,3,43,0,39,XED_EXCEPTION_INVALID),
/*1031*/ XED_DEF_INST(XED_ICLASS_LGS,XED_CATEGORY_SEGOP,XED_EXTENSION_BASE,3,XED_IFORM_LGS_GPRv_MEMp2,1435,3,0,0,7,XED_EXCEPTION_INVALID),
/*1032*/ XED_DEF_INST(XED_ICLASS_PSLLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLW_MMXq_IMMb,1438,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1033*/ XED_DEF_INST(XED_ICLASS_PSLLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLW_XMMdq_IMMb,1440,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1034*/ XED_DEF_INST(XED_ICLASS_PSLLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLW_MMXq_MEMq,1442,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1035*/ XED_DEF_INST(XED_ICLASS_PSLLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLW_MMXq_MMXq,1444,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1036*/ XED_DEF_INST(XED_ICLASS_PSLLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLW_XMMdq_MEMdq,1446,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1037*/ XED_DEF_INST(XED_ICLASS_PSLLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLW_XMMdq_XMMdq,1448,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1038*/ XED_DEF_INST(XED_ICLASS_CVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSI2SD_XMMsd_MEMd,1450,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1039*/ XED_DEF_INST(XED_ICLASS_CVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSI2SD_XMMsd_GPR32d,1452,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1040*/ XED_DEF_INST(XED_ICLASS_CVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSI2SD_XMMsd_MEMq,1454,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1041*/ XED_DEF_INST(XED_ICLASS_CVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSI2SD_XMMsd_GPR64q,1456,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1042*/ XED_DEF_INST(XED_ICLASS_PSLLQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLQ_MMXq_IMMb,1458,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1043*/ XED_DEF_INST(XED_ICLASS_PSLLQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLQ_XMMdq_IMMb,1460,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1044*/ XED_DEF_INST(XED_ICLASS_PSLLQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLQ_MMXq_MEMq,1462,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1045*/ XED_DEF_INST(XED_ICLASS_PSLLQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSLLQ_MMXq_MMXq,1464,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1046*/ XED_DEF_INST(XED_ICLASS_PSLLQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLQ_XMMdq_MEMdq,1466,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1047*/ XED_DEF_INST(XED_ICLASS_PSLLQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSLLQ_XMMdq_XMMdq,1468,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1048*/ XED_DEF_INST(XED_ICLASS_JZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JZ_RELBRb,163,3,56,0,20,XED_EXCEPTION_INVALID),
/*1049*/ XED_DEF_INST(XED_ICLASS_JZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JZ_RELBRb,166,3,56,0,20,XED_EXCEPTION_INVALID),
/*1050*/ XED_DEF_INST(XED_ICLASS_JZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JZ_RELBRz,169,3,56,0,21,XED_EXCEPTION_INVALID),
/*1051*/ XED_DEF_INST(XED_ICLASS_JZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JZ_RELBRd,172,3,56,0,20,XED_EXCEPTION_INVALID),
/*1052*/ XED_DEF_INST(XED_ICLASS_SCASW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_SCASW,1470,4,28,0,62,XED_EXCEPTION_INVALID),
/*1053*/ XED_DEF_INST(XED_ICLASS_JP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JP_RELBRb,163,3,33,0,20,XED_EXCEPTION_INVALID),
/*1054*/ XED_DEF_INST(XED_ICLASS_JP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JP_RELBRb,166,3,33,0,20,XED_EXCEPTION_INVALID),
/*1055*/ XED_DEF_INST(XED_ICLASS_JP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JP_RELBRz,169,3,33,0,21,XED_EXCEPTION_INVALID),
/*1056*/ XED_DEF_INST(XED_ICLASS_JP,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JP_RELBRd,172,3,33,0,20,XED_EXCEPTION_INVALID),
/*1057*/ XED_DEF_INST(XED_ICLASS_UMONITOR,XED_CATEGORY_WAITPKG,XED_EXTENSION_WAITPKG,3,XED_IFORM_UMONITOR_GPRa,1474,1,0,0,0,XED_EXCEPTION_INVALID),
/*1058*/ XED_DEF_INST(XED_ICLASS_SCASQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_SCASQ,1475,4,28,0,62,XED_EXCEPTION_INVALID),
/*1059*/ XED_DEF_INST(XED_ICLASS_JS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JS_RELBRb,163,3,59,0,20,XED_EXCEPTION_INVALID),
/*1060*/ XED_DEF_INST(XED_ICLASS_JS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JS_RELBRb,166,3,59,0,20,XED_EXCEPTION_INVALID),
/*1061*/ XED_DEF_INST(XED_ICLASS_JS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JS_RELBRz,169,3,59,0,21,XED_EXCEPTION_INVALID),
/*1062*/ XED_DEF_INST(XED_ICLASS_JS,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JS_RELBRd,172,3,59,0,20,XED_EXCEPTION_INVALID),
/*1063*/ XED_DEF_INST(XED_ICLASS_SFENCE,XED_CATEGORY_MISC,XED_EXTENSION_SSE,3,XED_IFORM_SFENCE,0,0,0,0,84,XED_EXCEPTION_INVALID),
/*1064*/ XED_DEF_INST(XED_ICLASS_RSQRTSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RSQRTSS_XMMss_MEMss,961,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/*1065*/ XED_DEF_INST(XED_ICLASS_RSQRTSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RSQRTSS_XMMss_XMMss,963,2,0,0,35,XED_EXCEPTION_SSE_TYPE_5),
/*1066*/ XED_DEF_INST(XED_ICLASS_JO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JO_RELBRb,163,3,63,0,20,XED_EXCEPTION_INVALID),
/*1067*/ XED_DEF_INST(XED_ICLASS_JO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JO_RELBRb,166,3,63,0,20,XED_EXCEPTION_INVALID),
/*1068*/ XED_DEF_INST(XED_ICLASS_JO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JO_RELBRd,172,3,63,0,20,XED_EXCEPTION_INVALID),
/*1069*/ XED_DEF_INST(XED_ICLASS_JO,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JO_RELBRz,169,3,63,0,21,XED_EXCEPTION_INVALID),
/*1070*/ XED_DEF_INST(XED_ICLASS_PSUBUSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBUSB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1071*/ XED_DEF_INST(XED_ICLASS_PSUBUSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBUSB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1072*/ XED_DEF_INST(XED_ICLASS_PSUBUSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBUSB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1073*/ XED_DEF_INST(XED_ICLASS_PSUBUSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBUSB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1074*/ XED_DEF_INST(XED_ICLASS_SCASD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_SCASD,1479,4,28,0,62,XED_EXCEPTION_INVALID),
/*1075*/ XED_DEF_INST(XED_ICLASS_SCASB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_SCASB,1483,4,28,0,61,XED_EXCEPTION_INVALID),
/*1076*/ XED_DEF_INST(XED_ICLASS_JB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JB_RELBRb,163,3,65,0,20,XED_EXCEPTION_INVALID),
/*1077*/ XED_DEF_INST(XED_ICLASS_JB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JB_RELBRb,166,3,65,0,20,XED_EXCEPTION_INVALID),
/*1078*/ XED_DEF_INST(XED_ICLASS_JB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JB_RELBRz,169,3,65,0,21,XED_EXCEPTION_INVALID),
/*1079*/ XED_DEF_INST(XED_ICLASS_JB,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JB_RELBRd,172,3,65,0,20,XED_EXCEPTION_INVALID),
/*1080*/ XED_DEF_INST(XED_ICLASS_RDPMC,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_RDPMC,870,4,0,0,0,XED_EXCEPTION_INVALID),
/*1081*/ XED_DEF_INST(XED_ICLASS_CMPXCHG_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG_LOCK_MEMb_GPR8,1350,4,18,0,53,XED_EXCEPTION_INVALID),
/*1082*/ XED_DEF_INST(XED_ICLASS_CMPXCHG_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG_LOCK_MEMv_GPRv,1358,4,18,0,54,XED_EXCEPTION_INVALID),
/*1083*/ XED_DEF_INST(XED_ICLASS_VMWRITE,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMWRITE_GPR64_MEMq,1487,3,20,0,0,XED_EXCEPTION_INVALID),
/*1084*/ XED_DEF_INST(XED_ICLASS_VMWRITE,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMWRITE_GPR64_GPR64,1490,3,20,0,0,XED_EXCEPTION_INVALID),
/*1085*/ XED_DEF_INST(XED_ICLASS_VMWRITE,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMWRITE_GPR32_MEMd,1493,3,20,0,0,XED_EXCEPTION_INVALID),
/*1086*/ XED_DEF_INST(XED_ICLASS_VMWRITE,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMWRITE_GPR32_GPR32,1496,3,20,0,0,XED_EXCEPTION_INVALID),
/*1087*/ XED_DEF_INST(XED_ICLASS_INC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_LOCK_MEMb,509,2,35,0,53,XED_EXCEPTION_INVALID),
/*1088*/ XED_DEF_INST(XED_ICLASS_INC_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_INC_LOCK_MEMv,513,2,35,0,54,XED_EXCEPTION_INVALID),
/*1089*/ XED_DEF_INST(XED_ICLASS_CMOVNP,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNP_GPRv_MEMv,334,3,33,0,39,XED_EXCEPTION_INVALID),
/*1090*/ XED_DEF_INST(XED_ICLASS_CMOVNP,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNP_GPRv_GPRv,337,3,33,0,39,XED_EXCEPTION_INVALID),
/*1091*/ XED_DEF_INST(XED_ICLASS_PMOVMSKB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMOVMSKB_GPR32_MMXq,1499,2,0,0,6,XED_EXCEPTION_MMX_NOMEM),
/*1092*/ XED_DEF_INST(XED_ICLASS_PMOVMSKB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMOVMSKB_GPR32_XMMdq,1501,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1093*/ XED_DEF_INST(XED_ICLASS_FSTPNCE,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSTPNCE_X87_ST0,1229,4,4,0,6,XED_EXCEPTION_INVALID),
/*1094*/ XED_DEF_INST(XED_ICLASS_FWAIT,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FWAIT,0,0,0,0,76,XED_EXCEPTION_INVALID),
/*1095*/ XED_DEF_INST(XED_ICLASS_RET_FAR,XED_CATEGORY_RET,XED_EXTENSION_BASE,3,XED_IFORM_RET_FAR_IMMw,1503,5,0,0,85,XED_EXCEPTION_INVALID),
/*1096*/ XED_DEF_INST(XED_ICLASS_RET_FAR,XED_CATEGORY_RET,XED_EXTENSION_BASE,3,XED_IFORM_RET_FAR,1508,4,0,0,85,XED_EXCEPTION_INVALID),
/*1097*/ XED_DEF_INST(XED_ICLASS_PCMPESTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRI_XMMdq_MEMdq_IMMb,1512,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1098*/ XED_DEF_INST(XED_ICLASS_PCMPESTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRI_XMMdq_XMMdq_IMMb,1519,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1099*/ XED_DEF_INST(XED_ICLASS_PCMPESTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRI_XMMdq_MEMdq_IMMb,1526,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1100*/ XED_DEF_INST(XED_ICLASS_PCMPESTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRI_XMMdq_XMMdq_IMMb,1533,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1101*/ XED_DEF_INST(XED_ICLASS_UNPCKLPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_UNPCKLPS_XMMps_MEMdq,72,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1102*/ XED_DEF_INST(XED_ICLASS_UNPCKLPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_UNPCKLPS_XMMps_XMMq,1540,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1103*/ XED_DEF_INST(XED_ICLASS_OR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_LOCK_MEMb_IMMb_80r1,1284,3,43,0,53,XED_EXCEPTION_INVALID),
/*1104*/ XED_DEF_INST(XED_ICLASS_OR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_LOCK_MEMv_IMMz,770,3,43,0,54,XED_EXCEPTION_INVALID),
/*1105*/ XED_DEF_INST(XED_ICLASS_OR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_LOCK_MEMb_IMMb_82r1,1284,3,43,0,53,XED_EXCEPTION_INVALID),
/*1106*/ XED_DEF_INST(XED_ICLASS_OR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_LOCK_MEMv_IMMb,776,3,43,0,54,XED_EXCEPTION_INVALID),
/*1107*/ XED_DEF_INST(XED_ICLASS_OR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_LOCK_MEMb_GPR8,782,3,43,0,53,XED_EXCEPTION_INVALID),
/*1108*/ XED_DEF_INST(XED_ICLASS_OR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_LOCK_MEMv_GPRv,788,3,43,0,54,XED_EXCEPTION_INVALID),
/*1109*/ XED_DEF_INST(XED_ICLASS_PCMPESTRM,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRM_XMMdq_MEMdq_IMMb,1542,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1110*/ XED_DEF_INST(XED_ICLASS_PCMPESTRM,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRM_XMMdq_XMMdq_IMMb,1549,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1111*/ XED_DEF_INST(XED_ICLASS_PCMPESTRM,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRM_XMMdq_MEMdq_IMMb,1556,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1112*/ XED_DEF_INST(XED_ICLASS_PCMPESTRM,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPESTRM_XMMdq_XMMdq_IMMb,1563,7,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1113*/ XED_DEF_INST(XED_ICLASS_PUNPCKLDQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKLDQ_MMXq_MEMd,1570,2,0,0,6,XED_EXCEPTION_INVALID),
/*1114*/ XED_DEF_INST(XED_ICLASS_PUNPCKLDQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKLDQ_MMXq_MMXd,1572,2,0,0,6,XED_EXCEPTION_INVALID),
/*1115*/ XED_DEF_INST(XED_ICLASS_PUNPCKLDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLDQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1116*/ XED_DEF_INST(XED_ICLASS_PUNPCKLDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLDQ_XMMdq_XMMq,150,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1117*/ XED_DEF_INST(XED_ICLASS_MULSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MULSS_XMMss_MEMss,413,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1118*/ XED_DEF_INST(XED_ICLASS_MULSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MULSS_XMMss_XMMss,415,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1119*/ XED_DEF_INST(XED_ICLASS_FXRSTOR64,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_FXRSTOR64_MEMmfpxenv,1574,2,0,0,86,XED_EXCEPTION_INVALID),
/*1120*/ XED_DEF_INST(XED_ICLASS_JECXZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JECXZ_RELBRb,1576,3,0,0,0,XED_EXCEPTION_INVALID),
/*1121*/ XED_DEF_INST(XED_ICLASS_JECXZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JECXZ_RELBRb,1579,3,0,0,0,XED_EXCEPTION_INVALID),
/*1122*/ XED_DEF_INST(XED_ICLASS_MULSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MULSD_XMMsd_MEMsd,938,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1123*/ XED_DEF_INST(XED_ICLASS_MULSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MULSD_XMMsd_XMMsd,940,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1124*/ XED_DEF_INST(XED_ICLASS_ENTER,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_ENTER_IMMw_IMMb,1582,6,0,0,87,XED_EXCEPTION_INVALID),
/*1125*/ XED_DEF_INST(XED_ICLASS_MOVBE,XED_CATEGORY_DATAXFER,XED_EXTENSION_MOVBE,3,XED_IFORM_MOVBE_GPRv_MEMv,1588,2,0,0,39,XED_EXCEPTION_INVALID),
/*1126*/ XED_DEF_INST(XED_ICLASS_MOVBE,XED_CATEGORY_DATAXFER,XED_EXTENSION_MOVBE,3,XED_IFORM_MOVBE_MEMv_GPRv,1590,2,0,0,39,XED_EXCEPTION_INVALID),
/*1127*/ XED_DEF_INST(XED_ICLASS_BNDLDX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDLDX_BND_MEMbnd32,1592,2,0,0,42,XED_EXCEPTION_INVALID),
/*1128*/ XED_DEF_INST(XED_ICLASS_BNDLDX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDLDX_BND_MEMbnd64,1594,2,0,0,42,XED_EXCEPTION_INVALID),
/*1129*/ XED_DEF_INST(XED_ICLASS_BNDLDX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDLDX_BND_MEMbnd64,1594,2,0,0,42,XED_EXCEPTION_INVALID),
/*1130*/ XED_DEF_INST(XED_ICLASS_BNDLDX,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDLDX_BND_MEMbnd64,1594,2,0,0,42,XED_EXCEPTION_INVALID),
/*1131*/ XED_DEF_INST(XED_ICLASS_XSAVEC,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVEC,3,XED_IFORM_XSAVEC_MEMmxsave,400,4,0,0,40,XED_EXCEPTION_INVALID),
/*1132*/ XED_DEF_INST(XED_ICLASS_PFSUBR,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFSUBR_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1133*/ XED_DEF_INST(XED_ICLASS_PFSUBR,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFSUBR_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1134*/ XED_DEF_INST(XED_ICLASS_AESDECLAST,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESDECLAST_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1135*/ XED_DEF_INST(XED_ICLASS_AESDECLAST,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESDECLAST_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1136*/ XED_DEF_INST(XED_ICLASS_REPNE_SCASB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPNE_SCASB,199,5,7,0,25,XED_EXCEPTION_INVALID),
/*1137*/ XED_DEF_INST(XED_ICLASS_REPNE_SCASD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPNE_SCASD,194,5,7,0,22,XED_EXCEPTION_INVALID),
/*1138*/ XED_DEF_INST(XED_ICLASS_FXSAVE,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_FXSAVE_MEMmfpxenv,590,2,0,0,56,XED_EXCEPTION_INVALID),
/*1139*/ XED_DEF_INST(XED_ICLASS_FISTTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_SSE3,3,XED_IFORM_FISTTP_MEMmem32int_ST0,1596,4,4,0,6,XED_EXCEPTION_INVALID),
/*1140*/ XED_DEF_INST(XED_ICLASS_FISTTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_SSE3,3,XED_IFORM_FISTTP_MEMm64int_ST0,1600,4,4,0,6,XED_EXCEPTION_INVALID),
/*1141*/ XED_DEF_INST(XED_ICLASS_FISTTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_SSE3,3,XED_IFORM_FISTTP_MEMmem16int_ST0,1604,4,4,0,6,XED_EXCEPTION_INVALID),
/*1142*/ XED_DEF_INST(XED_ICLASS_PANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_PANDN_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1143*/ XED_DEF_INST(XED_ICLASS_PANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_PANDN_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/*1144*/ XED_DEF_INST(XED_ICLASS_PANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_PANDN_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1145*/ XED_DEF_INST(XED_ICLASS_PANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_PANDN_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1146*/ XED_DEF_INST(XED_ICLASS_PMULDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMULDQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1147*/ XED_DEF_INST(XED_ICLASS_PMULDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMULDQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1148*/ XED_DEF_INST(XED_ICLASS_FCMOVNBE,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVNBE_ST0_X87,474,4,34,0,6,XED_EXCEPTION_INVALID),
/*1149*/ XED_DEF_INST(XED_ICLASS_REPNE_SCASQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REPNE_SCASQ,184,5,7,0,22,XED_EXCEPTION_INVALID),
/*1150*/ XED_DEF_INST(XED_ICLASS_REPNE_SCASW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPNE_SCASW,179,5,7,0,22,XED_EXCEPTION_INVALID),
/*1151*/ XED_DEF_INST(XED_ICLASS_SHUFPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SHUFPD_XMMpd_MEMpd_IMMb,1062,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1152*/ XED_DEF_INST(XED_ICLASS_SHUFPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SHUFPD_XMMpd_XMMpd_IMMb,1065,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1153*/ XED_DEF_INST(XED_ICLASS_SUBPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SUBPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1154*/ XED_DEF_INST(XED_ICLASS_SUBPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SUBPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1155*/ XED_DEF_INST(XED_ICLASS_SQRTPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SQRTPD_XMMpd_MEMpd,1608,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1156*/ XED_DEF_INST(XED_ICLASS_SQRTPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SQRTPD_XMMpd_XMMpd,1610,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1157*/ XED_DEF_INST(XED_ICLASS_POPFQ,XED_CATEGORY_POP,XED_EXTENSION_LONGMODE,3,XED_IFORM_POPFQ,1612,4,1,0,5,XED_EXCEPTION_INVALID),
/*1158*/ XED_DEF_INST(XED_ICLASS_VMCALL,XED_CATEGORY_VTX,XED_EXTENSION_VTX,3,XED_IFORM_VMCALL,999,1,53,0,6,XED_EXCEPTION_INVALID),
/*1159*/ XED_DEF_INST(XED_ICLASS_LEAVE,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_LEAVE,1616,4,0,0,88,XED_EXCEPTION_INVALID),
/*1160*/ XED_DEF_INST(XED_ICLASS_XADD_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_XADD_LOCK_MEMb_GPR8,322,3,18,0,53,XED_EXCEPTION_INVALID),
/*1161*/ XED_DEF_INST(XED_ICLASS_XADD_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_XADD_LOCK_MEMv_GPRv,328,3,18,0,54,XED_EXCEPTION_INVALID),
/*1162*/ XED_DEF_INST(XED_ICLASS_MONITORX,XED_CATEGORY_MISC,XED_EXTENSION_MONITORX,3,XED_IFORM_MONITORX,1041,3,0,0,8,XED_EXCEPTION_INVALID),
/*1163*/ XED_DEF_INST(XED_ICLASS_MONITORX,XED_CATEGORY_MISC,XED_EXTENSION_MONITORX,3,XED_IFORM_MONITORX,1044,3,0,0,8,XED_EXCEPTION_INVALID),
/*1164*/ XED_DEF_INST(XED_ICLASS_MONITORX,XED_CATEGORY_MISC,XED_EXTENSION_MONITORX,3,XED_IFORM_MONITORX,1047,3,0,0,8,XED_EXCEPTION_INVALID),
/*1165*/ XED_DEF_INST(XED_ICLASS_MONITORX,XED_CATEGORY_MISC,XED_EXTENSION_MONITORX,3,XED_IFORM_MONITORX,1041,3,0,0,8,XED_EXCEPTION_INVALID),
/*1166*/ XED_DEF_INST(XED_ICLASS_LIDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LIDT_MEMs64,1620,2,0,0,15,XED_EXCEPTION_INVALID),
/*1167*/ XED_DEF_INST(XED_ICLASS_LIDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LIDT_MEMs,1622,2,0,0,89,XED_EXCEPTION_INVALID),
/*1168*/ XED_DEF_INST(XED_ICLASS_F2XM1,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_F2XM1,140,2,4,0,6,XED_EXCEPTION_INVALID),
/*1169*/ XED_DEF_INST(XED_ICLASS_PMOVZXDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXDQ_XMMdq_MEMq,1624,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1170*/ XED_DEF_INST(XED_ICLASS_PMOVZXDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXDQ_XMMdq_XMMq,1626,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1171*/ XED_DEF_INST(XED_ICLASS_SQRTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SQRTPS_XMMps_MEMps,995,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1172*/ XED_DEF_INST(XED_ICLASS_SQRTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_SQRTPS_XMMps_XMMps,997,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1173*/ XED_DEF_INST(XED_ICLASS_FPREM,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FPREM,1115,3,3,0,6,XED_EXCEPTION_INVALID),
/*1174*/ XED_DEF_INST(XED_ICLASS_AESENC,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESENC_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1175*/ XED_DEF_INST(XED_ICLASS_AESENC,XED_CATEGORY_AES,XED_EXTENSION_AES,3,XED_IFORM_AESENC_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1176*/ XED_DEF_INST(XED_ICLASS_REP_OUTSW,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSW,1628,5,5,0,82,XED_EXCEPTION_INVALID),
/*1177*/ XED_DEF_INST(XED_ICLASS_REP_OUTSW,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSW,1628,5,5,0,82,XED_EXCEPTION_INVALID),
/*1178*/ XED_DEF_INST(XED_ICLASS_PALIGNR,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PALIGNR_MMXq_MEMq_IMMb,1633,3,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1179*/ XED_DEF_INST(XED_ICLASS_PALIGNR,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PALIGNR_MMXq_MMXq_IMMb,1636,3,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1180*/ XED_DEF_INST(XED_ICLASS_PALIGNR,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PALIGNR_XMMdq_MEMdq_IMMb,425,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1181*/ XED_DEF_INST(XED_ICLASS_PALIGNR,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PALIGNR_XMMdq_XMMdq_IMMb,428,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1182*/ XED_DEF_INST(XED_ICLASS_PMINSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINSB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1183*/ XED_DEF_INST(XED_ICLASS_PMINSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINSB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1184*/ XED_DEF_INST(XED_ICLASS_ANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_ANDPD_XMMxuq_MEMxuq,602,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1185*/ XED_DEF_INST(XED_ICLASS_ANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_ANDPD_XMMxuq_XMMxuq,604,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1186*/ XED_DEF_INST(XED_ICLASS_LDS,XED_CATEGORY_SEGOP,XED_EXTENSION_BASE,3,XED_IFORM_LDS_GPRz_MEMp,1639,3,0,0,7,XED_EXCEPTION_INVALID),
/*1187*/ XED_DEF_INST(XED_ICLASS_REP_OUTSB,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSB,1642,5,5,0,83,XED_EXCEPTION_INVALID),
/*1188*/ XED_DEF_INST(XED_ICLASS_REP_OUTSB,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSB,1642,5,5,0,83,XED_EXCEPTION_INVALID),
/*1189*/ XED_DEF_INST(XED_ICLASS_PMULHW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMULHW_MMXq_MEMq,417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1190*/ XED_DEF_INST(XED_ICLASS_PMULHW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMULHW_MMXq_MMXq,419,2,0,0,6,XED_EXCEPTION_INVALID),
/*1191*/ XED_DEF_INST(XED_ICLASS_PMULHW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULHW_XMMdq_MEMdq,421,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1192*/ XED_DEF_INST(XED_ICLASS_PMULHW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULHW_XMMdq_XMMdq,423,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1193*/ XED_DEF_INST(XED_ICLASS_REP_OUTSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSD,1647,5,5,0,82,XED_EXCEPTION_INVALID),
/*1194*/ XED_DEF_INST(XED_ICLASS_REP_OUTSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSD,1647,5,5,0,82,XED_EXCEPTION_INVALID),
/*1195*/ XED_DEF_INST(XED_ICLASS_REP_OUTSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSD,1647,5,5,0,82,XED_EXCEPTION_INVALID),
/*1196*/ XED_DEF_INST(XED_ICLASS_REP_OUTSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_OUTSD,1647,5,5,0,82,XED_EXCEPTION_INVALID),
/*1197*/ XED_DEF_INST(XED_ICLASS_XLAT,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_XLAT,1652,3,0,0,62,XED_EXCEPTION_INVALID),
/*1198*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_MEMb_GPR8,1655,2,0,0,53,XED_EXCEPTION_INVALID),
/*1199*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_MEMb_GPR8,1655,2,0,0,53,XED_EXCEPTION_INVALID),
/*1200*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_GPR8_GPR8,1657,2,0,0,37,XED_EXCEPTION_INVALID),
/*1201*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_MEMv_GPRv,1659,2,0,0,54,XED_EXCEPTION_INVALID),
/*1202*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_MEMv_GPRv,1659,2,0,0,54,XED_EXCEPTION_INVALID),
/*1203*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_GPRv_GPRv,1661,2,0,0,39,XED_EXCEPTION_INVALID),
/*1204*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_GPRv_OrAX,1663,2,0,0,39,XED_EXCEPTION_INVALID),
/*1205*/ XED_DEF_INST(XED_ICLASS_XCHG,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_XCHG_GPRv_OrAX,1663,2,0,0,39,XED_EXCEPTION_INVALID),
/*1206*/ XED_DEF_INST(XED_ICLASS_FINCSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FINCSTP,1665,1,4,0,76,XED_EXCEPTION_INVALID),
/*1207*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_XMMdq_MEMq_0F6E,1666,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1208*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_XMMdq_GPR64,1668,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1209*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_MEMq_XMMq_0F7E,1670,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1210*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_GPR64_XMMq,1672,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1211*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_MEMq_XMMq_0FD6,1670,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1212*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_XMMdq_XMMq_0FD6,1674,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1213*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_XMMdq_MEMq_0F7E,1666,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1214*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVQ_XMMdq_XMMq_0F7E,1676,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1215*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MMXq_MEMq_0F6E,1260,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1216*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MMXq_GPR64,1678,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1217*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MEMq_MMXq_0F7E,226,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1218*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_GPR64_MMXq,1680,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1219*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MMXq_MEMq_0F6F,1260,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1220*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MMXq_MMXq_0F6F,1262,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1221*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MEMq_MMXq_0F7F,226,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1222*/ XED_DEF_INST(XED_ICLASS_MOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVQ_MMXq_MMXq_0F7F,1682,2,0,0,6,XED_EXCEPTION_MMX_NOFP2),
/*1223*/ XED_DEF_INST(XED_ICLASS_PMINSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMINSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1224*/ XED_DEF_INST(XED_ICLASS_PMINSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMINSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1225*/ XED_DEF_INST(XED_ICLASS_PMINSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMINSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1226*/ XED_DEF_INST(XED_ICLASS_PMINSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMINSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1227*/ XED_DEF_INST(XED_ICLASS_SMSW,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SMSW_MEMw,1684,2,0,0,0,XED_EXCEPTION_INVALID),
/*1228*/ XED_DEF_INST(XED_ICLASS_SMSW,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SMSW_GPRv,1686,2,0,0,39,XED_EXCEPTION_INVALID),
/*1229*/ XED_DEF_INST(XED_ICLASS_XRSTOR,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVE,3,XED_IFORM_XRSTOR_MEMmxsave,90,4,0,0,90,XED_EXCEPTION_INVALID),
/*1230*/ XED_DEF_INST(XED_ICLASS_FTST,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FTST,140,2,3,0,6,XED_EXCEPTION_INVALID),
/*1231*/ XED_DEF_INST(XED_ICLASS_CVTTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTPD2DQ_XMMdq_MEMpd,1213,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1232*/ XED_DEF_INST(XED_ICLASS_CVTTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTPD2DQ_XMMdq_XMMpd,1215,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1233*/ XED_DEF_INST(XED_ICLASS_XRSTOR64,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVE,3,XED_IFORM_XRSTOR64_MEMmxsave,90,4,0,0,90,XED_EXCEPTION_INVALID),
/*1234*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_MEMb_IMMb_80r4,764,3,43,0,36,XED_EXCEPTION_INVALID),
/*1235*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPR8_IMMb_80r4,767,3,43,0,37,XED_EXCEPTION_INVALID),
/*1236*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_MEMv_IMMz,770,3,43,0,38,XED_EXCEPTION_INVALID),
/*1237*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPRv_IMMz,773,3,43,0,39,XED_EXCEPTION_INVALID),
/*1238*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_MEMb_IMMb_82r4,764,3,43,0,36,XED_EXCEPTION_INVALID),
/*1239*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPR8_IMMb_82r4,767,3,43,0,37,XED_EXCEPTION_INVALID),
/*1240*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_MEMv_IMMb,776,3,43,0,38,XED_EXCEPTION_INVALID),
/*1241*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPRv_IMMb,779,3,43,0,39,XED_EXCEPTION_INVALID),
/*1242*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_MEMb_GPR8,782,3,43,0,36,XED_EXCEPTION_INVALID),
/*1243*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPR8_GPR8_20,785,3,43,0,37,XED_EXCEPTION_INVALID),
/*1244*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_MEMv_GPRv,788,3,43,0,38,XED_EXCEPTION_INVALID),
/*1245*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPRv_GPRv_21,791,3,43,0,39,XED_EXCEPTION_INVALID),
/*1246*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPR8_GPR8_22,794,3,43,0,37,XED_EXCEPTION_INVALID),
/*1247*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPR8_MEMb,797,3,43,0,37,XED_EXCEPTION_INVALID),
/*1248*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPRv_GPRv_23,800,3,43,0,39,XED_EXCEPTION_INVALID),
/*1249*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_GPRv_MEMv,803,3,43,0,39,XED_EXCEPTION_INVALID),
/*1250*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_AL_IMMb,1688,3,43,0,37,XED_EXCEPTION_INVALID),
/*1251*/ XED_DEF_INST(XED_ICLASS_AND,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_AND_OrAX_IMMz,809,3,43,0,39,XED_EXCEPTION_INVALID),
/*1252*/ XED_DEF_INST(XED_ICLASS_PI2FD,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PI2FD_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1253*/ XED_DEF_INST(XED_ICLASS_PI2FD,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PI2FD_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1254*/ XED_DEF_INST(XED_ICLASS_PSHUFB,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSHUFB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1255*/ XED_DEF_INST(XED_ICLASS_PSHUFB,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PSHUFB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1256*/ XED_DEF_INST(XED_ICLASS_PSHUFB,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSHUFB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1257*/ XED_DEF_INST(XED_ICLASS_PSHUFB,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PSHUFB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1258*/ XED_DEF_INST(XED_ICLASS_FLDENV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDENV_MEMmem14,1691,2,3,0,76,XED_EXCEPTION_INVALID),
/*1259*/ XED_DEF_INST(XED_ICLASS_FLDENV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDENV_MEMmem28,1693,2,3,0,76,XED_EXCEPTION_INVALID),
/*1260*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPR8_IMMb_C6r0,1695,2,0,0,37,XED_EXCEPTION_INVALID),
/*1261*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMb_IMMb,1697,2,0,0,91,XED_EXCEPTION_INVALID),
/*1262*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPRv_IMMz,1699,2,0,0,39,XED_EXCEPTION_INVALID),
/*1263*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMv_IMMz,1701,2,0,0,92,XED_EXCEPTION_INVALID),
/*1264*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPR8_GPR8_88,1703,2,0,0,37,XED_EXCEPTION_INVALID),
/*1265*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMb_GPR8,1705,2,0,0,91,XED_EXCEPTION_INVALID),
/*1266*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMv_GPRv,1590,2,0,0,92,XED_EXCEPTION_INVALID),
/*1267*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPRv_GPRv_89,1707,2,0,0,39,XED_EXCEPTION_INVALID),
/*1268*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPR8_MEMb,1709,2,0,0,37,XED_EXCEPTION_INVALID),
/*1269*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPR8_GPR8_8A,1711,2,0,0,37,XED_EXCEPTION_INVALID),
/*1270*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPRv_MEMv,1588,2,0,0,39,XED_EXCEPTION_INVALID),
/*1271*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPRv_GPRv_8B,1713,2,0,0,39,XED_EXCEPTION_INVALID),
/*1272*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMw_SEG,1715,2,0,0,0,XED_EXCEPTION_INVALID),
/*1273*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPRv_SEG,1717,2,0,0,39,XED_EXCEPTION_INVALID),
/*1274*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_SEG_MEMw,1719,2,0,0,6,XED_EXCEPTION_INVALID),
/*1275*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_SEG_GPR16,1721,2,0,0,6,XED_EXCEPTION_INVALID),
/*1276*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_AL_MEMb,1723,2,0,0,61,XED_EXCEPTION_INVALID),
/*1277*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_OrAX_MEMv,1725,2,0,0,88,XED_EXCEPTION_INVALID),
/*1278*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMb_AL,1727,2,0,0,61,XED_EXCEPTION_INVALID),
/*1279*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_MEMv_OrAX,1729,2,0,0,88,XED_EXCEPTION_INVALID),
/*1280*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPR8_IMMb_B0,1731,2,0,0,37,XED_EXCEPTION_INVALID),
/*1281*/ XED_DEF_INST(XED_ICLASS_MOV,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOV_GPRv_IMMv,1733,2,0,0,39,XED_EXCEPTION_INVALID),
/*1282*/ XED_DEF_INST(XED_ICLASS_PSHUFD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSHUFD_XMMdq_MEMdq_IMMb,1735,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1283*/ XED_DEF_INST(XED_ICLASS_PSHUFD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSHUFD_XMMdq_XMMdq_IMMb,1738,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1284*/ XED_DEF_INST(XED_ICLASS_JLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JLE_RELBRb,163,3,6,0,20,XED_EXCEPTION_INVALID),
/*1285*/ XED_DEF_INST(XED_ICLASS_JLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JLE_RELBRb,166,3,6,0,20,XED_EXCEPTION_INVALID),
/*1286*/ XED_DEF_INST(XED_ICLASS_JLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JLE_RELBRz,169,3,6,0,21,XED_EXCEPTION_INVALID),
/*1287*/ XED_DEF_INST(XED_ICLASS_JLE,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JLE_RELBRd,172,3,6,0,20,XED_EXCEPTION_INVALID),
/*1288*/ XED_DEF_INST(XED_ICLASS_VMFUNC,XED_CATEGORY_VTX,XED_EXTENSION_VMFUNC,3,XED_IFORM_VMFUNC,1741,1,0,0,0,XED_EXCEPTION_INVALID),
/*1289*/ XED_DEF_INST(XED_ICLASS_WRFSBASE,XED_CATEGORY_RDWRFSGS,XED_EXTENSION_RDWRFSGS,3,XED_IFORM_WRFSBASE_GPRy,1742,2,0,0,7,XED_EXCEPTION_INVALID),
/*1290*/ XED_DEF_INST(XED_ICLASS_PFCMPEQ,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCMPEQ_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1291*/ XED_DEF_INST(XED_ICLASS_PFCMPEQ,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFCMPEQ_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1292*/ XED_DEF_INST(XED_ICLASS_PSHUFW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSHUFW_MMXq_MEMq_IMMb,1744,3,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1293*/ XED_DEF_INST(XED_ICLASS_PSHUFW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSHUFW_MMXq_MMXq_IMMb,1747,3,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1294*/ XED_DEF_INST(XED_ICLASS_SETSSBSY,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_SETSSBSY,0,0,0,0,0,XED_EXCEPTION_INVALID),
/*1295*/ XED_DEF_INST(XED_ICLASS_BNDMK,XED_CATEGORY_MPX,XED_EXTENSION_MPX,3,XED_IFORM_BNDMK_BND_AGEN,1750,2,0,0,93,XED_EXCEPTION_INVALID),
/*1296*/ XED_DEF_INST(XED_ICLASS_PMOVSXBD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXBD_XMMdq_MEMd,1752,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1297*/ XED_DEF_INST(XED_ICLASS_PMOVSXBD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXBD_XMMdq_XMMd,1754,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1298*/ XED_DEF_INST(XED_ICLASS_FPATAN,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FPATAN,409,4,4,0,6,XED_EXCEPTION_INVALID),
/*1299*/ XED_DEF_INST(XED_ICLASS_PMOVSXWQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXWQ_XMMdq_MEMd,1756,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1300*/ XED_DEF_INST(XED_ICLASS_PMOVSXWQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXWQ_XMMdq_XMMd,1758,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1301*/ XED_DEF_INST(XED_ICLASS_FST,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FST_MEMmem32real_ST0,1760,3,4,0,6,XED_EXCEPTION_INVALID),
/*1302*/ XED_DEF_INST(XED_ICLASS_FST,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FST_MEMm64real_ST0,1763,3,4,0,6,XED_EXCEPTION_INVALID),
/*1303*/ XED_DEF_INST(XED_ICLASS_FST,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FST_X87_ST0,1766,3,4,0,6,XED_EXCEPTION_INVALID),
/*1304*/ XED_DEF_INST(XED_ICLASS_FIST,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIST_MEMmem32int_ST0,1769,3,4,0,6,XED_EXCEPTION_INVALID),
/*1305*/ XED_DEF_INST(XED_ICLASS_FIST,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIST_MEMmem16int_ST0,1772,3,4,0,6,XED_EXCEPTION_INVALID),
/*1306*/ XED_DEF_INST(XED_ICLASS_PMOVSXBQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXBQ_XMMdq_MEMw,1775,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1307*/ XED_DEF_INST(XED_ICLASS_PMOVSXBQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVSXBQ_XMMdq_XMMw,1777,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1308*/ XED_DEF_INST(XED_ICLASS_MOVLPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVLPD_XMMsd_MEMq,1454,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1309*/ XED_DEF_INST(XED_ICLASS_MOVLPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVLPD_MEMq_XMMsd,1779,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1310*/ XED_DEF_INST(XED_ICLASS_CVTTPS2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTTPS2PI_MMXq_MEMq,1781,2,0,0,45,XED_EXCEPTION_MMX_FP),
/*1311*/ XED_DEF_INST(XED_ICLASS_CVTTPS2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTTPS2PI_MMXq_XMMq,1783,2,0,0,45,XED_EXCEPTION_MMX_FP),
/*1312*/ XED_DEF_INST(XED_ICLASS_PREFETCHWT1,XED_CATEGORY_PREFETCHWT1,XED_EXTENSION_PREFETCHWT1,3,XED_IFORM_PREFETCHWT1_MEMu8,1024,1,0,0,24,XED_EXCEPTION_INVALID),
/*1313*/ XED_DEF_INST(XED_ICLASS_LDDQU,XED_CATEGORY_SSE,XED_EXTENSION_SSE3,3,XED_IFORM_LDDQU_XMMpd_MEMdq,1785,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1314*/ XED_DEF_INST(XED_ICLASS_RSQRTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RSQRTPS_XMMps_MEMps,995,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1315*/ XED_DEF_INST(XED_ICLASS_RSQRTPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RSQRTPS_XMMps_XMMps,997,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1316*/ XED_DEF_INST(XED_ICLASS_PFRCP,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFRCP_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1317*/ XED_DEF_INST(XED_ICLASS_PFRCP,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFRCP_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1318*/ XED_DEF_INST(XED_ICLASS_CVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSS2SD_XMMsd_MEMss,1787,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1319*/ XED_DEF_INST(XED_ICLASS_CVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSS2SD_XMMsd_XMMss,1789,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1320*/ XED_DEF_INST(XED_ICLASS_FDIVRP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIVRP_X87_ST0,572,4,4,0,6,XED_EXCEPTION_INVALID),
/*1321*/ XED_DEF_INST(XED_ICLASS_FBLD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FBLD_ST0_MEMmem80dec,1791,4,4,0,6,XED_EXCEPTION_INVALID),
/*1322*/ XED_DEF_INST(XED_ICLASS_CPUID,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_CPUID,1795,4,0,0,6,XED_EXCEPTION_INVALID),
/*1323*/ XED_DEF_INST(XED_ICLASS_RDTSC,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_RDTSC,1799,3,0,0,0,XED_EXCEPTION_INVALID),
/*1324*/ XED_DEF_INST(XED_ICLASS_PFSQRT,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFSQRT_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1325*/ XED_DEF_INST(XED_ICLASS_PFSQRT,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFSQRT_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1326*/ XED_DEF_INST(XED_ICLASS_LZCNT,XED_CATEGORY_LZCNT,XED_EXTENSION_LZCNT,3,XED_IFORM_LZCNT_GPRv_MEMv,220,3,72,0,39,XED_EXCEPTION_INVALID),
/*1327*/ XED_DEF_INST(XED_ICLASS_LZCNT,XED_CATEGORY_LZCNT,XED_EXTENSION_LZCNT,3,XED_IFORM_LZCNT_GPRv_GPRv,223,3,72,0,39,XED_EXCEPTION_INVALID),
/*1328*/ XED_DEF_INST(XED_ICLASS_MINPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MINPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1329*/ XED_DEF_INST(XED_ICLASS_MINPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MINPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1330*/ XED_DEF_INST(XED_ICLASS_XORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_XORPD_XMMxuq_MEMxuq,602,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1331*/ XED_DEF_INST(XED_ICLASS_XORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE2,3,XED_IFORM_XORPD_XMMxuq_XMMxuq,604,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1332*/ XED_DEF_INST(XED_ICLASS_MAXSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MAXSD_XMMsd_MEMsd,938,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1333*/ XED_DEF_INST(XED_ICLASS_MAXSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MAXSD_XMMsd_XMMsd,940,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1334*/ XED_DEF_INST(XED_ICLASS_FIDIVR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIDIVR_ST0_MEMmem32int,753,3,4,0,6,XED_EXCEPTION_INVALID),
/*1335*/ XED_DEF_INST(XED_ICLASS_FIDIVR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FIDIVR_ST0_MEMmem16int,756,3,4,0,6,XED_EXCEPTION_INVALID),
/*1336*/ XED_DEF_INST(XED_ICLASS_IRET,XED_CATEGORY_RET,XED_EXTENSION_BASE,3,XED_IFORM_IRET,1137,5,61,0,75,XED_EXCEPTION_INVALID),
/*1337*/ XED_DEF_INST(XED_ICLASS_ADD_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_LOCK_MEMb_IMMb_80r0,1284,3,18,0,53,XED_EXCEPTION_INVALID),
/*1338*/ XED_DEF_INST(XED_ICLASS_ADD_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_LOCK_MEMv_IMMz,770,3,18,0,54,XED_EXCEPTION_INVALID),
/*1339*/ XED_DEF_INST(XED_ICLASS_ADD_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_LOCK_MEMb_IMMb_82r0,1284,3,18,0,53,XED_EXCEPTION_INVALID),
/*1340*/ XED_DEF_INST(XED_ICLASS_ADD_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_LOCK_MEMv_IMMb,776,3,18,0,54,XED_EXCEPTION_INVALID),
/*1341*/ XED_DEF_INST(XED_ICLASS_ADD_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_LOCK_MEMb_GPR8,782,3,18,0,53,XED_EXCEPTION_INVALID),
/*1342*/ XED_DEF_INST(XED_ICLASS_ADD_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_LOCK_MEMv_GPRv,788,3,18,0,54,XED_EXCEPTION_INVALID),
/*1343*/ XED_DEF_INST(XED_ICLASS_MINPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MINPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1344*/ XED_DEF_INST(XED_ICLASS_MINPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MINPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1345*/ XED_DEF_INST(XED_ICLASS_FDISI8087_NOP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDISI8087_NOP,0,0,0,0,63,XED_EXCEPTION_INVALID),
/*1346*/ XED_DEF_INST(XED_ICLASS_WRGSBASE,XED_CATEGORY_RDWRFSGS,XED_EXTENSION_RDWRFSGS,3,XED_IFORM_WRGSBASE_GPRy,1802,2,0,0,7,XED_EXCEPTION_INVALID),
/*1347*/ XED_DEF_INST(XED_ICLASS_ADDSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_ADDSD_XMMsd_MEMsd,938,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1348*/ XED_DEF_INST(XED_ICLASS_ADDSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_ADDSD_XMMsd_XMMsd,940,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1349*/ XED_DEF_INST(XED_ICLASS_VMXOFF,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMXOFF,759,1,73,0,6,XED_EXCEPTION_INVALID),
/*1350*/ XED_DEF_INST(XED_ICLASS_PSRLQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLQ_MMXq_IMMb,1458,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1351*/ XED_DEF_INST(XED_ICLASS_PSRLQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLQ_XMMdq_IMMb,1460,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1352*/ XED_DEF_INST(XED_ICLASS_PSRLQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLQ_MMXq_MEMq,1462,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1353*/ XED_DEF_INST(XED_ICLASS_PSRLQ,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLQ_MMXq_MMXq,1464,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1354*/ XED_DEF_INST(XED_ICLASS_PSRLQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1355*/ XED_DEF_INST(XED_ICLASS_PSRLQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1356*/ XED_DEF_INST(XED_ICLASS_PSRLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLW_MMXq_IMMb,1438,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1357*/ XED_DEF_INST(XED_ICLASS_PSRLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLW_XMMdq_IMMb,1440,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1358*/ XED_DEF_INST(XED_ICLASS_PSRLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLW_MMXq_MEMq,1442,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1359*/ XED_DEF_INST(XED_ICLASS_PSRLW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLW_MMXq_MMXq,1444,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1360*/ XED_DEF_INST(XED_ICLASS_PSRLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1361*/ XED_DEF_INST(XED_ICLASS_PSRLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1362*/ XED_DEF_INST(XED_ICLASS_MOVDIR64B,XED_CATEGORY_MOVDIR,XED_EXTENSION_MOVDIR,3,XED_IFORM_MOVDIR64B_GPRa_MEM,1804,4,0,0,33,XED_EXCEPTION_INVALID),
/*1363*/ XED_DEF_INST(XED_ICLASS_MOVDIR64B,XED_CATEGORY_MOVDIR,XED_EXTENSION_MOVDIR,3,XED_IFORM_MOVDIR64B_GPRa_MEM,1804,4,0,0,33,XED_EXCEPTION_INVALID),
/*1364*/ XED_DEF_INST(XED_ICLASS_SIDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SIDT_MEMs,1808,2,0,0,7,XED_EXCEPTION_INVALID),
/*1365*/ XED_DEF_INST(XED_ICLASS_SIDT,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_SIDT_MEMs64,1810,2,0,0,0,XED_EXCEPTION_INVALID),
/*1366*/ XED_DEF_INST(XED_ICLASS_SYSRET_AMD,XED_CATEGORY_SYSRET,XED_EXTENSION_BASE,0,XED_IFORM_SYSRET_AMD,1812,2,74,0,94,XED_EXCEPTION_INVALID),
/*1367*/ XED_DEF_INST(XED_ICLASS_MOVDIRI,XED_CATEGORY_MOVDIR,XED_EXTENSION_MOVDIR,3,XED_IFORM_MOVDIRI_MEMu32_GPR32u32,600,2,0,0,0,XED_EXCEPTION_INVALID),
/*1368*/ XED_DEF_INST(XED_ICLASS_MOVDIRI,XED_CATEGORY_MOVDIR,XED_EXTENSION_MOVDIR,3,XED_IFORM_MOVDIRI_MEMu64_GPR64u64,612,2,0,0,0,XED_EXCEPTION_INVALID),
/*1369*/ XED_DEF_INST(XED_ICLASS_XSAVE,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVE,3,XED_IFORM_XSAVE_MEMmxsave,900,4,0,0,40,XED_EXCEPTION_INVALID),
/*1370*/ XED_DEF_INST(XED_ICLASS_SHA256MSG1,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA256MSG1_XMMi32_XMMi32_SHA,285,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1371*/ XED_DEF_INST(XED_ICLASS_SHA256MSG1,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA256MSG1_XMMi32_MEMi32_SHA,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1372*/ XED_DEF_INST(XED_ICLASS_CDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_BASE,3,XED_IFORM_CDQ,1814,2,0,0,0,XED_EXCEPTION_INVALID),
/*1373*/ XED_DEF_INST(XED_ICLASS_PSRLD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLD_MMXq_IMMb,1417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1374*/ XED_DEF_INST(XED_ICLASS_PSRLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLD_XMMdq_IMMb,1419,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1375*/ XED_DEF_INST(XED_ICLASS_PSRLD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLD_MMXq_MEMq,1421,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1376*/ XED_DEF_INST(XED_ICLASS_PSRLD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRLD_MMXq_MMXq,1423,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1377*/ XED_DEF_INST(XED_ICLASS_PSRLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1378*/ XED_DEF_INST(XED_ICLASS_PSRLD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRLD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1379*/ XED_DEF_INST(XED_ICLASS_SBB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_LOCK_MEMb_IMMb_80r3,551,3,38,0,53,XED_EXCEPTION_INVALID),
/*1380*/ XED_DEF_INST(XED_ICLASS_SBB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_LOCK_MEMv_IMMz,554,3,38,0,54,XED_EXCEPTION_INVALID),
/*1381*/ XED_DEF_INST(XED_ICLASS_SBB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_LOCK_MEMb_IMMb_82r3,551,3,38,0,53,XED_EXCEPTION_INVALID),
/*1382*/ XED_DEF_INST(XED_ICLASS_SBB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_LOCK_MEMv_IMMb,557,3,38,0,54,XED_EXCEPTION_INVALID),
/*1383*/ XED_DEF_INST(XED_ICLASS_SBB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_LOCK_MEMb_GPR8,560,3,38,0,53,XED_EXCEPTION_INVALID),
/*1384*/ XED_DEF_INST(XED_ICLASS_SBB_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SBB_LOCK_MEMv_GPRv,563,3,38,0,54,XED_EXCEPTION_INVALID),
/*1385*/ XED_DEF_INST(XED_ICLASS_CRC32,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_CRC32_GPRyy_MEMb,1816,2,0,0,27,XED_EXCEPTION_INVALID),
/*1386*/ XED_DEF_INST(XED_ICLASS_CRC32,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_CRC32_GPRyy_GPR8b,1818,2,0,0,27,XED_EXCEPTION_INVALID),
/*1387*/ XED_DEF_INST(XED_ICLASS_CRC32,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_CRC32_GPRyy_MEMv,1820,2,0,0,27,XED_EXCEPTION_INVALID),
/*1388*/ XED_DEF_INST(XED_ICLASS_CRC32,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_CRC32_GPRyy_GPRv,1822,2,0,0,27,XED_EXCEPTION_INVALID),
/*1389*/ XED_DEF_INST(XED_ICLASS_INSB,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_INSB,1824,4,5,0,19,XED_EXCEPTION_INVALID),
/*1390*/ XED_DEF_INST(XED_ICLASS_RDFSBASE,XED_CATEGORY_RDWRFSGS,XED_EXTENSION_RDWRFSGS,3,XED_IFORM_RDFSBASE_GPRy,1828,2,0,0,39,XED_EXCEPTION_INVALID),
/*1391*/ XED_DEF_INST(XED_ICLASS_INSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_INSD,1830,4,5,0,17,XED_EXCEPTION_INVALID),
/*1392*/ XED_DEF_INST(XED_ICLASS_INSD,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_INSD,1830,4,5,0,17,XED_EXCEPTION_INVALID),
/*1393*/ XED_DEF_INST(XED_ICLASS_MOVNTSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE4A,3,XED_IFORM_MOVNTSS_MEMd_XMMd,1834,2,0,0,95,XED_EXCEPTION_INVALID),
/*1394*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_MEMb,1148,4,62,0,37,XED_EXCEPTION_INVALID),
/*1395*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPR8,1152,4,62,0,37,XED_EXCEPTION_INVALID),
/*1396*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_MEMv,1156,4,62,0,39,XED_EXCEPTION_INVALID),
/*1397*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv,1160,4,62,0,39,XED_EXCEPTION_INVALID),
/*1398*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv_MEMv_IMMz,1836,4,62,0,39,XED_EXCEPTION_INVALID),
/*1399*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv_GPRv_IMMz,1840,4,62,0,39,XED_EXCEPTION_INVALID),
/*1400*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv_MEMv_IMMb,1844,4,62,0,39,XED_EXCEPTION_INVALID),
/*1401*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv_GPRv_IMMb,1848,4,62,0,39,XED_EXCEPTION_INVALID),
/*1402*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv_MEMv,803,3,62,0,39,XED_EXCEPTION_INVALID),
/*1403*/ XED_DEF_INST(XED_ICLASS_IMUL,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_IMUL_GPRv_GPRv,800,3,62,0,39,XED_EXCEPTION_INVALID),
/*1404*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_MEMb_IMMb,1852,3,19,1,37,XED_EXCEPTION_INVALID),
/*1405*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_GPR8_IMMb,1855,3,20,1,37,XED_EXCEPTION_INVALID),
/*1406*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_MEMv_IMMb,1858,3,21,1,39,XED_EXCEPTION_INVALID),
/*1407*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_GPRv_IMMb,1861,3,22,1,39,XED_EXCEPTION_INVALID),
/*1408*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_MEMb_ONE,1864,3,75,0,65,XED_EXCEPTION_INVALID),
/*1409*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_GPR8_ONE,1867,3,75,0,65,XED_EXCEPTION_INVALID),
/*1410*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_MEMv_ONE,1870,3,75,0,66,XED_EXCEPTION_INVALID),
/*1411*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_GPRv_ONE,1873,3,75,0,66,XED_EXCEPTION_INVALID),
/*1412*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_MEMb_CL,1876,3,77,0,37,XED_EXCEPTION_INVALID),
/*1413*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_GPR8_CL,1879,3,77,0,37,XED_EXCEPTION_INVALID),
/*1414*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_MEMv_CL,1882,3,77,0,39,XED_EXCEPTION_INVALID),
/*1415*/ XED_DEF_INST(XED_ICLASS_RCR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCR_GPRv_CL,1885,3,77,0,39,XED_EXCEPTION_INVALID),
/*1416*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_MEMb_IMMb,1852,3,23,1,37,XED_EXCEPTION_INVALID),
/*1417*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_GPR8_IMMb,1855,3,24,1,37,XED_EXCEPTION_INVALID),
/*1418*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_MEMv_IMMb,1858,3,25,1,39,XED_EXCEPTION_INVALID),
/*1419*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_GPRv_IMMb,1861,3,26,1,39,XED_EXCEPTION_INVALID),
/*1420*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_MEMb_ONE,1864,3,75,0,65,XED_EXCEPTION_INVALID),
/*1421*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_GPR8_ONE,1867,3,75,0,65,XED_EXCEPTION_INVALID),
/*1422*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_MEMv_ONE,1870,3,75,0,66,XED_EXCEPTION_INVALID),
/*1423*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_GPRv_ONE,1873,3,75,0,66,XED_EXCEPTION_INVALID),
/*1424*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_MEMb_CL,1876,3,77,0,37,XED_EXCEPTION_INVALID),
/*1425*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_GPR8_CL,1879,3,77,0,37,XED_EXCEPTION_INVALID),
/*1426*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_MEMv_CL,1882,3,77,0,39,XED_EXCEPTION_INVALID),
/*1427*/ XED_DEF_INST(XED_ICLASS_RCL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_RCL_GPRv_CL,1885,3,77,0,39,XED_EXCEPTION_INVALID),
/*1428*/ XED_DEF_INST(XED_ICLASS_MOVNTSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE4A,3,XED_IFORM_MOVNTSD_MEMq_XMMq,1670,2,0,0,95,XED_EXCEPTION_INVALID),
/*1429*/ XED_DEF_INST(XED_ICLASS_INSW,XED_CATEGORY_IOSTRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_INSW,1888,4,5,0,17,XED_EXCEPTION_INVALID),
/*1430*/ XED_DEF_INST(XED_ICLASS_SUBSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SUBSD_XMMsd_MEMsd,938,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1431*/ XED_DEF_INST(XED_ICLASS_SUBSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_SUBSD_XMMsd_XMMsd,940,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1432*/ XED_DEF_INST(XED_ICLASS_DIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DIV_MEMb,965,3,52,0,37,XED_EXCEPTION_INVALID),
/*1433*/ XED_DEF_INST(XED_ICLASS_DIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DIV_GPR8,968,3,52,0,37,XED_EXCEPTION_INVALID),
/*1434*/ XED_DEF_INST(XED_ICLASS_DIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DIV_MEMv,971,4,52,0,39,XED_EXCEPTION_INVALID),
/*1435*/ XED_DEF_INST(XED_ICLASS_DIV,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DIV_GPRv,975,4,52,0,39,XED_EXCEPTION_INVALID),
/*1436*/ XED_DEF_INST(XED_ICLASS_PCLMULQDQ,XED_CATEGORY_PCLMULQDQ,XED_EXTENSION_PCLMULQDQ,3,XED_IFORM_PCLMULQDQ_XMMdq_XMMdq_IMMb,428,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1437*/ XED_DEF_INST(XED_ICLASS_PCLMULQDQ,XED_CATEGORY_PCLMULQDQ,XED_EXTENSION_PCLMULQDQ,3,XED_IFORM_PCLMULQDQ_XMMdq_MEMdq_IMMb,425,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1438*/ XED_DEF_INST(XED_ICLASS_PTWRITE,XED_CATEGORY_PT,XED_EXTENSION_PT,3,XED_IFORM_PTWRITE_GPRy,1892,1,0,0,39,XED_EXCEPTION_INVALID),
/*1439*/ XED_DEF_INST(XED_ICLASS_PTWRITE,XED_CATEGORY_PT,XED_EXTENSION_PT,3,XED_IFORM_PTWRITE_MEMy,1893,1,0,0,39,XED_EXCEPTION_INVALID),
/*1440*/ XED_DEF_INST(XED_ICLASS_FSUBRP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSUBRP_X87_ST0,572,4,4,0,6,XED_EXCEPTION_INVALID),
/*1441*/ XED_DEF_INST(XED_ICLASS_PUSHA,XED_CATEGORY_PUSH,XED_EXTENSION_BASE,3,XED_IFORM_PUSHA,1894,11,0,0,70,XED_EXCEPTION_INVALID),
/*1442*/ XED_DEF_INST(XED_ICLASS_FABS,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FABS,140,2,4,0,6,XED_EXCEPTION_INVALID),
/*1443*/ XED_DEF_INST(XED_ICLASS_FEMMS,XED_CATEGORY_MMX,XED_EXTENSION_3DNOW,3,XED_IFORM_FEMMS,0,0,0,0,96,XED_EXCEPTION_INVALID),
/*1444*/ XED_DEF_INST(XED_ICLASS_STOSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_STOSW,1905,4,39,0,62,XED_EXCEPTION_INVALID),
/*1445*/ XED_DEF_INST(XED_ICLASS_PADDSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDSB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1446*/ XED_DEF_INST(XED_ICLASS_PADDSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PADDSB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1447*/ XED_DEF_INST(XED_ICLASS_PADDSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDSB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1448*/ XED_DEF_INST(XED_ICLASS_PADDSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PADDSB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1449*/ XED_DEF_INST(XED_ICLASS_STOSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_STOSQ,1909,4,39,0,62,XED_EXCEPTION_INVALID),
/*1450*/ XED_DEF_INST(XED_ICLASS_CMPXCHG16B,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_LONGMODE,3,XED_IFORM_CMPXCHG16B_MEMdq,1913,6,16,0,97,XED_EXCEPTION_INVALID),
/*1451*/ XED_DEF_INST(XED_ICLASS_REP_MOVSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_MOVSD,1919,6,39,0,71,XED_EXCEPTION_INVALID),
/*1452*/ XED_DEF_INST(XED_ICLASS_REP_MOVSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_MOVSD,1919,6,39,0,71,XED_EXCEPTION_INVALID),
/*1453*/ XED_DEF_INST(XED_ICLASS_REP_MOVSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_MOVSB,1925,6,39,0,72,XED_EXCEPTION_INVALID),
/*1454*/ XED_DEF_INST(XED_ICLASS_REP_MOVSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_MOVSB,1925,6,39,0,72,XED_EXCEPTION_INVALID),
/*1455*/ XED_DEF_INST(XED_ICLASS_FCMOVU,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVU_ST0_X87,474,4,23,0,6,XED_EXCEPTION_INVALID),
/*1456*/ XED_DEF_INST(XED_ICLASS_EXTRQ,XED_CATEGORY_BITBYTE,XED_EXTENSION_SSE4A,3,XED_IFORM_EXTRQ_XMMq_IMMb_IMMb,1931,3,0,0,44,XED_EXCEPTION_INVALID),
/*1457*/ XED_DEF_INST(XED_ICLASS_EXTRQ,XED_CATEGORY_BITBYTE,XED_EXTENSION_SSE4A,3,XED_IFORM_EXTRQ_XMMq_XMMdq,463,2,0,0,44,XED_EXCEPTION_INVALID),
/*1458*/ XED_DEF_INST(XED_ICLASS_DPPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_DPPD_XMMdq_MEMdq_IMMb,1233,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2D),
/*1459*/ XED_DEF_INST(XED_ICLASS_DPPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_DPPD_XMMdq_XMMdq_IMMb,1236,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2D),
/*1460*/ XED_DEF_INST(XED_ICLASS_REP_MOVSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_MOVSW,1934,6,39,0,71,XED_EXCEPTION_INVALID),
/*1461*/ XED_DEF_INST(XED_ICLASS_REP_MOVSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REP_MOVSW,1934,6,39,0,71,XED_EXCEPTION_INVALID),
/*1462*/ XED_DEF_INST(XED_ICLASS_POPAD,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POPAD,1940,10,0,0,3,XED_EXCEPTION_INVALID),
/*1463*/ XED_DEF_INST(XED_ICLASS_FSIN,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSIN,140,2,58,0,6,XED_EXCEPTION_INVALID),
/*1464*/ XED_DEF_INST(XED_ICLASS_IN,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_IN_AL_IMMb,1950,3,36,0,58,XED_EXCEPTION_INVALID),
/*1465*/ XED_DEF_INST(XED_ICLASS_IN,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_IN_OeAX_IMMb,1953,3,36,0,7,XED_EXCEPTION_INVALID),
/*1466*/ XED_DEF_INST(XED_ICLASS_IN,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_IN_AL_DX,1956,3,36,0,37,XED_EXCEPTION_INVALID),
/*1467*/ XED_DEF_INST(XED_ICLASS_IN,XED_CATEGORY_IO,XED_EXTENSION_BASE,3,XED_IFORM_IN_OeAX_DX,1959,3,36,0,39,XED_EXCEPTION_INVALID),
/*1468*/ XED_DEF_INST(XED_ICLASS_FCMOVE,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVE_ST0_X87,474,4,26,0,6,XED_EXCEPTION_INVALID),
/*1469*/ XED_DEF_INST(XED_ICLASS_FLDCW,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDCW_MEMmem16,1962,3,55,0,76,XED_EXCEPTION_INVALID),
/*1470*/ XED_DEF_INST(XED_ICLASS_DPPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_DPPS_XMMdq_MEMdq_IMMb,1965,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2D),
/*1471*/ XED_DEF_INST(XED_ICLASS_DPPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_DPPS_XMMdq_XMMdq_IMMb,1968,3,0,0,32,XED_EXCEPTION_SSE_TYPE_2D),
/*1472*/ XED_DEF_INST(XED_ICLASS_FCMOVB,XED_CATEGORY_FCMOV,XED_EXTENSION_X87,3,XED_IFORM_FCMOVB_ST0_X87,474,4,25,0,6,XED_EXCEPTION_INVALID),
/*1473*/ XED_DEF_INST(XED_ICLASS_LFENCE,XED_CATEGORY_MISC,XED_EXTENSION_SSE2,3,XED_IFORM_LFENCE,0,0,0,0,84,XED_EXCEPTION_INVALID),
/*1474*/ XED_DEF_INST(XED_ICLASS_CVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSD2SI_GPR32d_MEMsd,1324,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1475*/ XED_DEF_INST(XED_ICLASS_CVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSD2SI_GPR32d_XMMsd,1326,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1476*/ XED_DEF_INST(XED_ICLASS_CVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSD2SI_GPR64q_MEMsd,1328,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1477*/ XED_DEF_INST(XED_ICLASS_CVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTSD2SI_GPR64q_XMMsd,1330,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1478*/ XED_DEF_INST(XED_ICLASS_CMOVNZ,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNZ_GPRv_MEMv,334,3,56,0,39,XED_EXCEPTION_INVALID),
/*1479*/ XED_DEF_INST(XED_ICLASS_CMOVNZ,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNZ_GPRv_GPRv,337,3,56,0,39,XED_EXCEPTION_INVALID),
/*1480*/ XED_DEF_INST(XED_ICLASS_FMULP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FMULP_X87_ST0,572,4,4,0,6,XED_EXCEPTION_INVALID),
/*1481*/ XED_DEF_INST(XED_ICLASS_CMOVNS,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNS_GPRv_MEMv,334,3,59,0,39,XED_EXCEPTION_INVALID),
/*1482*/ XED_DEF_INST(XED_ICLASS_CMOVNS,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNS_GPRv_GPRv,337,3,59,0,39,XED_EXCEPTION_INVALID),
/*1483*/ XED_DEF_INST(XED_ICLASS_FSQRT,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSQRT,140,2,4,0,6,XED_EXCEPTION_INVALID),
/*1484*/ XED_DEF_INST(XED_ICLASS_CMOVNO,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNO_GPRv_MEMv,334,3,63,0,39,XED_EXCEPTION_INVALID),
/*1485*/ XED_DEF_INST(XED_ICLASS_CMOVNO,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNO_GPRv_GPRv,337,3,63,0,39,XED_EXCEPTION_INVALID),
/*1486*/ XED_DEF_INST(XED_ICLASS_CMOVNL,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNL_GPRv_MEMv,334,3,10,0,39,XED_EXCEPTION_INVALID),
/*1487*/ XED_DEF_INST(XED_ICLASS_CMOVNL,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNL_GPRv_GPRv,337,3,10,0,39,XED_EXCEPTION_INVALID),
/*1488*/ XED_DEF_INST(XED_ICLASS_CVTPS2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTPS2PI_MMXq_MEMq,1781,2,0,0,45,XED_EXCEPTION_MMX_FP),
/*1489*/ XED_DEF_INST(XED_ICLASS_CVTPS2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTPS2PI_MMXq_XMMq,1783,2,0,0,45,XED_EXCEPTION_MMX_FP),
/*1490*/ XED_DEF_INST(XED_ICLASS_PREFETCHW,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCHW_0F0Dr1,193,1,0,0,24,XED_EXCEPTION_INVALID),
/*1491*/ XED_DEF_INST(XED_ICLASS_PREFETCHW,XED_CATEGORY_PREFETCH,XED_EXTENSION_3DNOW,3,XED_IFORM_PREFETCHW_0F0Dr3,193,1,0,0,24,XED_EXCEPTION_INVALID),
/*1492*/ XED_DEF_INST(XED_ICLASS_CVTPS2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPS2PD_XMMpd_MEMq,1971,2,0,0,26,XED_EXCEPTION_SSE_TYPE_3),
/*1493*/ XED_DEF_INST(XED_ICLASS_CVTPS2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPS2PD_XMMpd_XMMq,1973,2,0,0,26,XED_EXCEPTION_SSE_TYPE_3),
/*1494*/ XED_DEF_INST(XED_ICLASS_CMOVNB,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNB_GPRv_MEMv,334,3,65,0,39,XED_EXCEPTION_INVALID),
/*1495*/ XED_DEF_INST(XED_ICLASS_CMOVNB,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNB_GPRv_GPRv,337,3,65,0,39,XED_EXCEPTION_INVALID),
/*1496*/ XED_DEF_INST(XED_ICLASS_PMULHRW,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PMULHRW_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1497*/ XED_DEF_INST(XED_ICLASS_PMULHRW,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PMULHRW_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1498*/ XED_DEF_INST(XED_ICLASS_MOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVAPS_XMMps_MEMps,995,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1499*/ XED_DEF_INST(XED_ICLASS_MOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVAPS_XMMps_XMMps_0F28,997,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1500*/ XED_DEF_INST(XED_ICLASS_MOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVAPS_MEMps_XMMps,1975,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1501*/ XED_DEF_INST(XED_ICLASS_MOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVAPS_XMMps_XMMps_0F29,1977,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1502*/ XED_DEF_INST(XED_ICLASS_PFMIN,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFMIN_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1503*/ XED_DEF_INST(XED_ICLASS_PFMIN,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFMIN_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1504*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_XMMdq_MEMd,1979,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1505*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_XMMdq_GPR32,1981,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1506*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_XMMdq_MEMd,1979,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1507*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_XMMdq_GPR32,1981,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1508*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_MEMd_XMMd,1834,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1509*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_GPR32_XMMd,1983,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1510*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_MEMd_XMMd,1834,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1511*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVD_GPR32_XMMd,1983,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1512*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_MMXq_MEMd,1985,2,0,0,6,XED_EXCEPTION_INVALID),
/*1513*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_MMXq_GPR32,1987,2,0,0,6,XED_EXCEPTION_INVALID),
/*1514*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_MMXq_MEMd,1985,2,0,0,6,XED_EXCEPTION_INVALID),
/*1515*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_MMXq_GPR32,1987,2,0,0,6,XED_EXCEPTION_INVALID),
/*1516*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_MEMd_MMXd,1989,2,0,0,6,XED_EXCEPTION_INVALID),
/*1517*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_GPR32_MMXd,1991,2,0,0,6,XED_EXCEPTION_INVALID),
/*1518*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_MEMd_MMXd,1989,2,0,0,6,XED_EXCEPTION_INVALID),
/*1519*/ XED_DEF_INST(XED_ICLASS_MOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MOVD_GPR32_MMXd,1991,2,0,0,6,XED_EXCEPTION_INVALID),
/*1520*/ XED_DEF_INST(XED_ICLASS_CMOVO,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVO_GPRv_MEMv,334,3,63,0,39,XED_EXCEPTION_INVALID),
/*1521*/ XED_DEF_INST(XED_ICLASS_CMOVO,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVO_GPRv_GPRv,337,3,63,0,39,XED_EXCEPTION_INVALID),
/*1522*/ XED_DEF_INST(XED_ICLASS_MULPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MULPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1523*/ XED_DEF_INST(XED_ICLASS_MULPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MULPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1524*/ XED_DEF_INST(XED_ICLASS_BT,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BT_MEMv_IMMb,1993,3,60,0,39,XED_EXCEPTION_INVALID),
/*1525*/ XED_DEF_INST(XED_ICLASS_BT,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BT_GPRv_IMMb,1996,3,60,0,39,XED_EXCEPTION_INVALID),
/*1526*/ XED_DEF_INST(XED_ICLASS_BT,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BT_MEMv_GPRv,364,3,60,0,39,XED_EXCEPTION_INVALID),
/*1527*/ XED_DEF_INST(XED_ICLASS_BT,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BT_GPRv_GPRv,367,3,60,0,39,XED_EXCEPTION_INVALID),
/*1528*/ XED_DEF_INST(XED_ICLASS_MOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVAPD_XMMpd_MEMpd,1608,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1529*/ XED_DEF_INST(XED_ICLASS_MOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVAPD_XMMpd_XMMpd_0F28,1610,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1530*/ XED_DEF_INST(XED_ICLASS_MOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVAPD_MEMpd_XMMpd,1999,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1531*/ XED_DEF_INST(XED_ICLASS_MOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVAPD_XMMpd_XMMpd_0F29,2001,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1532*/ XED_DEF_INST(XED_ICLASS_XRSTORS,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVES,0,XED_IFORM_XRSTORS_MEMmxsave,90,4,0,0,10,XED_EXCEPTION_INVALID),
/*1533*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_MEMv,2003,4,0,0,98,XED_EXCEPTION_INVALID),
/*1534*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_GPRv_8F,2007,4,0,0,3,XED_EXCEPTION_INVALID),
/*1535*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_ES,2011,4,0,0,75,XED_EXCEPTION_INVALID),
/*1536*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_SS,2015,4,0,0,75,XED_EXCEPTION_INVALID),
/*1537*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_DS,2019,4,0,0,75,XED_EXCEPTION_INVALID),
/*1538*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_GPRv_58,2023,4,0,0,3,XED_EXCEPTION_INVALID),
/*1539*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_FS,2027,4,0,0,75,XED_EXCEPTION_INVALID),
/*1540*/ XED_DEF_INST(XED_ICLASS_POP,XED_CATEGORY_POP,XED_EXTENSION_BASE,3,XED_IFORM_POP_GS,2031,4,0,0,75,XED_EXCEPTION_INVALID),
/*1541*/ XED_DEF_INST(XED_ICLASS_JRCXZ,XED_CATEGORY_COND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JRCXZ_RELBRb,2035,3,0,0,0,XED_EXCEPTION_INVALID),
/*1542*/ XED_DEF_INST(XED_ICLASS_MULPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MULPD_XMMpd_MEMpd,304,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1543*/ XED_DEF_INST(XED_ICLASS_MULPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MULPD_XMMpd_XMMpd,306,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1544*/ XED_DEF_INST(XED_ICLASS_SHLD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHLD_MEMv_GPRv_IMMb,1025,4,27,1,39,XED_EXCEPTION_INVALID),
/*1545*/ XED_DEF_INST(XED_ICLASS_SHLD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHLD_GPRv_GPRv_IMMb,1029,4,28,1,39,XED_EXCEPTION_INVALID),
/*1546*/ XED_DEF_INST(XED_ICLASS_SHLD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHLD_MEMv_GPRv_CL,1033,4,46,0,39,XED_EXCEPTION_INVALID),
/*1547*/ XED_DEF_INST(XED_ICLASS_SHLD,XED_CATEGORY_SHIFT,XED_EXTENSION_BASE,3,XED_IFORM_SHLD_GPRv_GPRv_CL,1037,4,46,0,39,XED_EXCEPTION_INVALID),
/*1548*/ XED_DEF_INST(XED_ICLASS_INVLPG,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_INVLPG_MEMb,1024,1,0,0,99,XED_EXCEPTION_INVALID),
/*1549*/ XED_DEF_INST(XED_ICLASS_MOVDQ2Q,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQ2Q_MMXq_XMMq,2038,2,0,0,74,XED_EXCEPTION_INVALID),
/*1550*/ XED_DEF_INST(XED_ICLASS_PABSD,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSD_MMXq_MEMq,1260,2,0,0,100,XED_EXCEPTION_MMX_MEM),
/*1551*/ XED_DEF_INST(XED_ICLASS_PABSD,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSD_MMXq_MMXq,1262,2,0,0,100,XED_EXCEPTION_INVALID),
/*1552*/ XED_DEF_INST(XED_ICLASS_PABSD,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSD_XMMdq_MEMdq,470,2,0,0,101,XED_EXCEPTION_SSE_TYPE_4),
/*1553*/ XED_DEF_INST(XED_ICLASS_PABSD,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSD_XMMdq_XMMdq,472,2,0,0,35,XED_EXCEPTION_SSE_TYPE_4),
/*1554*/ XED_DEF_INST(XED_ICLASS_SAHF,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_SAHF,2040,2,78,0,0,XED_EXCEPTION_INVALID),
/*1555*/ XED_DEF_INST(XED_ICLASS_CLFLUSH,XED_CATEGORY_MISC,XED_EXTENSION_CLFSH,3,XED_IFORM_CLFLUSH_MEMmprefetch,193,1,0,0,6,XED_EXCEPTION_INVALID),
/*1556*/ XED_DEF_INST(XED_ICLASS_PABSB,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSB_MMXq_MEMq,1260,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1557*/ XED_DEF_INST(XED_ICLASS_PABSB,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSB_MMXq_MMXq,1262,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1558*/ XED_DEF_INST(XED_ICLASS_PABSB,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSB_XMMdq_MEMdq,470,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1559*/ XED_DEF_INST(XED_ICLASS_PABSB,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PABSB_XMMdq_XMMdq,472,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1560*/ XED_DEF_INST(XED_ICLASS_MOVMSKPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVMSKPD_GPR32_XMMpd,2042,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1561*/ XED_DEF_INST(XED_ICLASS_FDIVP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIVP_X87_ST0,572,4,4,0,6,XED_EXCEPTION_INVALID),
/*1562*/ XED_DEF_INST(XED_ICLASS_PSUBQ,XED_CATEGORY_MMX,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBQ_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1563*/ XED_DEF_INST(XED_ICLASS_PSUBQ,XED_CATEGORY_MMX,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBQ_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1564*/ XED_DEF_INST(XED_ICLASS_PSUBQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1565*/ XED_DEF_INST(XED_ICLASS_PSUBQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1566*/ XED_DEF_INST(XED_ICLASS_FDIVR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIVR_ST0_MEMmem32real,269,3,4,0,6,XED_EXCEPTION_INVALID),
/*1567*/ XED_DEF_INST(XED_ICLASS_FDIVR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIVR_ST0_X87,272,3,4,0,6,XED_EXCEPTION_INVALID),
/*1568*/ XED_DEF_INST(XED_ICLASS_FDIVR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIVR_ST0_MEMm64real,275,3,4,0,6,XED_EXCEPTION_INVALID),
/*1569*/ XED_DEF_INST(XED_ICLASS_FDIVR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIVR_X87_ST0,278,3,4,0,6,XED_EXCEPTION_INVALID),
/*1570*/ XED_DEF_INST(XED_ICLASS_FDIV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIV_ST0_MEMmem32real,269,3,4,0,6,XED_EXCEPTION_INVALID),
/*1571*/ XED_DEF_INST(XED_ICLASS_FDIV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIV_ST0_X87,272,3,4,0,6,XED_EXCEPTION_INVALID),
/*1572*/ XED_DEF_INST(XED_ICLASS_FDIV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIV_ST0_MEMm64real,275,3,4,0,6,XED_EXCEPTION_INVALID),
/*1573*/ XED_DEF_INST(XED_ICLASS_FDIV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDIV_X87_ST0,278,3,4,0,6,XED_EXCEPTION_INVALID),
/*1574*/ XED_DEF_INST(XED_ICLASS_PI2FW,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PI2FW_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1575*/ XED_DEF_INST(XED_ICLASS_PI2FW,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PI2FW_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1576*/ XED_DEF_INST(XED_ICLASS_EMMS,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_EMMS,0,0,0,0,102,XED_EXCEPTION_INVALID),
/*1577*/ XED_DEF_INST(XED_ICLASS_CVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSS2SI_GPR32d_MEMss,739,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1578*/ XED_DEF_INST(XED_ICLASS_CVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSS2SI_GPR32d_XMMss,741,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1579*/ XED_DEF_INST(XED_ICLASS_CVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSS2SI_GPR64q_MEMss,743,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1580*/ XED_DEF_INST(XED_ICLASS_CVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE,3,XED_IFORM_CVTSS2SI_GPR64q_XMMss,745,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1581*/ XED_DEF_INST(XED_ICLASS_MOVHPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVHPD_XMMsd_MEMq,1454,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1582*/ XED_DEF_INST(XED_ICLASS_MOVHPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVHPD_MEMq_XMMsd,1779,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1583*/ XED_DEF_INST(XED_ICLASS_CMOVZ,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVZ_GPRv_MEMv,334,3,56,0,39,XED_EXCEPTION_INVALID),
/*1584*/ XED_DEF_INST(XED_ICLASS_CMOVZ,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVZ_GPRv_GPRv,337,3,56,0,39,XED_EXCEPTION_INVALID),
/*1585*/ XED_DEF_INST(XED_ICLASS_CQO,XED_CATEGORY_CONVERT,XED_EXTENSION_LONGMODE,3,XED_IFORM_CQO,2044,2,0,0,0,XED_EXCEPTION_INVALID),
/*1586*/ XED_DEF_INST(XED_ICLASS_CMOVP,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVP_GPRv_MEMv,334,3,33,0,39,XED_EXCEPTION_INVALID),
/*1587*/ XED_DEF_INST(XED_ICLASS_CMOVP,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVP_GPRv_GPRv,337,3,33,0,39,XED_EXCEPTION_INVALID),
/*1588*/ XED_DEF_INST(XED_ICLASS_CMOVS,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVS_GPRv_MEMv,334,3,59,0,39,XED_EXCEPTION_INVALID),
/*1589*/ XED_DEF_INST(XED_ICLASS_CMOVS,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVS_GPRv_GPRv,337,3,59,0,39,XED_EXCEPTION_INVALID),
/*1590*/ XED_DEF_INST(XED_ICLASS_STGI,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_STGI,0,0,0,0,48,XED_EXCEPTION_INVALID),
/*1591*/ XED_DEF_INST(XED_ICLASS_RDPID,XED_CATEGORY_RDPID,XED_EXTENSION_RDPID,3,XED_IFORM_RDPID_GPR32u32,2046,2,0,0,0,XED_EXCEPTION_INVALID),
/*1592*/ XED_DEF_INST(XED_ICLASS_RDPID,XED_CATEGORY_RDPID,XED_EXTENSION_RDPID,3,XED_IFORM_RDPID_GPR64u64,2048,2,0,0,0,XED_EXCEPTION_INVALID),
/*1593*/ XED_DEF_INST(XED_ICLASS_CMOVL,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVL_GPRv_MEMv,334,3,10,0,39,XED_EXCEPTION_INVALID),
/*1594*/ XED_DEF_INST(XED_ICLASS_CMOVL,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVL_GPRv_GPRv,337,3,10,0,39,XED_EXCEPTION_INVALID),
/*1595*/ XED_DEF_INST(XED_ICLASS_MOVHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVHPS_XMMq_MEMq,1312,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1596*/ XED_DEF_INST(XED_ICLASS_MOVHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVHPS_MEMq_XMMps,1314,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1597*/ XED_DEF_INST(XED_ICLASS_CMOVB,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVB_GPRv_MEMv,334,3,65,0,39,XED_EXCEPTION_INVALID),
/*1598*/ XED_DEF_INST(XED_ICLASS_CMOVB,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVB_GPRv_GPRv,337,3,65,0,39,XED_EXCEPTION_INVALID),
/*1599*/ XED_DEF_INST(XED_ICLASS_PUNPCKHBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKHBW_MMXq_MEMq,84,2,0,0,18,XED_EXCEPTION_MMX_MEM),
/*1600*/ XED_DEF_INST(XED_ICLASS_PUNPCKHBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKHBW_MMXq_MMXd,146,2,0,0,18,XED_EXCEPTION_MMX_MEM),
/*1601*/ XED_DEF_INST(XED_ICLASS_PUNPCKHBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHBW_XMMdq_MEMdq,148,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*1602*/ XED_DEF_INST(XED_ICLASS_PUNPCKHBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHBW_XMMdq_XMMq,150,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*1603*/ XED_DEF_INST(XED_ICLASS_PHADDW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1604*/ XED_DEF_INST(XED_ICLASS_PHADDW,XED_CATEGORY_MMX,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1605*/ XED_DEF_INST(XED_ICLASS_PHADDW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1606*/ XED_DEF_INST(XED_ICLASS_PHADDW,XED_CATEGORY_SSE,XED_EXTENSION_SSSE3,3,XED_IFORM_PHADDW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1607*/ XED_DEF_INST(XED_ICLASS_PCMPISTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPISTRI_XMMdq_MEMdq_IMMb,2050,5,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1608*/ XED_DEF_INST(XED_ICLASS_PCMPISTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPISTRI_XMMdq_XMMdq_IMMb,2055,5,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1609*/ XED_DEF_INST(XED_ICLASS_PCMPISTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPISTRI_XMMdq_MEMdq_IMMb,2060,5,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1610*/ XED_DEF_INST(XED_ICLASS_PCMPISTRI,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PCMPISTRI_XMMdq_XMMdq_IMMb,2065,5,29,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1611*/ XED_DEF_INST(XED_ICLASS_MOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVUPD_XMMpd_MEMpd,1608,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1612*/ XED_DEF_INST(XED_ICLASS_MOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVUPD_XMMpd_XMMpd_0F10,1610,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1613*/ XED_DEF_INST(XED_ICLASS_MOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVUPD_MEMpd_XMMpd,1999,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1614*/ XED_DEF_INST(XED_ICLASS_MOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVUPD_XMMpd_XMMpd_0F11,2001,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1615*/ XED_DEF_INST(XED_ICLASS_XBEGIN,XED_CATEGORY_COND_BR,XED_EXTENSION_RTM,3,XED_IFORM_XBEGIN_RELBRz,2070,3,0,0,39,XED_EXCEPTION_INVALID),
/*1616*/ XED_DEF_INST(XED_ICLASS_LMSW,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LMSW_MEMw,2073,2,0,0,15,XED_EXCEPTION_INVALID),
/*1617*/ XED_DEF_INST(XED_ICLASS_LMSW,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_LMSW_GPR16,2075,2,0,0,15,XED_EXCEPTION_INVALID),
/*1618*/ XED_DEF_INST(XED_ICLASS_INVEPT,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_INVEPT_GPR64_MEMdq,388,3,20,0,15,XED_EXCEPTION_INVALID),
/*1619*/ XED_DEF_INST(XED_ICLASS_INVEPT,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_INVEPT_GPR32_MEMdq,391,3,20,0,15,XED_EXCEPTION_INVALID),
/*1620*/ XED_DEF_INST(XED_ICLASS_REPE_CMPSQ,XED_CATEGORY_STRINGOP,XED_EXTENSION_LONGMODE,3,XED_IFORM_REPE_CMPSQ,955,6,7,0,71,XED_EXCEPTION_INVALID),
/*1621*/ XED_DEF_INST(XED_ICLASS_ANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_ANDPS_XMMxud_MEMxud,614,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1622*/ XED_DEF_INST(XED_ICLASS_ANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_SSE,3,XED_IFORM_ANDPS_XMMxud_XMMxud,616,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1623*/ XED_DEF_INST(XED_ICLASS_MOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVUPS_XMMps_MEMps,995,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1624*/ XED_DEF_INST(XED_ICLASS_MOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVUPS_XMMps_XMMps_0F10,997,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1625*/ XED_DEF_INST(XED_ICLASS_MOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVUPS_MEMps_XMMps,1975,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1626*/ XED_DEF_INST(XED_ICLASS_MOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVUPS_XMMps_XMMps_0F11,1977,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4M),
/*1627*/ XED_DEF_INST(XED_ICLASS_BTS_LOCK,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTS_LOCK_MEMv_IMMb,812,3,60,0,54,XED_EXCEPTION_INVALID),
/*1628*/ XED_DEF_INST(XED_ICLASS_BTS_LOCK,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTS_LOCK_MEMv_GPRv,788,3,60,0,54,XED_EXCEPTION_INVALID),
/*1629*/ XED_DEF_INST(XED_ICLASS_REPE_CMPSD,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPE_CMPSD,989,6,7,0,71,XED_EXCEPTION_INVALID),
/*1630*/ XED_DEF_INST(XED_ICLASS_PEXTRD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRD_MEMd_XMMdq_IMMb,2077,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1631*/ XED_DEF_INST(XED_ICLASS_PEXTRD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRD_GPR32d_XMMdq_IMMb,1124,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1632*/ XED_DEF_INST(XED_ICLASS_XOR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_LOCK_MEMb_IMMb_80r6,764,3,43,0,53,XED_EXCEPTION_INVALID),
/*1633*/ XED_DEF_INST(XED_ICLASS_XOR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_LOCK_MEMv_IMMz,770,3,43,0,54,XED_EXCEPTION_INVALID),
/*1634*/ XED_DEF_INST(XED_ICLASS_XOR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_LOCK_MEMb_IMMb_82r6,764,3,43,0,53,XED_EXCEPTION_INVALID),
/*1635*/ XED_DEF_INST(XED_ICLASS_XOR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_LOCK_MEMv_IMMb,776,3,43,0,54,XED_EXCEPTION_INVALID),
/*1636*/ XED_DEF_INST(XED_ICLASS_XOR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_LOCK_MEMb_GPR8,782,3,43,0,53,XED_EXCEPTION_INVALID),
/*1637*/ XED_DEF_INST(XED_ICLASS_XOR_LOCK,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_XOR_LOCK_MEMv_GPRv,788,3,43,0,54,XED_EXCEPTION_INVALID),
/*1638*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_MEMb_IMMb_80r1,1284,3,43,0,36,XED_EXCEPTION_INVALID),
/*1639*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPR8_IMMb_80r1,2080,3,43,0,37,XED_EXCEPTION_INVALID),
/*1640*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_MEMv_IMMz,770,3,43,0,38,XED_EXCEPTION_INVALID),
/*1641*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPRv_IMMz,773,3,43,0,39,XED_EXCEPTION_INVALID),
/*1642*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_MEMb_IMMb_82r1,1284,3,43,0,36,XED_EXCEPTION_INVALID),
/*1643*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPR8_IMMb_82r1,2080,3,43,0,37,XED_EXCEPTION_INVALID),
/*1644*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_MEMv_IMMb,776,3,43,0,38,XED_EXCEPTION_INVALID),
/*1645*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPRv_IMMb,779,3,43,0,39,XED_EXCEPTION_INVALID),
/*1646*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_MEMb_GPR8,782,3,43,0,36,XED_EXCEPTION_INVALID),
/*1647*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPR8_GPR8_08,785,3,43,0,37,XED_EXCEPTION_INVALID),
/*1648*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_MEMv_GPRv,788,3,43,0,38,XED_EXCEPTION_INVALID),
/*1649*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPRv_GPRv_09,791,3,43,0,39,XED_EXCEPTION_INVALID),
/*1650*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPR8_MEMb,797,3,43,0,37,XED_EXCEPTION_INVALID),
/*1651*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPR8_GPR8_0A,794,3,43,0,37,XED_EXCEPTION_INVALID),
/*1652*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPRv_MEMv,803,3,43,0,39,XED_EXCEPTION_INVALID),
/*1653*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_GPRv_GPRv_0B,800,3,43,0,39,XED_EXCEPTION_INVALID),
/*1654*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_AL_IMMb,806,3,43,0,37,XED_EXCEPTION_INVALID),
/*1655*/ XED_DEF_INST(XED_ICLASS_OR,XED_CATEGORY_LOGICAL,XED_EXTENSION_BASE,3,XED_IFORM_OR_OrAX_IMMz,809,3,43,0,39,XED_EXCEPTION_INVALID),
/*1656*/ XED_DEF_INST(XED_ICLASS_REPE_CMPSB,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPE_CMPSB,983,6,7,0,72,XED_EXCEPTION_INVALID),
/*1657*/ XED_DEF_INST(XED_ICLASS_FXRSTOR,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_FXRSTOR_MEMmfpxenv,1574,2,0,0,86,XED_EXCEPTION_INVALID),
/*1658*/ XED_DEF_INST(XED_ICLASS_REPE_CMPSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPE_CMPSW,2083,6,7,0,71,XED_EXCEPTION_INVALID),
/*1659*/ XED_DEF_INST(XED_ICLASS_CLTS,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_CLTS,0,0,0,0,15,XED_EXCEPTION_INVALID),
/*1660*/ XED_DEF_INST(XED_ICLASS_FRSTOR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FRSTOR_MEMmem94,2089,2,3,0,103,XED_EXCEPTION_INVALID),
/*1661*/ XED_DEF_INST(XED_ICLASS_FRSTOR,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FRSTOR_MEMmem108,2091,2,3,0,103,XED_EXCEPTION_INVALID),
/*1662*/ XED_DEF_INST(XED_ICLASS_MOVZX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVZX_GPRv_MEMb,1072,2,0,0,39,XED_EXCEPTION_INVALID),
/*1663*/ XED_DEF_INST(XED_ICLASS_MOVZX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVZX_GPRv_GPR8,1074,2,0,0,39,XED_EXCEPTION_INVALID),
/*1664*/ XED_DEF_INST(XED_ICLASS_MOVZX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVZX_GPRv_MEMw,1076,2,0,0,39,XED_EXCEPTION_INVALID),
/*1665*/ XED_DEF_INST(XED_ICLASS_MOVZX,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_MOVZX_GPRv_GPR16,1078,2,0,0,39,XED_EXCEPTION_INVALID),
/*1666*/ XED_DEF_INST(XED_ICLASS_FLDLN2,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDLN2,266,3,4,0,6,XED_EXCEPTION_INVALID),
/*1667*/ XED_DEF_INST(XED_ICLASS_UD2,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_UD2,0,0,0,0,6,XED_EXCEPTION_INVALID),
/*1668*/ XED_DEF_INST(XED_ICLASS_TPAUSE,XED_CATEGORY_WAITPKG,XED_EXTENSION_WAITPKG,3,XED_IFORM_TPAUSE_GPR32u32,715,4,40,0,0,XED_EXCEPTION_INVALID),
/*1669*/ XED_DEF_INST(XED_ICLASS_TPAUSE,XED_CATEGORY_WAITPKG,XED_EXTENSION_WAITPKG,3,XED_IFORM_TPAUSE_GPR64u64,719,4,40,0,0,XED_EXCEPTION_INVALID),
/*1670*/ XED_DEF_INST(XED_ICLASS_REPNE_CMPSW,XED_CATEGORY_STRINGOP,XED_EXTENSION_BASE,3,XED_IFORM_REPNE_CMPSW,2083,6,7,0,71,XED_EXCEPTION_INVALID),
/*1671*/ XED_DEF_INST(XED_ICLASS_PMULUDQ,XED_CATEGORY_MMX,XED_EXTENSION_SSE2,3,XED_IFORM_PMULUDQ_MMXq_MEMq,2093,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1672*/ XED_DEF_INST(XED_ICLASS_PMULUDQ,XED_CATEGORY_MMX,XED_EXTENSION_SSE2,3,XED_IFORM_PMULUDQ_MMXq_MMXq,2095,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1673*/ XED_DEF_INST(XED_ICLASS_PMULUDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULUDQ_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1674*/ XED_DEF_INST(XED_ICLASS_PMULUDQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMULUDQ_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1675*/ XED_DEF_INST(XED_ICLASS_FXCH,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FXCH_ST0_X87,2097,3,4,0,6,XED_EXCEPTION_INVALID),
/*1676*/ XED_DEF_INST(XED_ICLASS_FXCH,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FXCH_ST0_X87_DFC1,2097,3,4,0,6,XED_EXCEPTION_INVALID),
/*1677*/ XED_DEF_INST(XED_ICLASS_FXCH,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FXCH_ST0_X87_DDC1,2097,3,4,0,6,XED_EXCEPTION_INVALID),
/*1678*/ XED_DEF_INST(XED_ICLASS_PMADDWD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMADDWD_MMXq_MEMq,417,2,0,0,67,XED_EXCEPTION_MMX_MEM),
/*1679*/ XED_DEF_INST(XED_ICLASS_PMADDWD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMADDWD_MMXq_MMXq,419,2,0,0,67,XED_EXCEPTION_MMX_MEM),
/*1680*/ XED_DEF_INST(XED_ICLASS_PMADDWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMADDWD_XMMdq_MEMdq,421,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1681*/ XED_DEF_INST(XED_ICLASS_PMADDWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMADDWD_XMMdq_XMMdq,423,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1682*/ XED_DEF_INST(XED_ICLASS_FLD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLD_ST0_MEMmem32real,2100,4,4,0,6,XED_EXCEPTION_INVALID),
/*1683*/ XED_DEF_INST(XED_ICLASS_FLD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLD_ST0_X87,2104,4,4,0,6,XED_EXCEPTION_INVALID),
/*1684*/ XED_DEF_INST(XED_ICLASS_FLD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLD_ST0_MEMmem80real,2108,4,4,0,6,XED_EXCEPTION_INVALID),
/*1685*/ XED_DEF_INST(XED_ICLASS_FLD,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLD_ST0_MEMm64real,2112,4,4,0,6,XED_EXCEPTION_INVALID),
/*1686*/ XED_DEF_INST(XED_ICLASS_PMAXUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXUW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1687*/ XED_DEF_INST(XED_ICLASS_PMAXUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXUW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1688*/ XED_DEF_INST(XED_ICLASS_PEXTRW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PEXTRW_GPR32_MMXq_IMMb,2116,3,0,0,6,XED_EXCEPTION_MMX_NOMEM),
/*1689*/ XED_DEF_INST(XED_ICLASS_PEXTRW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PEXTRW_GPR32_XMMdq_IMMb,2119,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1690*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_MEMb_IMMb,764,3,29,1,37,XED_EXCEPTION_INVALID),
/*1691*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_GPR8_IMMb,767,3,30,1,37,XED_EXCEPTION_INVALID),
/*1692*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_MEMv_IMMb,812,3,31,1,39,XED_EXCEPTION_INVALID),
/*1693*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_GPRv_IMMb,815,3,32,1,39,XED_EXCEPTION_INVALID),
/*1694*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_MEMb_ONE,818,3,79,0,65,XED_EXCEPTION_INVALID),
/*1695*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_GPR8_ONE,821,3,79,0,65,XED_EXCEPTION_INVALID),
/*1696*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_MEMv_ONE,824,3,79,0,66,XED_EXCEPTION_INVALID),
/*1697*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_GPRv_ONE,827,3,79,0,66,XED_EXCEPTION_INVALID),
/*1698*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_MEMb_CL,830,3,81,0,37,XED_EXCEPTION_INVALID),
/*1699*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_GPR8_CL,833,3,81,0,37,XED_EXCEPTION_INVALID),
/*1700*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_MEMv_CL,836,3,81,0,39,XED_EXCEPTION_INVALID),
/*1701*/ XED_DEF_INST(XED_ICLASS_ROL,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROL_GPRv_CL,839,3,81,0,39,XED_EXCEPTION_INVALID),
/*1702*/ XED_DEF_INST(XED_ICLASS_VERW,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_VERW_MEMw,1383,2,16,0,14,XED_EXCEPTION_INVALID),
/*1703*/ XED_DEF_INST(XED_ICLASS_VERW,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,3,XED_IFORM_VERW_GPR16,1385,2,16,0,14,XED_EXCEPTION_INVALID),
/*1704*/ XED_DEF_INST(XED_ICLASS_PAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_PAND_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1705*/ XED_DEF_INST(XED_ICLASS_PAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_MMX,3,XED_IFORM_PAND_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/*1706*/ XED_DEF_INST(XED_ICLASS_PAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_PAND_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1707*/ XED_DEF_INST(XED_ICLASS_PAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_SSE2,3,XED_IFORM_PAND_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1708*/ XED_DEF_INST(XED_ICLASS_FUCOMP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FUCOMP_ST0_X87,2122,4,3,0,6,XED_EXCEPTION_INVALID),
/*1709*/ XED_DEF_INST(XED_ICLASS_JMP,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_MEMv,2126,2,0,0,104,XED_EXCEPTION_INVALID),
/*1710*/ XED_DEF_INST(XED_ICLASS_JMP,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_GPRv,2128,2,0,0,104,XED_EXCEPTION_INVALID),
/*1711*/ XED_DEF_INST(XED_ICLASS_JMP,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_RELBRz,2130,2,0,0,105,XED_EXCEPTION_INVALID),
/*1712*/ XED_DEF_INST(XED_ICLASS_JMP,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_RELBRd,2132,2,0,0,20,XED_EXCEPTION_INVALID),
/*1713*/ XED_DEF_INST(XED_ICLASS_JMP,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_RELBRb,2134,2,0,0,0,XED_EXCEPTION_INVALID),
/*1714*/ XED_DEF_INST(XED_ICLASS_JMP,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_RELBRb,2136,2,0,0,0,XED_EXCEPTION_INVALID),
/*1715*/ XED_DEF_INST(XED_ICLASS_CVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTDQ2PS_XMMps_MEMdq,2138,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1716*/ XED_DEF_INST(XED_ICLASS_CVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTDQ2PS_XMMps_XMMdq,2140,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1717*/ XED_DEF_INST(XED_ICLASS_FUCOMI,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FUCOMI_ST0_X87,232,4,13,0,6,XED_EXCEPTION_INVALID),
/*1718*/ XED_DEF_INST(XED_ICLASS_PMAXUD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXUD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1719*/ XED_DEF_INST(XED_ICLASS_PMAXUD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMAXUD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1720*/ XED_DEF_INST(XED_ICLASS_PMAXUB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMAXUB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1721*/ XED_DEF_INST(XED_ICLASS_PMAXUB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMAXUB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/*1722*/ XED_DEF_INST(XED_ICLASS_PMAXUB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMAXUB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1723*/ XED_DEF_INST(XED_ICLASS_PMAXUB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMAXUB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1724*/ XED_DEF_INST(XED_ICLASS_BLENDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDPS_XMMdq_MEMdq_IMMb,1965,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1725*/ XED_DEF_INST(XED_ICLASS_BLENDPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDPS_XMMdq_XMMdq_IMMb,1968,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1726*/ XED_DEF_INST(XED_ICLASS_PEXTRB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRB_MEMb_XMMdq_IMMb,2142,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1727*/ XED_DEF_INST(XED_ICLASS_PEXTRB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRB_GPR32d_XMMdq_IMMb,1124,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1728*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_MEMb_IMMb,764,3,33,1,37,XED_EXCEPTION_INVALID),
/*1729*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_GPR8_IMMb,767,3,34,1,37,XED_EXCEPTION_INVALID),
/*1730*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_GPRv_IMMb,815,3,35,1,39,XED_EXCEPTION_INVALID),
/*1731*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_MEMv_IMMb,812,3,36,1,39,XED_EXCEPTION_INVALID),
/*1732*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_MEMb_ONE,818,3,79,0,65,XED_EXCEPTION_INVALID),
/*1733*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_GPR8_ONE,821,3,79,0,65,XED_EXCEPTION_INVALID),
/*1734*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_MEMv_ONE,824,3,79,0,66,XED_EXCEPTION_INVALID),
/*1735*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_GPRv_ONE,827,3,79,0,66,XED_EXCEPTION_INVALID),
/*1736*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_MEMb_CL,830,3,81,0,37,XED_EXCEPTION_INVALID),
/*1737*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_GPR8_CL,833,3,81,0,37,XED_EXCEPTION_INVALID),
/*1738*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_MEMv_CL,836,3,81,0,39,XED_EXCEPTION_INVALID),
/*1739*/ XED_DEF_INST(XED_ICLASS_ROR,XED_CATEGORY_ROTATE,XED_EXTENSION_BASE,3,XED_IFORM_ROR_GPRv_CL,839,3,81,0,39,XED_EXCEPTION_INVALID),
/*1740*/ XED_DEF_INST(XED_ICLASS_INVD,XED_CATEGORY_SYSTEM,XED_EXTENSION_BASE,0,XED_IFORM_INVD,0,0,0,0,15,XED_EXCEPTION_INVALID),
/*1741*/ XED_DEF_INST(XED_ICLASS_STMXCSR,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_STMXCSR_MEMd,2145,2,0,0,106,XED_EXCEPTION_SSE_TYPE_5),
/*1742*/ XED_DEF_INST(XED_ICLASS_SETLE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETLE_MEMb,596,2,6,0,37,XED_EXCEPTION_INVALID),
/*1743*/ XED_DEF_INST(XED_ICLASS_SETLE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETLE_GPR8,598,2,6,0,37,XED_EXCEPTION_INVALID),
/*1744*/ XED_DEF_INST(XED_ICLASS_XSAVE64,XED_CATEGORY_XSAVE,XED_EXTENSION_XSAVE,3,XED_IFORM_XSAVE64_MEMmxsave,900,4,0,0,40,XED_EXCEPTION_INVALID),
/*1745*/ XED_DEF_INST(XED_ICLASS_PUNPCKHWD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKHWD_MMXq_MEMq,84,2,0,0,18,XED_EXCEPTION_MMX_MEM),
/*1746*/ XED_DEF_INST(XED_ICLASS_PUNPCKHWD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKHWD_MMXq_MMXd,146,2,0,0,18,XED_EXCEPTION_MMX_MEM),
/*1747*/ XED_DEF_INST(XED_ICLASS_PUNPCKHWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHWD_XMMdq_MEMdq,148,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*1748*/ XED_DEF_INST(XED_ICLASS_PUNPCKHWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKHWD_XMMdq_XMMq,150,2,0,0,4,XED_EXCEPTION_SSE_TYPE_4),
/*1749*/ XED_DEF_INST(XED_ICLASS_CVTPD2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPD2PS_XMMps_MEMpd,2147,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1750*/ XED_DEF_INST(XED_ICLASS_CVTPD2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPD2PS_XMMps_XMMpd,2149,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1751*/ XED_DEF_INST(XED_ICLASS_CVTPD2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPD2PI_MMXq_MEMpd,2151,2,0,0,107,XED_EXCEPTION_MMX_FP_16ALIGN),
/*1752*/ XED_DEF_INST(XED_ICLASS_CVTPD2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTPD2PI_MMXq_XMMpd,2153,2,0,0,107,XED_EXCEPTION_MMX_FP_16ALIGN),
/*1753*/ XED_DEF_INST(XED_ICLASS_GF2P8MULB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_GF2P8MULB_XMMu8_XMMu8,2155,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1754*/ XED_DEF_INST(XED_ICLASS_GF2P8MULB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_GF2P8MULB_XMMu8_MEMu8,2157,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1755*/ XED_DEF_INST(XED_ICLASS_RDRAND,XED_CATEGORY_RDRAND,XED_EXTENSION_RDRAND,3,XED_IFORM_RDRAND_GPRv,1239,2,67,0,39,XED_EXCEPTION_INVALID),
/*1756*/ XED_DEF_INST(XED_ICLASS_FDECSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FDECSTP,1665,1,4,0,76,XED_EXCEPTION_INVALID),
/*1757*/ XED_DEF_INST(XED_ICLASS_MFENCE,XED_CATEGORY_MISC,XED_EXTENSION_SSE2,3,XED_IFORM_MFENCE,0,0,0,0,84,XED_EXCEPTION_INVALID),
/*1758*/ XED_DEF_INST(XED_ICLASS_WRSSQ,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_WRSSQ_MEMu64_GPR64u64,612,2,0,0,0,XED_EXCEPTION_INVALID),
/*1759*/ XED_DEF_INST(XED_ICLASS_BOUND,XED_CATEGORY_INTERRUPT,XED_EXTENSION_BASE,3,XED_IFORM_BOUND_GPRv_MEMa16,2159,2,0,0,108,XED_EXCEPTION_INVALID),
/*1760*/ XED_DEF_INST(XED_ICLASS_BOUND,XED_CATEGORY_INTERRUPT,XED_EXTENSION_BASE,3,XED_IFORM_BOUND_GPRv_MEMa32,2161,2,0,0,108,XED_EXCEPTION_INVALID),
/*1761*/ XED_DEF_INST(XED_ICLASS_PSHUFLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSHUFLW_XMMdq_MEMdq_IMMb,2163,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1762*/ XED_DEF_INST(XED_ICLASS_PSHUFLW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSHUFLW_XMMdq_XMMdq_IMMb,2166,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1763*/ XED_DEF_INST(XED_ICLASS_WRSSD,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_WRSSD_MEMu32_GPR32u32,600,2,0,0,0,XED_EXCEPTION_INVALID),
/*1764*/ XED_DEF_INST(XED_ICLASS_CMOVNBE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNBE_GPRv_MEMv,334,3,41,0,39,XED_EXCEPTION_INVALID),
/*1765*/ XED_DEF_INST(XED_ICLASS_CMOVNBE,XED_CATEGORY_CMOV,XED_EXTENSION_BASE,3,XED_IFORM_CMOVNBE_GPRv_GPRv,337,3,41,0,39,XED_EXCEPTION_INVALID),
/*1766*/ XED_DEF_INST(XED_ICLASS_SYSCALL_AMD,XED_CATEGORY_SYSCALL,XED_EXTENSION_BASE,3,XED_IFORM_SYSCALL_AMD,859,2,51,0,8,XED_EXCEPTION_INVALID),
/*1767*/ XED_DEF_INST(XED_ICLASS_FLDLG2,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDLG2,266,3,4,0,6,XED_EXCEPTION_INVALID),
/*1768*/ XED_DEF_INST(XED_ICLASS_SYSRET,XED_CATEGORY_SYSRET,XED_EXTENSION_LONGMODE,0,XED_IFORM_SYSRET,2169,2,74,0,29,XED_EXCEPTION_INVALID),
/*1769*/ XED_DEF_INST(XED_ICLASS_SYSRET,XED_CATEGORY_SYSRET,XED_EXTENSION_LONGMODE,0,XED_IFORM_SYSRET,1812,2,74,0,29,XED_EXCEPTION_INVALID),
/*1770*/ XED_DEF_INST(XED_ICLASS_WBNOINVD,XED_CATEGORY_SYSTEM,XED_EXTENSION_WBNOINVD,0,XED_IFORM_WBNOINVD,0,0,0,0,15,XED_EXCEPTION_INVALID),
/*1771*/ XED_DEF_INST(XED_ICLASS_SKINIT,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_SKINIT_EAX,2171,1,0,0,48,XED_EXCEPTION_INVALID),
/*1772*/ XED_DEF_INST(XED_ICLASS_FLDZ,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLDZ,266,3,4,0,6,XED_EXCEPTION_INVALID),
/*1773*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_MEMb_IMMb_80r5,1284,3,18,0,36,XED_EXCEPTION_INVALID),
/*1774*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPR8_IMMb_80r5,2080,3,18,0,37,XED_EXCEPTION_INVALID),
/*1775*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_MEMv_IMMz,770,3,18,0,38,XED_EXCEPTION_INVALID),
/*1776*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPRv_IMMz,773,3,18,0,39,XED_EXCEPTION_INVALID),
/*1777*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_MEMb_IMMb_82r5,1284,3,18,0,36,XED_EXCEPTION_INVALID),
/*1778*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPR8_IMMb_82r5,2080,3,18,0,37,XED_EXCEPTION_INVALID),
/*1779*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_MEMv_IMMb,776,3,18,0,38,XED_EXCEPTION_INVALID),
/*1780*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPRv_IMMb,779,3,18,0,39,XED_EXCEPTION_INVALID),
/*1781*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_MEMb_GPR8,782,3,18,0,36,XED_EXCEPTION_INVALID),
/*1782*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPR8_GPR8_28,785,3,18,0,37,XED_EXCEPTION_INVALID),
/*1783*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_MEMv_GPRv,788,3,18,0,38,XED_EXCEPTION_INVALID),
/*1784*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPRv_GPRv_29,791,3,18,0,39,XED_EXCEPTION_INVALID),
/*1785*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPR8_GPR8_2A,794,3,18,0,37,XED_EXCEPTION_INVALID),
/*1786*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPR8_MEMb,797,3,18,0,37,XED_EXCEPTION_INVALID),
/*1787*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPRv_GPRv_2B,800,3,18,0,39,XED_EXCEPTION_INVALID),
/*1788*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_GPRv_MEMv,803,3,18,0,39,XED_EXCEPTION_INVALID),
/*1789*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_AL_IMMb,1688,3,18,0,37,XED_EXCEPTION_INVALID),
/*1790*/ XED_DEF_INST(XED_ICLASS_SUB,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_SUB_OrAX_IMMz,809,3,18,0,39,XED_EXCEPTION_INVALID),
/*1791*/ XED_DEF_INST(XED_ICLASS_NEG,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_NEG_MEMb,509,2,18,0,36,XED_EXCEPTION_INVALID),
/*1792*/ XED_DEF_INST(XED_ICLASS_NEG,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_NEG_GPR8,511,2,18,0,37,XED_EXCEPTION_INVALID),
/*1793*/ XED_DEF_INST(XED_ICLASS_NEG,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_NEG_MEMv,513,2,18,0,38,XED_EXCEPTION_INVALID),
/*1794*/ XED_DEF_INST(XED_ICLASS_NEG,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_NEG_GPRv,515,2,18,0,39,XED_EXCEPTION_INVALID),
/*1795*/ XED_DEF_INST(XED_ICLASS_PMINUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINUW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1796*/ XED_DEF_INST(XED_ICLASS_PMINUW,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINUW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1797*/ XED_DEF_INST(XED_ICLASS_MAXPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MAXPD_XMMpd_MEMpd,304,2,0,0,109,XED_EXCEPTION_SSE_TYPE_2),
/*1798*/ XED_DEF_INST(XED_ICLASS_MAXPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_MAXPD_XMMpd_XMMpd,306,2,0,0,109,XED_EXCEPTION_SSE_TYPE_2),
/*1799*/ XED_DEF_INST(XED_ICLASS_CLAC,XED_CATEGORY_SMAP,XED_EXTENSION_SMAP,0,XED_IFORM_CLAC,759,1,82,0,0,XED_EXCEPTION_INVALID),
/*1800*/ XED_DEF_INST(XED_ICLASS_SETNLE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNLE_MEMb,596,2,6,0,37,XED_EXCEPTION_INVALID),
/*1801*/ XED_DEF_INST(XED_ICLASS_SETNLE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETNLE_GPR8,598,2,6,0,37,XED_EXCEPTION_INVALID),
/*1802*/ XED_DEF_INST(XED_ICLASS_PMINUD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINUD_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1803*/ XED_DEF_INST(XED_ICLASS_PMINUD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMINUD_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1804*/ XED_DEF_INST(XED_ICLASS_MAXPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MAXPS_XMMps_MEMps,281,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1805*/ XED_DEF_INST(XED_ICLASS_MAXPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MAXPS_XMMps_XMMps,283,2,0,0,32,XED_EXCEPTION_SSE_TYPE_2),
/*1806*/ XED_DEF_INST(XED_ICLASS_PMINUB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMINUB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1807*/ XED_DEF_INST(XED_ICLASS_PMINUB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PMINUB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_INVALID),
/*1808*/ XED_DEF_INST(XED_ICLASS_PMINUB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMINUB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1809*/ XED_DEF_INST(XED_ICLASS_PMINUB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PMINUB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1810*/ XED_DEF_INST(XED_ICLASS_FBSTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FBSTP_MEMmem80dec_ST0,2172,4,4,0,6,XED_EXCEPTION_INVALID),
/*1811*/ XED_DEF_INST(XED_ICLASS_PINSRW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PINSRW_MMXq_MEMw_IMMb,2176,3,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1812*/ XED_DEF_INST(XED_ICLASS_PINSRW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PINSRW_MMXq_GPR32_IMMb,2179,3,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1813*/ XED_DEF_INST(XED_ICLASS_PINSRW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PINSRW_XMMdq_MEMw_IMMb,2182,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1814*/ XED_DEF_INST(XED_ICLASS_PINSRW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PINSRW_XMMdq_GPR32_IMMb,2185,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1815*/ XED_DEF_INST(XED_ICLASS_PINSRQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PINSRQ_XMMdq_MEMq_IMMb,2188,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1816*/ XED_DEF_INST(XED_ICLASS_PINSRQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PINSRQ_XMMdq_GPR64q_IMMb,2191,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1817*/ XED_DEF_INST(XED_ICLASS_SALC,XED_CATEGORY_FLAGOP,XED_EXTENSION_BASE,3,XED_IFORM_SALC,2194,2,83,0,0,XED_EXCEPTION_INVALID),
/*1818*/ XED_DEF_INST(XED_ICLASS_FUCOMPP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FUCOMPP,2196,4,3,0,6,XED_EXCEPTION_INVALID),
/*1819*/ XED_DEF_INST(XED_ICLASS_PINSRD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PINSRD_XMMdq_MEMd_IMMb,2200,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1820*/ XED_DEF_INST(XED_ICLASS_PINSRD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PINSRD_XMMdq_GPR32d_IMMb,2203,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1821*/ XED_DEF_INST(XED_ICLASS_MOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQA_MEMdq_XMMdq,1107,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1822*/ XED_DEF_INST(XED_ICLASS_MOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQA_XMMdq_XMMdq_0F7F,1109,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1823*/ XED_DEF_INST(XED_ICLASS_MOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQA_XMMdq_MEMdq,470,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1824*/ XED_DEF_INST(XED_ICLASS_MOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVDQA_XMMdq_XMMdq_0F6F,472,2,0,0,33,XED_EXCEPTION_SSE_TYPE_1),
/*1825*/ XED_DEF_INST(XED_ICLASS_CMPXCHG8B,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG8B_MEMq,2206,6,16,0,110,XED_EXCEPTION_INVALID),
/*1826*/ XED_DEF_INST(XED_ICLASS_CMPXCHG8B,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG8B_MEMq,2206,6,16,0,110,XED_EXCEPTION_INVALID),
/*1827*/ XED_DEF_INST(XED_ICLASS_PINSRB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PINSRB_XMMdq_MEMb_IMMb,2212,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1828*/ XED_DEF_INST(XED_ICLASS_PINSRB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PINSRB_XMMdq_GPR32d_IMMb,2203,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1829*/ XED_DEF_INST(XED_ICLASS_PREFETCHNTA,XED_CATEGORY_PREFETCH,XED_EXTENSION_SSE,3,XED_IFORM_PREFETCHNTA_MEMmprefetch,193,1,0,0,111,XED_EXCEPTION_INVALID),
/*1830*/ XED_DEF_INST(XED_ICLASS_BTR_LOCK,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTR_LOCK_MEMv_IMMb,812,3,60,0,54,XED_EXCEPTION_INVALID),
/*1831*/ XED_DEF_INST(XED_ICLASS_BTR_LOCK,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BTR_LOCK_MEMv_GPRv,788,3,60,0,54,XED_EXCEPTION_INVALID),
/*1832*/ XED_DEF_INST(XED_ICLASS_IRETQ,XED_CATEGORY_RET,XED_EXTENSION_LONGMODE,3,XED_IFORM_IRETQ,2215,5,61,0,75,XED_EXCEPTION_INVALID),
/*1833*/ XED_DEF_INST(XED_ICLASS_PSUBSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBSW_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1834*/ XED_DEF_INST(XED_ICLASS_PSUBSW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBSW_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1835*/ XED_DEF_INST(XED_ICLASS_PSUBSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBSW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1836*/ XED_DEF_INST(XED_ICLASS_PSUBSW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBSW_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1837*/ XED_DEF_INST(XED_ICLASS_FNSTENV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSTENV_MEMmem14,2220,2,55,0,73,XED_EXCEPTION_INVALID),
/*1838*/ XED_DEF_INST(XED_ICLASS_FNSTENV,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSTENV_MEMmem28,2222,2,55,0,73,XED_EXCEPTION_INVALID),
/*1839*/ XED_DEF_INST(XED_ICLASS_PSWAPD,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PSWAPD_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1840*/ XED_DEF_INST(XED_ICLASS_PSWAPD,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PSWAPD_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1841*/ XED_DEF_INST(XED_ICLASS_PAVGW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PAVGW_MMXq_MEMq,417,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1842*/ XED_DEF_INST(XED_ICLASS_PAVGW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PAVGW_MMXq_MMXq,419,2,0,0,6,XED_EXCEPTION_INVALID),
/*1843*/ XED_DEF_INST(XED_ICLASS_PAVGW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PAVGW_XMMdq_MEMdq,1320,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1844*/ XED_DEF_INST(XED_ICLASS_PAVGW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PAVGW_XMMdq_XMMdq,1322,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1845*/ XED_DEF_INST(XED_ICLASS_MOVNTPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE2,3,XED_IFORM_MOVNTPD_MEMdq_XMMpd,2224,2,0,0,69,XED_EXCEPTION_SSE_TYPE_1),
/*1846*/ XED_DEF_INST(XED_ICLASS_BLENDVPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDVPS_XMMdq_MEMdq,2226,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1847*/ XED_DEF_INST(XED_ICLASS_BLENDVPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDVPS_XMMdq_XMMdq,2229,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1848*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_MEMb_IMMb_80r0,1284,3,18,0,36,XED_EXCEPTION_INVALID),
/*1849*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPR8_IMMb_80r0,767,3,18,0,37,XED_EXCEPTION_INVALID),
/*1850*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_MEMv_IMMz,770,3,18,0,38,XED_EXCEPTION_INVALID),
/*1851*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPRv_IMMz,773,3,18,0,39,XED_EXCEPTION_INVALID),
/*1852*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_MEMb_IMMb_82r0,1284,3,18,0,36,XED_EXCEPTION_INVALID),
/*1853*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPR8_IMMb_82r0,2080,3,18,0,37,XED_EXCEPTION_INVALID),
/*1854*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_MEMv_IMMb,776,3,18,0,38,XED_EXCEPTION_INVALID),
/*1855*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPRv_IMMb,779,3,18,0,39,XED_EXCEPTION_INVALID),
/*1856*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_MEMb_GPR8,782,3,18,0,36,XED_EXCEPTION_INVALID),
/*1857*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPR8_GPR8_00,785,3,18,0,37,XED_EXCEPTION_INVALID),
/*1858*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_MEMv_GPRv,788,3,18,0,38,XED_EXCEPTION_INVALID),
/*1859*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPRv_GPRv_01,791,3,18,0,39,XED_EXCEPTION_INVALID),
/*1860*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPR8_MEMb,797,3,18,0,37,XED_EXCEPTION_INVALID),
/*1861*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPR8_GPR8_02,794,3,18,0,37,XED_EXCEPTION_INVALID),
/*1862*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPRv_MEMv,803,3,18,0,39,XED_EXCEPTION_INVALID),
/*1863*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_GPRv_GPRv_03,800,3,18,0,39,XED_EXCEPTION_INVALID),
/*1864*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_AL_IMMb,1688,3,18,0,37,XED_EXCEPTION_INVALID),
/*1865*/ XED_DEF_INST(XED_ICLASS_ADD,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADD_OrAX_IMMz,809,3,18,0,39,XED_EXCEPTION_INVALID),
/*1866*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_MEMb_IMMb_80r2,551,3,30,0,36,XED_EXCEPTION_INVALID),
/*1867*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPR8_IMMb_80r2,665,3,30,0,37,XED_EXCEPTION_INVALID),
/*1868*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_MEMv_IMMz,554,3,30,0,38,XED_EXCEPTION_INVALID),
/*1869*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPRv_IMMz,668,3,30,0,39,XED_EXCEPTION_INVALID),
/*1870*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_MEMb_IMMb_82r2,551,3,30,0,36,XED_EXCEPTION_INVALID),
/*1871*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPR8_IMMb_82r2,665,3,30,0,37,XED_EXCEPTION_INVALID),
/*1872*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_MEMv_IMMb,557,3,30,0,38,XED_EXCEPTION_INVALID),
/*1873*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPRv_IMMb,671,3,30,0,39,XED_EXCEPTION_INVALID),
/*1874*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_MEMb_GPR8,560,3,30,0,36,XED_EXCEPTION_INVALID),
/*1875*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPR8_GPR8_10,674,3,30,0,37,XED_EXCEPTION_INVALID),
/*1876*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_MEMv_GPRv,563,3,30,0,38,XED_EXCEPTION_INVALID),
/*1877*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPRv_GPRv_11,677,3,30,0,39,XED_EXCEPTION_INVALID),
/*1878*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPR8_MEMb,683,3,30,0,37,XED_EXCEPTION_INVALID),
/*1879*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPR8_GPR8_12,680,3,30,0,37,XED_EXCEPTION_INVALID),
/*1880*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPRv_MEMv,689,3,30,0,39,XED_EXCEPTION_INVALID),
/*1881*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_GPRv_GPRv_13,686,3,30,0,39,XED_EXCEPTION_INVALID),
/*1882*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_AL_IMMb,692,3,30,0,37,XED_EXCEPTION_INVALID),
/*1883*/ XED_DEF_INST(XED_ICLASS_ADC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_ADC_OrAX_IMMz,695,3,30,0,39,XED_EXCEPTION_INVALID),
/*1884*/ XED_DEF_INST(XED_ICLASS_PSUBSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBSB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1885*/ XED_DEF_INST(XED_ICLASS_PSUBSB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSUBSB_MMXq_MMXq,86,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1886*/ XED_DEF_INST(XED_ICLASS_PSUBSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBSB_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1887*/ XED_DEF_INST(XED_ICLASS_PSUBSB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSUBSB_XMMdq_XMMdq,285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1888*/ XED_DEF_INST(XED_ICLASS_BLENDVPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDVPD_XMMdq_MEMdq,2232,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1889*/ XED_DEF_INST(XED_ICLASS_BLENDVPD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_BLENDVPD_XMMdq_XMMdq,2235,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1890*/ XED_DEF_INST(XED_ICLASS_CMPXCHG8B_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG8B_LOCK_MEMq,2206,6,16,0,112,XED_EXCEPTION_INVALID),
/*1891*/ XED_DEF_INST(XED_ICLASS_CMPXCHG8B_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_BASE,3,XED_IFORM_CMPXCHG8B_LOCK_MEMq,2206,6,16,0,112,XED_EXCEPTION_INVALID),
/*1892*/ XED_DEF_INST(XED_ICLASS_CWDE,XED_CATEGORY_CONVERT,XED_EXTENSION_BASE,3,XED_IFORM_CWDE,2238,2,0,0,0,XED_EXCEPTION_INVALID),
/*1893*/ XED_DEF_INST(XED_ICLASS_MOVNTPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVNTPS_MEMdq_XMMps,2240,2,0,0,69,XED_EXCEPTION_SSE_TYPE_1),
/*1894*/ XED_DEF_INST(XED_ICLASS_BSF,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSF_GPRv_MEMv,606,3,32,0,39,XED_EXCEPTION_INVALID),
/*1895*/ XED_DEF_INST(XED_ICLASS_BSF,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSF_GPRv_GPRv,263,3,32,0,39,XED_EXCEPTION_INVALID),
/*1896*/ XED_DEF_INST(XED_ICLASS_BSF,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSF_GPRv_MEMv,606,3,32,0,39,XED_EXCEPTION_INVALID),
/*1897*/ XED_DEF_INST(XED_ICLASS_BSF,XED_CATEGORY_BITBYTE,XED_EXTENSION_BASE,3,XED_IFORM_BSF_GPRv_GPRv,263,3,32,0,39,XED_EXCEPTION_INVALID),
/*1898*/ XED_DEF_INST(XED_ICLASS_PAVGB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PAVGB_MMXq_MEMq,84,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1899*/ XED_DEF_INST(XED_ICLASS_PAVGB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PAVGB_MMXq_MMXq,437,2,0,0,6,XED_EXCEPTION_INVALID),
/*1900*/ XED_DEF_INST(XED_ICLASS_PAVGB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PAVGB_XMMdq_MEMdq,2157,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1901*/ XED_DEF_INST(XED_ICLASS_PAVGB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PAVGB_XMMdq_XMMdq,2155,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1902*/ XED_DEF_INST(XED_ICLASS_LEA,XED_CATEGORY_MISC,XED_EXTENSION_BASE,3,XED_IFORM_LEA_GPRv_AGEN,2242,2,0,0,39,XED_EXCEPTION_INVALID),
/*1903*/ XED_DEF_INST(XED_ICLASS_RDGSBASE,XED_CATEGORY_RDWRFSGS,XED_EXTENSION_RDWRFSGS,3,XED_IFORM_RDGSBASE_GPRy,2244,2,0,0,39,XED_EXCEPTION_INVALID),
/*1904*/ XED_DEF_INST(XED_ICLASS_MASKMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_MMX,3,XED_IFORM_MASKMOVQ_MMXq_MMXq,2246,4,0,0,57,XED_EXCEPTION_MMX_NOFP2),
/*1905*/ XED_DEF_INST(XED_ICLASS_FLD1,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FLD1,266,3,4,0,6,XED_EXCEPTION_INVALID),
/*1906*/ XED_DEF_INST(XED_ICLASS_XTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_RTM,3,XED_IFORM_XTEST,759,1,84,0,0,XED_EXCEPTION_INVALID),
/*1907*/ XED_DEF_INST(XED_ICLASS_GF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_GF2P8AFFINEINVQB_XMMu8_XMMu64_IMM8,540,3,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1908*/ XED_DEF_INST(XED_ICLASS_GF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_GF2P8AFFINEINVQB_XMMu8_MEMu64_IMM8,543,3,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1909*/ XED_DEF_INST(XED_ICLASS_LES,XED_CATEGORY_SEGOP,XED_EXTENSION_BASE,3,XED_IFORM_LES_GPRz_MEMp,2250,3,0,0,7,XED_EXCEPTION_INVALID),
/*1910*/ XED_DEF_INST(XED_ICLASS_SETZ,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETZ_MEMb,596,2,56,0,37,XED_EXCEPTION_INVALID),
/*1911*/ XED_DEF_INST(XED_ICLASS_SETZ,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETZ_GPR8,598,2,56,0,37,XED_EXCEPTION_INVALID),
/*1912*/ XED_DEF_INST(XED_ICLASS_SHA1MSG2,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1MSG2_XMMi32_XMMi32_SHA,285,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1913*/ XED_DEF_INST(XED_ICLASS_SHA1MSG2,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1MSG2_XMMi32_MEMi32_SHA,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1914*/ XED_DEF_INST(XED_ICLASS_SHA1MSG1,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1MSG1_XMMi32_XMMi32_SHA,285,2,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1915*/ XED_DEF_INST(XED_ICLASS_SHA1MSG1,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA1MSG1_XMMi32_MEMi32_SHA,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1916*/ XED_DEF_INST(XED_ICLASS_MOVHLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE,3,XED_IFORM_MOVHLPS_XMMq_XMMq,1068,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1917*/ XED_DEF_INST(XED_ICLASS_PSRAW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRAW_MMXq_IMMb,2253,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1918*/ XED_DEF_INST(XED_ICLASS_PSRAW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRAW_XMMdq_IMMb,2255,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1919*/ XED_DEF_INST(XED_ICLASS_PSRAW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRAW_MMXq_MEMq,2257,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1920*/ XED_DEF_INST(XED_ICLASS_PSRAW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRAW_MMXq_MMXq,2259,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1921*/ XED_DEF_INST(XED_ICLASS_PSRAW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRAW_XMMdq_MEMdq,2261,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1922*/ XED_DEF_INST(XED_ICLASS_PSRAW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRAW_XMMdq_XMMdq,2263,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1923*/ XED_DEF_INST(XED_ICLASS_SHA256RNDS2,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA256RNDS2_XMMi32_XMMi32_SHA,2265,3,0,0,0,XED_EXCEPTION_SSE_TYPE_4),
/*1924*/ XED_DEF_INST(XED_ICLASS_SHA256RNDS2,XED_CATEGORY_SHA,XED_EXTENSION_SHA,3,XED_IFORM_SHA256RNDS2_XMMi32_MEMi32_SHA,2268,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1925*/ XED_DEF_INST(XED_ICLASS_PFADD,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFADD_MMXq_MEMq,84,2,0,0,8,XED_EXCEPTION_INVALID),
/*1926*/ XED_DEF_INST(XED_ICLASS_PFADD,XED_CATEGORY_3DNOW,XED_EXTENSION_3DNOW,3,XED_IFORM_PFADD_MMXq_MMXq,86,2,0,0,8,XED_EXCEPTION_INVALID),
/*1927*/ XED_DEF_INST(XED_ICLASS_ENDBR32,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_ENDBR32,0,0,0,0,0,XED_EXCEPTION_INVALID),
/*1928*/ XED_DEF_INST(XED_ICLASS_COMISD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_COMISD_XMMsd_MEMsd,2271,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1929*/ XED_DEF_INST(XED_ICLASS_COMISD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_COMISD_XMMsd_XMMsd,2274,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1930*/ XED_DEF_INST(XED_ICLASS_PSRAD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRAD_MMXq_IMMb,2277,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1931*/ XED_DEF_INST(XED_ICLASS_PSRAD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRAD_XMMdq_IMMb,2279,2,0,0,0,XED_EXCEPTION_SSE_TYPE_7),
/*1932*/ XED_DEF_INST(XED_ICLASS_PSRAD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRAD_MMXq_MEMq,2281,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1933*/ XED_DEF_INST(XED_ICLASS_PSRAD,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PSRAD_MMXq_MMXq,2283,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1934*/ XED_DEF_INST(XED_ICLASS_PSRAD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRAD_XMMdq_MEMdq,2285,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1935*/ XED_DEF_INST(XED_ICLASS_PSRAD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSRAD_XMMdq_XMMdq,2287,2,0,0,33,XED_EXCEPTION_SSE_TYPE_7),
/*1936*/ XED_DEF_INST(XED_ICLASS_PACKSSWB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PACKSSWB_MMXq_MEMq,417,2,0,0,46,XED_EXCEPTION_MMX_MEM),
/*1937*/ XED_DEF_INST(XED_ICLASS_PACKSSWB,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PACKSSWB_MMXq_MMXq,419,2,0,0,46,XED_EXCEPTION_INVALID),
/*1938*/ XED_DEF_INST(XED_ICLASS_PACKSSWB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PACKSSWB_XMMdq_MEMdq,421,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/*1939*/ XED_DEF_INST(XED_ICLASS_PACKSSWB,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PACKSSWB_XMMdq_XMMdq,423,2,0,0,47,XED_EXCEPTION_SSE_TYPE_4),
/*1940*/ XED_DEF_INST(XED_ICLASS_FSINCOS,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FSINCOS,647,3,58,0,6,XED_EXCEPTION_INVALID),
/*1941*/ XED_DEF_INST(XED_ICLASS_COMISS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_COMISS_XMMss_MEMss,2289,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1942*/ XED_DEF_INST(XED_ICLASS_COMISS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_COMISS_XMMss_XMMss,2292,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1943*/ XED_DEF_INST(XED_ICLASS_PEXTRW_SSE4,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRW_SSE4_MEMw_XMMdq_IMMb,2295,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1944*/ XED_DEF_INST(XED_ICLASS_PEXTRW_SSE4,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRW_SSE4_GPR32_XMMdq_IMMb,2298,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1945*/ XED_DEF_INST(XED_ICLASS_RCPPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RCPPS_XMMps_MEMps,995,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1946*/ XED_DEF_INST(XED_ICLASS_RCPPS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_RCPPS_XMMps_XMMps,997,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1947*/ XED_DEF_INST(XED_ICLASS_DEC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_MEMb,509,2,35,0,36,XED_EXCEPTION_INVALID),
/*1948*/ XED_DEF_INST(XED_ICLASS_DEC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_GPR8,511,2,35,0,37,XED_EXCEPTION_INVALID),
/*1949*/ XED_DEF_INST(XED_ICLASS_DEC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_MEMv,513,2,35,0,38,XED_EXCEPTION_INVALID),
/*1950*/ XED_DEF_INST(XED_ICLASS_DEC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_GPRv_FFr1,515,2,35,0,39,XED_EXCEPTION_INVALID),
/*1951*/ XED_DEF_INST(XED_ICLASS_DEC,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_DEC_GPRv_48,517,2,35,0,39,XED_EXCEPTION_INVALID),
/*1952*/ XED_DEF_INST(XED_ICLASS_DAA,XED_CATEGORY_DECIMAL,XED_EXTENSION_BASE,3,XED_IFORM_DAA,2301,2,86,0,0,XED_EXCEPTION_INVALID),
/*1953*/ XED_DEF_INST(XED_ICLASS_SETBE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETBE_MEMb,596,2,41,0,37,XED_EXCEPTION_INVALID),
/*1954*/ XED_DEF_INST(XED_ICLASS_SETBE,XED_CATEGORY_SETCC,XED_EXTENSION_BASE,3,XED_IFORM_SETBE_GPR8,598,2,41,0,37,XED_EXCEPTION_INVALID),
/*1955*/ XED_DEF_INST(XED_ICLASS_CMPXCHG16B_LOCK,XED_CATEGORY_SEMAPHORE,XED_EXTENSION_LONGMODE,3,XED_IFORM_CMPXCHG16B_LOCK_MEMdq,1913,6,16,0,113,XED_EXCEPTION_INVALID),
/*1956*/ XED_DEF_INST(XED_ICLASS_NEG_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_NEG_LOCK_MEMb,509,2,18,0,53,XED_EXCEPTION_INVALID),
/*1957*/ XED_DEF_INST(XED_ICLASS_NEG_LOCK,XED_CATEGORY_BINARY,XED_EXTENSION_BASE,3,XED_IFORM_NEG_LOCK_MEMv,513,2,18,0,54,XED_EXCEPTION_INVALID),
/*1958*/ XED_DEF_INST(XED_ICLASS_FUCOMIP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FUCOMIP_ST0_X87,482,5,13,0,6,XED_EXCEPTION_INVALID),
/*1959*/ XED_DEF_INST(XED_ICLASS_DAS,XED_CATEGORY_DECIMAL,XED_EXTENSION_BASE,3,XED_IFORM_DAS,2301,2,86,0,0,XED_EXCEPTION_INVALID),
/*1960*/ XED_DEF_INST(XED_ICLASS_MOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE3,3,XED_IFORM_MOVDDUP_XMMdq_MEMq,1666,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1961*/ XED_DEF_INST(XED_ICLASS_MOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_SSE3,3,XED_IFORM_MOVDDUP_XMMdq_XMMq,1676,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1962*/ XED_DEF_INST(XED_ICLASS_BSWAP,XED_CATEGORY_DATAXFER,XED_EXTENSION_BASE,3,XED_IFORM_BSWAP_GPRv,2303,1,0,0,39,XED_EXCEPTION_INVALID),
/*1963*/ XED_DEF_INST(XED_ICLASS_PUNPCKLBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKLBW_MMXq_MEMd,2304,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1964*/ XED_DEF_INST(XED_ICLASS_PUNPCKLBW,XED_CATEGORY_MMX,XED_EXTENSION_MMX,3,XED_IFORM_PUNPCKLBW_MMXq_MMXd,2306,2,0,0,6,XED_EXCEPTION_MMX_MEM),
/*1965*/ XED_DEF_INST(XED_ICLASS_PUNPCKLBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLBW_XMMdq_MEMdq,148,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1966*/ XED_DEF_INST(XED_ICLASS_PUNPCKLBW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PUNPCKLBW_XMMdq_XMMq,150,2,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1967*/ XED_DEF_INST(XED_ICLASS_PAUSE,XED_CATEGORY_MISC,XED_EXTENSION_PAUSE,3,XED_IFORM_PAUSE,0,0,0,0,6,XED_EXCEPTION_INVALID),
/*1968*/ XED_DEF_INST(XED_ICLASS_ROUNDSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDSS_XMMd_MEMd_IMMb,2308,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1969*/ XED_DEF_INST(XED_ICLASS_ROUNDSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDSS_XMMd_XMMd_IMMb,2311,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1970*/ XED_DEF_INST(XED_ICLASS_VMRUN,XED_CATEGORY_SYSTEM,XED_EXTENSION_SVM,3,XED_IFORM_VMRUN_OrAX,431,1,0,0,9,XED_EXCEPTION_INVALID),
/*1971*/ XED_DEF_INST(XED_ICLASS_PCONFIG,XED_CATEGORY_PCONFIG,XED_EXTENSION_PCONFIG,0,XED_IFORM_PCONFIG,2314,5,87,0,0,XED_EXCEPTION_INVALID),
/*1972*/ XED_DEF_INST(XED_ICLASS_FNSTCW,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FNSTCW_MEMmem16,2319,3,55,0,73,XED_EXCEPTION_INVALID),
/*1973*/ XED_DEF_INST(XED_ICLASS_ROUNDSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDSD_XMMq_MEMq_IMMb,2322,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1974*/ XED_DEF_INST(XED_ICLASS_ROUNDSD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_ROUNDSD_XMMq_XMMq_IMMb,2325,3,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1975*/ XED_DEF_INST(XED_ICLASS_PEXTRQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRQ_MEMq_XMMdq_IMMb,2328,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1976*/ XED_DEF_INST(XED_ICLASS_PEXTRQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PEXTRQ_GPR64q_XMMdq_IMMb,2331,3,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1977*/ XED_DEF_INST(XED_ICLASS_ADCX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADCX_GPR32d_GPR32d,1011,3,17,0,0,XED_EXCEPTION_INVALID),
/*1978*/ XED_DEF_INST(XED_ICLASS_ADCX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADCX_GPR32d_MEMd,1014,3,17,0,0,XED_EXCEPTION_INVALID),
/*1979*/ XED_DEF_INST(XED_ICLASS_ADCX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADCX_GPR64q_GPR64q,1017,3,17,0,0,XED_EXCEPTION_INVALID),
/*1980*/ XED_DEF_INST(XED_ICLASS_ADCX,XED_CATEGORY_ADOX_ADCX,XED_EXTENSION_ADOX_ADCX,3,XED_IFORM_ADCX_GPR64q_MEMq,1020,3,17,0,0,XED_EXCEPTION_INVALID),
/*1981*/ XED_DEF_INST(XED_ICLASS_FISTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISTP_MEMmem32int_ST0,1596,4,4,0,6,XED_EXCEPTION_INVALID),
/*1982*/ XED_DEF_INST(XED_ICLASS_FISTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISTP_MEMmem16int_ST0,1604,4,4,0,6,XED_EXCEPTION_INVALID),
/*1983*/ XED_DEF_INST(XED_ICLASS_FISTP,XED_CATEGORY_X87_ALU,XED_EXTENSION_X87,3,XED_IFORM_FISTP_MEMm64int_ST0,1600,4,4,0,6,XED_EXCEPTION_INVALID),
/*1984*/ XED_DEF_INST(XED_ICLASS_PMOVZXWQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXWQ_XMMdq_MEMd,2334,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1985*/ XED_DEF_INST(XED_ICLASS_PMOVZXWQ,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXWQ_XMMdq_XMMd,2336,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1986*/ XED_DEF_INST(XED_ICLASS_MAXSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MAXSS_XMMss_MEMss,413,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1987*/ XED_DEF_INST(XED_ICLASS_MAXSS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_MAXSS_XMMss_XMMss,415,2,0,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1988*/ XED_DEF_INST(XED_ICLASS_JMP_FAR,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_FAR_MEMp2,2338,2,0,0,114,XED_EXCEPTION_INVALID),
/*1989*/ XED_DEF_INST(XED_ICLASS_JMP_FAR,XED_CATEGORY_UNCOND_BR,XED_EXTENSION_BASE,3,XED_IFORM_JMP_FAR_PTRp_IMMw,2340,3,0,0,115,XED_EXCEPTION_INVALID),
/*1990*/ XED_DEF_INST(XED_ICLASS_ENDBR64,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_ENDBR64,0,0,0,0,0,XED_EXCEPTION_INVALID),
/*1991*/ XED_DEF_INST(XED_ICLASS_INCSSPD,XED_CATEGORY_CET,XED_EXTENSION_CET,3,XED_IFORM_INCSSPD_GPR32u8,2343,2,0,0,0,XED_EXCEPTION_INVALID),
/*1992*/ XED_DEF_INST(XED_ICLASS_PBLENDVB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PBLENDVB_XMMdq_MEMdq,2345,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1993*/ XED_DEF_INST(XED_ICLASS_PBLENDVB,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PBLENDVB_XMMdq_XMMdq,2348,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*1994*/ XED_DEF_INST(XED_ICLASS_VMRESUME,XED_CATEGORY_VTX,XED_EXTENSION_VTX,0,XED_IFORM_VMRESUME,999,1,53,0,6,XED_EXCEPTION_INVALID),
/*1995*/ XED_DEF_INST(XED_ICLASS_UCOMISD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_UCOMISD_XMMsd_MEMsd,2271,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1996*/ XED_DEF_INST(XED_ICLASS_UCOMISD,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_UCOMISD_XMMsd_XMMsd,2274,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*1997*/ XED_DEF_INST(XED_ICLASS_PMOVZXWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXWD_XMMdq_MEMq,2351,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1998*/ XED_DEF_INST(XED_ICLASS_PMOVZXWD,XED_CATEGORY_SSE,XED_EXTENSION_SSE4,3,XED_IFORM_PMOVZXWD_XMMdq_XMMq,2353,2,0,0,0,XED_EXCEPTION_SSE_TYPE_5),
/*1999*/ XED_DEF_INST(XED_ICLASS_CVTTPD2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTPD2PI_MMXq_MEMpd,2151,2,0,0,107,XED_EXCEPTION_MMX_FP_16ALIGN),
/*2000*/ XED_DEF_INST(XED_ICLASS_CVTTPD2PI,XED_CATEGORY_CONVERT,XED_EXTENSION_SSE2,3,XED_IFORM_CVTTPD2PI_MMXq_XMMpd,2153,2,0,0,107,XED_EXCEPTION_MMX_FP_16ALIGN),
/*2001*/ XED_DEF_INST(XED_ICLASS_UCOMISS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_UCOMISS_XMMss_MEMss,2289,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*2002*/ XED_DEF_INST(XED_ICLASS_UCOMISS,XED_CATEGORY_SSE,XED_EXTENSION_SSE,3,XED_IFORM_UCOMISS_XMMss_XMMss,2292,3,85,0,41,XED_EXCEPTION_SSE_TYPE_3),
/*2003*/ XED_DEF_INST(XED_ICLASS_PSHUFHW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSHUFHW_XMMdq_MEMdq_IMMb,2163,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*2004*/ XED_DEF_INST(XED_ICLASS_PSHUFHW,XED_CATEGORY_SSE,XED_EXTENSION_SSE2,3,XED_IFORM_PSHUFHW_XMMdq_XMMdq_IMMb,2166,3,0,0,33,XED_EXCEPTION_SSE_TYPE_4),
/*2005*/ XED_DEF_INST(XED_ICLASS_MWAIT,XED_CATEGORY_MISC,XED_EXTENSION_MONITOR,0,XED_IFORM_MWAIT,924,2,0,0,15,XED_EXCEPTION_INVALID),
/*2006*/ XED_DEF_INST(XED_ICLASS_VPHADDUDQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUDQ_XMMdq_MEMdq,2355,2,0,0,8,XED_EXCEPTION_INVALID),
/*2007*/ XED_DEF_INST(XED_ICLASS_VPHADDUDQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUDQ_XMMdq_XMMdq,2357,2,0,0,8,XED_EXCEPTION_INVALID),
/*2008*/ XED_DEF_INST(XED_ICLASS_BLCS,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCS_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2009*/ XED_DEF_INST(XED_ICLASS_BLCS,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCS_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2010*/ XED_DEF_INST(XED_ICLASS_BLCS,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCS_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2011*/ XED_DEF_INST(XED_ICLASS_BLCS,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCS_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2012*/ XED_DEF_INST(XED_ICLASS_VPSHAD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAD_XMMdq_MEMdq_XMMdq,2371,3,0,0,8,XED_EXCEPTION_INVALID),
/*2013*/ XED_DEF_INST(XED_ICLASS_VPSHAD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAD_XMMdq_XMMdq_XMMdq,2374,3,0,0,8,XED_EXCEPTION_INVALID),
/*2014*/ XED_DEF_INST(XED_ICLASS_VPSHAD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAD_XMMdq_XMMdq_MEMdq,2377,3,0,0,8,XED_EXCEPTION_INVALID),
/*2015*/ XED_DEF_INST(XED_ICLASS_VPSHAD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAD_XMMdq_XMMdq_XMMdq,2380,3,0,0,8,XED_EXCEPTION_INVALID),
/*2016*/ XED_DEF_INST(XED_ICLASS_LWPINS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_LWPINS_VGPRyy_MEMd_IMMd,2383,4,89,0,80,XED_EXCEPTION_INVALID),
/*2017*/ XED_DEF_INST(XED_ICLASS_LWPINS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_LWPINS_VGPRyy_GPRyy_IMMd,2387,4,89,0,80,XED_EXCEPTION_INVALID),
/*2018*/ XED_DEF_INST(XED_ICLASS_VPHADDUWQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUWQ_XMMdq_MEMdq,2391,2,0,0,8,XED_EXCEPTION_INVALID),
/*2019*/ XED_DEF_INST(XED_ICLASS_VPHADDUWQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUWQ_XMMdq_XMMdq,2393,2,0,0,8,XED_EXCEPTION_INVALID),
/*2020*/ XED_DEF_INST(XED_ICLASS_BLSIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSIC_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2021*/ XED_DEF_INST(XED_ICLASS_BLSIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSIC_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2022*/ XED_DEF_INST(XED_ICLASS_BLSIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSIC_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2023*/ XED_DEF_INST(XED_ICLASS_BLSIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSIC_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2024*/ XED_DEF_INST(XED_ICLASS_VPHSUBDQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHSUBDQ_XMMdq_MEMdq,2395,2,0,0,8,XED_EXCEPTION_INVALID),
/*2025*/ XED_DEF_INST(XED_ICLASS_VPHSUBDQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHSUBDQ_XMMdq_XMMdq,2397,2,0,0,8,XED_EXCEPTION_INVALID),
/*2026*/ XED_DEF_INST(XED_ICLASS_BLCFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCFILL_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2027*/ XED_DEF_INST(XED_ICLASS_BLCFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCFILL_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2028*/ XED_DEF_INST(XED_ICLASS_BLCFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCFILL_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2029*/ XED_DEF_INST(XED_ICLASS_BLCFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCFILL_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2030*/ XED_DEF_INST(XED_ICLASS_VPHSUBBW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHSUBBW_XMMdq_MEMdq,2399,2,0,0,8,XED_EXCEPTION_INVALID),
/*2031*/ XED_DEF_INST(XED_ICLASS_VPHSUBBW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHSUBBW_XMMdq_XMMdq,2401,2,0,0,8,XED_EXCEPTION_INVALID),
/*2032*/ XED_DEF_INST(XED_ICLASS_VPPERM,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPPERM_XMMdq_XMMdq_MEMdq_XMMdq,2403,4,0,0,8,XED_EXCEPTION_INVALID),
/*2033*/ XED_DEF_INST(XED_ICLASS_VPPERM,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPPERM_XMMdq_XMMdq_XMMdq_XMMdq,2407,4,0,0,8,XED_EXCEPTION_INVALID),
/*2034*/ XED_DEF_INST(XED_ICLASS_VPPERM,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPPERM_XMMdq_XMMdq_XMMdq_MEMdq,2411,4,0,0,8,XED_EXCEPTION_INVALID),
/*2035*/ XED_DEF_INST(XED_ICLASS_VPPERM,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPPERM_XMMdq_XMMdq_XMMdq_XMMdq,2415,4,0,0,8,XED_EXCEPTION_INVALID),
/*2036*/ XED_DEF_INST(XED_ICLASS_TZMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_TZMSK_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2037*/ XED_DEF_INST(XED_ICLASS_TZMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_TZMSK_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2038*/ XED_DEF_INST(XED_ICLASS_TZMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_TZMSK_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2039*/ XED_DEF_INST(XED_ICLASS_TZMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_TZMSK_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2040*/ XED_DEF_INST(XED_ICLASS_VPMADCSSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMADCSSWD_XMMdq_XMMdq_MEMdq_XMMdq,2419,4,0,0,8,XED_EXCEPTION_INVALID),
/*2041*/ XED_DEF_INST(XED_ICLASS_VPMADCSSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMADCSSWD_XMMdq_XMMdq_XMMdq_XMMdq,2423,4,0,0,8,XED_EXCEPTION_INVALID),
/*2042*/ XED_DEF_INST(XED_ICLASS_VPHADDUWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUWD_XMMdq_MEMdq,2427,2,0,0,8,XED_EXCEPTION_INVALID),
/*2043*/ XED_DEF_INST(XED_ICLASS_VPHADDUWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUWD_XMMdq_XMMdq,2429,2,0,0,8,XED_EXCEPTION_INVALID),
/*2044*/ XED_DEF_INST(XED_ICLASS_VPMADCSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMADCSWD_XMMdq_XMMdq_MEMdq_XMMdq,2419,4,0,0,8,XED_EXCEPTION_INVALID),
/*2045*/ XED_DEF_INST(XED_ICLASS_VPMADCSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMADCSWD_XMMdq_XMMdq_XMMdq_XMMdq,2423,4,0,0,8,XED_EXCEPTION_INVALID),
/*2046*/ XED_DEF_INST(XED_ICLASS_VPHADDBQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDBQ_XMMdq_MEMdq,2431,2,0,0,8,XED_EXCEPTION_INVALID),
/*2047*/ XED_DEF_INST(XED_ICLASS_VPHADDBQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDBQ_XMMdq_XMMdq,2433,2,0,0,8,XED_EXCEPTION_INVALID),
/*2048*/ XED_DEF_INST(XED_ICLASS_VPHSUBWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHSUBWD_XMMdq_MEMdq,2435,2,0,0,8,XED_EXCEPTION_INVALID),
/*2049*/ XED_DEF_INST(XED_ICLASS_VPHSUBWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHSUBWD_XMMdq_XMMdq,2437,2,0,0,8,XED_EXCEPTION_INVALID),
/*2050*/ XED_DEF_INST(XED_ICLASS_VPMACSDD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSDD_XMMdq_XMMdq_MEMdq_XMMdq,2439,4,0,0,8,XED_EXCEPTION_INVALID),
/*2051*/ XED_DEF_INST(XED_ICLASS_VPMACSDD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSDD_XMMdq_XMMdq_XMMdq_XMMdq,2443,4,0,0,8,XED_EXCEPTION_INVALID),
/*2052*/ XED_DEF_INST(XED_ICLASS_VPMACSWW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSWW_XMMdq_XMMdq_MEMdq_XMMdq,2403,4,0,0,8,XED_EXCEPTION_INVALID),
/*2053*/ XED_DEF_INST(XED_ICLASS_VPMACSWW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSWW_XMMdq_XMMdq_XMMdq_XMMdq,2407,4,0,0,8,XED_EXCEPTION_INVALID),
/*2054*/ XED_DEF_INST(XED_ICLASS_VPHADDBW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDBW_XMMdq_MEMdq,2447,2,0,0,8,XED_EXCEPTION_INVALID),
/*2055*/ XED_DEF_INST(XED_ICLASS_VPHADDBW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDBW_XMMdq_XMMdq,2449,2,0,0,8,XED_EXCEPTION_INVALID),
/*2056*/ XED_DEF_INST(XED_ICLASS_VPHADDUBD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUBD_XMMdq_MEMdq,2451,2,0,0,8,XED_EXCEPTION_INVALID),
/*2057*/ XED_DEF_INST(XED_ICLASS_VPHADDUBD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUBD_XMMdq_XMMdq,2453,2,0,0,8,XED_EXCEPTION_INVALID),
/*2058*/ XED_DEF_INST(XED_ICLASS_VPSHLD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLD_XMMdq_MEMdq_XMMdq,2455,3,0,0,8,XED_EXCEPTION_INVALID),
/*2059*/ XED_DEF_INST(XED_ICLASS_VPSHLD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLD_XMMdq_XMMdq_XMMdq,2458,3,0,0,8,XED_EXCEPTION_INVALID),
/*2060*/ XED_DEF_INST(XED_ICLASS_VPSHLD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLD_XMMdq_XMMdq_MEMdq,2461,3,0,0,8,XED_EXCEPTION_INVALID),
/*2061*/ XED_DEF_INST(XED_ICLASS_VPSHLD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLD_XMMdq_XMMdq_XMMdq,2464,3,0,0,8,XED_EXCEPTION_INVALID),
/*2062*/ XED_DEF_INST(XED_ICLASS_VFRCZPD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPD_XMMdq_MEMdq,2467,2,0,0,116,XED_EXCEPTION_INVALID),
/*2063*/ XED_DEF_INST(XED_ICLASS_VFRCZPD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPD_XMMdq_XMMdq,2469,2,0,0,116,XED_EXCEPTION_INVALID),
/*2064*/ XED_DEF_INST(XED_ICLASS_VFRCZPD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPD_YMMqq_MEMqq,2471,2,0,0,116,XED_EXCEPTION_INVALID),
/*2065*/ XED_DEF_INST(XED_ICLASS_VFRCZPD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPD_YMMqq_YMMqq,2473,2,0,0,116,XED_EXCEPTION_INVALID),
/*2066*/ XED_DEF_INST(XED_ICLASS_VPMACSSWW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSWW_XMMdq_XMMdq_MEMdq_XMMdq,2403,4,0,0,8,XED_EXCEPTION_INVALID),
/*2067*/ XED_DEF_INST(XED_ICLASS_VPMACSSWW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSWW_XMMdq_XMMdq_XMMdq_XMMdq,2407,4,0,0,8,XED_EXCEPTION_INVALID),
/*2068*/ XED_DEF_INST(XED_ICLASS_VPSHLB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLB_XMMdq_MEMdq_XMMdq,2475,3,0,0,8,XED_EXCEPTION_INVALID),
/*2069*/ XED_DEF_INST(XED_ICLASS_VPSHLB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLB_XMMdq_XMMdq_XMMdq,2478,3,0,0,8,XED_EXCEPTION_INVALID),
/*2070*/ XED_DEF_INST(XED_ICLASS_VPSHLB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLB_XMMdq_XMMdq_MEMdq,2481,3,0,0,8,XED_EXCEPTION_INVALID),
/*2071*/ XED_DEF_INST(XED_ICLASS_VPSHLB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLB_XMMdq_XMMdq_XMMdq,2484,3,0,0,8,XED_EXCEPTION_INVALID),
/*2072*/ XED_DEF_INST(XED_ICLASS_VPHADDUBQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUBQ_XMMdq_MEMdq,2487,2,0,0,8,XED_EXCEPTION_INVALID),
/*2073*/ XED_DEF_INST(XED_ICLASS_VPHADDUBQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUBQ_XMMdq_XMMdq,2489,2,0,0,8,XED_EXCEPTION_INVALID),
/*2074*/ XED_DEF_INST(XED_ICLASS_VPROTB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTB_XMMdq_MEMdq_IMMb,2491,3,0,0,8,XED_EXCEPTION_INVALID),
/*2075*/ XED_DEF_INST(XED_ICLASS_VPROTB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTB_XMMdq_XMMdq_IMMb,2494,3,0,0,8,XED_EXCEPTION_INVALID),
/*2076*/ XED_DEF_INST(XED_ICLASS_VPROTB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTB_XMMdq_MEMdq_XMMdq,2475,3,0,0,8,XED_EXCEPTION_INVALID),
/*2077*/ XED_DEF_INST(XED_ICLASS_VPROTB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTB_XMMdq_XMMdq_XMMdq,2478,3,0,0,8,XED_EXCEPTION_INVALID),
/*2078*/ XED_DEF_INST(XED_ICLASS_VPROTB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTB_XMMdq_XMMdq_MEMdq,2481,3,0,0,8,XED_EXCEPTION_INVALID),
/*2079*/ XED_DEF_INST(XED_ICLASS_VPROTB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTB_XMMdq_XMMdq_XMMdq,2484,3,0,0,8,XED_EXCEPTION_INVALID),
/*2080*/ XED_DEF_INST(XED_ICLASS_VPHADDUBW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUBW_XMMdq_MEMdq,2497,2,0,0,8,XED_EXCEPTION_INVALID),
/*2081*/ XED_DEF_INST(XED_ICLASS_VPHADDUBW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDUBW_XMMdq_XMMdq,2499,2,0,0,8,XED_EXCEPTION_INVALID),
/*2082*/ XED_DEF_INST(XED_ICLASS_VPHADDBD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDBD_XMMdq_MEMdq,2501,2,0,0,8,XED_EXCEPTION_INVALID),
/*2083*/ XED_DEF_INST(XED_ICLASS_VPHADDBD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDBD_XMMdq_XMMdq,2503,2,0,0,8,XED_EXCEPTION_INVALID),
/*2084*/ XED_DEF_INST(XED_ICLASS_VPMACSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSWD_XMMdq_XMMdq_MEMdq_XMMdq,2419,4,0,0,8,XED_EXCEPTION_INVALID),
/*2085*/ XED_DEF_INST(XED_ICLASS_VPMACSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSWD_XMMdq_XMMdq_XMMdq_XMMdq,2423,4,0,0,8,XED_EXCEPTION_INVALID),
/*2086*/ XED_DEF_INST(XED_ICLASS_VPMACSDQL,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSDQL_XMMdq_XMMdq_MEMdq_XMMdq,2505,4,0,0,8,XED_EXCEPTION_INVALID),
/*2087*/ XED_DEF_INST(XED_ICLASS_VPMACSDQL,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSDQL_XMMdq_XMMdq_XMMdq_XMMdq,2509,4,0,0,8,XED_EXCEPTION_INVALID),
/*2088*/ XED_DEF_INST(XED_ICLASS_VPSHLW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLW_XMMdq_MEMdq_XMMdq,2513,3,0,0,8,XED_EXCEPTION_INVALID),
/*2089*/ XED_DEF_INST(XED_ICLASS_VPSHLW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLW_XMMdq_XMMdq_XMMdq,2516,3,0,0,8,XED_EXCEPTION_INVALID),
/*2090*/ XED_DEF_INST(XED_ICLASS_VPSHLW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLW_XMMdq_XMMdq_MEMdq,2519,3,0,0,8,XED_EXCEPTION_INVALID),
/*2091*/ XED_DEF_INST(XED_ICLASS_VPSHLW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLW_XMMdq_XMMdq_XMMdq,2522,3,0,0,8,XED_EXCEPTION_INVALID),
/*2092*/ XED_DEF_INST(XED_ICLASS_VPMACSDQH,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSDQH_XMMdq_XMMdq_MEMdq_XMMdq,2505,4,0,0,8,XED_EXCEPTION_INVALID),
/*2093*/ XED_DEF_INST(XED_ICLASS_VPMACSDQH,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSDQH_XMMdq_XMMdq_XMMdq_XMMdq,2509,4,0,0,8,XED_EXCEPTION_INVALID),
/*2094*/ XED_DEF_INST(XED_ICLASS_VPMACSSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSWD_XMMdq_XMMdq_MEMdq_XMMdq,2419,4,0,0,8,XED_EXCEPTION_INVALID),
/*2095*/ XED_DEF_INST(XED_ICLASS_VPMACSSWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSWD_XMMdq_XMMdq_XMMdq_XMMdq,2423,4,0,0,8,XED_EXCEPTION_INVALID),
/*2096*/ XED_DEF_INST(XED_ICLASS_BLCIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCIC_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2097*/ XED_DEF_INST(XED_ICLASS_BLCIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCIC_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2098*/ XED_DEF_INST(XED_ICLASS_BLCIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCIC_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2099*/ XED_DEF_INST(XED_ICLASS_BLCIC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCIC_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2100*/ XED_DEF_INST(XED_ICLASS_VPROTD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTD_XMMdq_MEMdq_IMMb,1735,3,0,0,8,XED_EXCEPTION_INVALID),
/*2101*/ XED_DEF_INST(XED_ICLASS_VPROTD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTD_XMMdq_XMMdq_IMMb,1738,3,0,0,8,XED_EXCEPTION_INVALID),
/*2102*/ XED_DEF_INST(XED_ICLASS_VPROTD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTD_XMMdq_MEMdq_XMMdq,2455,3,0,0,8,XED_EXCEPTION_INVALID),
/*2103*/ XED_DEF_INST(XED_ICLASS_VPROTD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTD_XMMdq_XMMdq_XMMdq,2458,3,0,0,8,XED_EXCEPTION_INVALID),
/*2104*/ XED_DEF_INST(XED_ICLASS_VPROTD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTD_XMMdq_XMMdq_MEMdq,2461,3,0,0,8,XED_EXCEPTION_INVALID),
/*2105*/ XED_DEF_INST(XED_ICLASS_VPROTD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTD_XMMdq_XMMdq_XMMdq,2464,3,0,0,8,XED_EXCEPTION_INVALID),
/*2106*/ XED_DEF_INST(XED_ICLASS_VPCOMQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMQ_XMMdq_XMMdq_MEMdq_IMMb,2525,4,0,0,8,XED_EXCEPTION_INVALID),
/*2107*/ XED_DEF_INST(XED_ICLASS_VPCOMQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMQ_XMMdq_XMMdq_XMMdq_IMMb,2529,4,0,0,8,XED_EXCEPTION_INVALID),
/*2108*/ XED_DEF_INST(XED_ICLASS_VPSHAQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAQ_XMMdq_MEMdq_XMMdq,2533,3,0,0,8,XED_EXCEPTION_INVALID),
/*2109*/ XED_DEF_INST(XED_ICLASS_VPSHAQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAQ_XMMdq_XMMdq_XMMdq,2536,3,0,0,8,XED_EXCEPTION_INVALID),
/*2110*/ XED_DEF_INST(XED_ICLASS_VPSHAQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAQ_XMMdq_XMMdq_MEMdq,2539,3,0,0,8,XED_EXCEPTION_INVALID),
/*2111*/ XED_DEF_INST(XED_ICLASS_VPSHAQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAQ_XMMdq_XMMdq_XMMdq,2542,3,0,0,8,XED_EXCEPTION_INVALID),
/*2112*/ XED_DEF_INST(XED_ICLASS_VPMACSSDD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSDD_XMMdq_XMMdq_MEMdq_XMMdq,2439,4,0,0,8,XED_EXCEPTION_INVALID),
/*2113*/ XED_DEF_INST(XED_ICLASS_VPMACSSDD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSDD_XMMdq_XMMdq_XMMdq_XMMdq,2443,4,0,0,8,XED_EXCEPTION_INVALID),
/*2114*/ XED_DEF_INST(XED_ICLASS_T1MSKC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_T1MSKC_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2115*/ XED_DEF_INST(XED_ICLASS_T1MSKC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_T1MSKC_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2116*/ XED_DEF_INST(XED_ICLASS_T1MSKC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_T1MSKC_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2117*/ XED_DEF_INST(XED_ICLASS_T1MSKC,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_T1MSKC_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2118*/ XED_DEF_INST(XED_ICLASS_VPMACSSDQH,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSDQH_XMMdq_XMMdq_MEMdq_XMMdq,2505,4,0,0,8,XED_EXCEPTION_INVALID),
/*2119*/ XED_DEF_INST(XED_ICLASS_VPMACSSDQH,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSDQH_XMMdq_XMMdq_XMMdq_XMMdq,2509,4,0,0,8,XED_EXCEPTION_INVALID),
/*2120*/ XED_DEF_INST(XED_ICLASS_VPHADDWQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDWQ_XMMdq_MEMdq,2545,2,0,0,8,XED_EXCEPTION_INVALID),
/*2121*/ XED_DEF_INST(XED_ICLASS_VPHADDWQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDWQ_XMMdq_XMMdq,2547,2,0,0,8,XED_EXCEPTION_INVALID),
/*2122*/ XED_DEF_INST(XED_ICLASS_VPSHAW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAW_XMMdq_MEMdq_XMMdq,2549,3,0,0,8,XED_EXCEPTION_INVALID),
/*2123*/ XED_DEF_INST(XED_ICLASS_VPSHAW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAW_XMMdq_XMMdq_XMMdq,2552,3,0,0,8,XED_EXCEPTION_INVALID),
/*2124*/ XED_DEF_INST(XED_ICLASS_VPSHAW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAW_XMMdq_XMMdq_MEMdq,2555,3,0,0,8,XED_EXCEPTION_INVALID),
/*2125*/ XED_DEF_INST(XED_ICLASS_VPSHAW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAW_XMMdq_XMMdq_XMMdq,2558,3,0,0,8,XED_EXCEPTION_INVALID),
/*2126*/ XED_DEF_INST(XED_ICLASS_VPMACSSDQL,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSDQL_XMMdq_XMMdq_MEMdq_XMMdq,2505,4,0,0,8,XED_EXCEPTION_INVALID),
/*2127*/ XED_DEF_INST(XED_ICLASS_VPMACSSDQL,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPMACSSDQL_XMMdq_XMMdq_XMMdq_XMMdq,2509,4,0,0,8,XED_EXCEPTION_INVALID),
/*2128*/ XED_DEF_INST(XED_ICLASS_LLWPCB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_LLWPCB_GPRyy,2561,1,0,0,80,XED_EXCEPTION_INVALID),
/*2129*/ XED_DEF_INST(XED_ICLASS_VFRCZSD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZSD_XMMdq_MEMq,2562,2,0,0,117,XED_EXCEPTION_INVALID),
/*2130*/ XED_DEF_INST(XED_ICLASS_VFRCZSD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZSD_XMMdq_XMMq,2564,2,0,0,117,XED_EXCEPTION_INVALID),
/*2131*/ XED_DEF_INST(XED_ICLASS_BEXTR_XOP,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BEXTR_XOP_GPR32d_MEMd_IMMd,2566,4,90,0,8,XED_EXCEPTION_INVALID),
/*2132*/ XED_DEF_INST(XED_ICLASS_BEXTR_XOP,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BEXTR_XOP_GPRyy_MEMy_IMMd,2570,4,90,0,80,XED_EXCEPTION_INVALID),
/*2133*/ XED_DEF_INST(XED_ICLASS_BEXTR_XOP,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BEXTR_XOP_GPR32d_GPR32d_IMMd,2574,4,90,0,8,XED_EXCEPTION_INVALID),
/*2134*/ XED_DEF_INST(XED_ICLASS_BEXTR_XOP,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BEXTR_XOP_GPRyy_GPRyy_IMMd,2578,4,90,0,80,XED_EXCEPTION_INVALID),
/*2135*/ XED_DEF_INST(XED_ICLASS_VPSHAB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAB_XMMdq_MEMdq_XMMdq,2582,3,0,0,8,XED_EXCEPTION_INVALID),
/*2136*/ XED_DEF_INST(XED_ICLASS_VPSHAB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAB_XMMdq_XMMdq_XMMdq,2585,3,0,0,8,XED_EXCEPTION_INVALID),
/*2137*/ XED_DEF_INST(XED_ICLASS_VPSHAB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAB_XMMdq_XMMdq_MEMdq,2588,3,0,0,8,XED_EXCEPTION_INVALID),
/*2138*/ XED_DEF_INST(XED_ICLASS_VPSHAB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHAB_XMMdq_XMMdq_XMMdq,2591,3,0,0,8,XED_EXCEPTION_INVALID),
/*2139*/ XED_DEF_INST(XED_ICLASS_BLCMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCMSK_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2140*/ XED_DEF_INST(XED_ICLASS_BLCMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCMSK_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2141*/ XED_DEF_INST(XED_ICLASS_BLCMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCMSK_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2142*/ XED_DEF_INST(XED_ICLASS_BLCMSK,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCMSK_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2143*/ XED_DEF_INST(XED_ICLASS_BLCI,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCI_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2144*/ XED_DEF_INST(XED_ICLASS_BLCI,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCI_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2145*/ XED_DEF_INST(XED_ICLASS_BLCI,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCI_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2146*/ XED_DEF_INST(XED_ICLASS_BLCI,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLCI_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2147*/ XED_DEF_INST(XED_ICLASS_BLSFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSFILL_VGPR32d_MEMd,2359,3,88,0,8,XED_EXCEPTION_INVALID),
/*2148*/ XED_DEF_INST(XED_ICLASS_BLSFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSFILL_VGPRyy_MEMy,2362,3,88,0,80,XED_EXCEPTION_INVALID),
/*2149*/ XED_DEF_INST(XED_ICLASS_BLSFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSFILL_VGPR32d_GPR32d,2365,3,88,0,8,XED_EXCEPTION_INVALID),
/*2150*/ XED_DEF_INST(XED_ICLASS_BLSFILL,XED_CATEGORY_TBM,XED_EXTENSION_TBM,3,XED_IFORM_BLSFILL_VGPRyy_GPRyy,2368,3,88,0,80,XED_EXCEPTION_INVALID),
/*2151*/ XED_DEF_INST(XED_ICLASS_VPHADDWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDWD_XMMdq_MEMdq,2435,2,0,0,8,XED_EXCEPTION_INVALID),
/*2152*/ XED_DEF_INST(XED_ICLASS_VPHADDWD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDWD_XMMdq_XMMdq,2437,2,0,0,8,XED_EXCEPTION_INVALID),
/*2153*/ XED_DEF_INST(XED_ICLASS_VPCOMUD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUD_XMMdq_XMMdq_MEMdq_IMMb,2594,4,0,0,8,XED_EXCEPTION_INVALID),
/*2154*/ XED_DEF_INST(XED_ICLASS_VPCOMUD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUD_XMMdq_XMMdq_XMMdq_IMMb,2598,4,0,0,8,XED_EXCEPTION_INVALID),
/*2155*/ XED_DEF_INST(XED_ICLASS_VPROTQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTQ_XMMdq_MEMdq_IMMb,2602,3,0,0,8,XED_EXCEPTION_INVALID),
/*2156*/ XED_DEF_INST(XED_ICLASS_VPROTQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTQ_XMMdq_XMMdq_IMMb,2605,3,0,0,8,XED_EXCEPTION_INVALID),
/*2157*/ XED_DEF_INST(XED_ICLASS_VPROTQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTQ_XMMdq_MEMdq_XMMdq,2608,3,0,0,8,XED_EXCEPTION_INVALID),
/*2158*/ XED_DEF_INST(XED_ICLASS_VPROTQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTQ_XMMdq_XMMdq_XMMdq,2611,3,0,0,8,XED_EXCEPTION_INVALID),
/*2159*/ XED_DEF_INST(XED_ICLASS_VPROTQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,8,XED_EXCEPTION_INVALID),
/*2160*/ XED_DEF_INST(XED_ICLASS_VPROTQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,8,XED_EXCEPTION_INVALID),
/*2161*/ XED_DEF_INST(XED_ICLASS_VPCOMUB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUB_XMMdq_XMMdq_MEMdq_IMMb,2620,4,0,0,8,XED_EXCEPTION_INVALID),
/*2162*/ XED_DEF_INST(XED_ICLASS_VPCOMUB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUB_XMMdq_XMMdq_XMMdq_IMMb,2624,4,0,0,8,XED_EXCEPTION_INVALID),
/*2163*/ XED_DEF_INST(XED_ICLASS_VPROTW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTW_XMMdq_MEMdq_IMMb,2163,3,0,0,8,XED_EXCEPTION_INVALID),
/*2164*/ XED_DEF_INST(XED_ICLASS_VPROTW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTW_XMMdq_XMMdq_IMMb,2166,3,0,0,8,XED_EXCEPTION_INVALID),
/*2165*/ XED_DEF_INST(XED_ICLASS_VPROTW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTW_XMMdq_MEMdq_XMMdq,2513,3,0,0,8,XED_EXCEPTION_INVALID),
/*2166*/ XED_DEF_INST(XED_ICLASS_VPROTW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTW_XMMdq_XMMdq_XMMdq,2516,3,0,0,8,XED_EXCEPTION_INVALID),
/*2167*/ XED_DEF_INST(XED_ICLASS_VPROTW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTW_XMMdq_XMMdq_MEMdq,2519,3,0,0,8,XED_EXCEPTION_INVALID),
/*2168*/ XED_DEF_INST(XED_ICLASS_VPROTW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPROTW_XMMdq_XMMdq_XMMdq,2522,3,0,0,8,XED_EXCEPTION_INVALID),
/*2169*/ XED_DEF_INST(XED_ICLASS_VPCOMW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMW_XMMdq_XMMdq_MEMdq_IMMb,2628,4,0,0,8,XED_EXCEPTION_INVALID),
/*2170*/ XED_DEF_INST(XED_ICLASS_VPCOMW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMW_XMMdq_XMMdq_XMMdq_IMMb,2632,4,0,0,8,XED_EXCEPTION_INVALID),
/*2171*/ XED_DEF_INST(XED_ICLASS_VPSHLQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLQ_XMMdq_MEMdq_XMMdq,2608,3,0,0,8,XED_EXCEPTION_INVALID),
/*2172*/ XED_DEF_INST(XED_ICLASS_VPSHLQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLQ_XMMdq_XMMdq_XMMdq,2611,3,0,0,8,XED_EXCEPTION_INVALID),
/*2173*/ XED_DEF_INST(XED_ICLASS_VPSHLQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,8,XED_EXCEPTION_INVALID),
/*2174*/ XED_DEF_INST(XED_ICLASS_VPSHLQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPSHLQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,8,XED_EXCEPTION_INVALID),
/*2175*/ XED_DEF_INST(XED_ICLASS_VPHADDDQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDDQ_XMMdq_MEMdq,2395,2,0,0,8,XED_EXCEPTION_INVALID),
/*2176*/ XED_DEF_INST(XED_ICLASS_VPHADDDQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPHADDDQ_XMMdq_XMMdq,2397,2,0,0,8,XED_EXCEPTION_INVALID),
/*2177*/ XED_DEF_INST(XED_ICLASS_VFRCZPS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPS_XMMdq_MEMdq,2636,2,0,0,116,XED_EXCEPTION_INVALID),
/*2178*/ XED_DEF_INST(XED_ICLASS_VFRCZPS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPS_XMMdq_XMMdq,2638,2,0,0,116,XED_EXCEPTION_INVALID),
/*2179*/ XED_DEF_INST(XED_ICLASS_VFRCZPS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPS_YMMqq_MEMqq,2640,2,0,0,116,XED_EXCEPTION_INVALID),
/*2180*/ XED_DEF_INST(XED_ICLASS_VFRCZPS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZPS_YMMqq_YMMqq,2642,2,0,0,116,XED_EXCEPTION_INVALID),
/*2181*/ XED_DEF_INST(XED_ICLASS_VPCOMUQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUQ_XMMdq_XMMdq_MEMdq_IMMb,2644,4,0,0,8,XED_EXCEPTION_INVALID),
/*2182*/ XED_DEF_INST(XED_ICLASS_VPCOMUQ,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUQ_XMMdq_XMMdq_XMMdq_IMMb,2648,4,0,0,8,XED_EXCEPTION_INVALID),
/*2183*/ XED_DEF_INST(XED_ICLASS_VPCOMB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMB_XMMdq_XMMdq_MEMdq_IMMb,2652,4,0,0,8,XED_EXCEPTION_INVALID),
/*2184*/ XED_DEF_INST(XED_ICLASS_VPCOMB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMB_XMMdq_XMMdq_XMMdq_IMMb,2656,4,0,0,8,XED_EXCEPTION_INVALID),
/*2185*/ XED_DEF_INST(XED_ICLASS_VFRCZSS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZSS_XMMdq_MEMd,2660,2,0,0,117,XED_EXCEPTION_INVALID),
/*2186*/ XED_DEF_INST(XED_ICLASS_VFRCZSS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VFRCZSS_XMMdq_XMMd,2662,2,0,0,117,XED_EXCEPTION_INVALID),
/*2187*/ XED_DEF_INST(XED_ICLASS_VPCOMD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMD_XMMdq_XMMdq_MEMdq_IMMb,2664,4,0,0,8,XED_EXCEPTION_INVALID),
/*2188*/ XED_DEF_INST(XED_ICLASS_VPCOMD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMD_XMMdq_XMMdq_XMMdq_IMMb,2668,4,0,0,8,XED_EXCEPTION_INVALID),
/*2189*/ XED_DEF_INST(XED_ICLASS_VPCOMUW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUW_XMMdq_XMMdq_MEMdq_IMMb,2672,4,0,0,8,XED_EXCEPTION_INVALID),
/*2190*/ XED_DEF_INST(XED_ICLASS_VPCOMUW,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCOMUW_XMMdq_XMMdq_XMMdq_IMMb,2676,4,0,0,8,XED_EXCEPTION_INVALID),
/*2191*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_XMMdq_XMMdq_MEMdq_XMMdq,2680,4,0,0,8,XED_EXCEPTION_INVALID),
/*2192*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_XMMdq_XMMdq_XMMdq_XMMdq,2684,4,0,0,8,XED_EXCEPTION_INVALID),
/*2193*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_XMMdq_XMMdq_XMMdq_MEMdq,2688,4,0,0,8,XED_EXCEPTION_INVALID),
/*2194*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_XMMdq_XMMdq_XMMdq_XMMdq,2692,4,0,0,8,XED_EXCEPTION_INVALID),
/*2195*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_YMMqq_YMMqq_MEMqq_YMMqq,2696,4,0,0,8,XED_EXCEPTION_INVALID),
/*2196*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_YMMqq_YMMqq_YMMqq_YMMqq,2700,4,0,0,8,XED_EXCEPTION_INVALID),
/*2197*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_YMMqq_YMMqq_YMMqq_MEMqq,2704,4,0,0,8,XED_EXCEPTION_INVALID),
/*2198*/ XED_DEF_INST(XED_ICLASS_VPCMOV,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPCMOV_YMMqq_YMMqq_YMMqq_YMMqq,2708,4,0,0,8,XED_EXCEPTION_INVALID),
/*2199*/ XED_DEF_INST(XED_ICLASS_LWPVAL,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_LWPVAL_VGPRyy_MEMd_IMMd,2712,3,0,0,80,XED_EXCEPTION_INVALID),
/*2200*/ XED_DEF_INST(XED_ICLASS_LWPVAL,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_LWPVAL_VGPRyy_GPRyy_IMMd,2715,3,0,0,80,XED_EXCEPTION_INVALID),
/*2201*/ XED_DEF_INST(XED_ICLASS_SLWPCB,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_SLWPCB_GPRyy,2561,1,0,0,80,XED_EXCEPTION_INVALID),
/*2202*/ XED_DEF_INST(XED_ICLASS_VMOVMSKPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVMSKPD_GPR32d_XMMdq,2718,2,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2203*/ XED_DEF_INST(XED_ICLASS_VMOVMSKPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVMSKPD_GPR32d_YMMqq,2720,2,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2204*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSD_XMMdq_MEMq,2562,2,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2205*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSD_XMMdq_XMMdq_XMMq_10,2722,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2206*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSD_MEMq_XMMq,2725,2,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2207*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSD_XMMdq_XMMdq_XMMq_11,2727,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2208*/ XED_DEF_INST(XED_ICLASS_VMOVMSKPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVMSKPS_GPR32d_XMMdq,2730,2,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2209*/ XED_DEF_INST(XED_ICLASS_VMOVMSKPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVMSKPS_GPR32d_YMMqq,2732,2,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2210*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULHUW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2211*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULHUW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2212*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULHUW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2213*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULHUW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2214*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSS_XMMdq_MEMd,2660,2,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2215*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSS_XMMdq_XMMdq_XMMd_10,2740,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2216*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSS_MEMd_XMMd,2743,2,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2217*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSS_XMMdq_XMMdq_XMMd_11,2745,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2218*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2219*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2220*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2221*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2222*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2223*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2224*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2225*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB231PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2226*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULUDQ_XMMdq_XMMdq_MEMdq,2772,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2227*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULUDQ_XMMdq_XMMdq_XMMdq,2775,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2228*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULUDQ_YMMqq_YMMqq_MEMqq,2778,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2229*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULUDQ_YMMqq_YMMqq_YMMqq,2781,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2230*/ XED_DEF_INST(XED_ICLASS_VRCPSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRCPSS_XMMdq_XMMdq_MEMd,2784,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2231*/ XED_DEF_INST(XED_ICLASS_VRCPSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRCPSS_XMMdq_XMMdq_XMMd,2740,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2232*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLDQ_XMMdq_XMMdq_IMMb,2787,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2233*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLDQ_YMMqq_YMMqq_IMMb,2790,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2234*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_XMMdq_MEMq_6E,1666,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2235*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_XMMdq_GPR64q,2793,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2236*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_MEMq_XMMq_7E,1670,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2237*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_GPR64q_XMMq,2795,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2238*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_XMMdq_MEMq_7E,1666,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2239*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_XMMdq_XMMq_7E,1676,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2240*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_MEMq_XMMq_D6,1670,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2241*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVQ_XMMdq_XMMq_D6,1674,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2242*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_XMMdq_MEMd,1979,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2243*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_XMMdq_GPR32d,2797,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2244*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_MEMd_XMMd,1834,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2245*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_GPR32d_XMMd,2799,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2246*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_XMMdq_MEMd,1979,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2247*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_XMMdq_GPR32d,2797,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2248*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_MEMd_XMMd,1834,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2249*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVD_GPR32d_XMMd,2799,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2250*/ XED_DEF_INST(XED_ICLASS_KMOVB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVB_MASKmskw_MASKu8_AVX512,2801,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2251*/ XED_DEF_INST(XED_ICLASS_KMOVB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVB_MASKmskw_MEMu8_AVX512,2803,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2252*/ XED_DEF_INST(XED_ICLASS_KMOVB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVB_MEMu8_MASKmskw_AVX512,2805,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2253*/ XED_DEF_INST(XED_ICLASS_KMOVB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVB_MASKmskw_GPR32u32_AVX512,2807,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2254*/ XED_DEF_INST(XED_ICLASS_KMOVB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVB_GPR32u32_MASKmskw_AVX512,2809,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2255*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULHRSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2256*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULHRSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2257*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULHRSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2258*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULHRSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2259*/ XED_DEF_INST(XED_ICLASS_VPERM2F128,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERM2F128_YMMqq_YMMqq_MEMqq_IMMb,2817,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2260*/ XED_DEF_INST(XED_ICLASS_VPERM2F128,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERM2F128_YMMqq_YMMqq_YMMqq_IMMb,2821,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2261*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2262*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2263*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2264*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2265*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_XMMdq_XMMdq_MEMdq_XMMdq,2825,4,0,0,116,XED_EXCEPTION_INVALID),
/*2266*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_XMMdq_XMMdq_XMMdq_XMMdq,2829,4,0,0,116,XED_EXCEPTION_INVALID),
/*2267*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_XMMdq_XMMdq_XMMdq_MEMdq,2833,4,0,0,116,XED_EXCEPTION_INVALID),
/*2268*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_XMMdq_XMMdq_XMMdq_XMMdq,2837,4,0,0,116,XED_EXCEPTION_INVALID),
/*2269*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_YMMqq_YMMqq_MEMqq_YMMqq,2841,4,0,0,116,XED_EXCEPTION_INVALID),
/*2270*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_YMMqq_YMMqq_YMMqq_YMMqq,2845,4,0,0,116,XED_EXCEPTION_INVALID),
/*2271*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_YMMqq_YMMqq_YMMqq_MEMqq,2849,4,0,0,116,XED_EXCEPTION_INVALID),
/*2272*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPD_YMMqq_YMMqq_YMMqq_YMMqq,2853,4,0,0,116,XED_EXCEPTION_INVALID),
/*2273*/ XED_DEF_INST(XED_ICLASS_VHADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2274*/ XED_DEF_INST(XED_ICLASS_VHADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2275*/ XED_DEF_INST(XED_ICLASS_VHADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2276*/ XED_DEF_INST(XED_ICLASS_VHADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2277*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2278*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2279*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2280*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2281*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLBW_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2282*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLBW_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2283*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLBW_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2284*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLBW_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2285*/ XED_DEF_INST(XED_ICLASS_KXNORQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXNORQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2286*/ XED_DEF_INST(XED_ICLASS_VPERMD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMD_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2287*/ XED_DEF_INST(XED_ICLASS_VPERMD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMD_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2288*/ XED_DEF_INST(XED_ICLASS_KXNORW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXNORW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2289*/ XED_DEF_INST(XED_ICLASS_BLSMSK,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSMSK_VGPR32d_MEMd,2359,3,91,0,0,XED_EXCEPTION_INVALID),
/*2290*/ XED_DEF_INST(XED_ICLASS_BLSMSK,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSMSK_VGPR32d_MEMd,2359,3,91,0,0,XED_EXCEPTION_INVALID),
/*2291*/ XED_DEF_INST(XED_ICLASS_BLSMSK,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSMSK_VGPR32d_VGPR32d,2884,3,91,0,0,XED_EXCEPTION_INVALID),
/*2292*/ XED_DEF_INST(XED_ICLASS_BLSMSK,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSMSK_VGPR32d_VGPR32d,2884,3,91,0,0,XED_EXCEPTION_INVALID),
/*2293*/ XED_DEF_INST(XED_ICLASS_BLSMSK,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSMSK_VGPR64q_MEMq,2887,3,91,0,0,XED_EXCEPTION_INVALID),
/*2294*/ XED_DEF_INST(XED_ICLASS_BLSMSK,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSMSK_VGPR64q_VGPR64q,2890,3,91,0,0,XED_EXCEPTION_INVALID),
/*2295*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPH2PS_XMMdq_MEMq,2893,2,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*2296*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPH2PS_XMMdq_XMMq,2895,2,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*2297*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPH2PS_YMMqq_MEMdq,2897,2,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*2298*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPH2PS_YMMqq_XMMdq,2899,2,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*2299*/ XED_DEF_INST(XED_ICLASS_KXNORB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXNORB_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2300*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMQ_YMMqq_MEMqq_IMMb,2901,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2301*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMQ_YMMqq_YMMqq_IMMb,2904,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2302*/ XED_DEF_INST(XED_ICLASS_KXNORD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXNORD_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2303*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSHDUP_XMMdq_MEMdq,2636,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2304*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSHDUP_XMMdq_XMMdq,2638,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2305*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSHDUP_YMMqq_MEMqq,2640,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2306*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSHDUP_YMMqq_YMMqq,2642,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2307*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2308*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2309*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_XMMdq_XMMdq_MEMdq,2913,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2310*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_XMMdq_XMMdq_XMMdq,2916,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2311*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_YMMqq_YMMqq_MEMqq,2919,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2312*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_YMMqq_YMMqq_YMMqq,2922,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2313*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_XMMdq_MEMdq_IMMb,2925,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2314*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_XMMdq_XMMdq_IMMb,2928,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2315*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_YMMqq_MEMqq_IMMb,2931,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2316*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPS_YMMqq_YMMqq_IMMb,2934,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2317*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXWQ_XMMdq_XMMd,2336,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2318*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXWQ_XMMdq_MEMd,2334,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2319*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXWQ_YMMqq_XMMq,2937,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2320*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXWQ_YMMqq_MEMq,2939,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2321*/ XED_DEF_INST(XED_ICLASS_VGATHERQPD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERQPD_YMMf64_MEMf64_YMMi64_VL256,2941,3,0,0,119,XED_EXCEPTION_AVX_TYPE_12),
/*2322*/ XED_DEF_INST(XED_ICLASS_VGATHERQPD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERQPD_XMMf64_MEMf64_XMMi64_VL128,2944,3,0,0,119,XED_EXCEPTION_AVX_TYPE_12),
/*2323*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2324*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2325*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESDEC_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2326*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESDEC_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2327*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESDEC_YMMu128_YMMu128_YMMu128,2953,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2328*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESDEC_YMMu128_YMMu128_MEMu128,2956,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2329*/ XED_DEF_INST(XED_ICLASS_VGATHERQPS,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERQPS_XMMf32_MEMf32_XMMi32_VL256,2959,3,0,0,120,XED_EXCEPTION_AVX_TYPE_12),
/*2330*/ XED_DEF_INST(XED_ICLASS_VGATHERQPS,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERQPS_XMMf32_MEMf32_XMMi32_VL128,2962,3,0,0,120,XED_EXCEPTION_AVX_TYPE_12),
/*2331*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2332*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2333*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2334*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2335*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2336*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2337*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2338*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2339*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQQ_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2340*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQQ_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2341*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPAVGW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2342*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPAVGW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2343*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPAVGW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2344*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPAVGW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2345*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQD_XMMdq_XMMdq_MEMdq,2461,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2346*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQD_XMMdq_XMMdq_XMMdq,2464,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2347*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQD_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2348*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQD_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2349*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2350*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPEQB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2351*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2352*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPEQB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2353*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEQB_XMMu8_XMMu8_XMMu64_IMM8,2971,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2354*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEQB_XMMu8_XMMu8_MEMu64_IMM8,2975,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2355*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEQB_YMMu8_YMMu8_YMMu64_IMM8,2979,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2356*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEQB_YMMu8_YMMu8_MEMu64_IMM8,2983,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2357*/ XED_DEF_INST(XED_ICLASS_VPAVGB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPAVGB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2358*/ XED_DEF_INST(XED_ICLASS_VPAVGB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPAVGB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2359*/ XED_DEF_INST(XED_ICLASS_VPAVGB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPAVGB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2360*/ XED_DEF_INST(XED_ICLASS_VPAVGB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPAVGB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2361*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXDQ_XMMdq_XMMq,749,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2362*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXDQ_XMMdq_MEMq,747,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2363*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXDQ_YMMqq_XMMdq,2987,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2364*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXDQ_YMMqq_MEMdq,2989,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2365*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXSD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2366*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXSD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2367*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXSD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2368*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXSD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2369*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVQ_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2370*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVQ_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2371*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVQ_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2372*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVQ_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2373*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXSB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2374*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXSB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2375*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXSB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2376*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXSB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2377*/ XED_DEF_INST(XED_ICLASS_VMULSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2378*/ XED_DEF_INST(XED_ICLASS_VMULSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2379*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPD_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2380*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPD_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2381*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPD_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2382*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPD_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2383*/ XED_DEF_INST(XED_ICLASS_KXORQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXORQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2384*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDDUP_XMMdq_MEMq,2562,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2385*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDDUP_XMMdq_XMMdq,2469,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2386*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDDUP_YMMqq_MEMqq,2471,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2387*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDDUP_YMMqq_YMMqq,2473,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2388*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2389*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2390*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2391*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2392*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2393*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2394*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2395*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLVD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2396*/ XED_DEF_INST(XED_ICLASS_SHRX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHRX_VGPR32d_MEMd_VGPR32d,3003,3,0,0,0,XED_EXCEPTION_INVALID),
/*2397*/ XED_DEF_INST(XED_ICLASS_SHRX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHRX_VGPR32d_MEMd_VGPR32d,3003,3,0,0,0,XED_EXCEPTION_INVALID),
/*2398*/ XED_DEF_INST(XED_ICLASS_SHRX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHRX_VGPR32d_VGPR32d_VGPR32d,3006,3,0,0,0,XED_EXCEPTION_INVALID),
/*2399*/ XED_DEF_INST(XED_ICLASS_SHRX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHRX_VGPR32d_VGPR32d_VGPR32d,3006,3,0,0,0,XED_EXCEPTION_INVALID),
/*2400*/ XED_DEF_INST(XED_ICLASS_SHRX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHRX_VGPR64q_MEMq_VGPR64q,3009,3,0,0,0,XED_EXCEPTION_INVALID),
/*2401*/ XED_DEF_INST(XED_ICLASS_SHRX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHRX_VGPR64q_VGPR64q_VGPR64q,3012,3,0,0,0,XED_EXCEPTION_INVALID),
/*2402*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPS_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2403*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPS_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2404*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPS_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2405*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDPS_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2406*/ XED_DEF_INST(XED_ICLASS_KUNPCKDQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KUNPCKDQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2407*/ XED_DEF_INST(XED_ICLASS_VMULSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2408*/ XED_DEF_INST(XED_ICLASS_VMULSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2409*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2410*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2411*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2412*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2413*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLDQ_XMMdq_XMMdq_IMMb,2787,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2414*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLDQ_YMMqq_YMMqq_IMMb,2790,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2415*/ XED_DEF_INST(XED_ICLASS_VFNMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSD_XMMdq_XMMdq_MEMq_XMMdq,3030,4,0,0,117,XED_EXCEPTION_INVALID),
/*2416*/ XED_DEF_INST(XED_ICLASS_VFNMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSD_XMMdq_XMMdq_XMMq_XMMdq,3034,4,0,0,117,XED_EXCEPTION_INVALID),
/*2417*/ XED_DEF_INST(XED_ICLASS_VFNMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSD_XMMdq_XMMdq_XMMdq_MEMq,3038,4,0,0,117,XED_EXCEPTION_INVALID),
/*2418*/ XED_DEF_INST(XED_ICLASS_VFNMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSD_XMMdq_XMMdq_XMMdq_XMMq,3042,4,0,0,117,XED_EXCEPTION_INVALID),
/*2419*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTDQA_XMMdq_MEMdq,470,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*2420*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX2,3,XED_IFORM_VMOVNTDQA_YMMqq_MEMqq,3046,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*2421*/ XED_DEF_INST(XED_ICLASS_VFNMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSS_XMMdq_XMMdq_MEMd_XMMdq,3048,4,0,0,117,XED_EXCEPTION_INVALID),
/*2422*/ XED_DEF_INST(XED_ICLASS_VFNMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSS_XMMdq_XMMdq_XMMd_XMMdq,3052,4,0,0,117,XED_EXCEPTION_INVALID),
/*2423*/ XED_DEF_INST(XED_ICLASS_VFNMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSS_XMMdq_XMMdq_XMMdq_MEMd,3056,4,0,0,117,XED_EXCEPTION_INVALID),
/*2424*/ XED_DEF_INST(XED_ICLASS_VFNMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDSS_XMMdq_XMMdq_XMMdq_XMMd,3060,4,0,0,117,XED_EXCEPTION_INVALID),
/*2425*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFHW_XMMdq_MEMdq_IMMb,933,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2426*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFHW_XMMdq_XMMdq_IMMb,930,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2427*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFHW_YMMqq_MEMqq_IMMb,3064,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2428*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFHW_YMMqq_YMMqq_IMMb,3067,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2429*/ XED_DEF_INST(XED_ICLASS_SARX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SARX_VGPR32d_MEMd_VGPR32d,3003,3,0,0,0,XED_EXCEPTION_INVALID),
/*2430*/ XED_DEF_INST(XED_ICLASS_SARX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SARX_VGPR32d_MEMd_VGPR32d,3003,3,0,0,0,XED_EXCEPTION_INVALID),
/*2431*/ XED_DEF_INST(XED_ICLASS_SARX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SARX_VGPR32d_VGPR32d_VGPR32d,3006,3,0,0,0,XED_EXCEPTION_INVALID),
/*2432*/ XED_DEF_INST(XED_ICLASS_SARX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SARX_VGPR32d_VGPR32d_VGPR32d,3006,3,0,0,0,XED_EXCEPTION_INVALID),
/*2433*/ XED_DEF_INST(XED_ICLASS_SARX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SARX_VGPR64q_MEMq_VGPR64q,3009,3,0,0,0,XED_EXCEPTION_INVALID),
/*2434*/ XED_DEF_INST(XED_ICLASS_SARX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SARX_VGPR64q_VGPR64q_VGPR64q,3012,3,0,0,0,XED_EXCEPTION_INVALID),
/*2435*/ XED_DEF_INST(XED_ICLASS_VMAXSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2436*/ XED_DEF_INST(XED_ICLASS_VMAXSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2437*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_XMMdq_XMMdq_MEMdq_XMMdq_IMMb,3070,5,0,0,8,XED_EXCEPTION_INVALID),
/*2438*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_XMMdq_XMMdq_XMMdq_XMMdq_IMMb,3075,5,0,0,8,XED_EXCEPTION_INVALID),
/*2439*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_YMMqq_YMMqq_MEMqq_YMMqq_IMMb,3080,5,0,0,8,XED_EXCEPTION_INVALID),
/*2440*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_YMMqq_YMMqq_YMMqq_YMMqq_IMMb,3085,5,0,0,8,XED_EXCEPTION_INVALID),
/*2441*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_XMMdq_XMMdq_XMMdq_MEMdq_IMMb,3090,5,0,0,8,XED_EXCEPTION_INVALID),
/*2442*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_XMMdq_XMMdq_XMMdq_XMMdq_IMMb,3095,5,0,0,8,XED_EXCEPTION_INVALID),
/*2443*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_YMMqq_YMMqq_YMMqq_MEMqq_IMMb,3100,5,0,0,8,XED_EXCEPTION_INVALID),
/*2444*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PS,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PS_YMMqq_YMMqq_YMMqq_YMMqq_IMMb,3105,5,0,0,8,XED_EXCEPTION_INVALID),
/*2445*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_XMMdq_XMMdq_MEMdq_XMMdq_IMMb,3110,5,0,0,8,XED_EXCEPTION_INVALID),
/*2446*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_XMMdq_XMMdq_XMMdq_XMMdq_IMMb,3115,5,0,0,8,XED_EXCEPTION_INVALID),
/*2447*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_YMMqq_YMMqq_MEMqq_YMMqq_IMMb,3120,5,0,0,8,XED_EXCEPTION_INVALID),
/*2448*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_YMMqq_YMMqq_YMMqq_YMMqq_IMMb,3125,5,0,0,8,XED_EXCEPTION_INVALID),
/*2449*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_XMMdq_XMMdq_XMMdq_MEMdq_IMMb,3130,5,0,0,8,XED_EXCEPTION_INVALID),
/*2450*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_XMMdq_XMMdq_XMMdq_XMMdq_IMMb,3135,5,0,0,8,XED_EXCEPTION_INVALID),
/*2451*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_YMMqq_YMMqq_YMMqq_MEMqq_IMMb,3140,5,0,0,8,XED_EXCEPTION_INVALID),
/*2452*/ XED_DEF_INST(XED_ICLASS_VPERMIL2PD,XED_CATEGORY_XOP,XED_EXTENSION_XOP,3,XED_IFORM_VPERMIL2PD_YMMqq_YMMqq_YMMqq_YMMqq_IMMb,3145,5,0,0,8,XED_EXCEPTION_INVALID),
/*2453*/ XED_DEF_INST(XED_ICLASS_VMAXSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2454*/ XED_DEF_INST(XED_ICLASS_VMAXSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2455*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINSD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2456*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINSD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2457*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINSD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2458*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINSD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2459*/ XED_DEF_INST(XED_ICLASS_VSTMXCSR,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSTMXCSR_MEMd,2145,2,0,0,106,XED_EXCEPTION_AVX_TYPE_5),
/*2460*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINSB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2461*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINSB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2462*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINSB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2463*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINSB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2464*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2465*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2466*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2467*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2468*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2469*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2470*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2471*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2472*/ XED_DEF_INST(XED_ICLASS_VPTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPTEST_XMMdq_MEMdq,1252,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2473*/ XED_DEF_INST(XED_ICLASS_VPTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPTEST_XMMdq_XMMdq,1255,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2474*/ XED_DEF_INST(XED_ICLASS_VPTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPTEST_YMMqq_MEMqq,3150,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2475*/ XED_DEF_INST(XED_ICLASS_VPTEST,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPTEST_YMMqq_YMMqq,3153,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2476*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2477*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2478*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2479*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2480*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKSSDW_XMMdq_XMMdq_MEMdq,3156,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2481*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKSSDW_XMMdq_XMMdq_XMMdq,3159,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2482*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKSSDW_YMMqq_YMMqq_MEMqq,3162,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2483*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKSSDW_YMMqq_YMMqq_YMMqq,3165,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2484*/ XED_DEF_INST(XED_ICLASS_VPINSRB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRB_XMMdq_XMMdq_MEMb_IMMb,3168,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2485*/ XED_DEF_INST(XED_ICLASS_VPINSRB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRB_XMMdq_XMMdq_GPR32d_IMMb,3172,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2486*/ XED_DEF_INST(XED_ICLASS_VPMAXUB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXUB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2487*/ XED_DEF_INST(XED_ICLASS_VPMAXUB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXUB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2488*/ XED_DEF_INST(XED_ICLASS_VPMAXUB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXUB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2489*/ XED_DEF_INST(XED_ICLASS_VPMAXUB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXUB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2490*/ XED_DEF_INST(XED_ICLASS_VADDSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2491*/ XED_DEF_INST(XED_ICLASS_VADDSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2492*/ XED_DEF_INST(XED_ICLASS_VADDSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2493*/ XED_DEF_INST(XED_ICLASS_VADDSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2494*/ XED_DEF_INST(XED_ICLASS_VPXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPXOR_XMMdq_XMMdq_MEMdq,3176,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2495*/ XED_DEF_INST(XED_ICLASS_VPXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPXOR_XMMdq_XMMdq_XMMdq,3179,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2496*/ XED_DEF_INST(XED_ICLASS_VPXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPXOR_YMMqq_YMMqq_MEMqq,3182,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2497*/ XED_DEF_INST(XED_ICLASS_VPXOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPXOR_YMMqq_YMMqq_YMMqq,3185,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2498*/ XED_DEF_INST(XED_ICLASS_VSQRTSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2499*/ XED_DEF_INST(XED_ICLASS_VSQRTSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2500*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXBQ_XMMdq_XMMw,1777,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2501*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXBQ_XMMdq_MEMw,1775,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2502*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXBQ_YMMqq_XMMd,3188,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2503*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXBQ_YMMqq_MEMd,3190,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2504*/ XED_DEF_INST(XED_ICLASS_VEXTRACTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VEXTRACTPS_MEMd_XMMdq_IMMb,3192,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2505*/ XED_DEF_INST(XED_ICLASS_VEXTRACTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VEXTRACTPS_GPR32_XMMdq_IMMb,3195,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2506*/ XED_DEF_INST(XED_ICLASS_VSQRTSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2507*/ XED_DEF_INST(XED_ICLASS_VSQRTSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2508*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2509*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2510*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2511*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2512*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SD_XMMdq_XMMdq_MEMd,3198,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2513*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SD_XMMdq_XMMdq_XMMd,3201,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2514*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESDECLAST_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2515*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESDECLAST_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2516*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESDECLAST_YMMu128_YMMu128_YMMu128,2953,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2517*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESDECLAST_YMMu128_YMMu128_MEMu128,2956,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2518*/ XED_DEF_INST(XED_ICLASS_VCOMISD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCOMISD_XMMq_MEMq,3204,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2519*/ XED_DEF_INST(XED_ICLASS_VCOMISD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCOMISD_XMMq_XMMq,3207,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2520*/ XED_DEF_INST(XED_ICLASS_VPBLENDVB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPBLENDVB_XMMdq_XMMdq_MEMdq_XMMdq,3210,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2521*/ XED_DEF_INST(XED_ICLASS_VPBLENDVB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPBLENDVB_XMMdq_XMMdq_XMMdq_XMMdq,3214,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2522*/ XED_DEF_INST(XED_ICLASS_VPBLENDVB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDVB_YMMqq_YMMqq_MEMqq_YMMqq,3218,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2523*/ XED_DEF_INST(XED_ICLASS_VPBLENDVB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDVB_YMMqq_YMMqq_YMMqq_YMMqq,3222,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2524*/ XED_DEF_INST(XED_ICLASS_VZEROALL,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VZEROALL,0,0,0,0,121,XED_EXCEPTION_AVX_TYPE_8),
/*2525*/ XED_DEF_INST(XED_ICLASS_BZHI,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_BZHI_VGPR32d_MEMd_VGPR32d,3226,4,94,0,0,XED_EXCEPTION_INVALID),
/*2526*/ XED_DEF_INST(XED_ICLASS_BZHI,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_BZHI_VGPR32d_MEMd_VGPR32d,3226,4,94,0,0,XED_EXCEPTION_INVALID),
/*2527*/ XED_DEF_INST(XED_ICLASS_BZHI,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_BZHI_VGPR32d_VGPR32d_VGPR32d,3230,4,94,0,0,XED_EXCEPTION_INVALID),
/*2528*/ XED_DEF_INST(XED_ICLASS_BZHI,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_BZHI_VGPR32d_VGPR32d_VGPR32d,3230,4,94,0,0,XED_EXCEPTION_INVALID),
/*2529*/ XED_DEF_INST(XED_ICLASS_BZHI,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_BZHI_VGPR64q_MEMq_VGPR64q,3234,4,94,0,0,XED_EXCEPTION_INVALID),
/*2530*/ XED_DEF_INST(XED_ICLASS_BZHI,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_BZHI_VGPR64q_VGPR64q_VGPR64q,3238,4,94,0,0,XED_EXCEPTION_INVALID),
/*2531*/ XED_DEF_INST(XED_ICLASS_VCOMISS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCOMISS_XMMd_MEMd,3242,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2532*/ XED_DEF_INST(XED_ICLASS_VCOMISS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCOMISS_XMMd_XMMd,3245,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2533*/ XED_DEF_INST(XED_ICLASS_PDEP,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PDEP_VGPR32d_VGPR32d_MEMd,3248,3,0,0,0,XED_EXCEPTION_INVALID),
/*2534*/ XED_DEF_INST(XED_ICLASS_PDEP,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PDEP_VGPR32d_VGPR32d_MEMd,3248,3,0,0,0,XED_EXCEPTION_INVALID),
/*2535*/ XED_DEF_INST(XED_ICLASS_PDEP,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PDEP_VGPR32d_VGPR32d_VGPR32d,3251,3,0,0,0,XED_EXCEPTION_INVALID),
/*2536*/ XED_DEF_INST(XED_ICLASS_PDEP,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PDEP_VGPR32d_VGPR32d_VGPR32d,3251,3,0,0,0,XED_EXCEPTION_INVALID),
/*2537*/ XED_DEF_INST(XED_ICLASS_PDEP,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PDEP_VGPR64q_VGPR64q_MEMq,3254,3,0,0,0,XED_EXCEPTION_INVALID),
/*2538*/ XED_DEF_INST(XED_ICLASS_PDEP,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PDEP_VGPR64q_VGPR64q_VGPR64q,3257,3,0,0,0,XED_EXCEPTION_INVALID),
/*2539*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRAD_XMMdq_XMMdq_MEMdq,3260,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2540*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRAD_XMMdq_XMMdq_XMMdq,3263,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2541*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRAD_XMMdq_XMMdq_IMMb,3266,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2542*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAD_YMMqq_YMMqq_MEMdq,3269,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2543*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAD_YMMqq_YMMqq_XMMq,3272,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2544*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAD_YMMqq_YMMqq_IMMb,3275,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2545*/ XED_DEF_INST(XED_ICLASS_VRSQRTSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRSQRTSS_XMMdq_XMMdq_MEMd,2784,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2546*/ XED_DEF_INST(XED_ICLASS_VRSQRTSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRSQRTSS_XMMdq_XMMdq_XMMd,2740,3,0,0,35,XED_EXCEPTION_AVX_TYPE_5),
/*2547*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXBD_XMMdq_XMMd,1754,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2548*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXBD_XMMdq_MEMd,1752,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2549*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXBD_YMMqq_XMMq,3278,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2550*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXBD_YMMqq_MEMq,3280,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2551*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFD_XMMdq_MEMdq_IMMb,933,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2552*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFD_XMMdq_XMMdq_IMMb,930,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2553*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFD_YMMqq_MEMqq_IMMb,3282,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2554*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFD_YMMqq_YMMqq_IMMb,3285,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2555*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRAW_XMMdq_XMMdq_MEMdq,3288,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2556*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRAW_XMMdq_XMMdq_XMMdq,3291,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2557*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRAW_XMMdq_XMMdq_IMMb,3294,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2558*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAW_YMMqq_YMMqq_MEMdq,3297,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2559*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAW_YMMqq_YMMqq_XMMq,3300,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2560*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAW_YMMqq_YMMqq_IMMb,3303,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2561*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2562*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2563*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2564*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2565*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_XMMdq_MEMdq,470,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2566*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_XMMdq_XMMdq_6F,472,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2567*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_MEMdq_XMMdq,1107,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2568*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_XMMdq_XMMdq_7F,1109,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2569*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_YMMqq_MEMqq,3046,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2570*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_YMMqq_YMMqq_6F,3306,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2571*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_MEMqq_YMMqq,3308,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2572*/ XED_DEF_INST(XED_ICLASS_VMOVDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQA_YMMqq_YMMqq_7F,3310,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*2573*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSLDUP_XMMdq_MEMdq,2636,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2574*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSLDUP_XMMdq_XMMdq,2638,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2575*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSLDUP_YMMqq_MEMqq,2640,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2576*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVSLDUP_YMMqq_YMMqq,2642,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2577*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2578*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2579*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2580*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2581*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_XMMdq_MEMdq,470,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2582*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_XMMdq_XMMdq_6F,472,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2583*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_YMMqq_MEMqq,3046,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2584*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_YMMqq_YMMqq_6F,3306,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2585*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_MEMdq_XMMdq,1107,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2586*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_XMMdq_XMMdq_7F,1109,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2587*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_MEMqq_YMMqq,3308,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2588*/ XED_DEF_INST(XED_ICLASS_VMOVDQU,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVDQU_YMMqq_YMMqq_7F,3310,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2589*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2590*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2591*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2592*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2593*/ XED_DEF_INST(XED_ICLASS_VAESIMC,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESIMC_XMMdq_XMMdq,472,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2594*/ XED_DEF_INST(XED_ICLASS_VAESIMC,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESIMC_XMMdq_MEMdq,470,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2595*/ XED_DEF_INST(XED_ICLASS_VCMPSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPSS_XMMdq_XMMdq_MEMd_IMMb,3312,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2596*/ XED_DEF_INST(XED_ICLASS_VCMPSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPSS_XMMdq_XMMdq_XMMd_IMMb,3316,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2597*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFLW_XMMdq_MEMdq_IMMb,933,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2598*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSHUFLW_XMMdq_XMMdq_IMMb,930,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2599*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFLW_YMMqq_MEMqq_IMMb,3064,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2600*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSHUFLW_YMMqq_YMMqq_IMMb,3067,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2601*/ XED_DEF_INST(XED_ICLASS_VLDMXCSR,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VLDMXCSR_MEMd,842,2,0,0,26,XED_EXCEPTION_AVX_TYPE_5L),
/*2602*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2603*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2604*/ XED_DEF_INST(XED_ICLASS_VPSLLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLD_XMMdq_XMMdq_MEMdq,3320,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2605*/ XED_DEF_INST(XED_ICLASS_VPSLLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLD_XMMdq_XMMdq_XMMdq,3323,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2606*/ XED_DEF_INST(XED_ICLASS_VPSLLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLD_XMMdq_XMMdq_IMMb,3326,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2607*/ XED_DEF_INST(XED_ICLASS_VPSLLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLD_YMMqq_YMMqq_MEMdq,3329,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2608*/ XED_DEF_INST(XED_ICLASS_VPSLLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLD_YMMqq_YMMqq_XMMq,3332,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2609*/ XED_DEF_INST(XED_ICLASS_VPSLLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLD_YMMqq_YMMqq_IMMb,3335,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2610*/ XED_DEF_INST(XED_ICLASS_VPMOVMSKB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVMSKB_GPR32d_XMMdq,3338,2,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2611*/ XED_DEF_INST(XED_ICLASS_VPMOVMSKB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVMSKB_GPR32d_YMMqq,3340,2,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2612*/ XED_DEF_INST(XED_ICLASS_VCMPSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPSD_XMMdq_XMMdq_MEMq_IMMb,3342,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2613*/ XED_DEF_INST(XED_ICLASS_VCMPSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPSD_XMMdq_XMMdq_XMMq_IMMb,3346,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2614*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2615*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2616*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLQ_XMMdq_XMMdq_IMMb,3350,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2617*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLQ_YMMqq_YMMqq_MEMdq,3353,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2618*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLQ_YMMqq_YMMqq_XMMq,3356,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2619*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLQ_YMMqq_YMMqq_IMMb,3359,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2620*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2621*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2622*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2623*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2624*/ XED_DEF_INST(XED_ICLASS_VBLENDVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPD_XMMdq_XMMdq_MEMdq_XMMdq,3362,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2625*/ XED_DEF_INST(XED_ICLASS_VBLENDVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPD_XMMdq_XMMdq_XMMdq_XMMdq,3366,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2626*/ XED_DEF_INST(XED_ICLASS_VBLENDVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPD_YMMqq_YMMqq_MEMqq_YMMqq,3370,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2627*/ XED_DEF_INST(XED_ICLASS_VBLENDVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPD_YMMqq_YMMqq_YMMqq_YMMqq,3374,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2628*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLW_XMMdq_XMMdq_MEMdq,3378,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2629*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLW_XMMdq_XMMdq_XMMdq,3381,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2630*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSLLW_XMMdq_XMMdq_IMMb,3384,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2631*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLW_YMMqq_YMMqq_MEMdq,3387,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2632*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLW_YMMqq_YMMqq_XMMq,3390,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2633*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLW_YMMqq_YMMqq_IMMb,3393,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2634*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2635*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB132SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2636*/ XED_DEF_INST(XED_ICLASS_VPAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPAND_XMMdq_XMMdq_MEMdq,3176,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2637*/ XED_DEF_INST(XED_ICLASS_VPAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPAND_XMMdq_XMMdq_XMMdq,3179,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2638*/ XED_DEF_INST(XED_ICLASS_VPAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPAND_YMMqq_YMMqq_MEMqq,3182,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2639*/ XED_DEF_INST(XED_ICLASS_VPAND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPAND_YMMqq_YMMqq_YMMqq,3185,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2640*/ XED_DEF_INST(XED_ICLASS_VPHADDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHADDW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2641*/ XED_DEF_INST(XED_ICLASS_VPHADDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHADDW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2642*/ XED_DEF_INST(XED_ICLASS_VPHADDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHADDW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2643*/ XED_DEF_INST(XED_ICLASS_VPHADDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHADDW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2644*/ XED_DEF_INST(XED_ICLASS_VPANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPANDN_XMMdq_XMMdq_MEMdq,3176,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2645*/ XED_DEF_INST(XED_ICLASS_VPANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPANDN_XMMdq_XMMdq_XMMdq,3179,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2646*/ XED_DEF_INST(XED_ICLASS_VPANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPANDN_YMMqq_YMMqq_MEMqq,3182,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2647*/ XED_DEF_INST(XED_ICLASS_VPANDN,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPANDN_YMMqq_YMMqq_YMMqq,3185,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2648*/ XED_DEF_INST(XED_ICLASS_KORD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORD_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2649*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPD_XMMdq_XMMdq_MEMdq_IMMb,3396,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2650*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPD_XMMdq_XMMdq_XMMdq_IMMb,3400,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2651*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPD_YMMqq_YMMqq_MEMqq_IMMb,2817,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2652*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPD_YMMqq_YMMqq_YMMqq_IMMb,2821,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2653*/ XED_DEF_INST(XED_ICLASS_VSUBSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2654*/ XED_DEF_INST(XED_ICLASS_VSUBSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2655*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPS_XMMdq_MEMdq,2636,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2656*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPS_XMMdq_XMMdq,2638,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2657*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPS_YMMqq_MEMqq,2640,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2658*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPS_YMMqq_YMMqq,2642,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2659*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2DQ_XMMdq_MEMdq,3404,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2660*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2DQ_XMMdq_XMMdq,3406,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2661*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2DQ_YMMqq_MEMqq,3408,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2662*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2DQ_YMMqq_YMMqq,3410,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2663*/ XED_DEF_INST(XED_ICLASS_VPHADDD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHADDD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2664*/ XED_DEF_INST(XED_ICLASS_VPHADDD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHADDD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2665*/ XED_DEF_INST(XED_ICLASS_VPHADDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHADDD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2666*/ XED_DEF_INST(XED_ICLASS_VPHADDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHADDD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2667*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPD_XMMdq_MEMdq,2467,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2668*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPD_XMMdq_XMMdq,2469,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2669*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPD_YMMqq_MEMqq,2471,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2670*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSQRTPD_YMMqq_YMMqq,2473,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2671*/ XED_DEF_INST(XED_ICLASS_VSUBSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2672*/ XED_DEF_INST(XED_ICLASS_VSUBSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2673*/ XED_DEF_INST(XED_ICLASS_KORQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2674*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPS_XMMdq_XMMdq_MEMdq_IMMb,3412,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2675*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPS_XMMdq_XMMdq_XMMdq_IMMb,3416,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2676*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPS_YMMqq_YMMqq_MEMqq_IMMb,3420,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2677*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSHUFPS_YMMqq_YMMqq_YMMqq_IMMb,3424,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2678*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2679*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2680*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2681*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2682*/ XED_DEF_INST(XED_ICLASS_VLDDQU,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VLDDQU_XMMdq_MEMdq,470,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2683*/ XED_DEF_INST(XED_ICLASS_VLDDQU,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VLDDQU_YMMqq_MEMqq,3046,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2684*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_MASKmskw_MASKu32_AVX512,3428,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2685*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_MASKmskw_MEMu32_AVX512,3430,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2686*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_MEMu32_MASKmskw_AVX512,3432,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2687*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_MASKmskw_GPR32u32_AVX512,2807,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2688*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_MASKmskw_GPR32u32_AVX512,2807,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2689*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_GPR32u32_MASKmskw_AVX512,2809,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2690*/ XED_DEF_INST(XED_ICLASS_KMOVD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVD_GPR32u32_MASKmskw_AVX512,2809,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2691*/ XED_DEF_INST(XED_ICLASS_KMOVQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVQ_MASKmskw_MASKu64_AVX512,3434,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2692*/ XED_DEF_INST(XED_ICLASS_KMOVQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVQ_MASKmskw_MEMu64_AVX512,3436,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2693*/ XED_DEF_INST(XED_ICLASS_KMOVQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVQ_MEMu64_MASKmskw_AVX512,3438,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2694*/ XED_DEF_INST(XED_ICLASS_KMOVQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVQ_MASKmskw_GPR64u64_AVX512,3440,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2695*/ XED_DEF_INST(XED_ICLASS_KMOVQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVQ_GPR64u64_MASKmskw_AVX512,3442,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2696*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2697*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2698*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2699*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2700*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2701*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2702*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2703*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD213PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2704*/ XED_DEF_INST(XED_ICLASS_KMOVW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVW_MASKmskw_MASKu16_AVX512,3444,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2705*/ XED_DEF_INST(XED_ICLASS_KMOVW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVW_MASKmskw_MEMu16_AVX512,3446,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2706*/ XED_DEF_INST(XED_ICLASS_KMOVW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVW_MEMu16_MASKmskw_AVX512,3448,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2707*/ XED_DEF_INST(XED_ICLASS_KMOVW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVW_MASKmskw_GPR32u32_AVX512,2807,2,0,0,118,XED_EXCEPTION_AVX512_K21),
/*2708*/ XED_DEF_INST(XED_ICLASS_KMOVW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KMOVW_GPR32u32_MASKmskw_AVX512,2809,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2709*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULDQ_XMMdq_XMMdq_MEMdq,3450,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2710*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULDQ_XMMdq_XMMdq_XMMdq,3453,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2711*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULDQ_YMMqq_YMMqq_MEMqq,3456,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2712*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULDQ_YMMqq_YMMqq_YMMqq,3459,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2713*/ XED_DEF_INST(XED_ICLASS_VDPPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDPPD_XMMdq_XMMdq_MEMdq_IMMb,3396,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2D),
/*2714*/ XED_DEF_INST(XED_ICLASS_VDPPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDPPD_XMMdq_XMMdq_XMMdq_IMMb,3400,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2D),
/*2715*/ XED_DEF_INST(XED_ICLASS_VGATHERDPS,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERDPS_YMMf32_MEMf32_YMMi32_VL256,3462,3,0,0,122,XED_EXCEPTION_AVX_TYPE_12),
/*2716*/ XED_DEF_INST(XED_ICLASS_VGATHERDPS,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERDPS_XMMf32_MEMf32_XMMi32_VL128,2959,3,0,0,122,XED_EXCEPTION_AVX_TYPE_12),
/*2717*/ XED_DEF_INST(XED_ICLASS_VPGATHERQD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERQD_XMMu32_MEMd_XMMi32_VL256,3465,3,0,0,120,XED_EXCEPTION_AVX_TYPE_12),
/*2718*/ XED_DEF_INST(XED_ICLASS_VPGATHERQD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERQD_XMMu32_MEMd_XMMi32_VL128,3468,3,0,0,120,XED_EXCEPTION_AVX_TYPE_12),
/*2719*/ XED_DEF_INST(XED_ICLASS_KSHIFTRQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTRQ_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2720*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESENC_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2721*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESENC_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2722*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESENC_YMMu128_YMMu128_YMMu128,2953,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2723*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESENC_YMMu128_YMMu128_MEMu128,2956,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2724*/ XED_DEF_INST(XED_ICLASS_VMOVLPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVLPD_XMMdq_XMMdq_MEMq,3015,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2725*/ XED_DEF_INST(XED_ICLASS_VMOVLPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVLPD_MEMq_XMMq,2725,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2726*/ XED_DEF_INST(XED_ICLASS_VGATHERDPD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERDPD_YMMf64_MEMf64_YMMi64_VL256,2941,3,0,0,123,XED_EXCEPTION_AVX_TYPE_12),
/*2727*/ XED_DEF_INST(XED_ICLASS_VGATHERDPD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VGATHERDPD_XMMf64_MEMf64_XMMi64_VL128,2944,3,0,0,123,XED_EXCEPTION_AVX_TYPE_12),
/*2728*/ XED_DEF_INST(XED_ICLASS_VDPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDPPS_XMMdq_XMMdq_MEMdq_IMMb,3412,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2D),
/*2729*/ XED_DEF_INST(XED_ICLASS_VDPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDPPS_XMMdq_XMMdq_XMMdq_IMMb,3416,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2D),
/*2730*/ XED_DEF_INST(XED_ICLASS_VDPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDPPS_YMMqq_YMMqq_MEMqq_IMMb,3420,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2D),
/*2731*/ XED_DEF_INST(XED_ICLASS_VDPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDPPS_YMMqq_YMMqq_YMMqq_IMMb,3424,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2D),
/*2732*/ XED_DEF_INST(XED_ICLASS_VMOVLHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVLHPS_XMMdq_XMMq_XMMq,3474,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*2733*/ XED_DEF_INST(XED_ICLASS_VMOVLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVLPS_XMMdq_XMMdq_MEMq,3477,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2734*/ XED_DEF_INST(XED_ICLASS_VMOVLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVLPS_MEMq_XMMq,3480,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2735*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHDQ_XMMdq_XMMdq_MEMdq,2461,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2736*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHDQ_XMMdq_XMMdq_XMMdq,2464,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2737*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHDQ_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2738*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHDQ_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2739*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2DQ_XMMdq_MEMdq,3482,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2740*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2DQ_XMMdq_XMMdq,3484,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2741*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2DQ_XMMdq_MEMqq,3486,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2742*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2DQ_XMMdq_YMMqq,3488,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2743*/ XED_DEF_INST(XED_ICLASS_VPGATHERQQ,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERQQ_YMMu64_MEMq_YMMi64_VL256,3490,3,0,0,119,XED_EXCEPTION_AVX_TYPE_12),
/*2744*/ XED_DEF_INST(XED_ICLASS_VPGATHERQQ,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERQQ_XMMu64_MEMq_XMMi64_VL128,3493,3,0,0,119,XED_EXCEPTION_AVX_TYPE_12),
/*2745*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSS2SI_GPR32d_MEMd,3496,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2746*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSS2SI_GPR32d_XMMd,3498,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2747*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSS2SI_GPR32d_MEMd,3496,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2748*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSS2SI_GPR32d_XMMd,3498,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2749*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSS2SI_GPR64q_MEMd,3500,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2750*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSS2SI_GPR64q_XMMd,3502,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2751*/ XED_DEF_INST(XED_ICLASS_VFMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2752*/ XED_DEF_INST(XED_ICLASS_VFMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2753*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEINVQB_XMMu8_XMMu8_XMMu64_IMM8,2971,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2754*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEINVQB_XMMu8_XMMu8_MEMu64_IMM8,2975,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2755*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEINVQB_YMMu8_YMMu8_YMMu64_IMM8,2979,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2756*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8AFFINEINVQB_YMMu8_YMMu8_MEMu64_IMM8,2983,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2757*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2758*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2759*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2760*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMULPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2761*/ XED_DEF_INST(XED_ICLASS_VFMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2762*/ XED_DEF_INST(XED_ICLASS_VFMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2763*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXBD_XMMdq_XMMd,238,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2764*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXBD_XMMdq_MEMd,236,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2765*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXBD_YMMqq_XMMq,3504,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2766*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXBD_YMMqq_MEMq,3506,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2767*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXBW_XMMdq_XMMq,1340,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2768*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXBW_XMMdq_MEMq,1338,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2769*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXBW_YMMqq_XMMdq,3508,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2770*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXBW_YMMqq_MEMdq,3510,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2771*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXBQ_XMMdq_XMMw,230,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2772*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXBQ_XMMdq_MEMw,228,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2773*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXBQ_YMMqq_XMMd,3512,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2774*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXBQ_YMMqq_MEMd,3514,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2775*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2776*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2777*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2778*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2779*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPD_XMMdq_XMMdq_MEMdq,3516,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*2780*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPD_YMMqq_YMMqq_MEMqq,3519,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*2781*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPD_MEMdq_XMMdq_XMMdq,3522,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*2782*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPD_MEMqq_YMMqq_YMMqq,3525,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*2783*/ XED_DEF_INST(XED_ICLASS_VINSERTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VINSERTPS_XMMdq_XMMdq_MEMd_IMMb,3312,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2784*/ XED_DEF_INST(XED_ICLASS_VINSERTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VINSERTPS_XMMdq_XMMdq_XMMdq_IMMb,3416,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*2785*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPALIGNR_XMMdq_XMMdq_MEMdq_IMMb,2620,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2786*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPALIGNR_XMMdq_XMMdq_XMMdq_IMMb,2624,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2787*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPALIGNR_YMMqq_YMMqq_MEMqq_IMMb,3528,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2788*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPALIGNR_YMMqq_YMMqq_YMMqq_IMMb,3532,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2789*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPS_XMMdq_XMMdq_MEMdq,3536,3,0,0,125,XED_EXCEPTION_AVX_TYPE_6),
/*2790*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPS_YMMqq_YMMqq_MEMqq,3539,3,0,0,125,XED_EXCEPTION_AVX_TYPE_6),
/*2791*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPS_MEMdq_XMMdq_XMMdq,3542,3,0,0,125,XED_EXCEPTION_AVX_TYPE_6),
/*2792*/ XED_DEF_INST(XED_ICLASS_VMASKMOVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVPS_MEMqq_YMMqq_YMMqq,3545,3,0,0,125,XED_EXCEPTION_AVX_TYPE_6),
/*2793*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDSB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2794*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDSB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2795*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDSB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2796*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDSB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2797*/ XED_DEF_INST(XED_ICLASS_KORTESTW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORTESTW_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*2798*/ XED_DEF_INST(XED_ICLASS_KORTESTQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORTESTQ_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*2799*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2800*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2801*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2802*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2803*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKUSWB_XMMdq_XMMdq_MEMdq,3551,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2804*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKUSWB_XMMdq_XMMdq_XMMdq,3554,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2805*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKUSWB_YMMqq_YMMqq_MEMqq,3557,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2806*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKUSWB_YMMqq_YMMqq_YMMqq,3560,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2807*/ XED_DEF_INST(XED_ICLASS_KORTESTD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORTESTD_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*2808*/ XED_DEF_INST(XED_ICLASS_KORTESTB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORTESTB_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*2809*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2810*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2811*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2812*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMAXPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2813*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHQDQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2814*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHQDQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2815*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHQDQ_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2816*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHQDQ_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2817*/ XED_DEF_INST(XED_ICLASS_VPSIGNW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSIGNW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2818*/ XED_DEF_INST(XED_ICLASS_VPSIGNW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSIGNW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2819*/ XED_DEF_INST(XED_ICLASS_VPSIGNW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSIGNW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2820*/ XED_DEF_INST(XED_ICLASS_VPSIGNW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSIGNW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2821*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2822*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2823*/ XED_DEF_INST(XED_ICLASS_KANDNB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDNB_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2824*/ XED_DEF_INST(XED_ICLASS_KADDW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KADDW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2825*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2826*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2827*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2828*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2829*/ XED_DEF_INST(XED_ICLASS_KADDQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KADDQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2830*/ XED_DEF_INST(XED_ICLASS_KANDB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDB_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2831*/ XED_DEF_INST(XED_ICLASS_KANDND,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDND_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2832*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2833*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB213SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2834*/ XED_DEF_INST(XED_ICLASS_VPSIGNB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSIGNB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2835*/ XED_DEF_INST(XED_ICLASS_VPSIGNB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSIGNB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2836*/ XED_DEF_INST(XED_ICLASS_VPSIGNB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSIGNB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2837*/ XED_DEF_INST(XED_ICLASS_VPSIGNB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSIGNB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2838*/ XED_DEF_INST(XED_ICLASS_KANDW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2839*/ XED_DEF_INST(XED_ICLASS_KADDD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KADDD_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2840*/ XED_DEF_INST(XED_ICLASS_KANDNQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDNQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2841*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2842*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2843*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2844*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2845*/ XED_DEF_INST(XED_ICLASS_KANDNW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDNW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2846*/ XED_DEF_INST(XED_ICLASS_KANDQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDQ_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2847*/ XED_DEF_INST(XED_ICLASS_KADDB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KADDB_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2848*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESENCLAST_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2849*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESENCLAST_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2850*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESENCLAST_YMMu128_YMMu128_YMMu128,2953,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2851*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_VAES,3,XED_IFORM_VAESENCLAST_YMMu128_YMMu128_MEMu128,2956,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2852*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2853*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2854*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2855*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKHPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2856*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDUSW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2857*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDUSW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2858*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDUSW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2859*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDUSW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2860*/ XED_DEF_INST(XED_ICLASS_KTESTW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KTESTW_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*2861*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLWD_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2862*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLWD_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2863*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLWD_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2864*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLWD_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2865*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDUSB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2866*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDUSB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2867*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDUSB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2868*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDUSB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2869*/ XED_DEF_INST(XED_ICLASS_VPSIGND,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSIGND_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2870*/ XED_DEF_INST(XED_ICLASS_VPSIGND,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSIGND_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2871*/ XED_DEF_INST(XED_ICLASS_VPSIGND,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSIGND_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2872*/ XED_DEF_INST(XED_ICLASS_VPSIGND,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSIGND_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2873*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTD_XMMdq_MEMd,3563,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2874*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTD_XMMdq_XMMd,3565,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2875*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTD_YMMqq_MEMd,3567,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2876*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTD_YMMqq_XMMd,3569,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2877*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2878*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2879*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2880*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2881*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTB_XMMdq_MEMb,3571,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2882*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTB_XMMdq_XMMb,3573,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2883*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTB_YMMqq_MEMb,3575,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2884*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTB_YMMqq_XMMb,3577,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2885*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULHW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2886*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULHW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2887*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULHW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2888*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULHW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2889*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPD_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2890*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPD_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2891*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPD_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2892*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPD_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2893*/ XED_DEF_INST(XED_ICLASS_VROUNDSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDSD_XMMdq_XMMdq_MEMq_IMMb,3342,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2894*/ XED_DEF_INST(XED_ICLASS_VROUNDSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDSD_XMMdq_XMMdq_XMMq_IMMb,3346,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2895*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTW_XMMdq_MEMw,3579,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2896*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTW_XMMdq_XMMw,3581,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2897*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTW_YMMqq_MEMw,3583,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2898*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTW_YMMqq_XMMw,3585,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2899*/ XED_DEF_INST(XED_ICLASS_VFMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2900*/ XED_DEF_INST(XED_ICLASS_VFMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2901*/ XED_DEF_INST(XED_ICLASS_VFMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2902*/ XED_DEF_INST(XED_ICLASS_VFMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD231PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2903*/ XED_DEF_INST(XED_ICLASS_KTESTQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KTESTQ_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*2904*/ XED_DEF_INST(XED_ICLASS_VROUNDSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDSS_XMMdq_XMMdq_MEMd_IMMb,3312,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2905*/ XED_DEF_INST(XED_ICLASS_VROUNDSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDSS_XMMdq_XMMdq_XMMd_IMMb,3316,4,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2906*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMADDUBSW_XMMdq_XMMdq_MEMdq,3587,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2907*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMADDUBSW_XMMdq_XMMdq_XMMdq,3590,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2908*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMADDUBSW_YMMqq_YMMqq_MEMqq,3593,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2909*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMADDUBSW_YMMqq_YMMqq_YMMqq,3596,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2910*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPS_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2911*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPS_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2912*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPS_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2913*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VXORPS_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2914*/ XED_DEF_INST(XED_ICLASS_VINSERTF128,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VINSERTF128_YMMqq_YMMqq_MEMdq_IMMb,3599,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2915*/ XED_DEF_INST(XED_ICLASS_VINSERTF128,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VINSERTF128_YMMqq_YMMqq_XMMdq_IMMb,3603,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*2916*/ XED_DEF_INST(XED_ICLASS_VFMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2917*/ XED_DEF_INST(XED_ICLASS_VFMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2918*/ XED_DEF_INST(XED_ICLASS_VHSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2919*/ XED_DEF_INST(XED_ICLASS_VHSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2920*/ XED_DEF_INST(XED_ICLASS_VHSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2921*/ XED_DEF_INST(XED_ICLASS_VHSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2922*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_XMMdq_MEMdq,2636,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2923*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_XMMdq_XMMdq_10,2638,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2924*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_MEMdq_XMMdq,3607,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2925*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_XMMdq_XMMdq_11,3609,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2926*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_YMMqq_MEMqq,2640,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2927*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_YMMqq_YMMqq_10,2642,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2928*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_MEMqq_YMMqq,3611,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2929*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPS_YMMqq_YMMqq_11,3613,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2930*/ XED_DEF_INST(XED_ICLASS_VHSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2931*/ XED_DEF_INST(XED_ICLASS_VHSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2932*/ XED_DEF_INST(XED_ICLASS_VHSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2933*/ XED_DEF_INST(XED_ICLASS_VHSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHSUBPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2934*/ XED_DEF_INST(XED_ICLASS_VFMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2935*/ XED_DEF_INST(XED_ICLASS_VFMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2936*/ XED_DEF_INST(XED_ICLASS_VHADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2937*/ XED_DEF_INST(XED_ICLASS_VHADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2938*/ XED_DEF_INST(XED_ICLASS_VHADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2939*/ XED_DEF_INST(XED_ICLASS_VHADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VHADDPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2940*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_XMMdq_MEMdq,2467,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2941*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_XMMdq_XMMdq_10,2469,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2942*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_MEMdq_XMMdq,3615,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2943*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_XMMdq_XMMdq_11,3617,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2944*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_YMMqq_MEMqq,2471,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2945*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_YMMqq_YMMqq_10,2473,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2946*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_MEMqq_YMMqq,3619,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2947*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVUPD_YMMqq_YMMqq_11,3621,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4M),
/*2948*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAVD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2949*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAVD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2950*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAVD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2951*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRAVD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2952*/ XED_DEF_INST(XED_ICLASS_KNOTQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KNOTQ_MASKmskw_MASKmskw_AVX512,3623,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2953*/ XED_DEF_INST(XED_ICLASS_KNOTW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KNOTW_MASKmskw_MASKmskw_AVX512,3623,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2954*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPS2DQ_XMMdq_MEMdq,3404,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2955*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPS2DQ_XMMdq_XMMdq,3406,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2956*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPS2DQ_YMMqq_MEMqq,3408,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2957*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPS2DQ_YMMqq_YMMqq,3410,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2958*/ XED_DEF_INST(XED_ICLASS_KNOTB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KNOTB_MASKmskw_MASKmskw_AVX512,3623,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2959*/ XED_DEF_INST(XED_ICLASS_KNOTD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KNOTD_MASKmskw_MASKmskw_AVX512,3623,2,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2960*/ XED_DEF_INST(XED_ICLASS_VTESTPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPD_XMMdq_MEMdq,3625,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2961*/ XED_DEF_INST(XED_ICLASS_VTESTPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPD_XMMdq_XMMdq,3628,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2962*/ XED_DEF_INST(XED_ICLASS_VTESTPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPD_YMMqq_MEMqq,3631,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2963*/ XED_DEF_INST(XED_ICLASS_VTESTPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPD_YMMqq_YMMqq,3634,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2964*/ XED_DEF_INST(XED_ICLASS_VDIVSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2965*/ XED_DEF_INST(XED_ICLASS_VDIVSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2966*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_XMMdq_XMMdq_MEMdq_XMMdq,3637,4,0,0,116,XED_EXCEPTION_INVALID),
/*2967*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_XMMdq_XMMdq_XMMdq_XMMdq,3641,4,0,0,116,XED_EXCEPTION_INVALID),
/*2968*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_XMMdq_XMMdq_XMMdq_MEMdq,3645,4,0,0,116,XED_EXCEPTION_INVALID),
/*2969*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_XMMdq_XMMdq_XMMdq_XMMdq,3649,4,0,0,116,XED_EXCEPTION_INVALID),
/*2970*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_YMMqq_YMMqq_MEMqq_YMMqq,3653,4,0,0,116,XED_EXCEPTION_INVALID),
/*2971*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_YMMqq_YMMqq_YMMqq_YMMqq,3657,4,0,0,116,XED_EXCEPTION_INVALID),
/*2972*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_YMMqq_YMMqq_YMMqq_MEMqq,3661,4,0,0,116,XED_EXCEPTION_INVALID),
/*2973*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPS_YMMqq_YMMqq_YMMqq_YMMqq,3665,4,0,0,116,XED_EXCEPTION_INVALID),
/*2974*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2975*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2976*/ XED_DEF_INST(XED_ICLASS_VDIVSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2977*/ XED_DEF_INST(XED_ICLASS_VDIVSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VDIVSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2978*/ XED_DEF_INST(XED_ICLASS_KUNPCKWD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KUNPCKWD_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*2979*/ XED_DEF_INST(XED_ICLASS_VTESTPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPS_XMMdq_MEMdq,3669,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2980*/ XED_DEF_INST(XED_ICLASS_VTESTPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPS_XMMdq_XMMdq,3672,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2981*/ XED_DEF_INST(XED_ICLASS_VTESTPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPS_YMMqq_MEMqq,3675,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2982*/ XED_DEF_INST(XED_ICLASS_VTESTPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VTESTPS_YMMqq_YMMqq,3678,3,92,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*2983*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTDQ_MEMdq_XMMdq,1107,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*2984*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTDQ_MEMqq_YMMqq,3308,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*2985*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2986*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*2987*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_XMMdq_XMMdq_MEMdq_XMMdq,2825,4,0,0,116,XED_EXCEPTION_INVALID),
/*2988*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_XMMdq_XMMdq_XMMdq_XMMdq,2829,4,0,0,116,XED_EXCEPTION_INVALID),
/*2989*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_XMMdq_XMMdq_XMMdq_MEMdq,2833,4,0,0,116,XED_EXCEPTION_INVALID),
/*2990*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_XMMdq_XMMdq_XMMdq_XMMdq,2837,4,0,0,116,XED_EXCEPTION_INVALID),
/*2991*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_YMMqq_YMMqq_MEMqq_YMMqq,2841,4,0,0,116,XED_EXCEPTION_INVALID),
/*2992*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_YMMqq_YMMqq_YMMqq_YMMqq,2845,4,0,0,116,XED_EXCEPTION_INVALID),
/*2993*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_YMMqq_YMMqq_YMMqq_MEMqq,2849,4,0,0,116,XED_EXCEPTION_INVALID),
/*2994*/ XED_DEF_INST(XED_ICLASS_VFNMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBPD_YMMqq_YMMqq_YMMqq_YMMqq,2853,4,0,0,116,XED_EXCEPTION_INVALID),
/*2995*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPS_XMMdq_XMMdq_MEMdq_IMMb,3412,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2996*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPS_XMMdq_XMMdq_XMMdq_IMMb,3416,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2997*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPS_YMMqq_YMMqq_MEMqq_IMMb,3420,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2998*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPS_YMMqq_YMMqq_YMMqq_IMMb,3424,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*2999*/ XED_DEF_INST(XED_ICLASS_VADDSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3000*/ XED_DEF_INST(XED_ICLASS_VADDSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3001*/ XED_DEF_INST(XED_ICLASS_VADDSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3002*/ XED_DEF_INST(XED_ICLASS_VADDSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSUBPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3003*/ XED_DEF_INST(XED_ICLASS_RORX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_RORX_VGPR32d_VGPR32d_IMMb,3681,3,0,0,0,XED_EXCEPTION_INVALID),
/*3004*/ XED_DEF_INST(XED_ICLASS_RORX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_RORX_VGPR32d_VGPR32d_IMMb,3681,3,0,0,0,XED_EXCEPTION_INVALID),
/*3005*/ XED_DEF_INST(XED_ICLASS_RORX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_RORX_VGPR32d_MEMd_IMMb,3684,3,0,0,0,XED_EXCEPTION_INVALID),
/*3006*/ XED_DEF_INST(XED_ICLASS_RORX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_RORX_VGPR32d_MEMd_IMMb,3684,3,0,0,0,XED_EXCEPTION_INVALID),
/*3007*/ XED_DEF_INST(XED_ICLASS_RORX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_RORX_VGPR64q_VGPR64q_IMMb,3687,3,0,0,0,XED_EXCEPTION_INVALID),
/*3008*/ XED_DEF_INST(XED_ICLASS_RORX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_RORX_VGPR64q_MEMq_IMMb,3690,3,0,0,0,XED_EXCEPTION_INVALID),
/*3009*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPD_XMMdq_XMMdq_MEMdq_IMMb,3396,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3010*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPD_XMMdq_XMMdq_XMMdq_IMMb,3400,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3011*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPD_YMMqq_YMMqq_MEMqq_IMMb,2817,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3012*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VCMPPD_YMMqq_YMMqq_YMMqq_IMMb,2821,4,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3013*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_XMMdq_XMMdq_MEMdq_XMMdq,3637,4,0,0,116,XED_EXCEPTION_INVALID),
/*3014*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_XMMdq_XMMdq_XMMdq_XMMdq,3641,4,0,0,116,XED_EXCEPTION_INVALID),
/*3015*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_XMMdq_XMMdq_XMMdq_MEMdq,3645,4,0,0,116,XED_EXCEPTION_INVALID),
/*3016*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_XMMdq_XMMdq_XMMdq_XMMdq,3649,4,0,0,116,XED_EXCEPTION_INVALID),
/*3017*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_YMMqq_YMMqq_MEMqq_YMMqq,3653,4,0,0,116,XED_EXCEPTION_INVALID),
/*3018*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_YMMqq_YMMqq_YMMqq_YMMqq,3657,4,0,0,116,XED_EXCEPTION_INVALID),
/*3019*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_YMMqq_YMMqq_YMMqq_MEMqq,3661,4,0,0,116,XED_EXCEPTION_INVALID),
/*3020*/ XED_DEF_INST(XED_ICLASS_VFMADDSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSUBPS_YMMqq_YMMqq_YMMqq_YMMqq,3665,4,0,0,116,XED_EXCEPTION_INVALID),
/*3021*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3022*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3023*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3024*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3025*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SI_GPR32d_MEMd,3496,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3026*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SI_GPR32d_XMMd,3498,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3027*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SI_GPR32d_MEMd,3496,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3028*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SI_GPR32d_XMMd,3498,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3029*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SI_GPR64q_MEMd,3500,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3030*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSS2SI_GPR64q_XMMd,3502,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3031*/ XED_DEF_INST(XED_ICLASS_VMINSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3032*/ XED_DEF_INST(XED_ICLASS_VMINSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3033*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPABSW_XMMdq_MEMdq,3693,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3034*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPABSW_XMMdq_XMMdq,3695,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3035*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPABSW_YMMqq_MEMqq,3697,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3036*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPABSW_YMMqq_YMMqq,3699,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3037*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3038*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3039*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3040*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VSUBPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3041*/ XED_DEF_INST(XED_ICLASS_VPHADDSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHADDSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3042*/ XED_DEF_INST(XED_ICLASS_VPHADDSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHADDSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3043*/ XED_DEF_INST(XED_ICLASS_VPHADDSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHADDSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3044*/ XED_DEF_INST(XED_ICLASS_VPHADDSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHADDSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3045*/ XED_DEF_INST(XED_ICLASS_VMINSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3046*/ XED_DEF_INST(XED_ICLASS_VMINSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3047*/ XED_DEF_INST(XED_ICLASS_VFMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSS_XMMdq_XMMdq_MEMd_XMMdq,3048,4,0,0,117,XED_EXCEPTION_INVALID),
/*3048*/ XED_DEF_INST(XED_ICLASS_VFMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSS_XMMdq_XMMdq_XMMd_XMMdq,3052,4,0,0,117,XED_EXCEPTION_INVALID),
/*3049*/ XED_DEF_INST(XED_ICLASS_VFMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSS_XMMdq_XMMdq_XMMdq_MEMd,3056,4,0,0,117,XED_EXCEPTION_INVALID),
/*3050*/ XED_DEF_INST(XED_ICLASS_VFMADDSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSS_XMMdq_XMMdq_XMMdq_XMMd,3060,4,0,0,117,XED_EXCEPTION_INVALID),
/*3051*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBUSB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3052*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBUSB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3053*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBUSB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3054*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBUSB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3055*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3056*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3057*/ XED_DEF_INST(XED_ICLASS_VFMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSD_XMMdq_XMMdq_MEMq_XMMdq,3030,4,0,0,117,XED_EXCEPTION_INVALID),
/*3058*/ XED_DEF_INST(XED_ICLASS_VFMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSD_XMMdq_XMMdq_XMMq_XMMdq,3034,4,0,0,117,XED_EXCEPTION_INVALID),
/*3059*/ XED_DEF_INST(XED_ICLASS_VFMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSD_XMMdq_XMMdq_XMMdq_MEMq,3038,4,0,0,117,XED_EXCEPTION_INVALID),
/*3060*/ XED_DEF_INST(XED_ICLASS_VFMADDSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDSD_XMMdq_XMMdq_XMMdq_XMMq,3042,4,0,0,117,XED_EXCEPTION_INVALID),
/*3061*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3062*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3063*/ XED_DEF_INST(XED_ICLASS_VBLENDVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPS_XMMdq_XMMdq_MEMdq_XMMdq,3701,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3064*/ XED_DEF_INST(XED_ICLASS_VBLENDVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPS_XMMdq_XMMdq_XMMdq_XMMdq,3705,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3065*/ XED_DEF_INST(XED_ICLASS_VBLENDVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPS_YMMqq_YMMqq_MEMqq_YMMqq,3709,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3066*/ XED_DEF_INST(XED_ICLASS_VBLENDVPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDVPS_YMMqq_YMMqq_YMMqq_YMMqq,3713,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3067*/ XED_DEF_INST(XED_ICLASS_VMPSADBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMPSADBW_XMMdq_XMMdq_MEMdq_IMMb,3717,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3068*/ XED_DEF_INST(XED_ICLASS_VMPSADBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMPSADBW_XMMdq_XMMdq_XMMdq_IMMb,3721,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3069*/ XED_DEF_INST(XED_ICLASS_VMPSADBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VMPSADBW_YMMqq_YMMqq_MEMqq_IMMb,3725,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3070*/ XED_DEF_INST(XED_ICLASS_VMPSADBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VMPSADBW_YMMqq_YMMqq_YMMqq_IMMb,3729,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3071*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBUSW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3072*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBUSW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3073*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBUSW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3074*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBUSW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3075*/ XED_DEF_INST(XED_ICLASS_KUNPCKBW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KUNPCKBW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3076*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3077*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3078*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3079*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3080*/ XED_DEF_INST(XED_ICLASS_VMOVHPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVHPD_XMMdq_XMMq_MEMq,3733,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3081*/ XED_DEF_INST(XED_ICLASS_VMOVHPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVHPD_MEMq_XMMdq,3736,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3082*/ XED_DEF_INST(XED_ICLASS_KTESTB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KTESTB_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*3083*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3084*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3085*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3086*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3087*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRI_XMMdq_MEMdq_IMMb,1512,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3088*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRI_XMMdq_XMMdq_IMMb,1519,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3089*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRI_XMMdq_MEMdq_IMMb,1512,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3090*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRI_XMMdq_XMMdq_IMMb,1519,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3091*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRI_XMMdq_MEMdq_IMMb,1526,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3092*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRI_XMMdq_XMMdq_IMMb,1533,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3093*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRM_XMMdq_MEMdq_IMMb,1542,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3094*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRM_XMMdq_XMMdq_IMMb,1549,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3095*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRM_XMMdq_MEMdq_IMMb,1542,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3096*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRM_XMMdq_XMMdq_IMMb,1549,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3097*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRM_XMMdq_MEMdq_IMMb,1556,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3098*/ XED_DEF_INST(XED_ICLASS_VPCMPESTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPESTRM_XMMdq_XMMdq_IMMb,1563,7,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3099*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3100*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3101*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3102*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD132PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3103*/ XED_DEF_INST(XED_ICLASS_VMOVHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVHPS_XMMdq_XMMq_MEMq,3738,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3104*/ XED_DEF_INST(XED_ICLASS_VMOVHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVHPS_MEMq_XMMdq,3741,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3105*/ XED_DEF_INST(XED_ICLASS_VZEROUPPER,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VZEROUPPER,0,0,0,0,126,XED_EXCEPTION_AVX_TYPE_8),
/*3106*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPS_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3107*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPS_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3108*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPS_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3109*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPS_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3110*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDQ_XMMdq_XMMdq_MEMdq,2539,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3111*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDQ_XMMdq_XMMdq_XMMdq,2542,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3112*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDQ_YMMqq_YMMqq_MEMqq,3743,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3113*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDQ_YMMqq_YMMqq_YMMqq,3746,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3114*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3115*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3116*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3117*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3118*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3119*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3120*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3121*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3122*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPD_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3123*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPD_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3124*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPD_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3125*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VANDNPD_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3126*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3127*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPADDD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3128*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3129*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPADDD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3130*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPABSB_XMMdq_MEMdq,3749,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3131*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPABSB_XMMdq_XMMdq,3751,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3132*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPABSB_YMMqq_MEMqq,3753,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3133*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPABSB_YMMqq_YMMqq,3755,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3134*/ XED_DEF_INST(XED_ICLASS_VBLENDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPD_XMMdq_XMMdq_MEMdq_IMMb,3396,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3135*/ XED_DEF_INST(XED_ICLASS_VBLENDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPD_XMMdq_XMMdq_XMMdq_IMMb,3400,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3136*/ XED_DEF_INST(XED_ICLASS_VBLENDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPD_YMMqq_YMMqq_MEMqq_IMMb,2817,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3137*/ XED_DEF_INST(XED_ICLASS_VBLENDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPD_YMMqq_YMMqq_YMMqq_IMMb,2821,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3138*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_XMMdq_XMMdq_MEMdq_XMMdq,2825,4,0,0,116,XED_EXCEPTION_INVALID),
/*3139*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_XMMdq_XMMdq_XMMdq_XMMdq,2829,4,0,0,116,XED_EXCEPTION_INVALID),
/*3140*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_XMMdq_XMMdq_XMMdq_MEMdq,2833,4,0,0,116,XED_EXCEPTION_INVALID),
/*3141*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_XMMdq_XMMdq_XMMdq_XMMdq,2837,4,0,0,116,XED_EXCEPTION_INVALID),
/*3142*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_YMMqq_YMMqq_MEMqq_YMMqq,2841,4,0,0,116,XED_EXCEPTION_INVALID),
/*3143*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_YMMqq_YMMqq_YMMqq_YMMqq,2845,4,0,0,116,XED_EXCEPTION_INVALID),
/*3144*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_YMMqq_YMMqq_YMMqq_MEMqq,2849,4,0,0,116,XED_EXCEPTION_INVALID),
/*3145*/ XED_DEF_INST(XED_ICLASS_VFMSUBPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPD_YMMqq_YMMqq_YMMqq_YMMqq,2853,4,0,0,116,XED_EXCEPTION_INVALID),
/*3146*/ XED_DEF_INST(XED_ICLASS_VBLENDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPS_XMMdq_XMMdq_MEMdq_IMMb,3412,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3147*/ XED_DEF_INST(XED_ICLASS_VBLENDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPS_XMMdq_XMMdq_XMMdq_IMMb,3416,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3148*/ XED_DEF_INST(XED_ICLASS_VBLENDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPS_YMMqq_YMMqq_MEMqq_IMMb,3420,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3149*/ XED_DEF_INST(XED_ICLASS_VBLENDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VBLENDPS_YMMqq_YMMqq_YMMqq_IMMb,3424,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3150*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_XMMdq_XMMdq_MEMdq_XMMdq,3637,4,0,0,116,XED_EXCEPTION_INVALID),
/*3151*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_XMMdq_XMMdq_XMMdq_XMMdq,3641,4,0,0,116,XED_EXCEPTION_INVALID),
/*3152*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_XMMdq_XMMdq_XMMdq_MEMdq,3645,4,0,0,116,XED_EXCEPTION_INVALID),
/*3153*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_XMMdq_XMMdq_XMMdq_XMMdq,3649,4,0,0,116,XED_EXCEPTION_INVALID),
/*3154*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_YMMqq_YMMqq_MEMqq_YMMqq,3653,4,0,0,116,XED_EXCEPTION_INVALID),
/*3155*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_YMMqq_YMMqq_YMMqq_YMMqq,3657,4,0,0,116,XED_EXCEPTION_INVALID),
/*3156*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_YMMqq_YMMqq_YMMqq_MEMqq,3661,4,0,0,116,XED_EXCEPTION_INVALID),
/*3157*/ XED_DEF_INST(XED_ICLASS_VFMSUBPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBPS_YMMqq_YMMqq_YMMqq_YMMqq,3665,4,0,0,116,XED_EXCEPTION_INVALID),
/*3158*/ XED_DEF_INST(XED_ICLASS_VRSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRSQRTPS_XMMdq_MEMdq,2636,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3159*/ XED_DEF_INST(XED_ICLASS_VRSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRSQRTPS_XMMdq_XMMdq,2638,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3160*/ XED_DEF_INST(XED_ICLASS_VRSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRSQRTPS_YMMqq_MEMqq,2640,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3161*/ XED_DEF_INST(XED_ICLASS_VRSQRTPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRSQRTPS_YMMqq_YMMqq,2642,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3162*/ XED_DEF_INST(XED_ICLASS_KSHIFTLQ,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTLQ_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3163*/ XED_DEF_INST(XED_ICLASS_VPEXTRB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRB_MEMb_XMMdq_IMMb,3757,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3164*/ XED_DEF_INST(XED_ICLASS_VPEXTRB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRB_GPR32d_XMMdq_IMMb,3760,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3165*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRD_MEMd_XMMdq_IMMb,3763,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3166*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRD_GPR32d_XMMdq_IMMb,3766,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3167*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRD_MEMd_XMMdq_IMMb,3763,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3168*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRD_GPR32d_XMMdq_IMMb,3766,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3169*/ XED_DEF_INST(XED_ICLASS_VPHSUBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHSUBW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3170*/ XED_DEF_INST(XED_ICLASS_VPHSUBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHSUBW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3171*/ XED_DEF_INST(XED_ICLASS_VPHSUBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHSUBW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3172*/ XED_DEF_INST(XED_ICLASS_VPHSUBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHSUBW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3173*/ XED_DEF_INST(XED_ICLASS_VPEXTRQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRQ_MEMq_XMMdq_IMMb,3769,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3174*/ XED_DEF_INST(XED_ICLASS_VPEXTRQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRQ_GPR64q_XMMdq_IMMb,3772,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3175*/ XED_DEF_INST(XED_ICLASS_VPEXTRW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRW_MEMw_XMMdq_IMMb,3775,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3176*/ XED_DEF_INST(XED_ICLASS_VPEXTRW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRW_GPR32d_XMMdq_IMMb_15,3778,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3177*/ XED_DEF_INST(XED_ICLASS_VPEXTRW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPEXTRW_GPR32d_XMMdq_IMMb_C5,3781,3,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3178*/ XED_DEF_INST(XED_ICLASS_VPHSUBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHSUBD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3179*/ XED_DEF_INST(XED_ICLASS_VPHSUBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHSUBD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3180*/ XED_DEF_INST(XED_ICLASS_VPHSUBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHSUBD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3181*/ XED_DEF_INST(XED_ICLASS_VPHSUBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHSUBD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3182*/ XED_DEF_INST(XED_ICLASS_ANDN,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_ANDN_VGPR32d_VGPR32d_MEMd,3784,4,96,0,0,XED_EXCEPTION_INVALID),
/*3183*/ XED_DEF_INST(XED_ICLASS_ANDN,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_ANDN_VGPR32d_VGPR32d_MEMd,3784,4,96,0,0,XED_EXCEPTION_INVALID),
/*3184*/ XED_DEF_INST(XED_ICLASS_ANDN,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_ANDN_VGPR32d_VGPR32d_VGPR32d,3788,4,96,0,0,XED_EXCEPTION_INVALID),
/*3185*/ XED_DEF_INST(XED_ICLASS_ANDN,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_ANDN_VGPR32d_VGPR32d_VGPR32d,3788,4,96,0,0,XED_EXCEPTION_INVALID),
/*3186*/ XED_DEF_INST(XED_ICLASS_ANDN,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_ANDN_VGPR64q_VGPR64q_MEMq,3792,4,96,0,0,XED_EXCEPTION_INVALID),
/*3187*/ XED_DEF_INST(XED_ICLASS_ANDN,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_ANDN_VGPR64q_VGPR64q_VGPR64q,3796,4,96,0,0,XED_EXCEPTION_INVALID),
/*3188*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3189*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3190*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3191*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3192*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3193*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3194*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3195*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB132SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3196*/ XED_DEF_INST(XED_ICLASS_VPBLENDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPBLENDW_XMMdq_XMMdq_MEMdq_IMMb,2672,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3197*/ XED_DEF_INST(XED_ICLASS_VPBLENDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPBLENDW_XMMdq_XMMdq_XMMdq_IMMb,2676,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3198*/ XED_DEF_INST(XED_ICLASS_VPBLENDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDW_YMMqq_YMMqq_MEMqq_IMMb,3800,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3199*/ XED_DEF_INST(XED_ICLASS_VPBLENDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDW_YMMqq_YMMqq_YMMqq_IMMb,3804,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3200*/ XED_DEF_INST(XED_ICLASS_VPOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPOR_XMMdq_XMMdq_MEMdq,3176,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3201*/ XED_DEF_INST(XED_ICLASS_VPOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX,3,XED_IFORM_VPOR_XMMdq_XMMdq_XMMdq,3179,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3202*/ XED_DEF_INST(XED_ICLASS_VPOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPOR_YMMqq_YMMqq_MEMqq,3182,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3203*/ XED_DEF_INST(XED_ICLASS_VPOR,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX2,3,XED_IFORM_VPOR_YMMqq_YMMqq_YMMqq,3185,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3204*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3205*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3206*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3207*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3208*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULLD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3209*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULLD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3210*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULLD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3211*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULLD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3212*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3213*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3214*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3215*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3216*/ XED_DEF_INST(XED_ICLASS_VUCOMISS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUCOMISS_XMMdq_MEMd,3808,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3217*/ XED_DEF_INST(XED_ICLASS_VUCOMISS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUCOMISS_XMMdq_XMMd,3811,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3218*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRM_XMMdq_MEMdq_IMMb,530,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3219*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRM,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRM_XMMdq_XMMdq_IMMb,535,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3220*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRI_XMMdq_MEMdq_IMMb,2050,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3221*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRI_XMMdq_XMMdq_IMMb,2055,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3222*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRI_XMMdq_MEMdq_IMMb,2050,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3223*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRI_XMMdq_XMMdq_IMMb,2055,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3224*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRI_XMMdq_MEMdq_IMMb,2060,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3225*/ XED_DEF_INST(XED_ICLASS_VPCMPISTRI,XED_CATEGORY_STTNI,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPISTRI_XMMdq_XMMdq_IMMb,2065,5,29,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3226*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULLW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3227*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMULLW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3228*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULLW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3229*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMULLW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3230*/ XED_DEF_INST(XED_ICLASS_VUCOMISD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUCOMISD_XMMdq_MEMq,3814,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3231*/ XED_DEF_INST(XED_ICLASS_VUCOMISD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUCOMISD_XMMdq_XMMq,3817,3,93,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3232*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3233*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3234*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3235*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3236*/ XED_DEF_INST(XED_ICLASS_MULX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_MULX_VGPR32d_VGPR32d_VGPR32d,3820,4,0,0,0,XED_EXCEPTION_INVALID),
/*3237*/ XED_DEF_INST(XED_ICLASS_MULX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_MULX_VGPR32d_VGPR32d_VGPR32d,3820,4,0,0,0,XED_EXCEPTION_INVALID),
/*3238*/ XED_DEF_INST(XED_ICLASS_MULX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_MULX_VGPR32d_VGPR32d_MEMd,3824,4,0,0,0,XED_EXCEPTION_INVALID),
/*3239*/ XED_DEF_INST(XED_ICLASS_MULX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_MULX_VGPR32d_VGPR32d_MEMd,3824,4,0,0,0,XED_EXCEPTION_INVALID),
/*3240*/ XED_DEF_INST(XED_ICLASS_MULX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_MULX_VGPR64q_VGPR64q_VGPR64q,3828,4,0,0,0,XED_EXCEPTION_INVALID),
/*3241*/ XED_DEF_INST(XED_ICLASS_MULX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_MULX_VGPR64q_VGPR64q_MEMq,3832,4,0,0,0,XED_EXCEPTION_INVALID),
/*3242*/ XED_DEF_INST(XED_ICLASS_VPERM2I128,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERM2I128_YMMqq_YMMqq_MEMqq_IMMb,3836,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3243*/ XED_DEF_INST(XED_ICLASS_VPERM2I128,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERM2I128_YMMqq_YMMqq_YMMqq_IMMb,3840,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3244*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3245*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3246*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF128,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VEXTRACTF128_MEMdq_YMMdq_IMMb,3844,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3247*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF128,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VEXTRACTF128_XMMdq_YMMdq_IMMb,3847,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3248*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXBW_XMMdq_XMMq,928,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3249*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXBW_XMMdq_MEMq,926,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3250*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXBW_YMMqq_XMMdq,3850,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3251*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXBW_YMMqq_MEMdq,3852,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3252*/ XED_DEF_INST(XED_ICLASS_VFMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3253*/ XED_DEF_INST(XED_ICLASS_VFMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3254*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKUSDW_XMMdq_XMMdq_MEMdq,3854,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3255*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKUSDW_XMMdq_XMMdq_XMMdq,3857,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3256*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKUSDW_YMMqq_YMMqq_MEMqq,3860,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3257*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKUSDW_YMMqq_YMMqq_YMMqq,3863,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3258*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXUD_XMMdq_XMMdq_MEMdq,2461,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3259*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXUD_XMMdq_XMMdq_XMMdq,2464,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3260*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXUD_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3261*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXUD_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3262*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRD_XMMdq_XMMdq_MEMd_IMMb,3866,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3263*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRD_XMMdq_XMMdq_GPR32d_IMMb,3870,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3264*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRD_XMMdq_XMMdq_MEMd_IMMb,3866,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3265*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRD_XMMdq_XMMdq_GPR32d_IMMb,3870,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3266*/ XED_DEF_INST(XED_ICLASS_VPINSRQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRQ_XMMdq_XMMdq_MEMq_IMMb,3874,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3267*/ XED_DEF_INST(XED_ICLASS_VPINSRQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRQ_XMMdq_XMMdq_GPR64q_IMMb,3878,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3268*/ XED_DEF_INST(XED_ICLASS_VPINSRW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRW_XMMdq_XMMdq_MEMw_IMMb,3882,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3269*/ XED_DEF_INST(XED_ICLASS_VPINSRW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPINSRW_XMMdq_XMMdq_GPR32d_IMMb,3886,4,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3270*/ XED_DEF_INST(XED_ICLASS_VFMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3271*/ XED_DEF_INST(XED_ICLASS_VFMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3272*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXUW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3273*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMAXUW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3274*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXUW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3275*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMAXUW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3276*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLW_XMMdq_XMMdq_MEMdq,3378,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3277*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLW_XMMdq_XMMdq_XMMdq,3381,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3278*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLW_XMMdq_XMMdq_IMMb,3384,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3279*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLW_YMMqq_YMMqq_MEMdq,3387,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3280*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLW_YMMqq_YMMqq_XMMq,3390,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3281*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLW_YMMqq_YMMqq_IMMb,3393,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3282*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3283*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3284*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLQ_XMMdq_XMMdq_IMMb,3350,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3285*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLQ_YMMqq_YMMqq_MEMdq,3353,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3286*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLQ_YMMqq_YMMqq_XMMq,3356,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3287*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLQ_YMMqq_YMMqq_IMMb,3359,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3288*/ XED_DEF_INST(XED_ICLASS_VFMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSS_XMMdq_XMMdq_MEMd_XMMdq,3048,4,0,0,117,XED_EXCEPTION_INVALID),
/*3289*/ XED_DEF_INST(XED_ICLASS_VFMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSS_XMMdq_XMMdq_XMMd_XMMdq,3052,4,0,0,117,XED_EXCEPTION_INVALID),
/*3290*/ XED_DEF_INST(XED_ICLASS_VFMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSS_XMMdq_XMMdq_XMMdq_MEMd,3056,4,0,0,117,XED_EXCEPTION_INVALID),
/*3291*/ XED_DEF_INST(XED_ICLASS_VFMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSS_XMMdq_XMMdq_XMMdq_XMMd,3060,4,0,0,117,XED_EXCEPTION_INVALID),
/*3292*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_XMMdq_MEMdq,2467,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3293*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_XMMdq_XMMdq_28,2469,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3294*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_MEMdq_XMMdq,3615,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3295*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_XMMdq_XMMdq_29,3617,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3296*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_YMMqq_MEMqq,2471,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3297*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_YMMqq_YMMqq_28,2473,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3298*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_MEMqq_YMMqq,3619,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3299*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPD_YMMqq_YMMqq_29,3621,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3300*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLQDQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3301*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLQDQ_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3302*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLQDQ_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3303*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLQDQ_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3304*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3305*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3306*/ XED_DEF_INST(XED_ICLASS_VFMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSD_XMMdq_XMMdq_MEMq_XMMdq,3030,4,0,0,117,XED_EXCEPTION_INVALID),
/*3307*/ XED_DEF_INST(XED_ICLASS_VFMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSD_XMMdq_XMMdq_XMMq_XMMdq,3034,4,0,0,117,XED_EXCEPTION_INVALID),
/*3308*/ XED_DEF_INST(XED_ICLASS_VFMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSD_XMMdq_XMMdq_XMMdq_MEMq,3038,4,0,0,117,XED_EXCEPTION_INVALID),
/*3309*/ XED_DEF_INST(XED_ICLASS_VFMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBSD_XMMdq_XMMdq_XMMdq_XMMq,3042,4,0,0,117,XED_EXCEPTION_INVALID),
/*3310*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLD_XMMdq_XMMdq_MEMdq,3320,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3311*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLD_XMMdq_XMMdq_XMMdq,3323,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3312*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSRLD_XMMdq_XMMdq_IMMb,3326,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3313*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLD_YMMqq_YMMqq_MEMdq,3329,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3314*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLD_YMMqq_YMMqq_XMMq,3332,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3315*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSRLD_YMMqq_YMMqq_IMMb,3335,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3316*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_XMMdq_XMMdq_MEMdq,3890,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3317*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_XMMdq_XMMdq_XMMdq,3893,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3318*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_YMMqq_YMMqq_MEMqq,3896,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3319*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_YMMqq_YMMqq_YMMqq,3899,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3320*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_XMMdq_MEMdq_IMMb,3902,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3321*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_XMMdq_XMMdq_IMMb,3905,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3322*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_YMMqq_MEMqq_IMMb,3908,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3323*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPERMILPD_YMMqq_YMMqq_IMMb,3911,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3324*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3325*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3326*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_XMMdq_MEMdq,2636,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3327*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_XMMdq_XMMdq_28,2638,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3328*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_MEMdq_XMMdq,3607,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3329*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_XMMdq_XMMdq_29,3609,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3330*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_YMMqq_MEMqq,2640,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3331*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_YMMqq_YMMqq_28,2642,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3332*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_MEMqq_YMMqq,3611,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3333*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVAPS_YMMqq_YMMqq_29,3613,2,0,0,33,XED_EXCEPTION_AVX_TYPE_1),
/*3334*/ XED_DEF_INST(XED_ICLASS_SHLX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHLX_VGPR32d_MEMd_VGPR32d,3003,3,0,0,0,XED_EXCEPTION_INVALID),
/*3335*/ XED_DEF_INST(XED_ICLASS_SHLX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHLX_VGPR32d_MEMd_VGPR32d,3003,3,0,0,0,XED_EXCEPTION_INVALID),
/*3336*/ XED_DEF_INST(XED_ICLASS_SHLX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHLX_VGPR32d_VGPR32d_VGPR32d,3006,3,0,0,0,XED_EXCEPTION_INVALID),
/*3337*/ XED_DEF_INST(XED_ICLASS_SHLX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHLX_VGPR32d_VGPR32d_VGPR32d,3006,3,0,0,0,XED_EXCEPTION_INVALID),
/*3338*/ XED_DEF_INST(XED_ICLASS_SHLX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHLX_VGPR64q_MEMq_VGPR64q,3009,3,0,0,0,XED_EXCEPTION_INVALID),
/*3339*/ XED_DEF_INST(XED_ICLASS_SHLX,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_SHLX_VGPR64q_VGPR64q_VGPR64q,3012,3,0,0,0,XED_EXCEPTION_INVALID),
/*3340*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX,3,XED_IFORM_VBROADCASTSD_YMMqq_MEMq,3914,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3341*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VBROADCASTSD_YMMqq_XMMdq,3916,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3342*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX,3,XED_IFORM_VBROADCASTSS_XMMdq_MEMd,2660,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3343*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX,3,XED_IFORM_VBROADCASTSS_YMMqq_MEMd,3918,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3344*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VBROADCASTSS_XMMdq_XMMdq,2638,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3345*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VBROADCASTSS_YMMqq_XMMdq,3920,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3346*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3347*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3348*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3349*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3350*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PS_XMMdq_MEMdq,3922,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3351*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PS_XMMdq_XMMdq,3924,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3352*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PS_YMMqq_MEMqq,3926,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3353*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PS_YMMqq_YMMqq,3928,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3354*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3355*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3356*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3357*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3358*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLDQ_XMMdq_XMMdq_MEMdq,2461,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3359*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKLDQ_XMMdq_XMMdq_XMMdq,2464,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3360*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLDQ_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3361*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKLDQ_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3362*/ XED_DEF_INST(XED_ICLASS_KXORB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXORB_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3363*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PD_XMMdq_MEMq,3930,2,0,0,26,XED_EXCEPTION_AVX_TYPE_5),
/*3364*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PD_XMMdq_XMMq,3932,2,0,0,26,XED_EXCEPTION_AVX_TYPE_5),
/*3365*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PD_YMMqq_MEMdq,3934,2,0,0,26,XED_EXCEPTION_AVX_TYPE_5),
/*3366*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTDQ2PD_YMMqq_XMMdq,3936,2,0,0,26,XED_EXCEPTION_AVX_TYPE_5),
/*3367*/ XED_DEF_INST(XED_ICLASS_VMINPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3368*/ XED_DEF_INST(XED_ICLASS_VMINPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3369*/ XED_DEF_INST(XED_ICLASS_VMINPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3370*/ XED_DEF_INST(XED_ICLASS_VMINPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMINPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3371*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTQ_XMMdq_MEMq,3938,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3372*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTQ_XMMdq_XMMq,3940,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3373*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTQ_YMMqq_MEMq,3942,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3374*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VPBROADCASTQ_YMMqq_XMMq,3944,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3375*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3376*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3377*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3378*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB213PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3379*/ XED_DEF_INST(XED_ICLASS_VPSUBB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3380*/ XED_DEF_INST(XED_ICLASS_VPSUBB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3381*/ XED_DEF_INST(XED_ICLASS_VPSUBB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3382*/ XED_DEF_INST(XED_ICLASS_VPSUBB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3383*/ XED_DEF_INST(XED_ICLASS_VPSUBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3384*/ XED_DEF_INST(XED_ICLASS_VPSUBD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3385*/ XED_DEF_INST(XED_ICLASS_VPSUBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3386*/ XED_DEF_INST(XED_ICLASS_VPSUBD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3387*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_XMMdq_XMMdq_MEMdq_XMMdq,3637,4,0,0,116,XED_EXCEPTION_INVALID),
/*3388*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_XMMdq_XMMdq_XMMdq_XMMdq,3641,4,0,0,116,XED_EXCEPTION_INVALID),
/*3389*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_XMMdq_XMMdq_XMMdq_MEMdq,3645,4,0,0,116,XED_EXCEPTION_INVALID),
/*3390*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_XMMdq_XMMdq_XMMdq_XMMdq,3649,4,0,0,116,XED_EXCEPTION_INVALID),
/*3391*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_YMMqq_YMMqq_MEMqq_YMMqq,3653,4,0,0,116,XED_EXCEPTION_INVALID),
/*3392*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_YMMqq_YMMqq_YMMqq_YMMqq,3657,4,0,0,116,XED_EXCEPTION_INVALID),
/*3393*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_YMMqq_YMMqq_YMMqq_MEMqq,3661,4,0,0,116,XED_EXCEPTION_INVALID),
/*3394*/ XED_DEF_INST(XED_ICLASS_VFNMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPS_YMMqq_YMMqq_YMMqq_YMMqq,3665,4,0,0,116,XED_EXCEPTION_INVALID),
/*3395*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVQ_XMMdq_XMMdq_MEMdq,2614,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3396*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVQ_YMMqq_YMMqq_MEMqq,2965,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3397*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVQ_MEMdq_XMMdq_XMMdq,3946,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3398*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVQ_MEMqq_YMMqq_YMMqq,3949,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3399*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF128,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX,3,XED_IFORM_VBROADCASTF128_YMMqq_MEMdq,3952,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3400*/ XED_DEF_INST(XED_ICLASS_VPSUBQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBQ_XMMdq_XMMdq_MEMdq,2539,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3401*/ XED_DEF_INST(XED_ICLASS_VPSUBQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBQ_XMMdq_XMMdq_XMMdq,2542,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3402*/ XED_DEF_INST(XED_ICLASS_VPSUBQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBQ_YMMqq_YMMqq_MEMqq,3743,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3403*/ XED_DEF_INST(XED_ICLASS_VPSUBQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBQ_YMMqq_YMMqq_YMMqq,3746,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3404*/ XED_DEF_INST(XED_ICLASS_VPSUBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3405*/ XED_DEF_INST(XED_ICLASS_VPSUBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3406*/ XED_DEF_INST(XED_ICLASS_VPSUBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3407*/ XED_DEF_INST(XED_ICLASS_VPSUBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3408*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVD_XMMdq_XMMdq_MEMdq,2461,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3409*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVD_YMMqq_YMMqq_MEMqq,2878,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3410*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVD_MEMdq_XMMdq_XMMdq,3954,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3411*/ XED_DEF_INST(XED_ICLASS_VPMASKMOVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMASKMOVD_MEMqq_YMMqq_YMMqq,3957,3,0,0,124,XED_EXCEPTION_AVX_TYPE_6),
/*3412*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3413*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3414*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3415*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3416*/ XED_DEF_INST(XED_ICLASS_VPSADBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSADBW_XMMdq_XMMdq_MEMdq,3960,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3417*/ XED_DEF_INST(XED_ICLASS_VPSADBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSADBW_XMMdq_XMMdq_XMMdq,3963,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3418*/ XED_DEF_INST(XED_ICLASS_VPSADBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSADBW_YMMqq_YMMqq_MEMqq,3966,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3419*/ XED_DEF_INST(XED_ICLASS_VPSADBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSADBW_YMMqq_YMMqq_YMMqq,3969,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3420*/ XED_DEF_INST(XED_ICLASS_VROUNDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPD_XMMdq_MEMdq_IMMb,3902,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3421*/ XED_DEF_INST(XED_ICLASS_VROUNDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPD_XMMdq_XMMdq_IMMb,3905,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3422*/ XED_DEF_INST(XED_ICLASS_VROUNDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPD_YMMqq_MEMqq_IMMb,3908,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3423*/ XED_DEF_INST(XED_ICLASS_VROUNDPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPD_YMMqq_YMMqq_IMMb,3911,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3424*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3425*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3426*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3427*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD132PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3428*/ XED_DEF_INST(XED_ICLASS_VROUNDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPS_XMMdq_MEMdq_IMMb,2925,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3429*/ XED_DEF_INST(XED_ICLASS_VROUNDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPS_XMMdq_XMMdq_IMMb,2928,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3430*/ XED_DEF_INST(XED_ICLASS_VROUNDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPS_YMMqq_MEMqq_IMMb,2931,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3431*/ XED_DEF_INST(XED_ICLASS_VROUNDPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VROUNDPS_YMMqq_YMMqq_IMMb,2934,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3432*/ XED_DEF_INST(XED_ICLASS_VPSUBSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBSB_XMMdq_XMMdq_MEMdq,2588,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3433*/ XED_DEF_INST(XED_ICLASS_VPSUBSB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBSB_XMMdq_XMMdq_XMMdq,2591,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3434*/ XED_DEF_INST(XED_ICLASS_VPSUBSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBSB_YMMqq_YMMqq_MEMqq,2997,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3435*/ XED_DEF_INST(XED_ICLASS_VPSUBSB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBSB_YMMqq_YMMqq_YMMqq,3000,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3436*/ XED_DEF_INST(XED_ICLASS_VINSERTI128,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VINSERTI128_YMMqq_YMMqq_MEMdq_IMMb,3972,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3437*/ XED_DEF_INST(XED_ICLASS_VINSERTI128,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VINSERTI128_YMMqq_YMMqq_XMMdq_IMMb,3976,4,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3438*/ XED_DEF_INST(XED_ICLASS_VEXTRACTI128,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VEXTRACTI128_MEMdq_YMMqq_IMMb,3980,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3439*/ XED_DEF_INST(XED_ICLASS_VEXTRACTI128,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VEXTRACTI128_XMMdq_YMMqq_IMMb,3983,3,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3440*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3441*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3442*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3443*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD213PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3444*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI128,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX2,3,XED_IFORM_VBROADCASTI128_YMMqq_MEMdq,3986,2,0,0,0,XED_EXCEPTION_AVX_TYPE_6),
/*3445*/ XED_DEF_INST(XED_ICLASS_VPSUBSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3446*/ XED_DEF_INST(XED_ICLASS_VPSUBSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPSUBSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3447*/ XED_DEF_INST(XED_ICLASS_VPSUBSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3448*/ XED_DEF_INST(XED_ICLASS_VPSUBSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSUBSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3449*/ XED_DEF_INST(XED_ICLASS_VPMOVZXDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXDQ_XMMdq_XMMq,1626,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3450*/ XED_DEF_INST(XED_ICLASS_VPMOVZXDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXDQ_XMMdq_MEMq,1624,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3451*/ XED_DEF_INST(XED_ICLASS_VPMOVZXDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXDQ_YMMqq_XMMdq,3988,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3452*/ XED_DEF_INST(XED_ICLASS_VPMOVZXDQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXDQ_YMMqq_MEMdq,3990,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3453*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SS_XMMdq_XMMdq_MEMd,3992,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3454*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SS_XMMdq_XMMdq_GPR32d,3995,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3455*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SS_XMMdq_XMMdq_MEMd,3992,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3456*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SS_XMMdq_XMMdq_GPR32d,3995,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3457*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SS_XMMdq_XMMdq_MEMq,3998,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3458*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SS_XMMdq_XMMdq_GPR64q,4001,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3459*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SS_XMMdq_XMMdq_MEMq,4004,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3460*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SS_XMMdq_XMMdq_XMMq,4007,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3461*/ XED_DEF_INST(XED_ICLASS_KANDD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KANDD_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3462*/ XED_DEF_INST(XED_ICLASS_VPCLMULQDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCLMULQDQ_XMMdq_XMMdq_XMMdq_IMMb,4010,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3463*/ XED_DEF_INST(XED_ICLASS_VPCLMULQDQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCLMULQDQ_XMMdq_XMMdq_MEMdq_IMMb,4014,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3464*/ XED_DEF_INST(XED_ICLASS_VPCLMULQDQ,XED_CATEGORY_VPCLMULQDQ,XED_EXTENSION_VPCLMULQDQ,3,XED_IFORM_VPCLMULQDQ_YMMu128_YMMu64_YMMu64_IMM8,4018,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3465*/ XED_DEF_INST(XED_ICLASS_VPCLMULQDQ,XED_CATEGORY_VPCLMULQDQ,XED_EXTENSION_VPCLMULQDQ,3,XED_IFORM_VPCLMULQDQ_YMMu128_YMMu64_MEMu64_IMM8,4022,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3466*/ XED_DEF_INST(XED_ICLASS_VRCPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRCPPS_XMMdq_MEMdq,2636,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3467*/ XED_DEF_INST(XED_ICLASS_VRCPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRCPPS_XMMdq_XMMdq,2638,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3468*/ XED_DEF_INST(XED_ICLASS_VRCPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRCPPS_YMMqq_MEMqq,2640,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3469*/ XED_DEF_INST(XED_ICLASS_VRCPPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VRCPPS_YMMqq_YMMqq,2642,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3470*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SD_XMMdq_XMMdq_MEMd,4026,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3471*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SD_XMMdq_XMMdq_GPR32d,4029,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3472*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SD_XMMdq_XMMdq_MEMd,4026,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3473*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SD_XMMdq_XMMdq_GPR32d,4029,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3474*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SD_XMMdq_XMMdq_MEMq,4032,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3475*/ XED_DEF_INST(XED_ICLASS_VCVTSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSI2SD_XMMdq_XMMdq_GPR64q,4035,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3476*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SI_GPR32d_MEMq,4038,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3477*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SI_GPR32d_XMMq,4040,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3478*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SI_GPR32d_MEMq,4038,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3479*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SI_GPR32d_XMMq,4040,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3480*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SI_GPR64q_MEMq,4042,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3481*/ XED_DEF_INST(XED_ICLASS_VCVTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTSD2SI_GPR64q_XMMq,4044,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3482*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_XMMdq_XMMdq_MEMdq_XMMdq,2825,4,0,0,116,XED_EXCEPTION_INVALID),
/*3483*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_XMMdq_XMMdq_XMMdq_XMMdq,2829,4,0,0,116,XED_EXCEPTION_INVALID),
/*3484*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_XMMdq_XMMdq_XMMdq_MEMdq,2833,4,0,0,116,XED_EXCEPTION_INVALID),
/*3485*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_XMMdq_XMMdq_XMMdq_XMMdq,2837,4,0,0,116,XED_EXCEPTION_INVALID),
/*3486*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_YMMqq_YMMqq_MEMqq_YMMqq,2841,4,0,0,116,XED_EXCEPTION_INVALID),
/*3487*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_YMMqq_YMMqq_YMMqq_YMMqq,2845,4,0,0,116,XED_EXCEPTION_INVALID),
/*3488*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_YMMqq_YMMqq_YMMqq_MEMqq,2849,4,0,0,116,XED_EXCEPTION_INVALID),
/*3489*/ XED_DEF_INST(XED_ICLASS_VFNMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMADDPD_YMMqq_YMMqq_YMMqq_YMMqq,2853,4,0,0,116,XED_EXCEPTION_INVALID),
/*3490*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3491*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3492*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3493*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3494*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3495*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3496*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3497*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3498*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSS_XMMdq_XMMdq_MEMd_XMMdq,3048,4,0,0,117,XED_EXCEPTION_INVALID),
/*3499*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSS_XMMdq_XMMdq_XMMd_XMMdq,3052,4,0,0,117,XED_EXCEPTION_INVALID),
/*3500*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSS_XMMdq_XMMdq_XMMdq_MEMd,3056,4,0,0,117,XED_EXCEPTION_INVALID),
/*3501*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSS_XMMdq_XMMdq_XMMdq_XMMd,3060,4,0,0,117,XED_EXCEPTION_INVALID),
/*3502*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXWD_XMMdq_XMMq,242,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3503*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXWD_XMMdq_MEMq,240,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3504*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXWD_YMMqq_XMMdq,4046,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3505*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXWD_YMMqq_MEMdq,4048,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3506*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_XMMdq_XMMdq_MEMdq_XMMdq,2825,4,0,0,116,XED_EXCEPTION_INVALID),
/*3507*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_XMMdq_XMMdq_XMMdq_XMMdq,2829,4,0,0,116,XED_EXCEPTION_INVALID),
/*3508*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_XMMdq_XMMdq_XMMdq_MEMdq,2833,4,0,0,116,XED_EXCEPTION_INVALID),
/*3509*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_XMMdq_XMMdq_XMMdq_XMMdq,2837,4,0,0,116,XED_EXCEPTION_INVALID),
/*3510*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_YMMqq_YMMqq_MEMqq_YMMqq,2841,4,0,0,116,XED_EXCEPTION_INVALID),
/*3511*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_YMMqq_YMMqq_YMMqq_YMMqq,2845,4,0,0,116,XED_EXCEPTION_INVALID),
/*3512*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_YMMqq_YMMqq_YMMqq_MEMqq,2849,4,0,0,116,XED_EXCEPTION_INVALID),
/*3513*/ XED_DEF_INST(XED_ICLASS_VFMADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPD_YMMqq_YMMqq_YMMqq_YMMqq,2853,4,0,0,116,XED_EXCEPTION_INVALID),
/*3514*/ XED_DEF_INST(XED_ICLASS_VMOVHLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVHLPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,0,XED_EXCEPTION_AVX_TYPE_7),
/*3515*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3516*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3517*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3518*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUBADD231PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3519*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXWQ_XMMdq_XMMd,1758,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3520*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVSXWQ_XMMdq_MEMd,1756,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3521*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXWQ_YMMqq_XMMq,4050,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3522*/ XED_DEF_INST(XED_ICLASS_VPMOVSXWQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVSXWQ_YMMqq_MEMq,4052,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3523*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_XMMdq_XMMdq_MEMdq_XMMdq,3637,4,0,0,116,XED_EXCEPTION_INVALID),
/*3524*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_XMMdq_XMMdq_XMMdq_XMMdq,3641,4,0,0,116,XED_EXCEPTION_INVALID),
/*3525*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_XMMdq_XMMdq_XMMdq_MEMdq,3645,4,0,0,116,XED_EXCEPTION_INVALID),
/*3526*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_XMMdq_XMMdq_XMMdq_XMMdq,3649,4,0,0,116,XED_EXCEPTION_INVALID),
/*3527*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_YMMqq_YMMqq_MEMqq_YMMqq,3653,4,0,0,116,XED_EXCEPTION_INVALID),
/*3528*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_YMMqq_YMMqq_YMMqq_YMMqq,3657,4,0,0,116,XED_EXCEPTION_INVALID),
/*3529*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_YMMqq_YMMqq_YMMqq_MEMqq,3661,4,0,0,116,XED_EXCEPTION_INVALID),
/*3530*/ XED_DEF_INST(XED_ICLASS_VFMADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMADDPS_YMMqq_YMMqq_YMMqq_YMMqq,3665,4,0,0,116,XED_EXCEPTION_INVALID),
/*3531*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSD_XMMdq_XMMdq_MEMq_XMMdq,3030,4,0,0,117,XED_EXCEPTION_INVALID),
/*3532*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSD_XMMdq_XMMdq_XMMq_XMMdq,3034,4,0,0,117,XED_EXCEPTION_INVALID),
/*3533*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSD_XMMdq_XMMdq_XMMdq_MEMq,3038,4,0,0,117,XED_EXCEPTION_INVALID),
/*3534*/ XED_DEF_INST(XED_ICLASS_VFNMSUBSD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFNMSUBSD_XMMdq_XMMdq_XMMdq_XMMq,3042,4,0,0,117,XED_EXCEPTION_INVALID),
/*3535*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3536*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3537*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3538*/ XED_DEF_INST(XED_ICLASS_VFNMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD231PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3539*/ XED_DEF_INST(XED_ICLASS_BEXTR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BEXTR_VGPR32d_MEMd_VGPR32d,3226,4,32,0,0,XED_EXCEPTION_INVALID),
/*3540*/ XED_DEF_INST(XED_ICLASS_BEXTR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BEXTR_VGPR32d_MEMd_VGPR32d,3226,4,32,0,0,XED_EXCEPTION_INVALID),
/*3541*/ XED_DEF_INST(XED_ICLASS_BEXTR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BEXTR_VGPR32d_VGPR32d_VGPR32d,3230,4,32,0,0,XED_EXCEPTION_INVALID),
/*3542*/ XED_DEF_INST(XED_ICLASS_BEXTR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BEXTR_VGPR32d_VGPR32d_VGPR32d,3230,4,32,0,0,XED_EXCEPTION_INVALID),
/*3543*/ XED_DEF_INST(XED_ICLASS_BEXTR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BEXTR_VGPR64q_MEMq_VGPR64q,3234,4,32,0,0,XED_EXCEPTION_INVALID),
/*3544*/ XED_DEF_INST(XED_ICLASS_BEXTR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BEXTR_VGPR64q_VGPR64q_VGPR64q,3238,4,32,0,0,XED_EXCEPTION_INVALID),
/*3545*/ XED_DEF_INST(XED_ICLASS_VGF2P8MULB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8MULB_XMMu8_XMMu8_XMMu8,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3546*/ XED_DEF_INST(XED_ICLASS_VGF2P8MULB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8MULB_XMMu8_XMMu8_MEMu8,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3547*/ XED_DEF_INST(XED_ICLASS_VGF2P8MULB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8MULB_YMMu8_YMMu8_YMMu8,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3548*/ XED_DEF_INST(XED_ICLASS_VGF2P8MULB,XED_CATEGORY_GFNI,XED_EXTENSION_GFNI,3,XED_IFORM_VGF2P8MULB_YMMu8_YMMu8_MEMu8,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3549*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPD_XMMdq_XMMdq_MEMdq,2614,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3550*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPD_XMMdq_XMMdq_XMMdq,2617,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3551*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPD_YMMqq_YMMqq_MEMqq,2965,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3552*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPD_YMMqq_YMMqq_YMMqq,2968,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3553*/ XED_DEF_INST(XED_ICLASS_KXORW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXORW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3554*/ XED_DEF_INST(XED_ICLASS_KTESTD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KTESTD_MASKmskw_MASKmskw_AVX512,3548,3,95,0,118,XED_EXCEPTION_AVX512_K20),
/*3555*/ XED_DEF_INST(XED_ICLASS_VPBLENDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDD_XMMdq_XMMdq_MEMdq_IMMb,2594,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3556*/ XED_DEF_INST(XED_ICLASS_VPBLENDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDD_XMMdq_XMMdq_XMMdq_IMMb,2598,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3557*/ XED_DEF_INST(XED_ICLASS_VPBLENDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDD_YMMqq_YMMqq_MEMqq_IMMb,4054,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3558*/ XED_DEF_INST(XED_ICLASS_VPBLENDD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPBLENDD_YMMqq_YMMqq_YMMqq_IMMb,4058,4,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3559*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPS_XMMdq_XMMdq_MEMdq,2461,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3560*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPS_XMMdq_XMMdq_XMMdq,2464,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3561*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPS_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3562*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX,3,XED_IFORM_VORPS_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3563*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231SS_XMMdq_XMMd_MEMd,2907,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3564*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231SS_XMMdq_XMMd_XMMd,2910,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3565*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231SD_XMMdq_XMMq_MEMq,2947,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3566*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMSUB231SD_XMMdq_XMMq_XMMq,2950,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3567*/ XED_DEF_INST(XED_ICLASS_PEXT,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PEXT_VGPR32d_VGPR32d_MEMd,3248,3,0,0,0,XED_EXCEPTION_INVALID),
/*3568*/ XED_DEF_INST(XED_ICLASS_PEXT,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PEXT_VGPR32d_VGPR32d_MEMd,3248,3,0,0,0,XED_EXCEPTION_INVALID),
/*3569*/ XED_DEF_INST(XED_ICLASS_PEXT,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PEXT_VGPR32d_VGPR32d_VGPR32d,3251,3,0,0,0,XED_EXCEPTION_INVALID),
/*3570*/ XED_DEF_INST(XED_ICLASS_PEXT,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PEXT_VGPR32d_VGPR32d_VGPR32d,3251,3,0,0,0,XED_EXCEPTION_INVALID),
/*3571*/ XED_DEF_INST(XED_ICLASS_PEXT,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PEXT_VGPR64q_VGPR64q_MEMq,3254,3,0,0,0,XED_EXCEPTION_INVALID),
/*3572*/ XED_DEF_INST(XED_ICLASS_PEXT,XED_CATEGORY_BMI2,XED_EXTENSION_BMI2,3,XED_IFORM_PEXT_VGPR64q_VGPR64q_VGPR64q,3257,3,0,0,0,XED_EXCEPTION_INVALID),
/*3573*/ XED_DEF_INST(XED_ICLASS_VMASKMOVDQU,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VMASKMOVDQU_XMMdq_XMMdq,4062,4,0,0,57,XED_EXCEPTION_AVX_TYPE_4),
/*3574*/ XED_DEF_INST(XED_ICLASS_VMOVNTPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTPD_MEMdq_XMMdq,3615,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*3575*/ XED_DEF_INST(XED_ICLASS_VMOVNTPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTPD_MEMqq_YMMqq,3619,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*3576*/ XED_DEF_INST(XED_ICLASS_KSHIFTRW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTRW_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3577*/ XED_DEF_INST(XED_ICLASS_VPMINUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINUW_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3578*/ XED_DEF_INST(XED_ICLASS_VPMINUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINUW_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3579*/ XED_DEF_INST(XED_ICLASS_VPMINUW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINUW_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3580*/ XED_DEF_INST(XED_ICLASS_VPMINUW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINUW_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3581*/ XED_DEF_INST(XED_ICLASS_VPERMPS,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3582*/ XED_DEF_INST(XED_ICLASS_VPERMPS,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3583*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPS_XMMdq_XMMdq_MEMdq,3018,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3584*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPS_XMMdq_XMMdq_XMMdq,3021,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3585*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPS_YMMqq_YMMqq_MEMqq,3024,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3586*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPS_YMMqq_YMMqq_YMMqq,3027,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3587*/ XED_DEF_INST(XED_ICLASS_VPMINUB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINUB_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3588*/ XED_DEF_INST(XED_ICLASS_VPMINUB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINUB_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3589*/ XED_DEF_INST(XED_ICLASS_VPMINUB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINUB_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3590*/ XED_DEF_INST(XED_ICLASS_VPMINUB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINUB_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3591*/ XED_DEF_INST(XED_ICLASS_KSHIFTRB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTRB_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3592*/ XED_DEF_INST(XED_ICLASS_VMOVNTPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTPS_MEMdq_XMMdq,3607,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*3593*/ XED_DEF_INST(XED_ICLASS_VMOVNTPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX,3,XED_IFORM_VMOVNTPS_MEMqq_YMMqq,3611,2,0,0,69,XED_EXCEPTION_AVX_TYPE_1),
/*3594*/ XED_DEF_INST(XED_ICLASS_VPMINUD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINUD_XMMdq_XMMdq_MEMdq,2461,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3595*/ XED_DEF_INST(XED_ICLASS_VPMINUD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMINUD_XMMdq_XMMdq_XMMdq,2464,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3596*/ XED_DEF_INST(XED_ICLASS_VPMINUD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINUD_YMMqq_YMMqq_MEMqq,2878,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3597*/ XED_DEF_INST(XED_ICLASS_VPMINUD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMINUD_YMMqq_YMMqq_YMMqq,2881,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3598*/ XED_DEF_INST(XED_ICLASS_KSHIFTRD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTRD_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3599*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPD_XMMdq_XMMdq_MEMdq,2857,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3600*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPD_XMMdq_XMMdq_XMMdq,2860,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3601*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPD_YMMqq_YMMqq_MEMqq,2863,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3602*/ XED_DEF_INST(XED_ICLASS_VUNPCKLPD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VUNPCKLPD_YMMqq_YMMqq_YMMqq,2866,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3603*/ XED_DEF_INST(XED_ICLASS_VPERMPD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMPD_YMMqq_MEMqq_IMMb,3908,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3604*/ XED_DEF_INST(XED_ICLASS_VPERMPD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPERMPD_YMMqq_YMMqq_IMMb,3911,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3605*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3606*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3607*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3608*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3609*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_XMMdq_XMMdq_MEMdq_XMMdq,2825,4,0,0,116,XED_EXCEPTION_INVALID),
/*3610*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_XMMdq_XMMdq_XMMdq_XMMdq,2829,4,0,0,116,XED_EXCEPTION_INVALID),
/*3611*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_XMMdq_XMMdq_XMMdq_MEMdq,2833,4,0,0,116,XED_EXCEPTION_INVALID),
/*3612*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_XMMdq_XMMdq_XMMdq_XMMdq,2837,4,0,0,116,XED_EXCEPTION_INVALID),
/*3613*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_YMMqq_YMMqq_MEMqq_YMMqq,2841,4,0,0,116,XED_EXCEPTION_INVALID),
/*3614*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_YMMqq_YMMqq_YMMqq_YMMqq,2845,4,0,0,116,XED_EXCEPTION_INVALID),
/*3615*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_YMMqq_YMMqq_YMMqq_MEMqq,2849,4,0,0,116,XED_EXCEPTION_INVALID),
/*3616*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPD,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPD_YMMqq_YMMqq_YMMqq_YMMqq,2853,4,0,0,116,XED_EXCEPTION_INVALID),
/*3617*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3618*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3619*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3620*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB213PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3621*/ XED_DEF_INST(XED_ICLASS_KORB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORB_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3622*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHBW_XMMdq_XMMdq_MEMdq,2481,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3623*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHBW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHBW_XMMdq_XMMdq_XMMdq,2484,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3624*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHBW_YMMqq_YMMqq_MEMqq,2869,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3625*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHBW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHBW_YMMqq_YMMqq_YMMqq,2872,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3626*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_XMMdq_XMMdq_MEMdq_XMMdq,3637,4,0,0,116,XED_EXCEPTION_INVALID),
/*3627*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_XMMdq_XMMdq_XMMdq_XMMdq,3641,4,0,0,116,XED_EXCEPTION_INVALID),
/*3628*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_XMMdq_XMMdq_XMMdq_MEMdq,3645,4,0,0,116,XED_EXCEPTION_INVALID),
/*3629*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_XMMdq_XMMdq_XMMdq_XMMdq,3649,4,0,0,116,XED_EXCEPTION_INVALID),
/*3630*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_YMMqq_YMMqq_MEMqq_YMMqq,3653,4,0,0,116,XED_EXCEPTION_INVALID),
/*3631*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_YMMqq_YMMqq_YMMqq_YMMqq,3657,4,0,0,116,XED_EXCEPTION_INVALID),
/*3632*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_YMMqq_YMMqq_YMMqq_MEMqq,3661,4,0,0,116,XED_EXCEPTION_INVALID),
/*3633*/ XED_DEF_INST(XED_ICLASS_VFMSUBADDPS,XED_CATEGORY_FMA4,XED_EXTENSION_FMA4,3,XED_IFORM_VFMSUBADDPS_YMMqq_YMMqq_YMMqq_YMMqq,3665,4,0,0,116,XED_EXCEPTION_INVALID),
/*3634*/ XED_DEF_INST(XED_ICLASS_KXORD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KXORD_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3635*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPD2DQ_XMMdq_MEMdq,3482,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3636*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPD2DQ_XMMdq_XMMdq,3484,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3637*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPD2DQ_XMMdq_MEMqq,3486,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3638*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTPD2DQ_XMMdq_YMMqq,3488,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3639*/ XED_DEF_INST(XED_ICLASS_KSHIFTLD,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTLD_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3640*/ XED_DEF_INST(XED_ICLASS_VFMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3641*/ XED_DEF_INST(XED_ICLASS_VFMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3642*/ XED_DEF_INST(XED_ICLASS_VFMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3643*/ XED_DEF_INST(XED_ICLASS_VFMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3644*/ XED_DEF_INST(XED_ICLASS_VPCMPGTD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3645*/ XED_DEF_INST(XED_ICLASS_VPCMPGTD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3646*/ XED_DEF_INST(XED_ICLASS_VPCMPGTD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3647*/ XED_DEF_INST(XED_ICLASS_VPCMPGTD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3648*/ XED_DEF_INST(XED_ICLASS_KSHIFTLB,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTLB_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3649*/ XED_DEF_INST(XED_ICLASS_VPMADDWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMADDWD_XMMdq_XMMdq_MEMdq,4066,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3650*/ XED_DEF_INST(XED_ICLASS_VPMADDWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMADDWD_XMMdq_XMMdq_XMMdq,4069,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3651*/ XED_DEF_INST(XED_ICLASS_VPMADDWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMADDWD_YMMqq_YMMqq_MEMqq,4072,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3652*/ XED_DEF_INST(XED_ICLASS_VPMADDWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMADDWD_YMMqq_YMMqq_YMMqq,4075,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3653*/ XED_DEF_INST(XED_ICLASS_VAESKEYGENASSIST,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESKEYGENASSIST_XMMdq_XMMdq_IMMb,930,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3654*/ XED_DEF_INST(XED_ICLASS_VAESKEYGENASSIST,XED_CATEGORY_AES,XED_EXTENSION_AVXAES,3,XED_IFORM_VAESKEYGENASSIST_XMMdq_MEMdq_IMMb,933,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3655*/ XED_DEF_INST(XED_ICLASS_VPCMPGTQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTQ_XMMdq_XMMdq_MEMdq,4078,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3656*/ XED_DEF_INST(XED_ICLASS_VPCMPGTQ,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTQ_XMMdq_XMMdq_XMMdq,4081,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3657*/ XED_DEF_INST(XED_ICLASS_VPCMPGTQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTQ_YMMqq_YMMqq_MEMqq,3743,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3658*/ XED_DEF_INST(XED_ICLASS_VPCMPGTQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTQ_YMMqq_YMMqq_YMMqq,3746,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3659*/ XED_DEF_INST(XED_ICLASS_KSHIFTLW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KSHIFTLW_MASKmskw_MASKmskw_IMM8_AVX512,3471,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3660*/ XED_DEF_INST(XED_ICLASS_VFMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3661*/ XED_DEF_INST(XED_ICLASS_VFMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3662*/ XED_DEF_INST(XED_ICLASS_VFMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3663*/ XED_DEF_INST(XED_ICLASS_VFMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADD213PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3664*/ XED_DEF_INST(XED_ICLASS_VPCMPGTW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3665*/ XED_DEF_INST(XED_ICLASS_VPCMPGTW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPCMPGTW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3666*/ XED_DEF_INST(XED_ICLASS_VPCMPGTW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3667*/ XED_DEF_INST(XED_ICLASS_VPCMPGTW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPCMPGTW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3668*/ XED_DEF_INST(XED_ICLASS_VPHMINPOSUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHMINPOSUW_XMMdq_MEMdq,4084,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3669*/ XED_DEF_INST(XED_ICLASS_VPHMINPOSUW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHMINPOSUW_XMMdq_XMMdq,4086,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3670*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPABSD_XMMdq_MEMdq,4088,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3671*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPABSD_XMMdq_XMMdq,4090,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3672*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPABSD_YMMqq_MEMqq,4092,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3673*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPABSD_YMMqq_YMMqq,4094,2,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3674*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3675*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3676*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3677*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3678*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXWD_XMMdq_XMMq,2353,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3679*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPMOVZXWD_XMMdq_MEMq,2351,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3680*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXWD_YMMqq_XMMdq,4096,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3681*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPMOVZXWD_YMMqq_MEMdq,4098,2,0,0,0,XED_EXCEPTION_AVX_TYPE_5),
/*3682*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3683*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3684*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3685*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMADDSUB132PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3686*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3687*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3688*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3689*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3690*/ XED_DEF_INST(XED_ICLASS_KORW,XED_CATEGORY_KMASK,XED_EXTENSION_AVX512VEX,3,XED_IFORM_KORW_MASKmskw_MASKmskw_MASKmskw_AVX512,2875,3,0,0,118,XED_EXCEPTION_AVX512_K20),
/*3691*/ XED_DEF_INST(XED_ICLASS_VPGATHERDD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERDD_YMMu32_MEMd_YMMi32_VL256,4100,3,0,0,122,XED_EXCEPTION_AVX_TYPE_12),
/*3692*/ XED_DEF_INST(XED_ICLASS_VPGATHERDD,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERDD_XMMu32_MEMd_XMMi32_VL128,3465,3,0,0,122,XED_EXCEPTION_AVX_TYPE_12),
/*3693*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHWD_XMMdq_XMMdq_MEMdq,2519,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3694*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHWD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPUNPCKHWD_XMMdq_XMMdq_XMMdq,2522,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3695*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHWD_YMMqq_YMMqq_MEMqq,2734,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3696*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHWD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPUNPCKHWD_YMMqq_YMMqq_YMMqq,2737,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3697*/ XED_DEF_INST(XED_ICLASS_VPGATHERDQ,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERDQ_YMMu64_MEMq_YMMi64_VL256,3490,3,0,0,123,XED_EXCEPTION_AVX_TYPE_12),
/*3698*/ XED_DEF_INST(XED_ICLASS_VPGATHERDQ,XED_CATEGORY_AVX2GATHER,XED_EXTENSION_AVX2GATHER,3,XED_IFORM_VPGATHERDQ_XMMu64_MEMq_XMMi64_VL128,3493,3,0,0,123,XED_EXCEPTION_AVX_TYPE_12),
/*3699*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PS_XMMdq_XMMdq_MEMdq,2748,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3700*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PS_XMMdq_XMMdq_XMMdq,2751,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3701*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PS_YMMqq_YMMqq_MEMqq,2754,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3702*/ XED_DEF_INST(XED_ICLASS_VFNMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFNMADD132PS_YMMqq_YMMqq_YMMqq,2757,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3703*/ XED_DEF_INST(XED_ICLASS_VPHSUBSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHSUBSW_XMMdq_XMMdq_MEMdq,2555,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3704*/ XED_DEF_INST(XED_ICLASS_VPHSUBSW,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPHSUBSW_XMMdq_XMMdq_XMMdq,2558,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3705*/ XED_DEF_INST(XED_ICLASS_VPHSUBSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHSUBSW_YMMqq_YMMqq_MEMqq,2811,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3706*/ XED_DEF_INST(XED_ICLASS_VPHSUBSW,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPHSUBSW_YMMqq_YMMqq_YMMqq,2814,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3707*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSD2SI_GPR32d_MEMq,4038,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3708*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSD2SI_GPR32d_XMMq,4040,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3709*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSD2SI_GPR32d_MEMq,4038,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3710*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSD2SI_GPR32d_XMMq,4040,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3711*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSD2SI_GPR64q_MEMq,4042,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3712*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTTSD2SI_GPR64q_XMMq,4044,2,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3713*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PD_XMMdq_XMMdq_MEMdq,2760,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3714*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PD_XMMdq_XMMdq_XMMdq,2763,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3715*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PD_YMMqq_YMMqq_MEMqq,2766,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3716*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_FMA,3,XED_IFORM_VFMSUB231PD_YMMqq_YMMqq_YMMqq,2769,3,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3717*/ XED_DEF_INST(XED_ICLASS_VCVTPD2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2PS_XMMdq_MEMdq,4103,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3718*/ XED_DEF_INST(XED_ICLASS_VCVTPD2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2PS_XMMdq_XMMdq,4105,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3719*/ XED_DEF_INST(XED_ICLASS_VCVTPD2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2PS_XMMdq_MEMqq,4107,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3720*/ XED_DEF_INST(XED_ICLASS_VCVTPD2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPD2PS_XMMdq_YMMqq,4109,2,0,0,26,XED_EXCEPTION_AVX_TYPE_2),
/*3721*/ XED_DEF_INST(XED_ICLASS_VPSLLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVD_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3722*/ XED_DEF_INST(XED_ICLASS_VPSLLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVD_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3723*/ XED_DEF_INST(XED_ICLASS_VPSLLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVD_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3724*/ XED_DEF_INST(XED_ICLASS_VPSLLVD,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVD_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3725*/ XED_DEF_INST(XED_ICLASS_BLSI,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSI_VGPR32d_MEMd,2359,3,96,0,0,XED_EXCEPTION_INVALID),
/*3726*/ XED_DEF_INST(XED_ICLASS_BLSI,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSI_VGPR32d_MEMd,2359,3,96,0,0,XED_EXCEPTION_INVALID),
/*3727*/ XED_DEF_INST(XED_ICLASS_BLSI,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSI_VGPR32d_VGPR32d,2884,3,96,0,0,XED_EXCEPTION_INVALID),
/*3728*/ XED_DEF_INST(XED_ICLASS_BLSI,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSI_VGPR32d_VGPR32d,2884,3,96,0,0,XED_EXCEPTION_INVALID),
/*3729*/ XED_DEF_INST(XED_ICLASS_BLSI,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSI_VGPR64q_MEMq,2887,3,96,0,0,XED_EXCEPTION_INVALID),
/*3730*/ XED_DEF_INST(XED_ICLASS_BLSI,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSI_VGPR64q_VGPR64q,2890,3,96,0,0,XED_EXCEPTION_INVALID),
/*3731*/ XED_DEF_INST(XED_ICLASS_VADDSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSD_XMMdq_XMMdq_MEMq,3015,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3732*/ XED_DEF_INST(XED_ICLASS_VADDSD,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSD_XMMdq_XMMdq_XMMq,2722,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3733*/ XED_DEF_INST(XED_ICLASS_BLSR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSR_VGPR32d_MEMd,2359,3,94,0,0,XED_EXCEPTION_INVALID),
/*3734*/ XED_DEF_INST(XED_ICLASS_BLSR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSR_VGPR32d_MEMd,2359,3,94,0,0,XED_EXCEPTION_INVALID),
/*3735*/ XED_DEF_INST(XED_ICLASS_BLSR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSR_VGPR32d_VGPR32d,2884,3,94,0,0,XED_EXCEPTION_INVALID),
/*3736*/ XED_DEF_INST(XED_ICLASS_BLSR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSR_VGPR32d_VGPR32d,2884,3,94,0,0,XED_EXCEPTION_INVALID),
/*3737*/ XED_DEF_INST(XED_ICLASS_BLSR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSR_VGPR64q_MEMq,2887,3,94,0,0,XED_EXCEPTION_INVALID),
/*3738*/ XED_DEF_INST(XED_ICLASS_BLSR,XED_CATEGORY_BMI1,XED_EXTENSION_BMI1,3,XED_IFORM_BLSR_VGPR64q_VGPR64q,2890,3,94,0,0,XED_EXCEPTION_INVALID),
/*3739*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PH,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPS2PH_MEMq_XMMdq_IMMb,4111,3,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*3740*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PH,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPS2PH_XMMq_XMMdq_IMMb,4114,3,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*3741*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PH,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPS2PH_MEMdq_YMMqq_IMMb,4117,3,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*3742*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PH,XED_CATEGORY_CONVERT,XED_EXTENSION_F16C,3,XED_IFORM_VCVTPS2PH_XMMdq_YMMqq_IMMb,4120,3,0,0,26,XED_EXCEPTION_AVX_TYPE_11),
/*3743*/ XED_DEF_INST(XED_ICLASS_VPACKSSWB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKSSWB_XMMdq_XMMdq_MEMdq,4123,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3744*/ XED_DEF_INST(XED_ICLASS_VPACKSSWB,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VPACKSSWB_XMMdq_XMMdq_XMMdq,4126,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3745*/ XED_DEF_INST(XED_ICLASS_VPACKSSWB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKSSWB_YMMqq_YMMqq_MEMqq,4129,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3746*/ XED_DEF_INST(XED_ICLASS_VPACKSSWB,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPACKSSWB_YMMqq_YMMqq_YMMqq,4132,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3747*/ XED_DEF_INST(XED_ICLASS_VADDSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSS_XMMdq_XMMdq_MEMd,2784,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3748*/ XED_DEF_INST(XED_ICLASS_VADDSS,XED_CATEGORY_AVX,XED_EXTENSION_AVX,3,XED_IFORM_VADDSS_XMMdq_XMMdq_XMMd,2740,3,0,0,41,XED_EXCEPTION_AVX_TYPE_3),
/*3749*/ XED_DEF_INST(XED_ICLASS_VPSLLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVQ_XMMdq_XMMdq_MEMdq,2377,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3750*/ XED_DEF_INST(XED_ICLASS_VPSLLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVQ_XMMdq_XMMdq_XMMdq,2380,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3751*/ XED_DEF_INST(XED_ICLASS_VPSLLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVQ_YMMqq_YMMqq_MEMqq,2991,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3752*/ XED_DEF_INST(XED_ICLASS_VPSLLVQ,XED_CATEGORY_AVX2,XED_EXTENSION_AVX2,3,XED_IFORM_VPSLLVQ_YMMqq_YMMqq_YMMqq,2994,3,0,0,0,XED_EXCEPTION_AVX_TYPE_4),
/*3753*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2PD_XMMdq_MEMq,4135,2,0,0,26,XED_EXCEPTION_AVX_TYPE_3),
/*3754*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2PD_XMMdq_XMMq,4137,2,0,0,26,XED_EXCEPTION_AVX_TYPE_3),
/*3755*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2PD_YMMqq_MEMdq,4139,2,0,0,26,XED_EXCEPTION_AVX_TYPE_3),
/*3756*/ XED_DEF_INST(XED_ICLASS_VCVTPS2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX,3,XED_IFORM_VCVTPS2PD_YMMqq_XMMdq,4141,2,0,0,26,XED_EXCEPTION_AVX_TYPE_3),
/*3757*/ XED_DEF_INST(XED_ICLASS_VFPCLASSSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSSS_MASKmskw_MASKmskw_XMMf32_IMM8_AVX512,4143,4,0,0,127,XED_EXCEPTION_AVX512_E6),
/*3758*/ XED_DEF_INST(XED_ICLASS_VFPCLASSSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSSS_MASKmskw_MASKmskw_MEMf32_IMM8_AVX512,4147,4,0,0,128,XED_EXCEPTION_AVX512_E6),
/*3759*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSD_XMMf64_MASKmskw_MEMf64_AVX512,4151,3,0,0,129,XED_EXCEPTION_AVX512_E5),
/*3760*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSD_MEMf64_MASKmskw_XMMf64_AVX512,4154,3,0,0,129,XED_EXCEPTION_AVX512_E5),
/*3761*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,130,XED_EXCEPTION_AVX512_E5),
/*3762*/ XED_DEF_INST(XED_ICLASS_VMOVSD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4161,4,0,0,130,XED_EXCEPTION_AVX512_E5),
/*3763*/ XED_DEF_INST(XED_ICLASS_VPSHLDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDD_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512,4165,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3764*/ XED_DEF_INST(XED_ICLASS_VPSHLDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDD_XMMu32_MASKmskw_XMMu32_MEMu32_IMM8_AVX512,4170,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3765*/ XED_DEF_INST(XED_ICLASS_VPSHLDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDD_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512,4175,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3766*/ XED_DEF_INST(XED_ICLASS_VPSHLDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDD_YMMu32_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,4180,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3767*/ XED_DEF_INST(XED_ICLASS_VPSHLDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512,4185,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3768*/ XED_DEF_INST(XED_ICLASS_VPSHLDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDD_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,4190,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3769*/ XED_DEF_INST(XED_ICLASS_VFPCLASSSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSSD_MASKmskw_MASKmskw_XMMf64_IMM8_AVX512,4195,4,0,0,127,XED_EXCEPTION_AVX512_E6),
/*3770*/ XED_DEF_INST(XED_ICLASS_VFPCLASSSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSSD_MASKmskw_MASKmskw_MEMf64_IMM8_AVX512,4199,4,0,0,128,XED_EXCEPTION_AVX512_E6),
/*3771*/ XED_DEF_INST(XED_ICLASS_VPTESTNMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_XMMu16_XMMu16_AVX512,4203,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3772*/ XED_DEF_INST(XED_ICLASS_VPTESTNMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_XMMu16_MEMu16_AVX512,4207,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3773*/ XED_DEF_INST(XED_ICLASS_VPTESTNMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_YMMu16_YMMu16_AVX512,4211,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3774*/ XED_DEF_INST(XED_ICLASS_VPTESTNMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_YMMu16_MEMu16_AVX512,4215,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3775*/ XED_DEF_INST(XED_ICLASS_VPTESTNMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_AVX512,4219,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3776*/ XED_DEF_INST(XED_ICLASS_VPTESTNMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_ZMMu16_MEMu16_AVX512,4223,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3777*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHUW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3778*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHUW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3779*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHUW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3780*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHUW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3781*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHUW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3782*/ XED_DEF_INST(XED_ICLASS_VPMULHUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHUW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3783*/ XED_DEF_INST(XED_ICLASS_VPSHLDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512,4251,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3784*/ XED_DEF_INST(XED_ICLASS_VPSHLDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDQ_XMMu64_MASKmskw_XMMu64_MEMu64_IMM8_AVX512,4256,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3785*/ XED_DEF_INST(XED_ICLASS_VPSHLDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512,4261,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3786*/ XED_DEF_INST(XED_ICLASS_VPSHLDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDQ_YMMu64_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,4266,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3787*/ XED_DEF_INST(XED_ICLASS_VPSHLDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512,4271,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3788*/ XED_DEF_INST(XED_ICLASS_VPSHLDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,4276,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3789*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSS_XMMf32_MASKmskw_MEMf32_AVX512,4281,3,0,0,129,XED_EXCEPTION_AVX512_E5),
/*3790*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSS_MEMf32_MASKmskw_XMMf32_AVX512,4284,3,0,0,129,XED_EXCEPTION_AVX512_E5),
/*3791*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,130,XED_EXCEPTION_AVX512_E5),
/*3792*/ XED_DEF_INST(XED_ICLASS_VMOVSS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4291,4,0,0,130,XED_EXCEPTION_AVX512_E5),
/*3793*/ XED_DEF_INST(XED_ICLASS_VPSHLDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDW_XMMu16_MASKmskw_XMMu16_XMMu16_IMM8_AVX512,4295,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3794*/ XED_DEF_INST(XED_ICLASS_VPSHLDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDW_XMMu16_MASKmskw_XMMu16_MEMu16_IMM8_AVX512,4300,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3795*/ XED_DEF_INST(XED_ICLASS_VPSHLDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDW_YMMu16_MASKmskw_YMMu16_YMMu16_IMM8_AVX512,4305,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3796*/ XED_DEF_INST(XED_ICLASS_VPSHLDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDW_YMMu16_MASKmskw_YMMu16_MEMu16_IMM8_AVX512,4310,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3797*/ XED_DEF_INST(XED_ICLASS_VPSHLDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_IMM8_AVX512,4315,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3798*/ XED_DEF_INST(XED_ICLASS_VPSHLDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDW_ZMMu16_MASKmskw_ZMMu16_MEMu16_IMM8_AVX512,4320,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3799*/ XED_DEF_INST(XED_ICLASS_VRSQRT14SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT14SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E10),
/*3800*/ XED_DEF_INST(XED_ICLASS_VRSQRT14SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT14SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E10),
/*3801*/ XED_DEF_INST(XED_ICLASS_VPROLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3802*/ XED_DEF_INST(XED_ICLASS_VPROLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3803*/ XED_DEF_INST(XED_ICLASS_VPROLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3804*/ XED_DEF_INST(XED_ICLASS_VPROLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3805*/ XED_DEF_INST(XED_ICLASS_VPROLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3806*/ XED_DEF_INST(XED_ICLASS_VPROLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3807*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3808*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3809*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3810*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3811*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3812*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3813*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3814*/ XED_DEF_INST(XED_ICLASS_VRSQRT14SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT14SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E10),
/*3815*/ XED_DEF_INST(XED_ICLASS_VRSQRT14SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT14SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E10),
/*3816*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3817*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3818*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3819*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3820*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3821*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3822*/ XED_DEF_INST(XED_ICLASS_VFMADDSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADDSUB231PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3823*/ XED_DEF_INST(XED_ICLASS_VPTESTNMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_AVX512,4413,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3824*/ XED_DEF_INST(XED_ICLASS_VPTESTNMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_ZMMu64_MEMu64_AVX512,4417,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3825*/ XED_DEF_INST(XED_ICLASS_VPTESTNMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_XMMu64_XMMu64_AVX512,4421,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3826*/ XED_DEF_INST(XED_ICLASS_VPTESTNMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_XMMu64_MEMu64_AVX512,4425,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3827*/ XED_DEF_INST(XED_ICLASS_VPTESTNMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_YMMu64_YMMu64_AVX512,4429,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3828*/ XED_DEF_INST(XED_ICLASS_VPTESTNMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_YMMu64_MEMu64_AVX512,4433,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3829*/ XED_DEF_INST(XED_ICLASS_VPROLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3830*/ XED_DEF_INST(XED_ICLASS_VPROLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3831*/ XED_DEF_INST(XED_ICLASS_VPROLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3832*/ XED_DEF_INST(XED_ICLASS_VPROLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3833*/ XED_DEF_INST(XED_ICLASS_VPROLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3834*/ XED_DEF_INST(XED_ICLASS_VPROLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLVQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3835*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512,4461,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3836*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_XMMf64_MASKmskw_MEMf64_IMM8_AVX512,4465,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3837*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512,4469,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3838*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_YMMf64_MASKmskw_MEMf64_IMM8_AVX512,4473,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3839*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4477,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3840*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4481,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3841*/ XED_DEF_INST(XED_ICLASS_VREDUCEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCEPD_ZMMf64_MASKmskw_MEMf64_IMM8_AVX512,4485,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3842*/ XED_DEF_INST(XED_ICLASS_V4FNMADDPS,XED_CATEGORY_AVX512_4FMAPS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_V4FNMADDPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4489,4,0,0,136,XED_EXCEPTION_AVX512_E2),
/*3843*/ XED_DEF_INST(XED_ICLASS_VPSHRDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4493,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3844*/ XED_DEF_INST(XED_ICLASS_VPSHRDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4497,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3845*/ XED_DEF_INST(XED_ICLASS_VPSHRDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4501,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3846*/ XED_DEF_INST(XED_ICLASS_VPSHRDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4505,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3847*/ XED_DEF_INST(XED_ICLASS_VPSHRDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4509,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3848*/ XED_DEF_INST(XED_ICLASS_VPSHRDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4513,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3849*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULUDQ_ZMMu64_MASKmskw_ZMMu32_ZMMu32_AVX512,4517,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3850*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULUDQ_ZMMu64_MASKmskw_ZMMu32_MEMu32_AVX512,4521,4,0,0,137,XED_EXCEPTION_AVX512_E4),
/*3851*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULUDQ_XMMu64_MASKmskw_XMMu32_XMMu32_AVX512,4525,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3852*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULUDQ_XMMu64_MASKmskw_XMMu32_MEMu32_AVX512,4529,4,0,0,137,XED_EXCEPTION_AVX512_E4),
/*3853*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULUDQ_YMMu64_MASKmskw_YMMu32_YMMu32_AVX512,4533,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3854*/ XED_DEF_INST(XED_ICLASS_VPMULUDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULUDQ_YMMu64_MASKmskw_YMMu32_MEMu32_AVX512,4537,4,0,0,137,XED_EXCEPTION_AVX512_E4),
/*3855*/ XED_DEF_INST(XED_ICLASS_VPSHRDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4541,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3856*/ XED_DEF_INST(XED_ICLASS_VPSHRDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4545,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3857*/ XED_DEF_INST(XED_ICLASS_VPSHRDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4549,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3858*/ XED_DEF_INST(XED_ICLASS_VPSHRDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4553,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3859*/ XED_DEF_INST(XED_ICLASS_VPSHRDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4557,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3860*/ XED_DEF_INST(XED_ICLASS_VPSHRDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4561,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3861*/ XED_DEF_INST(XED_ICLASS_VPROLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512,4565,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3862*/ XED_DEF_INST(XED_ICLASS_VPROLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLQ_ZMMu64_MASKmskw_MEMu64_IMM8_AVX512,4569,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3863*/ XED_DEF_INST(XED_ICLASS_VPROLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512,4573,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3864*/ XED_DEF_INST(XED_ICLASS_VPROLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLQ_XMMu64_MASKmskw_MEMu64_IMM8_AVX512,4577,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3865*/ XED_DEF_INST(XED_ICLASS_VPROLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512,4581,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3866*/ XED_DEF_INST(XED_ICLASS_VPROLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLQ_YMMu64_MASKmskw_MEMu64_IMM8_AVX512,4585,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3867*/ XED_DEF_INST(XED_ICLASS_VPSHRDVQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4589,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3868*/ XED_DEF_INST(XED_ICLASS_VPSHRDVQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4593,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3869*/ XED_DEF_INST(XED_ICLASS_VPSHRDVQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4597,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3870*/ XED_DEF_INST(XED_ICLASS_VPSHRDVQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4601,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3871*/ XED_DEF_INST(XED_ICLASS_VPSHRDVQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4605,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3872*/ XED_DEF_INST(XED_ICLASS_VPSHRDVQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDVQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4609,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3873*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLDQ_XMMu8_XMMu8_IMM8_AVX512,4613,3,0,0,0,XED_EXCEPTION_AVX512_E4NF),
/*3874*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLDQ_XMMu8_MEMu8_IMM8_AVX512,4616,3,0,0,138,XED_EXCEPTION_AVX512_E4NF),
/*3875*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLDQ_YMMu8_YMMu8_IMM8_AVX512,4619,3,0,0,0,XED_EXCEPTION_AVX512_E4NF),
/*3876*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLDQ_YMMu8_MEMu8_IMM8_AVX512,4622,3,0,0,138,XED_EXCEPTION_AVX512_E4NF),
/*3877*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLDQ_ZMMu8_ZMMu8_IMM8_AVX512,4625,3,0,0,0,XED_EXCEPTION_AVX512_E4NF),
/*3878*/ XED_DEF_INST(XED_ICLASS_VPSLLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLDQ_ZMMu8_MEMu8_IMM8_AVX512,4628,3,0,0,138,XED_EXCEPTION_AVX512_E4NF),
/*3879*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512,4631,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3880*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,4636,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3881*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512,4641,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3882*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGQ_XMMu64_MASKmskw_XMMu64_MEMu64_IMM8_AVX512,4646,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3883*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512,4651,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3884*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGQ_YMMu64_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,4656,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3885*/ XED_DEF_INST(XED_ICLASS_VRANGESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRANGESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4661,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*3886*/ XED_DEF_INST(XED_ICLASS_VRANGESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRANGESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4666,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*3887*/ XED_DEF_INST(XED_ICLASS_VRANGESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRANGESD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,4671,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*3888*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_XMMu64_MASKmskw_XMMf32_AVX512,4676,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*3889*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_XMMu64_MASKmskw_MEMf32_AVX512,4679,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*3890*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_YMMu64_MASKmskw_XMMf32_AVX512,4682,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*3891*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_YMMu64_MASKmskw_MEMf32_AVX512,4685,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*3892*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_ZMMu64_MASKmskw_YMMf32_AVX512,4688,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*3893*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_ZMMu64_MASKmskw_YMMf32_AVX512,4691,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*3894*/ XED_DEF_INST(XED_ICLASS_VCVTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2UQQ_ZMMu64_MASKmskw_MEMf32_AVX512,4694,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*3895*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512,4697,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3896*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGD_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,4702,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3897*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGD_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512,4707,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3898*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGD_XMMu32_MASKmskw_XMMu32_MEMu32_IMM8_AVX512,4712,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3899*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGD_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512,4717,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3900*/ XED_DEF_INST(XED_ICLASS_VPTERNLOGD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTERNLOGD_YMMu32_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,4722,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*3901*/ XED_DEF_INST(XED_ICLASS_VRANGESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRANGESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4727,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*3902*/ XED_DEF_INST(XED_ICLASS_VRANGESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRANGESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4732,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*3903*/ XED_DEF_INST(XED_ICLASS_VRANGESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRANGESS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,4737,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*3904*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_XMMu64_GPR64u64_AVX512,4742,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3905*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_XMMu64_MEMu64_AVX512,4744,2,0,0,140,XED_EXCEPTION_AVX512_E9NF),
/*3906*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_GPR64u64_XMMu64_AVX512,4746,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3907*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_MEMu64_XMMu64_AVX512,4748,2,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*3908*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_XMMu64_XMMu64_AVX512,4750,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3909*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_XMMu64_MEMu64_AVX512,4744,2,0,0,142,XED_EXCEPTION_AVX512_E9NF),
/*3910*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_XMMu64_XMMu64_AVX512,4752,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3911*/ XED_DEF_INST(XED_ICLASS_VMOVQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVQ_MEMu64_XMMu64_AVX512,4748,2,0,0,142,XED_EXCEPTION_AVX512_E9NF),
/*3912*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_XMMu32_GPR32u32_AVX512,4754,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3913*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_XMMu32_GPR32u32_AVX512,4754,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3914*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_XMMu32_MEMu32_AVX512,4756,2,0,0,140,XED_EXCEPTION_AVX512_E9NF),
/*3915*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_XMMu32_MEMu32_AVX512,4756,2,0,0,140,XED_EXCEPTION_AVX512_E9NF),
/*3916*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_GPR32u32_XMMu32_AVX512,4758,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3917*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_GPR32u32_XMMu32_AVX512,4758,2,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*3918*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_MEMu32_XMMu32_AVX512,4760,2,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*3919*/ XED_DEF_INST(XED_ICLASS_VMOVD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVD_MEMu32_XMMu32_AVX512,4760,2,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*3920*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHRSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512,4762,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3921*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHRSW_XMMi16_MASKmskw_XMMi16_MEMi16_AVX512,4766,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3922*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHRSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512,4770,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3923*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHRSW_YMMi16_MASKmskw_YMMi16_MEMi16_AVX512,4774,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3924*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHRSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512,4778,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3925*/ XED_DEF_INST(XED_ICLASS_VPMULHRSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHRSW_ZMMi16_MASKmskw_ZMMi16_MEMi16_AVX512,4782,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*3926*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3927*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3928*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3929*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3930*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3931*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3932*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD231PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3933*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3934*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3935*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3936*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3937*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3938*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3939*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3940*/ XED_DEF_INST(XED_ICLASS_VPMOVDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDB_XMMu8_MASKmskw_ZMMu32_AVX512,4786,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3941*/ XED_DEF_INST(XED_ICLASS_VPMOVDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDB_MEMu8_MASKmskw_ZMMu32_AVX512,4789,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*3942*/ XED_DEF_INST(XED_ICLASS_VPMOVDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDB_XMMu8_MASKmskw_XMMu32_AVX512,4792,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3943*/ XED_DEF_INST(XED_ICLASS_VPMOVDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDB_MEMu8_MASKmskw_XMMu32_AVX512,4795,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*3944*/ XED_DEF_INST(XED_ICLASS_VPMOVDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDB_XMMu8_MASKmskw_YMMu32_AVX512,4798,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3945*/ XED_DEF_INST(XED_ICLASS_VPMOVDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDB_MEMu8_MASKmskw_YMMu32_AVX512,4801,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*3946*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3947*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3948*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3949*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3950*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3951*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3952*/ XED_DEF_INST(XED_ICLASS_VFMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3953*/ XED_DEF_INST(XED_ICLASS_VINSERTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTF64X2_YMMf64_MASKmskw_YMMf64_XMMf64_IMM8_AVX512,4804,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3954*/ XED_DEF_INST(XED_ICLASS_VINSERTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTF64X2_YMMf64_MASKmskw_YMMf64_MEMf64_IMM8_AVX512,4809,5,0,0,144,XED_EXCEPTION_AVX512_E6NF),
/*3955*/ XED_DEF_INST(XED_ICLASS_VINSERTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTF64X2_ZMMf64_MASKmskw_ZMMf64_XMMf64_IMM8_AVX512,4814,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3956*/ XED_DEF_INST(XED_ICLASS_VINSERTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTF64X2_ZMMf64_MASKmskw_ZMMf64_MEMf64_IMM8_AVX512,4819,5,0,0,144,XED_EXCEPTION_AVX512_E6NF),
/*3957*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSW,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSW_MEMu16_MASKmskw_XMMu16_AVX512,4824,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*3958*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSW,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSW_XMMu16_MASKmskw_XMMu16_AVX512,4827,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3959*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSW,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSW_MEMu16_MASKmskw_YMMu16_AVX512,4830,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*3960*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSW,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSW_YMMu16_MASKmskw_YMMu16_AVX512,4833,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3961*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSW,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSW_MEMu16_MASKmskw_ZMMu16_AVX512,4836,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*3962*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSW,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSW_ZMMu16_MASKmskw_ZMMu16_AVX512,4839,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3963*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLBW_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3964*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLBW_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*3965*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLBW_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3966*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLBW_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*3967*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLBW_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3968*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLBW_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*3969*/ XED_DEF_INST(XED_ICLASS_VINSERTF64X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTF64X4_ZMMf64_MASKmskw_ZMMf64_YMMf64_IMM8_AVX512,4866,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3970*/ XED_DEF_INST(XED_ICLASS_VINSERTF64X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTF64X4_ZMMf64_MASKmskw_ZMMf64_MEMf64_IMM8_AVX512,4871,5,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*3971*/ XED_DEF_INST(XED_ICLASS_VPERMB,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3972*/ XED_DEF_INST(XED_ICLASS_VPERMB,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMB_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*3973*/ XED_DEF_INST(XED_ICLASS_VPERMB,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3974*/ XED_DEF_INST(XED_ICLASS_VPERMB,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMB_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*3975*/ XED_DEF_INST(XED_ICLASS_VPERMB,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3976*/ XED_DEF_INST(XED_ICLASS_VPERMB,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMB_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*3977*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_XMMu64_MASKmskw_XMMf64_AVX512,4876,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3978*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_XMMu64_MASKmskw_MEMf64_AVX512,4879,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3979*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_YMMu64_MASKmskw_YMMf64_AVX512,4882,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3980*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_YMMu64_MASKmskw_MEMf64_AVX512,4885,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3981*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_ZMMu64_MASKmskw_ZMMf64_AVX512,4888,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3982*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_ZMMu64_MASKmskw_ZMMf64_AVX512,4891,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*3983*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UQQ_ZMMu64_MASKmskw_MEMf64_AVX512,4894,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*3984*/ XED_DEF_INST(XED_ICLASS_VINSERTI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI32X4_ZMMu32_MASKmskw_ZMMu32_XMMu32_IMM8_AVX512,4897,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3985*/ XED_DEF_INST(XED_ICLASS_VINSERTI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI32X4_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,4902,5,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*3986*/ XED_DEF_INST(XED_ICLASS_VINSERTI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI32X4_YMMu32_MASKmskw_YMMu32_XMMu32_IMM8_AVX512,4907,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3987*/ XED_DEF_INST(XED_ICLASS_VINSERTI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI32X4_YMMu32_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,4912,5,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*3988*/ XED_DEF_INST(XED_ICLASS_VPERMD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3989*/ XED_DEF_INST(XED_ICLASS_VPERMD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*3990*/ XED_DEF_INST(XED_ICLASS_VPERMD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*3991*/ XED_DEF_INST(XED_ICLASS_VPERMD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*3992*/ XED_DEF_INST(XED_ICLASS_VPMOVSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDB_XMMi8_MASKmskw_ZMMi32_AVX512,4917,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3993*/ XED_DEF_INST(XED_ICLASS_VPMOVSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDB_MEMi8_MASKmskw_ZMMi32_AVX512,4920,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*3994*/ XED_DEF_INST(XED_ICLASS_VPMOVSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDB_XMMi8_MASKmskw_XMMi32_AVX512,4923,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3995*/ XED_DEF_INST(XED_ICLASS_VPMOVSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDB_MEMi8_MASKmskw_XMMi32_AVX512,4926,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*3996*/ XED_DEF_INST(XED_ICLASS_VPMOVSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDB_XMMi8_MASKmskw_YMMi32_AVX512,4929,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*3997*/ XED_DEF_INST(XED_ICLASS_VPMOVSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDB_MEMi8_MASKmskw_YMMi32_AVX512,4932,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*3998*/ XED_DEF_INST(XED_ICLASS_VPLZCNTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTD_ZMMu32_MASKmskw_ZMMu32_AVX512CD,4935,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*3999*/ XED_DEF_INST(XED_ICLASS_VPLZCNTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTD_ZMMu32_MASKmskw_MEMu32_AVX512CD,4938,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4000*/ XED_DEF_INST(XED_ICLASS_VPLZCNTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTD_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4001*/ XED_DEF_INST(XED_ICLASS_VPLZCNTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTD_XMMu32_MASKmskw_MEMu32_AVX512,4944,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4002*/ XED_DEF_INST(XED_ICLASS_VPLZCNTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTD_YMMu32_MASKmskw_YMMu32_AVX512,4947,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4003*/ XED_DEF_INST(XED_ICLASS_VPLZCNTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTD_YMMu32_MASKmskw_MEMu32_AVX512,4950,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4004*/ XED_DEF_INST(XED_ICLASS_VPMOVDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDW_YMMu16_MASKmskw_ZMMu32_AVX512,4953,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4005*/ XED_DEF_INST(XED_ICLASS_VPMOVDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDW_MEMu16_MASKmskw_ZMMu32_AVX512,4956,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4006*/ XED_DEF_INST(XED_ICLASS_VPMOVDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDW_XMMu16_MASKmskw_XMMu32_AVX512,4959,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4007*/ XED_DEF_INST(XED_ICLASS_VPMOVDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDW_MEMu16_MASKmskw_XMMu32_AVX512,4962,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4008*/ XED_DEF_INST(XED_ICLASS_VPMOVDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDW_XMMu16_MASKmskw_YMMu32_AVX512,4965,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4009*/ XED_DEF_INST(XED_ICLASS_VPMOVDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVDW_MEMu16_MASKmskw_YMMu32_AVX512,4968,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4010*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_ZMMf32_MASKmskw_YMMf16_AVX512,4971,3,0,0,134,XED_EXCEPTION_AVX512_E11),
/*4011*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_ZMMf32_MASKmskw_YMMf16_AVX512,4974,3,0,0,134,XED_EXCEPTION_AVX512_E11),
/*4012*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_ZMMf32_MASKmskw_MEMf16_AVX512,4977,3,0,0,150,XED_EXCEPTION_AVX512_E11),
/*4013*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_XMMf32_MASKmskw_XMMf16_AVX512,4980,3,0,0,134,XED_EXCEPTION_AVX512_E11),
/*4014*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_XMMf32_MASKmskw_MEMf16_AVX512,4983,3,0,0,150,XED_EXCEPTION_AVX512_E11),
/*4015*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_YMMf32_MASKmskw_XMMf16_AVX512,4986,3,0,0,134,XED_EXCEPTION_AVX512_E11),
/*4016*/ XED_DEF_INST(XED_ICLASS_VCVTPH2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPH2PS_YMMf32_MASKmskw_MEMf16_AVX512,4989,3,0,0,150,XED_EXCEPTION_AVX512_E11),
/*4017*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512,4992,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4018*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_ZMMu64_MASKmskw_MEMu64_IMM8_AVX512,4996,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4019*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4020*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4021*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512,5000,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4022*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_YMMu64_MASKmskw_MEMu64_IMM8_AVX512,5004,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4023*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4024*/ XED_DEF_INST(XED_ICLASS_VPERMQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4025*/ XED_DEF_INST(XED_ICLASS_VPERMW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4026*/ XED_DEF_INST(XED_ICLASS_VPERMW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4027*/ XED_DEF_INST(XED_ICLASS_VPERMW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4028*/ XED_DEF_INST(XED_ICLASS_VPERMW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4029*/ XED_DEF_INST(XED_ICLASS_VPERMW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4030*/ XED_DEF_INST(XED_ICLASS_VPERMW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4031*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSHDUP_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4032*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSHDUP_ZMMf32_MASKmskw_MEMf32_AVX512,5011,3,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4033*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSHDUP_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4034*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSHDUP_XMMf32_MASKmskw_MEMf32_AVX512,5017,3,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4035*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSHDUP_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4036*/ XED_DEF_INST(XED_ICLASS_VMOVSHDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSHDUP_YMMf32_MASKmskw_MEMf32_AVX512,5023,3,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4037*/ XED_DEF_INST(XED_ICLASS_VP4DPWSSDS,XED_CATEGORY_AVX512_4VNNIW,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VP4DPWSSDS_ZMMi32_MASKmskw_ZMMi16_MEMu32_AVX512,5026,4,0,0,151,XED_EXCEPTION_AVX512_E4),
/*4038*/ XED_DEF_INST(XED_ICLASS_VPMOVSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDW_YMMi16_MASKmskw_ZMMi32_AVX512,5030,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4039*/ XED_DEF_INST(XED_ICLASS_VPMOVSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDW_MEMi16_MASKmskw_ZMMi32_AVX512,5033,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4040*/ XED_DEF_INST(XED_ICLASS_VPMOVSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDW_XMMi16_MASKmskw_XMMi32_AVX512,5036,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4041*/ XED_DEF_INST(XED_ICLASS_VPMOVSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDW_MEMi16_MASKmskw_XMMi32_AVX512,5039,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4042*/ XED_DEF_INST(XED_ICLASS_VPMOVSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDW_XMMi16_MASKmskw_YMMi32_AVX512,5042,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4043*/ XED_DEF_INST(XED_ICLASS_VPMOVSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSDW_MEMi16_MASKmskw_YMMi32_AVX512,5045,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4044*/ XED_DEF_INST(XED_ICLASS_VPLZCNTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTQ_ZMMu64_MASKmskw_ZMMu64_AVX512CD,5048,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4045*/ XED_DEF_INST(XED_ICLASS_VPLZCNTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTQ_ZMMu64_MASKmskw_MEMu64_AVX512CD,5051,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4046*/ XED_DEF_INST(XED_ICLASS_VPLZCNTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTQ_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4047*/ XED_DEF_INST(XED_ICLASS_VPLZCNTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTQ_XMMu64_MASKmskw_MEMu64_AVX512,5057,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4048*/ XED_DEF_INST(XED_ICLASS_VPLZCNTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTQ_YMMu64_MASKmskw_YMMu64_AVX512,5060,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4049*/ XED_DEF_INST(XED_ICLASS_VPLZCNTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPLZCNTQ_YMMu64_MASKmskw_MEMu64_AVX512,5063,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4050*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_XMMi64_MASKmskw_XMMf32_AVX512,5066,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4051*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_XMMi64_MASKmskw_MEMf32_AVX512,5069,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*4052*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_YMMi64_MASKmskw_XMMf32_AVX512,5072,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4053*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_YMMi64_MASKmskw_MEMf32_AVX512,5075,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*4054*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_ZMMi64_MASKmskw_YMMf32_AVX512,5078,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4055*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_ZMMi64_MASKmskw_YMMf32_AVX512,5081,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4056*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2QQ_ZMMi64_MASKmskw_MEMf32_AVX512,5084,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*4057*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF64X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF64X4_YMMf64_MASKmskw_ZMMf64_IMM8_AVX512,5087,4,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4058*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF64X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF64X4_MEMf64_MASKmskw_ZMMf64_IMM8_AVX512,5091,4,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*4059*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4060*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4061*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4062*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512,5103,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4063*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_ZMMf32_MASKmskw_MEMf32_IMM8_AVX512,5107,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4064*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4065*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4066*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512,5119,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4067*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_XMMf32_MASKmskw_MEMf32_IMM8_AVX512,5123,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4068*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4069*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4070*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512,5131,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4071*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_YMMf32_MASKmskw_MEMf32_IMM8_AVX512,5135,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4072*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4073*/ XED_DEF_INST(XED_ICLASS_VPERMILPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4074*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWQ_ZMMi64_MASKmskw_XMMi16_AVX512,5147,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4075*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWQ_ZMMi64_MASKmskw_MEMi16_AVX512,5150,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*4076*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWQ_XMMi64_MASKmskw_XMMi16_AVX512,5153,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4077*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWQ_XMMi64_MASKmskw_MEMi16_AVX512,5156,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*4078*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWQ_YMMi64_MASKmskw_XMMi16_AVX512,5159,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4079*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWQ_YMMi64_MASKmskw_MEMi16_AVX512,5162,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*4080*/ XED_DEF_INST(XED_ICLASS_VGATHERQPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERQPD_ZMMf64_MASKmskw_MEMf64_AVX512_VL512,5165,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4081*/ XED_DEF_INST(XED_ICLASS_VGATHERQPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERQPD_XMMf64_MASKmskw_MEMf64_AVX512_VL128,5168,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4082*/ XED_DEF_INST(XED_ICLASS_VGATHERQPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERQPD_YMMf64_MASKmskw_MEMf64_AVX512_VL256,5171,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4083*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4084*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4085*/ XED_DEF_INST(XED_ICLASS_VFNMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4086*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDEC_XMMu128_XMMu128_XMMu128_AVX512,5182,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*4087*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDEC_XMMu128_XMMu128_MEMu128_AVX512,5185,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*4088*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDEC_YMMu128_YMMu128_YMMu128_AVX512,5188,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*4089*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDEC_YMMu128_YMMu128_MEMu128_AVX512,5191,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*4090*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDEC_ZMMu128_ZMMu128_ZMMu128_AVX512,5194,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*4091*/ XED_DEF_INST(XED_ICLASS_VAESDEC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDEC_ZMMu128_ZMMu128_MEMu128_AVX512,5197,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*4092*/ XED_DEF_INST(XED_ICLASS_VGATHERQPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERQPS_YMMf32_MASKmskw_MEMf32_AVX512_VL512,5200,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4093*/ XED_DEF_INST(XED_ICLASS_VGATHERQPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERQPS_XMMf32_MASKmskw_MEMf32_AVX512_VL128,5203,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4094*/ XED_DEF_INST(XED_ICLASS_VGATHERQPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERQPS_XMMf32_MASKmskw_MEMf32_AVX512_VL256,5203,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4095*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4096*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4097*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4098*/ XED_DEF_INST(XED_ICLASS_VMAXSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4099*/ XED_DEF_INST(XED_ICLASS_VMAXSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5206,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4100*/ XED_DEF_INST(XED_ICLASS_VMAXSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4101*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4102*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5214,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4103*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4104*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4105*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4106*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4107*/ XED_DEF_INST(XED_ICLASS_VSCALEFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4108*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_AVX512,4413,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4109*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_ZMMu64_MEMu64_AVX512,4417,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4110*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_XMMu64_XMMu64_AVX512,4421,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4111*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_XMMu64_MEMu64_AVX512,4425,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4112*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_YMMu64_YMMu64_AVX512,4429,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4113*/ XED_DEF_INST(XED_ICLASS_VPCMPEQQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_YMMu64_MEMu64_AVX512,4433,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4114*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPAVGW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4115*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPAVGW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4116*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPAVGW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4117*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPAVGW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4118*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPAVGW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4119*/ XED_DEF_INST(XED_ICLASS_VPAVGW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPAVGW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4120*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQW_XMMu16_MASKmskw_ZMMu64_AVX512,5234,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4121*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQW_MEMu16_MASKmskw_ZMMu64_AVX512,5237,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*4122*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQW_XMMu16_MASKmskw_XMMu64_AVX512,5240,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4123*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQW_MEMu16_MASKmskw_XMMu64_AVX512,5243,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*4124*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQW_XMMu16_MASKmskw_YMMu64_AVX512,5246,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4125*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQW_MEMu16_MASKmskw_YMMu64_AVX512,5249,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*4126*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_AVX512,5252,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4127*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_ZMMu32_MEMu32_AVX512,5256,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4128*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_XMMu32_XMMu32_AVX512,5260,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4129*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_XMMu32_MEMu32_AVX512,5264,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4130*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_YMMu32_YMMu32_AVX512,5268,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4131*/ XED_DEF_INST(XED_ICLASS_VPCMPEQD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_YMMu32_MEMu32_AVX512,5272,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4132*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4133*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5276,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4134*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4135*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4136*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4137*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4138*/ XED_DEF_INST(XED_ICLASS_VSCALEFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCALEFPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4139*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQB_MASKmskw_MASKmskw_XMMu8_XMMu8_AVX512,5280,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4140*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQB_MASKmskw_MASKmskw_XMMu8_MEMu8_AVX512,5284,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4141*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQB_MASKmskw_MASKmskw_YMMu8_YMMu8_AVX512,5288,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4142*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQB_MASKmskw_MASKmskw_YMMu8_MEMu8_AVX512,5292,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4143*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_AVX512,5296,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4144*/ XED_DEF_INST(XED_ICLASS_VPCMPEQB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQB_MASKmskw_MASKmskw_ZMMu8_MEMu8_AVX512,5300,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4145*/ XED_DEF_INST(XED_ICLASS_VPEXTRW_C5,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRW_GPR32u16_XMMu16_IMM8_AVX512_C5,5304,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4146*/ XED_DEF_INST(XED_ICLASS_VPEXTRW_C5,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRW_GPR32u16_XMMu16_IMM8_AVX512_C5,5304,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4147*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQB_XMMu8_MASKmskw_ZMMu64_AVX512,5307,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4148*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQB_MEMu8_MASKmskw_ZMMu64_AVX512,5310,3,0,0,153,XED_EXCEPTION_AVX512_E6),
/*4149*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQB_XMMu8_MASKmskw_XMMu64_AVX512,5313,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4150*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQB_MEMu8_MASKmskw_XMMu64_AVX512,5316,3,0,0,153,XED_EXCEPTION_AVX512_E6),
/*4151*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQB_XMMu8_MASKmskw_YMMu64_AVX512,5319,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4152*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQB_MEMu8_MASKmskw_YMMu64_AVX512,5322,3,0,0,153,XED_EXCEPTION_AVX512_E6),
/*4153*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEQB_XMMu8_MASKmskw_XMMu8_XMMu64_IMM8_AVX512,5325,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4154*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEQB_XMMu8_MASKmskw_XMMu8_MEMu64_IMM8_AVX512,5330,5,0,0,148,XED_EXCEPTION_AVX512_E4),
/*4155*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEQB_YMMu8_MASKmskw_YMMu8_YMMu64_IMM8_AVX512,5335,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4156*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEQB_YMMu8_MASKmskw_YMMu8_MEMu64_IMM8_AVX512,5340,5,0,0,148,XED_EXCEPTION_AVX512_E4),
/*4157*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEQB_ZMMu8_MASKmskw_ZMMu8_ZMMu64_IMM8_AVX512,5345,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4158*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEQB_ZMMu8_MASKmskw_ZMMu8_MEMu64_IMM8_AVX512,5350,5,0,0,148,XED_EXCEPTION_AVX512_E4),
/*4159*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQD_YMMu32_MASKmskw_ZMMu64_AVX512,5355,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4160*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQD_MEMu32_MASKmskw_ZMMu64_AVX512,5358,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4161*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQD_XMMu32_MASKmskw_XMMu64_AVX512,5361,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4162*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQD_MEMu32_MASKmskw_XMMu64_AVX512,5364,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4163*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQD_XMMu32_MASKmskw_YMMu64_AVX512,5367,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4164*/ XED_DEF_INST(XED_ICLASS_VPMOVUSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSQD_MEMu32_MASKmskw_YMMu64_AVX512,5370,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4165*/ XED_DEF_INST(XED_ICLASS_VPBLENDMQ,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4166*/ XED_DEF_INST(XED_ICLASS_VPBLENDMQ,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,155,XED_EXCEPTION_AVX512_E4),
/*4167*/ XED_DEF_INST(XED_ICLASS_VPBLENDMQ,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4168*/ XED_DEF_INST(XED_ICLASS_VPBLENDMQ,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,155,XED_EXCEPTION_AVX512_E4),
/*4169*/ XED_DEF_INST(XED_ICLASS_VPBLENDMQ,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4170*/ XED_DEF_INST(XED_ICLASS_VPBLENDMQ,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,155,XED_EXCEPTION_AVX512_E4),
/*4171*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXDQ_ZMMi64_MASKmskw_YMMi32_AVX512,5373,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4172*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXDQ_ZMMi64_MASKmskw_MEMi32_AVX512,5376,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4173*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXDQ_XMMi64_MASKmskw_XMMi32_AVX512,5379,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4174*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXDQ_XMMi64_MASKmskw_MEMi32_AVX512,5382,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4175*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXDQ_YMMi64_MASKmskw_XMMi32_AVX512,5385,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4176*/ XED_DEF_INST(XED_ICLASS_VPMOVSXDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXDQ_YMMi64_MASKmskw_MEMi32_AVX512,5388,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4177*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSD_ZMMi32_MASKmskw_ZMMi32_ZMMi32_AVX512,5391,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4178*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSD_ZMMi32_MASKmskw_ZMMi32_MEMi32_AVX512,5395,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4179*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSD_XMMi32_MASKmskw_XMMi32_XMMi32_AVX512,5399,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4180*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSD_XMMi32_MASKmskw_XMMi32_MEMi32_AVX512,5403,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4181*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSD_YMMi32_MASKmskw_YMMi32_YMMi32_AVX512,5407,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4182*/ XED_DEF_INST(XED_ICLASS_VPMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSD_YMMi32_MASKmskw_YMMi32_MEMi32_AVX512,5411,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4183*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4184*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4185*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4186*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4187*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4188*/ XED_DEF_INST(XED_ICLASS_VPSRLVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4189*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512,5415,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4190*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSB_XMMi8_MASKmskw_XMMi8_MEMi8_AVX512,5419,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4191*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512,5423,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4192*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSB_YMMi8_MASKmskw_YMMi8_MEMi8_AVX512,5427,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4193*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512,5431,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4194*/ XED_DEF_INST(XED_ICLASS_VPMAXSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSB_ZMMi8_MASKmskw_ZMMi8_MEMi8_AVX512,5435,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4195*/ XED_DEF_INST(XED_ICLASS_VPSRLVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4196*/ XED_DEF_INST(XED_ICLASS_VPSRLVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4197*/ XED_DEF_INST(XED_ICLASS_VPSRLVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4198*/ XED_DEF_INST(XED_ICLASS_VPSRLVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4199*/ XED_DEF_INST(XED_ICLASS_VPSRLVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4200*/ XED_DEF_INST(XED_ICLASS_VPSRLVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4201*/ XED_DEF_INST(XED_ICLASS_VPBLENDMW,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4202*/ XED_DEF_INST(XED_ICLASS_VPBLENDMW,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,156,XED_EXCEPTION_AVX512_E4),
/*4203*/ XED_DEF_INST(XED_ICLASS_VPBLENDMW,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4204*/ XED_DEF_INST(XED_ICLASS_VPBLENDMW,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,156,XED_EXCEPTION_AVX512_E4),
/*4205*/ XED_DEF_INST(XED_ICLASS_VPBLENDMW,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4206*/ XED_DEF_INST(XED_ICLASS_VPBLENDMW,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,156,XED_EXCEPTION_AVX512_E4),
/*4207*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI64X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI64X2_YMMu64_MASKmskw_MEMu64_AVX512,5439,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4208*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI64X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI64X2_ZMMu64_MASKmskw_MEMu64_AVX512,5442,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4209*/ XED_DEF_INST(XED_ICLASS_VMULSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4210*/ XED_DEF_INST(XED_ICLASS_VMULSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5445,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4211*/ XED_DEF_INST(XED_ICLASS_VMULSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4212*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4213*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPD_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4214*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4215*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPD_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4216*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4217*/ XED_DEF_INST(XED_ICLASS_VANDPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPD_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4218*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDDUP_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,131,XED_EXCEPTION_AVX512_E5NF),
/*4219*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDDUP_ZMMf64_MASKmskw_MEMf64_AVX512,5452,3,0,0,158,XED_EXCEPTION_AVX512_E5NF),
/*4220*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDDUP_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,131,XED_EXCEPTION_AVX512_E5NF),
/*4221*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDDUP_XMMf64_MASKmskw_MEMf64_AVX512,4151,3,0,0,158,XED_EXCEPTION_AVX512_E5NF),
/*4222*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDDUP_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,131,XED_EXCEPTION_AVX512_E5NF),
/*4223*/ XED_DEF_INST(XED_ICLASS_VMOVDDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDDUP_YMMf64_MASKmskw_MEMf64_AVX512,5461,3,0,0,158,XED_EXCEPTION_AVX512_E5NF),
/*4224*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512,4762,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4225*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSW_XMMi16_MASKmskw_XMMi16_MEMi16_AVX512,4766,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4226*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512,4770,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4227*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSW_YMMi16_MASKmskw_YMMi16_MEMi16_AVX512,4774,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4228*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512,4778,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4229*/ XED_DEF_INST(XED_ICLASS_VPMAXSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSW_ZMMi16_MASKmskw_ZMMi16_MEMi16_AVX512,4782,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4230*/ XED_DEF_INST(XED_ICLASS_VPBLENDMB,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4231*/ XED_DEF_INST(XED_ICLASS_VPBLENDMB,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMB_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,156,XED_EXCEPTION_AVX512_E4),
/*4232*/ XED_DEF_INST(XED_ICLASS_VPBLENDMB,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4233*/ XED_DEF_INST(XED_ICLASS_VPBLENDMB,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMB_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,156,XED_EXCEPTION_AVX512_E4),
/*4234*/ XED_DEF_INST(XED_ICLASS_VPBLENDMB,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4235*/ XED_DEF_INST(XED_ICLASS_VPBLENDMB,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMB_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,156,XED_EXCEPTION_AVX512_E4),
/*4236*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_ZMMu32_MASKmskw_ZMMu32_AVX512,4935,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4237*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_ZMMu32_MASKmskw_MEMu32_AVX512,5464,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4238*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_ZMMu32_MASKmskw_ZMMu32_AVX512,5467,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4239*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_MEMu32_MASKmskw_ZMMu32_AVX512,5470,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4240*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4241*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_XMMu32_MASKmskw_MEMu32_AVX512,5473,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4242*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_XMMu32_MASKmskw_XMMu32_AVX512,5476,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4243*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_MEMu32_MASKmskw_XMMu32_AVX512,5479,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4244*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_YMMu32_MASKmskw_YMMu32_AVX512,4947,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4245*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_YMMu32_MASKmskw_MEMu32_AVX512,5482,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4246*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_YMMu32_MASKmskw_YMMu32_AVX512,5485,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4247*/ XED_DEF_INST(XED_ICLASS_VMOVDQU32,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU32_MEMu32_MASKmskw_YMMu32_AVX512,5488,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4248*/ XED_DEF_INST(XED_ICLASS_VPBLENDMD,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4249*/ XED_DEF_INST(XED_ICLASS_VPBLENDMD,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,155,XED_EXCEPTION_AVX512_E4),
/*4250*/ XED_DEF_INST(XED_ICLASS_VPBLENDMD,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4251*/ XED_DEF_INST(XED_ICLASS_VPBLENDMD,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,155,XED_EXCEPTION_AVX512_E4),
/*4252*/ XED_DEF_INST(XED_ICLASS_VPBLENDMD,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,154,XED_EXCEPTION_AVX512_E4),
/*4253*/ XED_DEF_INST(XED_ICLASS_VPBLENDMD,XED_CATEGORY_BLEND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBLENDMD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,155,XED_EXCEPTION_AVX512_E4),
/*4254*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4255*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4256*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4257*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4258*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4259*/ XED_DEF_INST(XED_ICLASS_VPSRLVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLVD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4260*/ XED_DEF_INST(XED_ICLASS_VPMAXSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSQ_ZMMi64_MASKmskw_ZMMi64_ZMMi64_AVX512,5491,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4261*/ XED_DEF_INST(XED_ICLASS_VPMAXSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSQ_ZMMi64_MASKmskw_ZMMi64_MEMi64_AVX512,5495,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4262*/ XED_DEF_INST(XED_ICLASS_VPMAXSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSQ_XMMi64_MASKmskw_XMMi64_XMMi64_AVX512,5499,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4263*/ XED_DEF_INST(XED_ICLASS_VPMAXSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSQ_XMMi64_MASKmskw_XMMi64_MEMi64_AVX512,5503,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4264*/ XED_DEF_INST(XED_ICLASS_VPMAXSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSQ_YMMi64_MASKmskw_YMMi64_YMMi64_AVX512,5507,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4265*/ XED_DEF_INST(XED_ICLASS_VPMAXSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXSQ_YMMi64_MASKmskw_YMMi64_MEMi64_AVX512,5511,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4266*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4267*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPS_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4268*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4269*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPS_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4270*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4271*/ XED_DEF_INST(XED_ICLASS_VANDPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDPS_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4272*/ XED_DEF_INST(XED_ICLASS_VMULSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4273*/ XED_DEF_INST(XED_ICLASS_VMULSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5515,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4274*/ XED_DEF_INST(XED_ICLASS_VMULSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4275*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRD_XMMu32_XMMu32_GPR32u32_IMM8_AVX512,5519,4,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4276*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRD_XMMu32_XMMu32_GPR32u32_IMM8_AVX512,5519,4,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4277*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRD_XMMu32_XMMu32_MEMu32_IMM8_AVX512,5523,4,0,0,140,XED_EXCEPTION_AVX512_E9NF),
/*4278*/ XED_DEF_INST(XED_ICLASS_VPINSRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRD_XMMu32_XMMu32_MEMu32_IMM8_AVX512,5523,4,0,0,140,XED_EXCEPTION_AVX512_E9NF),
/*4279*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4280*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5276,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4281*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4282*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4283*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4284*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4285*/ XED_DEF_INST(XED_ICLASS_VMULPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4286*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLDQ_XMMu8_XMMu8_IMM8_AVX512,4613,3,0,0,0,XED_EXCEPTION_AVX512_E4NF),
/*4287*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLDQ_XMMu8_MEMu8_IMM8_AVX512,4616,3,0,0,138,XED_EXCEPTION_AVX512_E4NF),
/*4288*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLDQ_YMMu8_YMMu8_IMM8_AVX512,4619,3,0,0,0,XED_EXCEPTION_AVX512_E4NF),
/*4289*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLDQ_YMMu8_MEMu8_IMM8_AVX512,4622,3,0,0,138,XED_EXCEPTION_AVX512_E4NF),
/*4290*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLDQ_ZMMu8_ZMMu8_IMM8_AVX512,4625,3,0,0,0,XED_EXCEPTION_AVX512_E4NF),
/*4291*/ XED_DEF_INST(XED_ICLASS_VPSRLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLDQ_ZMMu8_MEMu8_IMM8_AVX512,4628,3,0,0,138,XED_EXCEPTION_AVX512_E4NF),
/*4292*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVNTDQA_ZMMu32_MEMu32_AVX512,5527,2,0,0,159,XED_EXCEPTION_AVX512_E1NF),
/*4293*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVNTDQA_XMMu32_MEMu32_AVX512,5529,2,0,0,159,XED_EXCEPTION_AVX512_E1NF),
/*4294*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQA,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVNTDQA_YMMu32_MEMu32_AVX512,5531,2,0,0,159,XED_EXCEPTION_AVX512_E1NF),
/*4295*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*4296*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_ZMMf32_MASKmskw_MEMf32_AVX512,5011,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*4297*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5533,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*4298*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_MEMf32_MASKmskw_ZMMf32_AVX512,5536,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*4299*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*4300*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_XMMf32_MASKmskw_MEMf32_AVX512,5017,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*4301*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_XMMf32_MASKmskw_XMMf32_AVX512,5539,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*4302*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_MEMf32_MASKmskw_XMMf32_AVX512,5542,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*4303*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*4304*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_YMMf32_MASKmskw_MEMf32_AVX512,5023,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*4305*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_YMMf32_MASKmskw_YMMf32_AVX512,5545,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*4306*/ XED_DEF_INST(XED_ICLASS_VMOVAPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPS_MEMf32_MASKmskw_YMMf32_AVX512,5548,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*4307*/ XED_DEF_INST(XED_ICLASS_VGETMANTSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTSD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4661,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4308*/ XED_DEF_INST(XED_ICLASS_VGETMANTSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTSD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4666,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4309*/ XED_DEF_INST(XED_ICLASS_VGETMANTSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTSD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,4671,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4310*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_YMMu32_MASKmskw_ZMMf64_AVX512_VL512,5551,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4311*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_YMMu32_MASKmskw_ZMMf64_AVX512_VL512,5554,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4312*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_YMMu32_MASKmskw_MEMf64_AVX512_VL512,5557,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4313*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_XMMu32_MASKmskw_XMMf64_AVX512_VL128,5560,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4314*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_XMMu32_MASKmskw_MEMf64_AVX512_VL128,5563,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4315*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_XMMu32_MASKmskw_YMMf64_AVX512_VL256,5566,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4316*/ XED_DEF_INST(XED_ICLASS_VCVTTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPD2UDQ_XMMu32_MASKmskw_MEMf64_AVX512_VL256,5563,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4317*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFHW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512,5569,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4318*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFHW_XMMu16_MASKmskw_MEMu16_IMM8_AVX512,5573,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4319*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFHW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512,5577,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4320*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFHW_YMMu16_MASKmskw_MEMu16_IMM8_AVX512,5581,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4321*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFHW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512,5585,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4322*/ XED_DEF_INST(XED_ICLASS_VPSHUFHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFHW_ZMMu16_MASKmskw_MEMu16_IMM8_AVX512,5589,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4323*/ XED_DEF_INST(XED_ICLASS_V4FMADDPS,XED_CATEGORY_AVX512_4FMAPS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_V4FMADDPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4489,4,0,0,136,XED_EXCEPTION_AVX512_E2),
/*4324*/ XED_DEF_INST(XED_ICLASS_VGETMANTSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTSS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4727,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4325*/ XED_DEF_INST(XED_ICLASS_VGETMANTSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTSS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4732,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4326*/ XED_DEF_INST(XED_ICLASS_VGETMANTSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTSS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,4737,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4327*/ XED_DEF_INST(XED_ICLASS_VPANDND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDND_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4328*/ XED_DEF_INST(XED_ICLASS_VPANDND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDND_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4329*/ XED_DEF_INST(XED_ICLASS_VPANDND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDND_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4330*/ XED_DEF_INST(XED_ICLASS_VPANDND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDND_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4331*/ XED_DEF_INST(XED_ICLASS_VPANDND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDND_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4332*/ XED_DEF_INST(XED_ICLASS_VPANDND,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDND_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4333*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTQ_ZMMu64_MASKmskw_ZMMu64_AVX512CD,5048,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4334*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTQ_ZMMu64_MASKmskw_MEMu64_AVX512CD,5051,3,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4335*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTQ_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4336*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTQ_XMMu64_MASKmskw_MEMu64_AVX512,5057,3,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4337*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTQ_YMMu64_MASKmskw_YMMu64_AVX512,5060,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4338*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTQ,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTQ_YMMu64_MASKmskw_MEMu64_AVX512,5063,3,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4339*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4340*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPD_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4341*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4342*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPD_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4343*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4344*/ XED_DEF_INST(XED_ICLASS_VORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPD_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4345*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTD_ZMMu32_MASKmskw_ZMMu32_AVX512CD,4935,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4346*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTD_ZMMu32_MASKmskw_MEMu32_AVX512CD,4938,3,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4347*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTD_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4348*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTD_XMMu32_MASKmskw_MEMu32_AVX512,4944,3,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4349*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTD_YMMu32_MASKmskw_YMMu32_AVX512,4947,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4350*/ XED_DEF_INST(XED_ICLASS_VPCONFLICTD,XED_CATEGORY_CONFLICT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCONFLICTD_YMMu32_MASKmskw_MEMu32_AVX512,4950,3,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4351*/ XED_DEF_INST(XED_ICLASS_VPANDNQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDNQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4352*/ XED_DEF_INST(XED_ICLASS_VPANDNQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDNQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4353*/ XED_DEF_INST(XED_ICLASS_VPANDNQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDNQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4354*/ XED_DEF_INST(XED_ICLASS_VPANDNQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDNQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4355*/ XED_DEF_INST(XED_ICLASS_VPANDNQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDNQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4356*/ XED_DEF_INST(XED_ICLASS_VPANDNQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDNQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4357*/ XED_DEF_INST(XED_ICLASS_VMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4358*/ XED_DEF_INST(XED_ICLASS_VMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5593,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4359*/ XED_DEF_INST(XED_ICLASS_VMAXSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4360*/ XED_DEF_INST(XED_ICLASS_VPSHRDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512,4251,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4361*/ XED_DEF_INST(XED_ICLASS_VPSHRDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDQ_XMMu64_MASKmskw_XMMu64_MEMu64_IMM8_AVX512,4256,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4362*/ XED_DEF_INST(XED_ICLASS_VPSHRDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512,4261,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4363*/ XED_DEF_INST(XED_ICLASS_VPSHRDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDQ_YMMu64_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,4266,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4364*/ XED_DEF_INST(XED_ICLASS_VPSHRDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512,4271,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4365*/ XED_DEF_INST(XED_ICLASS_VPSHRDQ,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,4276,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4366*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSD_ZMMi32_MASKmskw_ZMMi32_ZMMi32_AVX512,5391,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4367*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSD_ZMMi32_MASKmskw_ZMMi32_MEMi32_AVX512,5395,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4368*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSD_XMMi32_MASKmskw_XMMi32_XMMi32_AVX512,5399,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4369*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSD_XMMi32_MASKmskw_XMMi32_MEMi32_AVX512,5403,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4370*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSD_YMMi32_MASKmskw_YMMi32_YMMi32_AVX512,5407,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4371*/ XED_DEF_INST(XED_ICLASS_VPMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSD_YMMi32_MASKmskw_YMMi32_MEMi32_AVX512,5411,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4372*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512,5415,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4373*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSB_XMMi8_MASKmskw_XMMi8_MEMi8_AVX512,5419,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4374*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512,5423,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4375*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSB_YMMi8_MASKmskw_YMMi8_MEMi8_AVX512,5427,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4376*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512,5431,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4377*/ XED_DEF_INST(XED_ICLASS_VPMINSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSB_ZMMi8_MASKmskw_ZMMi8_MEMi8_AVX512,5435,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4378*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4379*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4380*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4381*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4382*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4383*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4384*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4385*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_XMMi64_MASKmskw_XMMf32_AVX512,5066,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4386*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_XMMi64_MASKmskw_MEMf32_AVX512,5069,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*4387*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_YMMi64_MASKmskw_XMMf32_AVX512,5072,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4388*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_YMMi64_MASKmskw_MEMf32_AVX512,5075,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*4389*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_ZMMi64_MASKmskw_YMMf32_AVX512,5078,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4390*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_ZMMi64_MASKmskw_YMMf32_AVX512,5597,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*4391*/ XED_DEF_INST(XED_ICLASS_VCVTPS2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2QQ_ZMMi64_MASKmskw_MEMf32_AVX512,5084,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*4392*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512,4762,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4393*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSW_XMMi16_MASKmskw_XMMi16_MEMi16_AVX512,4766,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4394*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512,4770,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4395*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSW_YMMi16_MASKmskw_YMMi16_MEMi16_AVX512,4774,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4396*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512,4778,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4397*/ XED_DEF_INST(XED_ICLASS_VPMINSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSW_ZMMi16_MASKmskw_ZMMi16_MEMi16_AVX512,4782,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4398*/ XED_DEF_INST(XED_ICLASS_VPMINSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSQ_ZMMi64_MASKmskw_ZMMi64_ZMMi64_AVX512,5491,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4399*/ XED_DEF_INST(XED_ICLASS_VPMINSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSQ_ZMMi64_MASKmskw_ZMMi64_MEMi64_AVX512,5495,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4400*/ XED_DEF_INST(XED_ICLASS_VPMINSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSQ_XMMi64_MASKmskw_XMMi64_XMMi64_AVX512,5499,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4401*/ XED_DEF_INST(XED_ICLASS_VPMINSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSQ_XMMi64_MASKmskw_XMMi64_MEMi64_AVX512,5503,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4402*/ XED_DEF_INST(XED_ICLASS_VPMINSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSQ_YMMi64_MASKmskw_YMMi64_YMMi64_AVX512,5507,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4403*/ XED_DEF_INST(XED_ICLASS_VPMINSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMINSQ_YMMi64_MASKmskw_YMMi64_MEMi64_AVX512,5511,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4404*/ XED_DEF_INST(XED_ICLASS_VPMADD52HUQ,XED_CATEGORY_IFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADD52HUQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4589,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4405*/ XED_DEF_INST(XED_ICLASS_VPMADD52HUQ,XED_CATEGORY_IFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADD52HUQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4593,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4406*/ XED_DEF_INST(XED_ICLASS_VPMADD52HUQ,XED_CATEGORY_IFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADD52HUQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4597,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4407*/ XED_DEF_INST(XED_ICLASS_VPMADD52HUQ,XED_CATEGORY_IFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADD52HUQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4601,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4408*/ XED_DEF_INST(XED_ICLASS_VPMADD52HUQ,XED_CATEGORY_IFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADD52HUQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4605,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4409*/ XED_DEF_INST(XED_ICLASS_VPMADD52HUQ,XED_CATEGORY_IFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADD52HUQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4609,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4410*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X2_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*4411*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X2_XMMu32_MASKmskw_MEMu32_AVX512,5600,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4412*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X2_YMMu32_MASKmskw_XMMu32_AVX512,5603,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*4413*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X2_YMMu32_MASKmskw_MEMu32_AVX512,5606,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4414*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X2_ZMMu32_MASKmskw_XMMu32_AVX512,5609,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*4415*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X2_ZMMu32_MASKmskw_MEMu32_AVX512,5612,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4416*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4417*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4418*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4419*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4420*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4421*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4422*/ XED_DEF_INST(XED_ICLASS_VFMSUB213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4423*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKSSDW_XMMi16_MASKmskw_XMMi32_XMMi32_AVX512,5615,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4424*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKSSDW_XMMi16_MASKmskw_XMMi32_MEMi32_AVX512,5619,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4425*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKSSDW_YMMi16_MASKmskw_YMMi32_YMMi32_AVX512,5623,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4426*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKSSDW_YMMi16_MASKmskw_YMMi32_MEMi32_AVX512,5627,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4427*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKSSDW_ZMMi16_MASKmskw_ZMMi32_ZMMi32_AVX512,5631,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4428*/ XED_DEF_INST(XED_ICLASS_VPACKSSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKSSDW_ZMMi16_MASKmskw_ZMMi32_MEMi32_AVX512,5635,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4429*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_YMMu32_MASKmskw_ZMMf64_AVX512_VL512,5551,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4430*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_YMMu32_MASKmskw_ZMMf64_AVX512_VL512,5639,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4431*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_YMMu32_MASKmskw_MEMf64_AVX512_VL512,5557,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4432*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_XMMu32_MASKmskw_XMMf64_AVX512_VL128,5560,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4433*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_XMMu32_MASKmskw_MEMf64_AVX512_VL128,5563,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4434*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_XMMu32_MASKmskw_YMMf64_AVX512_VL256,5566,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4435*/ XED_DEF_INST(XED_ICLASS_VCVTPD2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2UDQ_XMMu32_MASKmskw_MEMf64_AVX512_VL256,5563,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4436*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_XMMf32_IMM8_AVX512,4143,4,0,0,134,XED_EXCEPTION_AVX512_E4),
/*4437*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_MEMf32_IMM8_AVX512_VL128,5642,4,0,0,135,XED_EXCEPTION_AVX512_E4),
/*4438*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_YMMf32_IMM8_AVX512,5646,4,0,0,134,XED_EXCEPTION_AVX512_E4),
/*4439*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_MEMf32_IMM8_AVX512_VL256,5642,4,0,0,135,XED_EXCEPTION_AVX512_E4),
/*4440*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_ZMMf32_IMM8_AVX512,5650,4,0,0,134,XED_EXCEPTION_AVX512_E4),
/*4441*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_MEMf32_IMM8_AVX512_VL512,5642,4,0,0,135,XED_EXCEPTION_AVX512_E4),
/*4442*/ XED_DEF_INST(XED_ICLASS_VPMOVD2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVD2M_MASKmskw_XMMu32_AVX512,5654,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4443*/ XED_DEF_INST(XED_ICLASS_VPMOVD2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVD2M_MASKmskw_YMMu32_AVX512,5656,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4444*/ XED_DEF_INST(XED_ICLASS_VPMOVD2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVD2M_MASKmskw_ZMMu32_AVX512,5658,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4445*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_XMMf64_IMM8_AVX512,4195,4,0,0,134,XED_EXCEPTION_AVX512_E4),
/*4446*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_MEMf64_IMM8_AVX512_VL128,5660,4,0,0,135,XED_EXCEPTION_AVX512_E4),
/*4447*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_YMMf64_IMM8_AVX512,5664,4,0,0,134,XED_EXCEPTION_AVX512_E4),
/*4448*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_MEMf64_IMM8_AVX512_VL256,5660,4,0,0,135,XED_EXCEPTION_AVX512_E4),
/*4449*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_ZMMf64_IMM8_AVX512,5668,4,0,0,134,XED_EXCEPTION_AVX512_E4),
/*4450*/ XED_DEF_INST(XED_ICLASS_VFPCLASSPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_MEMf64_IMM8_AVX512_VL512,5660,4,0,0,135,XED_EXCEPTION_AVX512_E4),
/*4451*/ XED_DEF_INST(XED_ICLASS_VSQRTSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4452*/ XED_DEF_INST(XED_ICLASS_VSQRTSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5515,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4453*/ XED_DEF_INST(XED_ICLASS_VSQRTSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4454*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4455*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPS_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4456*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4457*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPS_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4458*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4459*/ XED_DEF_INST(XED_ICLASS_VORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VORPS_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4460*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBQ_ZMMi64_MASKmskw_XMMi8_AVX512,5672,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4461*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBQ_ZMMi64_MASKmskw_MEMi8_AVX512,5675,3,0,0,153,XED_EXCEPTION_AVX512_E5),
/*4462*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBQ_XMMi64_MASKmskw_XMMi8_AVX512,5678,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4463*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBQ_XMMi64_MASKmskw_MEMi8_AVX512,5681,3,0,0,153,XED_EXCEPTION_AVX512_E5),
/*4464*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBQ_YMMi64_MASKmskw_XMMi8_AVX512,5684,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4465*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBQ_YMMi64_MASKmskw_MEMi8_AVX512,5687,3,0,0,153,XED_EXCEPTION_AVX512_E5),
/*4466*/ XED_DEF_INST(XED_ICLASS_VEXTRACTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTPS_GPR32f32_XMMf32_IMM8_AVX512,5690,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4467*/ XED_DEF_INST(XED_ICLASS_VEXTRACTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTPS_MEMf32_XMMf32_IMM8_AVX512,5693,3,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*4468*/ XED_DEF_INST(XED_ICLASS_VSHUFF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF32X4_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512,5696,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4469*/ XED_DEF_INST(XED_ICLASS_VSHUFF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF32X4_ZMMf32_MASKmskw_ZMMf32_MEMf32_IMM8_AVX512,5701,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4470*/ XED_DEF_INST(XED_ICLASS_VSHUFF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF32X4_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512,5706,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4471*/ XED_DEF_INST(XED_ICLASS_VSHUFF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF32X4_YMMf32_MASKmskw_YMMf32_MEMf32_IMM8_AVX512,5711,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4472*/ XED_DEF_INST(XED_ICLASS_VSQRTSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4473*/ XED_DEF_INST(XED_ICLASS_VSQRTSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5445,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4474*/ XED_DEF_INST(XED_ICLASS_VSQRTSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4475*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4476*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4477*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4478*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4479*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4480*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4481*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SD_XMMf64_MASKmskw_XMMf32_XMMf32_AVX512,5716,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4482*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SD_XMMf64_MASKmskw_XMMf32_XMMf32_AVX512,5720,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4483*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SD_XMMf64_MASKmskw_XMMf32_MEMf32_AVX512,5724,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4484*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBD_ZMMi32_MASKmskw_XMMi8_AVX512,5728,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4485*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBD_ZMMi32_MASKmskw_MEMi8_AVX512,5731,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*4486*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBD_XMMi32_MASKmskw_XMMi8_AVX512,5734,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4487*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBD_XMMi32_MASKmskw_MEMi8_AVX512,5737,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*4488*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBD_YMMi32_MASKmskw_XMMi8_AVX512,5740,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4489*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBD_YMMi32_MASKmskw_MEMi8_AVX512,5743,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*4490*/ XED_DEF_INST(XED_ICLASS_VPDPBUSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSDS_XMMi32_MASKmskw_XMMu8_XMMu32_AVX512,5746,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4491*/ XED_DEF_INST(XED_ICLASS_VPDPBUSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSDS_XMMi32_MASKmskw_XMMu8_MEMu32_AVX512,5750,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4492*/ XED_DEF_INST(XED_ICLASS_VPDPBUSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSDS_YMMi32_MASKmskw_YMMu8_YMMu32_AVX512,5754,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4493*/ XED_DEF_INST(XED_ICLASS_VPDPBUSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSDS_YMMi32_MASKmskw_YMMu8_MEMu32_AVX512,5758,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4494*/ XED_DEF_INST(XED_ICLASS_VPDPBUSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSDS_ZMMi32_MASKmskw_ZMMu8_ZMMu32_AVX512,5762,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4495*/ XED_DEF_INST(XED_ICLASS_VPDPBUSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSDS_ZMMi32_MASKmskw_ZMMu8_MEMu32_AVX512,5766,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4496*/ XED_DEF_INST(XED_ICLASS_VCOMISD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMISD_XMMf64_XMMf64_AVX512,5770,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4497*/ XED_DEF_INST(XED_ICLASS_VCOMISD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMISD_XMMf64_XMMf64_AVX512,5773,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4498*/ XED_DEF_INST(XED_ICLASS_VCOMISD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMISD_XMMf64_MEMf64_AVX512,5776,3,97,0,161,XED_EXCEPTION_AVX512_E3NF),
/*4499*/ XED_DEF_INST(XED_ICLASS_VCOMISS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMISS_XMMf32_XMMf32_AVX512,5779,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4500*/ XED_DEF_INST(XED_ICLASS_VCOMISS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMISS_XMMf32_XMMf32_AVX512,5782,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4501*/ XED_DEF_INST(XED_ICLASS_VCOMISS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMISS_XMMf32_MEMf32_AVX512,5785,3,97,0,161,XED_EXCEPTION_AVX512_E3NF),
/*4502*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_ZMMu32_MASKmskw_ZMMu32_XMMu32_AVX512,5788,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4503*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,5792,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4504*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512,5796,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4505*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_ZMMu32_MASKmskw_MEMu32_IMM8_AVX512,5800,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4506*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4507*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,5804,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4508*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512,5808,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4509*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_XMMu32_MASKmskw_MEMu32_IMM8_AVX512,5812,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4510*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_YMMu32_MASKmskw_YMMu32_XMMu32_AVX512,5816,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4511*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,5820,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4512*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512,5824,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4513*/ XED_DEF_INST(XED_ICLASS_VPSRAD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAD_YMMu32_MASKmskw_MEMu32_IMM8_AVX512,5828,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4514*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR32u32_AVX512,5832,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4515*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR32u32_AVX512,5832,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4516*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR32u32_AVX512,5835,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4517*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR32u32_AVX512,5835,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4518*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_MEMu32_AVX512,5838,3,0,0,163,XED_EXCEPTION_AVX512_E3NF),
/*4519*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_MEMu32_AVX512,5838,3,0,0,163,XED_EXCEPTION_AVX512_E3NF),
/*4520*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR64u64_AVX512,5841,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4521*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR64u64_AVX512,5844,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4522*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_MEMu64_AVX512,5847,3,0,0,163,XED_EXCEPTION_AVX512_E3NF),
/*4523*/ XED_DEF_INST(XED_ICLASS_VPMOVB2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVB2M_MASKmskw_XMMu8_AVX512,5850,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4524*/ XED_DEF_INST(XED_ICLASS_VPMOVB2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVB2M_MASKmskw_YMMu8_AVX512,5852,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4525*/ XED_DEF_INST(XED_ICLASS_VPMOVB2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVB2M_MASKmskw_ZMMu8_AVX512,5854,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4526*/ XED_DEF_INST(XED_ICLASS_VPINSRQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRQ_XMMu64_XMMu64_GPR64u64_IMM8_AVX512,5856,4,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4527*/ XED_DEF_INST(XED_ICLASS_VPINSRQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRQ_XMMu64_XMMu64_MEMu64_IMM8_AVX512,5860,4,0,0,140,XED_EXCEPTION_AVX512_E9NF),
/*4528*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512,5864,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4529*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFD_ZMMu32_MASKmskw_MEMu32_IMM8_AVX512,5868,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4530*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512,5872,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4531*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFD_XMMu32_MASKmskw_MEMu32_IMM8_AVX512,5876,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4532*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512,5880,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4533*/ XED_DEF_INST(XED_ICLASS_VPSHUFD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFD_YMMu32_MASKmskw_MEMu32_IMM8_AVX512,5884,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4534*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4535*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4536*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512,5888,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4537*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_XMMu16_MASKmskw_MEMu16_IMM8_AVX512,5892,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4538*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_YMMu16_MASKmskw_YMMu16_XMMu16_AVX512,5896,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4539*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,5900,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4540*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512,5904,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4541*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_YMMu16_MASKmskw_MEMu16_IMM8_AVX512,5908,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4542*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_ZMMu16_MASKmskw_ZMMu16_XMMu16_AVX512,5912,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4543*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,5916,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4544*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512,5920,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4545*/ XED_DEF_INST(XED_ICLASS_VPSRAW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAW_ZMMu16_MASKmskw_MEMu16_IMM8_AVX512,5924,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4546*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_GPR32u32_AVX512,5928,3,0,0,35,XED_EXCEPTION_AVX512_E10NF),
/*4547*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_GPR32u32_AVX512,5928,3,0,0,35,XED_EXCEPTION_AVX512_E10NF),
/*4548*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_MEMu32_AVX512,5931,3,0,0,164,XED_EXCEPTION_AVX512_E10NF),
/*4549*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_MEMu32_AVX512,5931,3,0,0,164,XED_EXCEPTION_AVX512_E10NF),
/*4550*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_GPR64u64_AVX512,5934,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4551*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_GPR64u64_AVX512,5937,3,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4552*/ XED_DEF_INST(XED_ICLASS_VCVTUSI2SD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_MEMu64_AVX512,5940,3,0,0,163,XED_EXCEPTION_AVX512_E3NF),
/*4553*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4554*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFB_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4555*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4556*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFB_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4557*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4558*/ XED_DEF_INST(XED_ICLASS_VPSHUFB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFB_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4559*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X4,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X4_ZMMf32_MASKmskw_MEMf32_AVX512,5943,3,0,0,165,XED_EXCEPTION_AVX512_E6),
/*4560*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X4,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X4_YMMf32_MASKmskw_MEMf32_AVX512,5946,3,0,0,165,XED_EXCEPTION_AVX512_E6),
/*4561*/ XED_DEF_INST(XED_ICLASS_VPERMI2B,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2B_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,5949,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4562*/ XED_DEF_INST(XED_ICLASS_VPERMI2B,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2B_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,5953,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4563*/ XED_DEF_INST(XED_ICLASS_VPERMI2B,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2B_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,5957,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4564*/ XED_DEF_INST(XED_ICLASS_VPERMI2B,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2B_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,5961,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4565*/ XED_DEF_INST(XED_ICLASS_VPERMI2B,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2B_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,5965,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4566*/ XED_DEF_INST(XED_ICLASS_VPERMI2B,XED_CATEGORY_AVX512_VBMI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2B_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,5969,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4567*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSLDUP_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4568*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSLDUP_ZMMf32_MASKmskw_MEMf32_AVX512,5011,3,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4569*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSLDUP_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4570*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSLDUP_XMMf32_MASKmskw_MEMf32_AVX512,5017,3,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4571*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSLDUP_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4572*/ XED_DEF_INST(XED_ICLASS_VMOVSLDUP,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVSLDUP_YMMf32_MASKmskw_MEMf32_AVX512,5023,3,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4573*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPGTB_MASKmskw_MASKmskw_XMMu8_XMMu8_AVX512,5280,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4574*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPGTB_MASKmskw_MASKmskw_XMMu8_MEMu8_AVX512,5284,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4575*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPGTB_MASKmskw_MASKmskw_YMMu8_YMMu8_AVX512,5288,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4576*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPGTB_MASKmskw_MASKmskw_YMMu8_MEMu8_AVX512,5292,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4577*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPGTB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_AVX512,5296,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4578*/ XED_DEF_INST(XED_ICLASS_VPCMPGTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPGTB_MASKmskw_MASKmskw_ZMMu8_MEMu8_AVX512,5300,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4579*/ XED_DEF_INST(XED_ICLASS_VPOPCNTQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTQ_ZMMu64_MASKmskw_ZMMu64_AVX512,5048,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4580*/ XED_DEF_INST(XED_ICLASS_VPOPCNTQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTQ_ZMMu64_MASKmskw_MEMu64_AVX512,5051,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4581*/ XED_DEF_INST(XED_ICLASS_VPOPCNTQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTQ_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4582*/ XED_DEF_INST(XED_ICLASS_VPOPCNTQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTQ_XMMu64_MASKmskw_MEMu64_AVX512,5057,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4583*/ XED_DEF_INST(XED_ICLASS_VPOPCNTQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTQ_YMMu64_MASKmskw_YMMu64_AVX512,5060,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4584*/ XED_DEF_INST(XED_ICLASS_VPOPCNTQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTQ_YMMu64_MASKmskw_MEMu64_AVX512,5063,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4585*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBW_XMMi16_MASKmskw_XMMi8_AVX512,5973,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4586*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBW_XMMi16_MASKmskw_MEMi8_AVX512,5976,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4587*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBW_YMMi16_MASKmskw_XMMi8_AVX512,5979,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4588*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBW_YMMi16_MASKmskw_MEMi8_AVX512,5982,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4589*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBW_ZMMi16_MASKmskw_YMMi8_AVX512,5985,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4590*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBW_ZMMi16_MASKmskw_MEMi8_AVX512,5988,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4591*/ XED_DEF_INST(XED_ICLASS_VPOPCNTD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTD_ZMMu32_MASKmskw_ZMMu32_AVX512,4935,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4592*/ XED_DEF_INST(XED_ICLASS_VPOPCNTD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTD_ZMMu32_MASKmskw_MEMu32_AVX512,4938,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4593*/ XED_DEF_INST(XED_ICLASS_VPOPCNTD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTD_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4594*/ XED_DEF_INST(XED_ICLASS_VPOPCNTD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTD_XMMu32_MASKmskw_MEMu32_AVX512,4944,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4595*/ XED_DEF_INST(XED_ICLASS_VPOPCNTD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTD_YMMu32_MASKmskw_YMMu32_AVX512,4947,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4596*/ XED_DEF_INST(XED_ICLASS_VPOPCNTD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTD_YMMu32_MASKmskw_MEMu32_AVX512,4950,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4597*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4598*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5276,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4599*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4600*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4601*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4602*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4603*/ XED_DEF_INST(XED_ICLASS_VDIVPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4604*/ XED_DEF_INST(XED_ICLASS_VPOPCNTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTB_XMMu8_MASKmskw_XMMu8_AVX512,5991,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4605*/ XED_DEF_INST(XED_ICLASS_VPOPCNTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTB_XMMu8_MASKmskw_MEMu8_AVX512,5994,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4606*/ XED_DEF_INST(XED_ICLASS_VPOPCNTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTB_YMMu8_MASKmskw_YMMu8_AVX512,5997,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4607*/ XED_DEF_INST(XED_ICLASS_VPOPCNTB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTB_YMMu8_MASKmskw_MEMu8_AVX512,6000,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4608*/ XED_DEF_INST(XED_ICLASS_VPOPCNTB,XED_CATEGORY_AVX512_BITALG,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTB_ZMMu8_MASKmskw_ZMMu8_AVX512,6003,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4609*/ XED_DEF_INST(XED_ICLASS_VPOPCNTB,XED_CATEGORY_AVX512_BITALG,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTB_ZMMu8_MASKmskw_MEMu8_AVX512,6006,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4610*/ XED_DEF_INST(XED_ICLASS_VCMPSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPSS_MASKmskw_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,6009,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4611*/ XED_DEF_INST(XED_ICLASS_VCMPSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPSS_MASKmskw_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,6014,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4612*/ XED_DEF_INST(XED_ICLASS_VCMPSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPSS_MASKmskw_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,6019,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4613*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFLW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512,5569,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4614*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFLW_XMMu16_MASKmskw_MEMu16_IMM8_AVX512,5573,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4615*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFLW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512,5577,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4616*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFLW_YMMu16_MASKmskw_MEMu16_IMM8_AVX512,5581,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4617*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFLW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512,5585,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4618*/ XED_DEF_INST(XED_ICLASS_VPSHUFLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFLW_ZMMu16_MASKmskw_MEMu16_IMM8_AVX512,5589,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4619*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4620*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4621*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4622*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4623*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4624*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4625*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4626*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4627*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4628*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4629*/ XED_DEF_INST(XED_ICLASS_VCMPSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPSD_MASKmskw_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,6024,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4630*/ XED_DEF_INST(XED_ICLASS_VCMPSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPSD_MASKmskw_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,6029,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4631*/ XED_DEF_INST(XED_ICLASS_VCMPSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPSD_MASKmskw_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,6034,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4632*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_ZMMu64_MASKmskw_ZMMu64_XMMu64_AVX512,6039,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4633*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,6043,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4634*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512,4565,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4635*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_ZMMu64_MASKmskw_MEMu64_IMM8_AVX512,4569,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4636*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4637*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,6047,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4638*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512,4573,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4639*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_XMMu64_MASKmskw_MEMu64_IMM8_AVX512,4577,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4640*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_YMMu64_MASKmskw_YMMu64_XMMu64_AVX512,6051,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4641*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,6055,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4642*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512,4581,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4643*/ XED_DEF_INST(XED_ICLASS_VPSLLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLQ_YMMu64_MASKmskw_MEMu64_IMM8_AVX512,4585,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4644*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBQ_ZMMi64_MASKmskw_XMMi8_AVX512,5672,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4645*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBQ_ZMMi64_MASKmskw_MEMi8_AVX512,5675,3,0,0,153,XED_EXCEPTION_AVX512_E5),
/*4646*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBQ_XMMi64_MASKmskw_XMMi8_AVX512,5678,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4647*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBQ_XMMi64_MASKmskw_MEMi8_AVX512,5681,3,0,0,153,XED_EXCEPTION_AVX512_E5),
/*4648*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBQ_YMMi64_MASKmskw_XMMi8_AVX512,5684,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4649*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBQ_YMMi64_MASKmskw_MEMi8_AVX512,5687,3,0,0,153,XED_EXCEPTION_AVX512_E5),
/*4650*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4651*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4652*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4653*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4654*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4655*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4656*/ XED_DEF_INST(XED_ICLASS_VFMSUBADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUBADD213PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4657*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4658*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4659*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512,5888,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4660*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_XMMu16_MASKmskw_MEMu16_IMM8_AVX512,5892,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4661*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_YMMu16_MASKmskw_YMMu16_XMMu16_AVX512,5896,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4662*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,5900,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4663*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512,5904,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4664*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_YMMu16_MASKmskw_MEMu16_IMM8_AVX512,5908,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4665*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_ZMMu16_MASKmskw_ZMMu16_XMMu16_AVX512,5912,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4666*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,5916,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*4667*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512,5920,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4668*/ XED_DEF_INST(XED_ICLASS_VPSLLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSLLW_ZMMu16_MASKmskw_MEMu16_IMM8_AVX512,5924,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4669*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4670*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4671*/ XED_DEF_INST(XED_ICLASS_VFMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB132SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4672*/ XED_DEF_INST(XED_ICLASS_VPERMI2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4673*/ XED_DEF_INST(XED_ICLASS_VPERMI2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4674*/ XED_DEF_INST(XED_ICLASS_VPERMI2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4675*/ XED_DEF_INST(XED_ICLASS_VPERMI2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4676*/ XED_DEF_INST(XED_ICLASS_VPERMI2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4677*/ XED_DEF_INST(XED_ICLASS_VPERMI2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4678*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4679*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4680*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4681*/ XED_DEF_INST(XED_ICLASS_VRCP28PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER,5449,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4682*/ XED_DEF_INST(XED_ICLASS_VRCP28PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER,6059,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4683*/ XED_DEF_INST(XED_ICLASS_VRCP28PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28PD_ZMMf64_MASKmskw_MEMf64_AVX512ER,6062,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4684*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512,6065,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4685*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_IMM8_AVX512,6070,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4686*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4661,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4687*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,6075,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4688*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPD_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512,6080,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4689*/ XED_DEF_INST(XED_ICLASS_VSHUFPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPD_YMMf64_MASKmskw_YMMf64_MEMf64_IMM8_AVX512,6085,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4690*/ XED_DEF_INST(XED_ICLASS_VSUBSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4691*/ XED_DEF_INST(XED_ICLASS_VSUBSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5515,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4692*/ XED_DEF_INST(XED_ICLASS_VSUBSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4693*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4694*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_ZMMf32_MASKmskw_ZMMf32_AVX512,6090,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4695*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_ZMMf32_MASKmskw_MEMf32_AVX512,6093,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4696*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4697*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_XMMf32_MASKmskw_MEMf32_AVX512,6096,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4698*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4699*/ XED_DEF_INST(XED_ICLASS_VSQRTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPS_YMMf32_MASKmskw_MEMf32_AVX512,6099,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4700*/ XED_DEF_INST(XED_ICLASS_VPANDD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4701*/ XED_DEF_INST(XED_ICLASS_VPANDD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4702*/ XED_DEF_INST(XED_ICLASS_VPANDD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4703*/ XED_DEF_INST(XED_ICLASS_VPANDD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4704*/ XED_DEF_INST(XED_ICLASS_VPANDD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4705*/ XED_DEF_INST(XED_ICLASS_VPANDD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4706*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_ZMMi32_MASKmskw_ZMMf32_AVX512,6102,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4707*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_ZMMi32_MASKmskw_ZMMf32_AVX512,6105,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4708*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_ZMMi32_MASKmskw_MEMf32_AVX512,6108,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4709*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_XMMi32_MASKmskw_XMMf32_AVX512,6111,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4710*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_XMMi32_MASKmskw_MEMf32_AVX512,6114,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4711*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_YMMi32_MASKmskw_YMMf32_AVX512,6117,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4712*/ XED_DEF_INST(XED_ICLASS_VCVTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPS2DQ_YMMi32_MASKmskw_MEMf32_AVX512,6120,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4713*/ XED_DEF_INST(XED_ICLASS_VRCP28PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER,5008,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4714*/ XED_DEF_INST(XED_ICLASS_VRCP28PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER,6123,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4715*/ XED_DEF_INST(XED_ICLASS_VRCP28PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28PS_ZMMf32_MASKmskw_MEMf32_AVX512ER,6093,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4716*/ XED_DEF_INST(XED_ICLASS_VPMOVW2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVW2M_MASKmskw_XMMu16_AVX512,6126,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4717*/ XED_DEF_INST(XED_ICLASS_VPMOVW2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVW2M_MASKmskw_YMMu16_AVX512,6128,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4718*/ XED_DEF_INST(XED_ICLASS_VPMOVW2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVW2M_MASKmskw_ZMMu16_AVX512,6130,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4719*/ XED_DEF_INST(XED_ICLASS_VPERMI2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4720*/ XED_DEF_INST(XED_ICLASS_VPERMI2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4721*/ XED_DEF_INST(XED_ICLASS_VPERMI2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4722*/ XED_DEF_INST(XED_ICLASS_VPERMI2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4723*/ XED_DEF_INST(XED_ICLASS_VPERMI2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4724*/ XED_DEF_INST(XED_ICLASS_VPERMI2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4725*/ XED_DEF_INST(XED_ICLASS_VPANDQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4726*/ XED_DEF_INST(XED_ICLASS_VPANDQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4727*/ XED_DEF_INST(XED_ICLASS_VPANDQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4728*/ XED_DEF_INST(XED_ICLASS_VPANDQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4729*/ XED_DEF_INST(XED_ICLASS_VPANDQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4730*/ XED_DEF_INST(XED_ICLASS_VPANDQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPANDQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4731*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4732*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_ZMMf64_MASKmskw_ZMMf64_AVX512,6132,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4733*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_ZMMf64_MASKmskw_MEMf64_AVX512,6062,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4734*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4735*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_XMMf64_MASKmskw_MEMf64_AVX512,6135,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4736*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4737*/ XED_DEF_INST(XED_ICLASS_VSQRTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSQRTPD_YMMf64_MASKmskw_MEMf64_AVX512,6138,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4738*/ XED_DEF_INST(XED_ICLASS_VSUBSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4739*/ XED_DEF_INST(XED_ICLASS_VSUBSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5445,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4740*/ XED_DEF_INST(XED_ICLASS_VSUBSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4741*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512,5696,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4742*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_IMM8_AVX512,5701,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4743*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4727,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4744*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,6141,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4745*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPS_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512,5706,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4746*/ XED_DEF_INST(XED_ICLASS_VSHUFPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFPS_YMMf32_MASKmskw_YMMf32_MEMf32_IMM8_AVX512,5711,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4747*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4748*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4749*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4750*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4751*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4752*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4753*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4754*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4755*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4756*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4757*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4758*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4759*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4760*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4761*/ XED_DEF_INST(XED_ICLASS_VPMOVM2W,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2W_XMMu16_MASKmskw_AVX512,6146,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4762*/ XED_DEF_INST(XED_ICLASS_VPMOVM2W,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2W_YMMu16_MASKmskw_AVX512,6148,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4763*/ XED_DEF_INST(XED_ICLASS_VPMOVM2W,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2W_ZMMu16_MASKmskw_AVX512,6150,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4764*/ XED_DEF_INST(XED_ICLASS_VDBPSADBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDBPSADBW_XMMu16_MASKmskw_XMMu8_XMMu8_IMM8_AVX512,6152,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4765*/ XED_DEF_INST(XED_ICLASS_VDBPSADBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDBPSADBW_XMMu16_MASKmskw_XMMu8_MEMu8_IMM8_AVX512,6157,5,0,0,146,XED_EXCEPTION_AVX512_E4),
/*4766*/ XED_DEF_INST(XED_ICLASS_VDBPSADBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDBPSADBW_YMMu16_MASKmskw_YMMu8_YMMu8_IMM8_AVX512,6162,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4767*/ XED_DEF_INST(XED_ICLASS_VDBPSADBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDBPSADBW_YMMu16_MASKmskw_YMMu8_MEMu8_IMM8_AVX512,6167,5,0,0,146,XED_EXCEPTION_AVX512_E4),
/*4768*/ XED_DEF_INST(XED_ICLASS_VDBPSADBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDBPSADBW_ZMMu16_MASKmskw_ZMMu8_ZMMu8_IMM8_AVX512,6172,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4769*/ XED_DEF_INST(XED_ICLASS_VDBPSADBW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDBPSADBW_ZMMu16_MASKmskw_ZMMu8_MEMu8_IMM8_AVX512,6177,5,0,0,146,XED_EXCEPTION_AVX512_E4),
/*4770*/ XED_DEF_INST(XED_ICLASS_VPROLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512,5796,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4771*/ XED_DEF_INST(XED_ICLASS_VPROLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLD_ZMMu32_MASKmskw_MEMu32_IMM8_AVX512,5800,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4772*/ XED_DEF_INST(XED_ICLASS_VPROLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512,5808,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4773*/ XED_DEF_INST(XED_ICLASS_VPROLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLD_XMMu32_MASKmskw_MEMu32_IMM8_AVX512,5812,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4774*/ XED_DEF_INST(XED_ICLASS_VPROLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512,5824,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4775*/ XED_DEF_INST(XED_ICLASS_VPROLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPROLD_YMMu32_MASKmskw_MEMu32_IMM8_AVX512,5828,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4776*/ XED_DEF_INST(XED_ICLASS_VEXPANDPD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPD_ZMMf64_MASKmskw_MEMf64_AVX512,5452,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4777*/ XED_DEF_INST(XED_ICLASS_VEXPANDPD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPD_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4778*/ XED_DEF_INST(XED_ICLASS_VEXPANDPD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPD_XMMf64_MASKmskw_MEMf64_AVX512,6182,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4779*/ XED_DEF_INST(XED_ICLASS_VEXPANDPD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPD_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4780*/ XED_DEF_INST(XED_ICLASS_VEXPANDPD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPD_YMMf64_MASKmskw_MEMf64_AVX512,5461,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4781*/ XED_DEF_INST(XED_ICLASS_VEXPANDPD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPD_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4782*/ XED_DEF_INST(XED_ICLASS_VPMOVM2B,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2B_XMMu8_MASKmskw_AVX512,6185,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4783*/ XED_DEF_INST(XED_ICLASS_VPMOVM2B,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2B_YMMu8_MASKmskw_AVX512,6187,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4784*/ XED_DEF_INST(XED_ICLASS_VPMOVM2B,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2B_ZMMu8_MASKmskw_AVX512,6189,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4785*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4786*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4787*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4788*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4789*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4790*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4791*/ XED_DEF_INST(XED_ICLASS_VFMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4792*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4793*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4794*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4795*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4796*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4797*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4798*/ XED_DEF_INST(XED_ICLASS_VFNMADD213PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD213PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4799*/ XED_DEF_INST(XED_ICLASS_VPMOVM2D,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2D_XMMu32_MASKmskw_AVX512,6191,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4800*/ XED_DEF_INST(XED_ICLASS_VPMOVM2D,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2D_YMMu32_MASKmskw_AVX512,6193,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4801*/ XED_DEF_INST(XED_ICLASS_VPMOVM2D,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVM2D_ZMMu32_MASKmskw_AVX512,6195,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*4802*/ XED_DEF_INST(XED_ICLASS_VEXPANDPS,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPS_ZMMf32_MASKmskw_MEMf32_AVX512,5011,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4803*/ XED_DEF_INST(XED_ICLASS_VEXPANDPS,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4804*/ XED_DEF_INST(XED_ICLASS_VEXPANDPS,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPS_XMMf32_MASKmskw_MEMf32_AVX512,5017,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4805*/ XED_DEF_INST(XED_ICLASS_VEXPANDPS,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4806*/ XED_DEF_INST(XED_ICLASS_VEXPANDPS,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPS_YMMf32_MASKmskw_MEMf32_AVX512,5023,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4807*/ XED_DEF_INST(XED_ICLASS_VEXPANDPS,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXPANDPS_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4808*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULDQ_ZMMi64_MASKmskw_ZMMi32_ZMMi32_AVX512,6197,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4809*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULDQ_ZMMi64_MASKmskw_ZMMi32_MEMi32_AVX512,6201,4,0,0,137,XED_EXCEPTION_AVX512_E4),
/*4810*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULDQ_XMMi64_MASKmskw_XMMi32_XMMi32_AVX512,6205,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4811*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULDQ_XMMi64_MASKmskw_XMMi32_MEMi32_AVX512,6209,4,0,0,137,XED_EXCEPTION_AVX512_E4),
/*4812*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULDQ_YMMi64_MASKmskw_YMMi32_YMMi32_AVX512,6213,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4813*/ XED_DEF_INST(XED_ICLASS_VPMULDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULDQ_YMMi64_MASKmskw_YMMi32_MEMi32_AVX512,6217,4,0,0,137,XED_EXCEPTION_AVX512_E4),
/*4814*/ XED_DEF_INST(XED_ICLASS_VGATHERDPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERDPS_ZMMf32_MASKmskw_MEMf32_AVX512_VL512,6221,3,0,0,166,XED_EXCEPTION_AVX512_E12),
/*4815*/ XED_DEF_INST(XED_ICLASS_VGATHERDPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERDPS_XMMf32_MASKmskw_MEMf32_AVX512_VL128,5203,3,0,0,166,XED_EXCEPTION_AVX512_E12),
/*4816*/ XED_DEF_INST(XED_ICLASS_VGATHERDPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERDPS_YMMf32_MASKmskw_MEMf32_AVX512_VL256,5200,3,0,0,166,XED_EXCEPTION_AVX512_E12),
/*4817*/ XED_DEF_INST(XED_ICLASS_VSCATTERPF0QPD,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERPF0QPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,167,XED_EXCEPTION_AVX512_E12NP),
/*4818*/ XED_DEF_INST(XED_ICLASS_VPGATHERQD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPGATHERQD_YMMu32_MASKmskw_MEMu32_AVX512_VL512,6226,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4819*/ XED_DEF_INST(XED_ICLASS_VPGATHERQD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPGATHERQD_XMMu32_MASKmskw_MEMu32_AVX512_VL128,6229,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4820*/ XED_DEF_INST(XED_ICLASS_VPGATHERQD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPGATHERQD_XMMu32_MASKmskw_MEMu32_AVX512_VL256,6229,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4821*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENC_XMMu128_XMMu128_XMMu128_AVX512,5182,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*4822*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENC_XMMu128_XMMu128_MEMu128_AVX512,5185,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*4823*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENC_YMMu128_YMMu128_YMMu128_AVX512,5188,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*4824*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENC_YMMu128_YMMu128_MEMu128_AVX512,5191,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*4825*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENC_ZMMu128_ZMMu128_ZMMu128_AVX512,5194,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*4826*/ XED_DEF_INST(XED_ICLASS_VAESENC,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENC_ZMMu128_ZMMu128_MEMu128_AVX512,5197,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*4827*/ XED_DEF_INST(XED_ICLASS_VMOVLPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVLPD_XMMf64_XMMf64_MEMf64_AVX512,6232,3,0,0,142,XED_EXCEPTION_AVX512_E9NF),
/*4828*/ XED_DEF_INST(XED_ICLASS_VMOVLPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVLPD_MEMf64_XMMf64_AVX512,6235,2,0,0,142,XED_EXCEPTION_AVX512_E9NF),
/*4829*/ XED_DEF_INST(XED_ICLASS_VSCATTERPF0QPS,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERPF0QPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,167,XED_EXCEPTION_AVX512_E12NP),
/*4830*/ XED_DEF_INST(XED_ICLASS_VGATHERDPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERDPD_ZMMf64_MASKmskw_MEMf64_AVX512_VL512,5165,3,0,0,166,XED_EXCEPTION_AVX512_E12),
/*4831*/ XED_DEF_INST(XED_ICLASS_VGATHERDPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERDPD_XMMf64_MASKmskw_MEMf64_AVX512_VL128,5168,3,0,0,166,XED_EXCEPTION_AVX512_E12),
/*4832*/ XED_DEF_INST(XED_ICLASS_VGATHERDPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERDPD_YMMf64_MASKmskw_MEMf64_AVX512_VL256,5171,3,0,0,166,XED_EXCEPTION_AVX512_E12),
/*4833*/ XED_DEF_INST(XED_ICLASS_VMOVLHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVLHPS_XMMf32_XMMf32_XMMf32_AVX512,6239,3,0,0,0,XED_EXCEPTION_AVX512_E7NM128),
/*4834*/ XED_DEF_INST(XED_ICLASS_VMOVLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVLPS_XMMf32_XMMf32_MEMf32_AVX512,6242,3,0,0,168,XED_EXCEPTION_AVX512_E9NF),
/*4835*/ XED_DEF_INST(XED_ICLASS_VMOVLPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVLPS_MEMf32_XMMf32_AVX512,6245,2,0,0,168,XED_EXCEPTION_AVX512_E9NF),
/*4836*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHDQ_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4837*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHDQ_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4838*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHDQ_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4839*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHDQ_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4840*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHDQ_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4841*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHDQ_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*4842*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_YMMi32_MASKmskw_ZMMf64_AVX512_VL512,6247,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4843*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_YMMi32_MASKmskw_ZMMf64_AVX512_VL512,6250,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4844*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_YMMi32_MASKmskw_MEMf64_AVX512_VL512,6253,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4845*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_XMMi32_MASKmskw_XMMf64_AVX512_VL128,6256,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4846*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_XMMi32_MASKmskw_MEMf64_AVX512_VL128,6259,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4847*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_XMMi32_MASKmskw_YMMf64_AVX512_VL256,6262,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4848*/ XED_DEF_INST(XED_ICLASS_VCVTPD2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2DQ_XMMi32_MASKmskw_MEMf64_AVX512_VL256,6259,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4849*/ XED_DEF_INST(XED_ICLASS_VPGATHERQQ,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPGATHERQQ_ZMMu64_MASKmskw_MEMu64_AVX512_VL512,6265,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4850*/ XED_DEF_INST(XED_ICLASS_VPGATHERQQ,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPGATHERQQ_XMMu64_MASKmskw_MEMu64_AVX512_VL128,6268,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4851*/ XED_DEF_INST(XED_ICLASS_VPGATHERQQ,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPGATHERQQ_YMMu64_MASKmskw_MEMu64_AVX512_VL256,6271,3,0,0,152,XED_EXCEPTION_AVX512_E12),
/*4852*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR32i32_XMMf32_AVX512,6274,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4853*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR32i32_XMMf32_AVX512,6274,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4854*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR32i32_XMMf32_AVX512,6276,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4855*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR32i32_XMMf32_AVX512,6276,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4856*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR32i32_MEMf32_AVX512,3496,2,0,0,169,XED_EXCEPTION_AVX512_E3NF),
/*4857*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR32i32_MEMf32_AVX512,3496,2,0,0,169,XED_EXCEPTION_AVX512_E3NF),
/*4858*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR64i64_XMMf32_AVX512,6278,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4859*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR64i64_XMMf32_AVX512,6280,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*4860*/ XED_DEF_INST(XED_ICLASS_VCVTTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSS2SI_GPR64i64_MEMf32_AVX512,3500,2,0,0,169,XED_EXCEPTION_AVX512_E3NF),
/*4861*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_XMMi64_MASKmskw_XMMf64_AVX512,6282,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4862*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_XMMi64_MASKmskw_MEMf64_AVX512,6285,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4863*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_YMMi64_MASKmskw_YMMf64_AVX512,6288,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4864*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_YMMi64_MASKmskw_MEMf64_AVX512,6291,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4865*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_ZMMi64_MASKmskw_ZMMf64_AVX512,6294,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4866*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_ZMMi64_MASKmskw_ZMMf64_AVX512,6297,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4867*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PD_ZMMi64_MASKmskw_MEMf64_AVX512,6300,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4868*/ XED_DEF_INST(XED_ICLASS_VGATHERPF0DPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF0DPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,170,XED_EXCEPTION_AVX512_E12NP),
/*4869*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4870*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4871*/ XED_DEF_INST(XED_ICLASS_VFMSUB231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB231SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4872*/ XED_DEF_INST(XED_ICLASS_VFMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4873*/ XED_DEF_INST(XED_ICLASS_VFMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4874*/ XED_DEF_INST(XED_ICLASS_VFMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4875*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF64X4,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF64X4_ZMMf64_MASKmskw_MEMf64_AVX512,6303,3,0,0,165,XED_EXCEPTION_AVX512_E6),
/*4876*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_XMMf32_MASKmskw_XMMu64_AVX512_VL128,6306,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4877*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_XMMf32_MASKmskw_MEMu64_AVX512_VL128,6309,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4878*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_XMMf32_MASKmskw_YMMu64_AVX512_VL256,6312,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4879*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_XMMf32_MASKmskw_MEMu64_AVX512_VL256,6309,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4880*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_YMMf32_MASKmskw_ZMMu64_AVX512_VL512,6315,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4881*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_YMMf32_MASKmskw_ZMMu64_AVX512_VL512,6318,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4882*/ XED_DEF_INST(XED_ICLASS_VCVTQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTQQ2PS_YMMf32_MASKmskw_MEMu64_AVX512_VL512,6321,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4883*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF64X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF64X2_YMMf64_MASKmskw_MEMf64_AVX512,6324,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4884*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF64X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF64X2_ZMMf64_MASKmskw_MEMf64_AVX512,6327,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*4885*/ XED_DEF_INST(XED_ICLASS_VPSHUFBITQMB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_XMMu64_XMMu8_AVX512,6330,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4886*/ XED_DEF_INST(XED_ICLASS_VPSHUFBITQMB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_XMMu64_MEMu8_AVX512,6334,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4887*/ XED_DEF_INST(XED_ICLASS_VPSHUFBITQMB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_YMMu64_YMMu8_AVX512,6338,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4888*/ XED_DEF_INST(XED_ICLASS_VPSHUFBITQMB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_YMMu64_MEMu8_AVX512,6342,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4889*/ XED_DEF_INST(XED_ICLASS_VPSHUFBITQMB,XED_CATEGORY_AVX512_BITALG,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_ZMMu64_ZMMu8_AVX512,6346,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4890*/ XED_DEF_INST(XED_ICLASS_VPSHUFBITQMB,XED_CATEGORY_AVX512_BITALG,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_ZMMu64_MEMu8_AVX512,6350,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4891*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4892*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5214,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4893*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4894*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4895*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4896*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4897*/ XED_DEF_INST(XED_ICLASS_VMULPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMULPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4898*/ XED_DEF_INST(XED_ICLASS_VFMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4899*/ XED_DEF_INST(XED_ICLASS_VFMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*4900*/ XED_DEF_INST(XED_ICLASS_VFMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*4901*/ XED_DEF_INST(XED_ICLASS_VGATHERPF0DPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF0DPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,170,XED_EXCEPTION_AVX512_E12NP),
/*4902*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSD_MEMu32_MASKmskw_ZMMu32_AVX512,5470,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4903*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSD_ZMMu32_MASKmskw_ZMMu32_AVX512,5467,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4904*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSD_MEMu32_MASKmskw_XMMu32_AVX512,5479,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4905*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSD_XMMu32_MASKmskw_XMMu32_AVX512,5476,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4906*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSD_MEMu32_MASKmskw_YMMu32_AVX512,5488,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4907*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSD_YMMu32_MASKmskw_YMMu32_AVX512,5485,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4908*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSB,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSB_MEMu8_MASKmskw_XMMu8_AVX512,6354,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4909*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSB,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSB_XMMu8_MASKmskw_XMMu8_AVX512,6357,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4910*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSB,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSB_MEMu8_MASKmskw_YMMu8_AVX512,6360,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4911*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSB,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSB_YMMu8_MASKmskw_YMMu8_AVX512,6363,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4912*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSB,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSB_MEMu8_MASKmskw_ZMMu8_AVX512,6366,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4913*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSB,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSB_ZMMu8_MASKmskw_ZMMu8_AVX512,6369,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4914*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBW_XMMi16_MASKmskw_XMMi8_AVX512,5973,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4915*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBW_XMMi16_MASKmskw_MEMi8_AVX512,5976,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4916*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBW_YMMi16_MASKmskw_XMMi8_AVX512,5979,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4917*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBW_YMMi16_MASKmskw_MEMi8_AVX512,5982,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4918*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBW_ZMMi16_MASKmskw_YMMi8_AVX512,5985,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*4919*/ XED_DEF_INST(XED_ICLASS_VPMOVZXBW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXBW_ZMMi16_MASKmskw_MEMi8_AVX512,5988,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*4920*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_ZMMu32_MASKmskw_ZMMf32_AVX512,6372,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4921*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_ZMMu32_MASKmskw_ZMMf32_AVX512,6375,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4922*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_ZMMu32_MASKmskw_MEMf32_AVX512,6378,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4923*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_XMMu32_MASKmskw_XMMf32_AVX512,6381,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4924*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_XMMu32_MASKmskw_MEMf32_AVX512,6384,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4925*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_YMMu32_MASKmskw_YMMf32_AVX512,6387,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4926*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UDQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UDQ_YMMu32_MASKmskw_MEMf32_AVX512,6390,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4927*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSQ,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSQ_MEMu64_MASKmskw_ZMMu64_AVX512,6393,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4928*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSQ,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSQ_ZMMu64_MASKmskw_ZMMu64_AVX512,6396,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4929*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSQ,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSQ_MEMu64_MASKmskw_XMMu64_AVX512,6399,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4930*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSQ,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSQ_XMMu64_MASKmskw_XMMu64_AVX512,6402,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4931*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSQ,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSQ_MEMu64_MASKmskw_YMMu64_AVX512,6405,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*4932*/ XED_DEF_INST(XED_ICLASS_VPCOMPRESSQ,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCOMPRESSQ_YMMu64_MASKmskw_YMMu64_AVX512,6408,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4933*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512,4762,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4934*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSW_XMMi16_MASKmskw_XMMi16_MEMi16_AVX512,4766,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4935*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512,4770,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4936*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSW_YMMi16_MASKmskw_YMMi16_MEMi16_AVX512,4774,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4937*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512,4778,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4938*/ XED_DEF_INST(XED_ICLASS_VPADDSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSW_ZMMi16_MASKmskw_ZMMi16_MEMi16_AVX512,4782,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4939*/ XED_DEF_INST(XED_ICLASS_VPMOVSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQW_XMMi16_MASKmskw_ZMMi64_AVX512,6411,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4940*/ XED_DEF_INST(XED_ICLASS_VPMOVSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQW_MEMi16_MASKmskw_ZMMi64_AVX512,6414,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*4941*/ XED_DEF_INST(XED_ICLASS_VPMOVSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQW_XMMi16_MASKmskw_XMMi64_AVX512,6417,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4942*/ XED_DEF_INST(XED_ICLASS_VPMOVSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQW_MEMi16_MASKmskw_XMMi64_AVX512,6420,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*4943*/ XED_DEF_INST(XED_ICLASS_VPMOVSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQW_XMMi16_MASKmskw_YMMi64_AVX512,6423,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4944*/ XED_DEF_INST(XED_ICLASS_VPMOVSQW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQW_MEMi16_MASKmskw_YMMi64_AVX512,6426,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*4945*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4477,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4946*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4481,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4947*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_ZMMf64_MASKmskw_MEMf64_IMM8_AVX512,4485,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4948*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512,4461,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4949*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_XMMf64_MASKmskw_MEMf64_IMM8_AVX512,4465,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4950*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512,4469,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4951*/ XED_DEF_INST(XED_ICLASS_VGETMANTPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPD_YMMf64_MASKmskw_MEMf64_IMM8_AVX512,4473,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4952*/ XED_DEF_INST(XED_ICLASS_VPDPWSSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPWSSDS_XMMi32_MASKmskw_XMMi16_XMMu32_AVX512,6429,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4953*/ XED_DEF_INST(XED_ICLASS_VPDPWSSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPWSSDS_XMMi32_MASKmskw_XMMi16_MEMu32_AVX512,6433,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4954*/ XED_DEF_INST(XED_ICLASS_VPDPWSSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPWSSDS_YMMi32_MASKmskw_YMMi16_YMMu32_AVX512,6437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4955*/ XED_DEF_INST(XED_ICLASS_VPDPWSSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPWSSDS_YMMi32_MASKmskw_YMMi16_MEMu32_AVX512,6441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4956*/ XED_DEF_INST(XED_ICLASS_VPDPWSSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPWSSDS_ZMMi32_MASKmskw_ZMMi16_ZMMu32_AVX512,6445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4957*/ XED_DEF_INST(XED_ICLASS_VPDPWSSDS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPWSSDS_ZMMi32_MASKmskw_ZMMi16_MEMu32_AVX512,6449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*4958*/ XED_DEF_INST(XED_ICLASS_VINSERTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTPS_XMMf32_XMMf32_XMMf32_IMM8_AVX512,6453,4,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*4959*/ XED_DEF_INST(XED_ICLASS_VINSERTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTPS_XMMf32_XMMf32_MEMf32_IMM8_AVX512,6457,4,0,0,171,XED_EXCEPTION_AVX512_E9NF),
/*4960*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPALIGNR_XMMu8_MASKmskw_XMMu8_XMMu8_IMM8_AVX512,6461,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4961*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPALIGNR_XMMu8_MASKmskw_XMMu8_MEMu8_IMM8_AVX512,6466,5,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4962*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPALIGNR_YMMu8_MASKmskw_YMMu8_YMMu8_IMM8_AVX512,6471,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4963*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPALIGNR_YMMu8_MASKmskw_YMMu8_MEMu8_IMM8_AVX512,6476,5,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4964*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPALIGNR_ZMMu8_MASKmskw_ZMMu8_ZMMu8_IMM8_AVX512,6481,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*4965*/ XED_DEF_INST(XED_ICLASS_VPALIGNR,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPALIGNR_ZMMu8_MASKmskw_ZMMu8_MEMu8_IMM8_AVX512,6486,5,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*4966*/ XED_DEF_INST(XED_ICLASS_VPMOVSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQD_YMMi32_MASKmskw_ZMMi64_AVX512,6491,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4967*/ XED_DEF_INST(XED_ICLASS_VPMOVSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQD_MEMi32_MASKmskw_ZMMi64_AVX512,6494,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4968*/ XED_DEF_INST(XED_ICLASS_VPMOVSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQD_XMMi32_MASKmskw_XMMi64_AVX512,6497,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4969*/ XED_DEF_INST(XED_ICLASS_VPMOVSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQD_MEMi32_MASKmskw_XMMi64_AVX512,6500,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4970*/ XED_DEF_INST(XED_ICLASS_VPMOVSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQD_XMMi32_MASKmskw_YMMi64_AVX512,6503,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4971*/ XED_DEF_INST(XED_ICLASS_VPMOVSQD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQD_MEMi32_MASKmskw_YMMi64_AVX512,6506,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4972*/ XED_DEF_INST(XED_ICLASS_VPMOVSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQB_XMMi8_MASKmskw_ZMMi64_AVX512,6509,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4973*/ XED_DEF_INST(XED_ICLASS_VPMOVSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQB_MEMi8_MASKmskw_ZMMi64_AVX512,6512,3,0,0,153,XED_EXCEPTION_AVX512_E6),
/*4974*/ XED_DEF_INST(XED_ICLASS_VPMOVSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQB_XMMi8_MASKmskw_XMMi64_AVX512,6515,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4975*/ XED_DEF_INST(XED_ICLASS_VPMOVSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQB_MEMi8_MASKmskw_XMMi64_AVX512,6518,3,0,0,153,XED_EXCEPTION_AVX512_E6),
/*4976*/ XED_DEF_INST(XED_ICLASS_VPMOVSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQB_XMMi8_MASKmskw_YMMi64_AVX512,6521,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4977*/ XED_DEF_INST(XED_ICLASS_VPMOVSQB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSQB_MEMi8_MASKmskw_YMMi64_AVX512,6524,3,0,0,153,XED_EXCEPTION_AVX512_E6),
/*4978*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512,5415,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4979*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSB_XMMi8_MASKmskw_XMMi8_MEMi8_AVX512,5419,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4980*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512,5423,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4981*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSB_YMMi8_MASKmskw_YMMi8_MEMi8_AVX512,5427,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4982*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512,5431,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*4983*/ XED_DEF_INST(XED_ICLASS_VPADDSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDSB_ZMMi8_MASKmskw_ZMMi8_MEMi8_AVX512,5435,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*4984*/ XED_DEF_INST(XED_ICLASS_VPMOVWB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVWB_XMMu8_MASKmskw_XMMu16_AVX512,6527,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4985*/ XED_DEF_INST(XED_ICLASS_VPMOVWB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVWB_MEMu8_MASKmskw_XMMu16_AVX512,6530,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4986*/ XED_DEF_INST(XED_ICLASS_VPMOVWB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVWB_XMMu8_MASKmskw_YMMu16_AVX512,6533,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4987*/ XED_DEF_INST(XED_ICLASS_VPMOVWB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVWB_MEMu8_MASKmskw_YMMu16_AVX512,6536,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4988*/ XED_DEF_INST(XED_ICLASS_VPMOVWB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVWB_YMMu8_MASKmskw_ZMMu16_AVX512,6539,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*4989*/ XED_DEF_INST(XED_ICLASS_VPMOVWB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVWB_MEMu8_MASKmskw_ZMMu16_AVX512,6542,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*4990*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512,5103,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4991*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512,6545,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4992*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_ZMMf32_MASKmskw_MEMf32_IMM8_AVX512,5107,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4993*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512,5119,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4994*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_XMMf32_MASKmskw_MEMf32_IMM8_AVX512,5123,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4995*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512,5131,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4996*/ XED_DEF_INST(XED_ICLASS_VGETMANTPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETMANTPS_YMMf32_MASKmskw_MEMf32_IMM8_AVX512,5135,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*4997*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4998*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,6549,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*4999*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5000*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5001*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5002*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5003*/ XED_DEF_INST(XED_ICLASS_VMAXPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5004*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSWB_XMMu8_MASKmskw_XMMu16_XMMu16_AVX512,6553,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5005*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSWB_XMMu8_MASKmskw_XMMu16_MEMu16_AVX512,6557,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5006*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSWB_YMMu8_MASKmskw_YMMu16_YMMu16_AVX512,6561,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5007*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSWB_YMMu8_MASKmskw_YMMu16_MEMu16_AVX512,6565,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5008*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSWB_ZMMu8_MASKmskw_ZMMu16_ZMMu16_AVX512,6569,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5009*/ XED_DEF_INST(XED_ICLASS_VPACKUSWB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSWB_ZMMu8_MASKmskw_ZMMu16_MEMu16_AVX512,6573,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5010*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5011*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,6577,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5012*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5013*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5014*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5015*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5016*/ XED_DEF_INST(XED_ICLASS_VMAXPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMAXPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5017*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHQDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5018*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHQDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5019*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHQDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5020*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHQDQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5021*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHQDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5022*/ XED_DEF_INST(XED_ICLASS_VPUNPCKHQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKHQDQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5023*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSW_XMMi16_MASKmskw_XMMi16_AVX512,6581,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5024*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSW_XMMi16_MASKmskw_MEMi16_AVX512,6584,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5025*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSW_YMMi16_MASKmskw_YMMi16_AVX512,6587,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5026*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSW_YMMi16_MASKmskw_MEMi16_AVX512,6590,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5027*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSW_ZMMi16_MASKmskw_ZMMi16_AVX512,6593,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5028*/ XED_DEF_INST(XED_ICLASS_VPABSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSW_ZMMi16_MASKmskw_MEMi16_AVX512,6596,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5029*/ XED_DEF_INST(XED_ICLASS_VPABSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSQ_ZMMi64_MASKmskw_ZMMi64_AVX512,6599,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5030*/ XED_DEF_INST(XED_ICLASS_VPABSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSQ_ZMMi64_MASKmskw_MEMi64_AVX512,6602,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5031*/ XED_DEF_INST(XED_ICLASS_VPABSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSQ_XMMi64_MASKmskw_XMMi64_AVX512,6605,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5032*/ XED_DEF_INST(XED_ICLASS_VPABSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSQ_XMMi64_MASKmskw_MEMi64_AVX512,6608,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5033*/ XED_DEF_INST(XED_ICLASS_VPABSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSQ_YMMi64_MASKmskw_YMMi64_AVX512,6611,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5034*/ XED_DEF_INST(XED_ICLASS_VPABSQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSQ_YMMi64_MASKmskw_MEMi64_AVX512,6614,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5035*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5036*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5037*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5038*/ XED_DEF_INST(XED_ICLASS_VRCP14SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E10),
/*5039*/ XED_DEF_INST(XED_ICLASS_VRCP14SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E10),
/*5040*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5041*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5042*/ XED_DEF_INST(XED_ICLASS_VFMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMSUB213SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5043*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF32X4_XMMf32_MASKmskw_ZMMf32_IMM8_AVX512,6617,4,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5044*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF32X4_MEMf32_MASKmskw_ZMMf32_IMM8_AVX512,6621,4,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*5045*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF32X4_XMMf32_MASKmskw_YMMf32_IMM8_AVX512,6625,4,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5046*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF32X4_MEMf32_MASKmskw_YMMf32_IMM8_AVX512,6629,4,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*5047*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSB_XMMi8_MASKmskw_XMMi8_AVX512,6633,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5048*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSB_XMMi8_MASKmskw_MEMi8_AVX512,6636,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5049*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSB_YMMi8_MASKmskw_YMMi8_AVX512,6639,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5050*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSB_YMMi8_MASKmskw_MEMi8_AVX512,6642,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5051*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSB_ZMMi8_MASKmskw_ZMMi8_AVX512,6645,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5052*/ XED_DEF_INST(XED_ICLASS_VPABSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSB_ZMMi8_MASKmskw_MEMi8_AVX512,6648,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5053*/ XED_DEF_INST(XED_ICLASS_VRCP14SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E10),
/*5054*/ XED_DEF_INST(XED_ICLASS_VRCP14SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E10),
/*5055*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF32X8,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF32X8_YMMf32_MASKmskw_ZMMf32_IMM8_AVX512,6651,4,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5056*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF32X8,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF32X8_MEMf32_MASKmskw_ZMMf32_IMM8_AVX512,6655,4,0,0,172,XED_EXCEPTION_AVX512_E6NF),
/*5057*/ XED_DEF_INST(XED_ICLASS_VPCMPUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_XMMu16_XMMu16_IMM8_AVX512,6659,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5058*/ XED_DEF_INST(XED_ICLASS_VPCMPUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_XMMu16_MEMu16_IMM8_AVX512,6664,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5059*/ XED_DEF_INST(XED_ICLASS_VPCMPUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_YMMu16_YMMu16_IMM8_AVX512,6669,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5060*/ XED_DEF_INST(XED_ICLASS_VPCMPUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_YMMu16_MEMu16_IMM8_AVX512,6674,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5061*/ XED_DEF_INST(XED_ICLASS_VPCMPUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_IMM8_AVX512,6679,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5062*/ XED_DEF_INST(XED_ICLASS_VPCMPUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_ZMMu16_MEMu16_IMM8_AVX512,6684,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5063*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENCLAST_XMMu128_XMMu128_XMMu128_AVX512,5182,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*5064*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENCLAST_XMMu128_XMMu128_MEMu128_AVX512,5185,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*5065*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENCLAST_YMMu128_YMMu128_YMMu128_AVX512,5188,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*5066*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENCLAST_YMMu128_YMMu128_MEMu128_AVX512,5191,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*5067*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENCLAST_ZMMu128_ZMMu128_ZMMu128_AVX512,5194,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*5068*/ XED_DEF_INST(XED_ICLASS_VAESENCLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESENCLAST_ZMMu128_ZMMu128_MEMu128_AVX512,5197,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*5069*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR32u32_XMMf64_AVX512,6689,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5070*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR32u32_XMMf64_AVX512,6689,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5071*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR32u32_XMMf64_AVX512,6691,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5072*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR32u32_XMMf64_AVX512,6691,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5073*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR32u32_MEMf64_AVX512,6693,2,0,0,173,XED_EXCEPTION_AVX512_E3NF),
/*5074*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR32u32_MEMf64_AVX512,6693,2,0,0,173,XED_EXCEPTION_AVX512_E3NF),
/*5075*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR64u64_XMMf64_AVX512,6695,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5076*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR64u64_XMMf64_AVX512,6697,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5077*/ XED_DEF_INST(XED_ICLASS_VCVTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSD2USI_GPR64u64_MEMf64_AVX512,6699,2,0,0,173,XED_EXCEPTION_AVX512_E3NF),
/*5078*/ XED_DEF_INST(XED_ICLASS_VGATHERPF0QPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF0QPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,174,XED_EXCEPTION_AVX512_E12NP),
/*5079*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5080*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5081*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5082*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5083*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5084*/ XED_DEF_INST(XED_ICLASS_VPADDUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5085*/ XED_DEF_INST(XED_ICLASS_VRSQRT28SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512ER,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5086*/ XED_DEF_INST(XED_ICLASS_VRSQRT28SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512ER,5593,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5087*/ XED_DEF_INST(XED_ICLASS_VRSQRT28SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512ER,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5088*/ XED_DEF_INST(XED_ICLASS_VGATHERPF0QPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF0QPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,174,XED_EXCEPTION_AVX512_E12NP),
/*5089*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5090*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSB_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5091*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5092*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSB_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5093*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5094*/ XED_DEF_INST(XED_ICLASS_VPADDUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDUSB_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5095*/ XED_DEF_INST(XED_ICLASS_VRSQRT28SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512ER,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5096*/ XED_DEF_INST(XED_ICLASS_VRSQRT28SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512ER,5206,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5097*/ XED_DEF_INST(XED_ICLASS_VRSQRT28SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512ER,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5098*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5099*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5100*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5101*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5102*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5103*/ XED_DEF_INST(XED_ICLASS_VUNPCKHPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUNPCKHPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5104*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_MEMu32_AVX512,6701,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5105*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_XMMu32_AVX512,5609,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5106*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_GPR32u32_AVX512,6704,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5107*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_GPR32u32_AVX512,6704,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5108*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_XMMu32_MASKmskw_MEMu32_AVX512,6707,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5109*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5110*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_XMMu32_MASKmskw_GPR32u32_AVX512,6710,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5111*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_XMMu32_MASKmskw_GPR32u32_AVX512,6710,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5112*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_YMMu32_MASKmskw_MEMu32_AVX512,6713,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5113*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_YMMu32_MASKmskw_XMMu32_AVX512,5603,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5114*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_YMMu32_MASKmskw_GPR32u32_AVX512,6716,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5115*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTD_YMMu32_MASKmskw_GPR32u32_AVX512,6716,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5116*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5117*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5118*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5119*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5120*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5121*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5122*/ XED_DEF_INST(XED_ICLASS_VFMADD231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD231PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5123*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_XMMu8_MASKmskw_XMMu8_AVX512,5991,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5124*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_XMMu8_MASKmskw_MEMu8_AVX512,5994,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5125*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_XMMu8_MASKmskw_XMMu8_AVX512,6357,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5126*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_MEMu8_MASKmskw_XMMu8_AVX512,6354,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5127*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_YMMu8_MASKmskw_YMMu8_AVX512,5997,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5128*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_YMMu8_MASKmskw_MEMu8_AVX512,6000,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5129*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_YMMu8_MASKmskw_YMMu8_AVX512,6363,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5130*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_MEMu8_MASKmskw_YMMu8_AVX512,6360,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5131*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_ZMMu8_MASKmskw_ZMMu8_AVX512,6003,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5132*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_ZMMu8_MASKmskw_MEMu8_AVX512,6006,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5133*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_ZMMu8_MASKmskw_ZMMu8_AVX512,6369,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5134*/ XED_DEF_INST(XED_ICLASS_VMOVDQU8,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU8_MEMu8_MASKmskw_ZMMu8_AVX512,6366,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5135*/ XED_DEF_INST(XED_ICLASS_VSHUFI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI32X4_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512,4185,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5136*/ XED_DEF_INST(XED_ICLASS_VSHUFI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI32X4_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,4190,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5137*/ XED_DEF_INST(XED_ICLASS_VSHUFI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI32X4_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512,4175,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5138*/ XED_DEF_INST(XED_ICLASS_VSHUFI32X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI32X4_YMMu32_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,4180,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5139*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDB_XMMu8_MASKmskw_ZMMu32_AVX512,4786,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5140*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDB_MEMu8_MASKmskw_ZMMu32_AVX512,4789,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*5141*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDB_XMMu8_MASKmskw_XMMu32_AVX512,4792,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5142*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDB_MEMu8_MASKmskw_XMMu32_AVX512,4795,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*5143*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDB_XMMu8_MASKmskw_YMMu32_AVX512,4798,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5144*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDB,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDB_MEMu8_MASKmskw_YMMu32_AVX512,4801,3,0,0,143,XED_EXCEPTION_AVX512_E6),
/*5145*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5146*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5147*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5148*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5149*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5150*/ XED_DEF_INST(XED_ICLASS_VPMULHW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULHW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5151*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5152*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPD_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5153*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5154*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPD_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5155*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5156*/ XED_DEF_INST(XED_ICLASS_VXORPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPD_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5157*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4477,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5158*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_ZMMf64_MASKmskw_MEMf64_IMM8_AVX512,4485,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5159*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5160*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5161*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512,4461,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5162*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_XMMf64_MASKmskw_MEMf64_IMM8_AVX512,4465,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5163*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5164*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5165*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512,4469,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5166*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_YMMf64_MASKmskw_MEMf64_IMM8_AVX512,4473,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5167*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5168*/ XED_DEF_INST(XED_ICLASS_VPERMILPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMILPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5169*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDW_YMMu16_MASKmskw_ZMMu32_AVX512,4953,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5170*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDW_MEMu16_MASKmskw_ZMMu32_AVX512,4956,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*5171*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDW_XMMu16_MASKmskw_XMMu32_AVX512,4959,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5172*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDW_MEMu16_MASKmskw_XMMu32_AVX512,4962,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*5173*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDW_XMMu16_MASKmskw_YMMu32_AVX512,4965,3,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5174*/ XED_DEF_INST(XED_ICLASS_VPMOVUSDW,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVUSDW_MEMu16_MASKmskw_YMMu32_AVX512,4968,3,0,0,149,XED_EXCEPTION_AVX512_E6),
/*5175*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_ZMMu64_MASKmskw_MEMu64_AVX512,6719,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5176*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_ZMMu64_MASKmskw_XMMu64_AVX512,6722,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5177*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_ZMMu64_MASKmskw_GPR64u64_AVX512,6725,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5178*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_XMMu64_MASKmskw_MEMu64_AVX512,6728,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5179*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5180*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_XMMu64_MASKmskw_GPR64u64_AVX512,6731,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5181*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_YMMu64_MASKmskw_MEMu64_AVX512,6734,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5182*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_YMMu64_MASKmskw_XMMu64_AVX512,6737,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5183*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTQ,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTQ_YMMu64_MASKmskw_GPR64u64_AVX512,6740,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5184*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADDUBSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512,4762,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5185*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADDUBSW_XMMi16_MASKmskw_XMMi16_MEMi16_AVX512,4766,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5186*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADDUBSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512,4770,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5187*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADDUBSW_YMMi16_MASKmskw_YMMi16_MEMi16_AVX512,4774,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5188*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADDUBSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512,4778,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5189*/ XED_DEF_INST(XED_ICLASS_VPMADDUBSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMADDUBSW_ZMMi16_MASKmskw_ZMMi16_MEMi16_AVX512,4782,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5190*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5191*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPS_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5192*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5193*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPS_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5194*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5195*/ XED_DEF_INST(XED_ICLASS_VXORPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VXORPS_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5196*/ XED_DEF_INST(XED_ICLASS_VRNDSCALESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4727,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5197*/ XED_DEF_INST(XED_ICLASS_VRNDSCALESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4732,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5198*/ XED_DEF_INST(XED_ICLASS_VRNDSCALESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALESS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,4737,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5199*/ XED_DEF_INST(XED_ICLASS_VFMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5200*/ XED_DEF_INST(XED_ICLASS_VFMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5201*/ XED_DEF_INST(XED_ICLASS_VFMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5202*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5203*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPS_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5204*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5205*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPS_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5206*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5207*/ XED_DEF_INST(XED_ICLASS_VANDNPS,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPS_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5208*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5209*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_ZMMf32_MASKmskw_MEMf32_AVX512,5011,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5210*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5533,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5211*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_MEMf32_MASKmskw_ZMMf32_AVX512,5536,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5212*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5213*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_XMMf32_MASKmskw_MEMf32_AVX512,5017,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5214*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_XMMf32_MASKmskw_XMMf32_AVX512,5539,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5215*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_MEMf32_MASKmskw_XMMf32_AVX512,5542,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5216*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5217*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_YMMf32_MASKmskw_MEMf32_AVX512,5023,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5218*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_YMMf32_MASKmskw_YMMf32_AVX512,5545,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5219*/ XED_DEF_INST(XED_ICLASS_VMOVUPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPS_MEMf32_MASKmskw_YMMf32_AVX512,5548,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5220*/ XED_DEF_INST(XED_ICLASS_VPSRAVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5221*/ XED_DEF_INST(XED_ICLASS_VPSRAVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5222*/ XED_DEF_INST(XED_ICLASS_VPSRAVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5223*/ XED_DEF_INST(XED_ICLASS_VPSRAVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5224*/ XED_DEF_INST(XED_ICLASS_VPSRAVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5225*/ XED_DEF_INST(XED_ICLASS_VPSRAVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5226*/ XED_DEF_INST(XED_ICLASS_VPSRAVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5227*/ XED_DEF_INST(XED_ICLASS_VPSRAVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5228*/ XED_DEF_INST(XED_ICLASS_VPSRAVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5229*/ XED_DEF_INST(XED_ICLASS_VPSRAVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5230*/ XED_DEF_INST(XED_ICLASS_VPSRAVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5231*/ XED_DEF_INST(XED_ICLASS_VPSRAVW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5232*/ XED_DEF_INST(XED_ICLASS_VINSERTI32X8,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI32X8_ZMMu32_MASKmskw_ZMMu32_YMMu32_IMM8_AVX512,6743,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5233*/ XED_DEF_INST(XED_ICLASS_VINSERTI32X8,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI32X8_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,6748,5,0,0,172,XED_EXCEPTION_AVX512_E6NF),
/*5234*/ XED_DEF_INST(XED_ICLASS_VFMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5235*/ XED_DEF_INST(XED_ICLASS_VFMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5236*/ XED_DEF_INST(XED_ICLASS_VFMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5237*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_XMMf64_MASKmskw_XMMu64_AVX512,6753,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5238*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_XMMf64_MASKmskw_MEMu64_AVX512,6756,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5239*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_YMMf64_MASKmskw_YMMu64_AVX512,6759,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5240*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_YMMf64_MASKmskw_MEMu64_AVX512,6762,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5241*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_ZMMf64_MASKmskw_ZMMu64_AVX512,6765,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5242*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_ZMMf64_MASKmskw_ZMMu64_AVX512,6768,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5243*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PD_ZMMf64_MASKmskw_MEMu64_AVX512,6771,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5244*/ XED_DEF_INST(XED_ICLASS_VRNDSCALESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4661,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5245*/ XED_DEF_INST(XED_ICLASS_VRNDSCALESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4666,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5246*/ XED_DEF_INST(XED_ICLASS_VRNDSCALESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALESD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,4671,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5247*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5248*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_ZMMf64_MASKmskw_MEMf64_AVX512,5452,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5249*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_ZMMf64_MASKmskw_ZMMf64_AVX512,6774,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5250*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_MEMf64_MASKmskw_ZMMf64_AVX512,6777,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5251*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5252*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_XMMf64_MASKmskw_MEMf64_AVX512,6182,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5253*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_XMMf64_MASKmskw_XMMf64_AVX512,6780,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5254*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_MEMf64_MASKmskw_XMMf64_AVX512,6783,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5255*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5256*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_YMMf64_MASKmskw_MEMf64_AVX512,5461,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5257*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_YMMf64_MASKmskw_YMMf64_AVX512,6786,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5258*/ XED_DEF_INST(XED_ICLASS_VMOVUPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVUPD_MEMf64_MASKmskw_YMMf64_AVX512,6789,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5259*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5260*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5261*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5262*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5263*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5264*/ XED_DEF_INST(XED_ICLASS_VPSRAVD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAVD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5265*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_ZMMi32_MASKmskw_ZMMf32_AVX512,6102,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5266*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_ZMMi32_MASKmskw_ZMMf32_AVX512,6792,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5267*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_ZMMi32_MASKmskw_MEMf32_AVX512,6108,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5268*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_XMMi32_MASKmskw_XMMf32_AVX512,6111,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5269*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_XMMi32_MASKmskw_MEMf32_AVX512,6114,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5270*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_YMMi32_MASKmskw_YMMf32_AVX512,6117,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5271*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2DQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2DQ_YMMi32_MASKmskw_MEMf32_AVX512,6120,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5272*/ XED_DEF_INST(XED_ICLASS_VDIVSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5273*/ XED_DEF_INST(XED_ICLASS_VDIVSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5445,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5274*/ XED_DEF_INST(XED_ICLASS_VDIVSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5275*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5276*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5277*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD231SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5278*/ XED_DEF_INST(XED_ICLASS_VDIVSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5279*/ XED_DEF_INST(XED_ICLASS_VDIVSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5515,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5280*/ XED_DEF_INST(XED_ICLASS_VDIVSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5281*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVNTDQ_MEMu32_ZMMu32_AVX512,6795,2,0,0,159,XED_EXCEPTION_AVX512_E1NF),
/*5282*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVNTDQ_MEMu32_XMMu32_AVX512,6797,2,0,0,159,XED_EXCEPTION_AVX512_E1NF),
/*5283*/ XED_DEF_INST(XED_ICLASS_VMOVNTDQ,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVNTDQ_MEMu32_YMMu32_AVX512,6799,2,0,0,159,XED_EXCEPTION_AVX512_E1NF),
/*5284*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_XMMf32_MASKmskw_XMMu64_AVX512_VL128,6306,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5285*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_XMMf32_MASKmskw_MEMu64_AVX512_VL128,6309,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5286*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_XMMf32_MASKmskw_YMMu64_AVX512_VL256,6312,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5287*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_XMMf32_MASKmskw_MEMu64_AVX512_VL256,6309,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5288*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_YMMf32_MASKmskw_ZMMu64_AVX512_VL512,6315,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5289*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_YMMf32_MASKmskw_ZMMu64_AVX512_VL512,6318,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5290*/ XED_DEF_INST(XED_ICLASS_VCVTUQQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUQQ2PS_YMMf32_MASKmskw_MEMu64_AVX512_VL512,6321,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5291*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5292*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5293*/ XED_DEF_INST(XED_ICLASS_VFNMADD231SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD231SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5294*/ XED_DEF_INST(XED_ICLASS_VGETEXPSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5295*/ XED_DEF_INST(XED_ICLASS_VGETEXPSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5593,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5296*/ XED_DEF_INST(XED_ICLASS_VGETEXPSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5297*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512,6801,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5298*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512,6806,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5299*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_ZMMf32_MEMf32_IMM8_AVX512,6811,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5300*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,6009,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5301*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,6816,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5302*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_YMMf32_YMMf32_IMM8_AVX512,6821,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5303*/ XED_DEF_INST(XED_ICLASS_VCMPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPS_MASKmskw_MASKmskw_YMMf32_MEMf32_IMM8_AVX512,6826,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5304*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512,6831,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5305*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512,6836,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5306*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_ZMMf64_MEMf64_IMM8_AVX512,6841,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5307*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,6024,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5308*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,6846,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5309*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_YMMf64_YMMf64_IMM8_AVX512,6851,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5310*/ XED_DEF_INST(XED_ICLASS_VCMPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCMPPD_MASKmskw_MASKmskw_YMMf64_MEMf64_IMM8_AVX512,6856,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5311*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDECLAST_XMMu128_XMMu128_XMMu128_AVX512,5182,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*5312*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDECLAST_XMMu128_XMMu128_MEMu128_AVX512,5185,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*5313*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDECLAST_YMMu128_YMMu128_YMMu128_AVX512,5188,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*5314*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDECLAST_YMMu128_YMMu128_MEMu128_AVX512,5191,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*5315*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDECLAST_ZMMu128_ZMMu128_ZMMu128_AVX512,5194,3,0,0,0,XED_EXCEPTION_AVX512_E4),
/*5316*/ XED_DEF_INST(XED_ICLASS_VAESDECLAST,XED_CATEGORY_VAES,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VAESDECLAST_ZMMu128_ZMMu128_MEMu128_AVX512,5197,3,0,0,138,XED_EXCEPTION_AVX512_E4),
/*5317*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X8,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X8_ZMMu32_MASKmskw_MEMu32_AVX512,6861,3,0,0,176,XED_EXCEPTION_AVX512_E6),
/*5318*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5319*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5214,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5320*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5321*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5322*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5323*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5324*/ XED_DEF_INST(XED_ICLASS_VSUBPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5325*/ XED_DEF_INST(XED_ICLASS_VPSHRDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDW_XMMu16_MASKmskw_XMMu16_XMMu16_IMM8_AVX512,4295,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5326*/ XED_DEF_INST(XED_ICLASS_VPSHRDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDW_XMMu16_MASKmskw_XMMu16_MEMu16_IMM8_AVX512,4300,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5327*/ XED_DEF_INST(XED_ICLASS_VPSHRDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDW_YMMu16_MASKmskw_YMMu16_YMMu16_IMM8_AVX512,4305,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5328*/ XED_DEF_INST(XED_ICLASS_VPSHRDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDW_YMMu16_MASKmskw_YMMu16_MEMu16_IMM8_AVX512,4310,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5329*/ XED_DEF_INST(XED_ICLASS_VPSHRDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_IMM8_AVX512,4315,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5330*/ XED_DEF_INST(XED_ICLASS_VPSHRDW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDW_ZMMu16_MASKmskw_ZMMu16_MEMu16_IMM8_AVX512,4320,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5331*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5332*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPD_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5333*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5334*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPD_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5335*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5336*/ XED_DEF_INST(XED_ICLASS_VANDNPD,XED_CATEGORY_LOGICAL_FP,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VANDNPD_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5337*/ XED_DEF_INST(XED_ICLASS_VSCATTERPF1DPS,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERPF1DPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,177,XED_EXCEPTION_AVX512_E12NP),
/*5338*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR32i32_XMMf32_AVX512,6274,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5339*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR32i32_XMMf32_AVX512,6274,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5340*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR32i32_XMMf32_AVX512,6864,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5341*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR32i32_XMMf32_AVX512,6864,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5342*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR32i32_MEMf32_AVX512,3496,2,0,0,169,XED_EXCEPTION_AVX512_E3NF),
/*5343*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR32i32_MEMf32_AVX512,3496,2,0,0,169,XED_EXCEPTION_AVX512_E3NF),
/*5344*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR64i64_XMMf32_AVX512,6278,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5345*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR64i64_XMMf32_AVX512,6866,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5346*/ XED_DEF_INST(XED_ICLASS_VCVTSS2SI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTSS2SI_GPR64i64_MEMf32_AVX512,3500,2,0,0,169,XED_EXCEPTION_AVX512_E3NF),
/*5347*/ XED_DEF_INST(XED_ICLASS_VMINSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5348*/ XED_DEF_INST(XED_ICLASS_VMINSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5206,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5349*/ XED_DEF_INST(XED_ICLASS_VMINSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5350*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X4,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X4_ZMMu32_MASKmskw_MEMu32_AVX512,6868,3,0,0,165,XED_EXCEPTION_AVX512_E6),
/*5351*/ XED_DEF_INST(XED_ICLASS_VBROADCASTI32X4,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTI32X4_YMMu32_MASKmskw_MEMu32_AVX512,6871,3,0,0,165,XED_EXCEPTION_AVX512_E6),
/*5352*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512,6874,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5353*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512,6879,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5354*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_IMM8_AVX512,6884,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5355*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,6889,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5356*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,6894,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5357*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512,6899,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5358*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPS_YMMf32_MASKmskw_YMMf32_MEMf32_IMM8_AVX512,6904,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5359*/ XED_DEF_INST(XED_ICLASS_VPSHRDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDD_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512,4165,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5360*/ XED_DEF_INST(XED_ICLASS_VPSHRDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDD_XMMu32_MASKmskw_XMMu32_MEMu32_IMM8_AVX512,4170,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5361*/ XED_DEF_INST(XED_ICLASS_VPSHRDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDD_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512,4175,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5362*/ XED_DEF_INST(XED_ICLASS_VPSHRDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDD_YMMu32_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,4180,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5363*/ XED_DEF_INST(XED_ICLASS_VPSHRDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512,4185,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5364*/ XED_DEF_INST(XED_ICLASS_VPSHRDD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHRDD_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,4190,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5365*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X8,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X8_ZMMf32_MASKmskw_MEMf32_AVX512,6909,3,0,0,176,XED_EXCEPTION_AVX512_E6),
/*5366*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5367*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5276,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5368*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5369*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5370*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5371*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5372*/ XED_DEF_INST(XED_ICLASS_VSUBPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSUBPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5373*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512,6912,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5374*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512,6917,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5375*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_IMM8_AVX512,6922,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5376*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,6927,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5377*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,6932,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5378*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512,6937,5,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5379*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMPD_YMMf64_MASKmskw_YMMf64_MEMf64_IMM8_AVX512,6942,5,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5380*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X2_YMMf32_MASKmskw_XMMf32_AVX512,6947,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5381*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X2_YMMf32_MASKmskw_MEMf32_AVX512,6950,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*5382*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X2_ZMMf32_MASKmskw_XMMf32_AVX512,6953,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5383*/ XED_DEF_INST(XED_ICLASS_VBROADCASTF32X2,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTF32X2_ZMMf32_MASKmskw_MEMf32_AVX512,6956,3,0,0,157,XED_EXCEPTION_AVX512_E6),
/*5384*/ XED_DEF_INST(XED_ICLASS_VMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5385*/ XED_DEF_INST(XED_ICLASS_VMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5593,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5386*/ XED_DEF_INST(XED_ICLASS_VMINSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINSD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5387*/ XED_DEF_INST(XED_ICLASS_VSCATTERPF1DPD,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERPF1DPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,177,XED_EXCEPTION_AVX512_E12NP),
/*5388*/ XED_DEF_INST(XED_ICLASS_VPCMPW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPW_MASKmskw_MASKmskw_XMMi16_XMMi16_IMM8_AVX512,6959,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5389*/ XED_DEF_INST(XED_ICLASS_VPCMPW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPW_MASKmskw_MASKmskw_XMMi16_MEMi16_IMM8_AVX512,6964,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5390*/ XED_DEF_INST(XED_ICLASS_VPCMPW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPW_MASKmskw_MASKmskw_YMMi16_YMMi16_IMM8_AVX512,6969,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5391*/ XED_DEF_INST(XED_ICLASS_VPCMPW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPW_MASKmskw_MASKmskw_YMMi16_MEMi16_IMM8_AVX512,6974,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5392*/ XED_DEF_INST(XED_ICLASS_VPCMPW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPW_MASKmskw_MASKmskw_ZMMi16_ZMMi16_IMM8_AVX512,6979,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5393*/ XED_DEF_INST(XED_ICLASS_VPCMPW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPW_MASKmskw_MASKmskw_ZMMi16_MEMi16_IMM8_AVX512,6984,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5394*/ XED_DEF_INST(XED_ICLASS_VPCMPQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_ZMMi64_ZMMi64_IMM8_AVX512,6989,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5395*/ XED_DEF_INST(XED_ICLASS_VPCMPQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_ZMMi64_MEMi64_IMM8_AVX512,6994,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5396*/ XED_DEF_INST(XED_ICLASS_VPCMPQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_XMMi64_XMMi64_IMM8_AVX512,6999,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5397*/ XED_DEF_INST(XED_ICLASS_VPCMPQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_XMMi64_MEMi64_IMM8_AVX512,7004,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5398*/ XED_DEF_INST(XED_ICLASS_VPCMPQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_YMMi64_YMMi64_IMM8_AVX512,7009,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5399*/ XED_DEF_INST(XED_ICLASS_VPCMPQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_YMMi64_MEMi64_IMM8_AVX512,7014,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5400*/ XED_DEF_INST(XED_ICLASS_VSCATTERQPS,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERQPS_MEMf32_MASKmskw_YMMf32_AVX512_VL512,7019,3,0,0,178,XED_EXCEPTION_AVX512_E12),
/*5401*/ XED_DEF_INST(XED_ICLASS_VSCATTERQPS,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERQPS_MEMf32_MASKmskw_XMMf32_AVX512_VL128,7022,3,0,0,178,XED_EXCEPTION_AVX512_E12),
/*5402*/ XED_DEF_INST(XED_ICLASS_VSCATTERQPS,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERQPS_MEMf32_MASKmskw_XMMf32_AVX512_VL256,7022,3,0,0,178,XED_EXCEPTION_AVX512_E12),
/*5403*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5404*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSB_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5405*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5406*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSB_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5407*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5408*/ XED_DEF_INST(XED_ICLASS_VPSUBUSB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSB_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5409*/ XED_DEF_INST(XED_ICLASS_VEXP2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXP2PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER,5008,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5410*/ XED_DEF_INST(XED_ICLASS_VEXP2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXP2PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER,6123,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5411*/ XED_DEF_INST(XED_ICLASS_VEXP2PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXP2PS_ZMMf32_MASKmskw_MEMf32_AVX512ER,6093,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5412*/ XED_DEF_INST(XED_ICLASS_VPCMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPD_MASKmskw_MASKmskw_ZMMi32_ZMMi32_IMM8_AVX512,7025,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5413*/ XED_DEF_INST(XED_ICLASS_VPCMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPD_MASKmskw_MASKmskw_ZMMi32_MEMi32_IMM8_AVX512,7030,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5414*/ XED_DEF_INST(XED_ICLASS_VPCMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPD_MASKmskw_MASKmskw_XMMi32_XMMi32_IMM8_AVX512,7035,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5415*/ XED_DEF_INST(XED_ICLASS_VPCMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPD_MASKmskw_MASKmskw_XMMi32_MEMi32_IMM8_AVX512,7040,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5416*/ XED_DEF_INST(XED_ICLASS_VPCMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPD_MASKmskw_MASKmskw_YMMi32_YMMi32_IMM8_AVX512,7045,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5417*/ XED_DEF_INST(XED_ICLASS_VPCMPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPD_MASKmskw_MASKmskw_YMMi32_MEMi32_IMM8_AVX512,7050,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5418*/ XED_DEF_INST(XED_ICLASS_VPCMPB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPB_MASKmskw_MASKmskw_XMMi8_XMMi8_IMM8_AVX512,7055,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5419*/ XED_DEF_INST(XED_ICLASS_VPCMPB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPB_MASKmskw_MASKmskw_XMMi8_MEMi8_IMM8_AVX512,7060,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5420*/ XED_DEF_INST(XED_ICLASS_VPCMPB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPB_MASKmskw_MASKmskw_YMMi8_YMMi8_IMM8_AVX512,7065,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5421*/ XED_DEF_INST(XED_ICLASS_VPCMPB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPB_MASKmskw_MASKmskw_YMMi8_MEMi8_IMM8_AVX512,7070,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5422*/ XED_DEF_INST(XED_ICLASS_VPCMPB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPB_MASKmskw_MASKmskw_ZMMi8_ZMMi8_IMM8_AVX512,7075,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5423*/ XED_DEF_INST(XED_ICLASS_VPCMPB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPB_MASKmskw_MASKmskw_ZMMi8_MEMi8_IMM8_AVX512,7080,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5424*/ XED_DEF_INST(XED_ICLASS_VEXP2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXP2PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER,5449,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5425*/ XED_DEF_INST(XED_ICLASS_VEXP2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXP2PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER,6059,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5426*/ XED_DEF_INST(XED_ICLASS_VEXP2PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXP2PD_ZMMf64_MASKmskw_MEMf64_AVX512ER,6062,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5427*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEINVQB_XMMu8_MASKmskw_XMMu8_XMMu64_IMM8_AVX512,5325,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5428*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEINVQB_XMMu8_MASKmskw_XMMu8_MEMu64_IMM8_AVX512,5330,5,0,0,148,XED_EXCEPTION_AVX512_E4),
/*5429*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEINVQB_YMMu8_MASKmskw_YMMu8_YMMu64_IMM8_AVX512,5335,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5430*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEINVQB_YMMu8_MASKmskw_YMMu8_MEMu64_IMM8_AVX512,5340,5,0,0,148,XED_EXCEPTION_AVX512_E4),
/*5431*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEINVQB_ZMMu8_MASKmskw_ZMMu8_ZMMu64_IMM8_AVX512,5345,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5432*/ XED_DEF_INST(XED_ICLASS_VGF2P8AFFINEINVQB,XED_CATEGORY_GFNI,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGF2P8AFFINEINVQB_ZMMu8_MASKmskw_ZMMu8_MEMu64_IMM8_AVX512,5350,5,0,0,148,XED_EXCEPTION_AVX512_E4),
/*5433*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5434*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5435*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5436*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5437*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5438*/ XED_DEF_INST(XED_ICLASS_VPSUBUSW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSUBUSW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5439*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5440*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5441*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5442*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5443*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5444*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5445*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5446*/ XED_DEF_INST(XED_ICLASS_VSHUFI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI64X2_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512,4271,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5447*/ XED_DEF_INST(XED_ICLASS_VSHUFI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI64X2_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,4276,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5448*/ XED_DEF_INST(XED_ICLASS_VSHUFI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI64X2_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512,4261,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5449*/ XED_DEF_INST(XED_ICLASS_VSHUFI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFI64X2_YMMu64_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,4266,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5450*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512,5103,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5451*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512,6545,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5452*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_ZMMf32_MASKmskw_MEMf32_IMM8_AVX512,5107,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5453*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512,5119,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5454*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_XMMf32_MASKmskw_MEMf32_IMM8_AVX512,5123,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5455*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512,5131,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5456*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPS_YMMf32_MASKmskw_MEMf32_IMM8_AVX512,5135,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5457*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5458*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_ZMMf32_MASKmskw_ZMMf32_AVX512,6123,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5459*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_ZMMf32_MASKmskw_MEMf32_AVX512,6093,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5460*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5461*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_XMMf32_MASKmskw_MEMf32_AVX512,6096,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5462*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5463*/ XED_DEF_INST(XED_ICLASS_VGETEXPPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPS_YMMf32_MASKmskw_MEMf32_AVX512,6099,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5464*/ XED_DEF_INST(XED_ICLASS_VMOVHPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVHPD_XMMf64_XMMf64_MEMf64_AVX512,7085,3,0,0,142,XED_EXCEPTION_AVX512_E9NF),
/*5465*/ XED_DEF_INST(XED_ICLASS_VMOVHPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVHPD_MEMf64_XMMf64_AVX512,7088,2,0,0,142,XED_EXCEPTION_AVX512_E9NF),
/*5466*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5467*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5468*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5469*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5470*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5471*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5472*/ XED_DEF_INST(XED_ICLASS_VFMADD132PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5473*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5474*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5475*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5476*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5477*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5478*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5479*/ XED_DEF_INST(XED_ICLASS_VFMADD132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD132PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5480*/ XED_DEF_INST(XED_ICLASS_VMOVHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVHPS_XMMf32_XMMf32_MEMf32_AVX512,7090,3,0,0,168,XED_EXCEPTION_AVX512_E9NF),
/*5481*/ XED_DEF_INST(XED_ICLASS_VMOVHPS,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVHPS_MEMf32_XMMf32_AVX512,7093,2,0,0,168,XED_EXCEPTION_AVX512_E9NF),
/*5482*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5483*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_ZMMf64_MASKmskw_ZMMf64_AVX512,6059,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5484*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_ZMMf64_MASKmskw_MEMf64_AVX512,6062,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5485*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5486*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_XMMf64_MASKmskw_MEMf64_AVX512,6135,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5487*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5488*/ XED_DEF_INST(XED_ICLASS_VGETEXPPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGETEXPPD_YMMf64_MASKmskw_MEMf64_AVX512,6138,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5489*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4477,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5490*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512,4481,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5491*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_ZMMf64_MASKmskw_MEMf64_IMM8_AVX512,4485,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5492*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512,4461,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5493*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_XMMf64_MASKmskw_MEMf64_IMM8_AVX512,4465,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5494*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512,4469,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5495*/ XED_DEF_INST(XED_ICLASS_VRNDSCALEPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRNDSCALEPD_YMMf64_MASKmskw_MEMf64_IMM8_AVX512,4473,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5496*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSD_ZMMi32_MASKmskw_ZMMi32_AVX512,7095,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5497*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSD_ZMMi32_MASKmskw_MEMi32_AVX512,7098,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5498*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSD_XMMi32_MASKmskw_XMMi32_AVX512,7101,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5499*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSD_XMMi32_MASKmskw_MEMi32_AVX512,7104,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5500*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSD_YMMi32_MASKmskw_YMMi32_AVX512,7107,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5501*/ XED_DEF_INST(XED_ICLASS_VPABSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPABSD_YMMi32_MASKmskw_MEMi32_AVX512,7110,3,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5502*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5503*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5504*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5505*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5506*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5507*/ XED_DEF_INST(XED_ICLASS_VPADDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5508*/ XED_DEF_INST(XED_ICLASS_VPCMPUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512,7113,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5509*/ XED_DEF_INST(XED_ICLASS_VPCMPUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,7118,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5510*/ XED_DEF_INST(XED_ICLASS_VPCMPUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_XMMu64_XMMu64_IMM8_AVX512,7123,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5511*/ XED_DEF_INST(XED_ICLASS_VPCMPUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_XMMu64_MEMu64_IMM8_AVX512,7128,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5512*/ XED_DEF_INST(XED_ICLASS_VPCMPUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_YMMu64_YMMu64_IMM8_AVX512,7133,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5513*/ XED_DEF_INST(XED_ICLASS_VPCMPUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,7138,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5514*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5515*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5516*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5517*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5518*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5519*/ XED_DEF_INST(XED_ICLASS_VPADDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5520*/ XED_DEF_INST(XED_ICLASS_VRSQRT28PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER,5008,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5521*/ XED_DEF_INST(XED_ICLASS_VRSQRT28PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER,6123,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5522*/ XED_DEF_INST(XED_ICLASS_VRSQRT28PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28PS_ZMMf32_MASKmskw_MEMf32_AVX512ER,6093,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5523*/ XED_DEF_INST(XED_ICLASS_VPEXPANDB,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDB_XMMu8_MASKmskw_MEMu8_AVX512,5994,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5524*/ XED_DEF_INST(XED_ICLASS_VPEXPANDB,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDB_XMMu8_MASKmskw_XMMu8_AVX512,5991,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5525*/ XED_DEF_INST(XED_ICLASS_VPEXPANDB,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDB_YMMu8_MASKmskw_MEMu8_AVX512,6000,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5526*/ XED_DEF_INST(XED_ICLASS_VPEXPANDB,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDB_YMMu8_MASKmskw_YMMu8_AVX512,5997,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5527*/ XED_DEF_INST(XED_ICLASS_VPEXPANDB,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDB_ZMMu8_MASKmskw_MEMu8_AVX512,6006,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5528*/ XED_DEF_INST(XED_ICLASS_VPEXPANDB,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDB_ZMMu8_MASKmskw_ZMMu8_AVX512,6003,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5529*/ XED_DEF_INST(XED_ICLASS_VPEXPANDD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDD_ZMMu32_MASKmskw_MEMu32_AVX512,5464,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5530*/ XED_DEF_INST(XED_ICLASS_VPEXPANDD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDD_ZMMu32_MASKmskw_ZMMu32_AVX512,4935,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5531*/ XED_DEF_INST(XED_ICLASS_VPEXPANDD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDD_XMMu32_MASKmskw_MEMu32_AVX512,5473,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5532*/ XED_DEF_INST(XED_ICLASS_VPEXPANDD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDD_XMMu32_MASKmskw_XMMu32_AVX512,4941,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5533*/ XED_DEF_INST(XED_ICLASS_VPEXPANDD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDD_YMMu32_MASKmskw_MEMu32_AVX512,5482,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5534*/ XED_DEF_INST(XED_ICLASS_VPEXPANDD,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDD_YMMu32_MASKmskw_YMMu32_AVX512,4947,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5535*/ XED_DEF_INST(XED_ICLASS_VPCMPUB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_XMMu8_XMMu8_IMM8_AVX512,7143,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5536*/ XED_DEF_INST(XED_ICLASS_VPCMPUB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_XMMu8_MEMu8_IMM8_AVX512,7148,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5537*/ XED_DEF_INST(XED_ICLASS_VPCMPUB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_YMMu8_YMMu8_IMM8_AVX512,7153,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5538*/ XED_DEF_INST(XED_ICLASS_VPCMPUB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_YMMu8_MEMu8_IMM8_AVX512,7158,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5539*/ XED_DEF_INST(XED_ICLASS_VPCMPUB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_IMM8_AVX512,7163,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5540*/ XED_DEF_INST(XED_ICLASS_VPCMPUB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_ZMMu8_MEMu8_IMM8_AVX512,7168,5,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5541*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512,4842,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5542*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDB_XMMu8_MASKmskw_XMMu8_MEMu8_AVX512,4846,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5543*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512,4850,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5544*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDB_YMMu8_MASKmskw_YMMu8_MEMu8_AVX512,4854,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5545*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512,4858,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5546*/ XED_DEF_INST(XED_ICLASS_VPADDB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDB_ZMMu8_MASKmskw_ZMMu8_MEMu8_AVX512,4862,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5547*/ XED_DEF_INST(XED_ICLASS_VRSQRT28PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER,5449,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5548*/ XED_DEF_INST(XED_ICLASS_VRSQRT28PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER,6059,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5549*/ XED_DEF_INST(XED_ICLASS_VRSQRT28PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRSQRT28PD_ZMMf64_MASKmskw_MEMf64_AVX512ER,6062,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5550*/ XED_DEF_INST(XED_ICLASS_VPCMPUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512,7173,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5551*/ XED_DEF_INST(XED_ICLASS_VPCMPUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,7178,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5552*/ XED_DEF_INST(XED_ICLASS_VPCMPUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_XMMu32_XMMu32_IMM8_AVX512,7183,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5553*/ XED_DEF_INST(XED_ICLASS_VPCMPUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_XMMu32_MEMu32_IMM8_AVX512,7188,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5554*/ XED_DEF_INST(XED_ICLASS_VPCMPUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_YMMu32_YMMu32_IMM8_AVX512,7193,5,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5555*/ XED_DEF_INST(XED_ICLASS_VPCMPUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,7198,5,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5556*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5557*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5558*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5559*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5560*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5561*/ XED_DEF_INST(XED_ICLASS_VPADDD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPADDD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5562*/ XED_DEF_INST(XED_ICLASS_VPEXPANDQ,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDQ_ZMMu64_MASKmskw_MEMu64_AVX512,7203,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5563*/ XED_DEF_INST(XED_ICLASS_VPEXPANDQ,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDQ_ZMMu64_MASKmskw_ZMMu64_AVX512,5048,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5564*/ XED_DEF_INST(XED_ICLASS_VPEXPANDQ,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDQ_XMMu64_MASKmskw_MEMu64_AVX512,7206,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5565*/ XED_DEF_INST(XED_ICLASS_VPEXPANDQ,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDQ_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5566*/ XED_DEF_INST(XED_ICLASS_VPEXPANDQ,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDQ_YMMu64_MASKmskw_MEMu64_AVX512,7209,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5567*/ XED_DEF_INST(XED_ICLASS_VPEXPANDQ,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDQ_YMMu64_MASKmskw_YMMu64_AVX512,5060,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5568*/ XED_DEF_INST(XED_ICLASS_VPEXPANDW,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDW_XMMu16_MASKmskw_MEMu16_AVX512,7212,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5569*/ XED_DEF_INST(XED_ICLASS_VPEXPANDW,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDW_XMMu16_MASKmskw_XMMu16_AVX512,7215,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5570*/ XED_DEF_INST(XED_ICLASS_VPEXPANDW,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDW_YMMu16_MASKmskw_MEMu16_AVX512,7218,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5571*/ XED_DEF_INST(XED_ICLASS_VPEXPANDW,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDW_YMMu16_MASKmskw_YMMu16_AVX512,7221,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5572*/ XED_DEF_INST(XED_ICLASS_VPEXPANDW,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDW_ZMMu16_MASKmskw_MEMu16_AVX512,7224,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5573*/ XED_DEF_INST(XED_ICLASS_VPEXPANDW,XED_CATEGORY_EXPAND,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXPANDW_ZMMu16_MASKmskw_ZMMu16_AVX512,7227,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5574*/ XED_DEF_INST(XED_ICLASS_VP4DPWSSD,XED_CATEGORY_AVX512_4VNNIW,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VP4DPWSSD_ZMMi32_MASKmskw_ZMMi16_MEMu32_AVX512,5026,4,0,0,151,XED_EXCEPTION_AVX512_E4),
/*5575*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR32u32_XMMf64_AVX512,6689,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5576*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR32u32_XMMf64_AVX512,6689,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5577*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR32u32_XMMf64_AVX512,7230,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5578*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR32u32_XMMf64_AVX512,7230,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5579*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR32u32_MEMf64_AVX512,6693,2,0,0,173,XED_EXCEPTION_AVX512_E3NF),
/*5580*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR32u32_MEMf64_AVX512,6693,2,0,0,173,XED_EXCEPTION_AVX512_E3NF),
/*5581*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR64u64_XMMf64_AVX512,6695,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5582*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR64u64_XMMf64_AVX512,7232,2,0,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5583*/ XED_DEF_INST(XED_ICLASS_VCVTTSD2USI,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTSD2USI_GPR64u64_MEMf64_AVX512,6699,2,0,0,173,XED_EXCEPTION_AVX512_E3NF),
/*5584*/ XED_DEF_INST(XED_ICLASS_VSHUFF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF64X2_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512,6065,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5585*/ XED_DEF_INST(XED_ICLASS_VSHUFF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF64X2_ZMMf64_MASKmskw_ZMMf64_MEMf64_IMM8_AVX512,6070,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5586*/ XED_DEF_INST(XED_ICLASS_VSHUFF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF64X2_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512,6080,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5587*/ XED_DEF_INST(XED_ICLASS_VSHUFF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSHUFF64X2_YMMf64_MASKmskw_YMMf64_MEMf64_IMM8_AVX512,6085,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5588*/ XED_DEF_INST(XED_ICLASS_VPDPBUSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSD_XMMi32_MASKmskw_XMMu8_XMMu32_AVX512,5746,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5589*/ XED_DEF_INST(XED_ICLASS_VPDPBUSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSD_XMMi32_MASKmskw_XMMu8_MEMu32_AVX512,5750,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5590*/ XED_DEF_INST(XED_ICLASS_VPDPBUSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSD_YMMi32_MASKmskw_YMMu8_YMMu32_AVX512,5754,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5591*/ XED_DEF_INST(XED_ICLASS_VPDPBUSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSD_YMMi32_MASKmskw_YMMu8_MEMu32_AVX512,5758,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5592*/ XED_DEF_INST(XED_ICLASS_VPDPBUSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSD_ZMMi32_MASKmskw_ZMMu8_ZMMu32_AVX512,5762,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5593*/ XED_DEF_INST(XED_ICLASS_VPDPBUSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPDPBUSD_ZMMi32_MASKmskw_ZMMu8_MEMu32_AVX512,5766,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5594*/ XED_DEF_INST(XED_ICLASS_VPTESTMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_XMMu8_XMMu8_AVX512,5280,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5595*/ XED_DEF_INST(XED_ICLASS_VPTESTMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_XMMu8_MEMu8_AVX512,5284,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5596*/ XED_DEF_INST(XED_ICLASS_VPTESTMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_YMMu8_YMMu8_AVX512,5288,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5597*/ XED_DEF_INST(XED_ICLASS_VPTESTMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_YMMu8_MEMu8_AVX512,5292,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5598*/ XED_DEF_INST(XED_ICLASS_VPTESTMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_AVX512,5296,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5599*/ XED_DEF_INST(XED_ICLASS_VPTESTMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_ZMMu8_MEMu8_AVX512,5300,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5600*/ XED_DEF_INST(XED_ICLASS_VPMOVQ2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVQ2M_MASKmskw_XMMu64_AVX512,7234,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*5601*/ XED_DEF_INST(XED_ICLASS_VPMOVQ2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVQ2M_MASKmskw_YMMu64_AVX512,7236,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*5602*/ XED_DEF_INST(XED_ICLASS_VPMOVQ2M,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVQ2M_MASKmskw_ZMMu64_AVX512,7238,2,0,0,0,XED_EXCEPTION_AVX512_E7NM),
/*5603*/ XED_DEF_INST(XED_ICLASS_VPRORQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512,4565,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5604*/ XED_DEF_INST(XED_ICLASS_VPRORQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORQ_ZMMu64_MASKmskw_MEMu64_IMM8_AVX512,4569,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5605*/ XED_DEF_INST(XED_ICLASS_VPRORQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512,4573,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5606*/ XED_DEF_INST(XED_ICLASS_VPRORQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORQ_XMMu64_MASKmskw_MEMu64_IMM8_AVX512,4577,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5607*/ XED_DEF_INST(XED_ICLASS_VPRORQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512,4581,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5608*/ XED_DEF_INST(XED_ICLASS_VPRORQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORQ_YMMu64_MASKmskw_MEMu64_IMM8_AVX512,4585,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5609*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5610*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5611*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5612*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5613*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5614*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5615*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5616*/ XED_DEF_INST(XED_ICLASS_VPRORD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512,5796,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5617*/ XED_DEF_INST(XED_ICLASS_VPRORD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORD_ZMMu32_MASKmskw_MEMu32_IMM8_AVX512,5800,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5618*/ XED_DEF_INST(XED_ICLASS_VPRORD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512,5808,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5619*/ XED_DEF_INST(XED_ICLASS_VPRORD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORD_XMMu32_MASKmskw_MEMu32_IMM8_AVX512,5812,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5620*/ XED_DEF_INST(XED_ICLASS_VPRORD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512,5824,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5621*/ XED_DEF_INST(XED_ICLASS_VPRORD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORD_YMMu32_MASKmskw_MEMu32_IMM8_AVX512,5828,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5622*/ XED_DEF_INST(XED_ICLASS_VPEXTRB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRB_GPR32u8_XMMu8_IMM8_AVX512,7240,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5623*/ XED_DEF_INST(XED_ICLASS_VPEXTRB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRB_MEMu8_XMMu8_IMM8_AVX512,7243,3,0,0,179,XED_EXCEPTION_AVX512_E9NF),
/*5624*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRD_GPR32u32_XMMu32_IMM8_AVX512,7246,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5625*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRD_GPR32u32_XMMu32_IMM8_AVX512,7246,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5626*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRD_MEMu32_XMMu32_IMM8_AVX512,7249,3,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*5627*/ XED_DEF_INST(XED_ICLASS_VPEXTRD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRD_MEMu32_XMMu32_IMM8_AVX512,7249,3,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*5628*/ XED_DEF_INST(XED_ICLASS_VPEXTRQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRQ_GPR64u64_XMMu64_IMM8_AVX512,7252,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5629*/ XED_DEF_INST(XED_ICLASS_VPEXTRQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRQ_MEMu64_XMMu64_IMM8_AVX512,7255,3,0,0,141,XED_EXCEPTION_AVX512_E9NF),
/*5630*/ XED_DEF_INST(XED_ICLASS_VPEXTRW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRW_GPR32u16_XMMu16_IMM8_AVX512,7258,3,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5631*/ XED_DEF_INST(XED_ICLASS_VPEXTRW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPEXTRW_MEMu16_XMMu16_IMM8_AVX512,7261,3,0,0,180,XED_EXCEPTION_AVX512_E9NF),
/*5632*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_XMMi64_MASKmskw_XMMf64_AVX512,6282,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5633*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_XMMi64_MASKmskw_MEMf64_AVX512,6285,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5634*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_YMMi64_MASKmskw_YMMf64_AVX512,6288,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5635*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_YMMi64_MASKmskw_MEMf64_AVX512,6291,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5636*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_ZMMi64_MASKmskw_ZMMf64_AVX512,6294,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5637*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_ZMMi64_MASKmskw_ZMMf64_AVX512,6297,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5638*/ XED_DEF_INST(XED_ICLASS_VCVTPD2QQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTPD2QQ_ZMMi64_MASKmskw_MEMf64_AVX512,6300,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5639*/ XED_DEF_INST(XED_ICLASS_VRCP14PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PD_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,134,XED_EXCEPTION_AVX512_E4),
/*5640*/ XED_DEF_INST(XED_ICLASS_VRCP14PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PD_ZMMf64_MASKmskw_MEMf64_AVX512,6062,3,0,0,135,XED_EXCEPTION_AVX512_E4),
/*5641*/ XED_DEF_INST(XED_ICLASS_VRCP14PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PD_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,134,XED_EXCEPTION_AVX512_E4),
/*5642*/ XED_DEF_INST(XED_ICLASS_VRCP14PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PD_XMMf64_MASKmskw_MEMf64_AVX512,6135,3,0,0,135,XED_EXCEPTION_AVX512_E4),
/*5643*/ XED_DEF_INST(XED_ICLASS_VRCP14PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PD_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,134,XED_EXCEPTION_AVX512_E4),
/*5644*/ XED_DEF_INST(XED_ICLASS_VRCP14PD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PD_YMMf64_MASKmskw_MEMf64_AVX512,6138,3,0,0,135,XED_EXCEPTION_AVX512_E4),
/*5645*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5646*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5214,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5647*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5648*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5649*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5650*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5651*/ XED_DEF_INST(XED_ICLASS_VADDPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5652*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5653*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5654*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5655*/ XED_DEF_INST(XED_ICLASS_VRCP14PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PS_ZMMf32_MASKmskw_ZMMf32_AVX512,5008,3,0,0,134,XED_EXCEPTION_AVX512_E4),
/*5656*/ XED_DEF_INST(XED_ICLASS_VRCP14PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PS_ZMMf32_MASKmskw_MEMf32_AVX512,6093,3,0,0,135,XED_EXCEPTION_AVX512_E4),
/*5657*/ XED_DEF_INST(XED_ICLASS_VRCP14PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,134,XED_EXCEPTION_AVX512_E4),
/*5658*/ XED_DEF_INST(XED_ICLASS_VRCP14PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PS_XMMf32_MASKmskw_MEMf32_AVX512,6096,3,0,0,135,XED_EXCEPTION_AVX512_E4),
/*5659*/ XED_DEF_INST(XED_ICLASS_VRCP14PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PS_YMMf32_MASKmskw_YMMf32_AVX512,5020,3,0,0,134,XED_EXCEPTION_AVX512_E4),
/*5660*/ XED_DEF_INST(XED_ICLASS_VRCP14PS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP14PS_YMMf32_MASKmskw_MEMf32_AVX512,6099,3,0,0,135,XED_EXCEPTION_AVX512_E4),
/*5661*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5662*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5663*/ XED_DEF_INST(XED_ICLASS_VFNMSUB132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB132SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5664*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5111,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5665*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,5276,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5666*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,5115,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5667*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4287,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5668*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5127,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5669*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,5139,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5670*/ XED_DEF_INST(XED_ICLASS_VADDPS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VADDPS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,5143,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5671*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_ZMMu64_MASKmskw_ZMMu64_XMMu64_AVX512,6039,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5672*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,6043,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5673*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512,4565,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5674*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_ZMMu64_MASKmskw_MEMu64_IMM8_AVX512,4569,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5675*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5676*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,6047,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5677*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512,4573,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5678*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_XMMu64_MASKmskw_MEMu64_IMM8_AVX512,4577,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5679*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_YMMu64_MASKmskw_YMMu64_XMMu64_AVX512,6051,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5680*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,6055,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5681*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512,4581,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5682*/ XED_DEF_INST(XED_ICLASS_VPSRAQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRAQ_YMMu64_MASKmskw_MEMu64_IMM8_AVX512,4585,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5683*/ XED_DEF_INST(XED_ICLASS_VRCP28SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512ER,4157,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5684*/ XED_DEF_INST(XED_ICLASS_VRCP28SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512ER,5593,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5685*/ XED_DEF_INST(XED_ICLASS_VRCP28SD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512ER,4381,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5686*/ XED_DEF_INST(XED_ICLASS_VPTESTMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_XMMu16_XMMu16_AVX512,4203,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5687*/ XED_DEF_INST(XED_ICLASS_VPTESTMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_XMMu16_MEMu16_AVX512,4207,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5688*/ XED_DEF_INST(XED_ICLASS_VPTESTMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_YMMu16_YMMu16_AVX512,4211,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5689*/ XED_DEF_INST(XED_ICLASS_VPTESTMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_YMMu16_MEMu16_AVX512,4215,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5690*/ XED_DEF_INST(XED_ICLASS_VPTESTMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_AVX512,4219,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5691*/ XED_DEF_INST(XED_ICLASS_VPTESTMW,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_ZMMu16_MEMu16_AVX512,4223,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5692*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5693*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5694*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5695*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5696*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5697*/ XED_DEF_INST(XED_ICLASS_VPMULLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5698*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5699*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5700*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5701*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5702*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5703*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5704*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5705*/ XED_DEF_INST(XED_ICLASS_VUCOMISS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUCOMISS_XMMf32_XMMf32_AVX512,5779,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5706*/ XED_DEF_INST(XED_ICLASS_VUCOMISS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUCOMISS_XMMf32_XMMf32_AVX512,5782,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5707*/ XED_DEF_INST(XED_ICLASS_VUCOMISS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUCOMISS_XMMf32_MEMf32_AVX512,5785,3,97,0,161,XED_EXCEPTION_AVX512_E3NF),
/*5708*/ XED_DEF_INST(XED_ICLASS_VPTESTNMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_AVX512,5252,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5709*/ XED_DEF_INST(XED_ICLASS_VPTESTNMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_ZMMu32_MEMu32_AVX512,5256,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5710*/ XED_DEF_INST(XED_ICLASS_VPTESTNMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_XMMu32_XMMu32_AVX512,5260,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5711*/ XED_DEF_INST(XED_ICLASS_VPTESTNMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_XMMu32_MEMu32_AVX512,5264,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5712*/ XED_DEF_INST(XED_ICLASS_VPTESTNMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_YMMu32_YMMu32_AVX512,5268,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5713*/ XED_DEF_INST(XED_ICLASS_VPTESTNMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_YMMu32_MEMu32_AVX512,5272,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5714*/ XED_DEF_INST(XED_ICLASS_VPTESTNMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_XMMu8_XMMu8_AVX512,5280,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5715*/ XED_DEF_INST(XED_ICLASS_VPTESTNMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_XMMu8_MEMu8_AVX512,5284,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5716*/ XED_DEF_INST(XED_ICLASS_VPTESTNMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_YMMu8_YMMu8_AVX512,5288,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5717*/ XED_DEF_INST(XED_ICLASS_VPTESTNMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_YMMu8_MEMu8_AVX512,5292,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5718*/ XED_DEF_INST(XED_ICLASS_VPTESTNMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_AVX512,5296,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5719*/ XED_DEF_INST(XED_ICLASS_VPTESTNMB,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_ZMMu8_MEMu8_AVX512,5300,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5720*/ XED_DEF_INST(XED_ICLASS_VPSHLDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4541,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5721*/ XED_DEF_INST(XED_ICLASS_VPSHLDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4545,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5722*/ XED_DEF_INST(XED_ICLASS_VPSHLDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4549,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5723*/ XED_DEF_INST(XED_ICLASS_VPSHLDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4553,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5724*/ XED_DEF_INST(XED_ICLASS_VPSHLDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4557,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5725*/ XED_DEF_INST(XED_ICLASS_VPSHLDVW,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4561,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5726*/ XED_DEF_INST(XED_ICLASS_VPMULLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5727*/ XED_DEF_INST(XED_ICLASS_VPMULLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5728*/ XED_DEF_INST(XED_ICLASS_VPMULLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5729*/ XED_DEF_INST(XED_ICLASS_VPMULLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5730*/ XED_DEF_INST(XED_ICLASS_VPMULLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5731*/ XED_DEF_INST(XED_ICLASS_VPMULLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5732*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5733*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5734*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5735*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5736*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5737*/ XED_DEF_INST(XED_ICLASS_VPMULLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMULLW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5738*/ XED_DEF_INST(XED_ICLASS_VRCP28SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512ER,4287,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5739*/ XED_DEF_INST(XED_ICLASS_VRCP28SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512ER,5206,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5740*/ XED_DEF_INST(XED_ICLASS_VRCP28SS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VRCP28SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512ER,4325,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5741*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF64X2_XMMf64_MASKmskw_YMMf64_IMM8_AVX512,7264,4,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5742*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF64X2_MEMf64_MASKmskw_YMMf64_IMM8_AVX512,7268,4,0,0,144,XED_EXCEPTION_AVX512_E6NF),
/*5743*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF64X2_XMMf64_MASKmskw_ZMMf64_IMM8_AVX512,7272,4,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5744*/ XED_DEF_INST(XED_ICLASS_VEXTRACTF64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VEXTRACTF64X2_MEMf64_MASKmskw_ZMMf64_IMM8_AVX512,7276,4,0,0,144,XED_EXCEPTION_AVX512_E6NF),
/*5745*/ XED_DEF_INST(XED_ICLASS_VPSHLDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4493,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5746*/ XED_DEF_INST(XED_ICLASS_VPSHLDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4497,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5747*/ XED_DEF_INST(XED_ICLASS_VPSHLDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4501,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5748*/ XED_DEF_INST(XED_ICLASS_VPSHLDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4505,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5749*/ XED_DEF_INST(XED_ICLASS_VPSHLDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4509,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5750*/ XED_DEF_INST(XED_ICLASS_VPSHLDVD,XED_CATEGORY_VBMI2,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSHLDVD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4513,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5751*/ XED_DEF_INST(XED_ICLASS_VUCOMISD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUCOMISD_XMMf64_XMMf64_AVX512,5770,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5752*/ XED_DEF_INST(XED_ICLASS_VUCOMISD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUCOMISD_XMMf64_XMMf64_AVX512,5773,3,97,0,41,XED_EXCEPTION_AVX512_E3NF),
/*5753*/ XED_DEF_INST(XED_ICLASS_VUCOMISD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VUCOMISD_XMMf64_MEMf64_AVX512,5776,3,97,0,161,XED_EXCEPTION_AVX512_E3NF),
/*5754*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4385,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5755*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,4389,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5756*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,4393,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5757*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5758*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,4401,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5759*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,4405,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5760*/ XED_DEF_INST(XED_ICLASS_VFNMSUB231PD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB231PD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,4409,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5761*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPD_MEMf64_MASKmskw_ZMMf64_AVX512,6777,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5762*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPD_ZMMf64_MASKmskw_ZMMf64_AVX512,6774,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5763*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPD_MEMf64_MASKmskw_XMMf64_AVX512,6783,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5764*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPD_XMMf64_MASKmskw_XMMf64_AVX512,6780,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5765*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPD_MEMf64_MASKmskw_YMMf64_AVX512,6789,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5766*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPD,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPD_YMMf64_MASKmskw_YMMf64_AVX512,6786,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5767*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLWD_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5768*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLWD_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5769*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLWD_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5770*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLWD_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5771*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLWD_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5772*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLWD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLWD_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5773*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5774*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5775*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5776*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPS,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPS_MEMf32_MASKmskw_ZMMf32_AVX512,5536,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5777*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPS,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPS_ZMMf32_MASKmskw_ZMMf32_AVX512,5533,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5778*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPS,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPS_MEMf32_MASKmskw_XMMf32_AVX512,5542,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5779*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPS,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPS_XMMf32_MASKmskw_XMMf32_AVX512,5539,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5780*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPS,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPS_MEMf32_MASKmskw_YMMf32_AVX512,5548,3,0,0,145,XED_EXCEPTION_AVX512_E4),
/*5781*/ XED_DEF_INST(XED_ICLASS_VCOMPRESSPS,XED_CATEGORY_COMPRESS,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCOMPRESSPS_YMMf32_MASKmskw_YMMf32_AVX512,5545,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5782*/ XED_DEF_INST(XED_ICLASS_VINSERTI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI64X2_YMMu64_MASKmskw_YMMu64_XMMu64_IMM8_AVX512,7280,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5783*/ XED_DEF_INST(XED_ICLASS_VINSERTI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI64X2_YMMu64_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,7285,5,0,0,144,XED_EXCEPTION_AVX512_E6NF),
/*5784*/ XED_DEF_INST(XED_ICLASS_VINSERTI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI64X2_ZMMu64_MASKmskw_ZMMu64_XMMu64_IMM8_AVX512,7290,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5785*/ XED_DEF_INST(XED_ICLASS_VINSERTI64X2,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI64X2_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,7295,5,0,0,144,XED_EXCEPTION_AVX512_E6NF),
/*5786*/ XED_DEF_INST(XED_ICLASS_VINSERTI64X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI64X4_ZMMu64_MASKmskw_ZMMu64_YMMu64_IMM8_AVX512,7300,5,0,0,131,XED_EXCEPTION_AVX512_E6NF),
/*5787*/ XED_DEF_INST(XED_ICLASS_VINSERTI64X4,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VINSERTI64X4_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,7305,5,0,0,147,XED_EXCEPTION_AVX512_E6NF),
/*5788*/ XED_DEF_INST(XED_ICLASS_VALIGNQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGNQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512,4271,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5789*/ XED_DEF_INST(XED_ICLASS_VALIGNQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGNQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_IMM8_AVX512,4276,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5790*/ XED_DEF_INST(XED_ICLASS_VALIGNQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGNQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512,4251,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5791*/ XED_DEF_INST(XED_ICLASS_VALIGNQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGNQ_XMMu64_MASKmskw_XMMu64_MEMu64_IMM8_AVX512,4256,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5792*/ XED_DEF_INST(XED_ICLASS_VALIGNQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGNQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512,4261,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5793*/ XED_DEF_INST(XED_ICLASS_VALIGNQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGNQ_YMMu64_MASKmskw_YMMu64_MEMu64_IMM8_AVX512,4266,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5794*/ XED_DEF_INST(XED_ICLASS_VREDUCESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4661,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5795*/ XED_DEF_INST(XED_ICLASS_VREDUCESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,4666,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5796*/ XED_DEF_INST(XED_ICLASS_VREDUCESD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCESD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,4671,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5797*/ XED_DEF_INST(XED_ICLASS_VALIGND,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGND_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512,4185,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5798*/ XED_DEF_INST(XED_ICLASS_VALIGND,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGND_ZMMu32_MASKmskw_ZMMu32_MEMu32_IMM8_AVX512,4190,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5799*/ XED_DEF_INST(XED_ICLASS_VALIGND,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGND_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512,4165,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5800*/ XED_DEF_INST(XED_ICLASS_VALIGND,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGND_XMMu32_MASKmskw_XMMu32_MEMu32_IMM8_AVX512,4170,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5801*/ XED_DEF_INST(XED_ICLASS_VALIGND,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGND_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512,4175,5,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5802*/ XED_DEF_INST(XED_ICLASS_VALIGND,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VALIGND_YMMu32_MASKmskw_YMMu32_MEMu32_IMM8_AVX512,4180,5,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5803*/ XED_DEF_INST(XED_ICLASS_VREDUCESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4727,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5804*/ XED_DEF_INST(XED_ICLASS_VREDUCESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,4732,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5805*/ XED_DEF_INST(XED_ICLASS_VREDUCESS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VREDUCESS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,4737,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5806*/ XED_DEF_INST(XED_ICLASS_VPERMI2W,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2W_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4541,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5807*/ XED_DEF_INST(XED_ICLASS_VPERMI2W,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2W_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4545,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5808*/ XED_DEF_INST(XED_ICLASS_VPERMI2W,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2W_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4549,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5809*/ XED_DEF_INST(XED_ICLASS_VPERMI2W,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2W_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4553,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5810*/ XED_DEF_INST(XED_ICLASS_VPERMI2W,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2W_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4557,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5811*/ XED_DEF_INST(XED_ICLASS_VPERMI2W,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2W_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4561,4,0,0,146,XED_EXCEPTION_AVX512_E4NF),
/*5812*/ XED_DEF_INST(XED_ICLASS_VPINSRB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRB_XMMu8_XMMu8_GPR32u8_IMM8_AVX512,7310,4,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5813*/ XED_DEF_INST(XED_ICLASS_VPINSRB,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRB_XMMu8_XMMu8_MEMu8_IMM8_AVX512,7314,4,0,0,181,XED_EXCEPTION_AVX512_E9NF),
/*5814*/ XED_DEF_INST(XED_ICLASS_VFMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5815*/ XED_DEF_INST(XED_ICLASS_VFMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5816*/ XED_DEF_INST(XED_ICLASS_VFMADD213SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD213SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5817*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSDW_XMMu16_MASKmskw_XMMu32_XMMu32_AVX512,7318,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5818*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSDW_XMMu16_MASKmskw_XMMu32_MEMu32_AVX512,7322,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5819*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSDW_YMMu16_MASKmskw_YMMu32_YMMu32_AVX512,7326,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5820*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSDW_YMMu16_MASKmskw_YMMu32_MEMu32_AVX512,7330,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5821*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSDW_ZMMu16_MASKmskw_ZMMu32_ZMMu32_AVX512,7334,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5822*/ XED_DEF_INST(XED_ICLASS_VPACKUSDW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPACKUSDW_ZMMu16_MASKmskw_ZMMu32_MEMu32_AVX512,7338,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5823*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5824*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5825*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5826*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5827*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5828*/ XED_DEF_INST(XED_ICLASS_VPMAXUD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5829*/ XED_DEF_INST(XED_ICLASS_VPERMI2Q,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2Q_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4605,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5830*/ XED_DEF_INST(XED_ICLASS_VPERMI2Q,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2Q_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4609,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5831*/ XED_DEF_INST(XED_ICLASS_VPERMI2Q,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2Q_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4589,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5832*/ XED_DEF_INST(XED_ICLASS_VPERMI2Q,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2Q_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4593,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5833*/ XED_DEF_INST(XED_ICLASS_VPERMI2Q,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2Q_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4597,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5834*/ XED_DEF_INST(XED_ICLASS_VPERMI2Q,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2Q_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4601,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5835*/ XED_DEF_INST(XED_ICLASS_VGATHERPF1DPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF1DPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,170,XED_EXCEPTION_AVX512_E12NP),
/*5836*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_XMMu16_MASKmskw_XMMu16_AVX512,7215,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5837*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_XMMu16_MASKmskw_MEMu16_AVX512,7212,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5838*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_XMMu16_MASKmskw_XMMu16_AVX512,4827,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5839*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_MEMu16_MASKmskw_XMMu16_AVX512,4824,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5840*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_YMMu16_MASKmskw_YMMu16_AVX512,7221,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5841*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_YMMu16_MASKmskw_MEMu16_AVX512,7218,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5842*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_YMMu16_MASKmskw_YMMu16_AVX512,4833,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5843*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_MEMu16_MASKmskw_YMMu16_AVX512,4830,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5844*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_ZMMu16_MASKmskw_ZMMu16_AVX512,7227,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5845*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_ZMMu16_MASKmskw_MEMu16_AVX512,7224,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5846*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_ZMMu16_MASKmskw_ZMMu16_AVX512,4839,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5847*/ XED_DEF_INST(XED_ICLASS_VMOVDQU16,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU16_MEMu16_MASKmskw_ZMMu16_AVX512,4836,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5848*/ XED_DEF_INST(XED_ICLASS_VSCATTERPF0DPS,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERPF0DPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,177,XED_EXCEPTION_AVX512_E12NP),
/*5849*/ XED_DEF_INST(XED_ICLASS_VGATHERPF1DPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF1DPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,170,XED_EXCEPTION_AVX512_E12NP),
/*5850*/ XED_DEF_INST(XED_ICLASS_VPMAXUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5851*/ XED_DEF_INST(XED_ICLASS_VPMAXUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5852*/ XED_DEF_INST(XED_ICLASS_VPMAXUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5853*/ XED_DEF_INST(XED_ICLASS_VPMAXUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5854*/ XED_DEF_INST(XED_ICLASS_VPMAXUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5855*/ XED_DEF_INST(XED_ICLASS_VPMAXUQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5856*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBD_ZMMi32_MASKmskw_XMMi8_AVX512,5728,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*5857*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBD_ZMMi32_MASKmskw_MEMi8_AVX512,5731,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*5858*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBD_XMMi32_MASKmskw_XMMi8_AVX512,5734,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*5859*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBD_XMMi32_MASKmskw_MEMi8_AVX512,5737,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*5860*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBD_YMMi32_MASKmskw_XMMi8_AVX512,5740,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*5861*/ XED_DEF_INST(XED_ICLASS_VPMOVSXBD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVSXBD_YMMi32_MASKmskw_MEMi8_AVX512,5743,3,0,0,143,XED_EXCEPTION_AVX512_E5),
/*5862*/ XED_DEF_INST(XED_ICLASS_VPERMI2D,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2D_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4509,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5863*/ XED_DEF_INST(XED_ICLASS_VPERMI2D,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2D_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4513,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5864*/ XED_DEF_INST(XED_ICLASS_VPERMI2D,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2D_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4493,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5865*/ XED_DEF_INST(XED_ICLASS_VPERMI2D,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2D_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4497,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5866*/ XED_DEF_INST(XED_ICLASS_VPERMI2D,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2D_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4501,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5867*/ XED_DEF_INST(XED_ICLASS_VPERMI2D,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPERMI2D_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4505,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5868*/ XED_DEF_INST(XED_ICLASS_VPINSRW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRW_XMMu16_XMMu16_GPR32u16_IMM8_AVX512,7342,4,0,0,0,XED_EXCEPTION_AVX512_E9NF),
/*5869*/ XED_DEF_INST(XED_ICLASS_VPINSRW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPINSRW_XMMu16_XMMu16_MEMu16_IMM8_AVX512,7346,4,0,0,182,XED_EXCEPTION_AVX512_E9NF),
/*5870*/ XED_DEF_INST(XED_ICLASS_VFMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5871*/ XED_DEF_INST(XED_ICLASS_VFMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5872*/ XED_DEF_INST(XED_ICLASS_VFMADD213SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFMADD213SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5873*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5874*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5875*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512,4235,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5876*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,4239,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5877*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512,4243,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5878*/ XED_DEF_INST(XED_ICLASS_VPMAXUW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMAXUW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,4247,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5879*/ XED_DEF_INST(XED_ICLASS_VSCATTERPF0DPD,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERPF0DPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,177,XED_EXCEPTION_AVX512_E12NP),
/*5880*/ XED_DEF_INST(XED_ICLASS_VPOPCNTW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTW_XMMu16_MASKmskw_XMMu16_AVX512,7215,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5881*/ XED_DEF_INST(XED_ICLASS_VPOPCNTW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTW_XMMu16_MASKmskw_MEMu16_AVX512,7212,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5882*/ XED_DEF_INST(XED_ICLASS_VPOPCNTW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTW_YMMu16_MASKmskw_YMMu16_AVX512,7221,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5883*/ XED_DEF_INST(XED_ICLASS_VPOPCNTW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTW_YMMu16_MASKmskw_MEMu16_AVX512,7218,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5884*/ XED_DEF_INST(XED_ICLASS_VPOPCNTW,XED_CATEGORY_AVX512_BITALG,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTW_ZMMu16_MASKmskw_ZMMu16_AVX512,7227,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5885*/ XED_DEF_INST(XED_ICLASS_VPOPCNTW,XED_CATEGORY_AVX512_BITALG,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPOPCNTW_ZMMu16_MASKmskw_MEMu16_AVX512,7224,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5886*/ XED_DEF_INST(XED_ICLASS_VGATHERPF1QPD,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF1QPD_MEMf64_MASKmskw_AVX512PF_VL512,6224,2,0,0,174,XED_EXCEPTION_AVX512_E12NP),
/*5887*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5888*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5214,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5889*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5890*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5891*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5892*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5893*/ XED_DEF_INST(XED_ICLASS_VDIVPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VDIVPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5894*/ XED_DEF_INST(XED_ICLASS_VGATHERPF1QPS,XED_CATEGORY_GATHER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VGATHERPF1QPS_MEMf32_MASKmskw_AVX512PF_VL512,6237,2,0,0,174,XED_EXCEPTION_AVX512_E12NP),
/*5895*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512,4227,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5896*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_XMMu16_MASKmskw_XMMu16_MEMu16_AVX512,4231,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5897*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512,5888,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5898*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_XMMu16_MASKmskw_MEMu16_IMM8_AVX512,5892,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5899*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_YMMu16_MASKmskw_YMMu16_XMMu16_AVX512,5896,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5900*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_YMMu16_MASKmskw_YMMu16_MEMu16_AVX512,5900,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5901*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512,5904,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5902*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_YMMu16_MASKmskw_MEMu16_IMM8_AVX512,5908,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5903*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_ZMMu16_MASKmskw_ZMMu16_XMMu16_AVX512,5912,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5904*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_ZMMu16_MASKmskw_ZMMu16_MEMu16_AVX512,5916,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5905*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512,5920,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5906*/ XED_DEF_INST(XED_ICLASS_VPSRLW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLW_ZMMu16_MASKmskw_MEMu16_IMM8_AVX512,5924,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5907*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_ZMMu64_MASKmskw_ZMMu64_XMMu64_AVX512,6039,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5908*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,6043,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5909*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512,4565,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5910*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_ZMMu64_MASKmskw_MEMu64_IMM8_AVX512,4569,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5911*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5912*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,6047,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5913*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512,4573,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5914*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_XMMu64_MASKmskw_MEMu64_IMM8_AVX512,4577,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5915*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_YMMu64_MASKmskw_YMMu64_XMMu64_AVX512,6051,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5916*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,6055,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5917*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512,4581,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5918*/ XED_DEF_INST(XED_ICLASS_VPSRLQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLQ_YMMu64_MASKmskw_MEMu64_IMM8_AVX512,4585,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5919*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_ZMMf64_MASKmskw_ZMMf64_AVX512,5449,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*5920*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_ZMMf64_MASKmskw_MEMf64_AVX512,5452,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*5921*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_ZMMf64_MASKmskw_ZMMf64_AVX512,6774,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*5922*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_MEMf64_MASKmskw_ZMMf64_AVX512,6777,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*5923*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_XMMf64_MASKmskw_XMMf64_AVX512,5455,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*5924*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_XMMf64_MASKmskw_MEMf64_AVX512,6182,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*5925*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_XMMf64_MASKmskw_XMMf64_AVX512,6780,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*5926*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_MEMf64_MASKmskw_XMMf64_AVX512,6783,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*5927*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_YMMf64_MASKmskw_YMMf64_AVX512,5458,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*5928*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_YMMf64_MASKmskw_MEMf64_AVX512,5461,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*5929*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_YMMf64_MASKmskw_YMMf64_AVX512,6786,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*5930*/ XED_DEF_INST(XED_ICLASS_VMOVAPD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVAPD_MEMf64_MASKmskw_YMMf64_AVX512,6789,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*5931*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_XMMu8_MASKmskw_XMMu8_AVX512,5991,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5932*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_XMMu8_MASKmskw_MEMu8_AVX512,7350,3,0,0,183,XED_EXCEPTION_AVX512_E6),
/*5933*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_XMMu8_MASKmskw_GPR32u8_AVX512,7353,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5934*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_YMMu8_MASKmskw_XMMu8_AVX512,7356,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5935*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_YMMu8_MASKmskw_MEMu8_AVX512,7359,3,0,0,183,XED_EXCEPTION_AVX512_E6),
/*5936*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_YMMu8_MASKmskw_GPR32u8_AVX512,7362,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5937*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_ZMMu8_MASKmskw_XMMu8_AVX512,7365,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5938*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_ZMMu8_MASKmskw_MEMu8_AVX512,7368,3,0,0,183,XED_EXCEPTION_AVX512_E6),
/*5939*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTB,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTB_ZMMu8_MASKmskw_GPR32u8_AVX512,7371,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*5940*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLQDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5941*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLQDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5942*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLQDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5943*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLQDQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5944*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLQDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5945*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLQDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLQDQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*5946*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4397,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5947*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,5174,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5948*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SD,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD132SD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5178,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5949*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_ZMMu32_MASKmskw_ZMMu32_XMMu32_AVX512,5788,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5950*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,5792,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5951*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512,5796,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5952*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_ZMMu32_MASKmskw_MEMu32_IMM8_AVX512,5800,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5953*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5954*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,5804,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5955*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512,5808,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5956*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_XMMu32_MASKmskw_MEMu32_IMM8_AVX512,5812,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5957*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_YMMu32_MASKmskw_YMMu32_XMMu32_AVX512,5816,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*5958*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,5820,4,0,0,162,XED_EXCEPTION_AVX512_E4NF),
/*5959*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512,5824,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5960*/ XED_DEF_INST(XED_ICLASS_VPSRLD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPSRLD_YMMu32_MASKmskw_MEMu32_IMM8_AVX512,5828,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*5961*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWD_ZMMi32_MASKmskw_YMMi16_AVX512,7374,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*5962*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWD_ZMMi32_MASKmskw_MEMi16_AVX512,7377,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*5963*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWD_XMMi32_MASKmskw_XMMi16_AVX512,7380,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*5964*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWD_XMMi32_MASKmskw_MEMi16_AVX512,7383,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*5965*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWD_YMMi32_MASKmskw_XMMi16_AVX512,7386,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*5966*/ XED_DEF_INST(XED_ICLASS_VPMOVZXWD,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPMOVZXWD_YMMi32_MASKmskw_MEMi16_AVX512,7389,3,0,0,149,XED_EXCEPTION_AVX512_E5),
/*5967*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5968*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,5095,4,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5969*/ XED_DEF_INST(XED_ICLASS_VFNMADD132SS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMADD132SS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,5099,4,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5970*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_ZMMu64_MASKmskw_ZMMu64_AVX512,5048,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5971*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_ZMMu64_MASKmskw_MEMu64_AVX512,7203,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5972*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_ZMMu64_MASKmskw_ZMMu64_AVX512,6396,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5973*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_MEMu64_MASKmskw_ZMMu64_AVX512,6393,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5974*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5975*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_XMMu64_MASKmskw_MEMu64_AVX512,7206,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5976*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_XMMu64_MASKmskw_XMMu64_AVX512,6402,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5977*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_MEMu64_MASKmskw_XMMu64_AVX512,6399,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5978*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_YMMu64_MASKmskw_YMMu64_AVX512,5060,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5979*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_YMMu64_MASKmskw_MEMu64_AVX512,7209,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5980*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_YMMu64_MASKmskw_YMMu64_AVX512,6408,3,0,0,131,XED_EXCEPTION_AVX512_E4),
/*5981*/ XED_DEF_INST(XED_ICLASS_VMOVDQU64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQU64_MEMu64_MASKmskw_YMMu64_AVX512,6405,3,0,0,133,XED_EXCEPTION_AVX512_E4),
/*5982*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMSS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,6889,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5983*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMSS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512,7392,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*5984*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMSS,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMSS_XMMf32_MASKmskw_XMMf32_MEMf32_IMM8_AVX512,7397,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*5985*/ XED_DEF_INST(XED_ICLASS_VSCATTERQPD,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERQPD_MEMf64_MASKmskw_ZMMf64_AVX512_VL512,7402,3,0,0,178,XED_EXCEPTION_AVX512_E12),
/*5986*/ XED_DEF_INST(XED_ICLASS_VSCATTERQPD,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERQPD_MEMf64_MASKmskw_XMMf64_AVX512_VL128,7405,3,0,0,178,XED_EXCEPTION_AVX512_E12),
/*5987*/ XED_DEF_INST(XED_ICLASS_VSCATTERQPD,XED_CATEGORY_SCATTER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VSCATTERQPD_MEMf64_MASKmskw_YMMf64_AVX512_VL256,7408,3,0,0,178,XED_EXCEPTION_AVX512_E12),
/*5988*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_ZMMf32_MASKmskw_ZMMu32_AVX512,7411,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5989*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_ZMMf32_MASKmskw_ZMMu32_AVX512,7414,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5990*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_ZMMf32_MASKmskw_MEMu32_AVX512,7417,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5991*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_XMMf32_MASKmskw_XMMu32_AVX512,7420,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5992*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_XMMf32_MASKmskw_MEMu32_AVX512,7423,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5993*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_YMMf32_MASKmskw_YMMu32_AVX512,7426,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*5994*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PS_YMMf32_MASKmskw_MEMu32_AVX512,7429,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*5995*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSD_ZMMf64_MASKmskw_MEMf64_AVX512,7432,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5996*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSD_ZMMf64_MASKmskw_XMMf64_AVX512,7435,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5997*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSD_YMMf64_MASKmskw_MEMf64_AVX512,7438,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*5998*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSD,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSD_YMMf64_MASKmskw_XMMf64_AVX512,7441,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*5999*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_ZMMu64_MASKmskw_ZMMu64_AVX512,5048,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*6000*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_ZMMu64_MASKmskw_MEMu64_AVX512,7203,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*6001*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_ZMMu64_MASKmskw_ZMMu64_AVX512,6396,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*6002*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_MEMu64_MASKmskw_ZMMu64_AVX512,6393,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*6003*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_XMMu64_MASKmskw_XMMu64_AVX512,5054,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*6004*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_XMMu64_MASKmskw_MEMu64_AVX512,7206,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*6005*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_XMMu64_MASKmskw_XMMu64_AVX512,6402,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*6006*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_MEMu64_MASKmskw_XMMu64_AVX512,6399,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*6007*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_YMMu64_MASKmskw_YMMu64_AVX512,5060,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*6008*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_YMMu64_MASKmskw_MEMu64_AVX512,7209,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*6009*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_YMMu64_MASKmskw_YMMu64_AVX512,6408,3,0,0,131,XED_EXCEPTION_AVX512_E1),
/*6010*/ XED_DEF_INST(XED_ICLASS_VMOVDQA64,XED_CATEGORY_DATAXFER,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMOVDQA64_MEMu64_MASKmskw_YMMu64_AVX512,6405,3,0,0,160,XED_EXCEPTION_AVX512_E1),
/*6011*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQW_MASKmskw_MASKmskw_XMMu16_XMMu16_AVX512,4203,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6012*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQW_MASKmskw_MASKmskw_XMMu16_MEMu16_AVX512,4207,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*6013*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQW_MASKmskw_MASKmskw_YMMu16_YMMu16_AVX512,4211,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6014*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQW_MASKmskw_MASKmskw_YMMu16_MEMu16_AVX512,4215,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*6015*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_AVX512,4219,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6016*/ XED_DEF_INST(XED_ICLASS_VPCMPEQW,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPCMPEQW_MASKmskw_MASKmskw_ZMMu16_MEMu16_AVX512,4223,4,0,0,133,XED_EXCEPTION_AVX512_E4),
/*6017*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMSD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,6927,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*6018*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMSD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512,7444,5,0,0,127,XED_EXCEPTION_AVX512_E3),
/*6019*/ XED_DEF_INST(XED_ICLASS_VFIXUPIMMSD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFIXUPIMMSD_XMMf64_MASKmskw_XMMf64_MEMf64_IMM8_AVX512,7449,5,0,0,128,XED_EXCEPTION_AVX512_E3),
/*6020*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_XMMu64_MASKmskw_XMMf32_AVX512,4676,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*6021*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_XMMu64_MASKmskw_MEMf32_AVX512,4679,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*6022*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_YMMu64_MASKmskw_XMMf32_AVX512,4682,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*6023*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_YMMu64_MASKmskw_MEMf32_AVX512,4685,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*6024*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_ZMMu64_MASKmskw_YMMf32_AVX512,4688,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*6025*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_ZMMu64_MASKmskw_YMMf32_AVX512,7454,3,0,0,134,XED_EXCEPTION_AVX512_E3),
/*6026*/ XED_DEF_INST(XED_ICLASS_VCVTTPS2UQQ,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTTPS2UQQ_ZMMu64_MASKmskw_MEMf32_AVX512,4694,3,0,0,139,XED_EXCEPTION_AVX512_E3),
/*6027*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSS_ZMMf32_MASKmskw_MEMf32_AVX512,7457,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*6028*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSS_ZMMf32_MASKmskw_XMMf32_AVX512,6953,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*6029*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSS_XMMf32_MASKmskw_MEMf32_AVX512,4281,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*6030*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSS_XMMf32_MASKmskw_XMMf32_AVX512,5014,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*6031*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSS_YMMf32_MASKmskw_MEMf32_AVX512,7460,3,0,0,175,XED_EXCEPTION_AVX512_E6),
/*6032*/ XED_DEF_INST(XED_ICLASS_VBROADCASTSS,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VBROADCASTSS_YMMf32_MASKmskw_XMMf32_AVX512,6947,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*6033*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PD_ZMMf64_MASKmskw_YMMu32_AVX512,7463,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*6034*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PD_ZMMf64_MASKmskw_MEMu32_AVX512,7466,3,0,0,184,XED_EXCEPTION_AVX512_E5),
/*6035*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PD_XMMf64_MASKmskw_XMMu32_AVX512,7469,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*6036*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PD_XMMf64_MASKmskw_MEMu32_AVX512,7472,3,0,0,184,XED_EXCEPTION_AVX512_E5),
/*6037*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PD_YMMf64_MASKmskw_XMMu32_AVX512,7475,3,0,0,131,XED_EXCEPTION_AVX512_E5),
/*6038*/ XED_DEF_INST(XED_ICLASS_VCVTUDQ2PD,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTUDQ2PD_YMMf64_MASKmskw_MEMu32_AVX512,7478,3,0,0,184,XED_EXCEPTION_AVX512_E5),
/*6039*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,5210,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6040*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512,6549,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6041*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_ZMMf64_MASKmskw_ZMMf64_MEMf64_AVX512,5218,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6042*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512,4157,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6043*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_XMMf64_MASKmskw_XMMf64_MEMf64_AVX512,5222,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6044*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512,5226,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6045*/ XED_DEF_INST(XED_ICLASS_VMINPD,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VMINPD_YMMf64_MASKmskw_YMMf64_MEMf64_AVX512,5230,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6046*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_ZMMf32_MASKmskw_ZMMi32_AVX512,7481,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6047*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_ZMMf32_MASKmskw_ZMMi32_AVX512,7484,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6048*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_ZMMf32_MASKmskw_MEMi32_AVX512,7487,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6049*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_XMMf32_MASKmskw_XMMi32_AVX512,7490,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6050*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_XMMf32_MASKmskw_MEMi32_AVX512,7493,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6051*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_YMMf32_MASKmskw_YMMi32_AVX512,7496,3,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6052*/ XED_DEF_INST(XED_ICLASS_VCVTDQ2PS,XED_CATEGORY_CONVERT,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VCVTDQ2PS_YMMf32_MASKmskw_MEMi32_AVX512,7499,3,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6053*/ XED_DEF_INST(XED_ICLASS_VPRORVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512,4437,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6054*/ XED_DEF_INST(XED_ICLASS_VPRORVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORVQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512,4441,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*6055*/ XED_DEF_INST(XED_ICLASS_VPRORVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512,4445,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6056*/ XED_DEF_INST(XED_ICLASS_VPRORVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORVQ_XMMu64_MASKmskw_XMMu64_MEMu64_AVX512,4449,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*6057*/ XED_DEF_INST(XED_ICLASS_VPRORVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512,4453,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6058*/ XED_DEF_INST(XED_ICLASS_VPRORVQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPRORVQ_YMMu64_MASKmskw_YMMu64_MEMu64_AVX512,4457,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*6059*/ XED_DEF_INST(XED_ICLASS_VPTESTMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_AVX512,5252,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6060*/ XED_DEF_INST(XED_ICLASS_VPTESTMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_ZMMu32_MEMu32_AVX512,5256,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*6061*/ XED_DEF_INST(XED_ICLASS_VPTESTMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_XMMu32_XMMu32_AVX512,5260,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6062*/ XED_DEF_INST(XED_ICLASS_VPTESTMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_XMMu32_MEMu32_AVX512,5264,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*6063*/ XED_DEF_INST(XED_ICLASS_VPTESTMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_YMMu32_YMMu32_AVX512,5268,4,0,0,131,XED_EXCEPTION_AVX512_E4),
/*6064*/ XED_DEF_INST(XED_ICLASS_VPTESTMD,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_YMMu32_MEMu32_AVX512,5272,4,0,0,132,XED_EXCEPTION_AVX512_E4),
/*6065*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4353,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6066*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512,4357,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6067*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512,4361,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6068*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512,4365,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6069*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512,4369,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6070*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512,4373,4,0,0,134,XED_EXCEPTION_AVX512_E2),
/*6071*/ XED_DEF_INST(XED_ICLASS_VFNMSUB213PS,XED_CATEGORY_VFMA,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VFNMSUB213PS_YMMf32_MASKmskw_YMMf32_MEMf32_AVX512,4377,4,0,0,135,XED_EXCEPTION_AVX512_E2),
/*6072*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_XMMu16_MASKmskw_XMMu16_AVX512,7215,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*6073*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_XMMu16_MASKmskw_MEMu16_AVX512,7502,3,0,0,185,XED_EXCEPTION_AVX512_E6),
/*6074*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_XMMu16_MASKmskw_GPR32u16_AVX512,7505,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*6075*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_YMMu16_MASKmskw_XMMu16_AVX512,7508,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*6076*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_YMMu16_MASKmskw_MEMu16_AVX512,7511,3,0,0,185,XED_EXCEPTION_AVX512_E6),
/*6077*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_YMMu16_MASKmskw_GPR32u16_AVX512,7514,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*6078*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_ZMMu16_MASKmskw_XMMu16_AVX512,7517,3,0,0,131,XED_EXCEPTION_AVX512_E6),
/*6079*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_ZMMu16_MASKmskw_MEMu16_AVX512,7520,3,0,0,185,XED_EXCEPTION_AVX512_E6),
/*6080*/ XED_DEF_INST(XED_ICLASS_VPBROADCASTW,XED_CATEGORY_BROADCAST,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPBROADCASTW_ZMMu16_MASKmskw_GPR32u16_AVX512,7523,3,0,0,131,XED_EXCEPTION_AVX512_E7NM),
/*6081*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLDQ_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512,4329,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*6082*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLDQ_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512,4333,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*6083*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLDQ_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512,4337,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*6084*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLDQ_XMMu32_MASKmskw_XMMu32_MEMu32_AVX512,4341,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*6085*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLDQ_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512,4345,4,0,0,131,XED_EXCEPTION_AVX512_E4NF),
/*6086*/ XED_DEF_INST(XED_ICLASS_VPUNPCKLDQ,XED_CATEGORY_AVX512,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPUNPCKLDQ_YMMu32_MASKmskw_YMMu32_MEMu32_AVX512,4349,4,0,0,148,XED_EXCEPTION_AVX512_E4NF),
/*6087*/ XED_DEF_INST(XED_ICLASS_VPTESTMQ,XED_CATEGORY_LOGICAL,XED_EXTENSION_AVX512EVEX,3,XED_IFORM_VPTESTMQ_MASKmskw_MASKmskw_ZMMu64_Z