/// @file xed-enc-groups.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-encode-private.h"
#include "xed-enc-operand-lu.h"
#include "xed-operand-accessors.h"
#include "xed-encoder.h"
xed_bool_t xed_encode_group_0(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][2] = {
   /*      SLDT*/    {   1,   0,},
   /*      SMSW*/    {2831,2830,},
   /*       STR*/    {2088,2087,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_1(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][2] = {
   /* VMOVMSKPD*/    {   2,   3,},
   /* VMOVMSKPS*/    {  10,  11,},
   /* VPMOVMSKB*/    {5584,5585,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_2(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[10][2] = {
   /*  CVTDQ2PS*/    {4850,4849,},
   /* GF2P8MULB*/    {1516,1517,},
   /*  SHA1MSG1*/    {6725,6726,},
   /*  SHA1MSG2*/    {6720,6721,},
   /* SHA1NEXTE*/    {1820,1821,},
   /*SHA256MSG1*/    {1051,1052,},
   /*SHA256MSG2*/    {1049,1050,},
   /*SHA256RNDS2*/    {1720,1721,},
   /*  UNPCKHPS*/    {   5,   4,},
   /*  UNPCKLPS*/    { 436, 435,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_3(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[27][2] = {
   /*    AESDEC*/    {6436,6437,},
   /*AESDECLAST*/    {6010,6011,},
   /*    AESENC*/    {5549,5550,},
   /*AESENCLAST*/    { 695, 696,},
   /*    AESIMC*/    {2476,2477,},
   /*  BLENDVPD*/    {1626,1625,},
   /*  BLENDVPS*/    {1588,1587,},
   /*  PACKUSDW*/    { 712, 711,},
   /*  PBLENDVB*/    {6797,6796,},
   /*   PCMPEQQ*/    {3782,3781,},
   /*   PCMPGTQ*/    {5291,5290,},
   /*PHMINPOSUW*/    {5363,5362,},
   /*    PMAXSB*/    {3983,3982,},
   /*    PMAXSD*/    {3985,3984,},
   /*    PMAXUD*/    {3121,3120,},
   /*    PMAXUW*/    {3119,3118,},
   /*    PMINSB*/    {1093,1092,},
   /*    PMINSD*/    {1096,1095,},
   /*    PMINUD*/    {4915,4914,},
   /*    PMINUW*/    {4909,4908,},
   /*    PMULDQ*/    {4270,4269,},
   /*    PMULLD*/    { 573, 572,},
   /*     PTEST*/    {5817,5816,},
   /*PUNPCKHQDQ*/    { 841, 840,},
   /*PUNPCKLQDQ*/    {3806,3805,},
   /*  UNPCKHPD*/    {   7,   6,},
   /*  UNPCKLPD*/    { 444, 443,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_4(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[18][2] = {
   /*     CMOVB*/    {1428,1427,},
   /*    CMOVBE*/    {1790,1789,},
   /*     CMOVL*/    {1424,1423,},
   /*    CMOVLE*/    {1983,1982,},
   /*    CMOVNB*/    {2970,2969,},
   /*   CMOVNBE*/    {5509,5508,},
   /*    CMOVNL*/    {2966,2965,},
   /*   CMOVNLE*/    {3635,3634,},
   /*    CMOVNO*/    {2964,2963,},
   /*    CMOVNP*/    {2962,2961,},
   /*    CMOVNS*/    {2960,2959,},
   /*    CMOVNZ*/    {2953,2952,},
   /*     CMOVO*/    {1426,1425,},
   /*     CMOVP*/    {1419,1418,},
   /*     CMOVS*/    {1421,1420,},
   /*     CMOVZ*/    {1417,1416,},
   /*    POPCNT*/    {   9,   8,},
   /*     TZCNT*/    {1960,1959,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_5(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[21][10] = {
   /* VPACKSSWB*/    {5156,5158,5155,5157,5159,5161,5163,5160,5162,5164,},
   /* VPACKUSWB*/    {4011,4013,4010,4012,4014,4016,4018,4015,4017,4019,},
   /*   VPADDSW*/    { 720, 722, 719, 721, 723, 725, 727, 724, 726, 728,},
   /*  VPADDUSW*/    {4039,4041,4038,4040,4042,4044,4046,4043,4045,4047,},
   /*    VPADDW*/    {1078,1080,1077,1079,1081,1083,1085,1082,1084,1086,},
   /*    VPAVGW*/    {5390,5392,5389,5391,5393,5395,5397,5394,5396,5398,},
   /*VPMADDUBSW*/    { 902, 904, 901, 903, 905, 907, 909, 906, 908, 910,},
   /*  VPMADDWD*/    {6087,6089,6086,6088,6090,6092,6094,6091,6093,6095,},
   /*   VPMAXSW*/    {5442,5444,5441,5443,5445,5447,5449,5446,5448,5450,},
   /*   VPMAXUW*/    {6280,6282,6279,6281,6283,6285,6287,6284,6286,6288,},
   /*   VPMINSW*/    {2056,2058,2055,2057,2059,2061,2063,2060,2062,2064,},
   /*   VPMINUW*/    {4934,4936,4933,4935,4937,4939,4941,4938,4940,4942,},
   /* VPMULHRSW*/    {3485,3487,3484,3486,3488,3490,3492,3489,3491,3493,},
   /*  VPMULHUW*/    {  13,  15,  12,  14,  16,  18,  20,  17,  19,  21,},
   /*   VPMULHW*/    {4068,4070,4067,4069,4071,4073,4075,4072,4074,4076,},
   /*   VPMULLW*/    {6213,6215,6212,6214,6216,6218,6220,6217,6219,6221,},
   /*   VPSUBSW*/    {3105,3107,3104,3106,3108,3110,3112,3109,3111,3113,},
   /*  VPSUBUSW*/    {6041,6043,6040,6042,6044,6046,6048,6045,6047,6049,},
   /*    VPSUBW*/    {3045,3047,3044,3046,3048,3050,3052,3049,3051,3053,},
   /*VPUNPCKHWD*/    {3354,3356,3353,3355,3357,3359,3361,3358,3360,3362,},
   /*VPUNPCKLWD*/    {1251,1253,1250,1252,1254,1256,1258,1255,1257,1259,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_6(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][3] = {
   /*VPBROADCASTMB2Q*/    {1434,1435,1433,},
   /*VPBROADCASTMW2D*/    {4741,4742,4740,},
   /*  VPMOVM2B*/    {  22,  23,  24,},
   /*  VPMOVM2D*/    {5655,5656,5657,},
   /*  VPMOVM2Q*/    {6782,6783,6784,},
   /*  VPMOVM2W*/    {5619,5620,5621,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_7(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[18][6] = {
   /* VBLENDMPS*/    {6693,6695,6691,6694,6696,6692,},
   /*    VPANDD*/    {2347,2349,2345,2348,2350,2346,},
   /*   VPANDND*/    {2483,2485,2481,2484,2486,2482,},
   /* VPBLENDMD*/    {3600,3602,3598,3601,3603,3599,},
   /*  VPDPBUSD*/    {1631,1633,1635,1632,1634,1636,},
   /* VPDPBUSDS*/    {2751,2753,2755,2752,2754,2756,},
   /*  VPDPWSSD*/    {5590,5592,5594,5591,5593,5595,},
   /* VPDPWSSDS*/    { 733, 735, 737, 734, 736, 738,},
   /*  VPERMI2D*/    {4575,4577,4573,4576,4578,4574,},
   /* VPERMI2PS*/    {2353,2355,2351,2354,2356,2352,},
   /*  VPERMT2D*/    {3193,3195,3191,3194,3196,3192,},
   /* VPERMT2PS*/    {6458,6460,6456,6459,6461,6457,},
   /*     VPORD*/    {4853,4855,4851,4854,4856,4852,},
   /*   VPROLVD*/    {  27,  29,  25,  28,  30,  26,},
   /*   VPRORVD*/    {6417,6419,6415,6418,6420,6416,},
   /*  VPSHLDVD*/    {4482,4484,4486,4483,4485,4487,},
   /*  VPSHRDVD*/    {1758,1760,1762,1759,1761,1763,},
   /*    VPXORD*/    {5080,5082,5078,5081,5083,5079,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_8(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[14][1] = {
   /*    FCMOVB*/    {4596,},
   /*   FCMOVBE*/    {2010,},
   /*    FCMOVE*/    {4595,},
   /*   FCMOVNB*/    { 205,},
   /*  FCMOVNBE*/    {6029,},
   /*   FCMOVNE*/    { 274,},
   /*   FCMOVNU*/    { 172,},
   /*    FCMOVU*/    {4590,},
   /*     FCOMI*/    { 405,},
   /*    FCOMIP*/    { 178,},
   /*     FUCOM*/    {  31,},
   /*    FUCOMI*/    {6514,},
   /*   FUCOMIP*/    {5102,},
   /*    FUCOMP*/    {6507,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 xed_encode_ntluf_X87(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_9(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*  RDFSBASE*/    {2829,},
   /*  RDGSBASE*/    {6778,},
   /*  WRFSBASE*/    {6140,},
   /*  WRGSBASE*/    {  32,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPRy_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_10(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[23][6] = {
   /* VBLENDMPD*/    {6708,6710,6706,6709,6711,6707,},
   /*   VPANDNQ*/    { 439, 441, 437, 440, 442, 438,},
   /*    VPANDQ*/    {2359,2361,2357,2360,2362,2358,},
   /* VPBLENDMQ*/    {3580,3582,3578,3581,3583,3579,},
   /* VPERMI2PD*/    {6640,6642,6638,6641,6643,6639,},
   /*  VPERMI2Q*/    { 492, 494, 490, 493, 495, 491,},
   /* VPERMT2PD*/    {6446,6448,6444,6447,6449,6445,},
   /*  VPERMT2Q*/    {3213,3215,3211,3214,3216,3212,},
   /*VPMADD52HUQ*/    {2073,2075,2077,2074,2076,2078,},
   /*VPMADD52LUQ*/    {3075,3077,3079,3076,3078,3080,},
   /*   VPMAXSQ*/    {5461,5463,5459,5462,5464,5460,},
   /*   VPMAXUQ*/    {6273,6275,6271,6274,6276,6272,},
   /*   VPMINSQ*/    {2067,2069,2065,2068,2070,2066,},
   /*   VPMINUQ*/    {4929,4931,4927,4930,4932,4928,},
   /*   VPMULLQ*/    {6206,6208,6210,6207,6209,6211,},
   /*VPMULTISHIFTQB*/    {1510,1512,1514,1511,1513,1515,},
   /*     VPORQ*/    {5111,5113,5109,5112,5114,5110,},
   /*   VPROLVQ*/    {  35,  37,  33,  36,  38,  34,},
   /*   VPRORVQ*/    {6378,6380,6376,6379,6381,6377,},
   /*  VPSHLDVQ*/    {4451,4453,4455,4452,4454,4456,},
   /*  VPSHRDVQ*/    {1774,1776,1778,1775,1777,1779,},
   /*   VPSRAVQ*/    {4101,4103,4099,4102,4104,4100,},
   /*    VPXORQ*/    {4900,4902,4898,4901,4903,4899,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_11(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /* V4FMADDPS*/    {5490,},
   /*V4FNMADDPS*/    {  39,},
   /* VP4DPWSSD*/    {6109,},
   /*VP4DPWSSDS*/    {1866,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE1_4X_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_12(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    VRCPSS*/    {  41,  40,},
   /*  VRSQRTSS*/    {3731,3730,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_13(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[16][4] = {
   /*        JB*/    {4179,4180,4178,4181,},
   /*       JBE*/    {6142,6143,6141,6144,},
   /*        JL*/    {4170,4171,4169,4172,},
   /*       JLE*/    {1183,1184,1182,1185,},
   /*       JNB*/    {  61,  62,  60,  63,},
   /*      JNBE*/    {2012,2013,2011,2014,},
   /*       JNL*/    {  79,  80,  78,  81,},
   /*      JNLE*/    {5217,5218,5216,5219,},
   /*       JNO*/    {  75,  76,  74,  77,},
   /*       JNP*/    {  53,  54,  52,  55,},
   /*       JNS*/    {  43,  44,  42,  45,},
   /*       JNZ*/    {  57,  58,  56,  59,},
   /*        JO*/    {5244,5246,5243,5245,},
   /*        JP*/    {4162,4163,4161,4164,},
   /*        JS*/    {4166,4167,4165,4168,},
   /*        JZ*/    {4158,4159,4157,4160,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRANCH_HINT_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRANCH_HINT_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISPz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FORCE64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRANCH_HINT_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FORCE64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRANCH_HINT_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP32_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_14(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][6] = {
   /*   VALIGNQ*/    {1277,1279,1275,1278,1280,1276,},
   /*   VPSHLDQ*/    {1733,1735,1737,1734,1736,1738,},
   /*   VPSHRDQ*/    {1008,1010,1012,1009,1011,1013,},
   /*VPTERNLOGQ*/    {  48,  50,  46,  49,  51,  47,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_15(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][2] = {
   /*  PMOVSXBW*/    {4419,4418,},
   /*  PMOVSXDQ*/    {5498,5497,},
   /*  PMOVSXWD*/    {  65,  64,},
   /*  PMOVZXBW*/    {1781,1780,},
   /*  PMOVZXDQ*/    {2822,2821,},
   /*  PMOVZXWD*/    {5143,5142,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_16(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][6] = {
   /*   VALIGND*/    {1296,1298,1294,1297,1299,1295,},
   /*   VPSHLDD*/    {3430,3432,3434,3431,3433,3435,},
   /*   VPSHRDD*/    {1021,1023,1025,1022,1024,1026,},
   /*VPTERNLOGD*/    {  68,  70,  66,  69,  71,  67,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_17(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*  SYSENTER*/    {2714,2715,},
   /*   SYSEXIT*/    {  72,  73,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_18(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[106][1] = {
   /*      CLAC*/    {1556,},
   /*       CLC*/    {2562,},
   /*       CLD*/    {2548,},
   /*      CLGI*/    { 846,},
   /*       CLI*/    {2547,},
   /*      CLTS*/    {3099,},
   /*       CMC*/    {1786,},
   /*     CPUID*/    {2845,},
   /*      EMMS*/    {4450,},
   /*     ENCLS*/    {2607,},
   /*     ENCLU*/    {2609,},
   /*     ENCLV*/    {2612,},
   /*   ENDBR32*/    {6455,},
   /*   ENDBR64*/    {5136,},
   /*     F2XM1*/    {1055,},
   /*      FABS*/    {1306,},
   /*      FCHS*/    {5211,},
   /*    FCOMPP*/    {5487,},
   /*      FCOS*/    {5716,},
   /*   FDECSTP*/    {3167,},
   /*FDISI8087_NOP*/    {2865,},
   /*     FEMMS*/    {2911,},
   /*FENI8087_NOP*/    {5492,},
   /*   FINCSTP*/    {1138,},
   /*      FLD1*/    {3331,},
   /*    FLDL2E*/    {5259,},
   /*    FLDL2T*/    {5252,},
   /*    FLDLG2*/    {1530,},
   /*    FLDLN2*/    {1628,},
   /*     FLDPI*/    { 925,},
   /*      FLDZ*/    {3188,},
   /*    FNCLEX*/    {1307,},
   /*    FNINIT*/    {5797,},
   /*      FNOP*/    {5783,},
   /*    FPATAN*/    {4402,},
   /*     FPREM*/    {1076,},
   /*    FPREM1*/    { 760,},
   /*     FPTAN*/    {3843,},
   /*   FRNDINT*/    {5577,},
   /*    FSCALE*/    {2462,},
   /*FSETPM287_NOP*/    {2257,},
   /*      FSIN*/    {6290,},
   /*   FSINCOS*/    {6734,},
   /*     FSQRT*/    {3553,},
   /*      FTST*/    {6110,},
   /*   FUCOMPP*/    {4944,},
   /*     FWAIT*/    { 990,},
   /*      FXAM*/    { 638,},
   /*   FXTRACT*/    {5479,},
   /*     FYL2X*/    {5292,},
   /*   FYL2XP1*/    {5576,},
   /*    GETSEC*/    {2595,},
   /*       HLT*/    { 171,},
   /*      INSB*/    {2881,},
   /*      INT1*/    {1409,},
   /*      INT3*/    {2692,},
   /*      INVD*/    {1474,},
   /*      LAHF*/    {3515,},
   /*    LFENCE*/    {1319,},
   /*    MFENCE*/    {3184,},
   /*     MWAIT*/    {6804,},
   /*    MWAITX*/    {3736,},
   /*      NOP2*/    {  89,},
   /*      NOP3*/    {  88,},
   /*      NOP4*/    {  93,},
   /*      NOP5*/    { 761,},
   /*      NOP6*/    {  95,},
   /*      NOP7*/    {  94,},
   /*      NOP8*/    {  83,},
   /*      NOP9*/    {  82,},
   /*     PAUSE*/    {6779,},
   /*   PCONFIG*/    {3375,},
   /*     RDMSR*/    {4215,},
   /*    RDPKRU*/    {4545,},
   /*     RDPMC*/    {1627,},
   /*     RDTSC*/    {4435,},
   /*    RDTSCP*/    {1526,},
   /*REPE_SCASB*/    {1773,},
   /*REPNE_SCASB*/    {2761,},
   /*       RSM*/    {3694,},
   /*      SAHF*/    {2994,},
   /*SAVEPREVSSP*/    {2001,},
   /*     SCASB*/    {5937,},
   /*  SETSSBSY*/    {4449,},
   /*    SFENCE*/    {5930,},
   /*      STAC*/    {5589,},
   /*       STC*/    {2084,},
   /*       STD*/    {2083,},
   /*      STGI*/    {2836,},
   /*       STI*/    {2085,},
   /*     STOSB*/    {4558,},
   /*       UD2*/    {6450,},
   /*    VMCALL*/    {6057,},
   /*    VMFUNC*/    {2835,},
   /*  VMLAUNCH*/    {5588,},
   /*   VMMCALL*/    {4475,},
   /*  VMRESUME*/    {1722,},
   /*    VMSAVE*/    {5372,},
   /*    VMXOFF*/    {4494,},
   /*  WBNOINVD*/    {5881,},
   /*     WRMSR*/    {5220,},
   /*    WRPKRU*/    {5555,},
   /*      XEND*/    { 564,},
   /*    XGETBV*/    { 757,},
   /*    XSETBV*/    {5467,},
   /*     XTEST*/    {3332,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_19(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[59][4] = {
   /*     PABSB*/    {6387,6386,6389,6388,},
   /*     PABSD*/    {6362,6361,6364,6363,},
   /*     PABSW*/    {6402,6401,6404,6403,},
   /*  PACKSSDW*/    {3815,3814,3817,3816,},
   /*  PACKSSWB*/    {1663,1662,1665,1664,},
   /*  PACKUSWB*/    { 182, 181, 184, 183,},
   /*     PADDB*/    {4004,4003,4006,4005,},
   /*     PADDD*/    {4000,3999,4002,4001,},
   /*     PADDQ*/    {4027,4026,4029,4028,},
   /*    PADDSB*/    {2935,2934,2937,2936,},
   /*    PADDSW*/    {3685,3684,3687,3686,},
   /*   PADDUSB*/    {2130,2129,2132,2131,},
   /*   PADDUSW*/    {2106,2105,2108,2107,},
   /*     PADDW*/    {4021,4020,4023,4022,},
   /*      PAND*/    {3963,3962,3965,3964,},
   /*     PANDN*/    {1042,1041,1044,1043,},
   /*     PAVGB*/    {5020,5019,5022,5021,},
   /*     PAVGW*/    {4985,4984,4987,4986,},
   /*   PCMPEQB*/    {3796,3795,3798,3797,},
   /*   PCMPEQD*/    {3127,3126,3129,3128,},
   /*   PCMPEQW*/    {3789,3788,3791,3790,},
   /*   PCMPGTB*/    {5310,5309,5312,5311,},
   /*   PCMPGTD*/    {5324,5323,5326,5325,},
   /*   PCMPGTW*/    {5300,5299,5302,5301,},
   /*    PHADDD*/    {5841,5840,5843,5842,},
   /*   PHADDSW*/    {3650,3649,3652,3651,},
   /*    PHADDW*/    {5848,5847,5850,5849,},
   /*    PHSUBD*/    {  85,  84,  87,  86,},
   /*   PHSUBSW*/    {5580,5579,5582,5581,},
   /*    PHSUBW*/    { 102, 101, 104, 103,},
   /* PMADDUBSW*/    {2121,2120,2123,2122,},
   /*   PMADDWD*/    {6463,6462,6465,6464,},
   /*    PMAXSW*/    {3979,3978,3981,3980,},
   /*    PMAXUB*/    {3123,3122,3125,3124,},
   /*    PMINSW*/    {1141,1140,1143,1142,},
   /*    PMINUB*/    {4924,4923,4926,4925,},
   /*  PMULHRSW*/    {  98,  97, 100,  99,},
   /*   PMULHUW*/    {3083,3082,3085,3084,},
   /*    PMULHW*/    {1117,1116,1119,1118,},
   /*    PMULLW*/    { 567, 566, 569, 568,},
   /*   PMULUDQ*/    {1453,1452,1455,1454,},
   /*       POR*/    { 879, 878, 881, 880,},
   /*    PSADBW*/    {6617,6616,6619,6618,},
   /*    PSHUFB*/    {6129,6128,6131,6130,},
   /*    PSIGNB*/    {5456,5455,5458,5457,},
   /*    PSIGND*/    {5452,5451,5454,5453,},
   /*    PSIGNW*/    {5412,5411,5414,5413,},
   /*     PSUBB*/    {2454,2453,2456,2455,},
   /*     PSUBD*/    {2450,2449,2452,2451,},
   /*     PSUBQ*/    {2468,2467,2470,2469,},
   /*    PSUBSB*/    {6699,6698,6701,6700,},
   /*    PSUBSW*/    {6680,6679,6682,6681,},
   /*   PSUBUSB*/    {3394,3393,3396,3395,},
   /*   PSUBUSW*/    {3409,3408,3411,3410,},
   /*     PSUBW*/    {2464,2463,2466,2465,},
   /* PUNPCKHBW*/    {4745,4744,4747,4746,},
   /* PUNPCKHDQ*/    {1752,1751,1754,1753,},
   /* PUNPCKHWD*/    {1499,1498,1501,1500,},
   /*      PXOR*/    {2393,2392,2395,2394,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_20(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][3] = {
   /*     BNDCL*/    {  92,  91,  90,},
   /*     BNDCN*/    { 770, 769, 768,},
   /*     BNDCU*/    { 825, 824, 823,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_AGEN) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_agen(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_21(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*    LLWPCB*/    {4082,},
   /*    SLWPCB*/    {  96,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_GPRy_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_22(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[17][2] = {
   /*   VAESIMC*/    {2277,2278,},
   /*  VPHADDBD*/    { 551, 550,},
   /*  VPHADDBQ*/    { 534, 533,},
   /*  VPHADDBW*/    { 548, 547,},
   /*  VPHADDDQ*/    {1457,1456,},
   /* VPHADDUBD*/    {3667,3666,},
   /* VPHADDUBQ*/    {3669,3668,},
   /* VPHADDUBW*/    {3671,3670,},
   /* VPHADDUDQ*/    { 972, 971,},
   /* VPHADDUWD*/    {3210,3209,},
   /* VPHADDUWQ*/    {3190,3189,},
   /*  VPHADDWD*/    {1237,1236,},
   /*  VPHADDWQ*/    {1226,1225,},
   /*VPHMINPOSUW*/    {3346,3345,},
   /*  VPHSUBBW*/    {5494,5493,},
   /*  VPHSUBDQ*/    {6336,6335,},
   /*  VPHSUBWD*/    { 106, 105,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_23(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*       LSL*/    { 108, 107,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRz_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_24(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][1] = {
   /*       LFS*/    {3604,},
   /*       LGS*/    {4154,},
   /*       LSS*/    { 109,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_P2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_25(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*VINSERTF64X2*/    { 110, 112, 111, 113,},
   /*VINSERTI64X2*/    {4519,4521,4520,4522,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE2_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE2_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_26(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*     MOVSD*/    { 114,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG1_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_27(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[15][10] = {
   /*VGF2P8MULB*/    {3174,3176,3175,3177,3168,3170,3172,3169,3171,3173,},
   /*    VPADDB*/    {1104,1106,1103,1105,1107,1109,1111,1108,1110,1112,},
   /*   VPADDSB*/    { 746, 748, 745, 747, 749, 751, 753, 750, 752, 754,},
   /*  VPADDUSB*/    {4504,4506,4503,4505,4507,4509,4511,4508,4510,4512,},
   /*    VPAVGB*/    {5402,5404,5401,5403,5405,5407,5409,5406,5408,5410,},
   /*   VPMAXSB*/    {5426,5428,5425,5427,5429,5431,5433,5430,5432,5434,},
   /*   VPMAXUB*/    {6242,6244,6241,6243,6245,6247,6249,6246,6248,6250,},
   /*   VPMINSB*/    {2042,2044,2041,2043,2045,2047,2049,2046,2048,2050,},
   /*   VPMINUB*/    {4946,4948,4945,4947,4949,4951,4953,4950,4952,4954,},
   /*   VPSHUFB*/    {1309,1311,1308,1310,1312,1314,1316,1313,1315,1317,},
   /*    VPSUBB*/    {3007,3009,3006,3008,3010,3012,3014,3011,3013,3015,},
   /*   VPSUBSB*/    {3088,3090,3087,3089,3091,3093,3095,3092,3094,3096,},
   /*  VPSUBUSB*/    {6019,6021,6018,6020,6022,6024,6026,6023,6025,6027,},
   /*VPUNPCKHBW*/    {5007,5009,5006,5008,5010,5012,5014,5011,5013,5015,},
   /*VPUNPCKLBW*/    { 116, 118, 115, 117, 119, 121, 123, 120, 122, 124,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_28(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*VINSERTF64X4*/    { 125, 126,},
   /*VINSERTI64X4*/    {4523,4524,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_29(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][6] = {
   /*   VPMOVDB*/    {3519,3521,3517,3520,3522,3518,},
   /*  VPMOVSDB*/    { 129, 131, 127, 130, 132, 128,},
   /* VPMOVUSDB*/    {4063,4065,4061,4064,4066,4062,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_QUARTERMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_QUARTERMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_QUARTERMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_30(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][6] = {
   /*      BLSI*/    {6792,6793,6795,6790,6791,6794,},
   /*    BLSMSK*/    { 135, 136, 138, 133, 134, 137,},
   /*      BLSR*/    {6800,6801,6803,6798,6799,6802,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_VGPR64_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_VGPR64_N(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_31(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*      ADCX*/    {5115,5117,5116,5118,},
   /*      ADOX*/    { 139, 141, 140, 142,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_32(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][6] = {
   /*   VPMOVDW*/    {3529,3531,3527,3530,3532,3528,},
   /*  VPMOVSDW*/    { 145, 147, 143, 146, 148, 144,},
   /* VPMOVUSDW*/    {4730,4732,4728,4731,4733,4729,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_33(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*  CVTPI2PD*/    { 150, 149,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_34(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][20] = {
   /* VPERMILPS*/    { 152, 154, 156, 151, 158, 153, 155, 157, 165, 169, 161, 163, 167, 159, 166, 170, 162, 164, 168, 160,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][18]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][19]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_35(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*VGATHERQPD*/    { 174, 173, 176, 177, 175,},
   /*VPGATHERQQ*/    {4281,4280,4283,4284,4282,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_XMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_YMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_36(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*  CVTPI2PS*/    { 180, 179,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_37(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][10] = {
   /*   VAESDEC*/    { 185, 193, 186, 194, 187, 189, 191, 188, 190, 192,},
   /*VAESDECLAST*/    {3717,3725,3718,3726,3719,3721,3723,3720,3722,3724,},
   /*   VAESENC*/    {5664,5672,5665,5673,5666,5668,5670,5667,5669,5671,},
   /*VAESENCLAST*/    { 830, 838, 831, 839, 832, 834, 836, 833, 835, 837,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_128_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_128_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_128_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_38(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*      POPF*/    {3384,},
   /*     PUSHF*/    { 195,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_39(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][4] = {
   /*       DIV*/    {2886,2888,2885,2887,},
   /*      IDIV*/    {2302,2304,2301,2303,},
   /*       MUL*/    {5766,5768,5765,5767,},
   /*       NEG*/    {4905,4907,4904,4906,},
   /*       NOT*/    { 197, 199, 196, 198,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_40(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*VGATHERQPS*/    { 201, 200, 203, 204, 202,},
   /*VPGATHERQD*/    {2424,2423,2426,2427,2425,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_XMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_YMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_41(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][60] = {
   /*       NOP*/    { 231, 230, 232, 233, 261, 238, 239, 235, 236, 237, 206, 207, 208, 209, 211, 213, 215, 217, 219, 227, 234, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 272, 210, 212, 214, 216, 218, 226, 242, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 273, 240, 241,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 0) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 0) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][18]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][19]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][20]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][21]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][22]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][23]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][24]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][25]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][26]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][27]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][28]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][29]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][30]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][31]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][32]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][33]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][34]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][35]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][36]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][37]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][38]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][39]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][40]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][41]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][42]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][43]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][44]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][45]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][46]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][47]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][48]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][49]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][50]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][51]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][52]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][53]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][54]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][55]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][56]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][57]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 0) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][58]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 0) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][59]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_42(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][20] = {
   /* VPERMILPD*/    { 276, 278, 280, 275, 282, 277, 279, 281, 289, 293, 285, 287, 291, 283, 290, 294, 286, 288, 292, 284,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][18]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][19]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_43(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /*  VPCMPEQW*/    { 296, 298, 295, 297, 299, 301, 303, 300, 302, 304,},
   /*  VPCMPGTW*/    {5069,5071,5068,5070,5072,5074,5076,5073,5075,5077,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_44(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /*  VPCMPEQQ*/    { 306, 308, 305, 307, 311, 313, 309, 312, 314, 310,},
   /*  VPCMPGTQ*/    {5059,5061,5058,5060,5064,5066,5062,5065,5067,5063,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_45(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][6] = {
   /*  ADC_LOCK*/    { 319, 320, 315, 318, 316, 317,},
   /*  ADD_LOCK*/    {1231,1232,1227,1230,1228,1229,},
   /*   OR_LOCK*/    {2749,2750,2745,2748,2746,2747,},
   /*  SBB_LOCK*/    {2879,2880,2875,2878,2876,2877,},
   /*  SUB_LOCK*/    {4034,4035,4030,4033,4031,4032,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_46(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][2] = {
   /*  ADDSUBPS*/    { 322, 321,},
   /* CVTTPS2DQ*/    {2413,2412,},
   /*    HADDPS*/    {3823,3822,},
   /*    HSUBPS*/    {2134,2133,},
   /*  MOVSHDUP*/    {5587,5586,},
   /*  MOVSLDUP*/    {2709,2708,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_PS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_47(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /*  VPCMPEQD*/    { 324, 326, 323, 325, 329, 331, 327, 330, 332, 328,},
   /*  VPCMPGTD*/    {5045,5047,5044,5046,5050,5052,5048,5051,5053,5049,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_48(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /*  VPCMPEQB*/    { 334, 336, 333, 335, 337, 339, 341, 338, 340, 342,},
   /*  VPCMPGTB*/    {5035,5037,5034,5036,5038,5040,5042,5039,5041,5043,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_49(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[12][2] = {
   /*     ADDPD*/    { 867, 866,},
   /*  ADDSUBPD*/    { 344, 343,},
   /*  CVTPD2PS*/    {4875,4874,},
   /* CVTTPD2DQ*/    {6112,6111,},
   /*     DIVPD*/    {3467,3466,},
   /*    HADDPD*/    {3812,3811,},
   /*    HSUBPD*/    {2149,2148,},
   /*     MAXPD*/    {1555,1554,},
   /*     MINPD*/    {2864,2863,},
   /*     MULPD*/    {1347,1346,},
   /*    SQRTPD*/    {6056,6055,},
   /*     SUBPD*/    {6054,6053,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_PD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_50(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*VBROADCASTF64X4*/    { 710,},
   /*VBROADCASTI64X4*/    { 345,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_51(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*VBROADCASTF64X2*/    {3672,3673,},
   /*VBROADCASTI64X2*/    { 346, 347,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE2_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE2_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_52(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[14][10] = {
   /*   VANDNPD*/    {6099,6101,6098,6100,6102,6104,6106,6103,6105,6107,},
   /*    VANDPD*/    { 349, 351, 348, 350, 352, 354, 356, 353, 355, 357,},
   /*     VORPD*/    {6605,6607,6604,6606,6608,6610,6612,6609,6611,6613,},
   /*    VPADDQ*/    {1067,1069,1066,1068,1072,1074,1070,1073,1075,1071,},
   /*   VPMULDQ*/    {2403,2405,2402,2404,2408,2410,2406,2409,2411,2407,},
   /*  VPMULUDQ*/    { 458, 460, 457, 459, 463, 465, 461, 464, 466, 462,},
   /*   VPSLLVQ*/    {5173,5175,5172,5174,5178,5180,5176,5179,5181,5177,},
   /*   VPSRLVQ*/    {1897,1899,1896,1898,1902,1904,1900,1903,1905,1901,},
   /*    VPSUBQ*/    {3035,3037,3034,3036,3040,3042,3038,3041,3043,3039,},
   /*VPUNPCKHQDQ*/    { 779, 781, 778, 780, 784, 786, 782, 785, 787, 783,},
   /*VPUNPCKLQDQ*/    {6292,6294,6291,6293,6297,6299,6295,6298,6300,6296,},
   /* VUNPCKHPD*/    { 512, 514, 511, 513, 517, 519, 515, 518, 520, 516,},
   /* VUNPCKLPD*/    {3238,3240,3237,3239,3243,3245,3241,3244,3246,3242,},
   /*    VXORPD*/    { 869, 871, 868, 870, 872, 874, 876, 873, 875, 877,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_53(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     WRSSD*/    {4897,},
   /*    WRUSSD*/    { 358,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_54(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     WRSSQ*/    {4895,},
   /*    WRUSSQ*/    { 359,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_55(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][6] = {
   /*     BEXTR*/    {5475,5476,5478,5473,5474,5477,},
   /*      BZHI*/    {2144,2145,2147,2142,2143,2146,},
   /*      SARX*/    {1986,1987,1989,1984,1985,1988,},
   /*      SHLX*/    {2973,2974,2976,2971,2972,2975,},
   /*      SHRX*/    { 362, 363, 365, 360, 361, 364,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_B(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_B(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_VGPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR64_B(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_VGPR64_N(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_VGPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_VGPR64_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_56(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[20][10] = {
   /*   VANDNPS*/    {6077,6079,6076,6078,6080,6082,6084,6081,6083,6085,},
   /*    VANDPS*/    { 367, 369, 366, 368, 370, 372, 374, 371, 373, 375,},
   /*     VORPS*/    {6629,6631,6628,6630,6632,6634,6636,6633,6635,6637,},
   /* VPACKSSDW*/    {5517,5519,5516,5518,5520,5522,5524,5521,5523,5525,},
   /* VPACKUSDW*/    {6252,6254,6251,6253,6255,6257,6259,6256,6258,6260,},
   /*    VPADDD*/    {1129,1131,1128,1130,1134,1136,1132,1135,1137,1133,},
   /*   VPMAXSD*/    {5416,5418,5415,5417,5421,5423,5419,5422,5424,5420,},
   /*   VPMAXUD*/    {6262,6264,6261,6263,6267,6269,6265,6268,6270,6266,},
   /*   VPMINSD*/    {2031,2033,2030,2032,2036,2038,2034,2037,2039,2035,},
   /*   VPMINUD*/    {4956,4958,4955,4957,4961,4963,4959,4962,4964,4960,},
   /*   VPMULLD*/    {6177,6179,6176,6178,6182,6184,6180,6183,6185,6181,},
   /*   VPSLLVD*/    {5122,5124,5121,5123,5127,5129,5125,5128,5130,5126,},
   /*   VPSRAVD*/    {4125,4127,4124,4126,4130,4132,4128,4131,4133,4129,},
   /*   VPSRLVD*/    {1939,1941,1938,1940,1944,1946,1942,1945,1947,1943,},
   /*    VPSUBD*/    {3021,3023,3020,3022,3026,3028,3024,3027,3029,3025,},
   /*VPUNPCKHDQ*/    {3888,3890,3887,3889,3893,3895,3891,3894,3896,3892,},
   /*VPUNPCKLDQ*/    {2996,2998,2995,2997,3001,3003,2999,3002,3004,3000,},
   /* VUNPCKHPS*/    { 497, 499, 496, 498, 502, 504, 500, 503, 505, 501,},
   /* VUNPCKLPS*/    {3223,3225,3222,3224,3228,3230,3226,3229,3231,3227,},
   /*    VXORPS*/    { 912, 914, 911, 913, 915, 917, 919, 916, 918, 920,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_57(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][2] = {
   /*  DEC_LOCK*/    { 376, 377,},
   /*  INC_LOCK*/    {6096,6097,},
   /*  NEG_LOCK*/    {5094,5095,},
   /*  NOT_LOCK*/    { 521, 522,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_58(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*   MOVDIRI*/    { 378, 379,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_59(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*    PSLLDQ*/    { 380,},
   /*    PSRLDQ*/    {4009,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_60(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][6] = {
   /*    VPROTB*/    { 419, 421, 418, 417, 420, 416,},
   /*    VPROTD*/    { 425, 427, 424, 423, 426, 422,},
   /*    VPROTQ*/    { 384, 386, 383, 382, 385, 381,},
   /*    VPROTW*/    { 402, 404, 401, 400, 403, 399,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_61(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][12] = {
   /*       RCL*/    { 396, 398, 395, 397, 392, 388, 394, 390, 391, 387, 393, 389,},
   /*       RCR*/    {4537,4539,4536,4538,4533,4529,4535,4531,4532,4528,4534,4530,},
   /*       ROL*/    {6504,6506,6503,6505,6500,6496,6502,6498,6499,6495,6501,6497,},
   /*       ROR*/    {6561,6563,6560,6562,6557,6553,6559,6554,6556,6552,6558,6555,},
   /*       SAR*/    { 561, 563, 560, 562, 557, 553, 559, 555, 556, 552, 558, 554,},
   /*       SHR*/    {3873,3875,3872,3874,3869,3865,3871,3867,3868,3864,3870,3866,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_reg1(xes) == XED_REG_CL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_reg1(xes) == XED_REG_CL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_reg0(xes) == XED_REG_CL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_reg0(xes) == XED_REG_CL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_ONE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_ONE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ONE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ONE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_62(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /*  VPSHUFHW*/    { 407, 409, 406, 408, 410, 412, 414, 411, 413, 415,},
   /*  VPSHUFLW*/    {2281,2283,2280,2282,2284,2286,2288,2285,2287,2289,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_63(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][5] = {
   /*     FCOMP*/    { 429, 430, 431, 432, 428,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 xed_encode_ntluf_X87(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 xed_encode_ntluf_X87(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 xed_encode_ntluf_X87(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_M64REAL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM32REAL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_64(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    TPAUSE*/    {6452,6451,},
   /*    UMWAIT*/    { 434, 433,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_65(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][1] = {
   /*      CDQE*/    { 445,},
   /*       CQO*/    {4743,},
   /*     IRETQ*/    {1576,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 3) &&
		 (xed3_operand_get_mode(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_66(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[22][11] = {
   /*    VADDPS*/    {4441,4437,4439,4436,4438,4443,4445,4440,4444,4446,4442,},
   /*    VDIVPS*/    {2268,2264,2266,2263,2265,2270,2272,2267,2271,2273,2269,},
   /*VFMADD132PS*/    {2811,2807,2809,2806,2808,2813,2815,2810,2814,2816,2812,},
   /*VFMADD213PS*/    {3339,3335,3337,3334,3336,3341,3343,3338,3342,3344,3340,},
   /*VFMADD231PS*/    { 893, 889, 891, 888, 890, 895, 897, 892, 896, 898, 894,},
   /*VFMADDSUB132PS*/    {1671,1667,1669,1666,1668,1673,1675,1670,1674,1676,1672,},
   /*VFMADDSUB213PS*/    {3266,3262,3264,3261,3263,3268,3270,3265,3269,3271,3267,},
   /*VFMADDSUB231PS*/    {3402,3398,3400,3397,3399,3404,3406,3401,3405,3407,3403,},
   /*VFMSUB132PS*/    {1814,1810,1812,1809,1811,1816,1818,1813,1817,1819,1815,},
   /*VFMSUB213PS*/    { 451, 447, 449, 446, 448, 453, 455, 450, 454, 456, 452,},
   /*VFMSUB231PS*/    {5638,5634,5636,5633,5635,5640,5642,5637,5641,5643,5639,},
   /*VFMSUBADD132PS*/    {4843,4839,4841,4838,4840,4845,4847,4842,4846,4848,4844,},
   /*VFMSUBADD213PS*/    {2295,2291,2293,2290,2292,2297,2299,2294,2298,2300,2296,},
   /*VFMSUBADD231PS*/    {4868,4864,4866,4863,4865,4870,4872,4867,4871,4873,4869,},
   /*VFNMADD132PS*/    {6758,6754,6756,6753,6755,6760,6762,6757,6761,6763,6759,},
   /*VFNMADD213PS*/    {5602,5598,5600,5597,5599,5604,5606,5601,5605,5607,5603,},
   /*VFNMADD231PS*/    {3138,3134,3136,3133,3135,3140,3142,3137,3141,3143,3139,},
   /*VFNMSUB132PS*/    { 816, 812, 814, 811, 813, 818, 820, 815, 819, 821, 817,},
   /*VFNMSUB213PS*/    {6395,6391,6393,6390,6392,6397,6399,6394,6398,6400,6396,},
   /*VFNMSUB231PS*/    {6191,6187,6189,6186,6188,6193,6195,6190,6194,6196,6192,},
   /*    VMULPS*/    {3622,3618,3620,3617,3619,3624,3626,3621,3625,3627,3623,},
   /*    VSUBPS*/    {5992,5988,5990,5987,5989,5994,5996,5991,5995,5997,5993,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_67(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[22][11] = {
   /*    VADDPD*/    {4425,4421,4423,4420,4422,4427,4429,4424,4428,4430,4426,},
   /*    VDIVPD*/    {2251,2247,2249,2246,2248,2253,2255,2250,2254,2256,2252,},
   /*VFMADD132PD*/    {2800,2796,2798,2795,2797,2802,2804,2799,2803,2805,2801,},
   /*VFMADD213PD*/    {3325,3321,3323,3320,3322,3327,3329,3324,3328,3330,3326,},
   /*VFMADD231PD*/    { 860, 856, 858, 855, 857, 862, 864, 859, 863, 865, 861,},
   /*VFMADDSUB132PD*/    {1650,1646,1648,1645,1647,1652,1654,1649,1653,1655,1651,},
   /*VFMADDSUB213PD*/    {3286,3282,3284,3281,3283,3288,3290,3285,3289,3291,3287,},
   /*VFMADDSUB231PD*/    {3422,3418,3420,3417,3419,3424,3426,3421,3425,3427,3423,},
   /*VFMSUB132PD*/    {1829,1825,1827,1824,1826,1831,1833,1828,1832,1834,1830,},
   /*VFMSUB213PD*/    { 472, 468, 470, 467, 469, 474, 476, 471, 475, 477, 473,},
   /*VFMSUB231PD*/    {5613,5609,5611,5608,5610,5615,5617,5612,5616,5618,5614,},
   /*VFMSUBADD132PD*/    {3065,3061,3063,3060,3062,3067,3069,3064,3068,3070,3066,},
   /*VFMSUBADD213PD*/    {2310,2306,2308,2305,2307,2312,2314,2309,2313,2315,2311,},
   /*VFMSUBADD231PD*/    {4881,4877,4879,4876,4878,4883,4885,4880,4884,4886,4882,},
   /*VFNMADD132PD*/    {6740,6736,6738,6735,6737,6742,6744,6739,6743,6745,6741,},
   /*VFNMADD213PD*/    {5649,5645,5647,5644,5646,5651,5653,5648,5652,5654,5650,},
   /*VFNMADD231PD*/    {3161,3157,3159,3156,3158,3163,3165,3160,3164,3166,3162,},
   /*VFNMSUB132PD*/    { 797, 793, 795, 792, 794, 799, 801, 796, 800, 802, 798,},
   /*VFNMSUB213PD*/    {6428,6424,6426,6423,6425,6430,6432,6427,6431,6433,6429,},
   /*VFNMSUB231PD*/    {6227,6223,6225,6222,6224,6229,6231,6226,6230,6232,6228,},
   /*    VMULPD*/    {3943,3939,3941,3938,3940,3945,3947,3942,3946,3948,3944,},
   /*    VSUBPD*/    {5981,5977,5979,5976,5978,5983,5985,5980,5984,5986,5982,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_68(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][6] = {
   /*VPSHUFBITQMB*/    { 478, 480, 482, 479, 481, 483,},
   /*  VPTESTMB*/    {1376,1378,1380,1377,1379,1381,},
   /* VPTESTNMB*/    {4463,4465,4467,4464,4466,4468,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_69(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[7][1] = {
   /*     FADDP*/    {3554,},
   /*     FDIVP*/    {1389,},
   /*    FDIVRP*/    {3005,},
   /*     FMULP*/    {2958,},
   /*   FSTPNCE*/    {2744,},
   /*     FSUBP*/    {2086,},
   /*    FSUBRP*/    { 484,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_X87(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_reg1(xes) == XED_REG_ST0);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_70(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][4] = {
   /*    MOVDQA*/    { 486, 488, 485, 487,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_71(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*   LDMXCSR*/    { 489,},
   /*   STMXCSR*/    {1496,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_72(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*VSHUFF32X4*/    { 508, 506, 509, 507,},
   /*VSHUFI32X4*/    {2651,2649,2652,2650,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_73(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*   INCSSPQ*/    { 510,},
   /*    RDSSPQ*/    {5596,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_74(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*   VCOMISD*/    { 526, 524, 523, 525, 527,},
   /*  VUCOMISD*/    {3415,3413,3412,3414,3416,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_75(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*   VCOMISS*/    { 531, 529, 528, 530, 532,},
   /*  VUCOMISS*/    {1223,1221,1220,1222,1224,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_76(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][9] = {
   /*VCVTUSI2SS*/    { 537, 538, 542, 535, 536, 541, 539, 540, 543,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_READER_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_READER_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_READER_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_77(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][3] = {
   /*  VPMOVB2M*/    { 544, 545, 546,},
   /*  VPMOVD2M*/    {3548,3549,3550,},
   /*  VPMOVQ2M*/    {2832,2833,2834,},
   /*  VPMOVW2M*/    {5717,5718,5719,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_78(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[8][1] = {
   /*       CBW*/    {5371,},
   /*       CWD*/    { 933,},
   /*      INSW*/    {2884,},
   /*      IRET*/    {6197,},
   /*REPE_SCASW*/    {1757,},
   /*REPNE_SCASW*/    {2773,},
   /*     SCASW*/    {5920,},
   /*     STOSW*/    { 549,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_79(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*REPE_SCASQ*/    {1764,},
   /*REPNE_SCASQ*/    {2769,},
   /*     SCASQ*/    {5929,},
   /*     STOSQ*/    { 565,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 3);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_80(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][2] = {
   /*  PMOVSXBD*/    {4401,4400,},
   /*  PMOVSXWQ*/    { 571, 570,},
   /*  PMOVZXBD*/    {1785,1784,},
   /*  PMOVZXWQ*/    {5120,5119,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_81(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][6] = {
   /*VFPCLASSPS*/    { 574, 576, 578, 575, 577, 579,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_82(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[13][8] = {
   /*  VFMADDPD*/    {1503,1505,1507,1509,1502,1504,1506,1508,},
   /*  VFMADDPS*/    {1519,1521,1523,1525,1518,1520,1522,1524,},
   /*VFMADDSUBPD*/    {3499,3501,3503,3505,3498,3500,3502,3504,},
   /*VFMADDSUBPS*/    {3508,3510,3512,3514,3507,3509,3511,3513,},
   /*VFMSUBADDPD*/    {3273,3275,3277,3279,3272,3274,3276,3278,},
   /*VFMSUBADDPS*/    {3305,3307,3309,3311,3304,3306,3308,3310,},
   /*  VFMSUBPD*/    {4328,4330,4332,4334,4327,4329,4331,4333,},
   /*  VFMSUBPS*/    {4349,4351,4353,4355,4348,4350,4352,4354,},
   /* VFNMADDPD*/    { 613, 615, 617, 619, 612, 614, 616, 618,},
   /* VFNMADDPS*/    { 581, 583, 585, 587, 580, 582, 584, 586,},
   /* VFNMSUBPD*/    {5939,5941,5943,5945,5938,5940,5942,5944,},
   /* VFNMSUBPS*/    {5922,5924,5926,5928,5921,5923,5925,5927,},
   /*    VPCMOV*/    {6115,6117,6119,6121,6114,6116,6118,6120,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_83(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[17][5] = {
   /*    VADDSS*/    {5168,5166,5165,5167,5169,},
   /*    VDIVSS*/    {2723,2721,2720,2722,2724,},
   /*VFMADD132SS*/    {4118,4116,4115,4117,4119,},
   /*VFMADD213SS*/    {5134,5132,5131,5133,5135,},
   /*VFMADD231SS*/    {2460,2458,2457,2459,2461,},
   /*VFMSUB132SS*/    { 591, 589, 588, 590, 592,},
   /*VFMSUB213SS*/    {1064,1062,1061,1063,1065,},
   /*VFMSUB231SS*/    {4274,4272,4271,4273,4275,},
   /*VFNMADD132SS*/    {6309,6307,6306,6308,6310,},
   /*VFNMADD213SS*/    {5350,5348,5347,5349,5351,},
   /*VFNMADD231SS*/    {2728,2726,2725,2727,2729,},
   /*VFNMSUB132SS*/    {1213,1211,1210,1212,1214,},
   /*VFNMSUB213SS*/    {1269,1267,1266,1268,1270,},
   /*VFNMSUB231SS*/    {6647,6645,6644,6646,6648,},
   /*    VMULSS*/    {5438,5436,5435,5437,5439,},
   /*   VSQRTSS*/    {3709,3707,3706,3708,3710,},
   /*    VSUBSS*/    { 678, 676, 675, 677, 679,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_84(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][18] = {
   /*    VPSLLD*/    { 594, 597, 595, 593, 598, 596, 603, 607, 599, 605, 609, 601, 604, 608, 600, 606, 610, 602,},
   /*    VPSRAD*/    {2157,2160,2158,2156,2161,2159,2166,2170,2162,2168,2172,2164,2167,2171,2163,2169,2173,2165,},
   /*    VPSRLD*/    {4654,4657,4655,4653,4658,4656,4663,4667,4659,4665,4669,4661,4664,4668,4660,4666,4670,4662,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_85(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][1] = {
   /*     CMPSW*/    {5388,},
   /*     LODSW*/    {3658,},
   /*     OUTSW*/    {5212,},
   /*REPE_CMPSW*/    {4763,},
   /*REPNE_CMPSW*/    { 611,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_86(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][18] = {
   /*    VPSLLQ*/    { 621, 624, 622, 620, 625, 623, 630, 634, 626, 632, 636, 628, 631, 635, 627, 633, 637, 629,},
   /*    VPSRLQ*/    {4616,4619,4617,4615,4620,4618,4625,4629,4621,4627,4631,4623,4626,4630,4622,4628,4632,4624,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_87(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][1] = {
   /*     CMPSB*/    {5399,},
   /*     LODSB*/    {3659,},
   /*     OUTSB*/    {5213,},
   /*REPE_CMPSB*/    {4797,},
   /*REPNE_CMPSB*/    { 639,},
   /*      XLAT*/    {4310,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_88(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*     CMPSD*/    {5400,},
   /*     LODSD*/    {3660,},
   /*REPE_CMPSD*/    {4771,},
   /*REPNE_CMPSD*/    { 640,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_89(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][18] = {
   /*    VPSLLW*/    { 642, 645, 643, 641, 646, 644, 647, 651, 655, 649, 653, 657, 648, 652, 656, 650, 654, 658,},
   /*    VPSRAW*/    {2193,2196,2194,2192,2197,2195,2198,2202,2206,2200,2204,2208,2199,2203,2207,2201,2205,2209,},
   /*    VPSRLW*/    {4598,4601,4599,4597,4602,4600,4603,4607,4611,4605,4609,4613,4604,4608,4612,4606,4610,4614,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_90(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[18][5] = {
   /*    VADDSD*/    {5140,5138,5137,5139,5141,},
   /* VCVTSD2SS*/    {1461,1459,1458,1460,1462,},
   /*    VDIVSD*/    {2733,2731,2730,2732,2734,},
   /*VFMADD132SD*/    {4836,4834,4833,4835,4837,},
   /*VFMADD213SD*/    {4556,4554,4553,4555,4557,},
   /*VFMADD231SD*/    {2474,2472,2471,2473,2475,},
   /*VFMSUB132SD*/    { 662, 660, 659, 661, 663,},
   /*VFMSUB213SD*/    {5814,5812,5811,5813,5815,},
   /*VFMSUB231SD*/    {4255,4253,4252,4254,4256,},
   /*VFNMADD132SD*/    {6304,6302,6301,6303,6305,},
   /*VFNMADD213SD*/    {5369,5367,5366,5368,5370,},
   /*VFNMADD231SD*/    {2738,2736,2735,2737,2739,},
   /*VFNMSUB132SD*/    {1207,1205,1204,1206,1208,},
   /*VFNMSUB213SD*/    {1323,1321,1320,1322,1324,},
   /*VFNMSUB231SD*/    {6658,6656,6655,6657,6659,},
   /*    VMULSD*/    {5471,5469,5468,5470,5472,},
   /*   VSQRTSD*/    {3698,3696,3695,3697,3699,},
   /*    VSUBSD*/    { 670, 668, 667, 669, 671,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_91(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][3] = {
   /*   VEXP2PD*/    {2771,2770,2772,},
   /*  VRCP28PD*/    { 665, 664, 666,},
   /*VRSQRT28PD*/    {1114,1113,1115,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_92(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][3] = {
   /*   VEXP2PS*/    {2763,2762,2764,},
   /*  VRCP28PS*/    { 673, 672, 674,},
   /*VRSQRT28PS*/    {1088,1087,1089,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_93(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][3] = {
   /*VPSCATTERDQ*/    {6723,6724,6722,},
   /*VSCATTERDPD*/    { 681, 682, 680,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_94(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][6] = {
   /* VDBPSADBW*/    { 683, 685, 687, 684, 686, 688,},
   /*   VPSHLDW*/    {1739,1741,1743,1740,1742,1744,},
   /*   VPSHRDW*/    {1002,1004,1006,1003,1005,1007,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_95(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*  CLRSSBSY*/    { 689,},
   /*  RSTORSSP*/    {2124,},
   /*   VMPTRLD*/    {3852,},
   /*   VMPTRST*/    {4583,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_96(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*VGATHERDPS*/    { 691, 690, 693, 694, 692,},
   /*VPGATHERDD*/    {1683,1682,1685,1686,1684,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_XMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_YMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_97(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*VGATHERDPD*/    { 698, 697, 700, 701, 699,},
   /*VPGATHERDQ*/    {1690,1689,1692,1693,1691,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_XMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_VMODRM_XMM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_98(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][4] = {
   /*        BT*/    {6340,6339,6338,6337,},
   /*       BTC*/    { 716, 715, 714, 713,},
   /*       BTR*/    { 709, 708, 707, 706,},
   /*       BTS*/    { 705, 704, 703, 702,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_99(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     POPFQ*/    {3728,},
   /*    PUSHFQ*/    { 717,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 3) &&
		 (xed3_operand_get_mode(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_100(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     POPFD*/    {3716,},
   /*    PUSHFD*/    { 718,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) != 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_101(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][4] = {
   /*VMASKMOVPD*/    { 731, 729, 732, 730,},
   /*VMASKMOVPS*/    { 743, 741, 744, 742,},
   /*VPMASKMOVD*/    {4725,4723,4726,4724,},
   /*VPMASKMOVQ*/    {3032,3030,3033,3031,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_102(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     FFREE*/    { 739,},
   /*    FFREEP*/    { 740,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_X87(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_103(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[16][2] = {
   /*      SETB*/    {1913,1912,},
   /*     SETBE*/    {1688,1687,},
   /*      SETL*/    {1915,1914,},
   /*     SETLE*/    {6565,6564,},
   /*     SETNB*/    { 763, 762,},
   /*    SETNBE*/    {2629,2628,},
   /*     SETNL*/    { 759, 758,},
   /*    SETNLE*/    {1558,1557,},
   /*     SETNO*/    { 756, 755,},
   /*     SETNP*/    { 777, 776,},
   /*     SETNS*/    { 775, 774,},
   /*     SETNZ*/    {4156,4155,},
   /*      SETO*/    {1917,1916,},
   /*      SETP*/    {1937,1936,},
   /*      SETS*/    {1949,1948,},
   /*      SETZ*/    {1958,1957,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_104(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][2] = {
   /*    ANDNPD*/    {3591,3590,},
   /*     ANDPD*/    {5093,5092,},
   /*      ORPD*/    {5545,5544,},
   /*     XORPD*/    { 765, 764,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_XUQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_105(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[12][1] = {
   /*     KNOTB*/    {4138,},
   /*     KNOTD*/    {4139,},
   /*     KNOTQ*/    {4136,},
   /*     KNOTW*/    {4137,},
   /*  KORTESTB*/    { 771,},
   /*  KORTESTD*/    { 766,},
   /*  KORTESTQ*/    {4054,},
   /*  KORTESTW*/    {1388,},
   /*    KTESTB*/    {4294,},
   /*    KTESTD*/    {4293,},
   /*    KTESTQ*/    {5844,},
   /*    KTESTW*/    {4299,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_106(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*    RDRAND*/    {3086,},
   /*    RDSEED*/    { 767,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_107(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][2] = {
   /*    ANDNPS*/    {3606,3605,},
   /*     ANDPS*/    {5104,5103,},
   /*      ORPS*/    {5547,5546,},
   /*     XORPS*/    { 773, 772,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_XUD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_108(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*   VFRCZSD*/    { 789, 788,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_109(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][2] = {
   /*      LLDT*/    { 791, 790,},
   /*      LMSW*/    {3072,3071,},
   /*       LTR*/    {3614,3613,},
   /*      VERR*/    {4092,4091,},
   /*      VERW*/    {5883,5882,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPR16_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_110(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[27][1] = {
   /*     KADDB*/    {2616,},
   /*     KADDD*/    {2613,},
   /*     KADDQ*/    {2594,},
   /*     KADDW*/    {2593,},
   /*     KANDB*/    { 803,},
   /*     KANDD*/    {4285,},
   /*    KANDNB*/    {2592,},
   /*    KANDND*/    {2596,},
   /*    KANDNQ*/    {2614,},
   /*    KANDNW*/    {1181,},
   /*     KANDQ*/    { 822,},
   /*     KANDW*/    { 810,},
   /*      KORB*/    {3804,},
   /*      KORD*/    {3813,},
   /*      KORQ*/    {3826,},
   /*      KORW*/    {3825,},
   /*  KUNPCKBW*/    {2778,},
   /*  KUNPCKDQ*/    {3607,},
   /*  KUNPCKWD*/    {5931,},
   /*    KXNORB*/    {3824,},
   /*    KXNORD*/    {3535,},
   /*    KXNORQ*/    {3516,},
   /*    KXNORW*/    {1094,},
   /*     KXORB*/    {5466,},
   /*     KXORD*/    {5465,},
   /*     KXORQ*/    {5440,},
   /*     KXORW*/    {4896,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_111(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*VEXTRACTF32X4*/    { 806, 804, 807, 805,},
   /*VEXTRACTI32X4*/    {4811,4809,4812,4810,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[23], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[23], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_112(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*   VFRCZSS*/    { 809, 808,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_113(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[9][4] = {
   /*   BLCFILL*/    {5822,5823,5820,5821,},
   /*      BLCI*/    { 849, 850, 847, 848,},
   /*     BLCIC*/    {2988,2989,2986,2987,},
   /*    BLCMSK*/    {3538,3539,3536,3537,},
   /*      BLCS*/    { 828, 829, 826, 827,},
   /*   BLSFILL*/    {3773,3774,3771,3772,},
   /*     BLSIC*/    {4912,4913,4910,4911,},
   /*    T1MSKC*/    { 988, 989, 986, 987,},
   /*     TZMSK*/    {3018,3019,3016,3017,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPRy_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRy_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPRy_N(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Y);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_114(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*VGATHERPF0QPD*/    { 842,},
   /*VGATHERPF1QPD*/    {2938,},
   /*VSCATTERPF0QPD*/    {3878,},
   /*VSCATTERPF1QPD*/    {6733,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_115(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /* CMPSD_XMM*/    { 844, 843,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SD) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_116(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[8][1] = {
   /*VGATHERPF0DPS*/    {3949,},
   /*VGATHERPF0QPS*/    { 845,},
   /*VGATHERPF1DPS*/    {4568,},
   /*VGATHERPF1QPS*/    {2947,},
   /*VSCATTERPF0DPS*/    {4567,},
   /*VSCATTERPF0QPS*/    {3882,},
   /*VSCATTERPF1DPS*/    {2757,},
   /*VSCATTERPF1QPS*/    {6728,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_117(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*  CVTSD2SI*/    {2949,2951,2948,2950,},
   /* CVTTSD2SI*/    { 852, 854, 851, 853,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_118(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*     LOOPE*/    { 884, 882, 883, 885,},
   /*    LOOPNE*/    {3834,3832,3833,3835,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_modep5(xes) == 0) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_modep5(xes) == 1) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_modep5(xes) == 1) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_modep5(xes) == 1) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_119(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*  VROUNDSD*/    { 887, 886,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_120(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*  VROUNDSS*/    { 900, 899,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_121(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[9][2] = {
   /*     ADDPS*/    { 922, 921,},
   /*     DIVPS*/    {3465,3464,},
   /*     MAXPS*/    {1560,1559,},
   /*     MINPS*/    {2858,2857,},
   /*     MULPS*/    {1344,1343,},
   /*     RCPPS*/    {3352,3351,},
   /*   RSQRTPS*/    {6157,6156,},
   /*    SQRTPS*/    {6075,6074,},
   /*     SUBPS*/    {6059,6058,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_PS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_122(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[24][2] = {
   /*   PAVGUSB*/    {6667,6666,},
   /*     PF2ID*/    {1978,1977,},
   /*     PF2IW*/    {1997,1996,},
   /*     PFACC*/    {1836,1835,},
   /*     PFADD*/    {3348,3347,},
   /*   PFCMPEQ*/    {4381,4380,},
   /*   PFCMPGE*/    {3437,3436,},
   /*   PFCMPGT*/    {3429,3428,},
   /*   PFCPIT1*/    {5496,5495,},
   /*     PFMAX*/    {1756,1755,},
   /*     PFMIN*/    {4699,4698,},
   /*     PFMUL*/    { 924, 923,},
   /*    PFNACC*/    {3922,3921,},
   /*   PFPNACC*/    {1728,1727,},
   /*     PFRCP*/    {2844,2843,},
   /*  PFRCPIT2*/    {1838,1837,},
   /*  PFRSQIT1*/    {3998,3997,},
   /*    PFSQRT*/    {6454,6453,},
   /*     PFSUB*/    {1732,1731,},
   /*    PFSUBR*/    {6009,6008,},
   /*     PI2FD*/    {6385,6384,},
   /*     PI2FW*/    {4448,4447,},
   /*   PMULHRW*/    {6324,6323,},
   /*    PSWAPD*/    {4135,4134,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_123(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[19][4] = {
   /* VADDSUBPD*/    {3689,3691,3688,3690,},
   /* VADDSUBPS*/    {3681,3683,3680,3682,},
   /*   VHADDPD*/    { 992, 994, 991, 993,},
   /*   VHADDPS*/    { 927, 929, 926, 928,},
   /*   VHSUBPD*/    {4096,4098,4095,4097,},
   /*   VHSUBPS*/    {4112,4114,4111,4113,},
   /*     VPAND*/    {2317,2319,2316,2318,},
   /*    VPANDN*/    {2321,2323,2320,2322,},
   /*   VPHADDD*/    {3819,3821,3818,3820,},
   /*  VPHADDSW*/    {5999,6001,5998,6000,},
   /*   VPHADDW*/    {3808,3810,3807,3809,},
   /*   VPHSUBD*/    {4415,4417,4414,4416,},
   /*  VPHSUBSW*/    {5106,5108,5105,5107,},
   /*   VPHSUBW*/    {4397,4399,4396,4398,},
   /*      VPOR*/    {6173,6175,6172,6174,},
   /*   VPSIGNB*/    {5829,5831,5828,5830,},
   /*   VPSIGND*/    {5825,5827,5824,5826,},
   /*   VPSIGNW*/    {5808,5810,5807,5809,},
   /*     VPXOR*/    {2094,2096,2093,2095,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_124(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][3] = {
   /*VFIXUPIMMSD*/    {4714,4713,4715,},
   /*VGETMANTSD*/    {1980,1979,1981,},
   /*  VRANGESD*/    {5241,5240,5242,},
   /* VREDUCESD*/    {1282,1281,1283,},
   /*VRNDSCALESD*/    { 931, 930, 932,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_125(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*    FNSTSW*/    { 935, 934,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_AX);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM16);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_126(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*  AND_LOCK*/    { 940, 941, 936, 939, 937, 938,},
   /*  XOR_LOCK*/    {1440,1441,1436,1439,1437,1438,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_127(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[8][6] = {
   /*     PSLLD*/    { 945, 942, 944, 947, 943, 946,},
   /*     PSLLQ*/    { 968, 965, 967, 970, 966, 969,},
   /*     PSLLW*/    { 962, 959, 961, 964, 960, 963,},
   /*     PSRAD*/    {1659,1656,1658,1661,1657,1660,},
   /*     PSRAW*/    {1642,1639,1641,1644,1640,1643,},
   /*     PSRLD*/    {1263,1260,1262,1265,1261,1264,},
   /*     PSRLQ*/    {1241,1238,1240,1243,1239,1242,},
   /*     PSRLW*/    {1247,1244,1246,1249,1245,1248,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_128(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][11] = {
   /*VCVTTPS2DQ*/    { 953, 949, 951, 948, 950, 955, 957, 952, 956, 958, 954,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_129(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*  UMONITOR*/    { 973,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_A_GPR_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_130(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[10][2] = {
   /*     ADDSS*/    {6240,6239,},
   /*  CVTSS2SD*/    {1391,1390,},
   /*     DIVSS*/    {2276,2275,},
   /*     MAXSS*/    {6789,6788,},
   /*     MINSS*/    {4049,4048,},
   /*     MULSS*/    {1001,1000,},
   /*     RCPSS*/    {3794,3793,},
   /*   RSQRTSS*/    { 975, 974,},
   /*    SQRTSS*/    {5679,5678,},
   /*     SUBSS*/    {5681,5680,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_131(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][10] = {
   /*VBROADCASTSS*/    { 978, 979, 976, 977, 983, 985, 981, 982, 984, 980,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE1_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE1_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE1_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_132(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][4] = {
   /* PUNPCKLBW*/    {6439,6438,6441,6440,},
   /* PUNPCKLDQ*/    { 996, 995, 998, 997,},
   /* PUNPCKLWD*/    {6730,6729,6732,6731,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_133(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*VBROADCASTF32X8*/    {4216,},
   /*VBROADCASTI32X8*/    { 999,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_134(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][5] = {
   /* VCVTSS2SD*/    {5559,5557,5556,5558,5560,},
   /*    VMAXSS*/    {1882,1880,1879,1881,1883,},
   /*    VMINSS*/    {1017,1015,1014,1016,1018,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_135(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*VBROADCASTF32X4*/    {4231,4230,},
   /*VBROADCASTI32X4*/    {1020,1019,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_136(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*   FXRSTOR*/    {1551,},
   /* FXRSTOR64*/    {1027,},
   /*    FXSAVE*/    {6028,},
   /*  FXSAVE64*/    {3569,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MFPXENV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_137(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[8][2] = {
   /*     ADDSD*/    {6234,6233,},
   /*  CVTSD2SS*/    {2968,2967,},
   /*     DIVSD*/    {2245,2244,},
   /*     MAXSD*/    {1219,1218,},
   /*     MINSD*/    {4053,4052,},
   /*     MULSD*/    {1029,1028,},
   /*    SQRTSD*/    {5662,5661,},
   /*     SUBSD*/    {5660,5659,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_138(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*     MOVBE*/    {1031,1030,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_139(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*    VMAXSD*/    {3664,3662,3661,3663,3665,},
   /*    VMINSD*/    {1035,1033,1032,1034,1036,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_140(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][4] = {
   /*  VFMADDSS*/    {1038,1040,1037,1039,},
   /*  VFMSUBSS*/    {2955,2957,2954,2956,},
   /* VFNMADDSS*/    {1974,1976,1973,1975,},
   /* VFNMSUBSS*/    {6577,6579,6576,6578,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_141(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][4] = {
   /*  VFMADDSD*/    {1046,1048,1045,1047,},
   /*  VFMSUBSD*/    {4056,4058,4055,4057,},
   /* VFNMADDSD*/    {1970,1972,1969,1971,},
   /* VFNMSUBSD*/    {6601,6603,6600,6602,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_142(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][2] = {
   /*      LGDT*/    {3633,3632,},
   /*      LIDT*/    {1054,1053,},
   /*      SGDT*/    {5723,5722,},
   /*      SIDT*/    {6235,6236,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_S);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_S64);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FORCE64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_143(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][5] = {
   /*PREFETCH_RESERVED*/    {1056,1057,1058,1059,1060,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_144(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /* REP_LODSW*/    {2109,2110,},
   /* REP_OUTSW*/    {1090,1091,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_145(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*    VPCMPB*/    {4263,4265,4267,4264,4266,4268,},
   /*   VPCMPUB*/    {1097,1099,1101,1098,1100,1102,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_146(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*   RET_FAR*/    {1121,1120,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM16_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_147(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*    VPCMPD*/    {4259,4261,4257,4260,4262,4258,},
   /*   VPCMPUD*/    {1124,1126,1122,1125,1127,1123,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_148(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*   MOVDQ2Q*/    {1139,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_149(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][10] = {
   /*    VPABSB*/    {1145,1147,1144,1146,1148,1150,1152,1149,1151,1153,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_150(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*VSHUFF64X2*/    {1156,1154,1157,1155,},
   /*VSHUFI64X2*/    {2781,2779,2782,2780,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_151(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][1] = {
   /*VGATHERPF0DPD*/    {3930,},
   /*VGATHERPF1DPD*/    {1158,},
   /*VSCATTERPF0DPD*/    {4585,},
   /*VSCATTERPF1DPD*/    {2760,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_152(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][22] = {
   /*       MOV*/    {1177,1178,1179,1180,1176,1175,1163,1168,1166,1172,1170,1174,1164,1165,1171,1159,1167,1161,1169,1173,1160,1162,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_reg0(xes) == XED_REG_AL) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID) &&
		 (xed3_operand_get_index(xes) == XED_REG_INVALID);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MEMDISPv_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_OrAX(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID) &&
		 (xed3_operand_get_index(xes) == XED_REG_INVALID);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MEMDISPv_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_SB(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_SB(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMMv_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_OrAX(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID) &&
		 (xed3_operand_get_index(xes) == XED_REG_INVALID);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MEMDISPv_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_AL) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID) &&
		 (xed3_operand_get_index(xes) == XED_REG_INVALID);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MEMDISPv_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_SEG(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_SEG_MOV(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR16_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W) &&
		 xed_encode_ntluf_SEG(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][18]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_SEG_MOV(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][19]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][20]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][21]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_153(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*     BNDMK*/    {1186,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_AGEN) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_agen(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_154(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*  VPTESTMQ*/    {1189,1191,1187,1190,1192,1188,},
   /* VPTESTNMQ*/    {4490,4492,4488,4491,4493,4489,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_155(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][7] = {
   /* VCVTPD2QQ*/    {1198,1193,1195,1197,1194,1196,1199,},
   /*VCVTPD2UQQ*/    {6626,6621,6623,6625,6622,6624,6627,},
   /* VCVTQQ2PD*/    {3928,3923,3925,3927,3924,3926,3929,},
   /*VCVTUQQ2PD*/    {5789,5784,5786,5788,5785,5787,5790,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_156(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][4] = {
   /*      FADD*/    {2225,2223,2224,2222,},
   /*      FDIV*/    {4434,4432,4433,4431,},
   /*     FDIVR*/    {1203,1201,1202,1200,},
   /*      FMUL*/    {4543,4541,4542,4540,},
   /*      FSUB*/    {5256,5254,5255,5253,},
   /*     FSUBR*/    {2092,2090,2091,2089,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_X87(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_reg1(xes) == XED_REG_ST0);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 xed_encode_ntluf_X87(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_M64REAL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM32REAL);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_157(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*      FBLD*/    {1209,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM80DEC);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_158(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][3] = {
   /* VGETEXPSD*/    {5017,5016,5018,},
   /*  VRCP28SD*/    {1216,1215,1217,},
   /*VRSQRT28SD*/    {2620,2619,2621,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_159(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][3] = {
   /* VGETEXPSS*/    {4989,4988,4990,},
   /*  VRCP28SS*/    {1234,1233,1235,},
   /*VRSQRT28SS*/    {2631,2630,2632,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_160(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][4] = {
   /*     CRC32*/    {1272,1274,1271,1273,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRy_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRy_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRy_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRy_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_161(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][10] = {
   /*      IMUL*/    {1285,1287,1284,1286,1293,1291,1289,1292,1290,1288,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_162(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[12][2] = {
   /*  VPMACSDD*/    {5874,5873,},
   /* VPMACSDQH*/    {5852,5851,},
   /* VPMACSDQL*/    {5846,5845,},
   /* VPMACSSDD*/    {4547,4546,},
   /*VPMACSSDQH*/    {3629,3628,},
   /*VPMACSSDQL*/    {3631,3630,},
   /* VPMACSSWD*/    {2539,2538,},
   /* VPMACSSWW*/    {2518,2517,},
   /*  VPMACSWD*/    {6422,6421,},
   /*  VPMACSWW*/    {6383,6382,},
   /*VPMADCSSWD*/    {4301,4300,},
   /* VPMADCSWD*/    {1301,1300,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_163(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][3] = {
   /*VFIXUPIMMSS*/    {4696,4695,4697,},
   /*VGETMANTSS*/    {1999,1998,2000,},
   /*  VRANGESS*/    {5250,5249,5251,},
   /* VREDUCESS*/    {1303,1302,1304,},
   /*VRNDSCALESS*/    {4807,4806,4808,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_SCALAR_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_164(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*      POPA*/    {3381,},
   /*     PUSHA*/    {1305,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1) &&
		 (xed3_operand_get_mode(xes) != 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_165(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     FLDCW*/    {1318,},
   /*    FNSTCW*/    {6785,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM16);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_166(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][16] = {
   /*      MOVD*/    {1340,1336,1338,1334,1339,1332,1335,1328,1337,1330,1333,1326,1331,1327,1329,1325,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_167(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    MOVHPS*/    {1342,1341,},
   /*    MOVLPS*/    {4051,4050,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_168(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[12][1] = {
   /*    XRSTOR*/    {6108,},
   /*  XRSTOR64*/    {6113,},
   /*   XRSTORS*/    {1345,},
   /* XRSTORS64*/    {1730,},
   /*     XSAVE*/    {2872,},
   /*   XSAVE64*/    {1497,},
   /*    XSAVEC*/    {4232,},
   /*  XSAVEC64*/    {3506,},
   /*  XSAVEOPT*/    {5764,},
   /*XSAVEOPT64*/    {3715,},
   /*    XSAVES*/    {6566,},
   /*  XSAVES64*/    {3612,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MXSAVE);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_169(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][1] = {
   /*  CLDEMOTE*/    {5658,},
   /*    INVLPG*/    {1348,},
   /*PREFETCHWT1*/    {6155,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_170(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][16] = {
   /*      MOVQ*/    {1360,1358,1364,1362,1363,1359,1352,1357,1350,1361,1354,1356,1353,1351,1349,1355,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MMX_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_MMX_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_171(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][11] = {
   /*    VMAXPD*/    {2556,2552,2554,2551,2553,2558,2560,2555,2559,2561,2557,},
   /*    VMINPD*/    {1370,1366,1368,1365,1367,1372,1374,1369,1373,1375,1371,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_172(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*  VPTESTMD*/    {1384,1386,1382,1385,1387,1383,},
   /* VPTESTNMD*/    {4459,4461,4457,4460,4462,4458,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_173(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*  VPTESTMW*/    {1392,1394,1396,1393,1395,1397,},
   /* VPTESTNMW*/    {4476,4478,4480,4477,4479,4481,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_174(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][11] = {
   /*    VMAXPS*/    {2568,2564,2566,2563,2565,2570,2572,2567,2571,2573,2569,},
   /*    VMINPS*/    {1403,1399,1401,1398,1400,1405,1407,1402,1406,1408,1404,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_175(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*  CVTSS2SI*/    {1411,1413,1410,1412,},
   /* CVTTSS2SI*/    {2027,2029,2026,2028,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_176(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    MOVHPD*/    {1415,1414,},
   /*    MOVLPD*/    {4037,4036,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_177(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*VBROADCASTF128*/    {1422,},
   /*VBROADCASTI128*/    {4813,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_178(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*  VROUNDPD*/    {1430,1432,1429,1431,},
   /*  VROUNDPS*/    {1443,1445,1442,1444,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_179(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    FNSAVE*/    {3446,3445,},
   /*    FRSTOR*/    {1447,1446,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM108);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM94);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_180(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*     MOVSX*/    {2434,2432,2431,2433,},
   /*     MOVZX*/    {1451,1449,1448,1450,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR16_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_181(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][6] = {
   /*       JMP*/    {1467,1465,1466,1468,1464,1463,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISPz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FORCE64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP32_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_RELBR) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_relbr(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FORCE64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_BRDISP8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_DF64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_182(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[7][4] = {
   /*   VFRCZPD*/    {2052,2054,2051,2053,},
   /*   VFRCZPS*/    {2080,2082,2079,2081,},
   /*    VPTEST*/    {3675,3677,3674,3676,},
   /*    VRCPPS*/    {1470,1472,1469,1471,},
   /*  VRSQRTPS*/    {4375,4377,4374,4376,},
   /*   VTESTPD*/    {5917,5919,5916,5918,},
   /*   VTESTPS*/    {5933,5935,5932,5934,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_183(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /* V4FMADDSS*/    {1561,},
   /*V4FNMADDSS*/    {1473,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE1_4X_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_184(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][6] = {
   /*  VPMOVSWB*/    {1475,1477,1479,1476,1478,1480,},
   /* VPMOVUSWB*/    {6508,6510,6512,6509,6511,6513,},
   /*   VPMOVWB*/    {5775,5777,5779,5776,5778,5780,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_185(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][15] = {
   /* VCVTSD2SI*/    {1489,1490,1494,1482,1484,1486,1481,1483,1485,1487,1488,1493,1491,1492,1495,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_186(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][3] = {
   /*VPSCATTERDD*/    {6718,6719,6717,},
   /*VSCATTERDPS*/    {1528,1529,1527,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[13], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D) &&
		 xed_encode_ntluf_MASKNOT0(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GSCAT_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_187(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*    SYSRET*/    {1532,1531,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_eosz(xes) != 3);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_eosz(xes) == 3);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_188(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][18] = {
   /*       ADC*/    {1624,1623,1616,1620,1618,1622,1615,1617,1612,1608,1619,1614,1610,1621,1607,1613,1609,1611,},
   /*       ADD*/    {1606,1605,1598,1602,1600,1604,1597,1599,1594,1590,1601,1596,1592,1603,1589,1595,1591,1593,},
   /*       CMP*/    {1808,1807,1800,1804,1802,1806,1799,1801,1796,1792,1803,1798,1794,1805,1791,1797,1793,1795,},
   /*       SBB*/    {5279,5278,5271,5274,5273,5276,5270,5272,5267,5263,5275,5269,5265,5277,5262,5268,5264,5266,},
   /*       SUB*/    {1550,1549,1542,1545,1544,1547,1541,1543,1538,1534,1546,1540,1536,1548,1533,1539,1535,1537,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_OrAX(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_AL) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][15]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][16]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMMz_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][17]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_189(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[9][2] = {
   /*AESKEYGENASSIST*/    {1552,1553,},
   /*   BLENDPD*/    {4025,4024,},
   /*   BLENDPS*/    {4008,4007,},
   /*      DPPD*/    {2940,2939,},
   /*      DPPS*/    {2946,2945,},
   /*   MPSADBW*/    {3541,3540,},
   /*   PBLENDW*/    {3526,3525,},
   /* PCLMULQDQ*/    {5781,5782,},
   /*    PSHUFD*/    {6133,6132,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_190(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*VMASKMOVDQU*/    {1562,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_191(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[8][1] = {
   /*  KSHIFTLB*/    {1630,},
   /*  KSHIFTLD*/    {1629,},
   /*  KSHIFTLQ*/    {1638,},
   /*  KSHIFTLW*/    {1637,},
   /*  KSHIFTRB*/    {1572,},
   /*  KSHIFTRD*/    {1575,},
   /*  KSHIFTRQ*/    {1563,},
   /*  KSHIFTRW*/    {1564,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_192(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][6] = {
   /*    VPERMD*/    {5294,5293,5297,5295,5298,5296,},
   /*   VPERMPS*/    {1566,1565,1569,1567,1570,1568,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_193(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[7][1] = {
   /*       CDQ*/    {6238,},
   /*      CWDE*/    {6712,},
   /*     IRETD*/    {1571,},
   /*REPE_SCASD*/    {1772,},
   /*REPNE_SCASD*/    {2765,},
   /*     SCASD*/    {5936,},
   /*     STOSD*/    {4548,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_194(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /* CMPXCHG8B*/    {1573,1574,},
   /*CMPXCHG8B_LOCK*/    {2740,2741,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IMMUNE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_195(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /*   VPERMPD*/    {1578,1577,1585,1581,1583,1579,1586,1582,1584,1580,},
   /*    VPERMQ*/    {5314,5313,5321,5317,5319,5315,5322,5318,5320,5316,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_196(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][5] = {
   /*       DEC*/    {1681,1678,1680,1677,1679,},
   /*       INC*/    {1878,1875,1877,1874,1876,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPRv_SB(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPR8_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_REG0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_B);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_197(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][15] = {
   /*VCVTTSD2SI*/    {1702,1703,1707,1695,1697,1699,1694,1696,1698,1700,1701,1706,1704,1705,1708,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][12]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][13]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][14]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_198(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][11] = {
   /* VCVTPD2DQ*/    {5693,5689,5691,5688,5690,5695,5697,5692,5696,5698,5694,},
   /* VCVTPD2PS*/    {1714,1710,1712,1709,1711,1716,1718,1713,1717,1719,1715,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_199(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    COMISD*/    {5089,5088,},
   /*   UCOMISD*/    {1724,1723,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_200(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*    COMISS*/    {5091,5090,},
   /*   UCOMISS*/    {1726,1725,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_SS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_201(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*   INVLPGA*/    {1729,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_OrAX(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_reg1(xes) == XED_REG_ECX);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_202(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*  CVTPS2DQ*/    {1746,1745,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_PS);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_203(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][4] = {
   /*    MOV_DR*/    {1747,1749,1748,1750,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_DR_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_CR_WIDTH_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_DR_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_CR_WIDTH_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_DR_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_CR_WIDTH_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_DR_R(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_CR_WIDTH_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_204(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*CLFLUSHOPT*/    {5548,},
   /*      CLWB*/    {1765,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_205(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[9][6] = {
   /* VPBLENDMW*/    {3584,3586,3588,3585,3587,3589,},
   /*  VPERMI2W*/    {3643,3645,3647,3644,3646,3648,},
   /*  VPERMT2W*/    {3203,3205,3207,3204,3206,3208,},
   /*    VPERMW*/    {5327,5329,5331,5328,5330,5332,},
   /*  VPSHLDVW*/    {4469,4471,4473,4470,4472,4474,},
   /*  VPSHRDVW*/    {1766,1768,1770,1767,1769,1771,},
   /*   VPSLLVW*/    {4734,4736,4738,4735,4737,4739,},
   /*   VPSRAVW*/    {4105,4107,4109,4106,4108,4110,},
   /*   VPSRLVW*/    {4889,4891,4893,4890,4892,4894,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_206(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*  PMOVSXBQ*/    {4413,4412,},
   /*  PMOVZXBQ*/    {1783,1782,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_W);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_207(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*VPERM2F128*/    {1788,1787,},
   /*VPERM2I128*/    {3552,3551,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_208(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][2] = {
   /*    INVEPT*/    {3074,3073,},
   /*   INVPCID*/    {5365,5364,},
   /*   INVVPID*/    {1823,1822,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_CR_WIDTH_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_REFINING66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_CR_WIDTH_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_209(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][4] = {
   /*VINSERTF32X4*/    {3102,3100,3103,3101,},
   /*VINSERTI32X4*/    {1841,1839,1842,1840,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE4_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_210(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /*VINSERTF32X8*/    {3097,3098,},
   /*VINSERTI32X8*/    {1843,1844,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_TUPLE8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_211(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][11] = {
   /* VCVTPH2PS*/    {1850,1846,1848,1845,1847,1852,1854,1849,1853,1855,1851,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_sae(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SAE_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_16_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_212(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /* VMOVSHDUP*/    {1857,1859,1856,1858,1862,1864,1860,1863,1865,1861,},
   /* VMOVSLDUP*/    {2235,2237,2234,2236,2240,2242,2238,2241,2243,2239,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_213(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][4] = {
   /*    BNDSTX*/    {1867,1868,1869,1870,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_BND32) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_BND64) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_BND64) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_mpxmode(xes) == 1) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_BND64) &&
		 xed_encode_ntluf_BND_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_214(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*   INSERTQ*/    {1872,1871,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[25], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1) &&
		 (xed3_operand_get_imm1(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_1_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_215(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*       INT*/    {1873,},
   /*    XABORT*/    {2422,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_IMM0) {
   conditions_satisfied = (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_216(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /*VPEXTRW_C5*/    {1884,1885,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_217(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][10] = {
   /* VPMOVSXDQ*/    {1886,1888,1887,1889,1892,1894,1890,1893,1895,1891,},
   /* VPMOVZXDQ*/    {4819,4821,4820,4822,4825,4827,4823,4826,4828,4824,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_HALFMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_218(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][6] = {
   /*    VPABSQ*/    {2588,2590,2586,2589,2591,2587,},
   /*VPCONFLICTQ*/    {1908,1910,1906,1909,1911,1907,},
   /*  VPLZCNTQ*/    {5336,5338,5334,5337,5339,5335,},
   /*  VPOPCNTQ*/    {3753,3755,3751,3754,3756,3752,},
   /*  VRCP14PD*/    {3180,3182,3178,3181,3183,3179,},
   /*VRSQRT14PD*/    {6651,6653,6649,6652,6654,6650,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_219(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][8] = {
   /*       BSR*/    {1919,1921,1923,1925,1918,1920,1922,1924,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_220(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][10] = {
   /*  VMOVDDUP*/    {1927,1929,1926,1928,1932,1934,1930,1933,1935,1931,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MOVDDUP_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MOVDDUP_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MOVDDUP_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_221(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][6] = {
   /*       BSF*/    {1951,1953,1955,1950,1952,1954,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPRv_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = xed_encode_ntluf_GPRv_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_V);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_222(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][1] = {
   /*     VMXON*/    {1956,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_IGNORE66_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_223(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][8] = {
   /*   VPSLLDQ*/    {5223,5224,5225,5227,5229,5226,5228,5230,},
   /*   VPSRLDQ*/    {1961,1962,1963,1965,1967,1964,1966,1968,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_ZD) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_8_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULLMEM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_224(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[5][6] = {
   /*VPCONFLICTD*/    {1992,1994,1990,1993,1995,1991,},
   /*  VPLZCNTD*/    {5305,5307,5303,5306,5308,5304,},
   /*  VPOPCNTD*/    {3767,3769,3765,3768,3770,3766,},
   /*  VRCP14PS*/    {6164,6166,6162,6165,6167,6163,},
   /*VRSQRT14PS*/    {6662,6664,6660,6663,6665,6661,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_225(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][8] = {
   /*VPERMIL2PD*/    {2019,2023,2021,2025,2018,2022,2020,2024,},
   /*VPERMIL2PS*/    {2003,2007,2005,2009,2002,2006,2004,2008,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[26], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[26], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_226(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[6][1] = {
   /*   CLFLUSH*/    {4727,},
   /*PREFETCHNTA*/    {6678,},
   /*PREFETCHT0*/    {2017,},
   /*PREFETCHT1*/    {2016,},
   /*PREFETCHT2*/    {2015,},
   /*PREFETCH_EXCLUSIVE*/    {2279,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MPREFETCH);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_227(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*  VLDMXCSR*/    {3792,},
   /*  VSTMXCSR*/    {2040,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 1 && xes->_operand_order[0] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_228(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][2] = {
   /*GF2P8AFFINEINVQB*/    {5054,5055,},
   /*GF2P8AFFINEQB*/    {5488,5489,},
   /* SHA1RNDS4*/    {2071,2072,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_229(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][6] = {
   /*VFPCLASSPD*/    {2097,2099,2101,2098,2100,2102,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_230(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /* REP_LODSQ*/    {2103,2104,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 3);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 3);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_231(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][9] = {
   /*VCVTSD2USI*/    {2113,2114,2118,2111,2112,2117,2115,2116,2119,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_232(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][2] = {
   /* REP_LODSB*/    {2125,2126,},
   /* REP_OUTSB*/    {5946,5947,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = 1;
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_233(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][2] = {
   /* REP_LODSD*/    {2127,2128,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_234(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][4] = {
   /* VBLENDVPD*/    {4249,4251,4248,4250,},
   /* VBLENDVPS*/    {4277,4279,4276,4278,},
   /* VPBLENDVB*/    {2136,2138,2135,2137,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[22], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 xed_encode_ntluf_YMM_SE(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_SE_IMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_235(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][3] = {
   /*      FILD*/    {2141,2140,2139,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_M64INT);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM16INT);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_reg0(xes) == XED_REG_ST0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_MEM32INT);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_236(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[4][6] = {
   /*      ANDN*/    {6151,6152,6154,6149,6150,6153,},
   /*      MULX*/    {2622,2623,2626,2624,2625,2627,},
   /*      PDEP*/    {2152,2153,2155,2150,2151,2154,},
   /*      PEXT*/    {4802,4803,4805,4800,4801,4804,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_VGPR32_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_VGPR32_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_VGPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR64_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_VGPR64_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_VGPR32_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR32_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_D);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_VGPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_VGPR64_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_237(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[8][4] = {
   /*    VPSHAB*/    {6703,6705,6702,6704,},
   /*    VPSHAD*/    {6714,6716,6713,6715,},
   /*    VPSHAQ*/    {6684,6686,6683,6685,},
   /*    VPSHAW*/    {6688,6690,6687,6689,},
   /*    VPSHLB*/    {2179,2181,2178,2180,},
   /*    VPSHLD*/    {2175,2177,2174,2176,},
   /*    VPSHLQ*/    {2231,2233,2230,2232,},
   /*    VPSHLW*/    {2227,2229,2226,2228,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[18], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_238(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][10] = {
   /*   VPSHUFD*/    {2183,2185,2182,2184,2188,2190,2186,2189,2191,2187,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[15], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[14], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_239(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][12] = {
   /*    VPSRAQ*/    {2214,2218,2210,2216,2220,2212,2215,2219,2211,2217,2221,2213,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[6], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[7], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_MEM128_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][11]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_240(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][5] = {
   /*     KMOVQ*/    {2262,2261,2258,2260,2259,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_GPR64_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_GPR64_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_MEM0 && xes->_operand_order[1] == XED_OPERAND_REG0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_MASK_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_Q);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_241(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[2][1] = {
   /*     POPAD*/    {6289,},
   /*    PUSHAD*/    {2274,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 0) {
   conditions_satisfied = (xed3_operand_get_eosz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) != 2);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_242(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][10] = {
   /*VGF2P8AFFINEINVQB*/    {6036,6038,6037,6039,6030,6032,6034,6031,6033,6035,},
   /*VGF2P8AFFINEQB*/    {5954,5956,5955,5957,5948,5950,5952,5949,5951,5953,},
   /*   VSHUFPD*/    {2325,2327,2324,2326,2330,2332,2328,2331,2333,2329,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_243(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[3][11] = {
   /* VCVTDQ2PS*/    {6370,6366,6368,6365,6367,6372,6374,6369,6373,6375,6371,},
   /* VCVTPS2DQ*/    {3297,3293,3295,3292,3294,3299,3301,3296,3300,3302,3298,},
   /*   VSQRTPS*/    {2339,2335,2337,2334,2336,2341,2343,2338,2342,2344,2340,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_32_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_244(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][11] = {
   /*   VSQRTPD*/    {2368,2364,2366,2363,2365,2370,2372,2367,2371,2373,2369,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_roundc(xes) != 0) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_FIX_ROUND_LEN512_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_AVX512_ROUND_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_REG1) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg1(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 2 && xes->_operand_order[0] == XED_OPERAND_REG0 && xes->_operand_order[1] == XED_OPERAND_MEM0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[5], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg2(xes));
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][7]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][8]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][9]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 3 && memcmp(xed_encode_order[4], xes->_operand_order, sizeof(xed_uint8_t)*3)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_VV);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][10]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_ESIZE_64_BITS_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_NELEM_FULL_BIND(xes);
       if (okay) return 1;
   }
     }
   return 0;
   (void) okay;
   (void) conditions_satisfied;
   (void) xes;
}
xed_bool_t xed_encode_group_245(xed_encoder_request_t* xes)
{
   xed_bool_t okay=1;
   xed_bool_t conditions_satisfied=0;
   xed_ptrn_func_ptr_t fb_ptrn_function;
   static const xed_uint16_t iform_ids[1][10] = {
   /*   VSHUFPS*/    {2375,2377,2374,2376,2380,2382,2378,2381,2383,2379,},
   };
   xed_uint8_t iclass_index = xed_encoder_get_iclasses_index_in_group(xes);
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][0]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[16], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_B(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][1]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_XMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_DQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][2]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 4 && memcmp(xed_encode_order[17], xes->_operand_order, sizeof(xed_uint8_t)*4)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_YMM_N(xes,xed3_operand_get_reg1(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,XED_OPERAND_WIDTH_QQ) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][3]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_MODRM_BIND(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_XMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][4]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 1) &&
		 xed_encode_ntluf_YMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_YMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_YMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][5]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[9], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 2) &&
		 xed_encode_ntluf_ZMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_ZMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 xed_encode_ntluf_ZMM_B3(xes,xed3_operand_get_reg3(xes)) &&
		 (xed3_operand_get_imm0(xes) == 1);
   if (conditions_satisfied) {
       okay=1;
       xed_encoder_request_set_iform_index(xes,iform_ids[iclass_index][6]);
       fb_ptrn_function = xed_encoder_get_fb_ptrn(xes);
       (*fb_ptrn_function)(xes);
       if (okay)
           okay = xed_encode_nonterminal_UIMM8_BIND(xes);
       if (okay) return 1;
   }
     }
   if (xes->_n_operand_order == 5 && memcmp(xed_encode_order[10], xes->_operand_order, sizeof(xed_uint8_t)*5)==0) {
   conditions_satisfied = (xed3_operand_get_vl(xes) == 0) &&
		 xed_encode_ntluf_XMM_R3(xes,xed3_operand_get_reg0(xes)) &&
		 xed_encode_ntluf_MASK1(xes,xed3_operand_get_reg1(xes)) &&
		 xed_encode_ntluf_XMM_N3(xes,xed3_operand_get_reg2(xes)) &&
		 (xed3_operand_get_mem0(xes) == 1) &&
		 xed_encoder_request__memop_compatible(xes,X