/// @file xed-encoder-4.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-encoder.h"
#include "xed-encode-private.h"
#include "xed-enc-operand-lu.h"
#include "xed-operand-accessors.h"
xed_uint_t xed_encode_nonterminal_SIB_REQUIRED_ENCODE_BIND(xed_encoder_request_t* xes)
{
/* SIB_REQUIRED_ENCODE()::
	EASZ=3 BASE0=@ DISP_WIDTH=32  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 BASE0=@ DISP_WIDTH=32  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RAX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RBX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RCX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RDX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RSP  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RBP  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RSI  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RDI  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R8  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R9  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R10  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R11  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R12  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R13  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R14  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R15  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_SP EASZ=1  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_ESP EASZ=2  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_RSP EASZ=3  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_R12W EASZ=1  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_R12D EASZ=2  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_R12 EASZ=3  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EAX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EBX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_ECX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EDX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_ESP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EBP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_ESI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EDI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EAX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EBX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_ECX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EDX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_ESP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EBP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_ESI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EDI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R8D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R9D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R10D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R11D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R12D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R13D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R14D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R15D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=0  ->	nothing
	EASZ=2 MODE=1  ->	nothing
 */
xed_uint_t okay=1;
xed_uint_t conditions_satisfied=0;
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID) &&
		 (xed3_operand_get_disp_width(xes) == 32);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID) &&
		 (xed3_operand_get_disp_width(xes) == 32);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RAX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RBX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RCX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RDX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RSP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RBP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RSI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_RDI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R8);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R9);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R10);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R11);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R12);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R13);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R14);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_index(xes) == XED_REG_R15);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) != 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_EAX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_EBX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_ECX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_EDX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_ESP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_EBP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_ESI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_index(xes) == XED_REG_EDI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_EAX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_EBX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_ECX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_EDX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_ESP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_EBP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_ESI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_EDI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R8D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R9D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R10D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R11D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R12D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R13D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R14D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_index(xes) == XED_REG_R15D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_sib(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 0);
if (conditions_satisfied) {
    okay=1;
    return 1; /* nothing */
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_mode(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    return 1; /* nothing */
    if (okay) return 1;
}
conditions_satisfied = 1;
if (conditions_satisfied) {
    okay=1;
/* FIXME action code not done yet for return 1*/
    if (okay) return 1;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) conditions_satisfied;
}
xed_uint_t xed_encode_nonterminal_SIB_REQUIRED_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* SIB_REQUIRED_ENCODE()::
	EASZ=3 BASE0=@ DISP_WIDTH=32  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 BASE0=@ DISP_WIDTH=32  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RAX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RBX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RCX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RDX  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RSP  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RBP  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RSI  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_RDI  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R8  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R9  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R10  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R11  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R12  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R13  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R14  ->	FB SIB=1 value=0x1
	EASZ=3 INDEX=XED_REG_R15  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_SP EASZ=1  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_ESP EASZ=2  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_RSP EASZ=3  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_R12W EASZ=1  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_R12D EASZ=2  ->	FB SIB=1 value=0x1
	EASZ!=1 BASE0=XED_REG_R12 EASZ=3  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EAX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EBX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_ECX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EDX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_ESP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EBP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_ESI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=1 INDEX=XED_REG_EDI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EAX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EBX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_ECX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EDX  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_ESP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EBP  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_ESI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_EDI  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R8D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R9D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R10D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R11D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R12D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R13D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R14D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=2 INDEX=XED_REG_R15D  ->	FB SIB=1 value=0x1
	EASZ=2 MODE=0  ->	nothing
	EASZ=2 MODE=1  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_XOP_MAP_ENC_EMIT(xed_encoder_request_t* xes)
{
/* XOP_MAP_ENC()::
	MAP=8 REXW[w]=*  ->	emit 0b0_1000 emit_type=numeric value=0x8 nbits=5 	emit w emit_type=letters nbits=1
	MAP=9 REXW[w]=*  ->	emit 0b0_1001 emit_type=numeric value=0x9 nbits=5 	emit w emit_type=letters nbits=1
	MAP=10 REXW[w]=*  ->	emit 0b0_1010 emit_type=numeric value=0xa nbits=5 	emit w emit_type=letters nbits=1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_XOP_MAP_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,5,0x8);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,5,0x9);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,5,0xa);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE1_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE1()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_ENCODE()::
	EASZ=1 DISP_WIDTH=0  ->	nt NT[MODRM_MOD_EA16_DISP0]
	EASZ=1 DISP_WIDTH=8  ->	nt NT[MODRM_MOD_EA16_DISP8]
	EASZ=1 DISP_WIDTH=16  ->	nt NT[MODRM_MOD_EA16_DISP16]
	EASZ=1 DISP_WIDTH=32  ->	nt NT[ERROR]
	EASZ=1 DISP_WIDTH=64  ->	nt NT[ERROR]
	EASZ=2 DISP_WIDTH=0  ->	nt NT[MODRM_MOD_EA32_DISP0]
	EASZ=2 DISP_WIDTH=8  ->	nt NT[MODRM_MOD_EA32_DISP8]
	EASZ=2 DISP_WIDTH=16  ->	nt NT[ERROR]
	EASZ=2 DISP_WIDTH=32  ->	nt NT[MODRM_MOD_EA32_DISP32]
	EASZ=2 DISP_WIDTH=64  ->	nt NT[ERROR]
	EASZ=3 DISP_WIDTH=0  ->	nt NT[MODRM_MOD_EA64_DISP0]
	EASZ=3 DISP_WIDTH=8  ->	nt NT[MODRM_MOD_EA64_DISP8]
	EASZ=3 DISP_WIDTH=16  ->	nt NT[ERROR]
	EASZ=3 DISP_WIDTH=32  ->	nt NT[MODRM_MOD_EA64_DISP32]
	EASZ=3 DISP_WIDTH=64  ->	nt NT[ERROR]
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MODRM_MOD_ENCODE;
/* 9 */ if (iform==9) {
    xed_encode_nonterminal_MODRM_MOD_EA16_DISP0_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 6 */ if (iform==6) {
    xed_encode_nonterminal_MODRM_MOD_EA16_DISP8_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encode_nonterminal_MODRM_MOD_EA16_DISP16_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 12 */ if (iform==12) {
    xed_encode_nonterminal_ERROR_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 15 */ if (iform==15) {
    xed_encode_nonterminal_ERROR_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encode_nonterminal_MODRM_MOD_EA32_DISP0_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encode_nonterminal_MODRM_MOD_EA32_DISP8_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 13 */ if (iform==13) {
    xed_encode_nonterminal_ERROR_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    xed_encode_nonterminal_MODRM_MOD_EA32_DISP32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 10 */ if (iform==10) {
    xed_encode_nonterminal_ERROR_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 14 */ if (iform==14) {
    xed_encode_nonterminal_MODRM_MOD_EA64_DISP0_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 11 */ if (iform==11) {
    xed_encode_nonterminal_MODRM_MOD_EA64_DISP8_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 8 */ if (iform==8) {
    xed_encode_nonterminal_ERROR_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_MODRM_MOD_EA64_DISP32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 5 */ if (iform==5) {
    xed_encode_nonterminal_ERROR_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_MEM128_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_MEM128()::
	BCAST!=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_D_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_LDOP_D()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VSIB_ENC_BASE_EMIT(xed_encoder_request_t* xes)
{
/* VSIB_ENC_BASE()::
	BASE0=XED_REG_AX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=0 value=0x0
	BASE0=XED_REG_EAX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=0 value=0x0
	BASE0=XED_REG_RAX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=0 value=0x0
	BASE0=XED_REG_CX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=1 value=0x1
	BASE0=XED_REG_ECX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=1 value=0x1
	BASE0=XED_REG_RCX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=1 value=0x1
	BASE0=XED_REG_DX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=2 value=0x2
	BASE0=XED_REG_EDX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=2 value=0x2
	BASE0=XED_REG_RDX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=2 value=0x2
	BASE0=XED_REG_BX EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=3 value=0x3
	BASE0=XED_REG_EBX EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=3 value=0x3
	BASE0=XED_REG_RBX EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=3 value=0x3
	BASE0=XED_REG_SP EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=4 value=0x4
	BASE0=XED_REG_ESP EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=4 value=0x4
	BASE0=XED_REG_RSP EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=4 value=0x4
	BASE0=XED_REG_SI EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=6 value=0x6
	BASE0=XED_REG_ESI EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=6 value=0x6
	BASE0=XED_REG_RSI EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=6 value=0x6
	BASE0=XED_REG_DI EASZ=1  ->	FB REXB=0 value=0x0 	FB SIBBASE=7 value=0x7
	BASE0=XED_REG_EDI EASZ=2  ->	FB REXB=0 value=0x0 	FB SIBBASE=7 value=0x7
	BASE0=XED_REG_RDI EASZ=3  ->	FB REXB=0 value=0x0 	FB SIBBASE=7 value=0x7
	BASE0=XED_REG_R8W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=0 value=0x0
	BASE0=XED_REG_R8D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=0 value=0x0
	BASE0=XED_REG_R8 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=0 value=0x0
	BASE0=XED_REG_R9W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=1 value=0x1
	BASE0=XED_REG_R9D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=1 value=0x1
	BASE0=XED_REG_R9 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=1 value=0x1
	BASE0=XED_REG_R10W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=2 value=0x2
	BASE0=XED_REG_R10D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=2 value=0x2
	BASE0=XED_REG_R10 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=2 value=0x2
	BASE0=XED_REG_R11W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=3 value=0x3
	BASE0=XED_REG_R11D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=3 value=0x3
	BASE0=XED_REG_R11 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=3 value=0x3
	BASE0=XED_REG_R12W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=4 value=0x4
	BASE0=XED_REG_R12D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=4 value=0x4
	BASE0=XED_REG_R12 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=4 value=0x4
	BASE0=XED_REG_R14W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=6 value=0x6
	BASE0=XED_REG_R14D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=6 value=0x6
	BASE0=XED_REG_R14 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=6 value=0x6
	BASE0=XED_REG_R15W EASZ=1  ->	FB REXB=1 value=0x1 	FB SIBBASE=7 value=0x7
	BASE0=XED_REG_R15D EASZ=2  ->	FB REXB=1 value=0x1 	FB SIBBASE=7 value=0x7
	BASE0=XED_REG_R15 EASZ=3  ->	FB REXB=1 value=0x1 	FB SIBBASE=7 value=0x7
	BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5
	BASE0=XED_REG_BP EASZ=1  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5
	BASE0=XED_REG_EBP EASZ=2  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5
	BASE0=XED_REG_RBP EASZ=3  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=0 value=0x0 	FB SIBBASE=5 value=0x5
	BASE0=XED_REG_R13W EASZ=1  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=1 value=0x1 	FB SIBBASE=5 value=0x5
	BASE0=XED_REG_R13D EASZ=2  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=1 value=0x1 	FB SIBBASE=5 value=0x5
	BASE0=XED_REG_R13 EASZ=3  ->	nt NT[DISP_WIDTH_8_32] 	FB REXB=1 value=0x1 	FB SIBBASE=5 value=0x5
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VSIB_ENC_BASE;
/* 91 */ if (iform==91) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 14 */ if (iform==14) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 41 */ if (iform==41) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 95 */ if (iform==95) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 18 */ if (iform==18) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 45 */ if (iform==45) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 22 */ if (iform==22) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 49 */ if (iform==49) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 8 */ if (iform==8) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 26 */ if (iform==26) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 53 */ if (iform==53) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 12 */ if (iform==12) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 30 */ if (iform==30) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 57 */ if (iform==57) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 20 */ if (iform==20) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 38 */ if (iform==38) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 65 */ if (iform==65) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 24 */ if (iform==24) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 42 */ if (iform==42) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 69 */ if (iform==69) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 28 */ if (iform==28) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 46 */ if (iform==46) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 73 */ if (iform==73) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 32 */ if (iform==32) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 50 */ if (iform==50) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 77 */ if (iform==77) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 36 */ if (iform==36) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 54 */ if (iform==54) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 81 */ if (iform==81) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 40 */ if (iform==40) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 58 */ if (iform==58) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 85 */ if (iform==85) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 44 */ if (iform==44) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 62 */ if (iform==62) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 89 */ if (iform==89) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 52 */ if (iform==52) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 70 */ if (iform==70) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 97 */ if (iform==97) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 56 */ if (iform==56) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 74 */ if (iform==74) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 101 */ if (iform==101) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 13 */ if (iform==13) {
    xed_encode_nonterminal_DISP_WIDTH_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 16 */ if (iform==16) {
    xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 34 */ if (iform==34) {
    xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 61 */ if (iform==61) {
    xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 48 */ if (iform==48) {
    xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 66 */ if (iform==66) {
    xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 93 */ if (iform==93) {
    xed_encode_nonterminal_DISP_WIDTH_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_WORD_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_STORE_WORD()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_ESIZE_16_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_16_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIMM8_EMIT(xed_encoder_request_t* xes)
{
/* SIMM8()::
	IMM_WIDTH=8 UIMM0[iiiiiiii]=*  ->	emit uimm0=iiiiiiii emit_type=letters nbits=8 	FB IMM0SIGNED=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SIMM8;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MEMDISPv_EMIT(xed_encoder_request_t* xes)
{
/* MEMDISPv()::
	DISP_WIDTH=16 EASZ=1 DISP[aaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaa emit_type=letters nbits=16
	DISP_WIDTH=32 EASZ=2 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=32
	DISP_WIDTH=64 EASZ=3 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=64
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MEMDISPv;
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,64,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MEMDISP8_EMIT(xed_encoder_request_t* xes)
{
/* MEMDISP8()::
	DISP_WIDTH=8 DISP[aaaaaaaa]=*  ->	emit disp=aaaaaaaa emit_type=letters nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MEMDISP8;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_UIMM8_1_EMIT(xed_encoder_request_t* xes)
{
/* UIMM8_1()::
	DUMMY=0 UIMM1[iiiiiiii]=*  ->	emit uimm1=iiiiiiii emit_type=letters nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_UIMM8_1;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_uimm1(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MEMDISP_EMIT(xed_encoder_request_t* xes)
{
/* MEMDISP()::
	DISP_WIDTH=0  ->	FB NEED_MEMDISP=0 value=0x0
	DISP_WIDTH=8 DISP[aaaaaaaa]=*  ->	FB NEED_MEMDISP=8 value=0x8 	emit disp=aaaaaaaa emit_type=letters nbits=8
	DISP_WIDTH=16 DISP[aaaaaaaaaaaaaaaa]=*  ->	FB NEED_MEMDISP=16 value=0x10 	emit disp=aaaaaaaaaaaaaaaa emit_type=letters nbits=16
	DISP_WIDTH=32 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	FB NEED_MEMDISP=32 value=0x20 	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=32
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MEMDISP;
/* 1 */ if (iform==1) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_BRDISP32_EMIT(xed_encoder_request_t* xes)
{
/* BRDISP32()::
	BRDISP_WIDTH=32 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit disp=dddddddddddddddddddddddddddddddd emit_type=letters nbits=32
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_BRDISP32;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MEMDISP32_EMIT(xed_encoder_request_t* xes)
{
/* MEMDISP32()::
	DISP_WIDTH=32 DISP[aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa emit_type=letters nbits=32
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MEMDISP32;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MEMDISP16_EMIT(xed_encoder_request_t* xes)
{
/* MEMDISP16()::
	DISP_WIDTH=16 DISP[aaaaaaaaaaaaaaaa]=*  ->	emit disp=aaaaaaaaaaaaaaaa emit_type=letters nbits=16
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MEMDISP16;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_UIMM32_EMIT(xed_encoder_request_t* xes)
{
/* UIMM32()::
	IMM_WIDTH=32 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_UIMM32;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_ONE_EMIT(xed_encoder_request_t* xes)
{
/* ONE()::
	IMM_WIDTH=8 UIMM0=1 MODE=0  ->	nothing
	IMM_WIDTH=8 UIMM0=1 MODE=1  ->	nothing
	IMM_WIDTH=8 UIMM0=1 MODE=2  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIMMz_EMIT(xed_encoder_request_t* xes)
{
/* SIMMz()::
	IMM_WIDTH=16 EOSZ=1 UIMM0[iiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiii emit_type=letters nbits=16 	FB IMM0SIGNED=1 value=0x1
	IMM_WIDTH=32 EOSZ=2 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32 	FB IMM0SIGNED=1 value=0x1
	IMM_WIDTH=32 EOSZ=3 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32 	FB IMM0SIGNED=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SIMMz;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_ASZ_NONTERM_EMIT(xed_encoder_request_t* xes)
{
/* ASZ_NONTERM()::
	EASZ=1 MODE=0  ->	FB ASZ=0 value=0x0
	EASZ=2 MODE=0  ->	FB ASZ=1 value=0x1
	EASZ=2 MODE=1  ->	FB ASZ=0 value=0x0
	EASZ=1 MODE=1  ->	FB ASZ=1 value=0x1
	EASZ=3 MODE=2  ->	FB ASZ=0 value=0x0
	EASZ=2 MODE=2  ->	FB ASZ=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_UIMMv_EMIT(xed_encoder_request_t* xes)
{
/* UIMMv()::
	IMM_WIDTH=16 EOSZ=1 UIMM0[iiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiii emit_type=letters nbits=16
	IMM_WIDTH=32 EOSZ=2 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=32
	IMM_WIDTH=64 EOSZ=3 UIMM0[iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii emit_type=letters nbits=64
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_UIMMv;
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,64,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_UIMM16_EMIT(xed_encoder_request_t* xes)
{
/* UIMM16()::
	IMM_WIDTH=16 UIMM0[iiiiiiiiiiiiiiii]=*  ->	emit uimm0=iiiiiiiiiiiiiiii emit_type=letters nbits=16
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_UIMM16;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_BRDISPz_EMIT(xed_encoder_request_t* xes)
{
/* BRDISPz()::
	BRDISP_WIDTH=16 EOSZ=1 DISP[dddddddddddddddd]=*  ->	emit disp=dddddddddddddddd emit_type=letters nbits=16
	BRDISP_WIDTH=32 EOSZ=2 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit disp=dddddddddddddddddddddddddddddddd emit_type=letters nbits=32
	BRDISP_WIDTH=32 EOSZ=3 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit disp=dddddddddddddddddddddddddddddddd emit_type=letters nbits=32
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_BRDISPz;
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_UIMM8_EMIT(xed_encoder_request_t* xes)
{
/* UIMM8()::
	IMM_WIDTH=8 UIMM0[iiiiiiii]=*  ->	emit uimm0=iiiiiiii emit_type=letters nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_UIMM8;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_BRDISP8_EMIT(xed_encoder_request_t* xes)
{
/* BRDISP8()::
	BRDISP_WIDTH=8 DISP[dddddddd]=*  ->	emit disp=dddddddd emit_type=letters nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_BRDISP8;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
