/// @file xed-classifiers.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
xed_bool_t xed_classify_avx512(const xed_decoded_inst_t* d)
{
    const xed_isa_set_enum_t isa_set = xed_decoded_inst_get_isa_set(d);
    switch(isa_set) {
    case XED_ISA_SET_AVX512F_KOP:
    case XED_ISA_SET_AVX512_VPOPCNTDQ_256:
    case XED_ISA_SET_AVX512F_256:
    case XED_ISA_SET_AVX512_GFNI_512:
    case XED_ISA_SET_AVX512PF_512:
    case XED_ISA_SET_AVX512BW_KOP:
    case XED_ISA_SET_AVX512F_SCALAR:
    case XED_ISA_SET_AVX512_4VNNIW_512:
    case XED_ISA_SET_AVX512_4FMAPS_512:
    case XED_ISA_SET_AVX512_VNNI_256:
    case XED_ISA_SET_AVX512_GFNI_128:
    case XED_ISA_SET_AVX512DQ_512:
    case XED_ISA_SET_AVX512_VAES_512:
    case XED_ISA_SET_AVX512DQ_256:
    case XED_ISA_SET_AVX512DQ_128:
    case XED_ISA_SET_AVX512_VBMI_256:
    case XED_ISA_SET_AVX512_VNNI_128:
    case XED_ISA_SET_AVX512_VPCLMULQDQ_512:
    case XED_ISA_SET_AVX512DQ_128N:
    case XED_ISA_SET_AVX512_BITALG_256:
    case XED_ISA_SET_AVX512_VBMI2_128:
    case XED_ISA_SET_AVX512F_128:
    case XED_ISA_SET_AVX512_VPOPCNTDQ_512:
    case XED_ISA_SET_AVX512_VAES_128:
    case XED_ISA_SET_AVX512BW_128N:
    case XED_ISA_SET_AVX512ER_SCALAR:
    case XED_ISA_SET_AVX512_VNNI_512:
    case XED_ISA_SET_AVX512_VPOPCNTDQ_128:
    case XED_ISA_SET_AVX512_GFNI_256:
    case XED_ISA_SET_AVX512_IFMA_256:
    case XED_ISA_SET_AVX512_VBMI2_256:
    case XED_ISA_SET_AVX512F_128N:
    case XED_ISA_SET_AVX512_VBMI2_512:
    case XED_ISA_SET_AVX512_VAES_256:
    case XED_ISA_SET_AVX512_BITALG_512:
    case XED_ISA_SET_AVX512ER_512:
    case XED_ISA_SET_AVX512_BITALG_128:
    case XED_ISA_SET_AVX512DQ_SCALAR:
    case XED_ISA_SET_AVX512_VPCLMULQDQ_256:
    case XED_ISA_SET_AVX512_IFMA_128:
    case XED_ISA_SET_AVX512CD_512:
    case XED_ISA_SET_AVX512F_512:
    case XED_ISA_SET_AVX512_VBMI_512:
    case XED_ISA_SET_AVX512CD_256:
    case XED_ISA_SET_AVX512CD_128:
    case XED_ISA_SET_AVX512_4FMAPS_SCALAR:
    case XED_ISA_SET_AVX512BW_512:
    case XED_ISA_SET_AVX512_VPCLMULQDQ_128:
    case XED_ISA_SET_AVX512BW_256:
    case XED_ISA_SET_AVX512DQ_KOP:
    case XED_ISA_SET_AVX512_IFMA_512:
    case XED_ISA_SET_AVX512BW_128:
    case XED_ISA_SET_AVX512_VBMI_128:
       return 1;
    default:
       return 0;
    }
}
xed_bool_t xed_classify_avx512_maskop(const xed_decoded_inst_t* d)
{
    const xed_isa_set_enum_t isa_set = xed_decoded_inst_get_isa_set(d);
    switch(isa_set) {
    case XED_ISA_SET_AVX512F_KOP:
    case XED_ISA_SET_AVX512BW_KOP:
    case XED_ISA_SET_AVX512DQ_KOP:
       return 1;
    default:
       return 0;
    }
}
xed_bool_t xed_classify_avx(const xed_decoded_inst_t* d)
{
    const xed_isa_set_enum_t isa_set = xed_decoded_inst_get_isa_set(d);
    switch(isa_set) {
    case XED_ISA_SET_AVX2:
    case XED_ISA_SET_AVX2GATHER:
    case XED_ISA_SET_AVX:
    case XED_ISA_SET_F16C:
    case XED_ISA_SET_AVX_GFNI:
    case XED_ISA_SET_AVXAES:
    case XED_ISA_SET_FMA:
       return 1;
    default:
       return 0;
    }
}
xed_bool_t xed_classify_sse(const xed_decoded_inst_t* d)
{
    const xed_isa_set_enum_t isa_set = xed_decoded_inst_get_isa_set(d);
    switch(isa_set) {
    case XED_ISA_SET_SSE4:
    case XED_ISA_SET_AES:
    case XED_ISA_SET_SSE3:
    case XED_ISA_SET_SSE2:
    case XED_ISA_SET_SSEMXCSR:
    case XED_ISA_SET_SSE4A:
    case XED_ISA_SET_PCLMULQDQ:
    case XED_ISA_SET_SSSE3:
    case XED_ISA_SET_SSE42:
    case XED_ISA_SET_SSE:
       return 1;
    default:
       return 0;
    }
}
