/// @file xed-cpuid-tables.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
const xed_cpuid_rec_t xed_cpuid_info[] = {
/* INVALID            */ { 0x0, 0, 0, XED_REG_INVALID },
/* ADOXADCX           */ { 0x7, 0, 19, XED_REG_EBX },
/* AES                */ { 0x1, 0, 25, XED_REG_ECX },
/* AVX                */ { 0x1, 0, 28, XED_REG_ECX },
/* AVX2               */ { 0x7, 0, 5, XED_REG_EBX },
/* AVX512BW           */ { 0x7, 0, 30, XED_REG_EBX },
/* AVX512CD           */ { 0x7, 0, 28, XED_REG_EBX },
/* AVX512DQ           */ { 0x7, 0, 17, XED_REG_EBX },
/* AVX512ER           */ { 0x7, 0, 27, XED_REG_EBX },
/* AVX512F            */ { 0x7, 0, 16, XED_REG_EBX },
/* AVX512IFMA         */ { 0x7, 0, 21, XED_REG_EBX },
/* AVX512PF           */ { 0x7, 0, 26, XED_REG_EBX },
/* AVX512VBMI         */ { 0x7, 0, 1, XED_REG_ECX },
/* AVX512VL           */ { 0x7, 0, 31, XED_REG_EBX },
/* AVX512_4FMAPS      */ { 0x7, 0, 3, XED_REG_EDX },
/* AVX512_4VNNIW      */ { 0x7, 0, 2, XED_REG_EDX },
/* AVX512_BITALG      */ { 0x7, 0, 12, XED_REG_ECX },
/* AVX512_VBMI2       */ { 0x7, 0, 6, XED_REG_ECX },
/* AVX512_VNNI        */ { 0x7, 0, 11, XED_REG_ECX },
/* AVX512_VPOPCNTDQ   */ { 0x7, 0, 14, XED_REG_ECX },
/* BMI1               */ { 0x7, 0, 3, XED_REG_EBX },
/* BMI2               */ { 0x7, 0, 8, XED_REG_EBX },
/* CET                */ { 0x7, 0, 7, XED_REG_ECX },
/* CLDEMOTE           */ { 0x7, 0, 25, XED_REG_ECX },
/* CLFLUSH            */ { 0x1, 0, 19, XED_REG_EDX },
/* CLFLUSHOPT         */ { 0x7, 0, 23, XED_REG_EBX },
/* CLWB               */ { 0x7, 0, 24, XED_REG_EBX },
/* CMPXCHG16B         */ { 0x1, 0, 13, XED_REG_ECX },
/* F16C               */ { 0x1, 0, 29, XED_REG_ECX },
/* FMA                */ { 0x1, 0, 12, XED_REG_ECX },
/* FXSAVE             */ { 0x1, 0, 24, XED_REG_EDX },
/* GFNI               */ { 0x7, 0, 8, XED_REG_ECX },
/* INTEL64            */ { 0x80000001, 0, 29, XED_REG_EDX },
/* INTELPT            */ { 0x7, 0, 25, XED_REG_EBX },
/* INVPCID            */ { 0x7, 0, 10, XED_REG_EBX },
/* LAHF               */ { 0x80000001, 0, 0, XED_REG_ECX },
/* LZCNT              */ { 0x80000001, 0, 5, XED_REG_ECX },
/* MONITOR            */ { 0x1, 0, 3, XED_REG_ECX },
/* MONITORX           */ { 0x80000001, 0, 29, XED_REG_ECX },
/* MOVDIR64B          */ { 0x7, 0, 28, XED_REG_ECX },
/* MOVDIRI            */ { 0x7, 0, 27, XED_REG_ECX },
/* MOVEBE             */ { 0x1, 0, 22, XED_REG_ECX },
/* MPX                */ { 0x7, 0, 14, XED_REG_EBX },
/* OSPKU              */ { 0x7, 0, 4, XED_REG_ECX },
/* OSXSAVE            */ { 0x1, 0, 27, XED_REG_ECX },
/* PCLMULQDQ          */ { 0x1, 0, 1, XED_REG_ECX },
/* PCONFIG            */ { 0x7, 0, 18, XED_REG_EDX },
/* PKU                */ { 0x7, 0, 3, XED_REG_ECX },
/* POPCNT             */ { 0x1, 0, 23, XED_REG_ECX },
/* PREFETCHW          */ { 0x80000001, 0, 8, XED_REG_ECX },
/* PREFETCHWT1        */ { 0x7, 0, 0, XED_REG_ECX },
/* PTWRITE            */ { 0x14, 0, 4, XED_REG_EBX },
/* RDP                */ { 0x7, 0, 22, XED_REG_ECX },
/* RDRAND             */ { 0x1, 0, 30, XED_REG_ECX },
/* RDSEED             */ { 0x7, 0, 18, XED_REG_EBX },
/* RDTSCP             */ { 0x80000001, 0, 27, XED_REG_EDX },
/* RDWRFSGS           */ { 0x7, 0, 0, XED_REG_EBX },
/* RTM                */ { 0x7, 0, 11, XED_REG_EBX },
/* SGX                */ { 0x7, 0, 2, XED_REG_EBX },
/* SHA                */ { 0x7, 0, 29, XED_REG_EBX },
/* SMAP               */ { 0x7, 0, 20, XED_REG_EBX },
/* SMX                */ { 0x1, 0, 6, XED_REG_ECX },
/* SSE                */ { 0x1, 0, 25, XED_REG_EDX },
/* SSE2               */ { 0x1, 0, 26, XED_REG_EDX },
/* SSE3               */ { 0x1, 0, 0, XED_REG_ECX },
/* SSE4               */ { 0x1, 0, 19, XED_REG_ECX },
/* SSE42              */ { 0x1, 0, 20, XED_REG_ECX },
/* SSSE3              */ { 0x1, 0, 9, XED_REG_ECX },
/* VAES               */ { 0x7, 0, 9, XED_REG_ECX },
/* VMX                */ { 0x1, 0, 5, XED_REG_ECX },
/* VPCLMULQDQ         */ { 0x7, 0, 10, XED_REG_ECX },
/* WAITPKG            */ { 0x7, 0, 5, XED_REG_ECX },
/* WBNOINVD           */ { 0x80000008, 0, 9, XED_REG_ECX },
/* XSAVE              */ { 0x1, 0, 26, XED_REG_ECX },
/* XSAVEC             */ { 0xD, 1, 1, XED_REG_EAX },
/* XSAVEOPT           */ { 0xD, 1, 0, XED_REG_EAX },
/* XSAVES             */ { 0xD, 1, 3, XED_REG_EAX },
};
const xed_cpuid_bit_enum_t xed_isa_set_to_cpuid_mapping[][XED_MAX_CPUID_BITS_PER_ISA_SET] = {
/* INVALID */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* 3DNOW */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* ADOX_ADCX */ { XED_CPUID_BIT_ADOXADCX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AES */ { XED_CPUID_BIT_AES, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AMD */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX */ { XED_CPUID_BIT_AVX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX2 */ { XED_CPUID_BIT_AVX2, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX2GATHER */ { XED_CPUID_BIT_AVX2, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512BW_128 */ { XED_CPUID_BIT_AVX512BW, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512BW_128N */ { XED_CPUID_BIT_AVX512BW, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512BW_256 */ { XED_CPUID_BIT_AVX512BW, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512BW_512 */ { XED_CPUID_BIT_AVX512BW, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512BW_KOP */ { XED_CPUID_BIT_AVX512BW, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512CD_128 */ { XED_CPUID_BIT_AVX512CD, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512CD_256 */ { XED_CPUID_BIT_AVX512CD, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512CD_512 */ { XED_CPUID_BIT_AVX512CD, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512DQ_128 */ { XED_CPUID_BIT_AVX512DQ, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512DQ_128N */ { XED_CPUID_BIT_AVX512DQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512DQ_256 */ { XED_CPUID_BIT_AVX512DQ, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512DQ_512 */ { XED_CPUID_BIT_AVX512DQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512DQ_KOP */ { XED_CPUID_BIT_AVX512DQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512DQ_SCALAR */ { XED_CPUID_BIT_AVX512DQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512ER_512 */ { XED_CPUID_BIT_AVX512ER, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512ER_SCALAR */ { XED_CPUID_BIT_AVX512ER, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512F_128 */ { XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512F_128N */ { XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512F_256 */ { XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512F_512 */ { XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512F_KOP */ { XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512F_SCALAR */ { XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512PF_512 */ { XED_CPUID_BIT_AVX512PF, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_4FMAPS_512 */ { XED_CPUID_BIT_AVX512_4FMAPS, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_4FMAPS_SCALAR */ { XED_CPUID_BIT_AVX512_4FMAPS, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_4VNNIW_512 */ { XED_CPUID_BIT_AVX512_4VNNIW, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_BITALG_128 */ { XED_CPUID_BIT_AVX512_BITALG, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_BITALG_256 */ { XED_CPUID_BIT_AVX512_BITALG, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_BITALG_512 */ { XED_CPUID_BIT_AVX512_BITALG, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_GFNI_128 */ { XED_CPUID_BIT_GFNI, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID  } ,
/* AVX512_GFNI_256 */ { XED_CPUID_BIT_GFNI, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID  } ,
/* AVX512_GFNI_512 */ { XED_CPUID_BIT_GFNI, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_IFMA_128 */ { XED_CPUID_BIT_AVX512IFMA, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_IFMA_256 */ { XED_CPUID_BIT_AVX512IFMA, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_IFMA_512 */ { XED_CPUID_BIT_AVX512IFMA, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VAES_128 */ { XED_CPUID_BIT_VAES, XED_CPUID_BIT_AES, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL  } ,
/* AVX512_VAES_256 */ { XED_CPUID_BIT_VAES, XED_CPUID_BIT_AES, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL  } ,
/* AVX512_VAES_512 */ { XED_CPUID_BIT_VAES, XED_CPUID_BIT_AES, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VBMI2_128 */ { XED_CPUID_BIT_AVX512_VBMI2, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VBMI2_256 */ { XED_CPUID_BIT_AVX512_VBMI2, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VBMI2_512 */ { XED_CPUID_BIT_AVX512_VBMI2, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VBMI_128 */ { XED_CPUID_BIT_AVX512VBMI, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VBMI_256 */ { XED_CPUID_BIT_AVX512VBMI, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VBMI_512 */ { XED_CPUID_BIT_AVX512VBMI, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VNNI_128 */ { XED_CPUID_BIT_AVX512_VNNI, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VNNI_256 */ { XED_CPUID_BIT_AVX512_VNNI, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VNNI_512 */ { XED_CPUID_BIT_AVX512_VNNI, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VPCLMULQDQ_128 */ { XED_CPUID_BIT_VPCLMULQDQ, XED_CPUID_BIT_PCLMULQDQ, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL  } ,
/* AVX512_VPCLMULQDQ_256 */ { XED_CPUID_BIT_VPCLMULQDQ, XED_CPUID_BIT_PCLMULQDQ, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_AVX512VL  } ,
/* AVX512_VPCLMULQDQ_512 */ { XED_CPUID_BIT_VPCLMULQDQ, XED_CPUID_BIT_PCLMULQDQ, XED_CPUID_BIT_AVX512F, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VPOPCNTDQ_128 */ { XED_CPUID_BIT_AVX512_VPOPCNTDQ, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VPOPCNTDQ_256 */ { XED_CPUID_BIT_AVX512_VPOPCNTDQ, XED_CPUID_BIT_AVX512VL, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX512_VPOPCNTDQ_512 */ { XED_CPUID_BIT_AVX512_VPOPCNTDQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVXAES */ { XED_CPUID_BIT_AES, XED_CPUID_BIT_AVX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* AVX_GFNI */ { XED_CPUID_BIT_GFNI, XED_CPUID_BIT_AVX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* BMI1 */ { XED_CPUID_BIT_BMI1, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* BMI2 */ { XED_CPUID_BIT_BMI2, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CET */ { XED_CPUID_BIT_CET, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CLDEMOTE */ { XED_CPUID_BIT_CLDEMOTE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CLFLUSHOPT */ { XED_CPUID_BIT_CLFLUSHOPT, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CLFSH */ { XED_CPUID_BIT_CLFLUSH, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CLWB */ { XED_CPUID_BIT_CLWB, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CLZERO */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CMOV */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* CMPXCHG16B */ { XED_CPUID_BIT_CMPXCHG16B, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* ENCLV */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* F16C */ { XED_CPUID_BIT_F16C, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* FAT_NOP */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* FCMOV */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* FMA */ { XED_CPUID_BIT_FMA, XED_CPUID_BIT_AVX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* FMA4 */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* FXSAVE */ { XED_CPUID_BIT_FXSAVE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* FXSAVE64 */ { XED_CPUID_BIT_FXSAVE, XED_CPUID_BIT_INTEL64, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* GFNI */ { XED_CPUID_BIT_GFNI, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I186 */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I286PROTECTED */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I286REAL */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I386 */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I486 */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I486REAL */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* I86 */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* INVPCID */ { XED_CPUID_BIT_INVPCID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* LAHF */ { XED_CPUID_BIT_LAHF, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* LONGMODE */ { XED_CPUID_BIT_INTEL64, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* LZCNT */ { XED_CPUID_BIT_LZCNT, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* MONITOR */ { XED_CPUID_BIT_MONITOR, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* MONITORX */ { XED_CPUID_BIT_MONITORX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* MOVBE */ { XED_CPUID_BIT_MOVEBE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* MOVDIR */ { XED_CPUID_BIT_MOVDIRI, XED_CPUID_BIT_MOVDIR64B, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* MPX */ { XED_CPUID_BIT_MPX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PAUSE */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PCLMULQDQ */ { XED_CPUID_BIT_PCLMULQDQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PCONFIG */ { XED_CPUID_BIT_PCONFIG, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PENTIUMMMX */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PENTIUMREAL */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PKU */ { XED_CPUID_BIT_PKU, XED_CPUID_BIT_OSPKU, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* POPCNT */ { XED_CPUID_BIT_POPCNT, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PPRO */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PREFETCHW */ { XED_CPUID_BIT_PREFETCHW, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PREFETCHWT1 */ { XED_CPUID_BIT_PREFETCHWT1, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PREFETCH_NOP */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* PT */ { XED_CPUID_BIT_INTELPT, XED_CPUID_BIT_PTWRITE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RDPID */ { XED_CPUID_BIT_RDP, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RDPMC */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RDRAND */ { XED_CPUID_BIT_RDRAND, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RDSEED */ { XED_CPUID_BIT_RDSEED, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RDTSCP */ { XED_CPUID_BIT_RDTSCP, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RDWRFSGS */ { XED_CPUID_BIT_RDWRFSGS, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* RTM */ { XED_CPUID_BIT_RTM, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SGX */ { XED_CPUID_BIT_SGX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SGX_ENCLV */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SHA */ { XED_CPUID_BIT_SHA, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SMAP */ { XED_CPUID_BIT_SMAP, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SMX */ { XED_CPUID_BIT_SMX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE */ { XED_CPUID_BIT_SSE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE2 */ { XED_CPUID_BIT_SSE2, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE2MMX */ { XED_CPUID_BIT_SSE2, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE3 */ { XED_CPUID_BIT_SSE3, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE3X87 */ { XED_CPUID_BIT_SSE3, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE4 */ { XED_CPUID_BIT_SSE4, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE42 */ { XED_CPUID_BIT_SSE42, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE4A */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSEMXCSR */ { XED_CPUID_BIT_SSE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSE_PREFETCH */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSSE3 */ { XED_CPUID_BIT_SSSE3, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SSSE3MMX */ { XED_CPUID_BIT_SSSE3, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* SVM */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* TBM */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* VAES */ { XED_CPUID_BIT_VAES, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* VMFUNC */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* VPCLMULQDQ */ { XED_CPUID_BIT_VPCLMULQDQ, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* VTX */ { XED_CPUID_BIT_VMX, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* WAITPKG */ { XED_CPUID_BIT_WAITPKG, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* WBNOINVD */ { XED_CPUID_BIT_WBNOINVD, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* X87 */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* XOP */ { XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* XSAVE */ { XED_CPUID_BIT_XSAVE, XED_CPUID_BIT_OSXSAVE, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* XSAVEC */ { XED_CPUID_BIT_XSAVEC, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* XSAVEOPT */ { XED_CPUID_BIT_XSAVEOPT, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
/* XSAVES */ { XED_CPUID_BIT_XSAVES, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID, XED_CPUID_BIT_INVALID  } ,
};
