/// @file xed-encoder-0.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-encoder.h"
#include "xed-encode-private.h"
#include "xed-enc-operand-lu.h"
#include "xed-operand-accessors.h"
xed_bool_t xed_encode_nonterminal_VMODRM_XMM_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VSIB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_UISA_VMODRM_ZMM_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VSIB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_NEWVEX3_ENC_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VEX_TYPE_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXR_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXXB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_MAP_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REG_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_ESCVL_ENC_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_XOP_ENC_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_XOP_TYPE_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXR_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_XOP_REXXB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_XOP_MAP_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REG_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_ESCVL_ENC_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_MODRM_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_SIB_REQUIRED_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SIBSCALE_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SIBINDEX_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SIBBASE_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_MODRM_RM_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_MODRM_MOD_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SIB_NT_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_UISA_VMODRM_ZMM_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VMODRM_MOD_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BASE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_UISA_ENC_INDEX_ZMM_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_SCALE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_NEWVEX_ENC_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VEX_TYPE_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXR_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXXB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_MAP_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REG_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_ESCVL_ENC_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_UISA_VMODRM_YMM_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VMODRM_MOD_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BASE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_UISA_ENC_INDEX_YMM_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_SCALE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_VMODRM_YMM_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VSIB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_XOP_ENC_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_XOP_TYPE_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXR_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_XOP_REXXB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_XOP_MAP_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REG_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_ESCVL_ENC_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_UISA_VMODRM_XMM_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VMODRM_MOD_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BASE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_UISA_ENC_INDEX_XMM_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_SCALE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_ISA_ENCODE(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_ISA_BINDINGS(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_ISA_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_UISA_VMODRM_YMM_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VSIB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_EVEX_ENC_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_EVEX_62_REXR_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXX_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXRR_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_MAP_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXW_VVVV_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_UPP_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_LL_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_AVX512_EVEX_BYTE3_ENC_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_NEWVEX3_ENC_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VEX_TYPE_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXR_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXXB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_MAP_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REG_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_ESCVL_ENC_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_ISA_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_PREFIX_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEXED_REX_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_INSTRUCTIONS_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_NEWVEX_ENC_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VEX_TYPE_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXR_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REXXB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_MAP_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_REG_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEX_ESCVL_ENC_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_MODRM_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_SIB_NT_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_UISA_VMODRM_XMM_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VSIB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_VMODRM_YMM_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VMODRM_MOD_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BASE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_INDEX_YMM_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_SCALE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_EVEX_ENC_EMIT(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_EVEX_62_REXR_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXX_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXB_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXRR_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_MAP_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_REXW_VVVV_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_UPP_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_EVEX_LL_ENC_EMIT(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_AVX512_EVEX_BYTE3_ENC_EMIT(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_ISA_BINDINGS(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_FIXUP_EOSZ_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_FIXUP_EASZ_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_ASZ_NONTERM_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_INSTRUCTIONS_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_OSZ_NONTERM_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_PREFIX_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VEXED_REX_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_bool_t xed_encode_nonterminal_VMODRM_XMM_BIND(xed_encoder_request_t* xes)
{
xed_bool_t okay;
okay = xed_encode_nonterminal_VMODRM_MOD_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BASE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_INDEX_XMM_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_SCALE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_VSIB_ENC_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_SEGMENT_ENCODE_BIND(xes);
if (!okay) return 0;
okay = xed_encode_nonterminal_DISP_NT_BIND(xes);
if (!okay) return 0;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE1_SUBDWORD_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_UISA_ENC_INDEX_XMM_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t rexx ;xed_int8_t sibindex ;xed_int8_t vexdest4;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(178)=0 INDEX=XED_REG_XMM0  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0,0},
/*h(179)=1 INDEX=XED_REG_XMM1  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1,0},
/*h(180)=2 INDEX=XED_REG_XMM2  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2,0},
/*h(181)=3 INDEX=XED_REG_XMM3  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3,0},
/*h(182)=4 INDEX=XED_REG_XMM4  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4,0},
/*h(183)=5 INDEX=XED_REG_XMM5  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5,0},
/*h(184)=6 INDEX=XED_REG_XMM6  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6,0},
/*h(185)=7 INDEX=XED_REG_XMM7  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7,0},
/*h(186)=8 INDEX=XED_REG_XMM8  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0,0},
/*h(187)=9 INDEX=XED_REG_XMM9  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1,0},
/*h(188)=10 INDEX=XED_REG_XMM10  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2,0},
/*h(189)=11 INDEX=XED_REG_XMM11  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3,0},
/*h(190)=12 INDEX=XED_REG_XMM12  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4,0},
/*h(191)=13 INDEX=XED_REG_XMM13  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5,0},
/*h(192)=14 INDEX=XED_REG_XMM14  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6,0},
/*h(193)=15 INDEX=XED_REG_XMM15  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7,0},
/*h(194)=16 INDEX=XED_REG_XMM16  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0,1},
/*h(195)=17 INDEX=XED_REG_XMM17  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1,1},
/*h(196)=18 INDEX=XED_REG_XMM18  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2,1},
/*h(197)=19 INDEX=XED_REG_XMM19  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3,1},
/*h(198)=20 INDEX=XED_REG_XMM20  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4,1},
/*h(199)=21 INDEX=XED_REG_XMM21  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5,1},
/*h(200)=22 INDEX=XED_REG_XMM22  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6,1},
/*h(201)=23 INDEX=XED_REG_XMM23  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7,1},
/*h(202)=24 INDEX=XED_REG_XMM24  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0,1},
/*h(203)=25 INDEX=XED_REG_XMM25  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1,1},
/*h(204)=26 INDEX=XED_REG_XMM26  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2,1},
/*h(205)=27 INDEX=XED_REG_XMM27  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3,1},
/*h(206)=28 INDEX=XED_REG_XMM28  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4,1},
/*h(207)=29 INDEX=XED_REG_XMM29  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5,1},
/*h(208)=30 INDEX=XED_REG_XMM30  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6,1},
/*h(209)=31 INDEX=XED_REG_XMM31  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_INDEX(xes);
hidx = key - 178;
if(hidx <= 31) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    xed3_operand_set_vexdest4(xes,lu_table[hidx].vexdest4);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_SIB_NT_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(0)=0 SIB=0  ->	nothing*/ {0},
/*h(1)=1 SIB=1 SIBBASE[bbb]=* SIBSCALE[ss]=* SIBINDEX[iii]=*  ->	emit ss_iii_bbb emit_type=letters nbits=8*/ {2}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SIB(xes);
hidx = key - 0;
if(hidx <= 1) {
    xed_encoder_request_iforms(xes)->x_SIB_NT=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_EIGHTHMEM_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA32_DISP0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t disp ;xed_int8_t disp_width ;xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[24] = {
/*h(566)=0 BASE0=XED_REG_ESP MODE=1  ->	FB MOD=0 value=0x0*/ {566, -1,-1,0},
/*h(1075)=1 BASE0=XED_REG_ECX MODE=2  ->	FB MOD=0 value=0x0*/ {1075, -1,-1,0},
/*h(1080)=2 BASE0=XED_REG_ESI MODE=2  ->	FB MOD=0 value=0x0*/ {1080, -1,-1,0},
/*h(1085)=3 BASE0=XED_REG_R11D MODE=2  ->	FB MOD=0 value=0x0*/ {1085, -1,-1,0},
/*h(562)=4 BASE0=XED_REG_EAX MODE=1  ->	FB MOD=0 value=0x0*/ {562, -1,-1,0},
/*h(567)=5 BASE0=XED_REG_EBP MODE=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0*/ {567, 0,8,1},
/*h(1076)=6 BASE0=XED_REG_EDX MODE=2  ->	FB MOD=0 value=0x0*/ {1076, -1,-1,0},
/*h(1081)=7 BASE0=XED_REG_EDI MODE=2  ->	FB MOD=0 value=0x0*/ {1081, -1,-1,0},
/*h(1086)=8 BASE0=XED_REG_R12D MODE=2  ->	FB MOD=0 value=0x0*/ {1086, -1,-1,0},
/*h(563)=9 BASE0=XED_REG_ECX MODE=1  ->	FB MOD=0 value=0x0*/ {563, -1,-1,0},
/*h(568)=10 BASE0=XED_REG_ESI MODE=1  ->	FB MOD=0 value=0x0*/ {568, -1,-1,0},
/*h(1077)=11 BASE0=XED_REG_EBX MODE=2  ->	FB MOD=0 value=0x0*/ {1077, -1,-1,0},
/*h(1082)=12 BASE0=XED_REG_R8D MODE=2  ->	FB MOD=0 value=0x0*/ {1082, -1,-1,0},
/*h(1087)=13 BASE0=XED_REG_R13D MODE=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0*/ {1087, 0,8,1},
/*h(564)=14 BASE0=XED_REG_EDX MODE=1  ->	FB MOD=0 value=0x0*/ {564, -1,-1,0},
/*h(569)=15 BASE0=XED_REG_EDI MODE=1  ->	FB MOD=0 value=0x0*/ {569, -1,-1,0},
/*h(1078)=16 BASE0=XED_REG_ESP MODE=2  ->	FB MOD=0 value=0x0*/ {1078, -1,-1,0},
/*h(1083)=17 BASE0=XED_REG_R9D MODE=2  ->	FB MOD=0 value=0x0*/ {1083, -1,-1,0},
/*h(1088)=18 BASE0=XED_REG_R14D MODE=2  ->	FB MOD=0 value=0x0*/ {1088, -1,-1,0},
/*h(565)=19 BASE0=XED_REG_EBX MODE=1  ->	FB MOD=0 value=0x0*/ {565, -1,-1,0},
/*h(1074)=20 BASE0=XED_REG_EAX MODE=2  ->	FB MOD=0 value=0x0*/ {1074, -1,-1,0},
/*h(1079)=21 BASE0=XED_REG_EBP MODE=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0*/ {1079, 0,8,1},
/*h(1084)=22 BASE0=XED_REG_R10D MODE=2  ->	FB MOD=0 value=0x0*/ {1084, -1,-1,0},
/*h(1089)=23 BASE0=XED_REG_R15D MODE=2  ->	FB MOD=0 value=0x0*/ {1089, -1,-1,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0_MODE(xes);
hidx = ((5*key % 107) % 24);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].disp >= 0) xed3_operand_set_disp(xes,lu_table[hidx].disp);
    if(lu_table[hidx].disp_width >= 0) xed3_operand_set_disp_width(xes,lu_table[hidx].disp_width);
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_OVERRIDE_SEG1_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t seg_ovd;} lu_entry_t;
static const lu_entry_t lu_table[12] = {
/*h(0)=0 SEG1=@  ->	FB SEG_OVD=0 value=0x0*/ {0, 0},
/*h(149)=1 SEG1=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3*/ {149, 3},
/*empty slot1 */ {0,0},
/*h(151)=3 SEG1=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4*/ {151, 4},
/*empty slot1 */ {0,0},
/*h(148)=5 SEG1=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0*/ {148, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(150)=8 SEG1=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6*/ {150, 6},
/*empty slot1 */ {0,0},
/*h(147)=10 SEG1=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1*/ {147, 1},
/*h(152)=11 SEG1=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5*/ {152, 5}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SEG1(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 12ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_OVERRIDE_SEG0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t seg_ovd;} lu_entry_t;
static const lu_entry_t lu_table[12] = {
/*h(0)=0 SEG0=@  ->	FB SEG_OVD=0 value=0x0*/ {0, 0},
/*h(149)=1 SEG0=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3*/ {149, 3},
/*empty slot1 */ {0,0},
/*h(151)=3 SEG0=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4*/ {151, 4},
/*empty slot1 */ {0,0},
/*h(148)=5 SEG0=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0*/ {148, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(150)=8 SEG0=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6*/ {150, 6},
/*empty slot1 */ {0,0},
/*h(147)=10 SEG0=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1*/ {147, 1},
/*h(152)=11 SEG0=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5*/ {152, 5}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SEG0(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 12ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_seg_ovd(xes,lu_table[hidx].seg_ovd);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_SIBBASE_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(0)=0 SIB=0  ->	nothing*/ {0},
/*h(1)=1 SIB=1  ->	nt NT[SIBBASE_ENCODE_SIB1]*/ {xed_encode_nonterminal_SIBBASE_ENCODE_SIB1_BIND}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_SIB(xes);
hidx = key - 0;
if(hidx <= 1) {
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_SIBBASE_ENCODE=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_VEX_ESCVL_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(0)=0 VL=0 VEX_PREFIX=0  ->	emit 0b000 emit_type=numeric value=0x0 nbits=3*/ {1},
/*h(1)=1 VL=0 VEX_PREFIX=1  ->	emit 0b001 emit_type=numeric value=0x1 nbits=3*/ {2},
/*h(2)=2 VL=0 VEX_PREFIX=2  ->	emit 0b011 emit_type=numeric value=0x3 nbits=3*/ {3},
/*h(3)=3 VL=0 VEX_PREFIX=3  ->	emit 0b010 emit_type=numeric value=0x2 nbits=3*/ {4},
/*h(4)=4 VL=1 VEX_PREFIX=0  ->	emit 0b100 emit_type=numeric value=0x4 nbits=3*/ {5},
/*h(5)=5 VL=1 VEX_PREFIX=1  ->	emit 0b101 emit_type=numeric value=0x5 nbits=3*/ {6},
/*h(6)=6 VL=1 VEX_PREFIX=2  ->	emit 0b111 emit_type=numeric value=0x7 nbits=3*/ {7},
/*h(7)=7 VL=1 VEX_PREFIX=3  ->	emit 0b110 emit_type=numeric value=0x6 nbits=3*/ {8}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_VEX_PREFIX_VL(xes);
hidx = key - 0;
if(hidx <= 7) {
    xed_encoder_request_iforms(xes)->x_VEX_ESCVL_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_SIBSCALE_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t sibscale;} lu_entry_t;
static const lu_entry_t lu_table[30] = {
/*h(0)=0 SIB=0  ->	nothing*/ {0, -1},
/*h(13)=1 SIB=0  ->	nothing*/ {13, -1},
/*h(5)=2 SIB=0  ->	nothing*/ {5, -1},
/*h(18)=3 SIB=1 SCALE=2  ->	FB SIBSCALE=1 value=0x1*/ {18, 1},
/*empty slot1 */ {0,0},
/*h(10)=5 SIB=0  ->	nothing*/ {10, -1},
/*empty slot1 */ {0,0},
/*h(2)=7 SIB=0  ->	nothing*/ {2, -1},
/*h(15)=8 SIB=0  ->	nothing*/ {15, -1},
/*h(7)=9 SIB=0  ->	nothing*/ {7, -1},
/*h(20)=10 SIB=1 SCALE=4  ->	FB SIBSCALE=2 value=0x2*/ {20, 2},
/*empty slot1 */ {0,0},
/*h(12)=12 SIB=0  ->	nothing*/ {12, -1},
/*empty slot1 */ {0,0},
/*h(4)=14 SIB=0  ->	nothing*/ {4, -1},
/*h(17)=15 SIB=1 SCALE=1  ->	FB SIBSCALE=0 value=0x0*/ {17, 0},
/*h(9)=16 SIB=0  ->	nothing*/ {9, -1},
/*empty slot1 */ {0,0},
/*h(1)=18 SIB=0  ->	nothing*/ {1, -1},
/*h(14)=19 SIB=0  ->	nothing*/ {14, -1},
/*empty slot1 */ {0,0},
/*h(6)=21 SIB=0  ->	nothing*/ {6, -1},
/*empty slot1 */ {0,0},
/*h(11)=23 SIB=0  ->	nothing*/ {11, -1},
/*h(24)=24 SIB=1 SCALE=8  ->	FB SIBSCALE=3 value=0x3*/ {24, 3},
/*h(3)=25 SIB=0  ->	nothing*/ {3, -1},
/*h(16)=26 SIB=1 SCALE=0  ->	FB SIBSCALE=0 value=0x0*/ {16, 0},
/*empty slot1 */ {0,0},
/*h(8)=28 SIB=0  ->	nothing*/ {8, -1},
/*empty slot1 */ {0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SCALE_SIB(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 30ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].sibscale >= 0) xed3_operand_set_sibscale(xes,lu_table[hidx].sibscale);
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE1_4X_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_OSZ_NONTERM_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error ;xed_int8_t osz ;xed_int8_t rexw;} lu_entry_t;
static const lu_entry_t lu_table[109] = {
/*h(109)=0 MODE=2 EOSZ=3 DF64=0 SKIP_OSZ=1  ->	nothing*/ {109, -1,-1,-1},
/*h(73)=1 MODE=0 EOSZ=2 DF32=1  ->	nothing*/ {73, -1,-1,-1},
/*h(37)=2 MODE=2 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {37, -1,1,-1},
/*h(110)=3 MODE=2 EOSZ=3 DF64=1  ->	nothing*/ {110, -1,-1,-1},
/*h(74)=4 MODE=0 EOSZ=2 DF32=0 SKIP_OSZ=1  ->	nothing*/ {74, -1,-1,-1},
/*h(38)=5 MODE=2 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {38, -1,1,-1},
/*h(111)=6 MODE=2 EOSZ=3 DF64=1  ->	nothing*/ {111, -1,-1,-1},
/*h(75)=7 MODE=0 EOSZ=2 DF32=1  ->	nothing*/ {75, -1,-1,-1},
/*h(39)=8 MODE=2 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {39, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(40)=11 MODE=2 EOSZ=2 DF64=0  ->	nothing*/ {40, -1,-1,-1},
/*h(4)=12 MODE=0 EOSZ=1  ->	nothing*/ {4, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(41)=14 MODE=2 EOSZ=2 DF64=0  ->	nothing*/ {41, -1,-1,-1},
/*h(5)=15 MODE=0 EOSZ=1  ->	nothing*/ {5, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(42)=17 MODE=2 EOSZ=2 DF64=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {42, XED_ERROR_GENERAL_ERROR,-1,-1},
/*h(6)=18 MODE=0 EOSZ=1  ->	nothing*/ {6, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(43)=20 MODE=2 EOSZ=2 DF64=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {43, XED_ERROR_GENERAL_ERROR,-1,-1},
/*h(7)=21 MODE=0 EOSZ=1  ->	nothing*/ {7, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(44)=23 MODE=2 EOSZ=3 DF64=0 SKIP_OSZ=0  ->	FB REXW=1 value=0x1*/ {44, -1,-1,1},
/*h(8)=24 MODE=0 EOSZ=2 DF32=0 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {8, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(45)=26 MODE=2 EOSZ=3 DF64=0 SKIP_OSZ=0  ->	FB REXW=1 value=0x1*/ {45, -1,-1,1},
/*h(9)=27 MODE=0 EOSZ=2 DF32=1  ->	nothing*/ {9, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(46)=29 MODE=2 EOSZ=3 DF64=1  ->	nothing*/ {46, -1,-1,-1},
/*h(10)=30 MODE=0 EOSZ=2 DF32=0 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {10, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(47)=32 MODE=2 EOSZ=3 DF64=1  ->	nothing*/ {47, -1,-1,-1},
/*h(11)=33 MODE=0 EOSZ=2 DF32=1  ->	nothing*/ {11, -1,-1,-1},
/*h(84)=34 MODE=1 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {84, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(85)=37 MODE=1 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {85, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(86)=40 MODE=1 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {86, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(87)=43 MODE=1 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {87, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(88)=46 MODE=1 EOSZ=2  ->	nothing*/ {88, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(89)=49 MODE=1 EOSZ=2  ->	nothing*/ {89, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(90)=52 MODE=1 EOSZ=2  ->	nothing*/ {90, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(91)=55 MODE=1 EOSZ=2  ->	nothing*/ {91, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(20)=60 MODE=1 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {20, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(21)=63 MODE=1 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {21, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(22)=66 MODE=1 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {22, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(23)=69 MODE=1 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {23, -1,1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(24)=72 MODE=1 EOSZ=2  ->	nothing*/ {24, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(25)=75 MODE=1 EOSZ=2  ->	nothing*/ {25, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(26)=78 MODE=1 EOSZ=2  ->	nothing*/ {26, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(27)=81 MODE=1 EOSZ=2  ->	nothing*/ {27, -1,-1,-1},
/*h(100)=82 MODE=2 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {100, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(101)=85 MODE=2 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {101, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(102)=88 MODE=2 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {102, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(103)=91 MODE=2 EOSZ=1 SKIP_OSZ=1  ->	nothing*/ {103, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(104)=94 MODE=2 EOSZ=2 DF64=0  ->	nothing*/ {104, -1,-1,-1},
/*h(68)=95 MODE=0 EOSZ=1  ->	nothing*/ {68, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(105)=97 MODE=2 EOSZ=2 DF64=0  ->	nothing*/ {105, -1,-1,-1},
/*h(69)=98 MODE=0 EOSZ=1  ->	nothing*/ {69, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(106)=100 MODE=2 EOSZ=2 DF64=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {106, XED_ERROR_GENERAL_ERROR,-1,-1},
/*h(70)=101 MODE=0 EOSZ=1  ->	nothing*/ {70, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(107)=103 MODE=2 EOSZ=2 DF64=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {107, XED_ERROR_GENERAL_ERROR,-1,-1},
/*h(71)=104 MODE=0 EOSZ=1  ->	nothing*/ {71, -1,-1,-1},
/*empty slot1 */ {0,0,0,0},
/*h(108)=106 MODE=2 EOSZ=3 DF64=0 SKIP_OSZ=1  ->	nothing*/ {108, -1,-1,-1},
/*h(72)=107 MODE=0 EOSZ=2 DF32=0 SKIP_OSZ=1  ->	nothing*/ {72, -1,-1,-1},
/*h(36)=108 MODE=2 EOSZ=1 SKIP_OSZ=0  ->	FB OSZ=1 value=0x1*/ {36, -1,1,-1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DF32_DF64_EOSZ_MODE_SKIP_OSZ(xes);
hidx = (3*key % 109);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    if(lu_table[hidx].osz >= 0) xed3_operand_set_osz(xes,lu_table[hidx].osz);
    if(lu_table[hidx].rexw >= 0) xed3_operand_set_rexw(xes,lu_table[hidx].rexw);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA32_DISP8_BIND(xed_encoder_request_t* xes)
{
xed3_operand_set_mod(xes,1);
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_REMOVE_SEGMENT_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(0)=0 AGEN=0  ->	nothing*/ {0},
/*h(1)=1 AGEN=1  ->	nt NT[REMOVE_SEGMENT_AGEN1]*/ {xed_encode_nonterminal_REMOVE_SEGMENT_AGEN1_BIND}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_AGEN(xes);
hidx = key - 0;
if(hidx <= 1) {
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_REMOVE_SEGMENT=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_BRANCH_HINT_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_FULL_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t bcrc;} lu_entry_t;
static const lu_entry_t lu_table[31] = {
/*h(1)=0 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(2)=1 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(3)=2 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(4)=3 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(5)=4 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(6)=5 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(7)=6 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(8)=7 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(9)=8 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(10)=9 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(11)=10 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(12)=11 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(13)=12 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(14)=13 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(15)=14 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(16)=15 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(17)=16 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(18)=17 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(19)=18 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(20)=19 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(21)=20 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(22)=21 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(23)=22 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(24)=23 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(25)=24 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(26)=25 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(27)=26 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(28)=27 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(29)=28 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(30)=29 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(31)=30 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BCAST(xes);
hidx = key - 1;
if(hidx <= 30) {
    xed3_operand_set_bcrc(xes,lu_table[hidx].bcrc);
    return 1;
}
else{
    xed3_operand_set_bcrc(xes,0);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_VEX_REG_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 MODE!=2 VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit 1_ddd emit_type=letters nbits=4*/ {2},
/*h(1)=1 MODE!=2 VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit 1_ddd emit_type=letters nbits=4*/ {2},
/*h(2)=2 MODE=2 VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit u_ddd emit_type=letters nbits=4*/ {3},
/*h(3)=3 MODE!=2 VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit 1_ddd emit_type=letters nbits=4*/ {2}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 3) {
    xed_encoder_request_iforms(xes)->x_VEX_REG_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE8_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(0)=0 DISP_WIDTH=0  ->	nothing*/ {0, },
/*empty slot1 */ {0},
/*empty slot1 */ {0},
/*h(32)=3 DISP_WIDTH=32  ->	nothing*/ {32, },
/*h(8)=4 DISP_WIDTH=8  ->	nothing*/ {8, }
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE4_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_8_32_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(8)=0 DISP_WIDTH=8  ->	nothing*/ {8, },
/*h(32)=1 DISP_WIDTH=32  ->	nothing*/ {32, }
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = ((3*key % 5) % 2);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_HALFMEM_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_SAE_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t bcrc;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(0)=0 SAE=0  ->	FB BCRC=0 value=0x0*/ {0},
/*h(1)=1 SAE=1  ->	FB BCRC=1 value=0x1*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SAE(xes);
hidx = key - 0;
if(hidx <= 1) {
    xed3_operand_set_bcrc(xes,lu_table[hidx].bcrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA16_DISP0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t disp ;xed_int8_t disp_width ;xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(37)=0 BASE0=XED_REG_BX INDEX=@  ->	FB MOD=0 value=0x0*/ {37, -1,-1,0},
/*h(21029)=1 BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB MOD=0 value=0x0*/ {21029, -1,-1,0},
/*h(20517)=2 BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB MOD=0 value=0x0*/ {20517, -1,-1,0},
/*h(39)=3 BASE0=XED_REG_BP INDEX=@  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0*/ {39, 0,8,1},
/*h(21031)=4 BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB MOD=0 value=0x0*/ {21031, -1,-1,0},
/*h(20519)=5 BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB MOD=0 value=0x0*/ {20519, -1,-1,0},
/*h(41)=6 BASE0=XED_REG_DI INDEX=@  ->	FB MOD=0 value=0x0*/ {41, -1,-1,0},
/*h(40)=7 BASE0=XED_REG_SI INDEX=@  ->	FB MOD=0 value=0x0*/ {40, -1,-1,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0_INDEX(xes);
hidx = ((20*key % 37) % 8);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].disp >= 0) xed3_operand_set_disp(xes,lu_table[hidx].disp);
    if(lu_table[hidx].disp_width >= 0) xed3_operand_set_disp_width(xes,lu_table[hidx].disp_width);
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_AVX512_ROUND_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t bcrc ;xed_int8_t llrc;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(1)=0 ROUNDC=1  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1*/ {1,0},
/*h(2)=1 ROUNDC=2  ->	FB LLRC=1 value=0x1 	FB BCRC=1 value=0x1*/ {1,1},
/*h(3)=2 ROUNDC=3  ->	FB LLRC=2 value=0x2 	FB BCRC=1 value=0x1*/ {1,2},
/*h(4)=3 ROUNDC=4  ->	FB LLRC=3 value=0x3 	FB BCRC=1 value=0x1*/ {1,3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_ROUNDC(xes);
hidx = key - 1;
if(hidx <= 3) {
    xed3_operand_set_bcrc(xes,lu_table[hidx].bcrc);
    xed3_operand_set_llrc(xes,lu_table[hidx].llrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ESIZE_128_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_VSIB_ENC_INDEX_XMM_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t rexx ;xed_int8_t sibindex;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(178)=0 INDEX=XED_REG_XMM0  ->	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0},
/*h(179)=1 INDEX=XED_REG_XMM1  ->	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1},
/*h(180)=2 INDEX=XED_REG_XMM2  ->	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2},
/*h(181)=3 INDEX=XED_REG_XMM3  ->	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3},
/*h(182)=4 INDEX=XED_REG_XMM4  ->	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4},
/*h(183)=5 INDEX=XED_REG_XMM5  ->	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5},
/*h(184)=6 INDEX=XED_REG_XMM6  ->	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6},
/*h(185)=7 INDEX=XED_REG_XMM7  ->	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7},
/*h(186)=8 INDEX=XED_REG_XMM8  ->	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0},
/*h(187)=9 INDEX=XED_REG_XMM9  ->	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1},
/*h(188)=10 INDEX=XED_REG_XMM10  ->	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2},
/*h(189)=11 INDEX=XED_REG_XMM11  ->	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3},
/*h(190)=12 INDEX=XED_REG_XMM12  ->	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4},
/*h(191)=13 INDEX=XED_REG_XMM13  ->	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5},
/*h(192)=14 INDEX=XED_REG_XMM14  ->	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6},
/*h(193)=15 INDEX=XED_REG_XMM15  ->	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_INDEX(xes);
hidx = key - 178;
if(hidx <= 15) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_LL_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t bcrc ;xed_int8_t llrc;} lu_entry_t;
static const lu_entry_t lu_table[19] = {
/*h(0)=0 ROUNDC=0 SAE=0 VL=0  ->	FB LLRC=0 value=0x0*/ {0, -1,0},
/*h(32)=1 ROUNDC=0 SAE=0 VL=2  ->	FB LLRC=2 value=0x2*/ {32, -1,2},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(8)=5 ROUNDC=0 SAE=1 VL=0  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1*/ {8, 1,0},
/*h(40)=6 ROUNDC=0 SAE=1 VL=2  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1*/ {40, 1,0},
/*empty slot1 */ {0,0,0},
/*h(9)=8 ROUNDC=1 SAE=1 VL=0  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1*/ {9, 1,0},
/*h(41)=9 ROUNDC=1 SAE=1 VL=2  ->	FB LLRC=0 value=0x0 	FB BCRC=1 value=0x1*/ {41, 1,0},
/*h(16)=10 ROUNDC=0 SAE=0 VL=1  ->	FB LLRC=1 value=0x1*/ {16, -1,1},
/*h(10)=11 ROUNDC=2 SAE=1 VL=0  ->	FB LLRC=1 value=0x1 	FB BCRC=1 value=0x1*/ {10, 1,1},
/*h(42)=12 ROUNDC=2 SAE=1 VL=2  ->	FB LLRC=1 value=0x1 	FB BCRC=1 value=0x1*/ {42, 1,1},
/*empty slot1 */ {0,0,0},
/*h(11)=14 ROUNDC=3 SAE=1 VL=0  ->	FB LLRC=2 value=0x2 	FB BCRC=1 value=0x1*/ {11, 1,2},
/*h(43)=15 ROUNDC=3 SAE=1 VL=2  ->	FB LLRC=2 value=0x2 	FB BCRC=1 value=0x1*/ {43, 1,2},
/*empty slot1 */ {0,0,0},
/*h(12)=17 ROUNDC=4 SAE=1 VL=0  ->	FB LLRC=3 value=0x3 	FB BCRC=1 value=0x1*/ {12, 1,3},
/*h(44)=18 ROUNDC=4 SAE=1 VL=2  ->	FB LLRC=3 value=0x3 	FB BCRC=1 value=0x1*/ {44, 1,3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_ROUNDC_SAE_VL(xes);
hidx = (3*key % 19);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].bcrc >= 0) xed3_operand_set_bcrc(xes,lu_table[hidx].bcrc);
    xed3_operand_set_llrc(xes,lu_table[hidx].llrc);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ESIZE_2_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_READER_BYTE_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_MODRM_RM_ENCODE_EA32_SIB0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t rm ;xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[124] = {
/*h(0)=0 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5*/ {0, -1,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(1089)=1 BASE0=XED_REG_R15D  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1*/ {1089, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(577)=3 BASE0=XED_REG_R15D  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1*/ {577, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(65)=5 BASE0=XED_REG_R15D  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1*/ {65, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1586)=18 BASE0=XED_REG_EAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0*/ {1586, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1074)=20 BASE0=XED_REG_EAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0*/ {1074, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(562)=22 BASE0=XED_REG_EAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0*/ {562, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(50)=24 BASE0=XED_REG_EAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0*/ {50, 0,0,0},
/*h(1587)=25 BASE0=XED_REG_ECX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0*/ {1587, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(1075)=27 BASE0=XED_REG_ECX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0*/ {1075, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(563)=29 BASE0=XED_REG_ECX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0*/ {563, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(51)=31 BASE0=XED_REG_ECX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0*/ {51, 0,1,0},
/*h(1588)=32 BASE0=XED_REG_EDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0*/ {1588, 0,2,0},
/*h(1536)=33 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5*/ {1536, -1,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(1076)=34 BASE0=XED_REG_EDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0*/ {1076, 0,2,0},
/*h(1024)=35 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5*/ {1024, -1,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(564)=36 BASE0=XED_REG_EDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0*/ {564, 0,2,0},
/*h(512)=37 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5*/ {512, -1,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(52)=38 BASE0=XED_REG_EDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0*/ {52, 0,2,0},
/*h(1589)=39 BASE0=XED_REG_EBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0*/ {1589, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(1077)=41 BASE0=XED_REG_EBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0*/ {1077, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(565)=43 BASE0=XED_REG_EBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0*/ {565, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(53)=45 BASE0=XED_REG_EBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0*/ {53, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1591)=53 BASE0=XED_REG_EBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0*/ {1591, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1079)=55 BASE0=XED_REG_EBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0*/ {1079, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(567)=57 BASE0=XED_REG_EBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0*/ {567, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(55)=59 BASE0=XED_REG_EBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0*/ {55, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*h(1592)=60 BASE0=XED_REG_ESI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0*/ {1592, 0,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(1080)=62 BASE0=XED_REG_ESI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0*/ {1080, 0,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(568)=64 BASE0=XED_REG_ESI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0*/ {568, 0,6,0},
/*h(1127)=65 BASE0=XED_REG_RIP MODE=2  ->	FB RM=5 value=0x5*/ {1127, -1,5,0},
/*h(56)=66 BASE0=XED_REG_ESI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0*/ {56, 0,6,0},
/*h(1593)=67 BASE0=XED_REG_EDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0*/ {1593, 0,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(1081)=69 BASE0=XED_REG_EDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0*/ {1081, 0,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(569)=71 BASE0=XED_REG_EDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0*/ {569, 0,7,0},
/*h(1128)=72 BASE0=XED_REG_EIP MODE=2  ->	FB RM=5 value=0x5*/ {1128, -1,5,0},
/*h(57)=73 BASE0=XED_REG_EDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0*/ {57, 0,7,0},
/*h(1594)=74 BASE0=XED_REG_R8D  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1*/ {1594, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1082)=76 BASE0=XED_REG_R8D  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1*/ {1082, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(570)=78 BASE0=XED_REG_R8D  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1*/ {570, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(58)=80 BASE0=XED_REG_R8D  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1*/ {58, 1,0,0},
/*h(1595)=81 BASE0=XED_REG_R9D  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1*/ {1595, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(1083)=83 BASE0=XED_REG_R9D  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1*/ {1083, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(571)=85 BASE0=XED_REG_R9D  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1*/ {571, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(59)=87 BASE0=XED_REG_R9D  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1*/ {59, 1,1,0},
/*h(1596)=88 BASE0=XED_REG_R10D  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1*/ {1596, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(1084)=90 BASE0=XED_REG_R10D  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1*/ {1084, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(572)=92 BASE0=XED_REG_R10D  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1*/ {572, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(60)=94 BASE0=XED_REG_R10D  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1*/ {60, 1,2,0},
/*h(1597)=95 BASE0=XED_REG_R11D  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1*/ {1597, 1,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(1085)=97 BASE0=XED_REG_R11D  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1*/ {1085, 1,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(573)=99 BASE0=XED_REG_R11D  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1*/ {573, 1,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(61)=101 BASE0=XED_REG_R11D  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1*/ {61, 1,3,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1599)=109 BASE0=XED_REG_R13D  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1*/ {1599, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1087)=111 BASE0=XED_REG_R13D  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1*/ {1087, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(575)=113 BASE0=XED_REG_R13D  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1*/ {575, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(63)=115 BASE0=XED_REG_R13D  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1*/ {63, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*h(1600)=116 BASE0=XED_REG_R14D  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1*/ {1600, 1,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(1088)=118 BASE0=XED_REG_R14D  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1*/ {1088, 1,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(576)=120 BASE0=XED_REG_R14D  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1*/ {576, 1,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(64)=122 BASE0=XED_REG_R14D  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1*/ {64, 1,6,0},
/*h(1601)=123 BASE0=XED_REG_R15D  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1*/ {1601, 1,7,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_BASE0_MODE(xes);
hidx = ((7*key % 163) % 124);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].rexb >= 0) xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE_EA32_SIB0=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_IMMUNE_REXW_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA16_DISP16_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[9] = {
/*h(0)=0 BASE0=@ INDEX=@  ->	FB MOD=0 value=0x0*/ {0, 0},
/*h(39)=1 BASE0=XED_REG_BP INDEX=@  ->	FB MOD=2 value=0x2*/ {39, 2},
/*h(40)=2 BASE0=XED_REG_SI INDEX=@  ->	FB MOD=2 value=0x2*/ {40, 2},
/*h(41)=3 BASE0=XED_REG_DI INDEX=@  ->	FB MOD=2 value=0x2*/ {41, 2},
/*h(21029)=4 BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB MOD=2 value=0x2*/ {21029, 2},
/*h(20517)=5 BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB MOD=2 value=0x2*/ {20517, 2},
/*h(21031)=6 BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB MOD=2 value=0x2*/ {21031, 2},
/*h(20519)=7 BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB MOD=2 value=0x2*/ {20519, 2},
/*h(37)=8 BASE0=XED_REG_BX INDEX=@  ->	FB MOD=2 value=0x2*/ {37, 2}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0_INDEX(xes);
hidx = ((30*key % 29) % 9);
if(lu_table[hidx].key == key) {
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_IGNORE66_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_IMMUNE66_LOOP64_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_READER_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_DF64_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t df64;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	nothing*/ {-1},
/*h(1)=1 MODE=1  ->	nothing*/ {-1},
/*h(2)=2 MODE=2  ->	FB DF64=1 value=0x1*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].df64 >= 0) xed3_operand_set_df64(xes,lu_table[hidx].df64);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA64_DISP32_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[19] = {
/*h(0)=0 BASE0=@  ->	FB MOD=0 value=0x0*/ {0, 0},
/*h(104)=1 BASE0=XED_REG_EIP  ->	FB MOD=0 value=0x0*/ {104, 0},
/*h(71)=2 BASE0=XED_REG_RBP  ->	FB MOD=2 value=0x2*/ {71, 2},
/*h(73)=3 BASE0=XED_REG_RDI  ->	FB MOD=2 value=0x2*/ {73, 2},
/*h(75)=4 BASE0=XED_REG_R9  ->	FB MOD=2 value=0x2*/ {75, 2},
/*h(77)=5 BASE0=XED_REG_R11  ->	FB MOD=2 value=0x2*/ {77, 2},
/*h(79)=6 BASE0=XED_REG_R13  ->	FB MOD=2 value=0x2*/ {79, 2},
/*h(81)=7 BASE0=XED_REG_R15  ->	FB MOD=2 value=0x2*/ {81, 2},
/*h(67)=8 BASE0=XED_REG_RCX  ->	FB MOD=2 value=0x2*/ {67, 2},
/*h(69)=9 BASE0=XED_REG_RBX  ->	FB MOD=2 value=0x2*/ {69, 2},
/*h(103)=10 BASE0=XED_REG_RIP  ->	FB MOD=0 value=0x0*/ {103, 0},
/*h(70)=11 BASE0=XED_REG_RSP  ->	FB MOD=2 value=0x2*/ {70, 2},
/*h(72)=12 BASE0=XED_REG_RSI  ->	FB MOD=2 value=0x2*/ {72, 2},
/*h(74)=13 BASE0=XED_REG_R8  ->	FB MOD=2 value=0x2*/ {74, 2},
/*h(76)=14 BASE0=XED_REG_R10  ->	FB MOD=2 value=0x2*/ {76, 2},
/*h(78)=15 BASE0=XED_REG_R12  ->	FB MOD=2 value=0x2*/ {78, 2},
/*h(80)=16 BASE0=XED_REG_R14  ->	FB MOD=2 value=0x2*/ {80, 2},
/*h(66)=17 BASE0=XED_REG_RAX  ->	FB MOD=2 value=0x2*/ {66, 2},
/*h(68)=18 BASE0=XED_REG_RDX  ->	FB MOD=2 value=0x2*/ {68, 2}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0(xes);
hidx = ((29*key % 673) % 19);
if(lu_table[hidx].key == key) {
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ESIZE_4_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_0_BIND(xed_encoder_request_t* xes)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 0;
if(hidx == 0) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_FIXUP_EASZ_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t easz;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0 EASZ=0  ->	FB EASZ=1 value=0x1*/ {0, 1},
/*h(4)=1 MODE=1 EASZ=0  ->	FB EASZ=2 value=0x2*/ {4, 2},
/*h(8)=2 MODE=2 EASZ=0  ->	FB EASZ=3 value=0x3*/ {8, 3}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_EASZ_MODE(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_easz(xes,lu_table[hidx].easz);
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_0_8_16_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; } lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 DISP_WIDTH=0  ->	nothing*/ {0, },
/*h(16)=1 DISP_WIDTH=16  ->	nothing*/ {16, },
/*h(8)=2 DISP_WIDTH=8  ->	nothing*/ {8, }
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = (4*key % 3);
if(lu_table[hidx].key == key) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_FIX_ROUND_LEN128_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_VEX_REXR_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[8] = {
/*h(0)=0 MODE!=2 REXR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {-1,2},
/*h(1)=1 MODE!=2 REXR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {-1,2},
/*h(2)=2 MODE=2 REXR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {-1,3},
/*h(3)=3 MODE!=2 REXR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {-1,2},
/*h(4)=4 MODE!=2 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(5)=5 MODE!=2 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(6)=6 MODE=2 REXR=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1*/ {-1,7},
/*h(7)=7 MODE!=2 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXR(xes);
hidx = key - 0;
if(hidx <= 7) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_VEX_REXR_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_16_BIND(xed_encoder_request_t* xes)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 16;
if(hidx == 0) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_XOP_REXXB_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(0)=0 MODE!=2 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,1},
/*h(1)=1 MODE!=2 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,1},
/*h(2)=2 MODE=2 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,3},
/*h(3)=3 MODE!=2 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,1},
/*h(4)=4 MODE!=2 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(5)=5 MODE!=2 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(6)=6 MODE=2 REXX=0 REXB=1  ->	emit 0b10 emit_type=numeric value=0x2 nbits=2*/ {-1,7},
/*h(7)=7 MODE!=2 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(8)=8 MODE!=2 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(9)=9 MODE!=2 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(10)=10 MODE=2 REXX=1 REXB=0  ->	emit 0b01 emit_type=numeric value=0x1 nbits=2*/ {-1,11},
/*h(11)=11 MODE!=2 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(12)=12 MODE!=2 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(13)=13 MODE!=2 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(14)=14 MODE=2 REXX=1 REXB=1  ->	emit 0b00 emit_type=numeric value=0x0 nbits=2*/ {-1,15},
/*h(15)=15 MODE!=2 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXB_REXX(xes);
hidx = key - 0;
if(hidx <= 15) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_XOP_REXXB_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_VSIB_ENC_SCALE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t sibscale;} lu_entry_t;
static const lu_entry_t lu_table[5] = {
/*h(0)=0 SCALE=0  ->	FB SIBSCALE=0 value=0x0*/ {0, 0},
/*h(2)=1 SCALE=2  ->	FB SIBSCALE=1 value=0x1*/ {2, 1},
/*h(4)=2 SCALE=4  ->	FB SIBSCALE=2 value=0x2*/ {4, 2},
/*h(1)=3 SCALE=1  ->	FB SIBSCALE=0 value=0x0*/ {1, 0},
/*h(8)=4 SCALE=8  ->	FB SIBSCALE=3 value=0x3*/ {8, 3}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SCALE(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 5ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_sibscale(xes,lu_table[hidx].sibscale);
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_RM_ENCODE_EANOT16_SIB1_BIND(xed_encoder_request_t* xes)
{
xed3_operand_set_rm(xes,4);
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_SIBINDEX_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(0)=0 SIB=0  ->	nothing*/ {0},
/*h(1)=1 SIB=1  ->	nt NT[SIBINDEX_ENCODE_SIB1]*/ {xed_encode_nonterminal_SIBINDEX_ENCODE_SIB1_BIND}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_SIB(xes);
hidx = key - 0;
if(hidx <= 1) {
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_SIBINDEX_ENCODE=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ESIZE_64_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_EVEX_62_REXR_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(5)=0 MODE=1 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {5, XED_ERROR_GENERAL_ERROR,0},
/*h(2)=1 MODE=2 REXR=0  ->	emit 0x62 emit_type=numeric value=0x62 nbits=8 	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {2, -1,2},
/*empty slot1 */ {0,0,0},
/*h(1)=3 MODE=1 REXR=0  ->	emit 0x62 emit_type=numeric value=0x62 nbits=8 	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {1, -1,4},
/*h(6)=4 MODE=2 REXR=1  ->	emit 0x62 emit_type=numeric value=0x62 nbits=8 	emit 0b0 emit_type=numeric value=0x0 nbits=1*/ {6, -1,5},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXR(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_EVEX_62_REXR_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE1_WORD_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_SCALAR_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_SIBINDEX_ENCODE_SIB1_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t rexx ;xed_int8_t sibindex;} lu_entry_t;
static const lu_entry_t lu_table[98] = {
/*h(0)=0 INDEX=@  ->	FB SIBINDEX=4 value=0x4 	FB REXX=0 value=0x0*/ {0, 0,4},
/*h(319)=1 INDEX=XED_REG_R13 EASZ=3  ->	FB SIBINDEX=5 value=0x5 	FB REXX=1 value=0x1*/ {319, 1,5},
/*h(291)=2 INDEX=XED_REG_RSI EASZ=3  ->	FB SIBINDEX=6 value=0x6 	FB REXX=0 value=0x0*/ {291, 0,6},
/*h(197)=3 INDEX=XED_REG_R15W EASZ=1  ->	FB SIBINDEX=7 value=0x7 	FB REXX=1 value=0x1*/ {197, 1,7},
/*h(169)=4 INDEX=XED_REG_R8W EASZ=1  ->	FB SIBINDEX=0 value=0x0 	FB REXX=1 value=0x1*/ {169, 1,0},
/*h(141)=5 INDEX=XED_REG_CX EASZ=1  ->	FB SIBINDEX=1 value=0x1 	FB REXX=0 value=0x0*/ {141, 0,1},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(189)=8 INDEX=XED_REG_R13W EASZ=1  ->	FB SIBINDEX=5 value=0x5 	FB REXX=1 value=0x1*/ {189, 1,5},
/*h(161)=9 INDEX=XED_REG_SI EASZ=1  ->	FB SIBINDEX=6 value=0x6 	FB REXX=0 value=0x0*/ {161, 0,6},
/*h(1)=10 INDEX=@  ->	FB SIBINDEX=4 value=0x4 	FB REXX=0 value=0x0*/ {1, 0,4},
/*h(254)=11 INDEX=XED_REG_R13D EASZ=2  ->	FB SIBINDEX=5 value=0x5 	FB REXX=1 value=0x1*/ {254, 1,5},
/*h(226)=12 INDEX=XED_REG_ESI EASZ=2  ->	FB SIBINDEX=6 value=0x6 	FB REXX=0 value=0x0*/ {226, 0,6},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(246)=16 INDEX=XED_REG_R11D EASZ=2  ->	FB SIBINDEX=3 value=0x3 	FB REXX=1 value=0x1*/ {246, 1,3},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(311)=19 INDEX=XED_REG_R11 EASZ=3  ->	FB SIBINDEX=3 value=0x3 	FB REXX=1 value=0x1*/ {311, 1,3},
/*h(2)=20 INDEX=@  ->	FB SIBINDEX=4 value=0x4 	FB REXX=0 value=0x0*/ {2, 0,4},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(303)=24 INDEX=XED_REG_R9 EASZ=3  ->	FB SIBINDEX=1 value=0x1 	FB REXX=1 value=0x1*/ {303, 1,1},
/*h(275)=25 INDEX=XED_REG_RDX EASZ=3  ->	FB SIBINDEX=2 value=0x2 	FB REXX=0 value=0x0*/ {275, 0,2},
/*h(181)=26 INDEX=XED_REG_R11W EASZ=1  ->	FB SIBINDEX=3 value=0x3 	FB REXX=1 value=0x1*/ {181, 1,3},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(3)=30 INDEX=@  ->	FB SIBINDEX=4 value=0x4 	FB REXX=0 value=0x0*/ {3, 0,4},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(238)=34 INDEX=XED_REG_R9D EASZ=2  ->	FB SIBINDEX=1 value=0x1 	FB REXX=1 value=0x1*/ {238, 1,1},
/*h(210)=35 INDEX=XED_REG_EDX EASZ=2  ->	FB SIBINDEX=2 value=0x2 	FB REXX=0 value=0x0*/ {210, 0,2},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(323)=41 INDEX=XED_REG_R14 EASZ=3  ->	FB SIBINDEX=6 value=0x6 	FB REXX=1 value=0x1*/ {323, 1,6},
/*h(295)=42 INDEX=XED_REG_RDI EASZ=3  ->	FB SIBINDEX=7 value=0x7 	FB REXX=0 value=0x0*/ {295, 0,7},
/*h(267)=43 INDEX=XED_REG_RAX EASZ=3  ->	FB SIBINDEX=0 value=0x0 	FB REXX=0 value=0x0*/ {267, 0,0},
/*h(173)=44 INDEX=XED_REG_R9W EASZ=1  ->	FB SIBINDEX=1 value=0x1 	FB REXX=1 value=0x1*/ {173, 1,1},
/*h(145)=45 INDEX=XED_REG_DX EASZ=1  ->	FB SIBINDEX=2 value=0x2 	FB REXX=0 value=0x0*/ {145, 0,2},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(193)=48 INDEX=XED_REG_R14W EASZ=1  ->	FB SIBINDEX=6 value=0x6 	FB REXX=1 value=0x1*/ {193, 1,6},
/*h(165)=49 INDEX=XED_REG_DI EASZ=1  ->	FB SIBINDEX=7 value=0x7 	FB REXX=0 value=0x0*/ {165, 0,7},
/*h(137)=50 INDEX=XED_REG_AX EASZ=1  ->	FB SIBINDEX=0 value=0x0 	FB REXX=0 value=0x0*/ {137, 0,0},
/*h(258)=51 INDEX=XED_REG_R14D EASZ=2  ->	FB SIBINDEX=6 value=0x6 	FB REXX=1 value=0x1*/ {258, 1,6},
/*h(230)=52 INDEX=XED_REG_EDI EASZ=2  ->	FB SIBINDEX=7 value=0x7 	FB REXX=0 value=0x0*/ {230, 0,7},
/*h(202)=53 INDEX=XED_REG_EAX EASZ=2  ->	FB SIBINDEX=0 value=0x0 	FB REXX=0 value=0x0*/ {202, 0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(250)=56 INDEX=XED_REG_R12D EASZ=2  ->	FB SIBINDEX=4 value=0x4 	FB REXX=1 value=0x1*/ {250, 1,4},
/*h(222)=57 INDEX=XED_REG_EBP EASZ=2  ->	FB SIBINDEX=5 value=0x5 	FB REXX=0 value=0x0*/ {222, 0,5},
/*empty slot1 */ {0,0,0},
/*h(315)=59 INDEX=XED_REG_R12 EASZ=3  ->	FB SIBINDEX=4 value=0x4 	FB REXX=1 value=0x1*/ {315, 1,4},
/*h(287)=60 INDEX=XED_REG_RBP EASZ=3  ->	FB SIBINDEX=5 value=0x5 	FB REXX=0 value=0x0*/ {287, 0,5},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(307)=64 INDEX=XED_REG_R10 EASZ=3  ->	FB SIBINDEX=2 value=0x2 	FB REXX=1 value=0x1*/ {307, 1,2},
/*h(279)=65 INDEX=XED_REG_RBX EASZ=3  ->	FB SIBINDEX=3 value=0x3 	FB REXX=0 value=0x0*/ {279, 0,3},
/*h(185)=66 INDEX=XED_REG_R12W EASZ=1  ->	FB SIBINDEX=4 value=0x4 	FB REXX=1 value=0x1*/ {185, 1,4},
/*h(157)=67 INDEX=XED_REG_BP EASZ=1  ->	FB SIBINDEX=5 value=0x5 	FB REXX=0 value=0x0*/ {157, 0,5},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(242)=74 INDEX=XED_REG_R10D EASZ=2  ->	FB SIBINDEX=2 value=0x2 	FB REXX=1 value=0x1*/ {242, 1,2},
/*h(214)=75 INDEX=XED_REG_EBX EASZ=2  ->	FB SIBINDEX=3 value=0x3 	FB REXX=0 value=0x0*/ {214, 0,3},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(327)=81 INDEX=XED_REG_R15 EASZ=3  ->	FB SIBINDEX=7 value=0x7 	FB REXX=1 value=0x1*/ {327, 1,7},
/*h(299)=82 INDEX=XED_REG_R8 EASZ=3  ->	FB SIBINDEX=0 value=0x0 	FB REXX=1 value=0x1*/ {299, 1,0},
/*h(271)=83 INDEX=XED_REG_RCX EASZ=3  ->	FB SIBINDEX=1 value=0x1 	FB REXX=0 value=0x0*/ {271, 0,1},
/*h(177)=84 INDEX=XED_REG_R10W EASZ=1  ->	FB SIBINDEX=2 value=0x2 	FB REXX=1 value=0x1*/ {177, 1,2},
/*h(149)=85 INDEX=XED_REG_BX EASZ=1  ->	FB SIBINDEX=3 value=0x3 	FB REXX=0 value=0x0*/ {149, 0,3},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*h(262)=91 INDEX=XED_REG_R15D EASZ=2  ->	FB SIBINDEX=7 value=0x7 	FB REXX=1 value=0x1*/ {262, 1,7},
/*h(234)=92 INDEX=XED_REG_R8D EASZ=2  ->	FB SIBINDEX=0 value=0x0 	FB REXX=1 value=0x1*/ {234, 1,0},
/*h(206)=93 INDEX=XED_REG_ECX EASZ=2  ->	FB SIBINDEX=1 value=0x1 	FB REXX=0 value=0x0*/ {206, 0,1},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0},
/*empty slot1 */ {0,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_EASZ_INDEX(xes);
hidx = ((10*key % 281) % 98);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_REXX_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(5)=0 MODE=1 REXX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {5, XED_ERROR_GENERAL_ERROR,0},
/*h(2)=1 MODE=2 REXX=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {2, -1,2},
/*empty slot1 */ {0,0,0},
/*h(1)=3 MODE=1 REXX=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {1, -1,4},
/*h(6)=4 MODE=2 REXX=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1*/ {6, -1,5},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXX(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_EVEX_REXX_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_XOP_TYPE_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(8)=0 MAP=8  ->	emit 0x8F emit_type=numeric value=0x8f nbits=8*/ {1},
/*h(9)=1 MAP=9  ->	emit 0x8F emit_type=numeric value=0x8f nbits=8*/ {2},
/*h(10)=2 MAP=10  ->	emit 0x8F emit_type=numeric value=0x8f nbits=8*/ {3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MAP(xes);
hidx = key - 8;
if(hidx <= 2) {
    xed_encoder_request_iforms(xes)->x_XOP_TYPE_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_ESIZE_8_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_BYTE_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_NELEM_MOVDDUP_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_IMMUNE66_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t df32 ;xed_int8_t eosz;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(0)=0 MODE=0  ->	FB EOSZ=2 value=0x2 	FB DF32=1 value=0x1*/ {1,2}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx == 0) {
    xed3_operand_set_df32(xes,lu_table[hidx].df32);
    xed3_operand_set_eosz(xes,lu_table[hidx].eosz);
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_SIBBASE_ENCODE_SIB1_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t sibbase ;xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[104] = {
/*h(0)=0 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {0, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(548)=3 BASE0=XED_REG_DX EASZ=1  ->	FB SIBBASE=2 value=0x2 	FB REXB=0 value=0x0*/ {548, 0,2,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(549)=7 BASE0=XED_REG_BX EASZ=1  ->	FB SIBBASE=3 value=0x3 	FB REXB=0 value=0x0*/ {549, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(550)=11 BASE0=XED_REG_SP EASZ=1  ->	FB SIBBASE=4 value=0x4 	FB REXB=0 value=0x0*/ {550, 0,4,0},
/*h(1024)=12 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {1024, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(1074)=13 BASE0=XED_REG_EAX EASZ=2  ->	FB SIBBASE=0 value=0x0 	FB REXB=0 value=0x0*/ {1074, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(551)=15 BASE0=XED_REG_BP EASZ=1  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {551, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1075)=17 BASE0=XED_REG_ECX EASZ=2  ->	FB SIBBASE=1 value=0x1 	FB REXB=0 value=0x0*/ {1075, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(552)=19 BASE0=XED_REG_SI EASZ=1  ->	FB SIBBASE=6 value=0x6 	FB REXB=0 value=0x0*/ {552, 0,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(1076)=21 BASE0=XED_REG_EDX EASZ=2  ->	FB SIBBASE=2 value=0x2 	FB REXB=0 value=0x0*/ {1076, 0,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(553)=23 BASE0=XED_REG_DI EASZ=1  ->	FB SIBBASE=7 value=0x7 	FB REXB=0 value=0x0*/ {553, 0,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(1077)=25 BASE0=XED_REG_EBX EASZ=2  ->	FB SIBBASE=3 value=0x3 	FB REXB=0 value=0x0*/ {1077, 0,3,0},
/*empty slot1 */ {0,0,0,0},
/*h(554)=27 BASE0=XED_REG_R8W EASZ=1  ->	FB SIBBASE=0 value=0x0 	FB REXB=1 value=0x1*/ {554, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1078)=29 BASE0=XED_REG_ESP EASZ=2  ->	FB SIBBASE=4 value=0x4 	FB REXB=0 value=0x0*/ {1078, 0,4,0},
/*empty slot1 */ {0,0,0,0},
/*h(555)=31 BASE0=XED_REG_R9W EASZ=1  ->	FB SIBBASE=1 value=0x1 	FB REXB=1 value=0x1*/ {555, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(1079)=33 BASE0=XED_REG_EBP EASZ=2  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {1079, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(556)=35 BASE0=XED_REG_R10W EASZ=1  ->	FB SIBBASE=2 value=0x2 	FB REXB=1 value=0x1*/ {556, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(1080)=37 BASE0=XED_REG_ESI EASZ=2  ->	FB SIBBASE=6 value=0x6 	FB REXB=0 value=0x0*/ {1080, 0,6,0},
/*empty slot1 */ {0,0,0,0},
/*h(557)=39 BASE0=XED_REG_R11W EASZ=1  ->	FB SIBBASE=3 value=0x3 	FB REXB=1 value=0x1*/ {557, 1,3,0},
/*h(1602)=40 BASE0=XED_REG_RAX EASZ=3  ->	FB SIBBASE=0 value=0x0 	FB REXB=0 value=0x0*/ {1602, 0,0,0},
/*h(1081)=41 BASE0=XED_REG_EDI EASZ=2  ->	FB SIBBASE=7 value=0x7 	FB REXB=0 value=0x0*/ {1081, 0,7,0},
/*empty slot1 */ {0,0,0,0},
/*h(558)=43 BASE0=XED_REG_R12W EASZ=1  ->	FB SIBBASE=4 value=0x4 	FB REXB=1 value=0x1*/ {558, 1,4,0},
/*h(1603)=44 BASE0=XED_REG_RCX EASZ=3  ->	FB SIBBASE=1 value=0x1 	FB REXB=0 value=0x0*/ {1603, 0,1,0},
/*h(1082)=45 BASE0=XED_REG_R8D EASZ=2  ->	FB SIBBASE=0 value=0x0 	FB REXB=1 value=0x1*/ {1082, 1,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(559)=47 BASE0=XED_REG_R13W EASZ=1  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=1 value=0x1*/ {559, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*h(1604)=48 BASE0=XED_REG_RDX EASZ=3  ->	FB SIBBASE=2 value=0x2 	FB REXB=0 value=0x0*/ {1604, 0,2,0},
/*h(1083)=49 BASE0=XED_REG_R9D EASZ=2  ->	FB SIBBASE=1 value=0x1 	FB REXB=1 value=0x1*/ {1083, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(560)=51 BASE0=XED_REG_R14W EASZ=1  ->	FB SIBBASE=6 value=0x6 	FB REXB=1 value=0x1*/ {560, 1,6,0},
/*h(1605)=52 BASE0=XED_REG_RBX EASZ=3  ->	FB SIBBASE=3 value=0x3 	FB REXB=0 value=0x0*/ {1605, 0,3,0},
/*h(1084)=53 BASE0=XED_REG_R10D EASZ=2  ->	FB SIBBASE=2 value=0x2 	FB REXB=1 value=0x1*/ {1084, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*h(561)=55 BASE0=XED_REG_R15W EASZ=1  ->	FB SIBBASE=7 value=0x7 	FB REXB=1 value=0x1*/ {561, 1,7,0},
/*h(1606)=56 BASE0=XED_REG_RSP EASZ=3  ->	FB SIBBASE=4 value=0x4 	FB REXB=0 value=0x0*/ {1606, 0,4,0},
/*h(1085)=57 BASE0=XED_REG_R11D EASZ=2  ->	FB SIBBASE=3 value=0x3 	FB REXB=1 value=0x1*/ {1085, 1,3,0},
/*h(512)=58 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {512, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1607)=60 BASE0=XED_REG_RBP EASZ=3  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {1607, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*h(1086)=61 BASE0=XED_REG_R12D EASZ=2  ->	FB SIBBASE=4 value=0x4 	FB REXB=1 value=0x1*/ {1086, 1,4,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1608)=64 BASE0=XED_REG_RSI EASZ=3  ->	FB SIBBASE=6 value=0x6 	FB REXB=0 value=0x0*/ {1608, 0,6,0},
/*h(1087)=65 BASE0=XED_REG_R13D EASZ=2  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=1 value=0x1*/ {1087, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1609)=68 BASE0=XED_REG_RDI EASZ=3  ->	FB SIBBASE=7 value=0x7 	FB REXB=0 value=0x0*/ {1609, 0,7,0},
/*h(1088)=69 BASE0=XED_REG_R14D EASZ=2  ->	FB SIBBASE=6 value=0x6 	FB REXB=1 value=0x1*/ {1088, 1,6,0},
/*h(1536)=70 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0*/ {1536, 0,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(1610)=72 BASE0=XED_REG_R8 EASZ=3  ->	FB SIBBASE=0 value=0x0 	FB REXB=1 value=0x1*/ {1610, 1,0,0},
/*h(1089)=73 BASE0=XED_REG_R15D EASZ=2  ->	FB SIBBASE=7 value=0x7 	FB REXB=1 value=0x1*/ {1089, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1611)=76 BASE0=XED_REG_R9 EASZ=3  ->	FB SIBBASE=1 value=0x1 	FB REXB=1 value=0x1*/ {1611, 1,1,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1612)=80 BASE0=XED_REG_R10 EASZ=3  ->	FB SIBBASE=2 value=0x2 	FB REXB=1 value=0x1*/ {1612, 1,2,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1613)=84 BASE0=XED_REG_R11 EASZ=3  ->	FB SIBBASE=3 value=0x3 	FB REXB=1 value=0x1*/ {1613, 1,3,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1614)=88 BASE0=XED_REG_R12 EASZ=3  ->	FB SIBBASE=4 value=0x4 	FB REXB=1 value=0x1*/ {1614, 1,4,0},
/*empty slot1 */ {0,0,0,0},
/*h(546)=90 BASE0=XED_REG_AX EASZ=1  ->	FB SIBBASE=0 value=0x0 	FB REXB=0 value=0x0*/ {546, 0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1615)=92 BASE0=XED_REG_R13 EASZ=3  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=1 value=0x1*/ {1615, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*empty slot1 */ {0,0,0,0},
/*h(547)=94 BASE0=XED_REG_CX EASZ=1  ->	FB SIBBASE=1 value=0x1 	FB REXB=0 value=0x0*/ {547, 0,1,0},
/*empty slot1 */ {0,0,0,0},
/*h(1616)=96 BASE0=XED_REG_R14 EASZ=3  ->	FB SIBBASE=6 value=0x6 	FB REXB=1 value=0x1*/ {1616, 1,6,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(1617)=100 BASE0=XED_REG_R15 EASZ=3  ->	FB SIBBASE=7 value=0x7 	FB REXB=1 value=0x1*/ {1617, 1,7,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_BASE0_EASZ(xes);
hidx = ((4*key % 199) % 104);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_sibbase(xes,lu_table[hidx].sibbase);
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_SIBBASE_ENCODE_SIB1=hidx+1;
    return res;
    return 1;
}
else{
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_CR_WIDTH_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t df32 ;xed_int8_t df64 ;xed_int8_t eosz;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0  ->	FB DF32=1 value=0x1 	FB EOSZ=2 value=0x2*/ {1,-1,2},
/*h(1)=1 MODE=1  ->	nothing*/ {-1,-1,-1},
/*h(2)=2 MODE=2  ->	FB DF64=1 value=0x1 	FB EOSZ=3 value=0x3*/ {-1,1,3}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE(xes);
hidx = key - 0;
if(hidx <= 2) {
    if(lu_table[hidx].df32 >= 0) xed3_operand_set_df32(xes,lu_table[hidx].df32);
    if(lu_table[hidx].df64 >= 0) xed3_operand_set_df64(xes,lu_table[hidx].df64);
    if(lu_table[hidx].eosz >= 0) xed3_operand_set_eosz(xes,lu_table[hidx].eosz);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_GPR_READER_WORD_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_VEX_MAP_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(16)=0 VEX_C4=1 MAP=0 REXW[w]=*  ->	emit 0b0_0000 emit_type=numeric value=0x0 nbits=5 	emit w emit_type=letters nbits=1*/ {1},
/*h(17)=1 VEX_C4=1 MAP=1 REXW[w]=*  ->	emit 0b0_0001 emit_type=numeric value=0x1 nbits=5 	emit w emit_type=letters nbits=1*/ {2},
/*h(18)=2 VEX_C4=1 MAP=2 REXW[w]=*  ->	emit 0b0_0010 emit_type=numeric value=0x2 nbits=5 	emit w emit_type=letters nbits=1*/ {3},
/*h(19)=3 VEX_C4=1 MAP=3 REXW[w]=*  ->	emit 0b0_0011 emit_type=numeric value=0x3 nbits=5 	emit w emit_type=letters nbits=1*/ {4}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MAP_VEX_C4(xes);
hidx = key - 16;
if(hidx <= 3) {
    xed_encoder_request_iforms(xes)->x_VEX_MAP_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA64_DISP8_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(66)=0 BASE0=XED_REG_RAX  ->	FB MOD=1 value=0x1*/ {1},
/*h(67)=1 BASE0=XED_REG_RCX  ->	FB MOD=1 value=0x1*/ {1},
/*h(68)=2 BASE0=XED_REG_RDX  ->	FB MOD=1 value=0x1*/ {1},
/*h(69)=3 BASE0=XED_REG_RBX  ->	FB MOD=1 value=0x1*/ {1},
/*h(70)=4 BASE0=XED_REG_RSP  ->	FB MOD=1 value=0x1*/ {1},
/*h(71)=5 BASE0=XED_REG_RBP  ->	FB MOD=1 value=0x1*/ {1},
/*h(72)=6 BASE0=XED_REG_RSI  ->	FB MOD=1 value=0x1*/ {1},
/*h(73)=7 BASE0=XED_REG_RDI  ->	FB MOD=1 value=0x1*/ {1},
/*h(74)=8 BASE0=XED_REG_R8  ->	FB MOD=1 value=0x1*/ {1},
/*h(75)=9 BASE0=XED_REG_R9  ->	FB MOD=1 value=0x1*/ {1},
/*h(76)=10 BASE0=XED_REG_R10  ->	FB MOD=1 value=0x1*/ {1},
/*h(77)=11 BASE0=XED_REG_R11  ->	FB MOD=1 value=0x1*/ {1},
/*h(78)=12 BASE0=XED_REG_R12  ->	FB MOD=1 value=0x1*/ {1},
/*h(79)=13 BASE0=XED_REG_R13  ->	FB MOD=1 value=0x1*/ {1},
/*h(80)=14 BASE0=XED_REG_R14  ->	FB MOD=1 value=0x1*/ {1},
/*h(81)=15 BASE0=XED_REG_R15  ->	FB MOD=1 value=0x1*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0(xes);
hidx = key - 66;
if(hidx <= 15) {
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA64_DISP0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t disp ;xed_int8_t disp_width ;xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[26] = {
/*h(68)=0 BASE0=XED_REG_RDX  ->	FB MOD=0 value=0x0*/ {68, -1,-1,0},
/*h(81)=1 BASE0=XED_REG_R15  ->	FB MOD=0 value=0x0*/ {81, -1,-1,0},
/*empty slot1 */ {0,0,0,0},
/*h(73)=3 BASE0=XED_REG_RDI  ->	FB MOD=0 value=0x0*/ {73, -1,-1,0},
/*empty slot1 */ {0,0,0,0},
/*h(78)=5 BASE0=XED_REG_R12  ->	FB MOD=0 value=0x0*/ {78, -1,-1,0},
/*h(70)=6 BASE0=XED_REG_RSP  ->	FB MOD=0 value=0x0*/ {70, -1,-1,0},
/*h(104)=7 BASE0=XED_REG_EIP  ->	FB MOD=0 value=0x0 	FB DISP_WIDTH=32 value=0x20 	FB DISP=0 value=0x0*/ {104, 0,32,0},
/*empty slot1 */ {0,0,0,0},
/*h(75)=9 BASE0=XED_REG_R9  ->	FB MOD=0 value=0x0*/ {75, -1,-1,0},
/*h(67)=10 BASE0=XED_REG_RCX  ->	FB MOD=0 value=0x0*/ {67, -1,-1,0},
/*h(80)=11 BASE0=XED_REG_R14  ->	FB MOD=0 value=0x0*/ {80, -1,-1,0},
/*h(72)=12 BASE0=XED_REG_RSI  ->	FB MOD=0 value=0x0*/ {72, -1,-1,0},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(77)=15 BASE0=XED_REG_R11  ->	FB MOD=0 value=0x0*/ {77, -1,-1,0},
/*h(69)=16 BASE0=XED_REG_RBX  ->	FB MOD=0 value=0x0*/ {69, -1,-1,0},
/*h(103)=17 BASE0=XED_REG_RIP  ->	FB MOD=0 value=0x0 	FB DISP_WIDTH=32 value=0x20 	FB DISP=0 value=0x0*/ {103, 0,32,0},
/*empty slot1 */ {0,0,0,0},
/*h(74)=19 BASE0=XED_REG_R8  ->	FB MOD=0 value=0x0*/ {74, -1,-1,0},
/*h(66)=20 BASE0=XED_REG_RAX  ->	FB MOD=0 value=0x0*/ {66, -1,-1,0},
/*h(79)=21 BASE0=XED_REG_R13  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0*/ {79, 0,8,1},
/*h(71)=22 BASE0=XED_REG_RBP  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0*/ {71, 0,8,1},
/*empty slot1 */ {0,0,0,0},
/*empty slot1 */ {0,0,0,0},
/*h(76)=25 BASE0=XED_REG_R10  ->	FB MOD=0 value=0x0*/ {76, -1,-1,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 26ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].disp >= 0) xed3_operand_set_disp(xes,lu_table[hidx].disp);
    if(lu_table[hidx].disp_width >= 0) xed3_operand_set_disp_width(xes,lu_table[hidx].disp_width);
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE2_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_REFINING66_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_MODRM_RM_ENCODE_EA64_SIB0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t rexb ;xed_int8_t rm ;xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[17] = {
/*h(0)=0 BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5*/ {0, -1,5,xed_encode_nonterminal_DISP_WIDTH_32_BIND},
/*h(73)=1 BASE0=XED_REG_RDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0*/ {73, 0,7,0},
/*h(68)=2 BASE0=XED_REG_RDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0*/ {68, 0,2,0},
/*h(80)=3 BASE0=XED_REG_R14  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1*/ {80, 1,6,0},
/*h(75)=4 BASE0=XED_REG_R9  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1*/ {75, 1,1,0},
/*h(81)=5 BASE0=XED_REG_R15  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1*/ {81, 1,7,0},
/*h(104)=6 BASE0=XED_REG_EIP  ->	FB RM=5 value=0x5*/ {104, -1,5,0},
/*h(77)=7 BASE0=XED_REG_R11  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1*/ {77, 1,3,0},
/*h(72)=8 BASE0=XED_REG_RSI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0*/ {72, 0,6,0},
/*h(67)=9 BASE0=XED_REG_RCX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0*/ {67, 0,1,0},
/*h(79)=10 BASE0=XED_REG_R13  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1*/ {79, 1,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*h(74)=11 BASE0=XED_REG_R8  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1*/ {74, 1,0,0},
/*h(69)=12 BASE0=XED_REG_RBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0*/ {69, 0,3,0},
/*h(103)=13 BASE0=XED_REG_RIP  ->	FB RM=5 value=0x5*/ {103, -1,5,0},
/*h(76)=14 BASE0=XED_REG_R10  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1*/ {76, 1,2,0},
/*h(71)=15 BASE0=XED_REG_RBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0*/ {71, 0,5,xed_encode_nonterminal_DISP_WIDTH_0_8_32_BIND},
/*h(66)=16 BASE0=XED_REG_RAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0*/ {66, 0,0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_BASE0(xes);
hidx = ((27*key % 433) % 17);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].rexb >= 0) xed3_operand_set_rexb(xes,lu_table[hidx].rexb);
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE_EA64_SIB0=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_VSIB_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(0)=0 DUMMY=0 SIBBASE[bbb]=* SIBINDEX[iii]=* SIBSCALE[ss]=*  ->	emit ss_iii_bbb emit_type=letters nbits=8*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DUMMY(xes);
hidx = key - 0;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_VSIB_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_REXB_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(5)=0 MODE=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {5, XED_ERROR_GENERAL_ERROR,0},
/*h(2)=1 MODE=2 REXB=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {2, -1,2},
/*empty slot1 */ {0,0,0},
/*h(1)=3 MODE=1 REXB=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {1, -1,4},
/*h(6)=4 MODE=2 REXB=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1*/ {6, -1,5},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXB(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_EVEX_REXB_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_ESIZE_32_BITS_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_VEXED_REX_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(0)=0 VEXVALID=0  ->	nt NT[REX_PREFIX_ENC]*/ {xed_encode_nonterminal_REX_PREFIX_ENC_BIND},
/*h(1)=1 VEXVALID=1  ->	nt NT[NEWVEX_ENC]*/ {xed_encode_nonterminal_NEWVEX_ENC_BIND},
/*h(2)=2 VEXVALID=2  ->	nt NT[EVEX_ENC]*/ {xed_encode_nonterminal_EVEX_ENC_BIND},
/*h(3)=3 VEXVALID=3  ->	nt NT[XOP_ENC]*/ {xed_encode_nonterminal_XOP_ENC_BIND}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_VEXVALID(xes);
hidx = key - 0;
if(hidx <= 3) {
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_VEXED_REX=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_VEX_REXXB_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(16)=0 MODE!=2 VEX_C4=1 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,1},
/*h(17)=1 MODE!=2 VEX_C4=1 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,1},
/*h(18)=2 MODE=2 VEX_C4=1 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,3},
/*h(19)=3 MODE!=2 VEX_C4=1 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2*/ {-1,1},
/*h(20)=4 MODE!=2 VEX_C4=1 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(21)=5 MODE!=2 VEX_C4=1 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(22)=6 MODE=2 VEX_C4=1 REXX=0 REXB=1  ->	emit 0b10 emit_type=numeric value=0x2 nbits=2*/ {-1,7},
/*h(23)=7 MODE!=2 VEX_C4=1 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(24)=8 MODE!=2 VEX_C4=1 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(25)=9 MODE!=2 VEX_C4=1 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(26)=10 MODE=2 VEX_C4=1 REXX=1 REXB=0  ->	emit 0b01 emit_type=numeric value=0x1 nbits=2*/ {-1,11},
/*h(27)=11 MODE!=2 VEX_C4=1 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(28)=12 MODE!=2 VEX_C4=1 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(29)=13 MODE!=2 VEX_C4=1 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0},
/*h(30)=14 MODE=2 VEX_C4=1 REXX=1 REXB=1  ->	emit 0b00 emit_type=numeric value=0x0 nbits=2*/ {-1,15},
/*h(31)=15 MODE!=2 VEX_C4=1 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXB_REXX_VEX_C4(xes);
hidx = key - 16;
if(hidx <= 15) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_VEX_REXXB_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_HALF_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t bcrc;} lu_entry_t;
static const lu_entry_t lu_table[31] = {
/*h(1)=0 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(2)=1 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(3)=2 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(4)=3 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(5)=4 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(6)=5 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(7)=6 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(8)=7 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(9)=8 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(10)=9 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(11)=10 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(12)=11 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(13)=12 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(14)=13 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(15)=14 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(16)=15 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(17)=16 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(18)=17 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(19)=18 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(20)=19 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(21)=20 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(22)=21 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(23)=22 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(24)=23 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(25)=24 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(26)=25 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(27)=26 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(28)=27 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(29)=28 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(30)=29 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1},
/*h(31)=30 BCAST!=0  ->	FB BCRC=1 value=0x1*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BCAST(xes);
hidx = key - 1;
if(hidx <= 30) {
    xed3_operand_set_bcrc(xes,lu_table[hidx].bcrc);
    return 1;
}
else{
    xed3_operand_set_bcrc(xes,0);
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_REXRR_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error ;xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[6] = {
/*h(5)=0 MODE=1 REXRR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {5, XED_ERROR_GENERAL_ERROR,0},
/*h(2)=1 MODE=2 REXRR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {2, -1,2},
/*empty slot1 */ {0,0,0},
/*h(1)=3 MODE=1 REXRR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1*/ {1, -1,4},
/*h(6)=4 MODE=2 REXRR=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1*/ {6, -1,5},
/*empty slot1 */ {0,0,0}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_MODE_REXRR(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 6ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    xed_encoder_request_iforms(xes)->x_EVEX_REXRR_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_AVX512_EVEX_BYTE3_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[2] = {
/*h(0)=0 ZEROING[z]=* LLRC[nn]=* BCRC[b]=* VEXDEST4=0 MASK[aaa]=*  ->	emit z_nn_b emit_type=letters nbits=4 	emit 0b1 emit_type=numeric value=0x1 nbits=1 	emit aaa emit_type=letters nbits=3*/ {1},
/*h(1)=1 ZEROING[z]=* LLRC[nn]=* BCRC[b]=* VEXDEST4=1 MASK[aaa]=*  ->	emit z_nn_b emit_type=letters nbits=4 	emit 0b0 emit_type=numeric value=0x0 nbits=1 	emit aaa emit_type=letters nbits=3*/ {2}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_VEXDEST4(xes);
hidx = key - 0;
if(hidx <= 1) {
    xed_encoder_request_iforms(xes)->x_AVX512_EVEX_BYTE3_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_EVEX_REXW_VVVV_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[1] = {
/*h(0)=0 DUMMY=0 REXW[w]=* VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit w emit_type=letters nbits=1 	emit u_ddd emit_type=letters nbits=4*/ {1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DUMMY(xes);
hidx = key - 0;
if(hidx == 0) {
    xed_encoder_request_iforms(xes)->x_EVEX_REXW_VVVV_ENC=lu_table[hidx].emit;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_DISP_WIDTH_8_BIND(xed_encoder_request_t* xes)
{
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = key - 8;
if(hidx == 0) {
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_UISA_ENC_INDEX_YMM_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t rexx ;xed_int8_t sibindex ;xed_int8_t vexdest4;} lu_entry_t;
static const lu_entry_t lu_table[32] = {
/*h(210)=0 INDEX=XED_REG_YMM0  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0,0},
/*h(211)=1 INDEX=XED_REG_YMM1  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1,0},
/*h(212)=2 INDEX=XED_REG_YMM2  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2,0},
/*h(213)=3 INDEX=XED_REG_YMM3  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3,0},
/*h(214)=4 INDEX=XED_REG_YMM4  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4,0},
/*h(215)=5 INDEX=XED_REG_YMM5  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5,0},
/*h(216)=6 INDEX=XED_REG_YMM6  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6,0},
/*h(217)=7 INDEX=XED_REG_YMM7  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7,0},
/*h(218)=8 INDEX=XED_REG_YMM8  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0,0},
/*h(219)=9 INDEX=XED_REG_YMM9  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1,0},
/*h(220)=10 INDEX=XED_REG_YMM10  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2,0},
/*h(221)=11 INDEX=XED_REG_YMM11  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3,0},
/*h(222)=12 INDEX=XED_REG_YMM12  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4,0},
/*h(223)=13 INDEX=XED_REG_YMM13  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5,0},
/*h(224)=14 INDEX=XED_REG_YMM14  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6,0},
/*h(225)=15 INDEX=XED_REG_YMM15  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7,0},
/*h(226)=16 INDEX=XED_REG_YMM16  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0,1},
/*h(227)=17 INDEX=XED_REG_YMM17  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1,1},
/*h(228)=18 INDEX=XED_REG_YMM18  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2,1},
/*h(229)=19 INDEX=XED_REG_YMM19  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3,1},
/*h(230)=20 INDEX=XED_REG_YMM20  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4,1},
/*h(231)=21 INDEX=XED_REG_YMM21  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5,1},
/*h(232)=22 INDEX=XED_REG_YMM22  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6,1},
/*h(233)=23 INDEX=XED_REG_YMM23  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7,1},
/*h(234)=24 INDEX=XED_REG_YMM24  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0,1},
/*h(235)=25 INDEX=XED_REG_YMM25  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1,1},
/*h(236)=26 INDEX=XED_REG_YMM26  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2,1},
/*h(237)=27 INDEX=XED_REG_YMM27  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3,1},
/*h(238)=28 INDEX=XED_REG_YMM28  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4,1},
/*h(239)=29 INDEX=XED_REG_YMM29  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5,1},
/*h(240)=30 INDEX=XED_REG_YMM30  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6,1},
/*h(241)=31 INDEX=XED_REG_YMM31  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7,1}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_INDEX(xes);
hidx = key - 210;
if(hidx <= 31) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    xed3_operand_set_vexdest4(xes,lu_table[hidx].vexdest4);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_MODRM_MOD_EA32_DISP32_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t mod;} lu_entry_t;
static const lu_entry_t lu_table[228] = {
/*h(0)=0 BASE0=@  ->	FB MOD=0 value=0x0*/ {0, 0},
/*empty slot1 */ {0,0},
/*h(7680)=2 BASE0=@  ->	FB MOD=0 value=0x0*/ {7680, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(7168)=11 BASE0=@  ->	FB MOD=0 value=0x0*/ {7168, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(6656)=20 BASE0=@  ->	FB MOD=0 value=0x0*/ {6656, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(6144)=29 BASE0=@  ->	FB MOD=0 value=0x0*/ {6144, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5632)=38 BASE0=@  ->	FB MOD=0 value=0x0*/ {5632, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5735)=41 MODE=2 BASE0=XED_REG_RIP EASZ=3  ->	FB MOD=0 value=0x0*/ {5735, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5120)=47 BASE0=@  ->	FB MOD=0 value=0x0*/ {5120, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(4608)=56 BASE0=@  ->	FB MOD=0 value=0x0*/ {4608, 0},
/*empty slot1 */ {0,0},
/*h(5224)=58 MODE=2 BASE0=XED_REG_EIP EASZ=2  ->	FB MOD=0 value=0x0*/ {5224, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(4096)=65 BASE0=@  ->	FB MOD=0 value=0x0*/ {4096, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5682)=73 MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {5682, 2},
/*h(3584)=74 BASE0=@  ->	FB MOD=0 value=0x0*/ {3584, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5683)=81 MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {5683, 2},
/*h(5170)=82 MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {5170, 2},
/*h(3072)=83 BASE0=@  ->	FB MOD=0 value=0x0*/ {3072, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5684)=89 MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {5684, 2},
/*h(5171)=90 MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {5171, 2},
/*h(4658)=91 MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {4658, 2},
/*h(2560)=92 BASE0=@  ->	FB MOD=0 value=0x0*/ {2560, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5685)=97 MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {5685, 2},
/*h(5172)=98 MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {5172, 2},
/*h(4659)=99 MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {4659, 2},
/*h(4146)=100 MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {4146, 2},
/*h(2048)=101 BASE0=@  ->	FB MOD=0 value=0x0*/ {2048, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5686)=105 MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {5686, 2},
/*h(5173)=106 MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {5173, 2},
/*h(4660)=107 MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {4660, 2},
/*h(4147)=108 MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {4147, 2},
/*h(3634)=109 MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {3634, 2},
/*h(1536)=110 BASE0=@  ->	FB MOD=0 value=0x0*/ {1536, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5687)=113 MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {5687, 2},
/*h(5174)=114 MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {5174, 2},
/*h(4661)=115 MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {4661, 2},
/*h(4148)=116 MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {4148, 2},
/*h(3635)=117 MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {3635, 2},
/*h(3122)=118 MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {3122, 2},
/*h(1024)=119 BASE0=@  ->	FB MOD=0 value=0x0*/ {1024, 0},
/*empty slot1 */ {0,0},
/*h(5688)=121 MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {5688, 2},
/*h(5175)=122 MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {5175, 2},
/*h(4662)=123 MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {4662, 2},
/*h(4149)=124 MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {4149, 2},
/*h(3636)=125 MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {3636, 2},
/*h(3123)=126 MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {3123, 2},
/*h(2610)=127 MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {2610, 2},
/*h(512)=128 BASE0=@  ->	FB MOD=0 value=0x0*/ {512, 0},
/*h(5689)=129 MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {5689, 2},
/*h(5176)=130 MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {5176, 2},
/*h(4663)=131 MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {4663, 2},
/*h(4150)=132 MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {4150, 2},
/*h(3637)=133 MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {3637, 2},
/*h(3124)=134 MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {3124, 2},
/*h(2611)=135 MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {2611, 2},
/*h(2098)=136 MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2*/ {2098, 2},
/*h(5690)=137 MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2*/ {5690, 2},
/*h(5177)=138 MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {5177, 2},
/*h(4664)=139 MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {4664, 2},
/*h(4151)=140 MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {4151, 2},
/*h(3638)=141 MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {3638, 2},
/*h(3125)=142 MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {3125, 2},
/*h(2612)=143 MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {2612, 2},
/*h(2099)=144 MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2*/ {2099, 2},
/*h(5691)=145 MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2*/ {5691, 2},
/*h(5178)=146 MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2*/ {5178, 2},
/*h(4665)=147 MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {4665, 2},
/*h(4152)=148 MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {4152, 2},
/*h(3639)=149 MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {3639, 2},
/*h(3126)=150 MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {3126, 2},
/*h(2613)=151 MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {2613, 2},
/*h(2100)=152 MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2*/ {2100, 2},
/*h(5692)=153 MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2*/ {5692, 2},
/*h(5179)=154 MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2*/ {5179, 2},
/*h(4666)=155 MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2*/ {4666, 2},
/*h(4153)=156 MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {4153, 2},
/*h(3640)=157 MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {3640, 2},
/*h(3127)=158 MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {3127, 2},
/*h(2614)=159 MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {2614, 2},
/*h(2101)=160 MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2*/ {2101, 2},
/*h(5693)=161 MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2*/ {5693, 2},
/*h(5180)=162 MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2*/ {5180, 2},
/*h(4667)=163 MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2*/ {4667, 2},
/*h(4154)=164 MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2*/ {4154, 2},
/*h(3641)=165 MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {3641, 2},
/*h(3128)=166 MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {3128, 2},
/*h(2615)=167 MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {2615, 2},
/*h(2102)=168 MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2*/ {2102, 2},
/*h(5694)=169 MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2*/ {5694, 2},
/*h(5181)=170 MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2*/ {5181, 2},
/*h(4668)=171 MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2*/ {4668, 2},
/*h(4155)=172 MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2*/ {4155, 2},
/*empty slot1 */ {0,0},
/*h(3129)=174 MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {3129, 2},
/*h(2616)=175 MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {2616, 2},
/*h(2103)=176 MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2*/ {2103, 2},
/*h(5695)=177 MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2*/ {5695, 2},
/*h(5182)=178 MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2*/ {5182, 2},
/*h(4669)=179 MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2*/ {4669, 2},
/*h(4156)=180 MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2*/ {4156, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(2617)=183 MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {2617, 2},
/*h(2104)=184 MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2*/ {2104, 2},
/*h(5696)=185 MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2*/ {5696, 2},
/*h(5183)=186 MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2*/ {5183, 2},
/*h(4670)=187 MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2*/ {4670, 2},
/*h(4157)=188 MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2*/ {4157, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(2105)=192 MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2*/ {2105, 2},
/*h(5697)=193 MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2*/ {5697, 2},
/*h(5184)=194 MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2*/ {5184, 2},
/*h(4671)=195 MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2*/ {4671, 2},
/*h(4158)=196 MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2*/ {4158, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(5185)=202 MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2*/ {5185, 2},
/*h(4672)=203 MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2*/ {4672, 2},
/*h(4159)=204 MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2*/ {4159, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(4673)=211 MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2*/ {4673, 2},
/*h(4160)=212 MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2*/ {4160, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(4161)=220 MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2*/ {4161, 2},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0_EASZ_MODE(xes);
hidx = ((8*key % 821) % 228);
if(lu_table[hidx].key == key) {
    xed3_operand_set_mod(xes,lu_table[hidx].mod);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_BND_R_CHECK_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t error;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(0)=0 REXR=0 REG=0x0  ->	nothing*/ {-1},
/*h(1)=1 REXR=0 REG=0x1  ->	nothing*/ {-1},
/*h(2)=2 REXR=0 REG=0x2  ->	nothing*/ {-1},
/*h(3)=3 REXR=0 REG=0x3  ->	nothing*/ {-1},
/*h(4)=4 REXR=0 REG=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(5)=5 REXR=0 REG=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(6)=6 REXR=0 REG=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(7)=7 REXR=0 REG=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(8)=8 REXR=1 REG=0x0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(9)=9 REXR=1 REG=0x1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(10)=10 REXR=1 REG=0x2  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(11)=11 REXR=1 REG=0x3  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(12)=12 REXR=1 REG=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(13)=13 REXR=1 REG=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(14)=14 REXR=1 REG=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR},
/*h(15)=15 REXR=1 REG=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {XED_ERROR_GENERAL_ERROR}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_REG_REXR(xes);
hidx = key - 0;
if(hidx <= 15) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_VSIB_ENC_INDEX_YMM_BIND(xed_encoder_request_t* xes)
{
typedef struct { xed_int8_t rexx ;xed_int8_t sibindex;} lu_entry_t;
static const lu_entry_t lu_table[16] = {
/*h(210)=0 INDEX=XED_REG_YMM0  ->	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0*/ {0,0},
/*h(211)=1 INDEX=XED_REG_YMM1  ->	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1*/ {0,1},
/*h(212)=2 INDEX=XED_REG_YMM2  ->	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2*/ {0,2},
/*h(213)=3 INDEX=XED_REG_YMM3  ->	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3*/ {0,3},
/*h(214)=4 INDEX=XED_REG_YMM4  ->	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4*/ {0,4},
/*h(215)=5 INDEX=XED_REG_YMM5  ->	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5*/ {0,5},
/*h(216)=6 INDEX=XED_REG_YMM6  ->	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6*/ {0,6},
/*h(217)=7 INDEX=XED_REG_YMM7  ->	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7*/ {0,7},
/*h(218)=8 INDEX=XED_REG_YMM8  ->	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0*/ {1,0},
/*h(219)=9 INDEX=XED_REG_YMM9  ->	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1*/ {1,1},
/*h(220)=10 INDEX=XED_REG_YMM10  ->	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2*/ {1,2},
/*h(221)=11 INDEX=XED_REG_YMM11  ->	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3*/ {1,3},
/*h(222)=12 INDEX=XED_REG_YMM12  ->	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4*/ {1,4},
/*h(223)=13 INDEX=XED_REG_YMM13  ->	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5*/ {1,5},
/*h(224)=14 INDEX=XED_REG_YMM14  ->	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6*/ {1,6},
/*h(225)=15 INDEX=XED_REG_YMM15  ->	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7*/ {1,7}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_INDEX(xes);
hidx = key - 210;
if(hidx <= 15) {
    xed3_operand_set_rexx(xes,lu_table[hidx].rexx);
    xed3_operand_set_sibindex(xes,lu_table[hidx].sibindex);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_TUPLE1_BYTE_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_MODRM_RM_ENCODE_EA16_SIB0_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t rm ;xed_nt_func_ptr_t ntptr0;} lu_entry_t;
static const lu_entry_t lu_table[9] = {
/*h(0)=0 BASE0=@ INDEX=@  ->	nt NT[DISP_WIDTH_16] 	FB RM=6 value=0x6*/ {0, 6,xed_encode_nonterminal_DISP_WIDTH_16_BIND},
/*h(39)=1 BASE0=XED_REG_BP INDEX=@  ->	nt NT[DISP_WIDTH_0_8_16] 	FB RM=6 value=0x6*/ {39, 6,xed_encode_nonterminal_DISP_WIDTH_0_8_16_BIND},
/*h(40)=2 BASE0=XED_REG_SI INDEX=@  ->	FB RM=4 value=0x4*/ {40, 4,0},
/*h(41)=3 BASE0=XED_REG_DI INDEX=@  ->	FB RM=5 value=0x5*/ {41, 5,0},
/*h(21029)=4 BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB RM=1 value=0x1*/ {21029, 1,0},
/*h(20517)=5 BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB RM=0 value=0x0*/ {20517, 0,0},
/*h(21031)=6 BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB RM=3 value=0x3*/ {21031, 3,0},
/*h(20519)=7 BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB RM=2 value=0x2*/ {20519, 2,0},
/*h(37)=8 BASE0=XED_REG_BX INDEX=@  ->	FB RM=7 value=0x7*/ {37, 7,0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
xed_uint64_t res = 1;
key = xed_enc_lu_BASE0_INDEX(xes);
hidx = ((30*key % 29) % 9);
if(lu_table[hidx].key == key) {
    xed3_operand_set_rm(xes,lu_table[hidx].rm);
    if(lu_table[hidx].ntptr0 != 0) res=(*lu_table[hidx].ntptr0)(xes);
    xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE_EA16_SIB0=hidx+1;
    return res;
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_FIXUP_EOSZ_ENC_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t eosz;} lu_entry_t;
static const lu_entry_t lu_table[3] = {
/*h(0)=0 MODE=0 EOSZ=0  ->	FB EOSZ=1 value=0x1*/ {0, 1},
/*h(4)=1 MODE=1 EOSZ=0  ->	FB EOSZ=2 value=0x2*/ {4, 2},
/*h(8)=2 MODE=2 EOSZ=0  ->	FB EOSZ=2 value=0x2*/ {8, 2}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_EOSZ_MODE(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 3ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    xed3_operand_set_eosz(xes,lu_table[hidx].eosz);
    return 1;
}
else{
    return 1;
}
}
xed_uint32_t xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t default_seg;} lu_entry_t;
static const lu_entry_t lu_table[108] = {
/*h(0)=0 BASE0=@  ->	FB DEFAULT_SEG=0 value=0x0*/ {0, 0},
/*empty slot1 */ {0,0},
/*h(1078)=2 BASE0=XED_REG_ESP EASZ=2  ->	FB DEFAULT_SEG=1 value=0x1*/ {1078, 1},
/*h(1617)=3 BASE0=XED_REG_R15 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1617, 0},
/*h(1083)=4 BASE0=XED_REG_R9D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1083, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1602)=7 BASE0=XED_REG_RAX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1602, 0},
/*empty slot1 */ {0,0},
/*h(1607)=9 BASE0=XED_REG_RBP EASZ=3  ->	FB DEFAULT_SEG=1 value=0x1*/ {1607, 1},
/*h(547)=10 BASE0=XED_REG_CX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {547, 0},
/*h(1086)=11 BASE0=XED_REG_R12D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1086, 0},
/*h(552)=12 BASE0=XED_REG_SI EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {552, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1610)=16 BASE0=XED_REG_R8 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1610, 0},
/*h(1076)=17 BASE0=XED_REG_EDX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1076, 0},
/*h(1615)=18 BASE0=XED_REG_R13 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1615, 0},
/*h(555)=19 BASE0=XED_REG_R9W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {555, 0},
/*empty slot1 */ {0,0},
/*h(560)=21 BASE0=XED_REG_R14W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {560, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1079)=24 BASE0=XED_REG_EBP EASZ=2  ->	FB DEFAULT_SEG=1 value=0x1*/ {1079, 1},
/*empty slot1 */ {0,0},
/*h(1084)=26 BASE0=XED_REG_R10D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1084, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1603)=29 BASE0=XED_REG_RCX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1603, 0},
/*empty slot1 */ {0,0},
/*h(1608)=31 BASE0=XED_REG_RSI EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1608, 0},
/*h(548)=32 BASE0=XED_REG_DX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {548, 0},
/*h(1087)=33 BASE0=XED_REG_R13D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1087, 0},
/*h(553)=34 BASE0=XED_REG_DI EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {553, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1611)=38 BASE0=XED_REG_R9 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1611, 0},
/*h(1077)=39 BASE0=XED_REG_EBX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1077, 0},
/*h(1616)=40 BASE0=XED_REG_R14 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1616, 0},
/*h(556)=41 BASE0=XED_REG_R10W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {556, 0},
/*h(1024)=42 BASE0=@  ->	FB DEFAULT_SEG=0 value=0x0*/ {1024, 0},
/*h(561)=43 BASE0=XED_REG_R15W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {561, 0},
/*empty slot1 */ {0,0},
/*h(1639)=45 BASE0=XED_REG_RIP EASZ=3  ->	nothing*/ {1639, -1},
/*h(1080)=46 BASE0=XED_REG_ESI EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1080, 0},
/*h(546)=47 BASE0=XED_REG_AX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {546, 0},
/*h(1085)=48 BASE0=XED_REG_R11D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1085, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1604)=51 BASE0=XED_REG_RDX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1604, 0},
/*empty slot1 */ {0,0},
/*h(1609)=53 BASE0=XED_REG_RDI EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1609, 0},
/*h(549)=54 BASE0=XED_REG_BX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {549, 0},
/*h(1088)=55 BASE0=XED_REG_R14D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1088, 0},
/*h(554)=56 BASE0=XED_REG_R8W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {554, 0},
/*empty slot1 */ {0,0},
/*h(1536)=58 BASE0=@  ->	FB DEFAULT_SEG=0 value=0x0*/ {1536, 0},
/*empty slot1 */ {0,0},
/*h(1612)=60 BASE0=XED_REG_R10 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1612, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(557)=63 BASE0=XED_REG_R11W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {557, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1081)=68 BASE0=XED_REG_EDI EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1081, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1605)=73 BASE0=XED_REG_RBX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1605, 0},
/*empty slot1 */ {0,0},
/*h(512)=75 BASE0=@  ->	FB DEFAULT_SEG=0 value=0x0*/ {512, 0},
/*h(550)=76 BASE0=XED_REG_SP EASZ=1  ->	FB DEFAULT_SEG=1 value=0x1*/ {550, 1},
/*h(1089)=77 BASE0=XED_REG_R15D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1089, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1074)=81 BASE0=XED_REG_EAX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1074, 0},
/*h(1613)=82 BASE0=XED_REG_R11 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1613, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(558)=85 BASE0=XED_REG_R12W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {558, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1082)=90 BASE0=XED_REG_R8D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1082, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1606)=95 BASE0=XED_REG_RSP EASZ=3  ->	FB DEFAULT_SEG=1 value=0x1*/ {1606, 1},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(551)=98 BASE0=XED_REG_BP EASZ=1  ->	FB DEFAULT_SEG=1 value=0x1*/ {551, 1},
/*empty slot1 */ {0,0},
/*h(1128)=100 BASE0=XED_REG_EIP EASZ=2  ->	nothing*/ {1128, -1},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(1075)=103 BASE0=XED_REG_ECX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0*/ {1075, 0},
/*h(1614)=104 BASE0=XED_REG_R12 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0*/ {1614, 0},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(559)=107 BASE0=XED_REG_R13W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0*/ {559, 0}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_BASE0_EASZ(xes);
hidx = ((22*key % 167) % 108);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].default_seg >= 0) xed3_operand_set_default_seg(xes,lu_table[hidx].default_seg);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_NELEM_QUARTERMEM_BIND(xed_encoder_request_t* xes)
{
return 1;
(void)xes;
return 1;
}
xed_uint32_t xed_encode_nonterminal_REMOVE_SEGMENT_AGEN1_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_int8_t error;} lu_entry_t;
static const lu_entry_t lu_table[12] = {
/*h(0)=0 SEG0=@  ->	nothing*/ {0, -1},
/*h(149)=1 SEG0=XED_REG_ES  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {149, XED_ERROR_GENERAL_ERROR},
/*empty slot1 */ {0,0},
/*h(151)=3 SEG0=XED_REG_FS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {151, XED_ERROR_GENERAL_ERROR},
/*empty slot1 */ {0,0},
/*h(148)=5 SEG0=XED_REG_DS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {148, XED_ERROR_GENERAL_ERROR},
/*empty slot1 */ {0,0},
/*empty slot1 */ {0,0},
/*h(150)=8 SEG0=XED_REG_SS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {150, XED_ERROR_GENERAL_ERROR},
/*empty slot1 */ {0,0},
/*h(147)=10 SEG0=XED_REG_CS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {147, XED_ERROR_GENERAL_ERROR},
/*h(152)=11 SEG0=XED_REG_GS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR*/ {152, XED_ERROR_GENERAL_ERROR}
};
xed_union64_t t, u;
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_SEG0(xes);
hidx = (t.u64 = 2654435769  * key, u.u64 = t.s.lo32 * 12ULL, u.s.hi32);
if(lu_table[hidx].key == key) {
    if(lu_table[hidx].error >= 0) xed3_operand_set_error(xes,lu_table[hidx].error);
    return 1;
}
else{
    return 0;
}
}
xed_uint32_t xed_encode_nonterminal_DISP_NT_BIND(xed_encoder_request_t* xes)
{
typedef struct {xed_uint32_t key; xed_uint32_t emit;} lu_entry_t;
static const lu_entry_t lu_table[4] = {
/*h(8)=0 DISP_WIDTH=8 DISP[dddddddd]=*  ->	emit dddddddd emit_type=letters nbits=8*/ {8, 1},
/*h(32)=1 DISP_WIDTH=32 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit dddddddddddddddddddddddddddddddd emit_type=letters nbits=32*/ {32, 2},
/*h(64)=2 DISP_WIDTH=64 DISP[dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd]=*  ->	emit dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd emit_type=letters nbits=64*/ {64, 3},
/*h(16)=3 DISP_WIDTH=16 DISP[dddddddddddddddd]=*  ->	emit dddddddddddddddd emit_type=letters nbits=16*/ {16, 4}
};
xed_uint64_t key = 0;
xed_uint64_t hidx = 0;
key = xed_enc_lu_DISP_WIDTH(xes);
hidx = ((3*key % 5) % 4);
if(lu_table[hidx].key == key) {
    xed_encoder_request_iforms(xes)->x_DISP_NT=lu_table[hidx].emit;
    return 1;
}
else{
    return 1;
}
}
