/// @file xed-encoder-3.c

// This file was automatically generated.
// Do not edit this file.

/*BEGIN_LEGAL

Copyright (c) 2018 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
#include "xed-internal-header.h"
#include "xed-encoder.h"
#include "xed-encode-private.h"
#include "xed-enc-operand-lu.h"
#include "xed-operand-accessors.h"
xed_uint_t xed_encode_nonterminal_REX_PREFIX_ENC_EMIT(xed_encoder_request_t* xes)
{
/* REX_PREFIX_ENC()::
	MODE=2 NOREX=0 NEEDREX=1 REXW[w]=* REXB[b]=* REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REX=1 REXW[w]=* REXB[b]=* REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=1 REXB[b]=* REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=* REXB[b]=1 REXX[x]=* REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=* REXB[b]=* REXX[x]=1 REXR[r]=*  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NOREX=0 REXW[w]=* REXB[b]=* REXX[x]=* REXR[r]=1  ->	emit 0b0100 emit_type=numeric value=0x4 nbits=4 	emit wrxb emit_type=letters nbits=4
	MODE=2 NEEDREX=0 REX=0 REXW=0 REXB=0 REXX=0 REXR=0  ->	nothing
	MODE=1 REX=0 REXW=0 REXB=0 REXX=0 REXR=0  ->	nothing
	MODE=0 REX=0 REXW=0 REXB=0 REXX=0 REXR=0  ->	nothing
	MODE=2 NOREX=1 NEEDREX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXW=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE=2 NOREX=1 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_REX_PREFIX_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,4,0x4);
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_rexw(xes)<< 3)|(xed3_operand_get_rexr(xes)<< 2)|(xed3_operand_get_rexx(xes)<< 1)|(xed3_operand_get_rexb(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,4,0x4);
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_rexw(xes)<< 3)|(xed3_operand_get_rexr(xes)<< 2)|(xed3_operand_get_rexx(xes)<< 1)|(xed3_operand_get_rexb(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,4,0x4);
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_rexw(xes)<< 3)|(xed3_operand_get_rexr(xes)<< 2)|(xed3_operand_get_rexx(xes)<< 1)|(xed3_operand_get_rexb(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,4,0x4);
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_rexw(xes)<< 3)|(xed3_operand_get_rexr(xes)<< 2)|(xed3_operand_get_rexx(xes)<< 1)|(xed3_operand_get_rexb(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,4,0x4);
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_rexw(xes)<< 3)|(xed3_operand_get_rexr(xes)<< 2)|(xed3_operand_get_rexx(xes)<< 1)|(xed3_operand_get_rexb(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 6 */ if (iform==6) {
    xed_encoder_request_encode_emit(xes,4,0x4);
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_rexw(xes)<< 3)|(xed3_operand_get_rexr(xes)<< 2)|(xed3_operand_get_rexx(xes)<< 1)|(xed3_operand_get_rexb(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (1) { /* nothing */
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_0_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_0()::
	DISP_WIDTH=0  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_FIXUP_EASZ_ENC_EMIT(xed_encoder_request_t* xes)
{
/* FIXUP_EASZ_ENC()::
	MODE=0 EASZ=0  ->	FB EASZ=1 value=0x1
	MODE=1 EASZ=0  ->	FB EASZ=2 value=0x2
	MODE=2 EASZ=0  ->	FB EASZ=3 value=0x3
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_0_8_16_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_0_8_16()::
	DISP_WIDTH=0  ->	nothing
	DISP_WIDTH=8  ->	nothing
	DISP_WIDTH=16  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_FIX_ROUND_LEN128_EMIT(xed_encoder_request_t* xes)
{
/* FIX_ROUND_LEN128()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VEX_REXR_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VEX_REXR_ENC()::
	MODE=2 REXR=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1
	MODE=2 REXR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE!=2 REXR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE!=2 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEX_REXR_ENC;
/* 7 */ if (iform==7) {
    xed_encoder_request_encode_emit(xes,1,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_16_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_16()::
	DISP_WIDTH=16  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_XOP_REXXB_ENC_EMIT(xed_encoder_request_t* xes)
{
/* XOP_REXXB_ENC()::
	MODE=2 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2
	MODE=2 REXX=1 REXB=0  ->	emit 0b01 emit_type=numeric value=0x1 nbits=2
	MODE=2 REXX=0 REXB=1  ->	emit 0b10 emit_type=numeric value=0x2 nbits=2
	MODE=2 REXX=1 REXB=1  ->	emit 0b00 emit_type=numeric value=0x0 nbits=2
	MODE!=2 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2
	MODE!=2 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE!=2 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE!=2 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_XOP_REXXB_ENC;
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,2,0x3);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 11 */ if (iform==11) {
    xed_encoder_request_encode_emit(xes,2,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    xed_encoder_request_encode_emit(xes,2,0x2);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 15 */ if (iform==15) {
    xed_encoder_request_encode_emit(xes,2,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,2,0x3);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_VSIB_ENC_SCALE_EMIT(xed_encoder_request_t* xes)
{
/* VSIB_ENC_SCALE()::
	SCALE=0  ->	FB SIBSCALE=0 value=0x0
	SCALE=1  ->	FB SIBSCALE=0 value=0x0
	SCALE=2  ->	FB SIBSCALE=1 value=0x1
	SCALE=4  ->	FB SIBSCALE=2 value=0x2
	SCALE=8  ->	FB SIBSCALE=3 value=0x3
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_RM_ENCODE_EANOT16_SIB1_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_RM_ENCODE_EANOT16_SIB1()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIBINDEX_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* SIBINDEX_ENCODE()::
	SIB=1  ->	nt NT[SIBINDEX_ENCODE_SIB1]
	SIB=0  ->	nothing
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SIBINDEX_ENCODE;
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_SIBINDEX_ENCODE_SIB1_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (1) { /* nothing */
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_ESIZE_64_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_64_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_EVEX_62_REXR_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_62_REXR_ENC()::
	MODE=2 REXR=1  ->	emit 0x62 emit_type=numeric value=0x62 nbits=8 	emit 0b0 emit_type=numeric value=0x0 nbits=1
	MODE=2 REXR=0  ->	emit 0x62 emit_type=numeric value=0x62 nbits=8 	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXR=0  ->	emit 0x62 emit_type=numeric value=0x62 nbits=8 	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_62_REXR_ENC;
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,8,0x62);
    xed_encoder_request_encode_emit(xes,1,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,8,0x62);
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,8,0x62);
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE1_WORD_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE1_WORD()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_SCALAR_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_SCALAR()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIBINDEX_ENCODE_SIB1_EMIT(xed_encoder_request_t* xes)
{
/* SIBINDEX_ENCODE_SIB1()::
	INDEX=@  ->	FB SIBINDEX=4 value=0x4 	FB REXX=0 value=0x0
	INDEX=XED_REG_AX EASZ=1  ->	FB SIBINDEX=0 value=0x0 	FB REXX=0 value=0x0
	INDEX=XED_REG_EAX EASZ=2  ->	FB SIBINDEX=0 value=0x0 	FB REXX=0 value=0x0
	INDEX=XED_REG_RAX EASZ=3  ->	FB SIBINDEX=0 value=0x0 	FB REXX=0 value=0x0
	INDEX=XED_REG_R8W EASZ=1  ->	FB SIBINDEX=0 value=0x0 	FB REXX=1 value=0x1
	INDEX=XED_REG_R8D EASZ=2  ->	FB SIBINDEX=0 value=0x0 	FB REXX=1 value=0x1
	INDEX=XED_REG_R8 EASZ=3  ->	FB SIBINDEX=0 value=0x0 	FB REXX=1 value=0x1
	INDEX=XED_REG_CX EASZ=1  ->	FB SIBINDEX=1 value=0x1 	FB REXX=0 value=0x0
	INDEX=XED_REG_ECX EASZ=2  ->	FB SIBINDEX=1 value=0x1 	FB REXX=0 value=0x0
	INDEX=XED_REG_RCX EASZ=3  ->	FB SIBINDEX=1 value=0x1 	FB REXX=0 value=0x0
	INDEX=XED_REG_R9W EASZ=1  ->	FB SIBINDEX=1 value=0x1 	FB REXX=1 value=0x1
	INDEX=XED_REG_R9D EASZ=2  ->	FB SIBINDEX=1 value=0x1 	FB REXX=1 value=0x1
	INDEX=XED_REG_R9 EASZ=3  ->	FB SIBINDEX=1 value=0x1 	FB REXX=1 value=0x1
	INDEX=XED_REG_DX EASZ=1  ->	FB SIBINDEX=2 value=0x2 	FB REXX=0 value=0x0
	INDEX=XED_REG_EDX EASZ=2  ->	FB SIBINDEX=2 value=0x2 	FB REXX=0 value=0x0
	INDEX=XED_REG_RDX EASZ=3  ->	FB SIBINDEX=2 value=0x2 	FB REXX=0 value=0x0
	INDEX=XED_REG_R10W EASZ=1  ->	FB SIBINDEX=2 value=0x2 	FB REXX=1 value=0x1
	INDEX=XED_REG_R10D EASZ=2  ->	FB SIBINDEX=2 value=0x2 	FB REXX=1 value=0x1
	INDEX=XED_REG_R10 EASZ=3  ->	FB SIBINDEX=2 value=0x2 	FB REXX=1 value=0x1
	INDEX=XED_REG_BX EASZ=1  ->	FB SIBINDEX=3 value=0x3 	FB REXX=0 value=0x0
	INDEX=XED_REG_EBX EASZ=2  ->	FB SIBINDEX=3 value=0x3 	FB REXX=0 value=0x0
	INDEX=XED_REG_RBX EASZ=3  ->	FB SIBINDEX=3 value=0x3 	FB REXX=0 value=0x0
	INDEX=XED_REG_R11W EASZ=1  ->	FB SIBINDEX=3 value=0x3 	FB REXX=1 value=0x1
	INDEX=XED_REG_R11D EASZ=2  ->	FB SIBINDEX=3 value=0x3 	FB REXX=1 value=0x1
	INDEX=XED_REG_R11 EASZ=3  ->	FB SIBINDEX=3 value=0x3 	FB REXX=1 value=0x1
	INDEX=XED_REG_R12W EASZ=1  ->	FB SIBINDEX=4 value=0x4 	FB REXX=1 value=0x1
	INDEX=XED_REG_R12D EASZ=2  ->	FB SIBINDEX=4 value=0x4 	FB REXX=1 value=0x1
	INDEX=XED_REG_R12 EASZ=3  ->	FB SIBINDEX=4 value=0x4 	FB REXX=1 value=0x1
	INDEX=XED_REG_BP EASZ=1  ->	FB SIBINDEX=5 value=0x5 	FB REXX=0 value=0x0
	INDEX=XED_REG_EBP EASZ=2  ->	FB SIBINDEX=5 value=0x5 	FB REXX=0 value=0x0
	INDEX=XED_REG_RBP EASZ=3  ->	FB SIBINDEX=5 value=0x5 	FB REXX=0 value=0x0
	INDEX=XED_REG_R13W EASZ=1  ->	FB SIBINDEX=5 value=0x5 	FB REXX=1 value=0x1
	INDEX=XED_REG_R13D EASZ=2  ->	FB SIBINDEX=5 value=0x5 	FB REXX=1 value=0x1
	INDEX=XED_REG_R13 EASZ=3  ->	FB SIBINDEX=5 value=0x5 	FB REXX=1 value=0x1
	INDEX=XED_REG_SI EASZ=1  ->	FB SIBINDEX=6 value=0x6 	FB REXX=0 value=0x0
	INDEX=XED_REG_ESI EASZ=2  ->	FB SIBINDEX=6 value=0x6 	FB REXX=0 value=0x0
	INDEX=XED_REG_RSI EASZ=3  ->	FB SIBINDEX=6 value=0x6 	FB REXX=0 value=0x0
	INDEX=XED_REG_R14W EASZ=1  ->	FB SIBINDEX=6 value=0x6 	FB REXX=1 value=0x1
	INDEX=XED_REG_R14D EASZ=2  ->	FB SIBINDEX=6 value=0x6 	FB REXX=1 value=0x1
	INDEX=XED_REG_R14 EASZ=3  ->	FB SIBINDEX=6 value=0x6 	FB REXX=1 value=0x1
	INDEX=XED_REG_DI EASZ=1  ->	FB SIBINDEX=7 value=0x7 	FB REXX=0 value=0x0
	INDEX=XED_REG_EDI EASZ=2  ->	FB SIBINDEX=7 value=0x7 	FB REXX=0 value=0x0
	INDEX=XED_REG_RDI EASZ=3  ->	FB SIBINDEX=7 value=0x7 	FB REXX=0 value=0x0
	INDEX=XED_REG_R15W EASZ=1  ->	FB SIBINDEX=7 value=0x7 	FB REXX=1 value=0x1
	INDEX=XED_REG_R15D EASZ=2  ->	FB SIBINDEX=7 value=0x7 	FB REXX=1 value=0x1
	INDEX=XED_REG_R15 EASZ=3  ->	FB SIBINDEX=7 value=0x7 	FB REXX=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_EVEX_REXX_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_REXX_ENC()::
	MODE=2 REXX=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1
	MODE=2 REXX=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXX=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXX=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_REXX_ENC;
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,1,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_XOP_TYPE_ENC_EMIT(xed_encoder_request_t* xes)
{
/* XOP_TYPE_ENC()::
	MAP=8  ->	emit 0x8F emit_type=numeric value=0x8f nbits=8
	MAP=9  ->	emit 0x8F emit_type=numeric value=0x8f nbits=8
	MAP=10  ->	emit 0x8F emit_type=numeric value=0x8f nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_XOP_TYPE_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,0x8f);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,8,0x8f);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,8,0x8f);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_ESIZE_8_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_8_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_BYTE_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_STORE_BYTE()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_MOVDDUP_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_MOVDDUP()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_IMMUNE66_EMIT(xed_encoder_request_t* xes)
{
/* IMMUNE66()::
	MODE=0  ->	FB EOSZ=2 value=0x2 	FB DF32=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SIBBASE_ENCODE_SIB1_EMIT(xed_encoder_request_t* xes)
{
/* SIBBASE_ENCODE_SIB1()::
	BASE0=XED_REG_AX EASZ=1  ->	FB SIBBASE=0 value=0x0 	FB REXB=0 value=0x0
	BASE0=XED_REG_EAX EASZ=2  ->	FB SIBBASE=0 value=0x0 	FB REXB=0 value=0x0
	BASE0=XED_REG_RAX EASZ=3  ->	FB SIBBASE=0 value=0x0 	FB REXB=0 value=0x0
	BASE0=XED_REG_R8W EASZ=1  ->	FB SIBBASE=0 value=0x0 	FB REXB=1 value=0x1
	BASE0=XED_REG_R8D EASZ=2  ->	FB SIBBASE=0 value=0x0 	FB REXB=1 value=0x1
	BASE0=XED_REG_R8 EASZ=3  ->	FB SIBBASE=0 value=0x0 	FB REXB=1 value=0x1
	BASE0=XED_REG_CX EASZ=1  ->	FB SIBBASE=1 value=0x1 	FB REXB=0 value=0x0
	BASE0=XED_REG_ECX EASZ=2  ->	FB SIBBASE=1 value=0x1 	FB REXB=0 value=0x0
	BASE0=XED_REG_RCX EASZ=3  ->	FB SIBBASE=1 value=0x1 	FB REXB=0 value=0x0
	BASE0=XED_REG_R9W EASZ=1  ->	FB SIBBASE=1 value=0x1 	FB REXB=1 value=0x1
	BASE0=XED_REG_R9D EASZ=2  ->	FB SIBBASE=1 value=0x1 	FB REXB=1 value=0x1
	BASE0=XED_REG_R9 EASZ=3  ->	FB SIBBASE=1 value=0x1 	FB REXB=1 value=0x1
	BASE0=XED_REG_DX EASZ=1  ->	FB SIBBASE=2 value=0x2 	FB REXB=0 value=0x0
	BASE0=XED_REG_EDX EASZ=2  ->	FB SIBBASE=2 value=0x2 	FB REXB=0 value=0x0
	BASE0=XED_REG_RDX EASZ=3  ->	FB SIBBASE=2 value=0x2 	FB REXB=0 value=0x0
	BASE0=XED_REG_R10W EASZ=1  ->	FB SIBBASE=2 value=0x2 	FB REXB=1 value=0x1
	BASE0=XED_REG_R10D EASZ=2  ->	FB SIBBASE=2 value=0x2 	FB REXB=1 value=0x1
	BASE0=XED_REG_R10 EASZ=3  ->	FB SIBBASE=2 value=0x2 	FB REXB=1 value=0x1
	BASE0=XED_REG_BX EASZ=1  ->	FB SIBBASE=3 value=0x3 	FB REXB=0 value=0x0
	BASE0=XED_REG_EBX EASZ=2  ->	FB SIBBASE=3 value=0x3 	FB REXB=0 value=0x0
	BASE0=XED_REG_RBX EASZ=3  ->	FB SIBBASE=3 value=0x3 	FB REXB=0 value=0x0
	BASE0=XED_REG_R11W EASZ=1  ->	FB SIBBASE=3 value=0x3 	FB REXB=1 value=0x1
	BASE0=XED_REG_R11D EASZ=2  ->	FB SIBBASE=3 value=0x3 	FB REXB=1 value=0x1
	BASE0=XED_REG_R11 EASZ=3  ->	FB SIBBASE=3 value=0x3 	FB REXB=1 value=0x1
	BASE0=XED_REG_SP EASZ=1  ->	FB SIBBASE=4 value=0x4 	FB REXB=0 value=0x0
	BASE0=XED_REG_ESP EASZ=2  ->	FB SIBBASE=4 value=0x4 	FB REXB=0 value=0x0
	BASE0=XED_REG_RSP EASZ=3  ->	FB SIBBASE=4 value=0x4 	FB REXB=0 value=0x0
	BASE0=XED_REG_R12W EASZ=1  ->	FB SIBBASE=4 value=0x4 	FB REXB=1 value=0x1
	BASE0=XED_REG_R12D EASZ=2  ->	FB SIBBASE=4 value=0x4 	FB REXB=1 value=0x1
	BASE0=XED_REG_R12 EASZ=3  ->	FB SIBBASE=4 value=0x4 	FB REXB=1 value=0x1
	BASE0=XED_REG_SI EASZ=1  ->	FB SIBBASE=6 value=0x6 	FB REXB=0 value=0x0
	BASE0=XED_REG_ESI EASZ=2  ->	FB SIBBASE=6 value=0x6 	FB REXB=0 value=0x0
	BASE0=XED_REG_RSI EASZ=3  ->	FB SIBBASE=6 value=0x6 	FB REXB=0 value=0x0
	BASE0=XED_REG_R14W EASZ=1  ->	FB SIBBASE=6 value=0x6 	FB REXB=1 value=0x1
	BASE0=XED_REG_R14D EASZ=2  ->	FB SIBBASE=6 value=0x6 	FB REXB=1 value=0x1
	BASE0=XED_REG_R14 EASZ=3  ->	FB SIBBASE=6 value=0x6 	FB REXB=1 value=0x1
	BASE0=XED_REG_DI EASZ=1  ->	FB SIBBASE=7 value=0x7 	FB REXB=0 value=0x0
	BASE0=XED_REG_EDI EASZ=2  ->	FB SIBBASE=7 value=0x7 	FB REXB=0 value=0x0
	BASE0=XED_REG_RDI EASZ=3  ->	FB SIBBASE=7 value=0x7 	FB REXB=0 value=0x0
	BASE0=XED_REG_R15W EASZ=1  ->	FB SIBBASE=7 value=0x7 	FB REXB=1 value=0x1
	BASE0=XED_REG_R15D EASZ=2  ->	FB SIBBASE=7 value=0x7 	FB REXB=1 value=0x1
	BASE0=XED_REG_R15 EASZ=3  ->	FB SIBBASE=7 value=0x7 	FB REXB=1 value=0x1
	BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0
	BASE0=XED_REG_BP EASZ=1  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0
	BASE0=XED_REG_EBP EASZ=2  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0
	BASE0=XED_REG_RBP EASZ=3  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=0 value=0x0
	BASE0=XED_REG_R13W EASZ=1  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=1 value=0x1
	BASE0=XED_REG_R13D EASZ=2  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=1 value=0x1
	BASE0=XED_REG_R13 EASZ=3  ->	nt NT[DISP_WIDTH_0_8_32] 	FB SIBBASE=5 value=0x5 	FB REXB=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SIBBASE_ENCODE_SIB1;
/* 91 */ if (iform==91) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 14 */ if (iform==14) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 41 */ if (iform==41) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 28 */ if (iform==28) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 46 */ if (iform==46) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 73 */ if (iform==73) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 95 */ if (iform==95) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 18 */ if (iform==18) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 45 */ if (iform==45) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 32 */ if (iform==32) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 50 */ if (iform==50) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 77 */ if (iform==77) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 22 */ if (iform==22) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 49 */ if (iform==49) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 36 */ if (iform==36) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 54 */ if (iform==54) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 81 */ if (iform==81) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 8 */ if (iform==8) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 26 */ if (iform==26) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 53 */ if (iform==53) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 40 */ if (iform==40) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 58 */ if (iform==58) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 85 */ if (iform==85) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 12 */ if (iform==12) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 30 */ if (iform==30) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 57 */ if (iform==57) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 44 */ if (iform==44) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 62 */ if (iform==62) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 89 */ if (iform==89) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 20 */ if (iform==20) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 38 */ if (iform==38) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 65 */ if (iform==65) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 52 */ if (iform==52) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 70 */ if (iform==70) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 97 */ if (iform==97) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 24 */ if (iform==24) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 42 */ if (iform==42) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 69 */ if (iform==69) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 56 */ if (iform==56) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 74 */ if (iform==74) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 101 */ if (iform==101) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 13 */ if (iform==13) {
    xed_encode_nonterminal_DISP_WIDTH_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 16 */ if (iform==16) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 34 */ if (iform==34) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 61 */ if (iform==61) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 48 */ if (iform==48) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 66 */ if (iform==66) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 93 */ if (iform==93) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_CR_WIDTH_EMIT(xed_encoder_request_t* xes)
{
/* CR_WIDTH()::
	MODE=0  ->	FB DF32=1 value=0x1 	FB EOSZ=2 value=0x2
	MODE=2  ->	FB DF64=1 value=0x1 	FB EOSZ=3 value=0x3
	MODE=1  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_READER_WORD_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_READER_WORD()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VEX_MAP_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VEX_MAP_ENC()::
	VEX_C4=1 MAP=0 REXW[w]=*  ->	emit 0b0_0000 emit_type=numeric value=0x0 nbits=5 	emit w emit_type=letters nbits=1
	VEX_C4=1 MAP=1 REXW[w]=*  ->	emit 0b0_0001 emit_type=numeric value=0x1 nbits=5 	emit w emit_type=letters nbits=1
	VEX_C4=1 MAP=2 REXW[w]=*  ->	emit 0b0_0010 emit_type=numeric value=0x2 nbits=5 	emit w emit_type=letters nbits=1
	VEX_C4=1 MAP=3 REXW[w]=*  ->	emit 0b0_0011 emit_type=numeric value=0x3 nbits=5 	emit w emit_type=letters nbits=1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEX_MAP_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,5,0x0);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,5,0x1);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,5,0x2);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,5,0x3);
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA64_DISP8_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA64_DISP8()::
	BASE0=XED_REG_RAX  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RBX  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RCX  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RDX  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RSP  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RBP  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RSI  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_RDI  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R8  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R9  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R10  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R11  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R12  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R13  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R14  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_R15  ->	FB MOD=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA64_DISP0_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA64_DISP0()::
	BASE0=XED_REG_RAX  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RBX  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RCX  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RDX  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RSI  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RDI  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_RSP  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R8  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R9  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R10  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R11  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R12  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R14  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_R15  ->	FB MOD=0 value=0x0
	BASE0=XED_REG_EIP  ->	FB MOD=0 value=0x0 	FB DISP_WIDTH=32 value=0x20 	FB DISP=0 value=0x0
	BASE0=XED_REG_RIP  ->	FB MOD=0 value=0x0 	FB DISP_WIDTH=32 value=0x20 	FB DISP=0 value=0x0
	BASE0=XED_REG_RBP  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	BASE0=XED_REG_R13  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE2_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE2()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_PREFIX_ENC_BIND(xed_encoder_request_t* xes)
{
/* PREFIX_ENC()::
	REP=2  ->	emit 0xf2 emit_type=numeric value=0xf2 nbits=8 	FB NO_RETURN=1 value=0x1
	REP=3  ->	emit 0xf3 emit_type=numeric value=0xf3 nbits=8 	FB NO_RETURN=1 value=0x1
	OSZ=1  ->	emit 0x66 emit_type=numeric value=0x66 nbits=8 	FB NO_RETURN=1 value=0x1
	ASZ=1  ->	emit 0x67 emit_type=numeric value=0x67 nbits=8 	FB NO_RETURN=1 value=0x1
	LOCK=1  ->	emit 0xf0 emit_type=numeric value=0xf0 nbits=8 	FB NO_RETURN=1 value=0x1
	SEG_OVD=4  ->	emit 0x64 emit_type=numeric value=0x64 nbits=8 	FB NO_RETURN=1 value=0x1
	SEG_OVD=5  ->	emit 0x65 emit_type=numeric value=0x65 nbits=8 	FB NO_RETURN=1 value=0x1
	MODE=2 HINT=3  ->	emit 0x2e emit_type=numeric value=0x2e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE=2 HINT=4  ->	emit 0x3e emit_type=numeric value=0x3e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=1  ->	emit 0x2e emit_type=numeric value=0x2e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 HINT=3  ->	emit 0x2e emit_type=numeric value=0x2e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=2  ->	emit 0x3e emit_type=numeric value=0x3e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 HINT=4  ->	emit 0x3e emit_type=numeric value=0x3e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=3  ->	emit 0x26 emit_type=numeric value=0x26 nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=6  ->	emit 0x36 emit_type=numeric value=0x36 nbits=8 	FB NO_RETURN=1 value=0x1
 */
xed_uint_t okay=1;
xed_uint_t conditions_satisfied=0;
xed_encoder_request_iforms(xes)->x_PREFIX_ENC=0;
conditions_satisfied = (xed3_operand_get_rep(xes) == 2);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<1);
}
conditions_satisfied = (xed3_operand_get_rep(xes) == 3);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<2);
}
conditions_satisfied = (xed3_operand_get_osz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<3);
}
conditions_satisfied = (xed3_operand_get_asz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<4);
}
conditions_satisfied = (xed3_operand_get_lock(xes) == 1);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<5);
}
conditions_satisfied = (xed3_operand_get_seg_ovd(xes) == 4);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<6);
}
conditions_satisfied = (xed3_operand_get_seg_ovd(xes) == 5);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<7);
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_hint(xes) == 3);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<8);
}
conditions_satisfied = (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_hint(xes) == 4);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<9);
}
conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_seg_ovd(xes) == 1);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<10);
}
conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_hint(xes) == 3);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<11);
}
conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_seg_ovd(xes) == 2);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<12);
}
conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_hint(xes) == 4);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<13);
}
conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_seg_ovd(xes) == 3);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<14);
}
conditions_satisfied = (xed3_operand_get_mode(xes) != 2) &&
		 (xed3_operand_get_seg_ovd(xes) == 6);
if (conditions_satisfied) {
    okay=1;
/* no code required for NO_RETURN binding */
    xed_encoder_request_iforms(xes)->x_PREFIX_ENC |=(1<<15);
}
conditions_satisfied = 1;
if (conditions_satisfied) {
    okay=1;
/* FIXME action code not done yet for return 1*/
    if (okay) return 1;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) conditions_satisfied;
}
xed_uint_t xed_encode_nonterminal_PREFIX_ENC_EMIT(xed_encoder_request_t* xes)
{
/* PREFIX_ENC()::
	REP=2  ->	emit 0xf2 emit_type=numeric value=0xf2 nbits=8 	FB NO_RETURN=1 value=0x1
	REP=3  ->	emit 0xf3 emit_type=numeric value=0xf3 nbits=8 	FB NO_RETURN=1 value=0x1
	OSZ=1  ->	emit 0x66 emit_type=numeric value=0x66 nbits=8 	FB NO_RETURN=1 value=0x1
	ASZ=1  ->	emit 0x67 emit_type=numeric value=0x67 nbits=8 	FB NO_RETURN=1 value=0x1
	LOCK=1  ->	emit 0xf0 emit_type=numeric value=0xf0 nbits=8 	FB NO_RETURN=1 value=0x1
	SEG_OVD=4  ->	emit 0x64 emit_type=numeric value=0x64 nbits=8 	FB NO_RETURN=1 value=0x1
	SEG_OVD=5  ->	emit 0x65 emit_type=numeric value=0x65 nbits=8 	FB NO_RETURN=1 value=0x1
	MODE=2 HINT=3  ->	emit 0x2e emit_type=numeric value=0x2e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE=2 HINT=4  ->	emit 0x3e emit_type=numeric value=0x3e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=1  ->	emit 0x2e emit_type=numeric value=0x2e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 HINT=3  ->	emit 0x2e emit_type=numeric value=0x2e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=2  ->	emit 0x3e emit_type=numeric value=0x3e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 HINT=4  ->	emit 0x3e emit_type=numeric value=0x3e nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=3  ->	emit 0x26 emit_type=numeric value=0x26 nbits=8 	FB NO_RETURN=1 value=0x1
	MODE!=2 SEG_OVD=6  ->	emit 0x36 emit_type=numeric value=0x36 nbits=8 	FB NO_RETURN=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_PREFIX_ENC;
/* no return */ if (iform&(1<<1)) {
    xed_encoder_request_encode_emit(xes,8,0xf2);
}
/* no return */ if (iform&(1<<2)) {
    xed_encoder_request_encode_emit(xes,8,0xf3);
}
/* no return */ if (iform&(1<<3)) {
    xed_encoder_request_encode_emit(xes,8,0x66);
}
/* no return */ if (iform&(1<<4)) {
    xed_encoder_request_encode_emit(xes,8,0x67);
}
/* no return */ if (iform&(1<<5)) {
    xed_encoder_request_encode_emit(xes,8,0xf0);
}
/* no return */ if (iform&(1<<6)) {
    xed_encoder_request_encode_emit(xes,8,0x64);
}
/* no return */ if (iform&(1<<7)) {
    xed_encoder_request_encode_emit(xes,8,0x65);
}
/* no return */ if (iform&(1<<8)) {
    xed_encoder_request_encode_emit(xes,8,0x2e);
}
/* no return */ if (iform&(1<<9)) {
    xed_encoder_request_encode_emit(xes,8,0x3e);
}
/* no return */ if (iform&(1<<10)) {
    xed_encoder_request_encode_emit(xes,8,0x2e);
}
/* no return */ if (iform&(1<<11)) {
    xed_encoder_request_encode_emit(xes,8,0x2e);
}
/* no return */ if (iform&(1<<12)) {
    xed_encoder_request_encode_emit(xes,8,0x3e);
}
/* no return */ if (iform&(1<<13)) {
    xed_encoder_request_encode_emit(xes,8,0x3e);
}
/* no return */ if (iform&(1<<14)) {
    xed_encoder_request_encode_emit(xes,8,0x26);
}
/* no return */ if (iform&(1<<15)) {
    xed_encoder_request_encode_emit(xes,8,0x36);
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_REFINING66_EMIT(xed_encoder_request_t* xes)
{
/* REFINING66()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_RM_ENCODE_EA64_SIB0_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_RM_ENCODE_EA64_SIB0()::
	BASE0=XED_REG_RIP  ->	FB RM=5 value=0x5
	BASE0=XED_REG_EIP  ->	FB RM=5 value=0x5
	BASE0=XED_REG_RAX  ->	FB RM=0 value=0x0 	FB REXB=0 value=0x0
	BASE0=XED_REG_R8  ->	FB RM=0 value=0x0 	FB REXB=1 value=0x1
	BASE0=XED_REG_RCX  ->	FB RM=1 value=0x1 	FB REXB=0 value=0x0
	BASE0=XED_REG_R9  ->	FB RM=1 value=0x1 	FB REXB=1 value=0x1
	BASE0=XED_REG_RDX  ->	FB RM=2 value=0x2 	FB REXB=0 value=0x0
	BASE0=XED_REG_R10  ->	FB RM=2 value=0x2 	FB REXB=1 value=0x1
	BASE0=XED_REG_RBX  ->	FB RM=3 value=0x3 	FB REXB=0 value=0x0
	BASE0=XED_REG_R11  ->	FB RM=3 value=0x3 	FB REXB=1 value=0x1
	BASE0=XED_REG_RSI  ->	FB RM=6 value=0x6 	FB REXB=0 value=0x0
	BASE0=XED_REG_R14  ->	FB RM=6 value=0x6 	FB REXB=1 value=0x1
	BASE0=XED_REG_RDI  ->	FB RM=7 value=0x7 	FB REXB=0 value=0x0
	BASE0=XED_REG_R15  ->	FB RM=7 value=0x7 	FB REXB=1 value=0x1
	BASE0=@  ->	nt NT[DISP_WIDTH_32] 	FB RM=5 value=0x5
	BASE0=XED_REG_RBP  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=0 value=0x0
	BASE0=XED_REG_R13  ->	nt NT[DISP_WIDTH_0_8_32] 	FB RM=5 value=0x5 	FB REXB=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE_EA64_SIB0;
/* 14 */ if (iform==14) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 17 */ if (iform==17) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 12 */ if (iform==12) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 10 */ if (iform==10) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 5 */ if (iform==5) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 15 */ if (iform==15) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 13 */ if (iform==13) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 8 */ if (iform==8) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 9 */ if (iform==9) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 6 */ if (iform==6) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encode_nonterminal_DISP_WIDTH_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 16 */ if (iform==16) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 11 */ if (iform==11) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_32_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_VSIB_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VSIB_ENC()::
	DUMMY=0 SIBBASE[bbb]=* SIBINDEX[iii]=* SIBSCALE[ss]=*  ->	emit ss_iii_bbb emit_type=letters nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VSIB_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_sibscale(xes)<< 6)|(xed3_operand_get_sibindex(xes)<< 3)|(xed3_operand_get_sibbase(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_EVEX_REXB_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_REXB_ENC()::
	MODE=2 REXB=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1
	MODE=2 REXB=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXB=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_REXB_ENC;
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,1,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_ESIZE_32_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_32_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VEXED_REX_EMIT(xed_encoder_request_t* xes)
{
/* VEXED_REX()::
	VEXVALID=3  ->	nt NT[XOP_ENC]
	VEXVALID=0  ->	nt NT[REX_PREFIX_ENC]
	VEXVALID=1  ->	nt NT[NEWVEX_ENC]
	VEXVALID=2  ->	nt NT[EVEX_ENC]
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEXED_REX;
/* 4 */ if (iform==4) {
    xed_encode_nonterminal_XOP_ENC_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encode_nonterminal_REX_PREFIX_ENC_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_NEWVEX_ENC_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encode_nonterminal_EVEX_ENC_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_VEX_REXXB_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VEX_REXXB_ENC()::
	MODE=2 VEX_C4=1 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2
	MODE=2 VEX_C4=1 REXX=1 REXB=0  ->	emit 0b01 emit_type=numeric value=0x1 nbits=2
	MODE=2 VEX_C4=1 REXX=0 REXB=1  ->	emit 0b10 emit_type=numeric value=0x2 nbits=2
	MODE=2 VEX_C4=1 REXX=1 REXB=1  ->	emit 0b00 emit_type=numeric value=0x0 nbits=2
	MODE!=2 VEX_C4=1 REXX=0 REXB=0  ->	emit 0b11 emit_type=numeric value=0x3 nbits=2
	MODE!=2 VEX_C4=1 REXX=1 REXB=0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE!=2 VEX_C4=1 REXX=0 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	MODE!=2 VEX_C4=1 REXX=1 REXB=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEX_REXXB_ENC;
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,2,0x3);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 11 */ if (iform==11) {
    xed_encoder_request_encode_emit(xes,2,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    xed_encoder_request_encode_emit(xes,2,0x2);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 15 */ if (iform==15) {
    xed_encoder_request_encode_emit(xes,2,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,2,0x3);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_HALF_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_HALF()::
	BCAST!=0  ->	FB BCRC=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_EVEX_REXRR_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_REXRR_ENC()::
	MODE=2 REXRR=1  ->	emit 0b0 emit_type=numeric value=0x0 nbits=1
	MODE=2 REXRR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXRR=0  ->	emit 0b1 emit_type=numeric value=0x1 nbits=1
	MODE=1 REXRR=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_REXRR_ENC;
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,1,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,1,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_AVX512_EVEX_BYTE3_ENC_EMIT(xed_encoder_request_t* xes)
{
/* AVX512_EVEX_BYTE3_ENC()::
	ZEROING[z]=* LLRC[nn]=* BCRC[b]=* VEXDEST4=0 MASK[aaa]=*  ->	emit z_nn_b emit_type=letters nbits=4 	emit 0b1 emit_type=numeric value=0x1 nbits=1 	emit aaa emit_type=letters nbits=3
	ZEROING[z]=* LLRC[nn]=* BCRC[b]=* VEXDEST4=1 MASK[aaa]=*  ->	emit z_nn_b emit_type=letters nbits=4 	emit 0b0 emit_type=numeric value=0x0 nbits=1 	emit aaa emit_type=letters nbits=3
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_AVX512_EVEX_BYTE3_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_zeroing(xes)<< 3)|(xed3_operand_get_llrc(xes)<< 1)|(xed3_operand_get_bcrc(xes)));
    xed_encoder_request_encode_emit(xes,1,0x1);
    xed_encoder_request_encode_emit(xes,3,(xed3_operand_get_mask(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_zeroing(xes)<< 3)|(xed3_operand_get_llrc(xes)<< 1)|(xed3_operand_get_bcrc(xes)));
    xed_encoder_request_encode_emit(xes,1,0x0);
    xed_encoder_request_encode_emit(xes,3,(xed3_operand_get_mask(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_EVEX_REXW_VVVV_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_REXW_VVVV_ENC()::
	DUMMY=0 REXW[w]=* VEXDEST3[u]=* VEXDEST210[ddd]=*  ->	emit w emit_type=letters nbits=1 	emit u_ddd emit_type=letters nbits=4
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_REXW_VVVV_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,1,(xed3_operand_get_rexw(xes)));
    xed_encoder_request_encode_emit(xes,4,(xed3_operand_get_vexdest3(xes)<< 3)|(xed3_operand_get_vexdest210(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_8_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_8()::
	DISP_WIDTH=8  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_UISA_ENC_INDEX_YMM_EMIT(xed_encoder_request_t* xes)
{
/* UISA_ENC_INDEX_YMM()::
	INDEX=XED_REG_YMM0  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_YMM1  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_YMM2  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_YMM3  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_YMM4  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_YMM5  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_YMM6  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_YMM7  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_YMM8  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_YMM9  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_YMM10  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_YMM11  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_YMM12  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_YMM13  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_YMM14  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_YMM15  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_YMM16  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_YMM17  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_YMM18  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_YMM19  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_YMM20  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_YMM21  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_YMM22  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_YMM23  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_YMM24  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_YMM25  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_YMM26  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_YMM27  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_YMM28  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_YMM29  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_YMM30  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_YMM31  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA32_DISP32_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA32_DISP32()::
	BASE0=@  ->	FB MOD=0 value=0x0
	MODE=2 BASE0=XED_REG_EIP EASZ=2  ->	FB MOD=0 value=0x0
	MODE=2 BASE0=XED_REG_RIP EASZ=3  ->	FB MOD=0 value=0x0
	MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2
	MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2
	MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_BND_R_CHECK_EMIT(xed_encoder_request_t* xes)
{
/* BND_R_CHECK()::
	REXR=0 REG=0x0  ->	nothing
	REXR=0 REG=0x1  ->	nothing
	REXR=0 REG=0x2  ->	nothing
	REXR=0 REG=0x3  ->	nothing
	REXR=0 REG=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=0 REG=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=0 REG=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=0 REG=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x2  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x3  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXR=1 REG=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VSIB_ENC_INDEX_YMM_EMIT(xed_encoder_request_t* xes)
{
/* VSIB_ENC_INDEX_YMM()::
	INDEX=XED_REG_YMM0  ->	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_YMM1  ->	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_YMM2  ->	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_YMM3  ->	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_YMM4  ->	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_YMM5  ->	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_YMM6  ->	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_YMM7  ->	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_YMM8  ->	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_YMM9  ->	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_YMM10  ->	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_YMM11  ->	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_YMM12  ->	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_YMM13  ->	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_YMM14  ->	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_YMM15  ->	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_TUPLE1_BYTE_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_TUPLE1_BYTE()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_RM_ENCODE_EA16_SIB0_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_RM_ENCODE_EA16_SIB0()::
	BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB RM=0 value=0x0
	BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB RM=1 value=0x1
	BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB RM=2 value=0x2
	BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB RM=3 value=0x3
	BASE0=XED_REG_SI INDEX=@  ->	FB RM=4 value=0x4
	BASE0=XED_REG_DI INDEX=@  ->	FB RM=5 value=0x5
	BASE0=XED_REG_BX INDEX=@  ->	FB RM=7 value=0x7
	BASE0=@ INDEX=@  ->	nt NT[DISP_WIDTH_16] 	FB RM=6 value=0x6
	BASE0=XED_REG_BP INDEX=@  ->	nt NT[DISP_WIDTH_0_8_16] 	FB RM=6 value=0x6
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE_EA16_SIB0;
/* 6 */ if (iform==6) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 5 */ if (iform==5) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 8 */ if (iform==8) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 9 */ if (iform==9) {
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 1 */ if (iform==1) {
    xed_encode_nonterminal_DISP_WIDTH_16_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_DISP_WIDTH_0_8_16_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_FIXUP_EOSZ_ENC_EMIT(xed_encoder_request_t* xes)
{
/* FIXUP_EOSZ_ENC()::
	MODE=0 EOSZ=0  ->	FB EOSZ=1 value=0x1
	MODE=1 EOSZ=0  ->	FB EOSZ=2 value=0x2
	MODE=2 EOSZ=0  ->	FB EOSZ=2 value=0x2
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SEGMENT_DEFAULT_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* SEGMENT_DEFAULT_ENCODE()::
	BASE0=@  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_SP EASZ=1  ->	FB DEFAULT_SEG=1 value=0x1
	BASE0=XED_REG_ESP EASZ=2  ->	FB DEFAULT_SEG=1 value=0x1
	BASE0=XED_REG_RSP EASZ=3  ->	FB DEFAULT_SEG=1 value=0x1
	BASE0=XED_REG_BP EASZ=1  ->	FB DEFAULT_SEG=1 value=0x1
	BASE0=XED_REG_EBP EASZ=2  ->	FB DEFAULT_SEG=1 value=0x1
	BASE0=XED_REG_RBP EASZ=3  ->	FB DEFAULT_SEG=1 value=0x1
	BASE0=XED_REG_AX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_EAX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_RAX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_CX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_ECX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_RCX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_DX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_EDX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_RDX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_BX EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_EBX EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_RBX EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_SI EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_ESI EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_RSI EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_DI EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_EDI EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_RDI EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R8W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R8D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R8 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R9W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R9D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R9 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R10W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R10D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R10 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R11W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R11D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R11 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R12W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R12D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R12 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R13W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R13D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R13 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R14W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R14D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R14 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R15W EASZ=1  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R15D EASZ=2  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_R15 EASZ=3  ->	FB DEFAULT_SEG=0 value=0x0
	BASE0=XED_REG_EIP EASZ=2  ->	nothing
	BASE0=XED_REG_RIP EASZ=3  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_QUARTERMEM_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_QUARTERMEM()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_REMOVE_SEGMENT_AGEN1_EMIT(xed_encoder_request_t* xes)
{
/* REMOVE_SEGMENT_AGEN1()::
	SEG0=@  ->	nothing
	SEG0=XED_REG_DS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	SEG0=XED_REG_CS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	SEG0=XED_REG_ES  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	SEG0=XED_REG_FS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	SEG0=XED_REG_GS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	SEG0=XED_REG_SS  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_DISP_NT_EMIT(xed_encoder_request_t* xes)
{
/* DISP_NT()::
	DISP_WIDTH=8 DISP[dddddddd]=*  ->	emit dddddddd emit_type=letters nbits=8
	DISP_WIDTH=16 DISP[dddddddddddddddd]=*  ->	emit dddddddddddddddd emit_type=letters nbits=16
	DISP_WIDTH=32 DISP[dddddddddddddddddddddddddddddddd]=*  ->	emit dddddddddddddddddddddddddddddddd emit_type=letters nbits=32
	DISP_WIDTH=64 DISP[dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd]=*  ->	emit dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd emit_type=letters nbits=64
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_DISP_NT;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,16,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,32,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,64,(xed3_operand_get_disp(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_VMODRM_MOD_ENCODE_BIND(xed_encoder_request_t* xes)
{
/* VMODRM_MOD_ENCODE()::
	EASZ=2 DISP_WIDTH=8  ->	FB MOD=1 value=0x1
	EASZ=2 DISP_WIDTH=32 BASE0=@  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=32 BASE0=@  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_AX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EAX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RAX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_BX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EBX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RBX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_CX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_ECX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RCX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_DX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EDX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RDX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_SI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_ESI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RSI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_DI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EDI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RDI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_SP EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_ESP EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RSP EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R8W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R8D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R8 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R9W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R9D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R9 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R10W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R10D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R10 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R11W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R11D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R11 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R12W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R12D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R12 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R14W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R14D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R14 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R15W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R15D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R15 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_AX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EAX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RAX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_BX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EBX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RBX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_CX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_ECX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RCX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_DX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EDX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RDX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_SI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_ESI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RSI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_DI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EDI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RDI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_SP EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_ESP EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RSP EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R8W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R8D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R8 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R9W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R9D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R9 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R10W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R10D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R10 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R11W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R11D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R11 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R12W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R12D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R12 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R14W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R14D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R14 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R15W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R15D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R15 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RAX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RBX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RCX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RDX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RSP  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RBP  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RSI  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RDI  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R8  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R9  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R10  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R11  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R12  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R13  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R14  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R15  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_AX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EAX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RAX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_BX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EBX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RBX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_CX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_ECX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RCX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_DX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EDX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RDX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_SI EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_ESI EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RSI EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_DI EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EDI EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RDI EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_SP EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_ESP EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RSP EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_BP EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EBP EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RBP EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R8W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R8D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R8 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R9W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R9D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R9 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R10W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R10D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R10 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R11W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R11D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R11 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R12W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R12D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R12 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R13W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R13D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R13 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R14W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R14D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R14 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R15W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R15D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R15 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_BP EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EBP EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RBP EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_R13W EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_R13D EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_R13 EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_BP EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EBP EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RBP EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R13W EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R13D EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R13 EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
 */
xed_uint_t okay=1;
xed_uint_t conditions_satisfied=0;
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 8);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_INVALID);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_AX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EAX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RAX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_BX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_CX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ECX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RCX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_DX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SI) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESI) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSI) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_DI) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDI) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDI) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_AX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EAX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RAX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_BX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_CX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ECX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RCX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_DX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SI) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESI) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSI) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_DI) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDI) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDI) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RAX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RCX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 8) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_AX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EAX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RAX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_BX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_CX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ECX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RCX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_DX) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDX) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDX) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SI) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESI) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSI) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_DI) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDI) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RDI) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_SP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RSP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_BP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EAX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ECX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 1) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EAX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ECX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDX);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBP);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_ESI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EDI);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R8D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R9D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R10D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R11D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R12D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R14D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 32) &&
		 (xed3_operand_get_mode(xes) == 2) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R15D);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,2);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_BP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 2) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_BP) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_EBP) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_RBP) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13W) &&
		 (xed3_operand_get_easz(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13D) &&
		 (xed3_operand_get_easz(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_easz(xes) == 3) &&
		 (xed3_operand_get_disp_width(xes) == 0) &&
		 (xed3_operand_get_base0(xes) == XED_REG_R13) &&
		 (xed3_operand_get_easz(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_mod(xes,1);
    xed3_operand_set_disp_width(xes,8);
    xed3_operand_set_disp(xes,0);
    if (okay) return 1;
}
conditions_satisfied = 1;
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_error(xes,XED_ERROR_GENERAL_ERROR);
    return 0; /* error */
/* FIXME action code not done yet for return 1*/
    if (okay) return 1;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) conditions_satisfied;
}
xed_uint_t xed_encode_nonterminal_VMODRM_MOD_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* VMODRM_MOD_ENCODE()::
	EASZ=2 DISP_WIDTH=8  ->	FB MOD=1 value=0x1
	EASZ=2 DISP_WIDTH=32 BASE0=@  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=32 BASE0=@  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_AX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EAX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RAX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_BX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EBX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RBX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_CX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_ECX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RCX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_DX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EDX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RDX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_SI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_ESI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RSI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_DI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EDI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RDI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_SP EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_ESP EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RSP EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R8W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R8D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R8 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R9W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R9D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R9 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R10W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R10D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R10 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R11W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R11D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R11 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R12W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R12D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R12 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R14W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R14D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R14 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R15W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R15D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=2 DISP_WIDTH=0 MODE=2 BASE0=XED_REG_R15 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_AX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EAX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RAX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_BX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EBX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RBX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_CX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_ECX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RCX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_DX EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EDX EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RDX EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_SI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_ESI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RSI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_DI EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EDI EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RDI EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_SP EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_ESP EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RSP EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R8W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R8D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R8 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R9W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R9D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R9 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R10W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R10D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R10 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R11W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R11D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R11 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R12W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R12D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R12 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R14W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R14D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R14 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R15W EASZ=1  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R15D EASZ=2  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R15 EASZ=3  ->	FB MOD=0 value=0x0
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RAX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RBX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RCX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RDX  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RSP  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RBP  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RSI  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_RDI  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R8  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R9  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R10  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R11  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R12  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R13  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R14  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=8 BASE0=XED_REG_R15  ->	FB MOD=1 value=0x1
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_AX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EAX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RAX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_BX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EBX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RBX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_CX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_ECX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RCX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_DX EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EDX EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RDX EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_SI EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_ESI EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RSI EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_DI EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EDI EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RDI EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_SP EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_ESP EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RSP EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_BP EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_EBP EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_RBP EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R8W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R8D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R8 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R9W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R9D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R9 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R10W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R10D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R10 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R11W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R11D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R11 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R12W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R12D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R12 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R13W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R13D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R13 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R14W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R14D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R14 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R15W EASZ=1  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R15D EASZ=2  ->	FB MOD=2 value=0x2
	EASZ=3 DISP_WIDTH=32 BASE0=XED_REG_R15 EASZ=3  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=1 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EAX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EBX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_ECX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EDX  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_ESP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EBP  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_ESI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_EDI  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R8D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R9D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R10D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R11D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R12D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R13D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R14D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=32 MODE=2 BASE0=XED_REG_R15D  ->	FB MOD=2 value=0x2
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_BP EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_EBP EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_RBP EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_R13W EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_R13D EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=2 DISP_WIDTH=0 BASE0=XED_REG_R13 EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_BP EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_EBP EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_RBP EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R13W EASZ=1  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R13D EASZ=2  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
	EASZ=3 DISP_WIDTH=0 BASE0=XED_REG_R13 EASZ=3  ->	FB MOD=1 value=0x1 	FB DISP_WIDTH=8 value=0x8 	FB DISP=0 value=0x0
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_UISA_ENC_INDEX_ZMM_EMIT(xed_encoder_request_t* xes)
{
/* UISA_ENC_INDEX_ZMM()::
	INDEX=XED_REG_ZMM0  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_ZMM1  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_ZMM2  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_ZMM3  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_ZMM4  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_ZMM5  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_ZMM6  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_ZMM7  ->	FB VEXDEST4=0 value=0x0 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_ZMM8  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_ZMM9  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_ZMM10  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_ZMM11  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_ZMM12  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_ZMM13  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_ZMM14  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_ZMM15  ->	FB VEXDEST4=0 value=0x0 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_ZMM16  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_ZMM17  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_ZMM18  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_ZMM19  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_ZMM20  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_ZMM21  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_ZMM22  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_ZMM23  ->	FB VEXDEST4=1 value=0x1 	FB REXX=0 value=0x0 	FB SIBINDEX=7 value=0x7
	INDEX=XED_REG_ZMM24  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=0 value=0x0
	INDEX=XED_REG_ZMM25  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=1 value=0x1
	INDEX=XED_REG_ZMM26  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=2 value=0x2
	INDEX=XED_REG_ZMM27  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=3 value=0x3
	INDEX=XED_REG_ZMM28  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=4 value=0x4
	INDEX=XED_REG_ZMM29  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=5 value=0x5
	INDEX=XED_REG_ZMM30  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=6 value=0x6
	INDEX=XED_REG_ZMM31  ->	FB VEXDEST4=1 value=0x1 	FB REXX=1 value=0x1 	FB SIBINDEX=7 value=0x7
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_FIXUP_SMODE_ENC_EMIT(xed_encoder_request_t* xes)
{
/* FIXUP_SMODE_ENC()::
	MODE=2 SMODE=0  ->	FB SMODE=2 value=0x2
	MODE=2 SMODE=1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_FORCE64_EMIT(xed_encoder_request_t* xes)
{
/* FORCE64()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GSCAT_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GSCAT()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SEGMENT_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* SEGMENT_ENCODE()::
	DEFAULT_SEG=1 SEG0=@  ->	FB SEG_OVD=0 value=0x0
	DEFAULT_SEG=1 SEG0=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1
	DEFAULT_SEG=1 SEG0=XED_REG_DS  ->	FB SEG_OVD=2 value=0x2
	DEFAULT_SEG=1 SEG0=XED_REG_SS  ->	FB SEG_OVD=0 value=0x0
	DEFAULT_SEG=1 SEG0=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3
	DEFAULT_SEG=1 SEG0=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4
	DEFAULT_SEG=1 SEG0=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5
	DEFAULT_SEG=0 SEG0=@  ->	FB SEG_OVD=0 value=0x0
	DEFAULT_SEG=0 SEG0=XED_REG_CS  ->	FB SEG_OVD=1 value=0x1
	DEFAULT_SEG=0 SEG0=XED_REG_DS  ->	FB SEG_OVD=0 value=0x0
	DEFAULT_SEG=0 SEG0=XED_REG_SS  ->	FB SEG_OVD=6 value=0x6
	DEFAULT_SEG=0 SEG0=XED_REG_ES  ->	FB SEG_OVD=3 value=0x3
	DEFAULT_SEG=0 SEG0=XED_REG_FS  ->	FB SEG_OVD=4 value=0x4
	DEFAULT_SEG=0 SEG0=XED_REG_GS  ->	FB SEG_OVD=5 value=0x5
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_MODRM_RM_ENCODE_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_RM_ENCODE()::
	EASZ=1 SIB=0  ->	nt NT[MODRM_RM_ENCODE_EA16_SIB0]
	EASZ=2 SIB=0  ->	nt NT[MODRM_RM_ENCODE_EA32_SIB0]
	EASZ=3 SIB=0  ->	nt NT[MODRM_RM_ENCODE_EA64_SIB0]
	EASZ!=1 SIB=1  ->	nt NT[MODRM_RM_ENCODE_EANOT16_SIB1]
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_MODRM_RM_ENCODE;
/* 5 */ if (iform==5) {
    xed_encode_nonterminal_MODRM_RM_ENCODE_EA16_SIB0_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encode_nonterminal_MODRM_RM_ENCODE_EA32_SIB0_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 7 */ if (iform==7) {
    xed_encode_nonterminal_MODRM_RM_ENCODE_EA64_SIB0_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 6 */ if (iform==6) {
    xed_encode_nonterminal_MODRM_RM_ENCODE_EANOT16_SIB1_EMIT(xes);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_FIX_ROUND_LEN512_EMIT(xed_encoder_request_t* xes)
{
/* FIX_ROUND_LEN512()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_READER_SUBDWORD_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_READER_SUBDWORD()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_LDOP()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_ERROR_EMIT(xed_encoder_request_t* xes)
{
/* ERROR()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_DISP_WIDTH_32_EMIT(xed_encoder_request_t* xes)
{
/* DISP_WIDTH_32()::
	DISP_WIDTH=32  ->	nothing
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_VEX_TYPE_ENC_BIND(xed_encoder_request_t* xes)
{
/* VEX_TYPE_ENC()::
	REXX=1  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	REXB=1  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	MAP=0  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	MAP=2  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	MAP=3  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	REXW=1  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
 */
xed_uint_t okay=1;
xed_uint_t conditions_satisfied=0;
conditions_satisfied = (xed3_operand_get_rexx(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,1);
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=1;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_rexb(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,1);
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=2;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_map(xes) == 0);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,1);
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=3;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_map(xes) == 2);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,1);
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=4;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_map(xes) == 3);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,1);
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=5;
    if (okay) return 1;
}
conditions_satisfied = (xed3_operand_get_rexw(xes) == 1);
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,1);
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=6;
    if (okay) return 1;
}
conditions_satisfied = 1;
if (conditions_satisfied) {
    okay=1;
    xed3_operand_set_vex_c4(xes,0);
/* FIXME action code not done yet for return 1*/
    xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC=0;
    if (okay) return 1;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) conditions_satisfied;
}
xed_uint_t xed_encode_nonterminal_VEX_TYPE_ENC_EMIT(xed_encoder_request_t* xes)
{
/* VEX_TYPE_ENC()::
	REXX=1  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	REXB=1  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	MAP=0  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	MAP=2  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	MAP=3  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
	REXW=1  ->	emit 0xC4 emit_type=numeric value=0xc4 nbits=8 	FB VEX_C4=1 value=0x1
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_VEX_TYPE_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,0xc4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,8,0xc4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,8,0xc4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,8,0xc4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 5 */ if (iform==5) {
    xed_encoder_request_encode_emit(xes,8,0xc4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 6 */ if (iform==6) {
    xed_encoder_request_encode_emit(xes,8,0xc4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    xed_encoder_request_encode_emit(xes,8,0xc5);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_EVEX_UPP_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_UPP_ENC()::
	VEX_PREFIX=0  ->	emit 0b100 emit_type=numeric value=0x4 nbits=3
	VEX_PREFIX=1  ->	emit 0b101 emit_type=numeric value=0x5 nbits=3
	VEX_PREFIX=3  ->	emit 0b110 emit_type=numeric value=0x6 nbits=3
	VEX_PREFIX=2  ->	emit 0b111 emit_type=numeric value=0x7 nbits=3
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_UPP_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,3,0x4);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,3,0x5);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,3,0x6);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,3,0x7);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_EVEX_MAP_ENC_EMIT(xed_encoder_request_t* xes)
{
/* EVEX_MAP_ENC()::
	MAP=0  ->	emit 0b0000 emit_type=numeric value=0x0 nbits=4
	MAP=1  ->	emit 0b0001 emit_type=numeric value=0x1 nbits=4
	MAP=2  ->	emit 0b0010 emit_type=numeric value=0x2 nbits=4
	MAP=3  ->	emit 0b0011 emit_type=numeric value=0x3 nbits=4
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_EVEX_MAP_ENC;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,4,0x0);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 2 */ if (iform==2) {
    xed_encoder_request_encode_emit(xes,4,0x1);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 3 */ if (iform==3) {
    xed_encoder_request_encode_emit(xes,4,0x2);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
/* 4 */ if (iform==4) {
    xed_encoder_request_encode_emit(xes,4,0x3);
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_NELEM_FULLMEM_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_FULLMEM()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_STORE()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_ESIZE_1_BITS_EMIT(xed_encoder_request_t* xes)
{
/* ESIZE_1_BITS()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_STORE_SUBDWORD_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_STORE_SUBDWORD()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_SE_IMM8_EMIT(xed_encoder_request_t* xes)
{
/* SE_IMM8()::
	DUMMY=0 ESRC[ssss]=* UIMM0[dddd]=*  ->	emit ssss_dddd emit_type=letters nbits=8
 */
xed_uint_t okay=1;
unsigned int iform = xed_encoder_request_iforms(xes)->x_SE_IMM8;
/* 1 */ if (iform==1) {
    xed_encoder_request_encode_emit(xes,8,(xed3_operand_get_esrc(xes)<< 4)|(xed3_operand_get_uimm0(xes)));
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
if (1) { /*otherwise*/
    if (xed3_operand_get_error(xes) != XED_ERROR_NONE) okay=0;
    return okay;
}
return 0; /*pacify the compiler*/
(void) okay;
(void) xes;
(void) iform;
}
xed_uint_t xed_encode_nonterminal_MODRM_MOD_EA16_DISP8_EMIT(xed_encoder_request_t* xes)
{
/* MODRM_MOD_EA16_DISP8()::
	BASE0=XED_REG_BX INDEX=@  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_SI INDEX=@  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_DI INDEX=@  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_BP INDEX=@  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_BP INDEX=XED_REG_SI  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_BP INDEX=XED_REG_DI  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_BX INDEX=XED_REG_SI  ->	FB MOD=1 value=0x1
	BASE0=XED_REG_BX INDEX=XED_REG_DI  ->	FB MOD=1 value=0x1
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_NELEM_GPR_WRITER_LDOP_Q_EMIT(xed_encoder_request_t* xes)
{
/* NELEM_GPR_WRITER_LDOP_Q()::
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
xed_uint_t xed_encode_nonterminal_BND_B_CHECK_EMIT(xed_encoder_request_t* xes)
{
/* BND_B_CHECK()::
	REXB=0 RM=0x0  ->	nothing
	REXB=0 RM=0x1  ->	nothing
	REXB=0 RM=0x2  ->	nothing
	REXB=0 RM=0x3  ->	nothing
	REXB=0 RM=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=0 RM=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=0 RM=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=0 RM=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x0  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x1  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x2  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x3  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x4  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x5  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x6  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
	REXB=1 RM=0x7  ->	FB ERROR=XED_ERROR_GENERAL_ERROR
 */
xed_uint_t okay=1;
return 1;
(void) okay;
(void) xes;
}
