#include "ide.h"

static VectorMap<String, PackageInfo> sPi;

void InvalidatePackageInfo(const String& name)
{
	int q = sPi.Find(name);
	if(q >= 0)
		sPi[q].path.Clear();
}

PackageInfo GetPackageInfo(const String& name)
{
	String path = PackagePath(name);
	Time tm = FileGetTime(path);
	int q = sPi.Find(name);
	if(q >= 0) {
		if(path == sPi[q].path && tm == sPi[q].stamp)
			return sPi[q];
	}
	else {
		q = sPi.GetCount();
		sPi.Add(name);
	}
	PackageInfo& pi = sPi[q];
	pi.path = path;
	pi.stamp = tm;
	Package p;
	p.Load(path);
	pi.ink = p.ink;
	pi.italic = p.italic;
	pi.bold = p.bold;
	return pi;
}

bool BaseSetup(String& vars) { return BaseSetupDlg().Run(vars); }

void BaseSetupDlg::NestTable::SetData(const Value& data)
{
	Vector<String> l = Split((String)data, ';');
	Clear();
	for(int i = 0; i < l.GetCount(); i++)
		Add(l[i]);
}

Value BaseSetupDlg::NestTable::GetData() const
{
	String s;
	for(int i = 0; i < GetCount(); i++) {
		if(i) s << ';';
		s << (String) Get(i, 0);
	}
	return s;
}

bool BaseSetupDlg::NestTable::Key(dword key, int count)
{
	if(key == K_CTRL_C) {
		String s1, s2;
		for(int i = 0 ; i < GetCount(); i++) {
			if(IsSelected(i)) {
				s1 = (String) Get(i, 0);
				if(s1.IsEmpty())
					continue;
				if(i) s2 << ';';
				s2 << s1;
			}
		}
		AppendClipboardText(s2);
		return true;
	}
	return ArrayCtrl::Key(key, count);
}

void BaseSetupDlg::NestTable::SetUppNests(const String& s)
{
	int i = 0;
	for(FindFile ff(ConfigFile("*.var")); ff; ff.Next()) {
		auto fname = GetFileTitle(ff.GetName());
		if(ff.IsFile() && !fname.IsEqual(s)) {
			Nest n;
			if(!n.Load(ff.GetPath()))
				continue;
			auto paths = Split(n.Get("UPP"), ';');
			if(paths.IsEmpty())
				continue;
			const auto& path = paths[0];
			edit_dir.AddPlace(path, IdeImg::Icon, fname);
			i++;
		}
	}
	if(i)
		edit_dir.AddPlaceSeparator();
}

BaseSetupDlg::NestTable::NestTable()
{
	AutoHideSb();
	AddColumn("Nests").Edit(edit);
	Appending().Removing().Inserting().Moving().MultiSelect();
	edit_dir.Attach(edit);
	edit_dir.AllFilesType();
	WhenArrayAction = edit << [=] { Update(); };
}

bool BaseSetupDlg::Run(String& vars)
{
	nests   <<= GetVar("UPP");
	output  <<= GetVar("OUTPUT");
	base    <<= vars;
	
	nests.SetUppNests(vars);

	while(TopWindow::Run() == IDOK)
	{
		String varname = ~base;
		String varfile = VarFilePath(varname);
		if(varname != vars)
		{
			if(FileExists(varfile) && !PromptOKCancel(NFormat("Overwrite existing assembly [* \1%s\1]?", varfile)))
				continue;
			if(!SaveVars(varname))
			{
				Exclamation(NFormat("Error writing assmbly [* \1%s\1].", VarFilePath(varname)));
				continue;
			}
		}
		
		SetVar("UPP", ~nests);
		SetVar("OUTPUT", ~output);
		
		for(auto i = 0; i < nests.GetCount(); i++)
			RealizeDirectory(nests.Get(i, 0));
		RealizeDirectory(~output);
		vars = varname;
		return true;
	}
	return false;
}

BaseSetupDlg::BaseSetupDlg()
{
	CtrlLayoutOKCancel(*this, "Assembly setup");
	dir.SetImage(CtrlImg::Dir());
	container.Add(nests.SizePos());
	
	nests.WhenUpdateRow = [=]
	{
		if(IsNull(base) && nests.GetCount())
			base <<= GetFileName((String) nests.Get(0, 0));
	};
	
	dir.WhenAction = [=]
	{
		auto s = SelectDirectory();
		if(!s.IsEmpty())
			output <<= s;
	};
}
