#ifndef _BFGChecksumVerifier_MySha1_h_
#define _BFGChecksumVerifier_MySha1_h_

#ifdef __cplusplus
extern "C"
{
#endif


typedef struct
{
    uint32_t state[5];
    uint32_t count[2];
    unsigned char buffer[64];
} SHA1_CTX;

void MySHA1Transform(
    uint32_t state[5],
    const unsigned char buffer[64]
    );

void MySHA1Init(
    SHA1_CTX * context
    );

void MySHA1Update(
    SHA1_CTX * context,
    const unsigned char *data,
    uint32_t len
    );

void MySHA1Final(
    unsigned char digest[20],
    SHA1_CTX * context
    );

void MySHA1(
    char *hash_out,
    const char *str,
    int len);
    

#ifdef __cplusplus
}
#endif

#endif
