#include <Core/Core.h>
#include "MySha1.h"

using namespace Upp;

CONSOLE_APP_MAIN
{
    constexpr int chunk = 1024 * 1024;
    constexpr int progress_interval = 1000;
//    static const char * filename = "/tmp/file4GB-.bin";
    static const char * filename = "/tmp/file4GB.bin";
    
    StdLogSetup(LOG_COUT | LOG_TIMESTAMP);
	RLOG("File '" << filename << "' sha1 calculation started");

	//Upp
    Sha1Stream sha1;
    //GIT
	SHA1_CTX ctx;
	MySHA1Init(&ctx);
        
    FileIn file(filename);
    auto size = file.GetSize();
    auto last_progress = msecs();

    while (!file.IsError() && !file.IsEof()) {
        auto buff = file.Get(chunk);
        if (buff.GetCount() <= 0) break;

        sha1.Put(buff);
        MySHA1Update(&ctx, (const unsigned char *)~buff, buff.GetCount());
        
        if (msecs(last_progress) > progress_interval) {
            last_progress = msecs();
            if (size > 0) RLOG("Progress: " << 100 * file.GetPos() / size << "%");
        }
    }

    if (!file.IsError()) {
		RLOG("UPP SHA1: " << sha1.FinishString());
		unsigned char result[21];
		MySHA1Final(result, &ctx);
		RLOG("GIT SHA1: " << HexString(result, 20));
    }else RLOG("File '" << filename << "' sha1 calculation interrupted by error: '" << file.GetErrorText() << "'");
}
