#ifndef _ArrayCtrlDirs_App_h
#define _ArrayCtrlDirs_App_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class EditDir : public EditString {
public:
	typedef EditDir CLASSNAME;
	EditDir();

	FrameRight<Button> btn;

	void OnBar(Bar& menu);
};

class ArrayCtrlDirs : public ArrayCtrl {
public:
	typedef ArrayCtrlDirs CLASSNAME;
	ArrayCtrlDirs();

	ArrayCtrlDirs& SetTitle(const char *text) { HeaderTab(0).SetText(text); return *this; }

	void DoRemoveRow();
	void DoRemoveRows();

	void OnBar(Bar& menu);
	void OnEdit(One<Ctrl>& ctrl);
	void OnSelectDir(EditDir *e);
};

class App : public TopWindow {
public:
	typedef App CLASSNAME;
	App();

	ArrayCtrlDirs list;
	Option ask_remove;
	Button show;

	void OnAskRemove();
	void OnShow();
};

#endif
