#include "App.h"

EditDir::EditDir()
{
	btn.SetImage(CtrlImg::right_arrow());
	AddFrame(btn);
	WhenBar = THISBACK(OnBar);
}

void EditDir::OnBar(Bar& menu)
{
	StdBar(menu);
	menu.Add(t_("Select directory"), CtrlImg::Dir(), btn.WhenAction)
		.Help(t_("Select directory"))
		.Key(K_CTRL_ENTER);
}

ArrayCtrlDirs::ArrayCtrlDirs()
{
	AutoHideSb().Inserting().Removing().Moving();
	AddColumn("").Margin(0).With(THISBACK(OnEdit));
	WhenBar = THISBACK(OnBar);
	EditDir e; e.SetFrame(NullFrame());
	SetLineCy(e.GetStdSize().cy);
}

void ArrayCtrlDirs::DoRemoveRow()
{
	DoRemove();

	if (GetCount() == 0)
		SetFocus();
}

void ArrayCtrlDirs::DoRemoveRows()
{
	if (IsAskRemove() && !PromptOKCancel(RowFormat(t_("Do you really want to delete all %ss ?"))))
		return;

	Clear();
	SetFocus();
}

void ArrayCtrlDirs::OnBar(Bar& menu)
{
	bool e = IsEditable();
	bool c = !IsEdit() && e;
	bool d = c && IsCursor();

	if (!menu.IsEmpty())
		menu.Separator();

	if (IsInserting())
		menu.Add(e, RowFormat(t_("Insert %s")), CtrlImg::Add(), THISBACK(DoInsertAfter))
			.Help(RowFormat(t_("Insert a new %s into the table.")))
			.Key(K_INSERT);

	if (IsRemoving()) {
		menu.Add(d, RowFormat(t_("Delete %s")), CtrlImg::remove(), THISBACK(DoRemoveRow))
			.Help(RowFormat(t_("Delete active %s.")))
			.Key(K_ALT_DELETE);
		menu.Add(GetCount() > 0, RowFormat(t_("Delete all %ss")), CtrlImg::remove(), THISBACK(DoRemoveRows))
			.Help(t_("Delete all table rows."))
			.Key(K_CTRL_D);
	}

	if (IsMoving()) {
		menu.Add(GetCursor() > 0, RowFormat(t_("Move %s up")), CtrlImg::up_arrow(), THISBACK(SwapUp))
			.Help(RowFormat(t_("Swap %s with previous thus moving it up.")))
			.Key(K_CTRL_UP);
		menu.Add(GetCursor() >= 0 && GetCursor() < GetCount() - 1,
		         RowFormat(t_("Move %s down")), CtrlImg::down_arrow(), THISBACK(SwapDown))
			.Help(RowFormat(t_("Swap %s with next thus moving it down.")))
			.Key(K_CTRL_DOWN);
	}
}

void ArrayCtrlDirs::OnEdit(One<Ctrl>& ctrl)
{
	EditDir& e = ctrl.Create<EditDir>();
	e.SetFrame(NullFrame());
	e.btn.NoWantFocus();
	e.btn <<= THISBACK1(OnSelectDir, &e);
	e.WhenBar << THISBACK(OnBar);
}

void ArrayCtrlDirs::OnSelectDir(EditDir *e)
{
	if (!e)
		return;

	e->SetFocus();

	FileSel fs;
	fs.ActiveDir(~*e);

	if (fs.ExecuteSelectDir())
		e->SetData(~fs);
}

App::App()
{
	Title("ArrayCtrlDirs example");
	Sizeable().MinimizeBox();

	const Size sz(640, 480);
	SetRect(sz);

	list.SetTitle("Nest").RowName("nest");
	list.Add(GetCurrentDirectory());
	list.Add(GetDesktopFolder());
	list.Add(GetHomeDirectory());

	ask_remove.Set(1);
	ask_remove.SetLabel(t_("Ask to remove"));
	ask_remove << THISBACK(OnAskRemove);
	show.SetLabel(t_("Show"));
	show <<= THISBACK(OnShow);

	Add(list.HSizePosZ(4, 4).VSizePosZ(4, 2 * 4 + 19));
	Add(ask_remove.LeftPosZ(4, 100).BottomPosZ(4, 19));
	Add(show.RightPosZ(4, 50).BottomPosZ(4, 19));
}

void App::OnAskRemove()
{
	list.AskRemove(ask_remove);
}

void App::OnShow()
{
	int n = list.GetCount();

	if (n == 0)
		return;

	Vector<String> d;

	for (int i = 0; i < n; ++i)
		d.Add(list.Get(i, 0));

	PromptOK(DeQtf(Join(d, ";")));
}

GUI_APP_MAIN
{
	App app;
	app.Run();
}
