#include "AsyncTest.h"

static bool cancel = false;

void AsyncTest::Do(int i)
{
	auto w = Async([=]{
		int done = 0;
		LOG("Thread #" << i << " started.");
		// while(!cancel) {
		while(!CoWork::IsCanceled()) {
			Sleep(10);
			done += 1024 * 1024;
			GuiLock __;
			switch(i) {
				case 0: pr1.Set(done); break;
				case 1: pr2.Set(done); break;
				case 2: pr3.Set(done); break;
				case 3: pr4.Set(done); break;
				default: break;
			}
		}
		LOG("Thread #" << i << " finished.");
	});
	workers.Add(pick(w));
}

void AsyncTest::Start()
{
	cancel = false;
	for(int i = 0; i < 4; i++)
		Do(i);
}

void AsyncTest::Stop()
{
	cancel = true;
	for(auto& w : workers)
		w.Cancel();
}

AsyncTest::AsyncTest()
{
	CtrlLayout(*this, t_("Test"));
	Sizeable().Zoomable();
	start.WhenAction = THISFN(Start);
	stop.WhenAction = THISFN(Stop);
	pr1.Percent().Set(0, INT_MAX);
	pr2.Percent().Set(0, INT_MAX);
	pr3.Percent().Set(0, INT_MAX);
	pr4.Percent().Set(0, INT_MAX);
}

GUI_APP_MAIN
{
	AsyncTest().Run();
}
