#ifndef _GtkDhctrl_h_
#define _GtkDhctrl_h_

#include <CtrlLib/CtrlLib.h>

#ifdef flagGTK

namespace Upp
{

	class GtkDHCtrl : public Ctrl
	{
		int isError;
		bool isMapped;
		Size CurrentSize;
		XVisualInfo* UserVisualInfo;
		String ErrorMessage;
	
		void MapWindow(bool map);
		bool Init(void);
		void Terminate(void);
	
		Window   hwnd;	
		bool isInitialized;
		
	protected:

		struct XWindow {
			Ptr<Ctrl>    ctrl;
			bool         exposed;
			Vector<Rect> invalid;
			Ptr<Ctrl>    owner;
			Ptr<Ctrl>    last_active;
			XIC          xic;
		};

		static XIM  xim;

		ArrayMap<Window, XWindow>& Xwindow();
		XWindow *AddXWindow(Window &w);
		void RemoveXWindow(Window &w);
		XWindow *XWindowFromWindow(Window &w);
		
		Rect GetRectInParentWindow(void);

		// Get parent Window (the one in containint TopCtrl
		Window GetParentWindow(void);
		
		Window GetWindow(void) { return hwnd; }

		// Get current X Display
		XDisplay *GetXDisplay(void);

		Visual     *GetVisual(void);
		XVisualInfo GetVisualInfo(void);
	
		virtual XVisualInfo *CreateVisual(void) {return 0;}
		virtual void SetAttributes(unsigned long &ValueMask, XSetWindowAttributes &attr) {}
		virtual void Paint(Draw &draw) {}
		virtual void BeforeInit(void) {}
		virtual void AfterInit(bool Error) {}
		virtual void BeforeTerminate(void) {}
		virtual void AfterTerminate(void) {}
		virtual void Resize(int w, int h) {}
	
		void SetError(bool err) { isError = err; }
		void SetErrorMessage(String const &msg) { ErrorMessage = msg; }
	
		virtual void State(int reason);
		
	public:
		typedef DHCtrl CLASSNAME;
	
		bool   IsInitialized(void) { return isInitialized; }
	
		bool   GetError(void) { return isError; }
		String GetErrorMessage(void) { return ErrorMessage; }
	
		GtkDHCtrl();
		~GtkDHCtrl();
	};
}

#endif

#endif
