#ifndef _PlantUmlEditor_LineParserActions_h_
#define _PlantUmlEditor_LineParserActions_h_

#include "PlantUmlSyntax.h"


namespace PlantUML {
	
	// ========================================================================================
	//
	// ========================================================================================
	class LineParserSyntaxLoader : public LineParserActions {
		private:
			std::wstring::const_iterator  _start;
			std::wstring::const_iterator  _end;
			std::wstring::const_iterator  _curr;
			int                           _lineNum;
			Upp::Vector<LineContext>&     _lineContexts;
			
		public:
			
			LineParserSyntaxLoader( const std::wstring& str, int line, Upp::Vector<LineContext>& lineContexts)
			: _start(str.begin())
			, _end(str.end())
			, _curr(_start)
			, _lineNum(line)
			, _lineContexts(lineContexts)
			{}
	
			virtual ~LineParserSyntaxLoader() {}
			
			virtual bool isSymbolsAdd() const { return true; };
			
			virtual void colorizeText(const std::wstring::const_iterator& start, const std::wstring::const_iterator& end, HighlighType hlt) {}
			virtual void setLineType(LineType l) {}
			
			
	};
	
	// ========================================================================================
	//
	// ========================================================================================
	
	class LineParserColorize : public LineParserActions {
		private:
			HighlightOutput& _hls;
			std::wstring::const_iterator  _start;
			std::wstring::const_iterator  _end;
			std::wstring::const_iterator  _curr;
			int                           _lineNum;
			Upp::Vector<LineContext>&     _lineContexts;
			Upp::CodeEditor&              _editor;
			
		public:
			
			LineParserColorize(HighlightOutput& hls, const std::wstring& str, int line, Upp::Vector<LineContext>& lineContexts, Upp::CodeEditor& editor)
			: _hls(hls)
			, _start(str.begin())
			, _end(str.end())
			, _curr(_start)
			, _lineNum(line)
			, _lineContexts(lineContexts)
			, _editor(editor)
			{}
	
			virtual ~LineParserColorize() {}
			
			virtual bool isSymbolsAdd() const { return false; };
	
			virtual void colorizeText(const std::wstring::const_iterator& start, const std::wstring::const_iterator& end, HighlighType hlt);
			virtual void setLineType(LineType l);
			void highLightRestOfLine();
			void highLightError();
			void highLightWarning();
			
	};
};
#endif
