#ifndef _PlantUmlEditor_PlantUmlEditor_h
#define _PlantUmlEditor_PlantUmlEditor_h

#include <CtrlLib/CtrlLib.h>
#include <CodeEditor/CodeEditor.h>


#define IMAGECLASS PlantUmlEditorImg
#define IMAGEFILE <PlantUmlEditor/PlantUmlEditor.iml>
#include <Draw/iml_header.h>

using namespace Upp;
#define LAYOUTFILE <PlantUmlEditor/PlantUmlEditor.lay>
#include <CtrlCore/lay.h>

#include "PlantUmlSyntax.h"
#include "Settings.h"

class PlantUmlEditorApp : public WithPlantUmlEditorLayout<TopWindow> {
public:
	typedef PlantUmlEditorApp CLASSNAME;
	PlantUmlEditorApp();
	
	void DragAndDrop(Point p, PasteClip& d);
	void OpenPUmlFile(String fileNammePath);
	
private:
	MenuBar menuBar;

	// MENU
	void mainBar(Bar& bar);
	void menuFile(Bar& bar);
	void menuConfig(Bar& bar);
	
	void openConfigDlg();

	void OnDirty();
	void SavePUmlFile();
	
	String fileNamePath;
};

#endif
