#include <CodeEditor/CodeEditor.h>

#include "PlantUmlSyntax.h"
#include "LineParserActions.h"


namespace PlantUML {

// ========================================================================================
//
// ========================================================================================

	void LineParserColorize::colorizeText(const std::wstring::const_iterator& start, const std::wstring::const_iterator& end, HighlighType hlt) {
		if (_curr < start ) {
			_hls.Put(start-_curr, PlantUmlSyntax::puml_style_ink[PUML_STYLE_NORMAL], PlantUmlSyntax::puml_style_paper[PUML_STYLE_NORMAL]);
			_curr = start;
		}
		_hls.Put(end-_curr, PlantUmlSyntax::puml_style_ink[ hlt ], PlantUmlSyntax::puml_style_paper[ hlt ]);
		_curr = end;
	}
	

	void LineParserColorize::setLineType(LineType l) {
		RLOGBLOCK( String() << "LineParserColorize::setLineType( " << l << " )");
		int c = _lineNum;
		if (_lineContexts[_lineNum].updateLineType(l)) {
			RLOG( "    LineParserColorize::setLineType( " << l << " ) : " << c << "  => " << _lineContexts[c].parsingType );
			while ( ++c < _lineContexts.GetCount() ) {
				if ((c) < _lineContexts.GetCount() ) {
					_lineContexts[c].parsingType = _lineContexts[c-1].getNextParsingType();
				}
			}
			
			// =============================================================================
			//     R E F R E S H   E D I T O R      TO SHOW FURTHER LINE CHANGES
			// =============================================================================
			Upp::PostCallback( Upp::MemFn<>(&_editor, &Upp::CodeEditor::UpdateRefresh) );
		}
	}
	
	
	
	void LineParserColorize::highLightRestOfLine() {
		if (_curr < _end ) {
			_hls.Put(_end-_curr, PlantUmlSyntax::puml_style_ink[PlantUML::PUML_STYLE_NOT_SET], PlantUmlSyntax::puml_style_paper[PlantUML::PUML_STYLE_NOT_SET]);
			_curr = _end;
		}
	}

	void LineParserColorize::highLightError() {
		if (_curr < _end ) {
			_hls.Put(_end-_curr, PlantUmlSyntax::puml_style_ink[PlantUML::PUML_STYLE_ERROR], PlantUmlSyntax::puml_style_paper[PlantUML::PUML_STYLE_ERROR]);
			_curr = _end;
		}
		_hls.SetPaper(0, _end-_start, PlantUmlSyntax::puml_style_paper[PlantUML::PUML_STYLE_ERROR].color);
	}

	void LineParserColorize::highLightWarning() {
		if (_curr < _end ) {
			_hls.Put(_end-_curr, PlantUmlSyntax::puml_style_ink[PlantUML::PUML_STYLE_WARNING], PlantUmlSyntax::puml_style_paper[PlantUML::PUML_STYLE_WARNING]);
			_curr = _end;
		}
		_hls.SetPaper(0, _end-_start, PlantUmlSyntax::puml_style_paper[PlantUML::PUML_STYLE_WARNING].color);
	}
};