#ifndef _PlantUmlEditor_PlantUmlSyntax_h_
#define _PlantUmlEditor_PlantUmlSyntax_h_

#include "SyntaxParser.h"


namespace Upp {

	NTL_MOVEABLE(PlantUML::LineContext);

	template <> inline String AsString(const PlantUML::PlantUMLParsingType& p) { return String(PlantUML::PlantUMLParsingType_nameString[p]); }
	template <> inline String AsString(const PlantUML::LineType& p) { return String(PlantUML::LineType_nameString[p]); }
	template <> inline String AsString(const PlantUML::LineContext& p) { return String(PlantUML::LineType_nameString[p.getLineType()]) << "  /  " << p.parsingType; }
};

using Upp::wchar;
using Upp::HighlightOutput;
using Upp::CodeEditor;
using Upp::WString;
using Upp::String;
using Upp::HlStyle;
using Upp::int64;
using Upp::Color;

class PlantUmlSyntax : public Upp::EditorSyntax {
private:
	struct Identation {
		enum Type {
			Tab = 0,
			Space,
			Unknown
		};
	};
	
	static Upp::Vector<PlantUML::LineContext>  _lineContexts;

public:
	PlantUmlSyntax();
	virtual ~PlantUmlSyntax() {}

	static void loadDefaultSettings();
	static void LoadColorSettings(const char *s);
	static String StoreColorSettings();

	virtual void Highlight(const wchar *start, const wchar *end, HighlightOutput& hls, CodeEditor *editor, int line, int64 pos);
	virtual void IndentInsert(CodeEditor& e, int chr, int count);

	virtual void            Clear() { RLOGBLOCK("PlantUmlSyntax::Clear"); }
	virtual void            ScanSyntax(const wchar *start, const wchar *end, int line, int tab_size);
//	virtual bool            CheckBrackets(CodeEditor& e, int64& bpos0, int64& bpos) {
//		// RLOGBLOCK("PlantUmlSyntax::CheckBrackets");
//	}
	virtual void            CheckSyntaxRefresh(CodeEditor& e, int64 pos, const WString& text) {
		RLOGBLOCK("PlantUmlSyntax::CheckSyntaxRefresh"); RLOG("CheckSyntaxRefresh: " + text );
	}
	virtual bool            CanAssist() const {
		RLOGBLOCK("PlantUmlSyntax::CanAssist");
		return true;
	}

	inline static const char*     getStyleLongDesc(int i)   { return puml_style_long_desc[ i ]; }
	inline static const char*     getStyleShortDesc(int i)  { return puml_style_short_desc[ i ]; }
	inline static const char*     getStyleName(int i)  { return puml_style_name[ i ]; }
	inline static const HlStyle&  getStyleInk(int i)   { return puml_style_ink[ i ]; }
	inline static const HlStyle&  getStylePaper(int i) { return puml_style_paper[ i ]; }
	
	inline static const HlStyle&  setStyleInk(int i, Color inkColor, bool bold, bool italic, bool underline) {
		HlStyle& s = puml_style_ink[ i ];
		s.color = inkColor;
		s.bold = bold;
		s.italic = italic;
		s.underline = underline;
	}

	inline static const HlStyle&  setStylePaper(int i, Color paperColor) {
		if ( i>=0 || i<PlantUML::PUML_HL_COUNT ) {
			puml_style_paper[ i ].color = paperColor;
		}
	}


	static const char* puml_style_short_desc[ PlantUML::PUML_HL_COUNT ];
	static const char* puml_style_long_desc[ PlantUML::PUML_HL_COUNT ];
	static const char* puml_style_name[ PlantUML::PUML_HL_COUNT ];
	static HlStyle     puml_style_ink[ PlantUML::PUML_HL_COUNT ];
	static HlStyle     puml_style_paper[ PlantUML::PUML_HL_COUNT ];
	
private:
	// Indentation management
	int              CalculateLineIndetations(const WString& line, Identation::Type type);
	int              CalculateSpaceIndetationSize(CodeEditor& editor);
	Identation::Type FindIdentationType(CodeEditor& editor, const WString& line);
	char             GetIdentationByType(Identation::Type type);
};


#endif
