#include "PlantUmlEditor.h"


void HlPusherFactory(One<Ctrl>& ctrl)
{
	ctrl.Create<ColorPusher>().NotNull().Track();
}

void ReadHlStyles(ArrayCtrl& hlstyle)
{
	hlstyle.Clear();
	for(int i = 0; i < PlantUML::PUML_HL_COUNT; i++) {
		const HlStyle& ink = PlantUmlSyntax::getStyleInk(i);
		const HlStyle& paper = PlantUmlSyntax::getStylePaper(i);
		hlstyle.Add(PlantUmlSyntax::getStyleShortDesc(i), ink.color, ink.bold, ink.italic, ink.underline, paper.color);
	}
}


ColorsDlg::ColorsDlg()
{
	CtrlLayout(*this, t_("Syntax Highlighting Configuration"));
	Sizeable();

	restoreDefaultsButton << [=] { Restoredefaultsbutton(); };
	
	hlstyle.AddColumn(t_("Style")       );
	hlstyle.AddColumn(t_("Ink Color")   ).Ctrls(HlPusherFactory);
	hlstyle.AddColumn(t_("Bold")        ).Ctrls<Option>();
	hlstyle.AddColumn(t_("Italic")      ).Ctrls<Option>();
	hlstyle.AddColumn(t_("Underline")   ).Ctrls<Option>();
	hlstyle.AddColumn(t_("Paper Color") ).Ctrls(HlPusherFactory);
	
	hlstyle.ColumnWidths("240 80 45 45 45 80");
	hlstyle.EvenRowColor().NoHorzGrid().SetLineCy(EditField::GetStdHeight() + 2);
	ReadHlStyles(hlstyle);
}

void ColorsDlg::updateConfig()
{
	for(int i = 0; i < PlantUML::PUML_HL_COUNT; i++) {
		PlantUmlSyntax::setStyleInk(  i
									, hlstyle.Get(i, 1)
									, hlstyle.Get(i, 2)
									, hlstyle.Get(i, 3)
									, hlstyle.Get(i, 4)
		);
		PlantUmlSyntax::setStylePaper(i, hlstyle.Get(i, 5) );
	}
}


void ColorsDlg::Restoredefaultsbutton()
{
	PlantUmlSyntax::loadDefaultSettings();
}
