#pragma BLITZ_PROHIBIT


#if defined(_MSC_VER)
# pragma warning(disable: 4345)
#endif

#include <boost/config/warning_disable.hpp>
#include <boost/spirit/include/qi.hpp>
#include <boost/spirit/include/phoenix_core.hpp>
#include <boost/spirit/include/phoenix_operator.hpp>
#include <boost/spirit/include/phoenix_fusion.hpp>
#include <boost/spirit/include/phoenix_stl.hpp>
#include <boost/spirit/include/phoenix_object.hpp>
#include <boost/fusion/include/adapt_struct.hpp>
#include <boost/spirit/include/phoenix_function.hpp>
#include <boost/spirit/include/qi_expect.hpp>



////////////////////////////////////////////////////////////////////////////
using namespace std;
using namespace boost::spirit;


////////////////////////////////////////////////////////////////////////////
//
//  PARSER GRAMMAR
//
////////////////////////////////////////////////////////////////////////////


namespace client
{
    struct employee
    {
        int dummy;
    };
}

// We need to tell fusion about our employee struct
// to make it a first-class fusion citizen. This has to
// be in global scope.

//[tutorial_employee_adapt_struct
BOOST_FUSION_ADAPT_STRUCT(
    client::employee,
    (int, dummy)
)
//]

#include "SyntaxParser.h"



namespace PlantUMLparser_ns
{
    namespace qi = boost::spirit::qi;
    namespace ascii = boost::spirit::ascii;


    //==============================================
    //  S T A T I C   S Y M B O L   T A B L E S
    //==============================================
	typedef qi::symbols<char, int> MacroSymbols;
	MacroSymbols  macroSymbolsList;
	
	typedef qi::symbols<char, int> ParticipantNames;
	ParticipantNames  actorsList;
	
    typedef std::vector<std::wstring> ActorsStack;
    static ActorsStack stackedActors;

    //==============================================
    //  E R R O R   H A N D L E R
    //==============================================
    struct error_handler_
    {
        template <typename, typename, typename>
        struct result { typedef void type; };

        template <typename Iterator>
        void operator()(
            qi::info const& what
          , Iterator err_pos, Iterator last) const
        {
            throw PlantUML::PlantUmlParseException("Error");
            std::cout
                << "Error! Expecting "
                << what                         // what failed?
                << " here: \""
                << std::string(err_pos, last)   // iterators to error-pos, end
                << "\""
                << std::endl
            ;
        }
    };

    boost::phoenix::function<error_handler_> const error_handler = error_handler_();


    //==============================================
    //  S E M A N T I C   A C T I O N S
    //==============================================
	struct do_throwError
	{
		do_throwError() {}

		void operator()(qi::unused_type, qi::unused_type, qi::unused_type ) const
		{
			throw PlantUML::PlantUmlParseException("Error");
		}
	};
    //==============================================
    //
    //==============================================

	struct do_setStyle
	{
		// http://marko-editor.com/articles/position_tracking/
		// https://theboostcpplibraries.com/boost.spirit-api
		
		// https://stackoverflow.com/questions/51252725/map-input-to-ast-types-in-boost-spirit/51254774#51254774
		// https://www.boost.org/doc/libs/1_68_0/libs/spirit/doc/html/spirit/qi/reference/directive/raw.html
		do_setStyle(PlantUML::LineParserActions& hlp_, PlantUML::HighlighType hlt_)
		: hlp( hlp_ ), hlt(hlt_) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			std::wstringstream log;
			log << "do_setStyle( " << std::wstring(range.begin(), range.end()) << " , " << hlt <<" )";
			//PlantUML::logFct( log );
			hlp.colorizeText(range.begin(), range.end(), hlt);
		}

		PlantUML::LineParserActions& hlp;
		const PlantUML::HighlighType hlt;
	};


    //==============================================
    // ACTORS LIST MANAGEMENT
    //==============================================

	struct do_clearActorStack
	{
		PlantUML::LineParserActions& hlp;
		ActorsStack& actorsStack;

		do_clearActorStack(PlantUML::LineParserActions& hlp_, ActorsStack& stack_) : hlp( hlp_ ), actorsStack(stack_) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			if ( hlp.isSymbolsAdd() ) {
				stackedActors.clear();
			}
		}
	};

	struct do_pushActor
	{
		PlantUML::LineParserActions& hlp;
		ActorsStack& actorsStack;

		do_pushActor(PlantUML::LineParserActions& hlp_, ActorsStack& stack_) : hlp( hlp_ ), actorsStack(stack_) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			if ( hlp.isSymbolsAdd() ) {
				stackedActors.push_back( std::wstring(range.begin(), range.end()) );
//				PlantUML::logFct( std::wstring(range.begin(), range.end()) );
			}
		}
	};

	struct do_addActor
	{
		PlantUML::LineParserActions& hlp;
		ParticipantNames& actors;
		ActorsStack& actorsStack;

		do_addActor(PlantUML::LineParserActions& hlp_, ParticipantNames& actors_, ActorsStack& stack_) : hlp( hlp_ ), actors(actors_), actorsStack(stack_) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			if ( hlp.isSymbolsAdd() ) {
				ActorsStack::const_iterator iter = stackedActors.begin();
				ActorsStack::const_iterator end = stackedActors.end();
				while(iter != end) {
					actors.add( *iter );
					++iter;
				}
			}
		}
	};

    //==============================================
    // MACROS LIST MANAGEMENT
    //==============================================
	struct do_addMacroName
	{
		PlantUML::LineParserActions& hlp;
		MacroSymbols& macroSymbols;

		do_addMacroName(PlantUML::LineParserActions& hlp_, MacroSymbols& macros_) : hlp( hlp_ ), macroSymbols( macros_ ) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			if ( hlp.isSymbolsAdd() ) {
				const std::wstring str(range.begin(), range.end());
				if ( macroSymbols.find( str ) == 0) {
					macroSymbols.add( str );
				}
			}
		}
	};

    //==============================================
	struct do_processInclude
	{
		PlantUML::LineParserActions& hlp;

		do_processInclude(PlantUML::LineParserActions& hlp_) : hlp( hlp_ ) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			if ( hlp.isSymbolsAdd() ) {
				const std::wstring str(range.begin(), range.end());
			}
		}
	};


    //==============================================
	struct do_setLineType
	{
		do_setLineType(PlantUML::LineParserActions& hlp_, bool& lineTypeAlreadySet_, PlantUML::LineType lt_)
		: hlp( hlp_ ), lt(lt_), lineTypeAlreadySet(lineTypeAlreadySet_) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			lineTypeAlreadySet = true;
			std::wstringstream log;
			log << "do_setLineType( " << lt << " )";
			//PlantUML::logFct( log );
			hlp.setLineType(lt);
		}

		void operator()( qi::unused_type, qi::unused_type, qi::unused_type ) const
		{
			lineTypeAlreadySet = true;
			std::wstringstream log;
			log << "do_setLineType( " << lt << " )";
			//PlantUML::logFct( log );
			hlp.setLineType(lt);
		}

		PlantUML::LineParserActions& hlp;
		const PlantUML::LineType lt;
		bool& lineTypeAlreadySet;
	};


    //==============================================
	struct do_setDefaultLineType
	{
		do_setDefaultLineType(PlantUML::LineParserActions& hlp_, bool& lineTypeAlreadySet_, PlantUML::LineType lt_)
		: hlp( hlp_ ), lt(lt_), lineTypeAlreadySet(lineTypeAlreadySet_) {}

		void operator()(const boost::iterator_range<std::wstring::const_iterator> range, qi::unused_type, qi::unused_type ) const
		{
			if ( !lineTypeAlreadySet ) {
				std::wstringstream log;
				log << "do_setDefaultLineType( " << lt << " )";
				//PlantUML::logFct( log );
				hlp.setLineType(lt);
			}
		}

		void operator()( qi::unused_type, qi::unused_type, qi::unused_type ) const
		{
			if ( !lineTypeAlreadySet ) {
				std::wstringstream log;
				log << "do_setDefaultLineType( " << lt << " )";
				//PlantUML::logFct( log );
				hlp.setLineType(lt);
			}
		}

		PlantUML::LineParserActions& hlp;
		const PlantUML::LineType lt;
		bool& lineTypeAlreadySet;
	};




#define ADD_MACRO           [do_addMacroName(_hlp, _macroSymbols)]


#define INIT_ACTORS         [do_clearActorStack(_hlp, _actorsStack)]
#define PUSH_ACTOR          [do_pushActor(_hlp, _actorsStack)]
#define ADD_ACTORS          [do_addActor(_hlp, actors, _actorsStack)]


#define PROCESS_INCLUDE     [do_processInclude(_hlp)]


#define INK_NORMAL          [do_setStyle(_hlp, PlantUML::PUML_STYLE_NORMAL)]
#define INK_COMMENT         [do_setStyle(_hlp, PlantUML::PUML_STYLE_COMMENT)]
#define INK_MACRO_KEYWORD   [do_setStyle(_hlp, PlantUML::PUML_STYLE_MACRO_KEYWORD)]
#define INK_MACRO_NAME      [do_setStyle(_hlp, PlantUML::PUML_STYLE_MACRO_NAME)]
#define INK_KEYWORD         [do_setStyle(_hlp, PlantUML::PUML_STYLE_KEYWORD)]
#define INK_ACTOR(MSG)      [do_setStyle(_hlp, PlantUML::PUML_STYLE_PARTICIPANT)]//[printDebugInfoV("Part[" MSG "] > ")]
#define INK_STRING          [do_setStyle(_hlp, PlantUML::PUML_STYLE_STRING)]
#define INK_NUMBER          [do_setStyle(_hlp, PlantUML::PUML_STYLE_NUMBER)]
#define INK_COLOR           [do_setStyle(_hlp, PlantUML::PUML_STYLE_COLOR)]
#define INK_ARROW           [do_setStyle(_hlp, PlantUML::PUML_STYLE_ARROW)]
#define INK_NOTE_TEXT       [do_setStyle(_hlp, PlantUML::PUML_STYLE_NOTE_TEXT)]
#define INK_REF_TEXT        [do_setStyle(_hlp, PlantUML::PUML_STYLE_NOTE_TEXT)]
#define INK_EYE_CANDY       [do_setStyle(_hlp, PlantUML::PUML_STYLE_EYE_CANDY)]
#define INK_MSG_TEXT        [do_setStyle(_hlp, PlantUML::PUML_STYLE_MSG_TEXT)]
#define INK_STEREOTYPE      [do_setStyle(_hlp, PlantUML::PUML_STYLE_STEREOTYPE)]
#define INK_SKIN_PARAM      [do_setStyle(_hlp, PlantUML::PUML_STYLE_SKINPARAM_NAME)]
#define INK_SKIN_PARAM_VAL  [do_setStyle(_hlp, PlantUML::PUML_STYLE_SKINPARAM_VALUE)]


#define INK_SYNTAX_ERROR    [do_setStyle(_hlp, PlantUML::PUML_STYLE_ERROR)]


#define LINETYPE_Normal            [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_NORMAL             )]
#define LINETYPE_NoteStart         [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_NOTE_START         )]
#define LINETYPE_NoteEnd           [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_NOTE_END           )]
#define LINETYPE_RefStart          [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_REF_START          )]
#define LINETYPE_RefEnd            [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_REF_END            )]
#define LINETYPE_LegendStart       [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_LEGEND_START       )]
#define LINETYPE_LegendEnd         [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_LEGEND_END         )]
#define LINETYPE_SectionStart      [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_SECTION_START      )]
#define LINETYPE_SectionEnd        [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_SECTION_END        )]
#define LINETYPE_GroupStart        [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_GROUP_START        )]
#define LINETYPE_GroupEnd          [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_GROUP_END          )]
#define LINETYPE_GroupIfStart      [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_GROUP_IF_START     )]
#define LINETYPE_GroupIfElse       [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_GROUP_IF_ELSE      )]
#define LINETYPE_BoxStart          [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_BOX_START          )]
#define LINETYPE_BoxEnd            [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_BOX_END            )]
#define LINETYPE_SkinParamSeqStart [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_SKINPARAM_SEQ_START)]
#define LINETYPE_SkinParamSeqEnd   [do_setLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_SKINPARAM_SEQ_END  )]
 
#define LINETYPE_default           [do_setDefaultLineType(_hlp,  _lineTypeAlreadySet, PlantUML::LINE_NORMAL      )]


    ///////////////////////////////////////////////////////////////////////////////
    //  Our employee parser
    //
    //  /home/a_didier.orig_fc25/Téléchargements/boost_1_63_0/libs/spirit/example/qi
    //
    ///////////////////////////////////////////////////////////////////////////////
    //[tutorial_employee_parser
    template <typename Iterator>
    struct PlantUmlGrammar : qi::grammar<Iterator, client::employee(), ascii::space_type>
    {
		PlantUML::LineParserActions& _hlp;
		PlantUML::PlantUMLParsingType _parsingType;
		bool _lineTypeAlreadySet;
		MacroSymbols& _macroSymbols;
		ParticipantNames& _actorsList;
		ActorsStack& _actorsStack;

        PlantUmlGrammar(PlantUML::LineParserActions& hlp, PlantUML::PlantUMLParsingType pt, MacroSymbols& macrosList, ParticipantNames& actors, ActorsStack& actorsStack)
        : PlantUmlGrammar::base_type(start)
        , _hlp(hlp)
        , _parsingType(pt)
        , _lineTypeAlreadySet(false)
        , _macroSymbols(macrosList)
        , _actorsList(actors)
        , _actorsStack(actorsStack)
        {
            using qi::on_error;
            using qi::fail;

            using qi::uint_;
            using qi::int_;
            using qi::lit;
            using qi::double_;
            using qi::lexeme;
            using standard_wide::char_;
            using qi::raw;
            using qi::graph;
            using qi::blank;
            using qi::space;
            using qi::alnum;
            using qi::alpha;
            using qi::digit;
            using qi::string;
            using qi::expect;



			// COMMENTAIRES
			comment = char_('\'') >> *char_;

			// =====================
			//    LANGUAGE BASICS
			EOL = eol | eoi;
			freeText = +char_;
            quoted_string = lexeme['"' >> +(char_ - '"') >> '"'];
            
            #define M_color (char_('#') > +alnum)
            color  = M_color;
			
			#define M_arrowColor (char_("[") > M_color > char_(']'))
			arrowColor = M_arrowColor;
			
			C_identifier = lexeme[ (alpha | '_') >> *(alnum | '_') ];

			participantDeclKeys = string("actor") | "boundary" | "control" | "entity" | "database" | "collections" | "participant";
			actor = C_identifier -( participantDeclKeys | groupKeys | string("deactivate") | "activate" | "end" | "box" | "note" );
			macroKeys = /*longest_d[*/ string("@startuml")  | "@enduml" | "!import" | "!enddefinelong" | "!undef" | "!ifdef" | "!else" | "!endif";
			
			// =====================
			//         ARROW
			#define M_arrowLeftEnd     (-(char_('x') | 'o') >> (('<' >>-char_('<') )|( '\\'>>-char_('\\') )|( '/'>>-char_('/'))))
			arrowLeftEnd = M_arrowLeftEnd;
			
			#define M_arrowRightEnd    ((( '>'>>-char_('>') )|( '\\'>>-char_('\\') )|( '/'>>-char_('/') ))  >>  -( char_('x')|'o' ))
			arrowRightEnd = M_arrowRightEnd;

			//  <<  -[#color]- >>
			//   o  -[#color]- o
			arrow = lexeme[
		            // LEFT  ARROW
					(
			            -(M_arrowLeftEnd | char_('o'))
					    > (   ( M_arrowColor > char_('-') >> -char_('-'))
							| ( char_('-')   >> -( (M_arrowColor >> -char_('-'))
												| ( char_('-') >> -M_arrowColor )
												)
							  )
						  )
					    > -(char_('o') | M_arrowRightEnd)
					)
		            ]
					;


			descriptionText = char_(':') >> *char_;

	
			note_decl = raw[string("note") | "hnote" | "rnote"] INK_KEYWORD
			            >  ( (raw[string("over")]INK_KEYWORD >> raw[actor % char_(',')] INK_ACTOR("2") )
						     |( raw[string("left") | "right"]INK_KEYWORD >> -(raw[string("of")]INK_KEYWORD >> raw[actor]INK_ACTOR("3") ) )
						   )
						>> -raw[lexeme[M_color]] INK_COLOR;
			stereotype = string("<<") >> (*char_ - ">>") >> ">>";
			skin_param       = raw[C_identifier] INK_SKIN_PARAM >> raw[freeText] INK_SKIN_PARAM_VAL;
			
			// =====================
			//    LINES PARSERS
			l_actor_decl     = raw[eps] INIT_ACTORS >> raw[participantDeclKeys] INK_KEYWORD >> -( raw[quoted_string] INK_STRING >> raw[string("as")] INK_KEYWORD ) >> raw[actor] INK_ACTOR("4") PUSH_ACTOR >> -raw[stereotype] INK_STEREOTYPE  >> raw[eps] ADD_ACTORS;
			l_actor_create   = raw[eps] INIT_ACTORS >> raw[ lit("create") ] INK_KEYWORD > ( -raw[participantDeclKeys] > raw[actor] INK_ACTOR("4b") PUSH_ACTOR) >> raw[eps] ADD_ACTORS;
			l_actor_destroy  = raw[string("destroy")] INK_KEYWORD > raw[actor] INK_ACTOR("4c");
			
			l_ref_decl       = raw[string("ref")] INK_KEYWORD >> raw[string("over")] INK_KEYWORD >> raw[actor % char_(',')] INK_ACTOR("7") >> (raw[descriptionText] INK_NORMAL | raw[eps]LINETYPE_RefStart);
			l_box_start      = raw[ raw[string("box")] INK_KEYWORD >> -raw[quoted_string] INK_STRING >> -raw[lexeme[M_color]] INK_COLOR ] LINETYPE_BoxStart;
			l_group_alt_if   = raw[string("alt")] INK_KEYWORD >> -raw[freeText] INK_NORMAL LINETYPE_GroupIfStart;
			l_group_alt_else = raw[string("else")] INK_KEYWORD >> -raw[freeText] INK_NORMAL LINETYPE_GroupIfElse;
			l_group          = raw[string("opt") | "loop" | ("par" >> ~char_('t')) | "break" | "critical" | "group"] INK_KEYWORD >> -raw[freeText] INK_NORMAL LINETYPE_GroupStart;
			l_macro_def      = raw[ "!definelong" | string("!define") ] INK_MACRO_KEYWORD >> raw[C_identifier] INK_MACRO_NAME ADD_MACRO >> -raw[freeText] INK_NORMAL;
			l_macro          = raw[macroKeys] INK_MACRO_KEYWORD >> -raw[freeText] INK_NORMAL;
			l_macro_using    = raw[ _macroSymbols ] INK_MACRO_NAME
								>> -( lit('(') >> ((raw[_actorsList]INK_ACTOR("8") | raw[C_identifier]INK_NORMAL) % raw[lit(',')]INK_NORMAL >> raw[lit(')')]INK_NORMAL ))>> -raw[freeText] INK_NORMAL;
			l_include        = raw[ string("!include")] INK_MACRO_KEYWORD >> raw[C_identifier >> -(lit('.') >> C_identifier)] INK_NORMAL PROCESS_INCLUDE;

			l_skinparam      = raw[string("skinparam")] INK_KEYWORD
								> (  raw[string("sequence") >> lit('{')] INK_KEYWORD LINETYPE_SkinParamSeqStart
								   | skin_param
								  );
			l_autonumber = raw[string("autonumber")] INK_KEYWORD
			               >> -(  raw[string("stop")] INK_KEYWORD
			                     |( raw[string("resume")] INK_KEYWORD >> -raw[lexeme[int_]] INK_NUMBER >> -raw[quoted_string] INK_STRING )
                                 |( -raw[uint_ >> -int_] INK_NUMBER  >> -raw[quoted_string] INK_STRING )
			                   );
			l_scale      = raw[string("scale")] INK_KEYWORD > raw[uint_] INK_NUMBER  > raw[char_('*')] INK_NUMBER > raw[uint_] INK_NUMBER  >> -raw[quoted_string] INK_STRING;
			l_note       = note_decl/*no INK*/ >> ( raw[descriptionText] INK_NOTE_TEXT | eps LINETYPE_NoteStart );
			l_legend     = raw[string("legend") >> (string("right")|"center"|"left") ] INK_KEYWORD LINETYPE_LegendStart;
			l_section    = raw[ string("title") | "header" | "footer"]INK_KEYWORD >> ( raw[freeText] INK_NOTE_TEXT | eps LINETYPE_SectionStart );
			l_activation = ( (raw[string("activate")] INK_KEYWORD > raw[actor] INK_ACTOR("5a") >> -raw[lexeme[M_color]] INK_COLOR )
			               | raw[string("deactivate")] INK_KEYWORD > raw[actor] INK_ACTOR("5b") );
			
			l_note_end   = raw[string("end") >> (string("note")| "rnote" | "hnote")]  INK_KEYWORD LINETYPE_NoteEnd;
			l_ref_end    = raw[string("end") >> string("ref") ]  INK_KEYWORD LINETYPE_RefEnd;
			l_legend_end = raw[string("end") >> "legend"]  INK_KEYWORD LINETYPE_LegendEnd;
			l_box_end    = raw[string("end") >> "box"]  INK_KEYWORD LINETYPE_BoxEnd;
			l_section_end= raw[string("end") >> (string("title") | "header" | "footer")]  INK_KEYWORD LINETYPE_SectionEnd;
			l_group_end  = raw[string("end")]  INK_KEYWORD LINETYPE_GroupEnd;
			l_message    = raw[eps] INIT_ACTORS
						   >> raw[ actor | char_('[') ] INK_ACTOR("6") PUSH_ACTOR
						   >> raw[arrow] INK_ARROW
						   >  ( raw[ actor | char_(']') ] INK_ACTOR("6") PUSH_ACTOR  /*| eps[do_throwError()]*/ )
						   >> !(char_-lit(':'))
			               >> -raw[descriptionText] INK_MSG_TEXT  >> raw[eps] ADD_ACTORS;
			l_eye_candy = raw[string("newpage")| "..." | "|||" | "=="] INK_EYE_CANDY >> raw[freeText] INK_EYE_CANDY;
			
			l_hide_footbox = raw[string("hide") > "footbox"] INK_KEYWORD;
			l_caption    = raw[string("caption")] INK_KEYWORD > raw[freeText] INK_NORMAL;


			// ===========================
			//    GLOBAL PARSING  RULES
			// ===========================
			note_text_rule		=     l_note_end
								| raw[freeText] INK_NOTE_TEXT;

			ref_text_rule		=     l_ref_end
								| raw[freeText] INK_REF_TEXT;
							
			section_text_rule	=     l_section_end
								| raw[freeText] INK_NORMAL;
			
			legend_text_rule	=     l_legend_end
								| raw[freeText] INK_NORMAL;
							
			box_text_rule		=     l_box_end
								|     l_actor_decl;

			skin_param_rule		= raw[lit('}') ] INK_KEYWORD LINETYPE_SkinParamSeqEnd | skin_param;
							
			main_rule =        l_macro
		                |      l_macro_def
		                |      l_macro_using
		                |      l_include
		                |      l_group_alt_if
		                |      l_group_alt_else
		                |      l_group
		                |      l_note_end
		                |      l_ref_end
		                |      l_legend_end
		                |      l_section_end
		                |      l_box_end
		                |      l_group_end
		                |      l_box_start
		                |      l_section
		                |      l_note
		                |      l_legend
		                |      l_activation
		                |      l_group
		                |      l_skinparam
		                |      l_autonumber
		                |      l_scale
		                |      l_eye_candy
		                |      l_ref_decl
		                |      l_actor_decl
		                |      l_actor_create
		                |      l_actor_destroy
		                |      l_hide_footbox
		                |      l_caption
		                |      l_message
			             ;

			
			start = -(    ( eps( boost::phoenix::ref(_parsingType) == PlantUML::PUML_PARSE_NOTE_TEXT)     > note_text_rule )
						| ( eps( boost::phoenix::ref(_parsingType) == PlantUML::PUML_PARSE_REF_TEXT)      > ref_text_rule )
						| ( eps( boost::phoenix::ref(_parsingType) == PlantUML::PUML_PARSE_SECTION_TEXT)  > section_text_rule )
						| ( eps( boost::phoenix::ref(_parsingType) == PlantUML::PUML_PARSE_LEGEND_TEXT)   > legend_text_rule )
						| ( eps( boost::phoenix::ref(_parsingType) == PlantUML::PUML_PARSE_BOX)           > box_text_rule )
						| ( eps( boost::phoenix::ref(_parsingType) == PlantUML::PUML_PARSE_SKIN_PARAMS)   > skin_param_rule )
						
						| main_rule
					)
					>> -raw[comment] INK_COMMENT
					>> raw[eps]LINETYPE_default >> space;

            // Error handling
            on_error<fail>(start, error_handler(_4, _3, _2));
	    }

        qi::rule<Iterator, std::wstring(), ascii::space_type> color, arrowColor, arrowLeftEnd, arrowRightEnd;
        qi::rule<Iterator, std::wstring(), ascii::space_type> arrow, l_caption;
        qi::rule<Iterator, std::wstring(), ascii::space_type> quoted_string, EOL, freeText, participantDeclKeys, groupKeys, macroKeys, C_identifier, actor;
        qi::rule<Iterator, std::wstring(), ascii::space_type> descriptionText, comment, note_decl, stereotype, skin_param, l_hide_footbox;
        qi::rule<Iterator, std::wstring(), ascii::space_type> l_actor_decl, l_actor_create, l_actor_destroy, l_ref_decl, l_group_alt_if, l_group_alt_else, l_box_start, l_group;
        qi::rule<Iterator, std::wstring(), ascii::space_type> l_macro_def, l_macro, l_macro_using, l_include, l_skinparam, l_autonumber;
        qi::rule<Iterator, std::wstring(), ascii::space_type> l_scale, l_note, l_legend, l_section, l_activation, l_box_end, l_note_end, l_ref_end, l_legend_end, l_group_end, l_section_end, l_message, l_eye_candy;
        qi::rule<Iterator, std::wstring(), ascii::space_type> main_rule, note_text_rule, ref_text_rule, section_text_rule, legend_text_rule, box_text_rule, skin_param_rule;
        
        qi::rule<Iterator, client::employee(), ascii::space_type> start;
    };
    //]
}




using namespace PlantUML;


namespace PlantUML {
	
	void PlantUMLParser::clearSymbols() {
		PlantUMLparser_ns::macroSymbolsList.clear();
		PlantUMLparser_ns::actorsList.clear();
		PlantUMLparser_ns::stackedActors.clear();
	}

	bool PlantUMLParser::parseLine(const std::wstring& inputText, LineParserActions& lineParserActions, PlantUMLParsingType parsingType) throw (PlantUmlParseException)
	{
	    using boost::spirit::ascii::space;

		PlantUMLparser_ns::PlantUmlGrammar<std::wstring::const_iterator> myGrammarParser( lineParserActions
																						, parsingType
																						, PlantUMLparser_ns::macroSymbolsList
																						, PlantUMLparser_ns::actorsList
																						, PlantUMLparser_ns::stackedActors
																						);

        client::employee emp;
        std::wstring::const_iterator iter = inputText.begin();
        std::wstring::const_iterator end = inputText.end();
        return  phrase_parse(iter, end, myGrammarParser, space, emp);
	}
} // namespace PlantUML





