#include <CtrlLib/CtrlLib.h>
#include "PlantUmlEditor.h"

#include "PlantUmlSyntax.h"

#define IMAGECLASS PlantUmlEditorImg
#define IMAGEFILE <PlantUmlEditor/PlantUmlEditor.iml>
#include <Draw/iml_source.h>


PlantUmlEditorApp::PlantUmlEditorApp()
{
	Icon( PlantUmlEditorImg::Icon() );
	CtrlLayout(*this, "PlantUml Editor");
	Sizeable();
	Sizeable(true);
	MaximizeBox(true);
	MinimizeBox(true);

	// MENU BAR
	AddFrame(menuBar);
	menuBar.Set(THISBACK(mainBar));


	editor.Highlight("plantuml");
	//editor.Highlight("cpp");
	editor.LineNumbers(true);
	editor.BarLine(true);
	editor.EditorBarLayout();
	editor.WhenState << THISFN(OnDirty);
	RegisterSystemHotKey(K_CTRL|K_S, THISFN(SavePUmlFile));
	//editor.WhenUpdate  Save
}


void PlantUmlEditorApp::mainBar(Bar& bar)
{
	bar.Add(t_("File"), THISBACK(menuFile));
	bar.Add(t_("Config"), THISBACK(menuConfig));
	//bar.Add(t_("About..."), callback(AboutDlg::showAboutDlg));
}

void PlantUmlEditorApp::menuFile(Bar& bar)
{
	//bar.Separator();
	bar.Add(editor.IsDirty(), t_("Save"), CtrlImg::save(), THISFN(SavePUmlFile));
	//bar.Separator();
	//bar.Add(t_("Exit"), FnpsaImg::TAB_CLOSE(), THISBACK(Exit)).Key(K_CTRL_E);
}

void PlantUmlEditorApp::menuConfig(Bar& bar)
{
	bar.Add(t_("Syntax Highlighting"), PlantUmlEditorImg::Settings_24() , THISFN(openConfigDlg));
}

void PlantUmlEditorApp::openConfigDlg() {
	ColorsDlg dlg;
	dlg.Execute();
	dlg.updateConfig();
}





void PlantUmlEditorApp::OnDirty() {
	if (editor.IsDirty()) Title( GetFileName(fileNamePath) + " *" );
	else                  Title( GetFileName(fileNamePath)        );
}


void PlantUmlEditorApp::DragAndDrop(Point p, PasteClip& d)
{
	if (AcceptFiles(d))
	{
		Vector<String> files = GetFiles(d); // on recupere la liste des fichiers a ouvrir
		Sort(files);
		for (int c=0; c<1 /*files.GetCount()*/; ++c)
		{
			// TODO  manage TABS for multiple files
			OpenPUmlFile(files[c]);
		}
	}
}

void PlantUmlEditorApp::SavePUmlFile() {
	RLOG("Saving file : " + fileNamePath);
	SaveFileBOM(fileNamePath, editor.GetW());
	editor.ClearDirty();
}

void PlantUmlEditorApp::OpenPUmlFile(String fileNamePath_)
{
	fileNamePath = fileNamePath_;
	RLOG("Loading file : " + fileNamePath);
	Title( GetFileName(fileNamePath) );
	editor.Set( LoadFileBOMW(fileNamePath, CHARSET_TOASCII) );
	editor.ClearDirty();
}

void CreateLogSyntax2(One<EditorSyntax>& e)
{
	e.Create<PlantUmlSyntax>();
}




// ======================================================================
//           M A I N 
// ======================================================================
GUI_APP_MAIN
{
	//SetLanguage(LNGC_('F', 'R', 'F', 'R', CHARSET_UTF8));
	//SetDefaultCharset(CHARSET_UTF8);


	const Vector<String>& arg = CommandLine();
	EditorSyntax::Register("plantuml", callback(CreateLogSyntax2), "*.uml *.plantuml", "PlantUML (.uml)");
	
	// create editor (CodeEditor will then load it's default values)
	PlantUmlEditorApp myEditor;
	
	PlantUmlSyntax::loadDefaultSettings();
	PlantUmlSyntax::LoadColorSettings( LoadFile( ConfigFile("PlantUmlEditor.colors") ) );

	if (arg.GetCount() > 0)	Upp::PostCallback( callback1( &myEditor, &PlantUmlEditorApp::OpenPUmlFile, arg[0] ) );
	myEditor.Run();
	
	SaveFile( ConfigFile("PlantUmlEditor.colors") , PlantUmlSyntax::StoreColorSettings() );
}



