#ifndef _test_thumbnail_panel_test_thumbnail_panel_h
#define _test_thumbnail_panel_test_thumbnail_panel_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;


struct Thumbnail : public Ctrl //clickable rect with a picture in it
{
	using CLASSNAME=Thumbnail;
	Image pic;
	bool bldn;
	
	//Callback WhenClick; //doesn't want to play nice with lambda ?!?!
	std::function<void()> WhenClick;
	
	
	virtual~Thumbnail(){ }
	Thumbnail() { bldn=false; }
	
	//Thumbnail(Image img, Callback cb, const std::string &desc="") { bldn=false; pic=img; Tip(desc.c_str()); WhenClick=cb; }
	Thumbnail(Image img, std::function<void()> cb, const std::string &desc="") { bldn=false; pic=img; Tip(desc.c_str()); WhenClick=cb; }
	
	virtual void Paint(Draw &drw)
	{
		drw.DrawRect(GetSize(), SColorFace());
		//drw.DrawImage(GetRect(), pic);
		Rect r=GetRect();
		drw.DrawImage(r, pic);
	}
	virtual void LeftDown(Point p, dword kf) { bldn=true; }
	virtual void LostFocus() { bldn=false; }
	virtual void LeftUp(Point p, dword kf) { if (bldn) if (WhenClick) WhenClick(); }
	
};

struct Thumbnails : public Ctrl
{
	using CLASSNAME=Thumbnails;
	
	bool bHorz; //true=>horz else vert
	int step; //to next thumb-pos
	int wh; //square-size
	Point nextpos; //last used pos

	Vector<Thumbnail*> thumbs;
	
	virtual ~Thumbnails()
	{
		for (auto p:thumbs) { RemoveChild(p); delete p; }
	}
	
	Thumbnails(bool horz=true)
	{
		bHorz=horz;
		wh=24;
		step=(wh+3);
		nextpos=Point(1,1);
	}
	virtual void Layout() //prep for horz/vert change
	{
		nextpos=Point(1,1);
		for (auto& p:thumbs) { p->SetRect(nextpos.x,nextpos.y,wh,wh); if (bHorz) nextpos.x+=step; else nextpos.y+=step; }
	}

	virtual void Paint(Draw &drw) { drw.DrawRect(GetSize(), SColorFace()); }
	
//	void AddThumbnail(Image img, Callback cb, const std::string &desc="") --- callback-issue
	void AddThumbnail(Image img, std::function<void()> cb, const std::string &desc="")
	{
		Thumbnail *pc=new Thumbnail(img, cb, desc);
		if (pc) thumbs.push_back(pc);
		Add((*pc).LeftPos(nextpos.x, wh).TopPos(nextpos.y, wh));
		if (bHorz) nextpos.x+=step; else nextpos.y+=step;
	}
	
};



struct  test_thumbnail_panel : public TopWindow
{
	using CLASSNAME=test_thumbnail_panel;

	Thumbnails thumbs;
	
	virtual ~test_thumbnail_panel();
	test_thumbnail_panel();

	void Paint(Draw &drw);
	
	void showthumbs();
};



#endif
