#include "SplitterExample.h"

SplitterExample::SplitterExample()
{
	SetRect(0, 0, 1024, 768);
	Sizeable().Zoomable().CenterScreen();

	edit.Set("Hello world!", CHARSET_DEFAULT);
	
	array.AddColumn("Nums");
	for(int i = 0; i < 10; i++) // fill the array.
		array.Add(i);
	
	CtrlLayout(pctrl); // Initialize layout for pctrl;
	pctrl.bt << [=] {  // Button "action" (will add another button to pctrl)
		if(button.IsChild())
			button.Remove();
		else
			pctrl.Add(button.SetLabel("Added button!").LeftPos(10, 150).TopPos(100, 40));
	};
	
	Add(vsplitter.Vert(hsplitter.Horz(edit, pctrl), array).SizePos()); // Adds a horizontal splitter into a vertical splitter. (nesting)
	
}

GUI_APP_MAIN
{
	SplitterExample().Run();
}
