#include <Core/Core.h>

/* ==========================================================================================
 	WinNT service example. Based on code found in internet. Here is the original header:

	"You may use Makc <makc.the.great@gmail.com> for credits ;)"
	
	"Windows service C++ implementation based on MSDN sample by Nigel Thompson (Microsoft 
	Developer Network Technology Group) November 1995"
   ========================================================================================== */
 
#include <windows.h> 
#include <winsock.h>
#define snprintf _snprintf
#pragma comment(lib,"ws2_32")
#pragma comment(lib,"advapi32")
 
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
 
 
// windows service class - must be named as "CNTservice"! Dont know why - but when you 
// rename the class, you can not stop the service (?).
 
class CNTservice
{
public:
	bool Init();
	void Run();

	CNTservice(const char* szserviceName);
	~CNTservice();

	bool IsInstalled();
	bool Install();
	bool Uninstall();

	bool Startservice();
	void SetStatus(DWORD dwState);
	bool Initialize();

	static void WINAPI serviceMain(DWORD dwArgc, LPTSTR* lpszArgv);
	static void WINAPI Handler(DWORD dwOpcode);

	char m_szserviceName[64];
	int m_iMajorVersion;
	int m_iMinorVersion;
	SERVICE_STATUS_HANDLE m_hserviceStatus;
	SERVICE_STATUS m_Status;
	
	bool m_bIsRunning;

	static CNTservice* m_pThis; // this code is older than HandlerEx :(
private:
	HANDLE m_hEventSource;
};
 
 
void CNTservice::Run()
{
	/* Serve connections until service_CONTROL_STOP received */
	while (m_bIsRunning)
	{
		// do something
		Sleep(500);
    }
}
 
 
bool CNTservice::Init()
{
	// do something to init
	
	return true;
}
 
 
CNTservice* CNTservice::m_pThis = NULL;
 
CNTservice::CNTservice(const char* szserviceName)
{
	m_pThis = this;

	// set default service name
	strncpy(m_szserviceName, szserviceName, sizeof(m_szserviceName)-1);
	m_hEventSource = NULL;

	// set initial service status 
	m_hserviceStatus = NULL;
	m_Status.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	m_Status.dwCurrentState = SERVICE_STOPPED;
	m_Status.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;
	m_Status.dwWin32ExitCode = 0;
	m_Status.dwServiceSpecificExitCode = 0;
	m_Status.dwCheckPoint = 0;
	m_Status.dwWaitHint = 0;
	m_bIsRunning = FALSE;
}
 
 
CNTservice::~CNTservice()
{
	if (m_hEventSource)
	{
		::DeregisterEventSource(m_hEventSource);
	}
}


bool CNTservice::IsInstalled()
{
	bool bResult = FALSE;

	SC_HANDLE hSCM = ::OpenSCManager(NULL, 						// local machine
									 NULL, 						// servicesActive database
									 SC_MANAGER_ALL_ACCESS); 	// full access
									 
	if (hSCM)
	{
		SC_HANDLE hservice = ::OpenService(hSCM,
										   m_szserviceName,
										   SERVICE_QUERY_CONFIG);
		if (hservice)
		{
			bResult = TRUE;
			::CloseServiceHandle(hservice);
		}

		::CloseServiceHandle(hSCM);
    }
	return bResult;
}


bool CNTservice::Install()
{
	SC_HANDLE hSCM = ::OpenSCManager(NULL, 						// local machine
									 NULL, 						// servicesActive database
									 SC_MANAGER_ALL_ACCESS); 	// full access

	if (!hSCM) return false;

	char szFilePath[FILENAME_MAX];
	
	::GetModuleFileName(NULL, szFilePath, sizeof(szFilePath));

	SC_HANDLE hservice = ::CreateService(hSCM,
										 m_szserviceName,
										 m_szserviceName,
										 SERVICE_ALL_ACCESS,
										 SERVICE_WIN32_OWN_PROCESS,
										 SERVICE_AUTO_START, 	// start condition
										 SERVICE_ERROR_NORMAL,
										 szFilePath,
										 NULL,
										 NULL,
										 NULL,
										 NULL,
										 NULL);

	if (!hservice)
	{
		::CloseServiceHandle(hSCM);
		
		return false;
    }

	char szKey[256]; HKEY hKey = NULL;
	
	strcpy(szKey, "SYSTEM\\CurrentControlSet\\services\\EventLog\\Application\\");
	
	strcat(szKey, m_szserviceName);
	
	if (::RegCreateKey(HKEY_LOCAL_MACHINE, szKey, &hKey) != ERROR_SUCCESS)
	{
		::CloseServiceHandle(hservice);
		::CloseServiceHandle(hSCM);
		
		return false;
    }

	::RegSetValueEx(hKey,
					"EventMessageFile",
					0,
					REG_EXPAND_SZ, 
					(CONST BYTE*)szFilePath,
					(int) strlen(szFilePath) + 1);     

	DWORD dwData = EVENTLOG_ERROR_TYPE | EVENTLOG_WARNING_TYPE | EVENTLOG_INFORMATION_TYPE;
	
	::RegSetValueEx(hKey,
					"TypesSupported",
					0,
					REG_DWORD,
					(CONST BYTE*)&dwData,
					sizeof(DWORD));
					
	::RegCloseKey(hKey);

	::CloseServiceHandle(hservice);
	::CloseServiceHandle(hSCM);
	
	return true;
}


bool CNTservice::Uninstall()
{
	SC_HANDLE hSCM = ::OpenSCManager(NULL, 						// local machine
									 NULL, 						// servicesActive database
									 SC_MANAGER_ALL_ACCESS); 	// full access
	if (!hSCM) return false;

	bool bResult = false;
	
	SC_HANDLE hservice = ::OpenService(hSCM,
									   m_szserviceName,
									   DELETE);
	
	if (hservice)
	{
		if (::DeleteService(hservice))
		{
			bResult = true;
		}
	
		::CloseServiceHandle(hservice);
    }
	::CloseServiceHandle(hSCM);
	
	return bResult;
}


bool CNTservice::Startservice()
{
	SERVICE_TABLE_ENTRY st[] =
	{
		{m_szserviceName, serviceMain},
		{NULL, NULL}
    };

	return ::StartServiceCtrlDispatcher(st);
}


void CNTservice::SetStatus(DWORD dwState)
{
	m_Status.dwCurrentState = dwState;
	//::SetServiceStatus(m_hServiceStatus, &m_Status); //NC commented
	
	//NC added
	CNTservice* pservice = m_pThis;
	::SetServiceStatus(pservice->m_hserviceStatus, &m_Status);
}


bool CNTservice::Initialize()
{
	SetStatus(SERVICE_START_PENDING);

	bool bResult = Init(); 								// actual initialization

	m_Status.dwWin32ExitCode = GetLastError();
	m_Status.dwCheckPoint = 0;
	m_Status.dwWaitHint = 0;
	
	if (!bResult)
	{
		SetStatus(SERVICE_STOPPED);
		
		return false;    
    }

	SetStatus(SERVICE_RUNNING);
	
	return true;
}


void CNTservice::serviceMain(DWORD dwArgc, LPTSTR* lpszArgv)
{
	CNTservice* pservice = m_pThis;

	pservice->m_Status.dwCurrentState = SERVICE_START_PENDING;
	pservice->m_hserviceStatus = RegisterServiceCtrlHandler(pservice->m_szserviceName, Handler);

	if (pservice->m_hserviceStatus != NULL)
	{
		if (pservice->Initialize())
		{
			pservice->m_bIsRunning = true;
			pservice->m_Status.dwWin32ExitCode = 0;
			pservice->m_Status.dwCheckPoint = 0;
			pservice->m_Status.dwWaitHint = 0;
			pservice->Run();
		}
		pservice->SetStatus(SERVICE_STOPPED);
    }
}


void CNTservice::Handler(DWORD dwOpcode)
{
	CNTservice* pservice = m_pThis;

	if ((dwOpcode == SERVICE_CONTROL_STOP) ||
		(dwOpcode == SERVICE_CONTROL_SHUTDOWN))
	{
		pservice->SetStatus(SERVICE_STOP_PENDING);
		pservice->m_bIsRunning = false; 						// service_STOPPED set when Run returns in serviceMain (above)
    }

	::SetServiceStatus(pservice->m_hserviceStatus, &pservice->m_Status);
}


int main(int argc, char* argv[])
{
	int iCode = 1;
	bool bRun = false;

	// Enter here the service name.
	CNTservice ntservice ("ecdss");

	if (ntservice.IsInstalled())
	{
		// uninstall or run
		bRun = true;
		if (argc > 1)
		{
			if (_stricmp(argv[1], "-u") == 0)
			{
				bRun = false;
				if (ntservice.Uninstall())
				{
					iCode = 0;
				}
			}
		}
	}
	else
	{
		// install before run
		if (ntservice.Install())
		{
			bRun = true;
		}
	}

	if (bRun)
	{
		if (ntservice.Startservice())
		{
			iCode = 0;
		}
		else if (GetLastError() == ERROR_FAILED_SERVICE_CONTROLLER_CONNECT)
		{
			printf("service installed; to start it, type this command: net start %s\n\n", ntservice.m_szserviceName );
			iCode = 0;
		}
	}

	return iCode;
}