#include "OleAut.h"

#define LLOG // LOG

OleObject::OleObject ( OleObject && other )
{
	var = pick ( other.var );
	childs = pick ( other.childs );
	other.var.SetNull();
}

OleObject& OleObject::operator= ( OleObject && other )
{
	Release();
	var = pick ( other.var );
	childs = pick ( other.childs );
	return *this;
}

void OleObject::Release()
{
	for ( int i = 0; i < childs.GetCount(); i++ )
		childs[i].Release();

	childs.Clear();

	IDispatch* pdisp = var;

	if ( pdisp )
		pdisp -> Release();

	var.SetNull();
}

bool OleObject::Set ( String path, Variant val )
{
	int lastdot = path.ReverseFind ( "." );

	if ( lastdot < 0 )
	{
		Array<Variant> v;
		v << val;
		return OleAut::Invoke ( DISPATCH_PROPERTYPUT, NULL, var, path, v );
	}

	return Method ( path.Left ( lastdot ) ).Set ( path.Mid ( lastdot + 1 ), val );
}

bool OleObject::Set ( String path, Variant p1, Variant val )
{
	int lastdot = path.ReverseFind ( "." );

	if ( lastdot < 0 )
	{
		Array<Variant> v;
		v << p1 << val;
		return OleAut::Invoke ( DISPATCH_PROPERTYPUT, NULL, var, path, v );
	}

	return Method ( path.Left ( lastdot ) ).Set ( path.Mid ( lastdot + 1 ), p1, val );
}

bool OleObject::Set ( String path, Variant p1, Variant p2, Variant val )
{
	int lastdot = path.ReverseFind ( "." );

	if ( lastdot < 0 )
	{
		Array<Variant> v;
		v << p1 << p2 << val;
		return OleAut::Invoke ( DISPATCH_PROPERTYPUT, NULL, var, path, v );
	}

	return Method ( path.Left ( lastdot ) ).Set ( path.Mid ( lastdot + 1 ), p1, p2, val );
}

OleObject OleObject::Method ( String path )
{
	LLOG ( "Method, path = " << path );
	int lastdot = path.ReverseFind ( "." );

	if ( lastdot < 0 )
	{
		return  Execute ( path );
	}

	OleObject o = Method ( path.Left ( lastdot ) );

	if ( !o )
	{
		return ( OleObject ) false;
	}

	return o.Execute ( path.Mid ( lastdot + 1 ) );
}

OleObject OleObject::Method ( String path, Array<Variant>& args )
{
	LLOG ( "Method, path = " << path );
	int lastdot = path.ReverseFind ( "." );

	if ( lastdot < 0 )
	{
		return Execute ( path, args );
	}

	OleObject o = Method ( path.Left ( lastdot ) );

	if ( !o )
	{
		return ( OleObject ) false;
	}

	return o.Execute ( path.Mid ( lastdot + 1 ), args );
}

#define E__TYPE_VAL(I)      COMBINE(Variant p, I)
#define E__VAL(I)			COMBINE(a << p, I)
#define E__NFBody(I) \
OleObject OleObject::Method(const char* path, __List##I(E__TYPE_VAL)) {\
	Array<Variant> a;\
	__List##I(E__VAL);\
	return Method(path, a);\
}\
 
__Expand30(E__NFBody)

#undef E__TYPE_VAL
#undef E__VAL
#undef E__NFBody

OleObject OleObject::Execute ( String name )
{
	Variant result;

	if ( !OleAut::Invoke ( DISPATCH_PROPERTYGET | DISPATCH_METHOD, result, var, name, 0 ) )
		result.SetNull();

	return result;
}

OleObject OleObject::Execute ( String name, Array<Variant>& args )
{
	Variant result;

	if ( !OleAut::Invoke ( DISPATCH_PROPERTYGET | DISPATCH_METHOD, result, var, name, args ) )
		result.SetNull();

	return result;
}

