#include <CtrlLib/CtrlLib.h>
#include <OleAut/OleAut.h>

using namespace Upp;

void TestWScriptShell();
void ExcelTest();

GUI_APP_MAIN
{
	TestWScriptShell();
	ExcelTest();
}


void ExcelTest()
{
	OleObject App;
	App = OleAut::CreateObject("Excel.Application");
	App("Workbooks.Add");
	App("ActiveSheet");
	App.Set("Visible", true);
	App("Sheets.Add").Set("Name", "TestSheet");
	
	Vector<Vector<Value> > data;
	for(int i = 0; i < 10; i++)
	{
		Vector<Value>& v = data.Add();
		for(int j = 0; j < 10; j++)
			v.Add() = i*j;
	}
	
	App("ActiveSheet.Range", "B1:K1").Set("Value", "Header");
	App("ActiveSheet.Range", "B2:K11").Set("Value", (SafeArray)data);
	
	App("ActiveSheet.Range", "B14:F18").Set("Value", 8);
	
	Color color = Gray();
	App("ActiveSheet.Range",  "B1:K1").Set("Interior.Color", (int)RGB(100, 100, 100));
	App("ActiveSheet.Range",  "B2:B20").Set("Interior.Color", (int)RGB(100, 100, 100));
	
	SafeArray arr = App("ActiveSheet.Range", "C3:F6")("Value");
	Vector<Vector<Value> > v = arr;
	String buf;
	for(int i = 0; i < v.GetCount(); i++)
	{
		buf << "&";
		for(int j = 0; j < v[i].GetCount(); j++)
			buf << v[i][j] << "    ";
	}
	PromptOK(buf);
	PromptOK("Press OK to close Excel");
	App("ActiveWorkbook").Set("Saved", true);
	App("Quit");
}


//
// links :
//   http://combot.univ-tln.fr/winibw/interactions/applis.html
//
//   http://www.besoindaide.com/ccm/vbscript/vbs-wshshell.htm
//
//   http://ss64.com/vb/run.html
//
class WScriptShell
{
	OleObject sh;
public:
	WScriptShell()
	{
		OleAut::Init();
		sh = OleAut::CreateObject("WScript.Shell", CLSCTX_ALL);
	}
	
	~WScriptShell()
	{
		OleAut::Close();
	}
	
	operator bool() { return (bool)sh;}
	
	bool Run(String prog, bool wait = true, bool visible = false)// wait the end of the scrip
	{
		if(!sh) return false;
		LOG(prog);
		Variant r = sh("Run", prog,  visible, wait);
		return r;
	}

	bool RunFile(String script_file)
	{
		if(!sh) return false;
		return Run("cscript \"" + script_file + "\"");
	}
	bool RunJsFile(String script_file)
	{
		if(!sh) return false;
		return Run("cscript //E:jscript \"" + script_file + "\"");
	}

	bool RunContent(String content, String type = "vbs")
	{
		if(!sh) return false;
		String tmp = GetTempFileName() + "." + type;
		SaveFile(tmp, content);
		bool ret = type.IsEqual("vbs") ? RunFile(tmp) : RunJsFile(tmp);
		FileDelete(tmp);
		return ret;
	}

	bool Vbs(String vbscript_content) { return RunContent(vbscript_content); }
	bool Js(String vbscript_content)  { return RunContent(vbscript_content, "js"); }
};

void TestWScriptShell()
{
	WScriptShell shell;
	
	shell.Js("WScript.CreateObject(\"WScript.Shell\").Popup(\"Ultimate++ : JavaScript test\");");
	shell.Vbs("MsgBox \"Ultimate++ : VBScript test\"");
}

