#include "OleAut.h"
#include "OleObject.h"

#include <Core/Core.h>

Value GetVARIANT(VARIANT &result);

class OleAutInitaliser
{
	public:
	OleAutInitaliser()  {OleAut::Init ();}
	~OleAutInitaliser() {OleAut::Close();}
};

static OleAutInitaliser __;

int OleAut::numOleInit = 0;

void OleAut::Init() {	// Initialize COM for this thread
	if (numOleInit == 0) {
		OleInitialize(NULL);
		CoInitialize(NULL);
	}
	numOleInit++;
}

bool OleAut::Close() {	// Uninitialize COM for this thread
	numOleInit--;
	if (numOleInit == 0)
		CoUninitialize();
	
	if (numOleInit < 0)	{	// if Close() is called before Init(), then ignore this call
		numOleInit = 0;
		return false;
	} else
		return true;
}

// Automation helper function
bool OleAut::Invoke(int autoType, VARIANT *pvResult, IDispatch *pDisp, String name) {
	return OleAut::Invoke(autoType, pvResult, pDisp, name, 0);
}

bool OleAut::Invoke(int autoType, VARIANT *pvResult, IDispatch *pDisp, String name, int cArgs, ...) {
	// Begin variable-argument list
	Array<Variant> a;
	va_list marker;
	va_start(marker, cArgs);
	for(int i = 0; i < cArgs ; i++)
		a.Add() = va_arg(marker, VARIANT);
	va_end(marker);
	return OleAut::Invoke(autoType, pvResult, pDisp, name, a);
}


bool OleAut::Invoke(int autoType, VARIANT *pvResult, IDispatch *pDisp, String name, Array<Variant>& a)
{
	if(!pDisp) {
		LOG("OleAut::Invoke() error. ObjectOle included is null, Request = " << name);
		return false;
	}
	// Variables used
	DISPPARAMS dp = { NULL, NULL, 0, 0 };
	DISPID dispidNamed = DISPID_PROPERTYPUT;
	DISPID dispID;
	HRESULT hr;
	char buf[200];
	char szName[200];
	WString wname = name.ToWString();
	WStringBuffer ptName(wname);

	// Convert down to ANSI
	WideCharToMultiByte(CP_ACP, 0, ptName, -1, szName, 256, NULL, NULL);

	// Get DISPID for name passed
	hr = pDisp->GetIDsOfNames(IID_NULL, (LPOLESTR *)&ptName, 1, LOCALE_USER_DEFAULT, &dispID);
	if(FAILED(hr)) {
		sprintf(buf, "OleAut::Invoke(\"%s\") not found for object or problem when running it", szName);
		LOG(buf);
		return false;
	}
	
	VARIANT *pArgs= NULL;
	if(a.GetCount())
	{
		pArgs = new VARIANT[a.GetCount()];		// Allocate memory for arguments
		for(int i = a.GetCount() - 1; i >= 0; i--)				// Extract arguments
		{
			pArgs[i] = a[a.GetCount() - i - 1];
			
		}
	}
	
	dp.cArgs = a.GetCount();			// Build DISPPARAMS
	dp.rgvarg = pArgs;

	if(autoType & DISPATCH_PROPERTYPUT) {		// Handle special-case for property-puts!
		dp.cNamedArgs = 1;
		dp.rgdispidNamedArgs = &dispidNamed;
	}
	
	// Make the call!
	hr = pDisp->Invoke(dispID, IID_NULL, LOCALE_SYSTEM_DEFAULT, autoType, &dp, pvResult, NULL, NULL);

	// Get output parameters results if any
	for(int i = 0; i < a.GetCount(); i++)
	{
		if(a[i].IsStringOutputParam())
		{
			a[i].SetOutputString();
		}
	}

	if(pArgs) delete [] pArgs;

	if(FAILED(hr)) {
		sprintf(buf, "OleAut::Invoke(\"%s\"=%08lx) failed w/err 0x%08lx, Name = %s", szName, dispID, hr, szName);
		LOG(buf);

		return false;
	}
	
	return true;
}


//CLSID_ShellWindows (9BA05972-F6A8-11CF-A442-00A0C90A8F39)
OleObject OleAut::CreateObject(String application, DWORD clsContext) {
	CLSID clsid;
	HRESULT hr = CLSIDFromProgID(application.ToWString(), &clsid);	// Get CLSID for our server
	if(FAILED(hr)) {
		LOG("CLSIDFromProgID() failed");
		return Null;
	}
	
	return CreateObject(clsid, clsContext);
}

OleObject OleAut::CreateObject(CLSID clsid, DWORD clsContext)
{
	IDispatch * app;
	// Start server and get IDispatch
	HRESULT hr = CoCreateInstance(clsid, NULL, clsContext, IID_IDispatch, (void **)&app);
	if(FAILED(hr)) {
		LOG("OleAut internal error. Application not registered properly");
		return Null;
	}
	
	return app;
}
