#ifndef _OleAut_OleObject_h_
#define _OleAut_OleObject_h_

#include <Core/Core.h>
using namespace Upp;

struct OleObject;
struct SafeArray;

String BSTR2String (BSTR wcs);

struct Variant
{
	Variant();
	~Variant();
	Variant(bool b);
	Variant(Nuller b);
	Variant(int b);
	Variant(long b);
	Variant(long long int b);
	Variant(float b);
	Variant(double b);
	Variant(String b);
	Variant(StringBuffer& b);
	Variant(const char* b);
	Variant(Time b);
	Variant(Value b);
	Variant(VARIANT v)						{ var = v;}
	Variant(const OleObject& o);
	Variant(OleObject&& o);

	Variant(const Variant& o)				{ var = o.var; buf_out = o.buf_out; str_out = o.str_out; }
	Variant(Variant&& o)					{ var = o.var; buf_out = o.buf_out; str_out = o.str_out; o.SetNull();}
	
	Variant& operator=(VARIANT v)			{ var = v; return *this;}
	
	Variant& operator=(OleObject& o);
	Variant& operator=(OleObject&& o);
	
	Variant& operator=(Variant&& o);
	
	operator Value () const;
	operator int () const;
	operator String () const;
	
	operator VARIANT () const				{ return var;};
	operator VARIANT* ()					{ return &var;};
	operator void* ()						{ return &var;};
	operator IDispatch* ()					{ return (var.vt == VT_DISPATCH) ? var.pdispVal : NULL;};
	operator bool()							{ return var.vt != VT_ERROR;};
	
	Variant& operator <<(bool b);
	Variant& operator <<(int b);
	Variant& operator <<(long b);
	Variant& operator <<(float b);
	Variant& operator <<(double b);
	Variant& operator <<(String b);
	Variant& operator <<(Time b);
	Variant& operator <<(Date b);
	Variant& operator <<(Value b);
	Variant& operator <<(Variant& other);
	Variant& operator <<(IDispatch*);

	void SetNull()							{ var.vt = VT_ERROR; var.scode = (long)DISP_E_PARAMNOTFOUND;}
	bool IsNull() const						{ return var.vt == VT_ERROR;}
	bool IsStringOutputParam() const		{ return var.pbstrVal == &str_out;}
	
	void SetOutputString()					{ buf_out -> Cat(BSTR2String(str_out));}
	
	friend SafeArray;
	
protected:
	VARIANT var;
	BSTR str_out;
	StringBuffer* buf_out;
	
private:
	void Init();
};

struct SafeArray
{
	Variant var;
	~SafeArray();
	SafeArray(Variant& v);
	SafeArray() { var.var.vt = VT_ERROR;}
	
	SafeArray(SafeArray& o);
	SafeArray(SafeArray&& o);
	SafeArray& operator=(SafeArray& o);
	
	SafeArray(Vector<Vector<Value> >& data);
	SafeArray& operator=(Vector<Vector<Value> >& data);
	
	operator Vector<Vector<Value> >();

	bool IsOK ()							{ return (var.var.vt & VT_ARRAY) == VT_ARRAY;}
	operator bool ()						{ return IsOK ();}
	operator Variant ()						{ return var;}
	
	int DimCount();
	long RowCount();
	long ColCount();
	bool Get(Vector<Vector<Value> >& data);
	bool Set(Vector<Vector<Value> >& data);
};

struct OleObject
{
	friend Variant;
	~OleObject()							{ Release(); }
	void Release();
	
	OleObject()								{}
	OleObject(IDispatch* pdisp)				{ var << pdisp;}
	OleObject(const OleObject& other) = delete;
	OleObject( Variant&& v)					{ var = pick(v); }
	OleObject( Nuller )						{ var.SetNull(); }
	OleObject( OleObject&& other);
	OleObject& operator=(OleObject&& other);

	operator bool()							{ return !var.IsNull();}
	operator int()							{ return var; }
	operator Value()						{ return  var.IsNull() ?  Null : var;}
	operator SafeArray ()					{ return  SafeArray(var); }
	operator String()						{ return var;}
	operator IDispatch*()					{ return var;}
	String ToString() const					{ return var;}
	
	bool Set(String path, Variant val);
	bool Set(String path, Variant p1, Variant val);
	bool Set(String path, Variant p1, Variant p2, Variant val);
	Value Get(String path) { return Method(path);};
	
	OleObject Method(String path);
	OleObject Method(String path, Array<Variant>& args);
	
	OleObject& operator=(Nuller)			{ var.SetNull(); return *this; }
	OleObject& operator[](const char* var)	{ return childs.GetAdd(String() << "__" << var << "__");}
	
	template <typename... Args>
	OleObject operator()(Args ... args)		{ return Method(args...); }
	
#define E__TYPE_VAL(I)  COMBINE(Variant p, I)
#define E__NFBody(I)	OleObject Method(const char* path, __List##I(E__TYPE_VAL));
	__Expand30(E__NFBody)
#undef E__TYPE_VAL
#undef E__NFBody

protected:
	Variant var;
private:
	OleObject Execute(String name);
	OleObject Execute(String name, Array<Variant>& args);
	

	ArrayMap<String, OleObject> childs;
};

#endif
