#include "OleAut.h"

SafeArray::~SafeArray()
{
	if ( ( var.var.vt == ( VT_ARRAY | VT_VARIANT ) )
		 && ( var.var.parray != 0 )
	   )
		SafeArrayDestroy ( var.var.parray );
}

SafeArray::SafeArray ( Variant& v )
{
	var.var = v.var;
	v.SetNull();
}

SafeArray::SafeArray ( SafeArray& o )
{
	var.var = o.var.var;
	o.var.var.vt = VT_ERROR;
}

SafeArray::SafeArray ( SafeArray && o )
{
	var.var = o.var.var;
	o.var.var.vt = VT_ERROR;
}


SafeArray& SafeArray::operator= ( SafeArray & o )
{
	var.var = o.var.var;
	o.var.var.vt = VT_ERROR;
	return *this;
}

long SafeArray::RowCount()
{
	if ( !IsOK () )
		return 0;

	long r;

	if ( SafeArrayGetUBound ( ( SAFEARRAY * ) var.var.parray, 1, &r ) != S_OK )
		return -1;

	return r;
}

int SafeArray::DimCount()
{
	if ( !IsOK () )
		return 0;

	return ( var.var.parray ) -> cDims;
}

long SafeArray::ColCount()
{
	if ( !IsOK () )
		return 0;

	long r;

	if ( SafeArrayGetUBound ( var.var.parray, 2, &r ) != S_OK )
		return -1;

	return r;
}

bool SafeArray::Get ( Vector<Vector<Value> >& data )
{
	if ( !IsOK () )
		return false;

	long rows = RowCount();

	long cols = ColCount();

	long is[2];

	VARIANT Element;

	for ( int i = 1;i <= rows;i++ )
	{
		is[0] = i;
		Vector<Value>& v = data.Add();

		for ( int j = 1; j <= cols; j++ )
		{
			is[1] = j;

			if ( SafeArrayGetElement ( var.var.parray, &is[0], &Element ) == S_OK )
			{
				Value val = Variant ( Element );
				v.Add() = val;
			}

		}
	}

	return true;
}

SafeArray::SafeArray ( Vector<Vector<Value> >& data )
{
	Set ( data );
}

SafeArray& SafeArray::operator= ( Vector<Vector<Value> >& data )
{
	Set ( data );
	return *this;
}

SafeArray::operator Vector<Vector<Value> >()
{
	Vector<Vector<Value> > data;
	Get ( data );
	return data;
}


bool SafeArray::Set ( Vector<Vector<Value> >& data )
{
	long rows = data.GetCount();
	long cols = data[0].GetCount();

	SAFEARRAYBOUND sab[2];		// 2 dimension
	sab[0].lLbound = 1;
	sab[0].cElements = rows;
	sab[1].lLbound = 1;
	sab[1].cElements = cols;

	var.var.parray = SafeArrayCreate ( VT_VARIANT, 2, sab );

	if ( var.var.parray == 0 )
		return false;

	var.var.vt = VT_ARRAY | VT_VARIANT;

	long is[2];

	Variant element;

	for ( int i = 1;i <= rows;i++ )
	{
		is[0] = i;
		Vector<Value>& v = data[i - 1];

		for ( int j = 1; j <= cols; j++ )
		{
			is[1] = j;
			element = v[j - 1];

			if ( !SafeArrayPutElement ( var.var.parray, &is[0], element ) == S_OK )
			{
				LOG ( "ERROR putting element " << element.operator String() << ", indices : i = " << i << ", j = " << j );
			}

		}
	}

	return true;
}


