#include "OleAut.h"


void Variant::Init() {
	VariantInit ( &var );
	VariantClear ( &var );
	buf_out = NULL;
}

Variant::~Variant() {

	if ( var.vt == VT_BSTR )
		SysFreeString ( var.bstrVal );
	else
		if ( var.vt == ( VT_ARRAY | VT_VARIANT ) && ( var.parray != 0 ) ) {
			SafeArrayDestroy ( var.parray );
			var.parray = NULL;
		}
}

Variant::Variant() {
	Init();
	var.vt = VT_ERROR;
	var.scode = ( long ) DISP_E_PARAMNOTFOUND;
}

Variant::Variant ( Nuller) {
	Init();
	var.vt = VT_ERROR;
	var.scode = ( long ) DISP_E_PARAMNOTFOUND;
}

Variant::Variant ( bool val ) {
	Init();
	var.vt = VT_BOOL;
	var.boolVal = val;
}

Variant::Variant ( int val ) {
	Init();
	var.vt = VT_I4;
	var.intVal = val;
}

Variant::Variant ( long val ) {
	Init();
	var.vt = VT_I4;
	var.lVal = val;
}

Variant::Variant ( long long int val ) {
	Init();
	var.vt = VT_I8;
	var.llVal = val;

}

Variant::Variant ( float val ) {
	Init();
	var.vt = VT_R4;
	var.fltVal = val;
}

Variant::Variant ( double val ) {
	Init();
	var.vt = VT_R8;
	var.dblVal = val;
}

Variant::Variant ( String val ) {
	Init();
	int size = MultiByteToWideChar ( CP_UTF8, 0, val, -1, NULL, 0 );
	WCHAR* wfileName = new WCHAR[size];
	MultiByteToWideChar ( CP_UTF8, 0, val, -1, wfileName, size );
	var.vt = VT_BSTR;
	var.bstrVal = ::SysAllocString ( wfileName );
	delete wfileName;
}

Variant::Variant(StringBuffer& val)
{
	Init();
	var.vt = VT_BSTR  | VT_BYREF;
	var.pbstrVal = &str_out;
	buf_out = &val;
}

Variant::Variant ( const char* val ) {
	Init();
	int size = MultiByteToWideChar ( CP_UTF8, 0, val, -1, NULL, 0 );
	WCHAR* wfileName = new WCHAR[size];
	MultiByteToWideChar ( CP_UTF8, 0, val, -1, wfileName, size );
	var.vt = VT_BSTR;
	var.bstrVal = ::SysAllocString ( wfileName );
	delete wfileName;
}

Variant::Variant ( Time t ) {
	Init();
	var.vt = VT_DATE;
	SYSTEMTIME stime;
	stime.wDay = t.day;
	stime.wMonth = t.month;
	stime.wYear = t.year;
	stime.wHour = t.hour;
	stime.wMinute = t.minute;
	stime.wSecond = t.second;
	SystemTimeToVariantTime ( &stime, & ( var.date ) );
}


Variant::Variant ( Value v ) {
	Init();
	if ( v.Is<bool>() ) {
		var.vt = VT_BOOL;
		var.boolVal = ( bool ) v;
	}

	else
		if ( v.Is<int>() ) {
			*this << ( int ) v;
		}

		else
			if ( v.Is<int64>() || v.Is<long>() ) {
				*this << ( long ) ( int64 ) v;
			}

			else
				if ( v.Is<float>() ) {
					*this << ( float ) ( double ) v;
				}

				else
					if ( v.Is<double>() ) {
						*this << ( double ) v;
					}

					else
						if ( v.Is<String>() ) {

							*this << ( String ) v;
						}

						else
							if ( IsDateTime ( v ) ) {
								*this << ( Upp::Time ) v;
							}

							else {
								*this << ( String ) v;
							}
}

Variant::Variant ( const OleObject& o ) {
	var = o.var;
}

Variant::Variant ( OleObject && o ) {
	var = o.var.var;
	o.var.SetNull();
}

Variant& Variant::operator=(Variant&& o)
{
	var = o.var;
	buf_out = o.buf_out;
	str_out = o.str_out;
	
	if(this != &o)
		o.SetNull();
	return *this;
}

Variant& Variant::operator= ( OleObject & o ) {
	var = o.var.var;
	o.var.SetNull();
	return *this;
}

Variant& Variant::operator= ( OleObject && o ) {
	var = o.var.var;
	o.var.SetNull();
	return *this;
}


Variant& Variant::operator << ( Variant& o ) {
	var = o.var;
	buf_out = o.buf_out;
	str_out = o.str_out;

	return *this;
}

Variant& Variant::operator << ( bool val ) {
	var.vt = VT_BOOL;
	var.boolVal = val;
	return *this;
}

Variant& Variant::operator << ( int val ) {
	var.vt = VT_I4;
	var.intVal = val;
	return *this;
}

Variant& Variant::operator << ( long val ) {
	var.vt = VT_I4;
	var.lVal = val;
	return *this;
}

Variant& Variant::operator << ( float val ) {
	var.vt = VT_R4;
	var.fltVal = val;
	return *this;
}

Variant& Variant::operator << ( double val ) {
	var.vt = VT_R8;
	var.dblVal = val;
	return *this;
}

Variant& Variant::operator << ( String val ) {
	int size = MultiByteToWideChar ( CP_UTF8, 0, val, -1, NULL, 0 );
	WCHAR* wfileName = new WCHAR[size];
	MultiByteToWideChar ( CP_UTF8, 0, val, -1, wfileName, size );
	var.vt = VT_BSTR;
	var.bstrVal = ::SysAllocString ( wfileName );
	delete wfileName;
	return *this;
}

Variant& Variant::operator << ( Time t ) {
	var.vt = VT_DATE;
	SYSTEMTIME stime;
	stime.wDay = t.day;
	stime.wMonth = t.month;
	stime.wYear = t.year;
	stime.wHour = t.hour;
	stime.wMinute = t.minute;
	stime.wSecond = t.second;
	SystemTimeToVariantTime ( &stime, & ( var.date ) );
	return *this;
}

Variant& Variant::operator << ( Date t ) {
	var.vt = VT_DATE;
	SYSTEMTIME stime;
	stime.wDay = t.day;
	stime.wMonth = t.month;
	stime.wYear = t.year;
	stime.wHour = 0;
	stime.wMinute = 0;
	stime.wSecond = 0;
	SystemTimeToVariantTime ( &stime, & ( var.date ) );
	return *this;
}

Variant& Variant::operator <<(IDispatch* pdisp)
{
	var.vt = VT_DISPATCH;
	var.pdispVal = pdisp;
	return *this;
}


Variant& Variant::operator << ( Value v ) {
	if ( v.Is<bool>() ) {
		var.vt = VT_BOOL;
		var.boolVal = ( bool ) v;
	}

	else
		if ( v.Is<int>() ) {
			*this << ( int ) v;
		}

		else
			if ( v.Is<int64>() || v.Is<long>() ) {
				*this << ( long ) ( int64 ) v;
			}

			else
				if ( v.Is<float>() ) {
					*this << ( float ) ( double ) v;
				}

				else
					if ( v.Is<double>() ) {
						*this << ( double ) v;
					}

					else
						if ( v.Is<String>() ) {

							*this << ( String ) v;
						}

						else
							if ( IsDateTime ( v ) ) {
								*this << ( Upp::Time ) v;
							}

							else {
								*this << ( String ) v;
							}

	return *this;
}


String BSTR2String ( BSTR wcs ) {
	int len = SysStringLen ( wcs );

	if ( len <= 0 )
		return Null;

	return WString ( wcs, len ).ToString();
}

Variant::operator int () const {
	return IsNull() ?  Null : var.intVal;
}


Variant::operator Value () const {
	Value ret;

	switch ( var.vt ) {

		case VT_EMPTY:

		case VT_NULL:

		case VT_BLOB:
			break;

		case VT_BOOL:
			ret = var.boolVal;// ? "true" : "false";
			break;

		case VT_I2:
			ret = var.iVal;
			break;

		case VT_I4:
			ret = ( int64 ) var.lVal;
			break;

		case VT_R4:
			ret = AsString ( var.fltVal );
			break;

		case VT_R8:
			ret = AsString ( var.dblVal );
			break;

		case VT_BSTR:
			ret = BSTR2String ( var.bstrVal );
			break;

		case VT_LPSTR:
			//ret = var.pszVal;
			ret = "Unknown VT_LPSTR";

		case VT_DATE:
			SYSTEMTIME stime;
			VariantTimeToSystemTime ( var.date, &stime );
			{
				Time t;
				t.day    = ( Upp::byte ) stime.wDay;
				t.month  = ( Upp::byte ) stime.wMonth;
				t.year   = stime.wYear;
				t.hour   = ( Upp::byte ) stime.wHour;
				t.minute = ( Upp::byte ) stime.wMinute;
				t.second = ( Upp::byte ) stime.wSecond;
				ret = t;
			}

			break;

		case VT_ARRAY:

			break;

		case VT_CF:
			ret = "(Clipboard format)";
			break;
	}

	return ret;
}

Variant::operator String () const {
	return AsString ( this->operator Value() );
}

