#include <CtrlLib/CtrlLib.h>

using namespace Upp;

void WriteClipboardHTML(const String& html);
WString HtmlToText(String s, bool showLinks);

void TestWriteClipboardHTML()
{
	String html =
	"<p style = \"margin:0px 0px 2px 0px;text-indent:0px;text-align:left;color:#be4e45;font-family:serif;font-size:24pt;font-weight:bold;font-style:normal;text-decoration:none;\">\
	Ultimate++ is a C++ cross-platform rapid application development framework</p>";
	
	WriteClipboardHTML( html);
	// then do paste in a word processor, libreoffice writer or winword.
}

void TestHtmlToText()
{
	HttpRequest r("https://www.ultimatepp.org/index.html");
	LOG(HtmlToText(r.Execute(), false));
}

GUI_APP_MAIN
{
	TestHtmlToText();
	TestWriteClipboardHTML();
}

void WriteClipboardHTML(const String& html)
{
	String data;
	
	data
		<< "Version:0.9\n"
		<< "StartHTML:#000001#\n"
		<< "EndHTML:#000002#\n"
		<< "StartFragment:#000003#\n"
		<< "EndFragment:#000004#\n"
		<< "StartSelection:#000003#\n"
		<< "EndSelection:#000004#\n"
		<< "<HTML>\n"
		<< "<!--StartFragment -->"
		<< html
	    << "<!--EndFragment -->\n"
		<< "</HTML>\n"
    ;
    
    data.Replace("#000001#", Sprintf("%08u", data.Find("<HTML>") + 6));
    data.Replace("#000002#", Sprintf("%08u", data.Find("</HTML>")));
    data.Replace("#000003#", Sprintf("%08u", data.Find("<!--StartFragment -->") + 21));
    data.Replace("#000004#", Sprintf("%08u", data.Find("<!--EndFragment -->")));
    
    WriteClipboard("HTML Format", data);
    AppendClipboardUnicodeText(HtmlToText(html, false));
}

WString HtmlToText(String s, bool showLinks = false)
{
	WString ret;
	CParser p(s);
	while(!p.IsEof())
	{
		if(p.Char2('<', '/') || p.Char2('<', '!'))
		{
			while(!p.IsEof() && !p.Char('>')) p.GetChar();
		}
		else
		if(p.Char('<'))
		{
			if(p.IsId())
			{
				String id = ToLower(p.ReadId());
				if(id == "br" || id == "p") ret << "\n";
				else
				if(id == "span" || id == "div") ret << " ";
				else
				if(id == "pr" ) ret << "\n\n";
				else
				if(id == "table" ) ret << "\n\n";
				else
				if(id == "tr" ) ret << "\n";
				else
				if(id == "td" ) ret << "\t";
				else
				if(id == "script" || id == "style")
				{
					while(!p.IsEof() && !p.Char('>')) p.GetChar();
					while(!p.IsEof() && !p.Char3('<', '/', 's') && !p.Char3('<', '/', 'S')) p.GetChar();
					while(!p.IsEof() && !p.Char('>')) p.GetChar();
				}
				else
				if(id == "a" || id == "A")
				{
					String h;
					if( p.IsId()) h =  ToLower(p.ReadId());
					while(h != "href" && !p.IsEof() && p.IsId() && !p.IsChar('>')) h = ToLower(p.ReadId());
					if(h == "href")
					{
						p.Char('=');
						WString link;
						while(!p.IsEof() && !p.Char('>')) link.Cat(p.GetChar());
						
						WString link_text;
						
						while(!p.IsEof() && !p.Char3('<', '/', 'a') && !p.Char3('<', '/', 'A'))
						{
							if(p.Char('<') && ( p.Char('I') || p.Char('i')) /* <img> */ )
							{
								while(!p.IsEof() && !p.Char('>')) p.GetChar();
								link_text << "{Image}";
							}
							else
								link_text.Cat(p.GetChar());
						}
						
						ret << "[" << link_text << "])";
						
						if(showLinks)
							ret << "{ => " << link << "}";
						
					}
					
				}
				while(!p.IsEof() && !p.Char('>')) p.GetChar();
			}
			
		}
		else
		if(p.Char('&'))
		{
			if(p.IsId())
			{
				String id = ToLower(p.ReadId());
				if(p.Char(';'))
				{
					ret << (WString)decode(id,
							"nbsp",	" ",
							"lt",	"<",
							"gt",	">",
							"amp",	"&",
							"quot",	"\"",
							" [&" + id + ";] "
							);
							
				}
			}
			else
			if(p.Char('#'))
			{
				if(p.IsNumber())
				{
					int n = p.ReadInt();
					if(p.Char(';'))
					{
						ret << n;
					}
				}
			}
		}
		else
		{
			ret << p.GetChar();
		}
	}
	
	return ret;
}


