#include "testqtf.h"

TestQtf::TestQtf() {
	//annotation_popup.Background(White);
	annotation_popup.SetFrame(BlackFrame());
	annotation_popup.Margins(Zx(6));
	annotation_popup.NoSb();
	
	Add(btn.SizePos());
	
	btn << THISBACK(Popup);
}

void TestQtf::Popup() {
	String qtf = "[2@(255.251.247) [C [@(254.95.146)* class] sys`.core`.lang`.[@(188.234.100) Vector]]&[C -|[@(254.95.146)* def] SortDesc(low[@(249.167.40) :] Int, high[@(249.167.40) :] Int);]&&Sorts the content of the array in descending order, from beginning to end or between two input indices.&&{{1:2F(255.251.247)G(255.251.247)@(51.51.51) [C low]||the start index||[C high]||the end index}}]";

	
	annotation_popup.SetQTF(qtf);
	
	Rect r = btn.GetScreenRect();
	
	int w = Zx(600) + Zx(6) * 2 + Zx(1) * 2;
	int h = annotation_popup.GetHeight(w) + Zy(6) * 2 + Zy(1) * 2;
	int y = r.top + h + StdFont(10).GetCy() / 2;
	if(y < GetWorkArea().top)
		y = r.bottom + StdFont(10).GetCy();
	annotation_popup.SetRect(r.left + Zy(6) * 2 + Zy(1) * 2, y, w, h);

	if (annotation_popup.IsOpen())
		return;
	annotation_popup.Ctrl::PopUp(this, false, false, true);
}

GUI_APP_MAIN
{
	TestQtf().Run();
}
