#include "ControlSkins.h"

ControlSkins::ControlSkins() {
	CtrlLayout(*this, "Window title");
	
	AddFrame(mainMenu);
	AddFrame(TopSeparatorFrame());
	
	mainMenu.Set(THISBACK(OnMainMenu));
	
	btnOk.Ok();
	btnCancel.Cancel();
	btnExit.Exit();
	btnDisabled.Enable(false);
	btnEdge.EdgeStyle();
	btnNaked.NakedStyle();
	
	btnFlat.Label("Flat");
	btnPushed.Label("Pushed");
	btnPushed.Check(true);
	
	btnFlatD.Label("Flat");
	btnFlatD.Enable(false);
	btnPushedD.Label("Pushed");
	btnPushedD.Check(true);
	btnPushedD.Enable(false);
	
	optCheck = 1;
	optTri = Null;
	
	optCheckD = 1;
	optTriD = Null;
	
	optCheckD.Enable(false);
	optUncheckD.Enable(false);
	optTriD.Enable(false);
	
	optCheckR = 1;
	optTriR = Null;
	
	optCheckDR = 1;
	optTriDR = Null;
	
	optCheckDR.Enable(false);
	optUncheckDR.Enable(false);
	optTriDR.Enable(false);
	
	swcCheck = 0;
	
	swcCheckD = 0;
	
	swcCheckD.Enable(false);
	swcUncheckD.Enable(false);
	
	swcCheckR = 0;
	
	swcCheckDR = 0;
	
	swcCheckDR.Enable(false);
	swcUncheckDR.Enable(false);
}

void ControlSkins::OnMainMenu(Bar& bar) {
	bar.Add("File", THISBACK(OnFileMenu));
	bar.Add("Edit", Callback());
	bar.Add("View", Callback());
	bar.Add("Help", Callback());
}

void ControlSkins::OnFileMenu(Bar& bar) {
	bar.Add("New...", CtrlImg::new_doc, Callback());
	bar.Add("Open...", CtrlImg::open, Callback());
	bar.Add("Save", CtrlImg::save, Callback());
	bar.Add("Save as..", CtrlImg::save_as, Callback());
	
	bar.Separator();
	
	bar.Add("Check me", Callback()).Check(true);
	bar.Add("Try it", Callback()).Check(false);
	bar.Add("Me too", Callback()).Check(true).Enable(false);
	bar.Add("Ditto", Callback()).Check(false).Enable(false);
	
	bar.Separator();
	
	bar.Add("Radio menu?", Callback()).Radio(true);
	bar.Add("Radio?", Callback()).Radio(false);
	bar.Add("Radio!", Callback()).Radio(true).Enable(false);
	bar.Add("Cool", Callback()).Radio(false).Enable(false);
	
	bar.Separator();
	
	bar.Add("Recent", THISBACK(OnRecent));
	
	bar.Separator();
	
	bar.Add("Exit", THISBACK(Close));
}

void ControlSkins::OnRecent(Bar& bar) {
	bar.Add("Item 1", Callback());
	bar.Add("Item 2", Callback());
	bar.Add("Item 3", Callback());
	bar.Add("Item 4", Callback());
}

void ControlSkins::OnToolBar(Bar& bar) {
	bar.Add(Image(), Callback()).RightLabel("Default skin");
	bar.Add("", Image(), Callback()).RightLabel("Light skin");
	bar.Add("", Image(), Callback()).RightLabel("Dark skin");
	bar.Add(Image(), Callback()).RightLabel("Custom skin");
	
	bar.Separator();
	
	bar.Add(CtrlImg::cut(), Callback());
	bar.Add(CtrlImg::copy(), Callback());
	bar.Add(CtrlImg::paste(), Callback());
	
	bar.Separator();
	
	bar.Add(CtrlImg::undo(), Callback()).RightLabel("Undo");
	bar.Add(CtrlImg::redo(), Callback()).RightLabel("Redo");
}

GUI_APP_MAIN {
	ControlSkins().Run();
}
