#ifndef _LayoutTest_LayerTree_h_
#define _LayoutTest_LayerTree_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class LayerTree : public TreeCtrl
{
public:
	typedef LayerTree CLASSNAME;
	
	LayerTree() : drag_id(-1), TreeCtrl() 
		{ }
	
	virtual void ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags);
	//virtual Image CursorImage(Point p, dword keyflags);
	virtual void LeftUp(Point p, dword keyflags) ;
	virtual void RightUp(Point p, dword keyflags) 		{StopDrag(); TreeCtrl::RightUp(p, keyflags);}
	virtual void MouseMove(Point p, dword keyflags) 	{if (drag_id >= 0) SetDragPos(GetScreenRect().TopLeft() + p);}
protected:
	struct DragPop : public TopWindow
	{
		Image img;
		DragPop() {Transparent(true);}
		virtual void Paint(Draw &draw) {draw.DrawImage(img.GetSize(), img);}
	};
	DragPop drag_wnd;
	int drag_id;
	
	void StartDrag(int id);
	void StopDrag();
	void SetDragPos(Point p);
	void MoveChildren(int src, int dest);
	void Drop(int id);
	int GetNodeIDAt(Point p);
};

#endif
